/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.AssembleParser;
import translator.FragmentMatch;
import translator.KeyPreferences;
import translator.LanguageCodes;
import translator.MainView;
import translator.NaturalOrderComparator;
import translator.Project;
import translator.TranslateEvent;
import translator.WorkflowView;
import translator.XMLHelper;
import translator.hunspell.HunSpellChecker;
import translator.server.RemoteMemory;
import translator.text.SegmentEditorKit;
import translator.text.TargetStyleConstants;
import translator.tmx.Memory;
import translator.tmx.MemoryView;
import translator.ui.GridPanel;
import translator.ui.UITools;

public class TMXNewEntryEditor
extends JDialog
implements ActionListener {
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JTextPane sourceArea;
    private JTextPane targetArea;
    private JTextField noteField;
    private JComboBox subjectBox;
    private JComboBox userBox;
    private JTextField contextField;
    private JTextField refField;
    private JTextField userField1;
    private JTextField userField2;
    private JTextField userField3;
    private MainView parent;
    private String source = "";
    private String target = "";

    public TMXNewEntryEditor(MainView ui) {
        super(ui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW FRAGMENT"), true);
        String pn;
        String s;
        JLabel label;
        JLabel label1;
        String s2;
        Object[] o;
        String title;
        String name;
        boolean ro;
        Memory m;
        Project p;
        List rmem;
        FontIcon ficon;
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.setResizable(true);
        this.parent = ui;
        LinkedHashMap projectAttrs = null;
        Project pro = this.parent.getProjectView().getProject();
        if (pro != null) {
            projectAttrs = pro.getSegmentAttributes();
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.setOpaque(false);
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(new EmptyBorder(new Insets(5, 0, 5, 5)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new CompoundBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOCAL MEMORIES")), new EmptyBorder(new Insets(3, 3, 3, 3))));
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new GridLayout(0, 2, 4, 4));
        jPanel4.add((Component)jPanel2, "North");
        MemoryView mview = this.parent.getMemoryView();
        List li = mview.getLocalMemories();
        int n = 0;
        if (li != null) {
            ArrayList glist = new ArrayList(li);
            Collections.sort(li, new NaturalOrderComparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    Memory g1 = (Memory)o1;
                    Memory g2 = (Memory)o2;
                    String s1 = g1.getName();
                    String s2 = g2.getName();
                    return s1.compareToIgnoreCase(s2);
                }
            });
            for (Object object : glist) {
                String name2;
                Memory m2 = (Memory)object;
                boolean ro2 = m2.isReadOnly();
                boolean terms = m2.getTermsMode();
                if (ro2 || !terms || (name2 = m2.getName()) == null) continue;
                ++n;
                JCheckBox item = name2.length() > 20 ? new JCheckBox(name2.substring(0, 17) + "...") : new JCheckBox(name2);
                Font font = item.getFont().deriveFont(1);
                item.setFont(font);
                item.setOpaque(false);
                item.putClientProperty("memory", m2);
                if (m2.isBlocked()) {
                    item.setSelected(false);
                } else {
                    item.setSelected(true);
                }
                item.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        JCheckBox item = (JCheckBox)e.getItem();
                        Memory m = (Memory)item.getClientProperty("memory");
                        if (e.getStateChange() == 1) {
                            m.setBlocked(false);
                        } else {
                            m.setBlocked(true);
                        }
                    }
                });
                jPanel2.add(item);
                JButton jButton = new JButton();
                jButton.setToolTipText(name2);
                jButton.putClientProperty("memory", m2);
                ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COFFEE, (int)jButton.getFont().getSize(), (Color)jButton.getForeground());
                jButton.setIcon((Icon)ficon);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JButton button = (JButton)e.getSource();
                        Memory g = (Memory)button.getClientProperty("memory");
                        TMXNewEntryEditor.this.addNewTerm(g);
                        TMXNewEntryEditor.this.closeDialog();
                    }
                });
                if (n == 1) {
                    jButton.setMnemonic(49);
                    jButton.setText(Integer.toString(n));
                } else if (n == 2) {
                    jButton.setMnemonic(50);
                    jButton.setText(Integer.toString(n));
                } else if (n == 3) {
                    jButton.setMnemonic(51);
                    jButton.setText(Integer.toString(n));
                } else if (n == 4) {
                    jButton.setMnemonic(52);
                    jButton.setText(Integer.toString(n));
                }
                jPanel2.add(jButton);
            }
        }
        if ((rmem = mview.getRemoteMemories()) != null && rmem.size() > 0) {
            JPanel jPanel6 = new JPanel();
            jPanel6.setBorder(new CompoundBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SERVER MEMORIES")), new EmptyBorder(new Insets(3, 3, 3, 3))));
            jPanel6.setOpaque(false);
            jPanel6.setLayout(new GridLayout(0, 2, 4, 4));
            jPanel4.add((Component)jPanel6, "South");
            for (Object object : rmem) {
                String name3;
                RemoteMemory rm = (RemoteMemory)object;
                if (rm.readonly || (name3 = rm.getName()) == null) continue;
                ++n;
                JCheckBox item = name3.length() > 20 ? new JCheckBox(name3.substring(0, 17) + "...") : new JCheckBox(name3);
                item.setSelected(true);
                Font font = item.getFont().deriveFont(1);
                item.setFont(font);
                item.setOpaque(false);
                jPanel6.add(item);
                JButton jButton = new JButton();
                jButton.setToolTipText(name3);
                jButton.putClientProperty("memory", rm);
                FontIcon ficon2 = FontIcon.of((Ikon)MaterialDesign.MDI_COFFEE, (int)jButton.getFont().getSize(), (Color)jButton.getForeground());
                jButton.setIcon((Icon)ficon2);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JButton button = (JButton)e.getSource();
                        Memory g = (Memory)button.getClientProperty("memory");
                        TMXNewEntryEditor.this.addNewTerm(g);
                        TMXNewEntryEditor.this.closeDialog();
                    }
                });
                if (n == 1) {
                    jButton.setMnemonic(49);
                    jButton.setText(Integer.toString(n));
                } else if (n == 2) {
                    jButton.setMnemonic(50);
                    jButton.setText(Integer.toString(n));
                } else if (n == 3) {
                    jButton.setMnemonic(51);
                    jButton.setText(Integer.toString(n));
                } else if (n == 4) {
                    jButton.setMnemonic(52);
                    jButton.setText(Integer.toString(n));
                }
                jPanel6.add(jButton);
            }
        }
        if ((p = this.parent.getProjectView().getProject()) != null && (m = p.getTMXMemory()) != null && !(ro = m.isReadOnly()) && (name = p.getName()) != null) {
            JCheckBox item = new JCheckBox(name);
            item.setOpaque(false);
            Font font = item.getFont().deriveFont(1);
            item.setFont(font);
            item.putClientProperty("memory", m);
            if (m.isBlocked()) {
                item.setSelected(false);
            } else {
                item.setSelected(true);
            }
            item.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JCheckBox item = (JCheckBox)e.getItem();
                    Memory m = (Memory)item.getClientProperty("memory");
                    if (e.getStateChange() == 1) {
                        m.setBlocked(false);
                    } else {
                        m.setBlocked(true);
                    }
                }
            });
            jPanel2.add(item);
        }
        this.jPanel1 = new JPanel();
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridLayout(2, 1, 10, 3));
        this.jPanel1.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.jPanel3 = new JPanel();
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new SpringLayout());
        this.sourceArea = new JTextPane();
        this.sourceArea.setEditorKit(new SegmentEditorKit());
        this.sourceArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TMXNewEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        if (AppPreferences.linuxGTK) {
            this.sourceArea.setCaretColor(this.sourceArea.getForeground());
        } else if (AppPreferences.background != 0) {
            Color background = new Color(AppPreferences.background);
            Color foreground = new Color(AppPreferences.foreground);
            this.sourceArea.setCaretColor(foreground);
            this.sourceArea.setBackground(background);
            this.sourceArea.setForeground(foreground);
        }
        this.sourceArea.setFont(new Font(AppPreferences.ntfontname, AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
        this.sourceArea.setMargin(new Insets(3, 3, 3, 3));
        JScrollPane jScrollPane1 = new JScrollPane(this.sourceArea);
        if (AppPreferences.RTLSource) {
            jScrollPane1.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        if ((title = AppPreferences.fileSLang).length() == 0) {
            title = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SOURCE LANGUAGE");
        } else {
            int b;
            String s3 = LanguageCodes.getName(title);
            if (s3 != null && (b = (title = s3).indexOf(40)) != -1) {
                title = title.substring(0, b - 1);
            }
        }
        jScrollPane1.setBorder(new CompoundBorder(new TitledBorder(title), new EmptyBorder(new Insets(3, 3, 3, 3))));
        jScrollPane1.setPreferredSize(new Dimension(600, 150));
        this.targetArea = new JTextPane();
        this.targetArea.setEditorKit(new SegmentEditorKit());
        this.targetArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    TMXNewEntryEditor.this.parent.getTargetView().showToolsPopup(evt.getComponent(), evt.getX(), evt.getY(), false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    TMXNewEntryEditor.this.parent.getTargetView().showToolsPopup(evt.getComponent(), evt.getX(), evt.getY(), false);
                }
            }
        });
        HunSpellChecker checker = this.parent.getSpellChecker();
        if (checker != null) {
            checker.setTextPane(this.targetArea, true);
        }
        this.targetArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TMXNewEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        if (AppPreferences.linuxGTK) {
            this.targetArea.setCaretColor(this.targetArea.getForeground());
        } else if (AppPreferences.background != 0) {
            Color background = new Color(AppPreferences.background);
            Color foreground = new Color(AppPreferences.foreground);
            this.targetArea.setCaretColor(foreground);
            this.targetArea.setBackground(background);
            this.targetArea.setForeground(foreground);
        }
        this.targetArea.setFont(new Font(AppPreferences.ntfontname, AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
        this.targetArea.setMargin(new Insets(3, 3, 3, 3));
        JScrollPane jScrollPane2 = new JScrollPane(this.targetArea);
        if (AppPreferences.RTLTarget) {
            jScrollPane2.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        if ((title = AppPreferences.fileTLang).length() == 0) {
            title = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET LANGUAGE");
        } else {
            int b;
            String s4 = LanguageCodes.getName(title);
            if (s4 != null && (b = (title = s4).indexOf(40)) != -1) {
                title = title.substring(0, b - 1);
            }
        }
        jScrollPane2.setBorder(new CompoundBorder(new TitledBorder(title), new EmptyBorder(new Insets(3, 3, 3, 3))));
        jScrollPane2.setPreferredSize(new Dimension(600, 150));
        StyledDocument sdoc = this.sourceArea.getStyledDocument();
        StyledDocument tdoc = this.targetArea.getStyledDocument();
        tdoc.addStyle("", null);
        Style style = tdoc.addStyle("Normal", null);
        StyleConstants.setForeground(style, this.targetArea.getForeground());
        style = tdoc.addStyle("SpaceNB", null);
        StyleConstants.setBackground(style, Color.LIGHT_GRAY);
        style = tdoc.addStyle("Spellcheck", null);
        TargetStyleConstants.setColorUnderline(style, true);
        if (AppPreferences.invisibles) {
            sdoc.putProperty("invisibles", true);
            tdoc.putProperty("invisibles", true);
        } else {
            sdoc.putProperty("invisibles", null);
            tdoc.putProperty("invisibles", null);
        }
        int rows = 0;
        if (AppPreferences.dbContextCol.length() > 0) {
            this.contextField = new JTextField();
            this.contextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    TMXNewEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
                }
            });
            this.contextField.setMargin(new Insets(0, 2, 0, 0));
            this.contextField.setPreferredSize(new Dimension(350, 30));
            JLabel label12 = new JLabel(AppPreferences.dbContextCol + ":");
            label12.setHorizontalAlignment(4);
            label12.setFont(label12.getFont().deriveFont(1));
            this.jPanel3.add(label12);
            this.jPanel3.add(this.contextField);
            ++rows;
        }
        if (AppPreferences.dbFieldCol.length() > 0) {
            List subjects = Project.getSubjectList();
            if (subjects != null && subjects.size() > 0) {
                o = subjects.toArray();
                this.subjectBox = new JComboBox<Object>(o);
                this.subjectBox.setEditable(true);
                this.subjectBox.insertItemAt("", 0);
                this.subjectBox.setSelectedIndex(0);
                this.subjectBox.setPreferredSize(new Dimension(350, 30));
            } else {
                this.subjectBox = new JComboBox();
                this.subjectBox.setPreferredSize(new Dimension(350, 30));
                this.subjectBox.setEditable(true);
            }
            if (AppPreferences.dbField != null && AppPreferences.dbField.length() > 0) {
                this.subjectBox.setSelectedItem(AppPreferences.dbField);
            } else if (projectAttrs != null && (s2 = (String)projectAttrs.get(AppPreferences.dbFieldCol)) != null) {
                this.subjectBox.setSelectedItem(s2);
            }
            label1 = new JLabel(AppPreferences.dbFieldCol + ":");
            label1.setHorizontalAlignment(4);
            label1.setFont(label1.getFont().deriveFont(1));
            this.jPanel3.add(label1);
            this.jPanel3.add(this.subjectBox);
            ++rows;
        }
        if (AppPreferences.dbClientCol.length() > 0) {
            List clients = Project.getClientList();
            if (clients != null && clients.size() > 0) {
                o = clients.toArray();
                this.userBox = new JComboBox<Object>(o);
                this.userBox.setEditable(true);
                this.userBox.insertItemAt("", 0);
                this.userBox.setSelectedIndex(0);
                this.userBox.setPreferredSize(new Dimension(350, 30));
            } else {
                this.userBox = new JComboBox();
                this.userBox.setPreferredSize(new Dimension(350, 30));
                this.userBox.setEditable(true);
            }
            if (AppPreferences.dbUser != null && AppPreferences.dbUser.length() > 0) {
                this.userBox.setSelectedItem(AppPreferences.dbUser);
            } else if (projectAttrs != null && (s2 = (String)projectAttrs.get(AppPreferences.dbClientCol)) != null) {
                this.userBox.setSelectedItem(s2);
            }
            label1 = new JLabel(AppPreferences.dbClientCol + ":");
            label1.setHorizontalAlignment(4);
            label1.setFont(label1.getFont().deriveFont(1));
            this.jPanel3.add(label1);
            this.jPanel3.add(this.userBox);
            ++rows;
        }
        if (AppPreferences.dbNotesCol.length() > 0) {
            this.noteField = new JTextField();
            this.noteField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    TMXNewEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
                }
            });
            this.noteField.setMargin(new Insets(0, 2, 0, 0));
            this.noteField.setPreferredSize(new Dimension(350, 30));
            label = new JLabel(AppPreferences.dbNotesCol + ":");
            label.setHorizontalAlignment(4);
            label.setFont(label.getFont().deriveFont(1));
            this.jPanel3.add(label);
            this.jPanel3.add(this.noteField);
            ++rows;
        }
        if (AppPreferences.dbURLCol.length() > 0) {
            this.refField = new JTextField();
            this.refField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    TMXNewEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
                }
            });
            this.refField.setMargin(new Insets(0, 2, 0, 0));
            this.refField.setPreferredSize(new Dimension(350, 30));
            JButton file = new JButton(AppPreferences.dbURLCol + "...");
            file.setFont(file.getFont().deriveFont(1));
            file.setPreferredSize(new Dimension(150, 30));
            file.setMaximumSize(new Dimension(150, 30));
            file.setOpaque(false);
            file.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET REFERENCE"));
            FontIcon ficon3 = FontIcon.of((Ikon)MaterialDesign.MDI_FOLDER, (int)file.getFont().getSize(), (Color)file.getForeground());
            file.setIcon((Icon)ficon3);
            file.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File f;
                    final String loc = !AppPreferences.dbURLRef.startsWith("http") ? ((f = new File(AppPreferences.dbURLRef)).exists() ? f.getPath() : System.getProperty("user.home")) : System.getProperty("user.home");
                    if (AppPreferences.isJavaFXReady()) {
                        Platform.runLater((Runnable)new Runnable(){
                            final /* synthetic */ 12 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                try {
                                    File file;
                                    FileChooser fileChooser = new FileChooser();
                                    fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FILE"));
                                    File f = new File(loc);
                                    if (f.isDirectory() && f.canRead()) {
                                        fileChooser.setInitialDirectory(f);
                                    }
                                    if ((file = fileChooser.showOpenDialog(null)) != null) {
                                        SwingUtilities.invokeLater(new Runnable(){
                                            final /* synthetic */ 1 this$2;
                                            {
                                                this.this$2 = this$2;
                                            }

                                            @Override
                                            public void run() {
                                                String path = file.getPath();
                                                this.this$2.this$1.TMXNewEntryEditor.this.refField.setText(path);
                                                AppPreferences.dbURLRef = file.getParent();
                                            }
                                        });
                                    }
                                }
                                catch (Exception ex) {
                                    final String s = ex.getMessage();
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 1 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        @Override
                                        public void run() {
                                            JOptionPane.showMessageDialog(this.this$2.this$1.TMXNewEntryEditor.this, s);
                                        }
                                    });
                                }
                            }
                        });
                    } else {
                        JFileChooser jch = new JFileChooser(loc);
                        jch.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FILE"));
                        jch.setFileSelectionMode(2);
                        if (0 == jch.showOpenDialog(TMXNewEntryEditor.this)) {
                            File file = jch.getSelectedFile();
                            String path = file.getPath();
                            TMXNewEntryEditor.this.refField.setText(path);
                        }
                    }
                }
            });
            this.jPanel3.add(file);
            this.jPanel3.add(this.refField);
            ++rows;
        }
        if (AppPreferences.dbUser1Col.length() > 0) {
            this.userField1 = new JTextField();
            if (AppPreferences.dbUser1Col.equalsIgnoreCase("Project")) {
                if (Project.userProjectName != null) {
                    this.userField1.setText(Project.userProjectName);
                } else if (projectAttrs != null && projectAttrs.get("Project") != null) {
                    s = (String)projectAttrs.get("Project");
                    if (s != null) {
                        this.userField1.setText(s);
                    }
                } else if (p != null && (pn = p.getProjectFolderName()) != null) {
                    this.userField1.setText(pn);
                }
            } else if (projectAttrs != null && (s = (String)projectAttrs.get(AppPreferences.dbUser1Col)) != null) {
                this.userField1.setText(s);
            }
            this.userField1.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    TMXNewEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
                }
            });
            this.userField1.setMargin(new Insets(0, 2, 0, 0));
            this.userField1.setPreferredSize(new Dimension(350, 30));
            label = new JLabel(AppPreferences.dbUser1Col + ":");
            label.setHorizontalAlignment(4);
            label.setFont(label.getFont().deriveFont(1));
            this.jPanel3.add(label);
            this.jPanel3.add(this.userField1);
            ++rows;
        }
        if (AppPreferences.dbUser2Col.length() > 0) {
            this.userField2 = new JTextField();
            if (AppPreferences.dbUser2Col.equalsIgnoreCase("Project")) {
                if (Project.userProjectName != null) {
                    this.userField2.setText(Project.userProjectName);
                } else if (projectAttrs != null && projectAttrs.get("Project") != null) {
                    s = (String)projectAttrs.get("Project");
                    if (s != null) {
                        this.userField2.setText(s);
                    }
                } else if (p != null && (pn = p.getProjectFolderName()) != null) {
                    this.userField2.setText(pn);
                }
            } else if (projectAttrs != null && (s = (String)projectAttrs.get(AppPreferences.dbUser2Col)) != null) {
                this.userField2.setText(s);
            }
            this.userField2.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    TMXNewEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
                }
            });
            this.userField2.setMargin(new Insets(0, 2, 0, 0));
            this.userField2.setPreferredSize(new Dimension(350, 30));
            label = new JLabel(AppPreferences.dbUser2Col + ":");
            label.setHorizontalAlignment(4);
            label.setFont(label.getFont().deriveFont(1));
            this.jPanel3.add(label);
            this.jPanel3.add(this.userField2);
            ++rows;
        }
        if (AppPreferences.dbUser3Col.length() > 0) {
            this.userField3 = new JTextField();
            if (AppPreferences.dbUser3Col.equalsIgnoreCase("Project")) {
                if (Project.userProjectName != null) {
                    this.userField3.setText(Project.userProjectName);
                } else if (projectAttrs != null && projectAttrs.get("Project") != null) {
                    s = (String)projectAttrs.get("Project");
                    if (s != null) {
                        this.userField3.setText(s);
                    }
                } else if (p != null && (pn = p.getProjectFolderName()) != null) {
                    this.userField3.setText(pn);
                }
            } else if (projectAttrs != null && (s = (String)projectAttrs.get(AppPreferences.dbUser3Col)) != null) {
                this.userField3.setText(s);
            }
            this.userField3.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    TMXNewEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
                }
            });
            this.userField3.setMargin(new Insets(0, 2, 0, 0));
            this.userField3.setPreferredSize(new Dimension(350, 30));
            label = new JLabel(AppPreferences.dbUser3Col + ":");
            label.setHorizontalAlignment(4);
            label.setFont(label.getFont().deriveFont(1));
            this.jPanel3.add(label);
            this.jPanel3.add(this.userField3);
            ++rows;
        }
        this.jButton1 = new JButton();
        this.jButton1.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jButton1.addActionListener(this);
        this.jButton2 = new JButton();
        this.jButton2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jButton2.addActionListener(this);
        this.jButton3 = new JButton();
        this.jButton3.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW FRAGMENT"));
        this.jButton3.addActionListener(this);
        this.jButton4 = new JButton();
        this.jButton4.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARIES"));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_PENCIL, (int)this.jButton4.getFont().getSize(), (Color)this.jButton4.getForeground());
        this.jButton4.setIcon((Icon)ficon);
        this.jButton4.addActionListener(this);
        jPanel2.add(new JLabel());
        jPanel2.add(this.jButton4);
        this.jPanel1.add(jScrollPane1);
        this.jPanel1.add(jScrollPane2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        jPanel5.setLayout(new GridLayout(0, 3, 10, 0));
        jPanel5.setOpaque(false);
        jPanel5.add(this.jButton3);
        jPanel5.add(this.jButton1);
        jPanel5.add(this.jButton2);
        GridPanel centralPanel = new GridPanel();
        centralPanel.setLayout(new BorderLayout());
        centralPanel.add((Component)this.jPanel1, "Center");
        if (rows > 0) {
            UITools.makeCompactGrid(this.jPanel3, rows, 2, 6, 6, 6, 6);
            centralPanel.add((Component)this.jPanel3, "South");
        }
        GridPanel con = new GridPanel();
        con.setLayout(new BorderLayout());
        this.setContentPane(con);
        con.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        con.add((Component)centralPanel, "Center");
        con.add((Component)jPanel5, "South");
        if (n > 5) {
            con.add((Component)jPanel4, "West");
        } else {
            con.add((Component)jPanel4, "North");
        }
        con.getActionMap().put("TITLECASE", new AbstractAction("TITLECASE"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTextComponent tc = TMXNewEntryEditor.this.parent.getFocusedTextComponent();
                TMXNewEntryEditor.this.parent.getResourceView().cycleCase(tc, 2);
            }
        });
        con.getActionMap().put("CYCLECASE", new AbstractAction("CYCLECASE"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTextComponent tc = TMXNewEntryEditor.this.parent.getFocusedTextComponent();
                TMXNewEntryEditor.this.parent.getResourceView().cycleCase(tc, 1);
            }
        });
        con.getActionMap().put("CYCLEFOCUS", new AbstractAction("CYCLEFOCUS"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!TMXNewEntryEditor.this.targetArea.isFocusOwner()) {
                    TMXNewEntryEditor.this.targetArea.requestFocusInWindow();
                } else {
                    TMXNewEntryEditor.this.sourceArea.requestFocusInWindow();
                }
            }
        });
        con.getActionMap().put("REQUESTFOCUS", new AbstractAction("REQUESTFOCUS"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMXNewEntryEditor.this.targetArea.requestFocusInWindow();
            }
        });
        con.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMXNewEntryEditor.this.jButton1.doClick();
            }
        });
        con.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMXNewEntryEditor.this.jButton2.doClick();
            }
        });
        KeyStroke ks = KeyPreferences.getKeyStroke("k38");
        con.getInputMap(1).put(ks, "TITLECASE");
        ks = KeyPreferences.getKeyStroke("k39");
        con.getInputMap(1).put(ks, "CYCLECASE");
        ks = KeyPreferences.getKeyStroke("k80");
        con.getInputMap(1).put(ks, "CYCLEFOCUS");
        ks = KeyPreferences.getKeyStroke("k89");
        con.getInputMap(1).put(ks, "REQUESTFOCUS");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(10, 128), "ENTER");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TMXNewEntryEditor.this.closeDialog();
            }
        });
        if (AppPreferences.cycleFocusTabKey) {
            this.parent.setTabAsFocusTraversalKey(this.sourceArea, this.targetArea, AppPreferences.cycleFocusTabKey);
        }
        this.pack();
        String t = this.sourceArea.getText();
        if (t != null && t.length() > 0) {
            this.targetArea.requestFocusInWindow();
        } else {
            this.sourceArea.requestFocusInWindow();
        }
    }

    public void setKey(String key) {
        key = XMLHelper.parseTags(key);
        this.sourceArea.setText(key);
        this.source = key;
    }

    public void setEntry(String entry) {
        entry = XMLHelper.parseTags(entry);
        this.targetArea.setText(entry);
        this.target = entry;
    }

    void closeDialog() {
        HunSpellChecker checker = this.parent.getSpellChecker();
        if (checker != null) {
            checker.setTextPane(this.parent.getTargetPane(), false);
        }
        AppPreferences.newEntryDialogWidth = this.getWidth();
        AppPreferences.newEntryDialogHeight = this.getHeight();
        AppPreferences.newEntryDialogPosX = this.getLocation().x;
        AppPreferences.newEntryDialogPosY = this.getLocation().y;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton1) {
            this.addNewTerm(null);
            this.closeDialog();
        } else if (e.getSource() == this.jButton2) {
            this.closeDialog();
        } else if (e.getSource() == this.jButton3) {
            this.addNewTerm(null);
            int mod = e.getModifiers();
            if ((mod & 2) == 2) {
                return;
            }
            this.sourceArea.setText("");
            this.targetArea.setText("");
            this.sourceArea.requestFocusInWindow();
        } else if (e.getSource() == this.jButton4) {
            String t;
            WorkflowView wv = this.parent.getWorkflowView();
            String s = this.sourceArea.getSelectedText();
            if (s == null && (s = this.sourceArea.getText()).length() == 0) {
                s = this.source;
            }
            if ((t = this.targetArea.getSelectedText()) == null && (t = this.targetArea.getText()).length() == 0) {
                t = this.target;
            }
            this.closeDialog();
            wv.addEntryToGlossary(s, t);
        }
    }

    private void addNewTerm(Memory memory) {
        Document sdoc = this.sourceArea.getDocument();
        Document tdoc = this.targetArea.getDocument();
        try {
            String key = sdoc.getText(0, sdoc.getLength());
            String value = tdoc.getText(0, tdoc.getLength());
            String key1 = this.sourceArea.getSelectedText();
            String value1 = this.targetArea.getSelectedText();
            if (key.length() > 0) {
                String ff;
                Object o;
                String nf;
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(4);
                String note = null;
                if (this.noteField != null && (nf = this.noteField.getText().trim()).length() > 0) {
                    note = nf;
                }
                if (this.subjectBox != null) {
                    o = this.subjectBox.getSelectedItem();
                    if (o != null) {
                        ff = o.toString().trim();
                        if (ff.length() > 0) {
                            map.put(AppPreferences.dbFieldCol, ff);
                        }
                    } else {
                        ff = "";
                    }
                    AppPreferences.dbField = ff;
                }
                if (this.userBox != null) {
                    o = this.userBox.getSelectedItem();
                    if (o != null) {
                        ff = o.toString().trim();
                        if (ff.length() > 0) {
                            map.put(AppPreferences.dbClientCol, ff);
                        }
                    } else {
                        ff = "";
                    }
                    AppPreferences.dbUser = ff;
                }
                if (this.refField != null) {
                    String rf = this.refField.getText().trim();
                    if (rf.length() > 0) {
                        map.put(AppPreferences.dbURLCol, rf);
                    }
                    AppPreferences.dbURLRef = rf;
                }
                if (this.contextField != null && (ff = this.contextField.getText().trim()).length() > 0) {
                    map.put(AppPreferences.dbContextCol, ff);
                }
                if (this.userField1 != null && (ff = this.userField1.getText().trim()).length() > 0) {
                    map.put(AppPreferences.dbUser1Col, ff);
                    if (AppPreferences.dbUser1Col.equalsIgnoreCase("Project")) {
                        Project.userProjectName = ff;
                    }
                }
                if (this.userField2 != null && (ff = this.userField2.getText().trim()).length() > 0) {
                    map.put(AppPreferences.dbUser2Col, ff);
                    if (AppPreferences.dbUser2Col.equalsIgnoreCase("Project")) {
                        Project.userProjectName = ff;
                    }
                }
                if (this.userField3 != null && (ff = this.userField3.getText().trim()).length() > 0) {
                    map.put(AppPreferences.dbUser3Col, ff);
                    if (AppPreferences.dbUser3Col.equalsIgnoreCase("Project")) {
                        Project.userProjectName = ff;
                    }
                }
                if (memory == null) {
                    TranslateEvent event;
                    this.parent.getMemoryView().addFragmentToMemory(key, value, note, map);
                    if (key1 != null && value1 != null) {
                        this.parent.getMemoryView().addFragmentToMemory(key1, value1, note, map);
                    }
                    if ((event = this.parent.getMemoryView().getTranslateEvent()) != null) {
                        event.addNewFragmentsToMatchBoard();
                    }
                } else {
                    if (AssembleParser.isSegmentPattern(key)) {
                        if (key.length() > 0 && key.charAt(0) != '?' && key.charAt(0) != '|') {
                            key = "?" + key;
                        }
                        if (value.length() > 0 && value.charAt(0) != '?' && value.charAt(0) != '|') {
                            value = "?" + value;
                        }
                    }
                    boolean terms = memory.getTermsMode();
                    boolean ro = memory.isReadOnly();
                    if (!ro && terms) {
                        memory.updateMemory(key, value, note, map);
                        TranslateEvent event = this.parent.getMemoryView().getTranslateEvent();
                        FragmentMatch fmatch = new FragmentMatch(key, key, value, "New", false, 1, 1, 0, memory.getPriority(), 0);
                        if (event != null) {
                            event.addFragmentMatch(fmatch);
                        }
                        if (key1 != null && value1 != null) {
                            memory.updateMemory(key1, value1, note, map);
                            fmatch = new FragmentMatch(key1, key1, value1, "New", false, 1, 1, 0, memory.getPriority(), 0);
                            if (event != null) {
                                event.addFragmentMatch(fmatch);
                            }
                        }
                        if (event != null) {
                            event.addNewFragmentsToMatchBoard();
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void grabSelection(String selection) {
        String sel = this.targetArea.getSelectedText();
        Document doc = this.targetArea.getDocument();
        int pos = this.targetArea.getCaretPosition();
        try {
            if (sel != null) {
                doc.remove(pos -= sel.length(), sel.length());
            }
            doc.insertString(pos, selection.trim() + AppPreferences.fca, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.targetArea.isFocusOwner()) {
            this.targetArea.requestFocusInWindow();
        }
    }
}

