/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import translator.AppPreferences;
import translator.XMLElement;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXBody;
import translator.tmx.TMXHandler;
import translator.tmx.TMXHeader;
import translator.tmx.TMXReadOnlyUnit;
import translator.tmx.TMXReadOnlyUnitMap;

public class TMXReadOnlyHandler
extends TMXHandler {
    private TMXReadOnlyUnitMap map;
    private StringBuffer source;
    private StringBuffer target;
    private String propType;
    String attrLang = "xml:lang";
    String attrProp = "type";
    boolean sourceSeg = false;
    boolean targetSeg = false;
    TMXReadOnlyUnit tu;
    TMXHeader header;

    public TMXReadOnlyHandler(Memory memory) {
        super(memory);
        memory.setReadOnlyLoaded(true);
        this.source = new StringBuffer();
        this.target = new StringBuffer();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        if (qName.equals("seg")) {
            if (this.sourceSeg) {
                this.source = new StringBuffer();
            } else if (this.targetSeg) {
                this.target = new StringBuffer();
            }
            this.contents.reset();
            return;
        }
        if (qName.equals("tuv")) {
            String value = attr.getValue(this.attrLang);
            if (value == null) {
                value = attr.getValue("lang");
            }
            if (value != null) {
                int i = value.indexOf(45);
                if (i != -1) {
                    value = value.substring(0, i);
                }
                if (value.equalsIgnoreCase(this.slang)) {
                    this.sourceSeg = true;
                } else if (value.equalsIgnoreCase(this.tlang)) {
                    this.targetSeg = true;
                }
            }
        } else if (qName.equals("tu")) {
            this.tu = new TMXReadOnlyUnit();
        } else if (qName.equals("tmx")) {
            this.tmx = this.memory.getTMX();
            if (this.tmx == null) {
                this.tmx = new TMX();
            }
        } else if (qName.equals("header")) {
            TMXHeader xml = this.header = new TMXHeader();
            for (int i = 0; i < attr.getLength(); ++i) {
                xml.setAttribute(attr.getQName(i), attr.getValue(i));
            }
            this.tmx.setHeader(xml);
        } else if (qName.equals("body")) {
            TMXBody tmb;
            if (this.header != null && !this.memory.isNewlyAdded()) {
                List properties = this.header.getChildren("prop");
                for (XMLElement next : properties) {
                    Object o;
                    String type = next.getAttribute("type");
                    if (type == null || (o = next.getContent(0)) == null) continue;
                    String value = o.toString();
                    if (type.equals("x-processing_tags")) {
                        this.memory.setWithTagPositions(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-segments")) {
                        this.memory.setSegmentsMode(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-terms")) {
                        this.memory.setTermsMode(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-read_only")) {
                        this.memory.setReadOnly(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-pretranslate_only")) {
                        this.memory.setPretranslateOnly(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-terms_consistency_check")) {
                        this.memory.setTermsCheck(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-priority")) {
                        this.memory.setPriority(Integer.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-integration")) {
                        this.memory.setWorkflowMode(Integer.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-case_match")) {
                        this.memory.setCaseMatch(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-greedy_exact_match")) {
                        this.memory.setGreedyMatching(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-duplicates")) {
                        this.memory.setDuplicatesMode(Integer.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-stop_autoassembling")) {
                        this.memory.stopAutoassembling(Boolean.valueOf(value));
                        continue;
                    }
                    if (!type.equals("x-prefix_matching")) continue;
                    boolean pm = Boolean.valueOf(value);
                    this.memory.setPrefixMatch(pm);
                    if (!pm) continue;
                    this.memory.setPrefixAccuracy(AppPreferences.memPrefixAccuracy);
                }
            }
            if ((tmb = this.tmx.getBody()) == null) {
                int cap = 20000;
                if (this.tmx.capacity != -1) {
                    cap = this.tmx.capacity;
                }
                tmb = new TMXBody(1, 1);
                this.map = new TMXReadOnlyUnitMap(cap);
                tmb.setTUMap(this.map);
                this.tmx.setTUMap(this.map);
                this.tmx.setBody(tmb);
                this.memory.setTMX(this.tmx);
            } else {
                this.map = (TMXReadOnlyUnitMap)this.tmx.getTUMap();
            }
        } else if (qName.equals("prop")) {
            this.propType = attr.getValue(this.attrProp);
        }
        if (this.sourceSeg && this.source != null && this.contents.size() > 0) {
            this.source.append(this.contents);
        } else if (this.targetSeg && this.target != null && this.contents.size() > 0) {
            this.target.append(this.contents);
        }
        this.contents.reset();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.sourceSeg && this.source != null && this.contents.size() > 0) {
            this.source.append(this.contents);
        } else if (this.targetSeg && this.target != null && this.contents.size() > 0) {
            this.target.append(this.contents);
        }
        if (qName.equals("seg")) {
            if (this.sourceSeg && this.source != null) {
                this.tu.setSegment(this.slang, this.source.toString());
            } else if (this.targetSeg && this.target != null) {
                this.tu.setSegment(this.tlang, this.target.toString());
            }
            this.source = null;
            this.target = null;
            this.sourceSeg = false;
            this.targetSeg = false;
        } else if (qName.equals("tu")) {
            if (this.tu != null && this.tu.getSegment(this.slang) != null && this.tu.getSegment(this.tlang) != null) {
                this.map.load(this.tu);
            }
            this.tu = null;
        } else if (qName.equals("prop")) {
            if (this.propType != null && this.tu != null) {
                this.tu.addProperty(this.propType, this.contents.toString());
            }
            this.propType = null;
        }
        this.contents.reset();
    }
}

