/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.io.Serializable;
import translator.InternalString;
import translator.TranslationUnit;

public class TMXReadOnlyUnitInternal
implements TranslationUnit,
Serializable {
    private TranslationUnit link;
    TranslationUnit previousTU;
    TranslationUnit nextTU;
    private String sourceLang;
    private String targetLang;
    InternalString sourceSegment;
    InternalString targetSegment;
    private Object[] properties = null;
    private String perfectMatch;
    public boolean state;
    private int propIndex = 0;

    @Override
    public boolean getState() {
        return this.state;
    }

    @Override
    public TranslationUnit getPreviousTranslationUnit() {
        return this.previousTU;
    }

    @Override
    public TranslationUnit getNextTranslationUnit() {
        return this.nextTU;
    }

    @Override
    public String getSegment(String lang) {
        int i = lang.indexOf(45);
        if (i != -1) {
            lang = lang.substring(0, i);
        }
        if (lang.toLowerCase().equals(this.sourceLang)) {
            return this.sourceSegment.toString();
        }
        if (lang.toLowerCase().equals(this.targetLang)) {
            return this.targetSegment.toString();
        }
        return "";
    }

    public void setSegment(String lang, String seg) {
        lang = lang.toLowerCase();
        if (this.sourceLang == null) {
            this.sourceLang = lang.intern();
            this.sourceSegment = new InternalString(seg, false);
        } else if (this.targetLang == null) {
            this.targetLang = lang.intern();
            this.targetSegment = new InternalString(seg, false);
        } else if (lang.equals(this.sourceLang)) {
            this.sourceSegment = new InternalString(seg, false);
        } else if (lang.equals(this.targetLang)) {
            this.targetSegment = new InternalString(seg, false);
        }
    }

    @Override
    public void setLink(TranslationUnit tu) {
        this.link = tu;
    }

    @Override
    public TranslationUnit getLink() {
        return this.link;
    }

    @Override
    public boolean hasLink() {
        return this.link != null;
    }

    @Override
    public boolean hasParent() {
        return false;
    }

    @Override
    public String getPerfectMatch() {
        return this.perfectMatch;
    }

    @Override
    public void setPerfectMatch(String s) {
        this.perfectMatch = s;
    }

    public void addProperty(String type, String content) {
        if (this.propIndex < 4) {
            if (this.properties == null) {
                this.properties = new Object[4];
            }
            String[] p = new String[]{type.intern(), content.intern()};
            this.properties[this.propIndex] = p;
            ++this.propIndex;
        }
    }

    @Override
    public Object[] getProperties() {
        return this.properties;
    }

    @Override
    public String getXMLFormat() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n<tu>");
        sb.append("\n<tuv ");
        sb.append("xm:lang");
        sb.append('=');
        sb.append('\"');
        sb.append(this.sourceLang);
        sb.append('\"');
        sb.append('>');
        sb.append("\n<seg>");
        sb.append(this.sourceSegment);
        sb.append("</seg>");
        sb.append("\n</tuv>");
        sb.append("\n<tuv ");
        sb.append("xml:lang");
        sb.append('=');
        sb.append('\"');
        sb.append(this.targetLang);
        sb.append('\"');
        sb.append('>');
        sb.append("\n<seg>");
        sb.append(this.targetSegment);
        sb.append("</seg>");
        sb.append("\n</tuv>");
        if (this.properties != null) {
            for (int i = 0; i < this.properties.length; ++i) {
                String[] p = (String[])this.properties[i];
                sb.append("\n<prop ");
                sb.append("type");
                sb.append('=');
                sb.append('\"');
                sb.append(p[0]);
                sb.append('\"');
                sb.append('>');
                sb.append(p[1]);
                sb.append("</prop>");
            }
        }
        sb.append("\n</tu>");
        return sb.toString();
    }
}

