/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import translator.AppPreferences;
import translator.FragmentMatch;
import translator.TranslationUnit;
import translator.XMLHelper;
import translator.tmx.TMXUnit;
import translator.ui.Colors;
import translator.ui.HTMLFormat;

public class TMXResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap tumap;
    private TranslationUnit perfectTU;
    private String[] names;
    private String[] sources;
    private String[] targets;
    private List fragmentMatches;
    private int[][] tuids;
    private int index = 0;
    private int tuindex = 0;
    private int ntu = 0;
    private int limit = 200;
    private int hitNumber = -2;
    public String sLang;
    public String tLang;
    public static String startHeader = "<b><a HREF=";
    public static String endHeader = "</a></b>";
    public static String endRow = "</TD></TR>";
    public static String endHTML = "</TABLE></BODY></HTML>";
    public static String sRow = "<TR>";
    public static String eRow = "</TR>";
    public static String sCol = "<TD BORDER=0 NOWRAP VALIGN=CENTER ALIGN=LEFT>";
    public static String eCol = "</TD>";
    private static String hitSpanStart1 = "<span style=\"color:#FF6600\">";
    private static String hitSpanEnd = "</span>";
    private static String hitSpanStart2 = "<span style=\"color:#FF00FF\">";
    private static String hitName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("HITS") + "&nbsp;";
    private static String fuzzyName = "FM";
    private static String exactName = "EM";
    private static String exactPrefixName = "EPM";
    private static String contextName = "CM";
    private static String fragmentName = "<span style=\"color:#FF00FF\">" + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FRAGMENT") + "</span>";
    private static String virtualName = "<span style=\"color:#FF00FF\">" + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("VIRTUAL FRAGMENT") + "</span>";
    private Object[] bfuzzies;
    private String currentSourceFragment = null;
    private String currentSourceSegment;
    private String currentTargetSegment;
    private int priority;
    private int contextPercent = 0;
    private int perfectMatch = 0;
    public boolean targetDifferent;
    public boolean sourceDifferent;
    private String memoryName;
    private Set otu = new HashSet(10);

    public TMXResult(String source, String target, int priority, String memoryName) {
        this.sLang = source;
        this.tLang = target;
        this.priority = priority;
        this.memoryName = memoryName;
        this.initArrays();
    }

    public void setCurrentSourceSegment(String s) {
        this.currentSourceSegment = s;
    }

    public void setCurrentTargetSegment(String t) {
        this.currentTargetSegment = t;
    }

    public String getCurrentTargetSegment() {
        return this.currentTargetSegment;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getContextPercent() {
        return this.contextPercent;
    }

    private void initArrays() {
        this.tumap = new HashMap();
        this.names = new String[this.limit];
        this.sources = new String[this.limit];
        this.targets = new String[this.limit];
        this.tuids = new int[this.limit][10];
        this.index = 0;
        this.tuindex = 1;
        this.ntu = 0;
        this.bfuzzies = new Object[AppPreferences.fuzzies];
        this.fragmentMatches = new ArrayList();
    }

    public int[][] getTUIds() {
        return this.tuids;
    }

    public Object[] getBestFuzzy(int i) {
        Object o;
        if (this.bfuzzies != null && (o = this.bfuzzies[i]) != null) {
            Object[] ob = (Object[])o;
            return ob;
        }
        return null;
    }

    public boolean isFragmentInBestFuzzyMatchSource(String s) {
        if (this.bfuzzies != null) {
            for (int i = 0; i < this.bfuzzies.length; ++i) {
                Object[] arr;
                String fuzzyKey;
                Object object = this.bfuzzies[i];
                if (object == null || !(fuzzyKey = (String)(arr = (Object[])object)[1]).contains(s)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFragmentInBestFuzzyMatchTarget(String s) {
        if (this.bfuzzies != null) {
            for (int i = 0; i < this.bfuzzies.length; ++i) {
                Object[] arr;
                String fuzzyEntry;
                Object object = this.bfuzzies[i];
                if (object == null || !(fuzzyEntry = (String)(arr = (Object[])object)[2]).contains(s)) continue;
                return true;
            }
        }
        return false;
    }

    public Object[] getBestFuzzies() {
        return this.bfuzzies;
    }

    public void setBestFuzzies(LinkedHashMap fuzzies) {
        if (fuzzies != null) {
            Set set = fuzzies.keySet();
            block0: for (String fuzzyEntry : set) {
                Object[] o = (Object[])fuzzies.get(fuzzyEntry);
                Integer oi = (Integer)o[0];
                int pro = oi;
                for (int i = 0; i < this.bfuzzies.length; ++i) {
                    Object object = this.bfuzzies[i];
                    if (object != null) {
                        Object[] arr = (Object[])object;
                        int bpro = (Integer)arr[0];
                        if (pro <= bpro) continue;
                        for (int j = i; j < this.bfuzzies.length; ++j) {
                            object = this.bfuzzies[j];
                            this.bfuzzies[j] = o;
                            if (object == null) continue block0;
                            o = (Object[])object;
                        }
                        continue block0;
                    }
                    this.bfuzzies[i] = o;
                    continue block0;
                }
            }
            for (int i = 0; i < this.bfuzzies.length; ++i) {
                String fuzzyKeyHTML;
                String nf;
                Object object = this.bfuzzies[i];
                if (object == null) continue;
                Object[] arr = (Object[])object;
                TranslationUnit tu = (TranslationUnit)arr[5];
                if (tu != null) {
                    TMXUnit tux;
                    String date;
                    arr[9] = this.tuindex;
                    this.tuids[this.index][0] = this.tuindex;
                    this.tumap.put(this.tuindex, tu);
                    ++this.tuindex;
                    String source = (String)arr[1];
                    String target = (String)arr[2];
                    this.sources[this.index] = source;
                    this.targets[this.index] = target;
                    this.names[this.index] = fuzzyName;
                    String meta = "";
                    Object[] props = tu.getProperties();
                    if (props != null) {
                        for (int j = 0; j < props.length; ++j) {
                            String cont;
                            String[] parr;
                            String type;
                            Object prop = props[j];
                            if (prop == null || !(type = (parr = (String[])prop)[0]).equals("Project") && !type.equals("Client") || (cont = parr[1]) == null) continue;
                            meta = meta + " | " + cont;
                        }
                    }
                    if (tu instanceof TMXUnit && (date = (tux = (TMXUnit)tu).getAttribute("creationdate")) != null) {
                        char b;
                        StringBuilder builder = new StringBuilder();
                        char[] darr = date.toCharArray();
                        int k = 0;
                        for (int j = 0; j < darr.length && (b = darr[j]) != 'T'; ++j) {
                            if (k == 4 || k == 6) {
                                builder.append('-');
                                builder.append(b);
                            } else {
                                builder.append(b);
                            }
                            ++k;
                        }
                        date = builder.toString();
                        meta = meta + " | " + date;
                    }
                    if (meta.length() > 0) {
                        arr[12] = meta;
                    }
                    ++this.index;
                }
                Integer oi = (Integer)arr[0];
                int pro = oi;
                String proc = Integer.toString(pro);
                String fuzzyKey = (String)arr[1];
                String fuzzyEntry = (String)arr[2];
                int[][] matrix = (int[][])arr[3];
                boolean pref = (Boolean)arr[4];
                String currentSegment = (String)arr[6];
                int[][] matrix2 = (int[][])arr[7];
                HashMap hmap = new HashMap();
                String track = null;
                StringBuilder sb = new StringBuilder();
                int sint = 0;
                for (int j = 0; j < matrix2.length; ++j) {
                    int k;
                    if (matrix2[j] == null) continue;
                    int[] pos = matrix2[j];
                    int len = pos.length;
                    nf = currentSegment.substring(sint, j);
                    if (nf.length() > 0) {
                        if (nf.trim().length() == 0) {
                            sb.append(nf);
                        } else {
                            if (nf.charAt(0) == ' ') {
                                sb.append(' ');
                                nf = nf.substring(1);
                            }
                            if (nf.charAt(nf.length() - 1) == ' ') {
                                nf = nf.substring(0, nf.length() - 1);
                                track = "<span style=color:" + Colors.trackingAddColorHTML + ">" + nf + "</span>";
                                sb.append(track);
                                sb.append(' ');
                            } else {
                                track = "<span style=color:" + Colors.trackingAddColorHTML + ">" + nf + "</span>";
                                sb.append(track);
                            }
                        }
                    }
                    if ((k = pos[0]) == 1) {
                        track = "<span style=color:" + Colors.trackingAddColorHTML + ">" + currentSegment.substring(j, j + len) + "</span>";
                        sb.append(track);
                    } else {
                        String s = currentSegment.substring(j, j + len);
                        sb.append(s);
                        if (track != null) {
                            String ls = s.toLowerCase();
                            ArrayDeque<String> queue = (ArrayDeque<String>)hmap.get(ls);
                            if (queue != null) {
                                queue.add(track);
                            } else {
                                queue = new ArrayDeque<String>();
                                queue.add(track);
                                hmap.put(ls, queue);
                            }
                            track = null;
                        }
                    }
                    sint = j + len;
                    if (len <= 0) continue;
                    j += len - 1;
                }
                if (sint < currentSegment.length()) {
                    String nf2 = currentSegment.substring(sint);
                    if (nf2.charAt(0) == ' ') {
                        sb.append(' ');
                        nf2 = nf2.substring(1);
                    }
                    track = "<span style=color:" + Colors.trackingAddColorHTML + ">" + nf2 + "</span>";
                    sb.append(track);
                    ArrayDeque<String> queue = new ArrayDeque<String>(1);
                    queue.add(track);
                    hmap.put(".", queue);
                }
                String currentSegmentHTML = sb.toString();
                sb = new StringBuilder();
                sint = 0;
                if (!pref) {
                    int spaceSpans = 0;
                    for (int j = 0; j < matrix.length; ++j) {
                        if (matrix[j] == null) continue;
                        int[] pos = matrix[j];
                        int len = pos.length;
                        int k = pos[0];
                        boolean spanSpace = false;
                        String nf3 = fuzzyKey.substring(sint, j);
                        if (nf3.length() > 0) {
                            if (nf3.trim().length() == 0) {
                                if (k == 1 && spaceSpans > 0) {
                                    spanSpace = true;
                                } else {
                                    sb.append(nf3);
                                }
                            } else {
                                if (nf3.charAt(0) == ' ') {
                                    sb.append(' ');
                                    nf3 = nf3.substring(1);
                                }
                                if (nf3.charAt(nf3.length() - 1) == ' ') {
                                    nf3 = nf3.substring(0, nf3.length() - 1);
                                    sb.append("<s><span style=color:" + Colors.trackingDeleteColorHTML + ">");
                                    sb.append(nf3);
                                    sb.append("</span></s>");
                                    sb.append(' ');
                                } else {
                                    sb.append("<s><span style=color:" + Colors.trackingDeleteColorHTML + ">");
                                    sb.append(nf3);
                                    sb.append("</span></s>");
                                }
                            }
                        }
                        if (k == 1) {
                            ++spaceSpans;
                            sb.append("<s><span style=color:" + Colors.trackingDeleteColorHTML + ">");
                            if (spanSpace) {
                                sb.append(nf3);
                            }
                            sb.append(fuzzyKey.substring(j, j + len));
                            sb.append("</span></s>");
                        } else {
                            String add;
                            spaceSpans = 0;
                            String s = fuzzyKey.substring(j, j + len);
                            String ls = s.toLowerCase();
                            ArrayDeque ad = (ArrayDeque)hmap.get(ls);
                            if (ad != null && (add = (String)ad.poll()) != null) {
                                int l = sb.length();
                                if (l > 0) {
                                    char c = sb.charAt(l - 1);
                                    if (c == ' ') {
                                        int del;
                                        if (l > 5 && (del = sb.indexOf("</s>", l - 5)) != -1) {
                                            sb.deleteCharAt(l - 1);
                                        }
                                        sb.append(add);
                                    } else {
                                        sb.append(add);
                                    }
                                } else {
                                    sb.append(add);
                                }
                                if (!AppPreferences.noWordSeparatorSourceLanguage) {
                                    sb.append(" ");
                                }
                            }
                            sb.append(s);
                        }
                        sint = j + len;
                        if (len <= 0) continue;
                        j += len - 1;
                    }
                    if (sint < fuzzyKey.length()) {
                        String add;
                        nf = fuzzyKey.substring(sint);
                        if (nf.charAt(0) == ' ') {
                            sb.append(' ');
                            nf = nf.substring(1);
                        }
                        sb.append("<s><span style=color:" + Colors.trackingDeleteColorHTML + ">");
                        sb.append(nf);
                        sb.append("</span></s>");
                        ArrayDeque ad = (ArrayDeque)hmap.get(".");
                        if (ad != null && (add = (String)ad.poll()) != null) {
                            sb.append(add);
                        }
                    } else {
                        String add;
                        ArrayDeque ad = (ArrayDeque)hmap.get(".");
                        if (ad != null && (add = (String)ad.poll()) != null) {
                            if (!AppPreferences.noWordSeparatorSourceLanguage) {
                                sb.append(" ");
                            }
                            sb.append(add);
                        }
                    }
                    fuzzyKeyHTML = sb.toString();
                } else {
                    fuzzyKeyHTML = fuzzyKey;
                }
                arr[10] = fuzzyKeyHTML;
                arr[11] = currentSegmentHTML;
            }
        }
    }

    public boolean setExactMatch(TranslationUnit tu, boolean segmentMatch, String[] contexts, boolean matchCase, String currentFragment, boolean prefixMatch) {
        boolean hasContext = false;
        do {
            Object[] props;
            String d;
            String source = tu.getSegment(this.sLang);
            String target = tu.getSegment(this.tLang);
            if (this.index >= this.limit) continue;
            if (!segmentMatch && this.isDuplicateMatch(source, target)) {
                return false;
            }
            int contextMatch = 0;
            boolean targetDiffers = false;
            boolean sourceDiffers = false;
            String meta = "";
            if (segmentMatch) {
                String s1;
                TranslationUnit unit;
                String c1;
                TMXUnit tux;
                String date;
                Object[] dprops = tu.getProperties();
                if (dprops != null) {
                    for (int j = 0; j < dprops.length; ++j) {
                        String cont;
                        String[] parr;
                        String type;
                        Object prop = dprops[j];
                        if (prop == null || !(type = (parr = (String[])prop)[0]).equals("Project") && !type.equals("Client") || (cont = parr[1]) == null) continue;
                        meta = meta + " | " + cont;
                    }
                }
                if (tu instanceof TMXUnit && (date = (tux = (TMXUnit)tu).getAttribute("creationdate")) != null) {
                    char b;
                    StringBuilder builder = new StringBuilder();
                    char[] darr = date.toCharArray();
                    int k = 0;
                    for (int j = 0; j < darr.length && (b = darr[j]) != 'T'; ++j) {
                        if (k == 4 || k == 6) {
                            builder.append('-');
                            builder.append(b);
                        } else {
                            builder.append(b);
                        }
                        ++k;
                    }
                    date = builder.toString();
                    meta = meta + " | " + date;
                }
                ++this.perfectMatch;
                this.contextPercent = 100;
                if (this.currentSourceSegment != null && !this.currentSourceSegment.equals(source)) {
                    sourceDiffers = true;
                }
                tu.setPerfectMatch(target);
                if (this.perfectTU == null || this.sourceDifferent) {
                    this.perfectTU = tu;
                    this.sourceDifferent = sourceDiffers;
                }
                if ((c1 = contexts[0]) != null && c1.length() > 0 && (unit = tu.getPreviousTranslationUnit()) != null && c1.equals(s1 = unit.getSegment(this.sLang))) {
                    ++contextMatch;
                    if (this.contextPercent == 100) {
                        this.perfectTU = tu;
                        this.contextPercent = 101;
                        this.sourceDifferent = sourceDiffers;
                    }
                    if (contexts[1] == null) {
                        ++contextMatch;
                        this.contextPercent = 102;
                        this.perfectTU = tu;
                        this.sourceDifferent = sourceDiffers;
                    }
                }
                if ((c1 = contexts[1]) != null && c1.length() > 0 && (unit = tu.getNextTranslationUnit()) != null && c1.equals(s1 = unit.getSegment(this.sLang))) {
                    ++contextMatch;
                    if (contexts[0] == null) {
                        ++contextMatch;
                        this.contextPercent = 102;
                        this.perfectTU = tu;
                        this.sourceDifferent = sourceDiffers;
                    } else if (this.contextPercent == 100) {
                        this.perfectTU = tu;
                        this.contextPercent = 101;
                        this.sourceDifferent = sourceDiffers;
                    } else if (this.contextPercent == 101 && contextMatch == 2) {
                        this.perfectTU = tu;
                        this.contextPercent = 102;
                        this.sourceDifferent = sourceDiffers;
                    }
                }
                if (!sourceDiffers && this.contextPercent == 100 && this.sourceDifferent) {
                    this.perfectTU = tu;
                    this.sourceDifferent = sourceDiffers;
                }
                if (this.currentTargetSegment != null) {
                    if (matchCase) {
                        if (!this.currentTargetSegment.equals(target)) {
                            targetDiffers = true;
                        }
                    } else if (!this.currentTargetSegment.equalsIgnoreCase(target)) {
                        targetDiffers = true;
                    }
                }
            }
            int context = 0;
            if (contextMatch == 0) {
                if (segmentMatch) {
                    StringBuilder sb = new StringBuilder();
                    if (!prefixMatch) {
                        sb.append("100% ").append(exactName);
                    } else {
                        sb.append("100% ").append(exactPrefixName);
                    }
                    if (sourceDiffers) {
                        d = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DIFFERENT SOURCE");
                        sb.append(" <sup style=\"font-size:12px\" color=red>").append(d).append("</sup>");
                    }
                    if (targetDiffers) {
                        d = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DIFFERENT TRANSLATION");
                        sb.append(" <sub style=\"font-size:12px\" color=red>").append(d).append("</sub>");
                        this.targetDifferent = true;
                    }
                    this.names[this.index] = sb.toString() + meta;
                } else {
                    this.names[this.index] = fragmentName + meta;
                }
            } else if (contextMatch == 1) {
                StringBuilder sb = new StringBuilder();
                sb.append("101% ").append(contextName);
                if (sourceDiffers) {
                    d = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DIFFERENT SOURCE");
                    sb.append(" <sup style=\"font-size:12px\" color=red>").append(d).append("</sup>");
                }
                if (targetDiffers) {
                    d = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DIFFERENT TRANSLATION");
                    sb.append(" <sub style=\"font-size:12px\" color=red>").append(d).append("</sub>");
                    this.targetDifferent = true;
                }
                this.names[this.index] = sb.toString() + meta;
                context = 1;
            } else if (contextMatch == 2) {
                StringBuilder sb = new StringBuilder();
                sb.append("102% ").append(contextName);
                if (sourceDiffers) {
                    d = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DIFFERENT SOURCE");
                    sb.append(" <sup style=\"font-size:12px\" color=red>").append(d).append("</sup>");
                }
                if (targetDiffers) {
                    d = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DIFFERENT TRANSLATION");
                    sb.append(" <sub style=\"font-size:12px\" color=red>").append(d).append("</sub>");
                    this.targetDifferent = true;
                }
                this.names[this.index] = sb.toString() + meta;
                hasContext = true;
                context = 1;
            }
            this.sources[this.index] = source;
            this.targets[this.index] = target;
            if (!segmentMatch && this.currentSourceSegment != null && (props = tu.getProperties()) != null) {
                Object object;
                for (int k = 0; k < props.length && (object = props[k]) != null; ++k) {
                    Pattern pat;
                    Matcher m;
                    String[] arr = (String[])object;
                    String type = arr[0];
                    String value = arr[1];
                    if (type == null || value == null || !type.equalsIgnoreCase("Context") || value.trim().length() <= 0 || !(m = (pat = Pattern.compile(value, 16)).matcher(this.currentSourceSegment)).find()) continue;
                    context = 1;
                    break;
                }
            }
            int matchType = segmentMatch ? (prefixMatch ? 4 : 1) : (prefixMatch ? 4 : 1);
            FragmentMatch fmatch = new FragmentMatch(currentFragment, source, target, this.memoryName, segmentMatch, matchType, 1, context, this.priority, 0);
            fmatch.setTMResult(this);
            fmatch.setResultID(this.index);
            this.fragmentMatches.add(fmatch);
            this.tuids[this.index][0] = this.tuindex;
            this.tumap.put(this.tuindex, tu);
            ++this.tuindex;
            ++this.index;
        } while ((tu = tu.getLink()) != null);
        return hasContext;
    }

    public void setVirtualMatch(String source, String target) {
        if (this.index < this.limit) {
            this.names[this.index] = virtualName;
            this.sources[this.index] = source;
            this.targets[this.index] = target;
            FragmentMatch fmatch = new FragmentMatch(source, source, target, this.memoryName, false, 2, 1, 0, this.priority, 0);
            fmatch.setTMResult(this);
            fmatch.setResultID(this.index);
            this.fragmentMatches.add(fmatch);
            ++this.index;
        }
    }

    public void setSubsegmentUnit(TranslationUnit tu) {
        if (this.ntu < 10 && this.index < this.limit) {
            this.otu.add(tu);
            ++this.ntu;
        }
    }

    public void clearSubsegmentUnits() {
        this.otu.clear();
        this.ntu = 0;
    }

    public void setSubsegmentMatch(int k, boolean context, String source, String target) {
        if (this.index < this.limit) {
            if (this.hitNumber == k && source.startsWith(this.currentSourceFragment)) {
                if (this.index > 0) {
                    --this.index;
                }
            } else if (this.hitNumber == k && this.currentSourceFragment.indexOf(source) != -1) {
                return;
            }
            int i = 0;
            for (TranslationUnit tu : this.otu) {
                if (tu == null) continue;
                this.tuids[this.index][i] = this.tuindex;
                this.tumap.put(this.tuindex, tu);
                ++this.tuindex;
                ++i;
            }
            this.otu.clear();
            String s = k > AppPreferences.hitToAutoThreshold || context ? hitSpanStart2 + hitName + k + hitSpanEnd : (k > 1 ? hitSpanStart1 + hitName + k + hitSpanEnd : hitName + k);
            this.names[this.index] = s;
            this.sources[this.index] = source;
            this.targets[this.index] = target;
            int contextL = 0;
            if (context) {
                contextL = 1;
            }
            FragmentMatch fmatch = new FragmentMatch(source, source, target, this.memoryName, false, 3, 1, contextL, this.priority, 0);
            fmatch.setTMResult(this);
            fmatch.setResultID(this.index);
            fmatch.setHitsNumer(k);
            this.fragmentMatches.add(fmatch);
            this.ntu = 0;
            ++this.index;
            this.currentSourceFragment = source;
            this.hitNumber = k;
        }
    }

    private boolean isDuplicateMatch(String source, String target) {
        int i;
        boolean duplicateSource = false;
        for (i = 0; i < this.sources.length; ++i) {
            String s = this.sources[i];
            if (s == null) {
                return false;
            }
            if (source == null || !s.equals(source)) continue;
            duplicateSource = true;
            break;
        }
        if (duplicateSource) {
            for (i = 0; i < this.targets.length; ++i) {
                String t = this.targets[i];
                if (t == null) {
                    return false;
                }
                if (target == null || !t.equals(target)) continue;
                return true;
            }
        }
        return false;
    }

    public TranslationUnit getPerfectTranslationUnit() {
        return this.perfectTU;
    }

    public TranslationUnit getTranslationUnit(int id) {
        TranslationUnit tu = (TranslationUnit)this.tumap.get(id);
        return tu;
    }

    public Collection getTranslationUnits() {
        return this.tumap.values();
    }

    public String getHTMLResults() {
        String t;
        String s;
        String src;
        int i;
        if (this.names == null) {
            return null;
        }
        StringBuilder html = new StringBuilder();
        html.append("<br>");
        html.append(HTMLFormat.startTMXResultHTML);
        int count = 0;
        if (this.perfectMatch > 0) {
            for (i = 0; i < this.perfectMatch && this.names[i] != null; ++i) {
                String trg;
                html.append(sRow);
                html.append(HTMLFormat.AALeftCol2);
                html.append(startHeader);
                html.append("\"%").append(String.valueOf(i)).append("\"").append(">");
                html.append(this.names[i]);
                html.append("&nbsp;");
                html.append("&nbsp;");
                html.append("<span style='white-space:nowrap'>");
                for (int j = 0; j < 10 && this.tuids[i][j] != 0; ++j) {
                    int id = this.tuids[i][j];
                    int k = j + 1;
                    html.append("|");
                    html.append("&nbsp;");
                    html.append("&nbsp;");
                    html.append("<a href=#").append(i).append("=").append(id).append("><b>").append(k).append("</b></a>");
                    if (j >= 9) continue;
                    html.append("&nbsp;");
                    html.append("&nbsp;");
                }
                html.append("</span>");
                html.append(endHeader);
                html.append(eCol);
                html.append(eRow);
                html.append(sRow);
                html.append("<p>");
                src = this.sources[i];
                s = XMLHelper.resolveXMLEntities2(src);
                if (this.sourceDifferent) {
                    s = XMLHelper.getDifferenceHTML(s, this.currentSourceSegment);
                }
                html.append(s);
                html.append("</p>");
                html.append(eRow);
                html.append(sRow);
                html.append("<p>");
                t = trg = this.targets[i];
                if (this.targetDifferent && this.currentTargetSegment != null) {
                    t = XMLHelper.getDifferenceHTML(t, this.currentTargetSegment);
                }
                html.append(t);
                html.append("</p>");
                html.append(eRow);
                ++count;
            }
        }
        if (this.bfuzzies != null) {
            for (i = 0; i < this.bfuzzies.length; ++i) {
                Object object = this.bfuzzies[i];
                if (object == null) continue;
                Object[] arr = (Object[])object;
                Integer oi = (Integer)arr[0];
                int pro = oi;
                String proc = Integer.toString(pro);
                String fuzzyEntry = (String)arr[2];
                boolean pref = (Boolean)arr[4];
                String fuzzyKeyHTML = (String)arr[10];
                html.append(sRow);
                html.append(HTMLFormat.AALeftCol2);
                html.append(startHeader).append("$").append(i).append(">");
                html.append(proc);
                html.append("% ");
                html.append(fuzzyName);
                String p = (String)arr[12];
                if (p != null) {
                    html.append(p);
                }
                int id = this.tuids[count][0];
                int k = 1;
                html.append("&nbsp;");
                html.append("&nbsp;");
                html.append("|");
                html.append("&nbsp;");
                html.append("&nbsp;");
                html.append("<a href=#").append(i).append("=").append(id).append("><b>").append(k).append("</b></a>");
                html.append(endHeader);
                html.append(endRow);
                if (!pref) {
                    html.append(sRow);
                    html.append("<p>");
                    html.append(fuzzyKeyHTML);
                    html.append("</p>");
                    html.append(eRow);
                }
                html.append(sRow);
                html.append("<p>");
                html.append(fuzzyEntry);
                html.append("</p>");
                html.append(eRow);
                ++count;
            }
        }
        for (i = count; i < this.limit && this.names[i] != null; ++i) {
            html.append(sRow);
            html.append(HTMLFormat.AALeftCol2);
            html.append(startHeader);
            html.append('\"').append(String.valueOf(i)).append('\"').append(">");
            html.append(this.names[i]);
            html.append("&nbsp;");
            html.append("&nbsp;");
            html.append("<span style='white-space:nowrap'>");
            for (int j = 0; j < 10 && this.tuids[i][j] != 0; ++j) {
                int id = this.tuids[i][j];
                int k = j + 1;
                html.append("|");
                html.append("&nbsp;");
                html.append("&nbsp;");
                html.append("<a href=#").append(i).append("=").append(id).append("><b>").append(k).append("</b></a>");
                if (j >= 9) continue;
                html.append("&nbsp;");
                html.append("&nbsp;");
            }
            html.append("</span>");
            html.append(endHeader);
            html.append(eCol);
            html.append(eRow);
            html.append(sRow);
            html.append("<p>");
            src = this.sources[i];
            s = XMLHelper.resolveXMLEntities2(src);
            html.append(s);
            html.append("</p>");
            html.append(eRow);
            html.append(sRow);
            html.append("<p>");
            String trg = this.targets[i];
            t = XMLHelper.resolveXMLEntities2(trg);
            html.append(t);
            html.append("</p>");
            html.append(eRow);
        }
        html.append(endHTML);
        return html.toString();
    }

    public String getTarget(int i) {
        return this.targets[i];
    }

    public String getSource(int i) {
        return this.sources[i];
    }

    public List getFragmentMatches() {
        return this.fragmentMatches;
    }

    public boolean hasMatches() {
        return this.index > 0;
    }
}

