/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import translator.AppPreferences;
import translator.database.DBConnection;
import translator.database.TermBase;
import translator.tmx.Memory;
import translator.tmx.TMXHandler;
import translator.tmx.TMXReadOnlyUnit;

public class TMXToTableHandler
extends TMXHandler {
    private TermBase base;
    private DBConnection connectionDB;
    private Connection connection;
    private Statement statement;
    private ResultSet rs;
    private ResultSetMetaData meta;
    private boolean autoincrement;
    private int srcCol = -1;
    private int trgCol = -1;
    private int clientID = -1;
    private int note = -1;
    private int field = -1;
    private int context = -1;
    private int reference = -1;
    private int[] columnTypes;
    private String[] columnNames;
    private int columnCount;
    private StringBuffer source;
    private StringBuffer target;
    String attrName = "xml:lang";
    boolean sourceSeg = false;
    boolean targetSeg = false;
    private TMXReadOnlyUnit tu;
    private String tuNote;
    private String tuFieldProp;
    private String tuContextProp;
    private String tuClientProp;
    private String tuReferenceProp;
    ProgressMonitor pm;
    private boolean singleTM;
    private int newNo = 0;
    private Date date;
    private Time time;
    private Timestamp timestamp;
    private String tableName;
    int counter = 0;
    int size = 0;

    public TMXToTableHandler(Memory memory, TermBase base) {
        super(memory);
        this.pm = memory.getProgressMonitor();
        this.singleTM = memory.isSingleTM();
        this.base = base;
        this.source = new StringBuffer();
        this.target = new StringBuffer();
        this.prepareDBTable();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        block17: {
            block16: {
                String value;
                block18: {
                    if (qName.equals("seg")) {
                        if (this.sourceSeg) {
                            this.source = new StringBuffer();
                        } else if (this.targetSeg) {
                            this.target = new StringBuffer();
                        }
                        this.contents.reset();
                        return;
                    }
                    if (!qName.equals("tuv")) break block16;
                    value = attr.getValue(this.attrName);
                    if (value == null) {
                        value = attr.getValue("lang");
                    }
                    if (value == null) break block17;
                    int i = value.indexOf(45);
                    if (i != -1) {
                        value = value.substring(0, i);
                    }
                    if (!value.equalsIgnoreCase(this.slang)) break block18;
                    this.sourceSeg = true;
                    break block17;
                }
                if (!value.equalsIgnoreCase(this.tlang)) break block17;
                this.targetSeg = true;
                break block17;
            }
            if (qName.equals("tu")) {
                this.tu = new TMXReadOnlyUnit();
            } else if (qName.equals("prop") && this.tu != null) {
                for (int i = 0; i < attr.getLength(); ++i) {
                    String type = attr.getQName(i);
                    String val = attr.getValue(i);
                    if (type == null || !type.equals("type")) continue;
                    if (val != null && val.equalsIgnoreCase(AppPreferences.dbFieldCol)) {
                        this.tuFieldProp = "";
                        break;
                    }
                    if (val != null && val.equalsIgnoreCase(AppPreferences.dbContextCol)) {
                        this.tuContextProp = "";
                        break;
                    }
                    if (val != null && val.equalsIgnoreCase(AppPreferences.dbClientCol)) {
                        this.tuClientProp = "";
                        break;
                    }
                    if (val == null || !val.equalsIgnoreCase(AppPreferences.dbURLCol)) continue;
                    this.tuReferenceProp = "";
                    break;
                }
            }
        }
        if (this.sourceSeg && this.source != null && this.contents.size() > 0) {
            this.source.append(this.contents);
        } else if (this.targetSeg && this.target != null && this.contents.size() > 0) {
            this.target.append(this.contents);
        }
        this.contents.reset();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.sourceSeg && this.source != null && this.contents.size() > 0) {
            this.source.append(this.contents);
        } else if (this.targetSeg && this.target != null && this.contents.size() > 0) {
            this.target.append(this.contents);
        }
        if (qName.equals("seg")) {
            if (this.sourceSeg && this.source != null) {
                this.tu.setSegment(this.slang, this.source.toString());
            } else if (this.targetSeg && this.target != null) {
                this.tu.setSegment(this.tlang, this.target.toString());
            }
            this.source = null;
            this.target = null;
            this.sourceSeg = false;
            this.targetSeg = false;
        } else if (qName.equals("tu")) {
            if (this.tu != null && this.tu.getSegment(this.slang) != null && this.tu.getSegment(this.tlang) != null) {
                try {
                    this.loadTU();
                }
                catch (SQLException ex) {
                    Logger.getLogger(TMXToTableHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.tu = null;
            this.tuNote = null;
            this.tuFieldProp = null;
            this.tuContextProp = null;
            this.tuClientProp = null;
            this.tuReferenceProp = null;
        } else if (qName.equals("note")) {
            if (this.tu != null && this.tuNote == null) {
                this.tuNote = this.contents.toString();
            }
        } else if (qName.equals("prop")) {
            if (this.tu != null && this.tuFieldProp != null && this.tuFieldProp.length() == 0) {
                this.tuFieldProp = this.contents.toString();
            } else if (this.tu != null && this.tuContextProp != null && this.tuContextProp.length() == 0) {
                this.tuContextProp = this.contents.toString();
            } else if (this.tu != null && this.tuClientProp != null && this.tuClientProp.length() == 0) {
                this.tuClientProp = this.contents.toString();
            } else if (this.tu != null && this.tuReferenceProp != null && this.tuReferenceProp.length() == 0) {
                this.tuReferenceProp = this.contents.toString();
            }
        }
        this.contents.reset();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.singleTM) {
            this.endLoading();
        }
    }

    public void endLoading() {
        this.pm.close();
        if (this.base.isLoaded()) {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                this.connectionDB.refresh();
            }
            catch (SQLException ex) {
                Logger.getLogger(TMXToTableHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(TMXToTableHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.base.closeResource();
        }
    }

    private void prepareDBTable() {
        try {
            String ncol;
            String rcol;
            String ccol;
            String fcol;
            String idcol;
            String tcol;
            this.connectionDB = this.base.getConnection();
            String driver = this.connectionDB.getDriverClassName();
            String nq = this.connectionDB.getNextRowsQuery();
            if (nq == null) {
                this.connectionDB.selectAllRows();
            } else {
                this.connectionDB.selectRows(nq);
            }
            this.connection = this.connectionDB.getConnection();
            this.tableName = this.connectionDB.getTableName();
            this.columnTypes = this.connectionDB.getColumnTypes();
            this.columnNames = this.connectionDB.getColumnNamesArray();
            this.rs = this.connectionDB.getResultSet();
            int scrollType = this.rs.getType();
            if (scrollType == 1003) {
                this.statement = this.connection.createStatement();
            } else if (driver != null && driver.equals("org.mariadb.jdbc.Driver")) {
                this.statement = this.connection.createStatement();
            }
            this.meta = this.rs.getMetaData();
            this.columnCount = this.meta.getColumnCount();
            String scol = this.connectionDB.getSourceLang();
            if (scol.indexOf("-") != -1) {
                scol = scol.replaceAll("-", "_");
            }
            if ((tcol = this.connectionDB.getTargetLang()).indexOf("-") != -1) {
                tcol = tcol.replaceAll("-", "_");
            }
            if ((idcol = this.connectionDB.getClientIDName()).indexOf("-") != -1) {
                idcol = idcol.replaceAll("-", "_");
            }
            if ((fcol = this.connectionDB.getFieldName()).indexOf("-") != -1) {
                fcol = fcol.replaceAll("-", "_");
            }
            if ((ccol = this.connectionDB.getContextName()).indexOf("-") != -1) {
                ccol = ccol.replaceAll("-", "_");
            }
            if ((rcol = this.connectionDB.getReferenceName()).indexOf("-") != -1) {
                rcol = rcol.replaceAll("-", "_");
            }
            if ((ncol = this.connectionDB.getNotesName()).indexOf("-") != -1) {
                ncol = ncol.replaceAll("-", "_");
            }
            this.autoincrement = this.connectionDB.autoIncrementNull;
            for (int i = 1; i <= this.columnCount; ++i) {
                String name = this.meta.getColumnName(i);
                int type = this.meta.getColumnType(i);
                if (type != -9 && type != 12) continue;
                if (name.equalsIgnoreCase(idcol)) {
                    this.clientID = i;
                    continue;
                }
                if (name.equalsIgnoreCase(fcol)) {
                    this.field = i;
                    continue;
                }
                if (name.equalsIgnoreCase(ccol)) {
                    this.context = i;
                    continue;
                }
                if (name.equalsIgnoreCase(rcol)) {
                    this.reference = i;
                    continue;
                }
                if (name.equalsIgnoreCase(ncol)) {
                    this.note = i;
                    continue;
                }
                if (name.equalsIgnoreCase(scol)) {
                    this.srcCol = i;
                    continue;
                }
                if (!name.equalsIgnoreCase(tcol)) continue;
                this.trgCol = i;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TMXToTableHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        java.util.Date today = new java.util.Date();
        this.date = new Date(today.getTime());
        this.time = new Time(today.getTime());
        this.timestamp = this.connectionDB.getTodayTimestamp();
    }

    private void loadTU() throws SQLException {
        if (this.statement != null) {
            this.loadTUSQLStatement();
            return;
        }
        String source = this.tu.getSegment(this.slang);
        String target = this.tu.getSegment(this.tlang);
        if (source == null || target == null || source.length() > AppPreferences.columnSize || target.length() > AppPreferences.columnSize) {
            return;
        }
        this.rs.moveToInsertRow();
        for (int i = 1; i <= this.columnCount; ++i) {
            int type = this.columnTypes[i - 1];
            if (type == -9 || type == 12) {
                String s = null;
                if (i == this.srcCol) {
                    s = source;
                } else if (i == this.trgCol) {
                    s = target;
                } else if (i == this.note && this.tuNote != null) {
                    s = this.tuNote;
                } else if (i == this.field && this.tuFieldProp != null) {
                    s = this.tuFieldProp;
                } else if (i == this.context && this.tuContextProp != null) {
                    s = this.tuContextProp;
                } else if (i == this.reference && this.tuReferenceProp != null) {
                    s = this.tuReferenceProp;
                } else if (i == this.clientID && this.tuClientProp != null) {
                    s = this.tuContextProp;
                }
                if (s == null) continue;
                this.rs.updateString(i, s);
                continue;
            }
            if (type == 4) {
                ++this.newNo;
                if (!this.meta.isAutoIncrement(i)) {
                    int j = this.newNo;
                    this.rs.updateInt(i, j);
                    continue;
                }
                if (!this.autoincrement) continue;
                this.rs.updateObject(i, null);
                continue;
            }
            if (type == 91) {
                this.rs.updateDate(i, this.date);
                continue;
            }
            if (type == 92) {
                this.rs.updateTime(i, this.time);
                continue;
            }
            if (type != 93) continue;
            this.rs.updateTimestamp(i, this.timestamp);
        }
        this.rs.insertRow();
        ++this.size;
        ++this.counter;
        if (this.counter == 10000) {
            this.counter = 0;
            this.pm.setNote(Integer.toString(this.size));
            this.updateProgress(9999);
        } else if (this.counter % 100 == 0) {
            this.pm.setNote(Integer.toString(this.size));
            this.updateProgress(this.counter);
        }
    }

    private void loadTUSQLStatement() throws SQLException {
        String source = this.tu.getSegment(this.slang);
        String target = this.tu.getSegment(this.tlang);
        if (source == null || target == null || source.length() > AppPreferences.columnSize || target.length() > AppPreferences.columnSize) {
            return;
        }
        StringBuilder sqlColumns = new StringBuilder("(");
        StringBuilder sqlValues = new StringBuilder("(");
        for (int i = 1; i <= this.columnCount; ++i) {
            String s;
            int type = this.columnTypes[i - 1];
            String columnName = this.columnNames[i - 1];
            if (type == -9 || type == 12) {
                s = null;
                if (i == this.srcCol) {
                    s = source;
                } else if (i == this.trgCol) {
                    s = target;
                } else if (i == this.note && this.tuNote != null) {
                    s = this.tuNote;
                } else if (i == this.field && this.tuFieldProp != null) {
                    s = this.tuFieldProp;
                } else if (i == this.context && this.tuContextProp != null) {
                    s = this.tuContextProp;
                } else if (i == this.reference && this.tuReferenceProp != null) {
                    s = this.tuReferenceProp;
                } else if (i == this.clientID && this.tuClientProp != null) {
                    s = this.tuContextProp;
                }
                if (s == null) continue;
                if (s.indexOf(39) != -1) {
                    s = s.replaceAll("'", "''");
                }
                sqlColumns.append(columnName);
                sqlColumns.append(",");
                sqlValues.append("'");
                sqlValues.append(s);
                sqlValues.append("', ");
                continue;
            }
            if (type == 4) {
                ++this.newNo;
                continue;
            }
            if (type == 91) {
                s = this.date.toString();
                if (s.length() <= 0) continue;
                sqlColumns.append(columnName);
                sqlColumns.append(",");
                sqlValues.append('\'');
                sqlValues.append(s);
                sqlValues.append('\'');
                sqlValues.append(", ");
                continue;
            }
            if (type == 92) {
                s = this.time.toString();
                if (s.length() <= 0) continue;
                sqlColumns.append(columnName);
                sqlColumns.append(",");
                sqlValues.append(s);
                sqlValues.append(", ");
                continue;
            }
            if (type != 93 || (s = this.timestamp.toString()).length() <= 0) continue;
            sqlColumns.append(columnName);
            sqlColumns.append(",");
            sqlValues.append(s);
            sqlValues.append(", ");
        }
        if (sqlColumns.length() > 1) {
            sqlColumns.setLength(sqlColumns.length() - 1);
            sqlColumns.append(")");
        }
        if (sqlValues.length() > 2) {
            sqlValues.setLength(sqlValues.length() - 2);
            sqlValues.append(")");
        }
        String sql = "INSERT INTO " + this.tableName + " " + sqlColumns.toString() + " VALUES " + sqlValues.toString() + ";";
        this.statement.executeUpdate(sql);
        ++this.size;
        ++this.counter;
        if (this.counter == 10000) {
            this.counter = 0;
            this.pm.setNote(Integer.toString(this.size));
            this.updateProgress(9999);
        } else if (this.counter % 100 == 0) {
            this.pm.setNote(Integer.toString(this.size));
            this.updateProgress(this.counter);
        }
    }

    public void initProgress(int min, int max, String note) {
        ProgressInit initProgress = new ProgressInit(min, max, note);
        SwingUtilities.invokeLater(initProgress);
    }

    public void updateProgress(int counter) {
        ProgressUpdater updater = new ProgressUpdater(counter);
        SwingUtilities.invokeLater(updater);
    }

    private class ProgressInit
    implements Runnable {
        private int min;
        private int max;
        private String note;

        ProgressInit(int min, int max, String note) {
            this.min = min;
            this.max = max;
            this.note = note;
        }

        @Override
        public void run() {
            TMXToTableHandler.this.pm.setMinimum(this.min);
            TMXToTableHandler.this.pm.setMaximum(this.max);
            TMXToTableHandler.this.pm.setNote(this.note);
        }
    }

    private class ProgressUpdater
    implements Runnable {
        private int _value;

        ProgressUpdater(int value) {
            this._value = value;
        }

        @Override
        public void run() {
            TMXToTableHandler.this.pm.setProgress(this._value);
        }
    }
}

