/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleContext;
import translator.AppPreferences;
import translator.FileFilters;
import translator.FormatChooser;
import translator.MainClass;
import translator.Project;
import translator.Translatable;
import translator.text.ParagraphStyledDocument;
import translator.translatables.TextDocument;
import translator.ui.GridPanel;

public class AutoCadDocument
extends TextDocument
implements Translatable {
    private String filteredLayers;

    public String getFilteredLayers() {
        return this.filteredLayers;
    }

    public void filterLayers(File file) {
        String regEx = "\r\nLAYER\r\n.+?\r\n  0\r\n";
        String outString = this.loadTextFile(file, "UTF-8");
        Pattern p = Pattern.compile(regEx, 32);
        String aaformat = "(\r\n  2\r\n.+)+";
        Pattern gp = Pattern.compile(aaformat, 2);
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = p.matcher(outString);
        while (m.find()) {
            String group = m.group();
            Matcher m2 = gp.matcher(group);
            if (!m2.find()) continue;
            String subgroup = m2.group();
            subgroup = subgroup.replaceAll("\r\n  2\r\n", "");
            list.add(subgroup);
        }
        if (!list.isEmpty()) {
            final JDialog dialog = new JDialog((Frame)this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILTER LAYERS"));
            dialog.setLayout(new BorderLayout(2, 2));
            dialog.setDefaultCloseOperation(2);
            dialog.setModal(true);
            dialog.setResizable(false);
            final GridPanel panel = new GridPanel();
            panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
            panel.setLayout(new GridLayout(0, 1, 0, 2));
            JScrollPane scroll = new JScrollPane(panel);
            scroll.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
            scroll.getVerticalScrollBar().setUnitIncrement(10);
            scroll.setOpaque(false);
            scroll.getViewport().setOpaque(false);
            if (list.size() > 20) {
                scroll.setPreferredSize(new Dimension(500, 500));
            }
            dialog.add((Component)scroll, "Center");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String next = iterator.next().toString();
                JCheckBox cb = new JCheckBox(next);
                panel.add(cb);
            }
            JButton buttonOK = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
            JButton buttonCancel = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.add(buttonOK);
            buttonsPanel.add(buttonCancel);
            dialog.add((Component)buttonsPanel, "South");
            buttonOK.addActionListener(new ActionListener(){
                final /* synthetic */ AutoCadDocument this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringBuilder sb = new StringBuilder();
                    int count = panel.getComponentCount();
                    for (int i = 0; i < count; ++i) {
                        JCheckBox cb = (JCheckBox)panel.getComponent(i);
                        if (!cb.isSelected()) continue;
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append(cb.getText());
                    }
                    this.this$0.filteredLayers = sb.toString();
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            buttonCancel.addActionListener(new ActionListener(){
                final /* synthetic */ AutoCadDocument this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            Dimension dlgSize = dialog.getPreferredSize();
            Dimension frmSize = MainClass.getMainView().getSize();
            Point loc = MainClass.getMainView().getLocation();
            dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            dialog.pack();
            dialog.setVisible(true);
        }
    }

    public void loadFile(File file, String format, String encoding, Map filters) {
        Object oi;
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadTextFile(file, "UTF-8");
        if (filters != null && (oi = filters.get("filter:Layers")) != null) {
            this.filteredLayers = oi.toString();
        }
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
    }

    public void openFile(File file, String format, String encoding, Map filters) {
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadTextFile(file, "UTF-8");
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(path)) {
            docs.add(path);
        }
        this.openEditorTab(this.doc);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
    }

    @Override
    String getContent(String xhtml, LinkedHashMap skeleton, String format) {
        String inline;
        this.isXML = false;
        String aaformat = "(\r\n  [13]\r\n.+)";
        Pattern p = Pattern.compile(format, 40);
        Pattern gp = Pattern.compile(aaformat, 2);
        Matcher matcher = p.matcher(xhtml);
        StringBuilder content = new StringBuilder();
        int to = 0;
        int index = 1;
        String[] layers = this.filteredLayers != null && this.filteredLayers.length() > 0 ? this.filteredLayers.split(",") : null;
        while (matcher.find()) {
            int from = matcher.start();
            String group = matcher.group();
            if (layers != null) {
                boolean inFilteredLayer = false;
                for (int i = 0; i < layers.length; ++i) {
                    String layer = layers[i].trim() + "\r\n";
                    if (group.indexOf(layer) == -1) continue;
                    inFilteredLayer = true;
                }
                if (!inFilteredLayer) continue;
            }
            Matcher gmatcher = gp.matcher(group);
            while (gmatcher.find()) {
                String subgroup = gmatcher.group();
                int start = gmatcher.start();
                String match = subgroup.replaceAll("\r\n  [13]\r\n", "");
                match = AutoCadDocument.hexToUnicode(match);
                inline = xhtml.substring(to, from + start);
                String tags = group.startsWith("AcDbM") ? "<x id=\"" + index + "\" ctype=\"x-break\" text:entity=\"mtext\"/>" : "<x id=\"" + index + "\" ctype=\"x-break\" text:entity=\"text\"/>";
                skeleton.put(tags, inline.toString());
                content.append(tags);
                content.append(match);
                to = from + gmatcher.end();
                ++index;
            }
        }
        if (to < xhtml.length()) {
            inline = xhtml.substring(to);
            String tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            content.append(tags);
        }
        return content.toString();
    }

    public static String toHexUnicode(String unicode) {
        String output = "";
        char[] charArray = unicode.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char a = charArray[i];
            if (a > '\u00ff') {
                String hex = Integer.toHexString(a);
                if (hex.length() == 2) {
                    output = output + "\\U+00" + hex;
                    continue;
                }
                if (hex.length() == 3) {
                    output = output + "\\U+0" + hex;
                    continue;
                }
                output = output + "\\U+" + hex;
                continue;
            }
            output = a == '\n' ? output + "\\U+000A" : (a == '\r' ? output + "\\U+000D" : output + a);
        }
        return output;
    }

    public static String hexToUnicode(String e) {
        StringBuffer sb = new StringBuffer();
        int ind = 0;
        int i = -1;
        String tail = null;
        String head = null;
        String code = null;
        while ((i = e.indexOf("\\U+", ind)) != -1) {
            tail = e.substring(ind, i);
            head = e.substring(i);
            int k = 7;
            code = head.substring(3, 7);
            char c = (char)Integer.parseInt(code, 16);
            sb.append(tail);
            sb.append(c);
            ind = i + k;
        }
        if (ind != -1 && sb.length() > 0) {
            sb.append(e.substring(ind));
            return sb.toString();
        }
        return e;
    }

    @Override
    String[] insertContent(Document doc) throws BadLocationException {
        int skelindex = 0;
        String[] contents = new String[this.skeletons.size()];
        LinkedHashMap skeleton = (LinkedHashMap)this.skeletons.get(skelindex);
        StringBuffer all = new StringBuffer();
        String content = doc.getText(0, doc.getLength());
        String tsegFormat = "(<x id=[^>]*>+?)";
        Pattern ttags = Pattern.compile(tsegFormat);
        Matcher ma = ttags.matcher(content);
        int st = 0;
        boolean mtext = false;
        while (ma.find()) {
            int b = ma.start();
            int e = ma.end();
            String group = ma.group();
            String cont = content.substring(st, b);
            if (cont.length() > 0) {
                if (mtext) {
                    while (cont.length() > 250) {
                        String part = cont.substring(0, 250);
                        all.append("\r\n  3\r\n");
                        all.append(part);
                        cont = cont.substring(250);
                    }
                }
                if (cont.length() > 0) {
                    all.append("\r\n  1\r\n");
                    all.append(cont);
                }
            }
            mtext = group.indexOf("mtext") != -1;
            String inline = (String)skeleton.get(group);
            if (inline != null) {
                all.append(inline);
            }
            st = e;
        }
        int le = content.length();
        if (st < le) {
            String cont = content.substring(st, le);
            all.append(cont);
        }
        if (all.length() > 0) {
            contents[skelindex] = all.toString();
            all.setLength(0);
        }
        return contents;
    }

    private boolean saveFile() {
        Document doc = null;
        doc = this.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            return false;
        }
        String path = (String)doc.getProperty("path");
        if (path == null) {
            return this.saveAsFile();
        }
        if (path.length() == 0) {
            return false;
        }
        Boolean save = (Boolean)doc.getProperty("save");
        if (save == null || !save.booleanValue()) {
            return false;
        }
        File file = new File(path);
        return this.saveAutoCadFile(file, doc);
    }

    private boolean saveAutoCadFile(File file, Document doc) {
        try {
            String[] texts = null;
            String text = "";
            if (this.skeletons.size() > 0) {
                texts = this.insertContent(doc);
                if (texts == null) {
                    JOptionPane.showMessageDialog(this.topui, "The original source language document has been modified. Export may fail or be incomplete.");
                    return false;
                }
                for (int i = 0; i < texts.length; ++i) {
                    String string = texts[i];
                    text = text + string;
                }
            } else {
                text = doc.getText(0, doc.getLength());
            }
            File tempFile = File.createTempFile("Exp", file.getName(), file.getParentFile());
            this.storeFile(tempFile, text, "UTF-8");
            if (file.exists()) {
                file.delete();
            }
            if (tempFile.renameTo(file)) {
                Boolean state = false;
                doc.putProperty("state", state);
            } else {
                JOptionPane.showMessageDialog(this.topui, "CafeTran cannot rename the file to " + file.getName());
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, e.getMessage());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, "The original source language document has been modified. Export may fail or be incomplete.");
        }
        return false;
    }

    private boolean saveAsFile() {
        Document doc = this.getDocument();
        Boolean save = (Boolean)doc.getProperty("save");
        if (save == null || !save.booleanValue()) {
            return false;
        }
        JFileChooser jFileChooser = new JFileChooser();
        FileFilters filters = new FileFilters();
        String filterName = AppPreferences.format;
        filters.setFileFilters(FormatChooser.formatType, filterName, jFileChooser);
        jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE DOCUMENT"));
        jFileChooser.setCurrentDirectory(new File(AppPreferences.fileDirectory));
        String fs = (String)doc.getProperty("path");
        String tlang = (String)doc.getProperty("target-lang");
        if (fs == null) {
            fs = "";
        }
        if (tlang != null) {
            int ind = fs.lastIndexOf(".");
            if (ind != -1) {
                String ext = fs.substring(ind);
                fs = fs.substring(0, ind) + "_" + tlang + ext;
            } else {
                fs = fs + tlang;
            }
        }
        jFileChooser.setSelectedFile(new File(fs));
        jFileChooser.repaint();
        if (0 == jFileChooser.showSaveDialog(this.topui)) {
            int i;
            File newFile = jFileChooser.getSelectedFile();
            AppPreferences.fileDirectory = newFile.getParent();
            String oldpath = (String)doc.getProperty("path");
            String path = newFile.getPath();
            doc.putProperty("path", path);
            doc.putProperty("file", newFile);
            List docs = this.topui.getResourceLoader().getDocumentLoaderList();
            if (oldpath != null) {
                docs.remove(oldpath);
            }
            docs.add(path);
            String oname = (String)doc.getProperty("name");
            String name = newFile.getName();
            JTabbedPane tabpane = this.tview.getTabbedPane();
            if (oname != null && (i = tabpane.indexOfTab(oname)) != -1) {
                tabpane.setTitleAt(i, name);
            }
            doc.putProperty("name", name);
            return this.saveAutoCadFile(newFile, doc);
        }
        return false;
    }

    @Override
    public void preview(Project pr, String spath) {
        Document sdoc = this.getDocument();
        String path = (String)sdoc.getProperty("path");
        String prev = pr.preview(sdoc);
        if (prev != null && path != null) {
            String prevFilePath;
            PlainDocument tdoc = new PlainDocument();
            try {
                tdoc.insertString(0, prev, null);
                if (sdoc.getProperty("skeleton") != null) {
                    LinkedHashMap skeleton = (LinkedHashMap)sdoc.getProperty("skeleton");
                    tdoc.putProperty("skeleton", skeleton);
                }
                if (sdoc.getProperty("zname") != null) {
                    String name = (String)sdoc.getProperty("zname");
                    tdoc.putProperty("zname", name);
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            File file = new File(path);
            String name = file.getName();
            String extention = null;
            int i = name.lastIndexOf(".");
            extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
            String parent = file.getParent();
            if (spath == null) {
                prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
            } else {
                prevFilePath = spath.toLowerCase().endsWith(extention) ? spath : spath + extention;
                if (prevFilePath.equalsIgnoreCase(path)) {
                    JOptionPane.showMessageDialog(this.topui, "Never overwrite the original source language document!");
                    return;
                }
            }
            File previewFile = new File(prevFilePath);
            boolean save = this.saveAutoCadFile(previewFile, tdoc);
            if (!save) {
                this.preview2(pr, spath);
            } else if (spath == null) {
                this.topui.getResourceView().viewFile(previewFile);
            }
        }
    }

    @Override
    public void preview2(Project pr, String spath) {
        Document sdoc = this.getDocument();
        String path = (String)sdoc.getProperty("path");
        String prev = pr.preview2(sdoc);
        if (prev != null && path != null) {
            String prevFilePath;
            PlainDocument tdoc = new PlainDocument();
            try {
                tdoc.insertString(0, prev, null);
                if (sdoc.getProperty("skeleton") != null) {
                    LinkedHashMap skeleton = (LinkedHashMap)sdoc.getProperty("skeleton");
                    tdoc.putProperty("skeleton", skeleton);
                }
                if (sdoc.getProperty("zname") != null) {
                    String name = (String)sdoc.getProperty("zname");
                    tdoc.putProperty("zname", name);
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            File file = new File(path);
            String name = file.getName();
            String extention = null;
            int i = name.lastIndexOf(".");
            extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
            String parent = file.getParent();
            if (spath == null) {
                prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
            } else {
                prevFilePath = spath.toLowerCase().endsWith(extention) ? spath : spath + extention;
                if (prevFilePath.equalsIgnoreCase(path)) {
                    JOptionPane.showMessageDialog(this.topui, "Never overwrite the original source language document!");
                    return;
                }
            }
            File previewFile = new File(prevFilePath);
            boolean save = this.saveAutoCadFile(previewFile, tdoc);
            if (save && spath == null) {
                this.topui.getResourceView().viewFile(previewFile);
            }
        }
    }

    @Override
    public boolean setTargetContent(Project p) {
        ParagraphStyledDocument sdoc = (ParagraphStyledDocument)this.getDocument();
        String s = this.translate(sdoc, p);
        if (s != null && s.length() > 0) {
            try {
                sdoc.remove(0, sdoc.getLength());
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.insertStringTags(sdoc, s);
            sdoc.setContents();
            JTextPane pane = this.getTextPane();
            if (pane != null) {
                this.cancelSegmentStyle();
                pane.setCaretPosition(0);
            }
            this.saveResource();
            return true;
        }
        return false;
    }

    private boolean okToAbandon() {
        Document doc = this.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            return true;
        }
        int value = JOptionPane.showConfirmDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE CHANGES IN THE DOCUMENT?"), "CafeTran", 1);
        switch (value) {
            case 0: {
                return this.saveFile();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void saveAsResource() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoCadDocument.this.saveAsFile();
            }
        });
    }

    @Override
    public void saveResource() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoCadDocument.this.saveFile();
            }
        });
    }

    @Override
    public void closeResource() {
        if (!this.okToAbandon()) {
            return;
        }
        Object o = this.getDocument().getProperty("path");
        if (o != null) {
            String path = o.toString();
            List docs = this.topui.getResourceLoader().getDocumentLoaderList();
            docs.remove(path);
        }
        this.tview = this.topui.getTabView();
        this.tview.removeTab(this.name);
    }
}

