/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.io.CharArrayWriter;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import translator.DefaultXMLElement;
import translator.XMLElement;
import translator.translatables.MSExcelDocument;
import translator.translatables.Row;
import translator.translatables.Sheet;

public class ExcelSheetInputHandler
extends DefaultHandler {
    protected CharArrayWriter contents = new CharArrayWriter();
    protected Stack deck = new Stack();
    private List sheets;
    private Sheet sheet;
    private String zipName;
    private MSExcelDocument excelDoc;

    public ExcelSheetInputHandler(MSExcelDocument excelDoc, List sheets, String zName) {
        this.excelDoc = excelDoc;
        this.sheets = sheets;
        this.zipName = zName;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        String h;
        DefaultXMLElement xml;
        boolean isRow = false;
        if (qName.equals("row")) {
            Row row = new Row(this.excelDoc);
            xml = row;
            isRow = true;
        } else if (qName.equals("worksheet")) {
            xml = new Sheet(this.zipName);
            this.sheet = (Sheet)xml;
        } else {
            xml = new DefaultXMLElement();
        }
        for (int i = 0; i < attr.getLength(); ++i) {
            xml.setAttribute(attr.getQName(i), attr.getValue(i));
        }
        xml.setName(qName);
        if ((qName.equals("col") || isRow) && (h = xml.getAttribute("hidden")) != null && h.equals("1")) {
            if (isRow) {
                Row row = (Row)xml;
                row.setHidden(isRow);
            } else {
                String min = xml.getAttribute("min");
                String max = xml.getAttribute("max");
                if (min != null && max != null) {
                    this.sheet.addHiddenColumn(min, max);
                }
            }
        }
        if (this.contents.size() > 0 && !this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement pxml = (XMLElement)o;
            pxml.addChild(this.contents.toString());
        }
        this.deck.push(xml);
        this.contents.reset();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        XMLElement childXml = (XMLElement)this.deck.pop();
        if (this.contents.size() > 0) {
            childXml.addChild(this.contents.toString());
        }
        if (!this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement xml = (XMLElement)o;
            xml.addChild(childXml);
        }
        if (qName.equals("worksheet")) {
            this.sheets.add(this.sheet);
        }
        this.contents.reset();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }
}

