/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.io.CharArrayWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import translator.DefaultXMLElement;
import translator.XMLElement;
import translator.translatables.Row;
import translator.translatables.Sheet;

public class ExcelSheetOutputHandler
extends DefaultHandler {
    protected CharArrayWriter contents = new CharArrayWriter();
    protected Stack deck = new Stack();
    private Sheet sheet;
    private Row row;
    private int index = 0;
    private String column;

    public ExcelSheetOutputHandler(Sheet sheet) {
        this.sheet = sheet;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        String n;
        if (qName.equals("row")) {
            this.row = this.sheet.getRow(this.index);
            ++this.index;
        } else if (qName.equals("c") && (n = attr.getQName(0)) != null && n.equals("r")) {
            this.column = attr.getValue(0);
        }
        DefaultXMLElement xml = new DefaultXMLElement();
        for (int i = 0; i < attr.getLength(); ++i) {
            xml.setAttribute(attr.getQName(i), attr.getValue(i));
        }
        xml.setName(qName);
        if (this.contents.size() > 0 && !this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement pxml = (XMLElement)o;
            pxml.addChild(this.contents.toString());
        }
        this.deck.push(xml);
        this.contents.reset();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        XMLElement childXml = (XMLElement)this.deck.pop();
        if (this.contents.size() > 0) {
            childXml.addChild(this.contents.toString());
        }
        if (!this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement xml = (XMLElement)o;
            xml.addChild(childXml);
        }
        if (qName.equals("si")) {
            this.removeEmptyTextElements(childXml);
            String s = childXml.getXMLFormat();
            if (s.length() > 0) {
                s = this.handleNewLines(s);
                this.row.setTarget(s, this.column);
            }
        }
        this.contents.reset();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }

    private String handleNewLines(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c2;
            boolean unixLine = false;
            char c = s.charAt(i);
            if (i > 0 && c == '\n' && (c2 = s.charAt(i - 1)) != '\r') {
                unixLine = true;
            }
            if (unixLine) {
                sb.append('\r');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void removeEmptyTextElements(XMLElement xml) {
        List list = xml.getChildren();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            XMLElement telement;
            Object content;
            List list2;
            XMLElement next = (XMLElement)iterator.next();
            String name = next.getName();
            if (!name.endsWith("r") || (list2 = next.getChildren("t")).size() != 1 || (content = (telement = (XMLElement)list2.get(0)).getContent(0)) != null && content.toString().length() != 0) continue;
            iterator.remove();
        }
    }
}

