/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import translator.AppPreferences;
import translator.FormatChooser;
import translator.GlossaryResource;
import translator.NaturalOrderComparator;
import translator.Project;
import translator.Translatable;
import translator.XMLElement;
import translator.XMLHelper;
import translator.text.ParagraphStyledDocument;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXReadOnlyUnit;
import translator.tmx.TMXReadOnlyUnitMap;
import translator.translatables.ExcelSheetInputHandler;
import translator.translatables.ExcelSheetOutputHandler;
import translator.translatables.IndesignIDMLDocument;
import translator.translatables.Row;
import translator.translatables.Sheet;
import translator.translatables.TextDocument;
import translator.translatables.ZipDocument;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;

public class MSExcelDocument
extends ZipDocument
implements Translatable {
    int tagIndex = 0;
    private List sharedStrings;
    private List sheets;
    private String sharedStringXMLStart;
    private String sharedStringXMLEnd;
    private boolean isBilingual;
    private String bilingualContent = "";
    public boolean conversion;
    private HashMap comments;
    private String tags;

    public MSExcelDocument() {
        this.isExcel = true;
        this.sheets = new ArrayList();
        this.comments = new HashMap();
    }

    public void setConversion() {
        this.conversion = true;
    }

    public List getSharedStrings() {
        return this.sharedStrings;
    }

    /*
     * WARNING - void declaration
     */
    public void loadFile(File file, String format, String encoding, String zName, Map filters) {
        ZipFile zipFile;
        this.setCustomFormatMap(format);
        String regExp = FormatChooser.getFormatRegEx(format);
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<? extends ZipEntry> list = Collections.list(entries);
        if (list.size() > 1) {
            Collections.sort(list, new NaturalOrderComparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    ZipEntry entry1 = (ZipEntry)o1;
                    ZipEntry entry2 = (ZipEntry)o2;
                    String s1 = entry1.getName();
                    String s2 = entry2.getName();
                    return super.compare(s1, s2);
                }
            });
        }
        this.sharedStrings = new ArrayList();
        ArrayList sheetProperties = new ArrayList();
        ArrayList<String> stories = new ArrayList<String>();
        int len = 0;
        for (ZipEntry zipEntry : list) {
            String regExp2;
            String outString;
            String zipname;
            String s = zipEntry.getName();
            if (s.equals("xl/sharedStrings.xml")) {
                zipname = s;
                outString = this.loadZipFile(zipFile, zipname, encoding);
                this.parseSharedStrings(outString, this.sharedStrings);
                continue;
            }
            if (s.startsWith("xl/worksheets/sheet")) {
                zipname = s;
                outString = this.loadZipFile(zipFile, zipname, encoding);
                this.parseSheetsInput(outString, zipname);
                continue;
            }
            if (s.startsWith("xl/workbook.xml")) {
                zipname = s;
                outString = this.loadZipFile(zipFile, zipname, encoding);
                if (outString == null) continue;
                this.parseSheetProperties(outString, sheetProperties);
                continue;
            }
            if (s.startsWith("xl/styles.xml")) {
                zipname = s;
                outString = this.loadZipFile(zipFile, zipname, encoding);
                if (outString == null) continue;
                this.parseHiddenCells(outString);
                continue;
            }
            if (!s.startsWith("xl/drawings/drawing")) continue;
            zipname = s;
            outString = this.loadZipFile(zipFile, zipname, encoding);
            LinkedHashMap skeleton = null;
            if (regExp.length() <= 0 || (outString = this.getPPContent(outString, skeleton = new LinkedHashMap(), regExp2 = "<xdr:from>.*?</xdr:from>|<xdr:to>.*?</xdr:to>|<[^>]*>")).trim().length() <= 0) continue;
            len += outString.length();
            this.skeletons.add(skeleton);
            stories.add(outString);
            this.zipNames.add(zipname);
        }
        try {
            zipFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(IndesignIDMLDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        String importSourceColumn = "";
        String string = "";
        String importNotesColumn = "";
        String exportColumn = "";
        String slang = null;
        String tlang = null;
        if (filters != null) {
            Object oi = filters.get("filter:ImportSourceColumn");
            Object oe = filters.get("filter:ExportColumn");
            Object oit = filters.get("filter:ImportTargetColumn");
            Object oin = filters.get("filter:ImportNotesColumn");
            if (oi != null) {
                importSourceColumn = oi.toString();
            }
            if (oe != null) {
                exportColumn = oe.toString();
            }
            if (oit != null) {
                String string2 = oit.toString();
                this.isBilingual = true;
                slang = (String)filters.get("source-language");
                tlang = (String)filters.get("target-language");
            }
            if (oin != null) {
                importNotesColumn = oin.toString();
            }
        }
        int count = 0;
        for (String s : sheetProperties) {
            if (count < this.sheets.size() && s.indexOf("hidden") != -1) {
                Sheet sheet = (Sheet)this.sheets.get(count);
                sheet.setHidden();
            }
            ++count;
        }
        if (this.conversion) {
            return;
        }
        count = 0;
        Iterator it = this.sheets.iterator();
        while (it.hasNext()) {
            void var14_20;
            String outString;
            Sheet sheet = (Sheet)it.next();
            String zipName = sheet.getName();
            if (!this.isBilingual) {
                Map notes;
                LinkedHashMap skeleton = new LinkedHashMap();
                String out = sheet.getSourceContent(importSourceColumn, exportColumn, importNotesColumn);
                outString = this.getContent(out, skeleton, regExp, notes = sheet.getNotesMap());
                if (outString.trim().length() > 0 && !sheet.isHidden()) {
                    len += outString.length();
                    this.skeletons.add(skeleton);
                    stories.add(outString);
                    continue;
                }
                this.zipNames.remove(zipName);
                it.remove();
                continue;
            }
            sheet.setID(count);
            ++count;
            outString = sheet.getBilingualContent(importSourceColumn, (String)var14_20, importNotesColumn, slang, tlang);
            if (outString.trim().length() > 0 && !sheet.isHidden()) {
                stories.add(outString);
                continue;
            }
            this.zipNames.remove(zipName);
            it.remove();
        }
        GapContent gap = new GapContent(len);
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        if (!this.isBilingual) {
            for (String story : stories) {
                this.insertStringTags(this.doc, story);
            }
            this.doc.setContents();
            this.setDocumentProperties(this.doc);
        } else {
            this.bilingualContent = "<body>";
            Iterator it2 = stories.iterator();
            while (it2.hasNext()) {
                this.bilingualContent = this.bilingualContent + (String)it2.next();
            }
            this.bilingualContent = this.bilingualContent + "</body>";
        }
    }

    /*
     * WARNING - void declaration
     */
    public void openFile(File file, String format, String encoding, String zName, Map filters) {
        ZipFile zipFile;
        this.setCustomFormatMap(format);
        String regExp = FormatChooser.getFormatRegEx(format);
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<? extends ZipEntry> list = Collections.list(entries);
        if (list.size() > 1) {
            Collections.sort(list, new NaturalOrderComparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    ZipEntry entry1 = (ZipEntry)o1;
                    ZipEntry entry2 = (ZipEntry)o2;
                    String s1 = entry1.getName();
                    String s2 = entry2.getName();
                    return super.compare(s1, s2);
                }
            });
        }
        this.sharedStrings = new ArrayList();
        ArrayList sheetProperties = new ArrayList();
        ArrayList<String> stories = new ArrayList<String>();
        int len = 0;
        for (ZipEntry zipEntry : list) {
            String regExp2;
            String outString;
            String zipname;
            String s = zipEntry.getName();
            if (s.equals("xl/sharedStrings.xml")) {
                zipname = s;
                outString = this.loadZipFile(zipFile, zipname, encoding);
                this.parseSharedStrings(outString, this.sharedStrings);
                continue;
            }
            if (s.startsWith("xl/worksheets/sheet")) {
                zipname = s;
                outString = this.loadZipFile(zipFile, zipname, encoding);
                this.parseSheetsInput(outString, zipname);
                continue;
            }
            if (s.startsWith("xl/workbook.xml")) {
                zipname = s;
                outString = this.loadZipFile(zipFile, zipname, encoding);
                if (outString == null) continue;
                this.parseSheetProperties(outString, sheetProperties);
                continue;
            }
            if (s.startsWith("xl/styles.xml")) {
                zipname = s;
                outString = this.loadZipFile(zipFile, zipname, encoding);
                if (outString == null) continue;
                this.parseHiddenCells(outString);
                continue;
            }
            if (!s.startsWith("xl/drawings/drawing")) continue;
            zipname = s;
            outString = this.loadZipFile(zipFile, zipname, encoding);
            LinkedHashMap skeleton = null;
            if (regExp.length() <= 0 || (outString = this.getPPContent(outString, skeleton = new LinkedHashMap(), regExp2 = "<xdr:from>.*?</xdr:from>|<xdr:to>.*?</xdr:to>|<[^>]*>")).trim().length() <= 0) continue;
            len += outString.length();
            this.skeletons.add(skeleton);
            stories.add(outString);
            this.zipNames.add(zipname);
        }
        try {
            zipFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(IndesignIDMLDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        String importColumn = "";
        String string = "";
        if (filters != null) {
            Object oi = filters.get("filter:ImportSourceColumn");
            Object oe = filters.get("filter:ExportColumn");
            if (oi != null) {
                importColumn = oi.toString();
            }
            if (oe != null) {
                String string2 = oe.toString();
            }
        }
        int count = 0;
        for (String s : sheetProperties) {
            if (count < this.sheets.size() && s.indexOf("hidden") != -1) {
                Sheet sheet = (Sheet)this.sheets.get(count);
                sheet.setHidden();
            }
            ++count;
        }
        Iterator it = this.sheets.iterator();
        while (it.hasNext()) {
            Map notes;
            void var14_20;
            Sheet sheet = (Sheet)it.next();
            String zipName = sheet.getName();
            LinkedHashMap skeleton = new LinkedHashMap();
            String out = sheet.getSourceContent(importColumn, (String)var14_20, "");
            String outString = this.getContent(out, skeleton, regExp, notes = sheet.getNotesMap());
            if (outString.trim().length() > 0 && !sheet.isHidden()) {
                len += outString.length();
                this.skeletons.add(skeleton);
                stories.add(outString);
            } else {
                this.zipNames.remove(zipName);
                it.remove();
            }
            ++count;
        }
        GapContent gap = new GapContent(len);
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        String loadedPath = path;
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(loadedPath)) {
            docs.add(loadedPath);
        }
        this.openEditorTab(this.doc);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
        this.setDocumentProperties(this.doc);
    }

    String getContent(String xhtml, LinkedHashMap skeleton, String aformat, Map notes) {
        this.isXML = true;
        Pattern p = Pattern.compile(aformat, 34);
        Matcher matcher = p.matcher(xhtml);
        StringBuilder content = new StringBuilder();
        String group = "";
        String lastGroup = "";
        int from = 0;
        int to = 0;
        int index = this.tagIndex;
        String standaloneSpace = null;
        boolean hasContent = false;
        boolean isPage = false;
        if (index > 0) {
            isPage = true;
        }
        boolean isPicture = false;
        ++index;
        StringBuffer inline = new StringBuffer();
        StringBuilder fgr = new StringBuilder();
        StringBuilder coll = new StringBuilder();
        int format = -1;
        int wstyle = 0;
        String wcolor = null;
        int textStyle = 0;
        boolean wrstyle = false;
        boolean wrProp = false;
        int wrPropStyle = 0;
        boolean wpProp = false;
        int wpPropStyle = 0;
        boolean change = false;
        boolean docSpace = false;
        boolean pexternal = false;
        boolean rexternal = false;
        String colorGroup = null;
        boolean colorChange = false;
        String fontGroup = null;
        boolean fontChange = false;
        String sizeGroup = null;
        boolean sizeChange = false;
        String comment = null;
        while (matcher.find()) {
            char ch;
            from = matcher.start();
            group = matcher.group();
            if (!notes.isEmpty() && group.startsWith("<row ") && (comment = (String)notes.get(group)) != null && comment.length() > 0) {
                comment = XMLHelper.parseTagsContent(comment);
            }
            if (group.endsWith("Style w:val=\"tw4winExternal\"/>") || !this.isUncleaned && group.startsWith("<w:vanish")) {
                if (group.startsWith("<w:rStyle") || wrProp) {
                    rexternal = true;
                    change = true;
                } else {
                    pexternal = true;
                }
            }
            if (group.equals("</w:p>") || group.equals("</si>")) {
                if (!isPicture) {
                    pexternal = false;
                    rexternal = false;
                }
                sizeGroup = null;
                colorGroup = null;
                fontGroup = null;
                wpPropStyle = 0;
            }
            if (group.startsWith("<t") && ((ch = group.charAt(2)) == '>' || ch == ' ')) {
                if (colorGroup != null && !colorChange) {
                    colorGroup = null;
                    change = true;
                }
                if (fontGroup != null && !fontChange) {
                    fontGroup = null;
                    change = true;
                }
                if (sizeGroup != null && !sizeChange) {
                    sizeGroup = null;
                    change = true;
                }
            }
            if (group.equals("<rPr>")) {
                if (!isPicture) {
                    rexternal = false;
                }
                wrProp = true;
            } else if (group.equals("</rPr>")) {
                wrProp = false;
                wrPropStyle = 0;
            } else if (group.equals("</r>")) {
                if (!isPicture) {
                    rexternal = false;
                }
                colorChange = false;
                fontChange = false;
                sizeChange = false;
            } else if (group.equals("<w:pPr>")) {
                wpProp = true;
            } else if (group.equals("</w:pPr>")) {
                wpProp = false;
                wstyle = 0;
                wrstyle = false;
            } else if (group.equals("<t xml:space=\"preserve\">")) {
                docSpace = true;
            } else if (group.indexOf("<w:tab") != -1 || group.equals("</si>") || group.equals("</w:p>") || group.equals("<w:br/>") || group.indexOf("<w:footnoteReference") != -1 || group.indexOf("<w:endnoteReference") != -1 || group.indexOf("<w:fldChar") != -1 || group.indexOf("<w:noBreakHyphen/>") != -1) {
                format = 0;
                wstyle = 0;
            } else if (group.equals("<b/>")) {
                if (wrPropStyle > 0 || lastGroup.equals("<i/>") || lastGroup.equals("<u/>")) {
                    change = (wstyle += 2) != textStyle;
                } else if (wstyle != 2 && wstyle != 6 && wstyle != 10 && wstyle != 14) {
                    change = true;
                    wstyle = 2;
                } else {
                    wstyle = 2;
                }
                if (wrProp) {
                    wrPropStyle = 2;
                }
                if (wpProp) {
                    wpPropStyle += 2;
                }
            } else if (group.equals("<i/>")) {
                if (wrPropStyle > 0 || lastGroup.equals("<b/>") || lastGroup.equals("<u/>")) {
                    change = (wstyle += 4) != textStyle;
                } else if (wstyle != 4 && wstyle != 6 && wstyle != 12 && wstyle != 14) {
                    change = true;
                    wstyle = 4;
                } else {
                    wstyle = 4;
                }
                if (wrProp) {
                    wrPropStyle = 4;
                }
                if (wpProp) {
                    wpPropStyle += 4;
                }
            } else if (group.equals("<u/>") || group.startsWith("<w:rStyle w:val=\"Hyperlink\"") || group.startsWith("<w:hlink ")) {
                if (wrPropStyle > 0 || lastGroup.equals("<b/>") || lastGroup.equals("<i/>")) {
                    change = (wstyle += 8) != textStyle;
                } else if (wstyle != 8 && wstyle != 10 && wstyle != 12 && wstyle != 14) {
                    change = true;
                    wstyle = 8;
                } else {
                    wstyle = 8;
                }
                if (wrProp) {
                    wrPropStyle = 8;
                }
                if (wpProp) {
                    wpPropStyle += 8;
                }
            } else if (group.startsWith("<w:vertAlign w:val=\"subscript\"")) {
                wstyle = 16;
                format = 0;
            } else if (group.startsWith("<w:vertAlign w:val=\"superscript\"")) {
                wstyle = 18;
                format = 0;
            } else if (group.equals("<w:strike/>")) {
                wstyle = 20;
                format = 0;
            } else if (group.equals("<w:caps/>")) {
                wstyle = 22;
                format = 0;
            } else if (group.equals("<w:smallCaps/>")) {
                wstyle = 24;
                format = 0;
            } else if (group.startsWith("<color") || group.startsWith("<w:highlight") || group.startsWith("<w:shd")) {
                int j;
                int i = group.indexOf("rgb=\"");
                if (i != -1 && (j = group.indexOf(34, i + 5)) != -1) {
                    String c = group.substring(i + 5, j);
                    if (c.length() > 7) {
                        c = c.substring(2);
                    }
                    wcolor = c;
                }
                if (colorGroup == null || !group.equals(colorGroup)) {
                    change = true;
                }
                colorGroup = group;
                colorChange = true;
            } else if (group.startsWith("<rFont")) {
                if (fontGroup == null || !group.equals(fontGroup)) {
                    change = true;
                }
                fontGroup = group;
                fontChange = true;
            } else if (group.startsWith("<szCs ") || group.startsWith("<sz ")) {
                String val = group.substring(group.indexOf(32) + 1);
                if (sizeGroup == null || !val.equals(sizeGroup)) {
                    change = true;
                }
                sizeGroup = val;
                sizeChange = true;
            } else if (group.startsWith("<w:txbxContent>") || group.startsWith("<w:sym ")) {
                change = true;
            } else if (group.equals("<w:drawing>") || group.equals("<w:pict>")) {
                isPicture = true;
            } else if (group.equals("</w:drawing>") || group.equals("</w:pict>")) {
                isPicture = false;
                change = true;
            }
            if (to == from) {
                inline.append(group);
                fgr.append(group);
                to = matcher.end();
            } else {
                String match = xhtml.substring(to, from);
                if (pexternal || rexternal) {
                    inline.append(match);
                    inline.append(group);
                    fgr.append(match);
                    fgr.append(group);
                    to = matcher.end();
                    continue;
                }
                String aftbreak = fgr.toString();
                if (wstyle > 0 && fgr.indexOf("<b/>") == -1 && fgr.indexOf("<i/>") == -1 && fgr.indexOf("<u/>") == -1 && fgr.indexOf("<w:hlink ") == -1 && fgr.indexOf("<w:rStyle w:val=\"Hyperlink\"") == -1 && fgr.indexOf("<w:vertAlign") == -1 && fgr.indexOf("<w:strike/>") == -1 && fgr.indexOf("<w:caps/>") == -1 && fgr.indexOf("<w:smallCaps/>") == -1) {
                    wstyle = 0;
                    change = true;
                }
                if (!(wrstyle || this.isUncleaned || change || format != -1 || match.length() <= 0 || !aftbreak.startsWith("</t></r><r") && !aftbreak.startsWith("</t></r><w:proofErr"))) {
                    match = XMLHelper.resolveEntitiesXML(match);
                    coll.append(match);
                    fgr.setLength(0);
                    inline.append(group);
                    fgr.append(group);
                    to = matcher.end();
                    change = false;
                    lastGroup = group;
                    continue;
                }
                int i = aftbreak.indexOf("<w:rStyle ");
                if (i == -1) {
                    i = aftbreak.indexOf("<w:vertAlign");
                }
                if (i != -1) {
                    if (aftbreak.indexOf("</r>", i) == -1) {
                        wrstyle = true;
                    } else {
                        wrstyle = false;
                        wstyle = 0;
                    }
                } else {
                    wrstyle = false;
                }
                if (match.trim().length() > 0) {
                    String s;
                    if (!hasContent) {
                        hasContent = true;
                    }
                    match = XMLHelper.resolveEntitiesXML(match);
                    StringBuilder typebuilder = new StringBuilder();
                    String equivtext = null;
                    if (isPage) {
                        typebuilder.append("page");
                        isPage = false;
                    } else if (AppPreferences.segmentTags || this.isBreak(inline)) {
                        typebuilder.append("break");
                        equivtext = " ";
                    }
                    int style = wpPropStyle > 0 ? wpPropStyle : wstyle;
                    if (style > 0 && (s = this.createStyleAttribute(style)) != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append(s);
                    }
                    if (wcolor != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append("fcolor:" + wcolor);
                        wcolor = null;
                    }
                    StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                    tagbuilder.append(index);
                    tagbuilder.append("\"");
                    if (typebuilder.length() > 0) {
                        tagbuilder.append(" ctype=\"x-");
                        tagbuilder.append((CharSequence)typebuilder);
                        tagbuilder.append("\"");
                    }
                    if (equivtext != null) {
                        tagbuilder.append(" equiv-text=\"");
                        tagbuilder.append(equivtext);
                        tagbuilder.append("\"");
                    }
                    tagbuilder.append("/>");
                    this.tags = tagbuilder.toString();
                    ++index;
                    skeleton.put(this.tags, inline.toString());
                    this.styles.put(this.tags, style);
                    if (comment != null) {
                        this.comments.put(this.tags, comment);
                        comment = null;
                    }
                    textStyle = wstyle;
                    inline.setLength(0);
                    fgr.setLength(0);
                    if (coll.length() > 0) {
                        content.append(coll.toString());
                        coll.setLength(0);
                    }
                    content.append(this.tags);
                    if (standaloneSpace != null) {
                        content.append(standaloneSpace);
                    }
                    content.append(match);
                    inline.append(group);
                    fgr.append(group);
                    change = false;
                    format = -1;
                    docSpace = false;
                    standaloneSpace = null;
                } else {
                    if (match.length() > 0 && (content.length() > 0 || docSpace)) {
                        standaloneSpace = match;
                    }
                    inline.append(group);
                    fgr.append(group);
                }
                to = matcher.end();
            }
            lastGroup = group;
        }
        if (!hasContent) {
            return "";
        }
        if (coll.length() > 0) {
            content.append(coll.toString());
            coll.setLength(0);
        }
        if (inline.length() > 0) {
            String tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            if (wpPropStyle > 0) {
                this.styles.put(tags, wpPropStyle);
            } else {
                this.styles.put(tags, wstyle);
            }
            content.append(tags);
        }
        this.tagIndex = index;
        return content.toString();
    }

    public boolean isBilingual() {
        return this.isBilingual;
    }

    public String getSourceAndTargetContent() {
        return this.bilingualContent;
    }

    boolean isBreak(StringBuffer group) {
        boolean br = false;
        if (group.indexOf("<w:tab") != -1 || group.indexOf("</w:p>") != -1 || group.indexOf("<w:br/>") != -1 || group.indexOf("</Data>") != -1 || group.indexOf("</si>") != -1 || group.indexOf("<w:txbxContent>") != -1) {
            br = true;
        }
        return br;
    }

    private void setBilingualContent(Project project) {
        List units = project.getXLIFF().getCurrentFile().getBody().getTransUnits();
        for (XLIFFUnit tu : units) {
            XMLElement target;
            String tcontent;
            int i;
            int rid;
            Row row;
            Sheet sheet;
            int sid;
            String sheetID = tu.getAttribute("resname");
            String rowID = tu.getAttribute("id");
            if (sheetID == null || rowID == null || (sid = Integer.parseInt(sheetID)) >= this.sheets.size() || (sheet = (Sheet)this.sheets.get(sid)) == null || (row = sheet.getRow(rid = Integer.parseInt(rowID))) == null || row.isHidden() || (i = (tcontent = (target = tu.getTarget()).getXMLFormat()).indexOf(62) + 1) >= tcontent.length()) continue;
            int j = tcontent.lastIndexOf(60);
            if ((tcontent = tcontent.substring(i, j)).length() > 0) {
                row.setBilinugalTarget(tcontent);
                continue;
            }
            row.clearTargetColumn();
        }
    }

    private void parseSheetProperties(String xmlString, List sheetProps) {
        Pattern pattern = Pattern.compile("<sheet .+?/>");
        Matcher matcher = pattern.matcher(xmlString);
        while (matcher.find()) {
            String group = matcher.group();
            sheetProps.add(group);
        }
    }

    private void parseSharedStrings(String xmlString, List ss) {
        Pattern pattern = Pattern.compile("<si>.+?</si>", 32);
        Matcher matcher = pattern.matcher(xmlString);
        int count = 0;
        int end = 0;
        while (matcher.find()) {
            if (count == 0) {
                int start = matcher.start();
                this.sharedStringXMLStart = xmlString.substring(0, start);
            }
            String group = matcher.group();
            ss.add(group);
            end = matcher.end();
            ++count;
        }
        this.sharedStringXMLEnd = xmlString.substring(end);
    }

    private String parseShareStringsOut() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sharedStringXMLStart);
        String forcedRunMarker = "<t>!!";
        Iterator it = this.sharedStrings.iterator();
        while (it.hasNext()) {
            String s = it.next().toString();
            int j = s.indexOf(forcedRunMarker);
            boolean runForced = false;
            while (j != -1) {
                StringBuffer sb2 = new StringBuffer(s);
                int k = (sb2 = sb2.replace(j, j + 5, "<r><t>")).indexOf("</t>", j);
                if (k == -1) break;
                sb2 = sb2.replace(k, k + 4, "</t></r>");
                s = sb2.toString();
                j = s.indexOf(forcedRunMarker, k);
                runForced = true;
            }
            if (runForced) {
                s = s.replace("<t>", "<t xml:space=\"preserve\">");
            }
            sb.append(s);
        }
        sb.append(this.sharedStringXMLEnd);
        return sb.toString();
    }

    private void parseHiddenCells(String xmlString) {
        Pattern patternNumberFormat = Pattern.compile("<numFmt .+?/>", 2);
        String nformat = null;
        Matcher mf = patternNumberFormat.matcher(xmlString);
        while (mf.find()) {
            int j;
            String g = mf.group();
            int i = g.indexOf("formatCode=\";;;\"");
            if (i == -1 || (j = g.indexOf("numFmtId=\"")) == -1) continue;
            int k = g.indexOf("\"", j + 10);
            nformat = g.substring(j, k + 1);
            break;
        }
    }

    private void parseSheetsInput(String xmlString, String zipName) {
        try {
            SAXParser parser = MSExcelDocument.getParser();
            ExcelSheetInputHandler handler = new ExcelSheetInputHandler(this, this.sheets, zipName);
            StringReader reader = new StringReader(xmlString);
            InputSource is = new InputSource();
            is.setCharacterStream(reader);
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (SAXException ex) {
            JOptionPane.showMessageDialog(null, ex.toString());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ex.toString());
        }
    }

    private void parseSheetsOutput(String[] xmlStrings) {
        try {
            int j = 0;
            SAXParser parser = MSExcelDocument.getParser();
            for (int i = 0; i < xmlStrings.length; ++i) {
                String string = xmlStrings[i];
                if (string == null || !string.startsWith("<sheet>")) continue;
                Sheet sheet = (Sheet)this.sheets.get(j);
                ExcelSheetOutputHandler handler = new ExcelSheetOutputHandler(sheet);
                StringReader reader = new StringReader(string);
                InputSource is = new InputSource();
                is.setCharacterStream(reader);
                parser.parse(is, (DefaultHandler)handler);
                ++j;
            }
        }
        catch (SAXException ex) {
            JOptionPane.showMessageDialog(null, ex.toString());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ex.toString());
        }
    }

    public static SAXParser getParser() {
        SAXParser saxParser = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            saxParser = factory.newSAXParser();
        }
        catch (SAXException ex) {
            Logger.getLogger(XMLHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(XMLHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
        return saxParser;
    }

    public void toMemory(Memory memory) {
        String tlang;
        String slang = memory.getSourceLangCode();
        int i = slang.indexOf(45);
        if (i != -1) {
            slang = slang.substring(0, i);
        }
        if ((i = (tlang = memory.getTargetLangCode()).indexOf(45)) != -1) {
            tlang = tlang.substring(0, i);
        }
        boolean readOnly = memory.isReadOnly();
        TMX tmx = memory.getTMX();
        TMXReadOnlyUnitMap romap = null;
        if (readOnly) {
            romap = (TMXReadOnlyUnitMap)tmx.getTUMap();
        }
        Pattern patternRow = Pattern.compile("<row.+?</row>", 34);
        Pattern patternColumn = Pattern.compile("<c .+?</c>", 34);
        Pattern patternTags = Pattern.compile("<.+?>", 34);
        for (Sheet sheet : this.sheets) {
            if (sheet.isHidden()) continue;
            String s = sheet.getSourceContent("", "", "");
            Matcher mr = patternRow.matcher(s);
            while (mr.find()) {
                String r = mr.group();
                Matcher mc = patternColumn.matcher(r);
                int end = 0;
                int count = 0;
                String source = "";
                String target = "";
                while (mc.find()) {
                    String c = mc.group();
                    Matcher mt = patternTags.matcher(c);
                    StringBuilder sb = new StringBuilder();
                    while (mt.find()) {
                        int start = mt.start();
                        if (start >= end) {
                            String content = c.substring(end, start);
                            sb.append(content);
                        }
                        end = mt.end();
                    }
                    if (end < c.length()) {
                        sb.append(c.substring(end));
                    }
                    if (count == 0) {
                        source = sb.toString();
                    } else if (count == 1) {
                        target = sb.toString();
                        break;
                    }
                    ++count;
                }
                if (source.length() <= 0 || target.length() <= 0) continue;
                source = XMLHelper.resolveEntitiesXML(source);
                target = XMLHelper.resolveEntitiesXML(target);
                if (romap != null) {
                    TMXReadOnlyUnit tu = new TMXReadOnlyUnit();
                    tu.setSegment(slang, source);
                    tu.setSegment(tlang, target);
                    romap.load(tu);
                    continue;
                }
                int dup = memory.getDuplicatesMode();
                tmx.update(source, target, null, null, null, dup);
                memory.setNewTU();
            }
        }
    }

    public void toGlossary(GlossaryResource glossary) {
        Pattern patternRow = Pattern.compile("<row.+?</row>", 34);
        Pattern patternColumn = Pattern.compile("<c .+?</c>", 34);
        Pattern patternTags = Pattern.compile("<.+?>", 34);
        for (Sheet sheet : this.sheets) {
            if (sheet.isHidden()) continue;
            String s = sheet.getSourceContent("", "", "");
            Matcher mr = patternRow.matcher(s);
            while (mr.find()) {
                String r = mr.group();
                Matcher mc = patternColumn.matcher(r);
                int end = 0;
                int count = 0;
                String source = "";
                String target = "";
                while (mc.find()) {
                    String c = mc.group();
                    Matcher mt = patternTags.matcher(c);
                    StringBuilder sb = new StringBuilder();
                    while (mt.find()) {
                        int start = mt.start();
                        if (start >= end) {
                            String content = c.substring(end, start);
                            sb.append(content);
                        }
                        end = mt.end();
                    }
                    if (end < c.length()) {
                        sb.append(c.substring(end));
                    }
                    if (count == 0) {
                        source = sb.toString();
                    } else if (count == 1) {
                        target = sb.toString();
                        break;
                    }
                    ++count;
                }
                if (source.length() <= 0 || target.length() <= 0) continue;
                source = XMLHelper.resolveEntitiesXML(source);
                target = XMLHelper.resolveEntitiesXML(target);
                glossary.updateDictionary(source, target, null);
                glossary.addToSourceMap();
            }
        }
    }

    @Override
    public void preview(Project pr, String spath) {
        Document sdoc = this.getDocument();
        String path = (String)sdoc.getProperty("path");
        PlainDocument tdoc = null;
        if (this.isBilingual) {
            this.setBilingualContent(pr);
        } else {
            String prev;
            XLIFF xliff = pr.getXLIFF();
            if (xliff != null) {
                xliff.setEmptyTargetSegments(true);
            }
            if ((prev = pr.preview(sdoc)) != null) {
                tdoc = new PlainDocument();
                try {
                    tdoc.insertString(0, prev, null);
                    if (sdoc.getProperty("skeleton") != null) {
                        LinkedHashMap skeleton = (LinkedHashMap)sdoc.getProperty("skeleton");
                        tdoc.putProperty("skeleton", skeleton);
                    }
                    if (sdoc.getProperty("zname") != null) {
                        String name = (String)sdoc.getProperty("zname");
                        tdoc.putProperty("zname", name);
                    }
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                return;
            }
        }
        if (path != null) {
            String prevFilePath;
            File file = new File(path);
            String name = file.getName();
            int i = name.lastIndexOf(".");
            String extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
            String parent = file.getParent();
            if (spath == null) {
                prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
            } else {
                prevFilePath = spath.toLowerCase().endsWith(extention) ? spath : spath + extention;
                if (prevFilePath.equalsIgnoreCase(path)) {
                    JOptionPane.showMessageDialog(this.topui, "Never overwrite the original source language document!");
                    return;
                }
            }
            File previewFile = new File(prevFilePath);
            boolean save = this.saveZipXMLFile(previewFile, file, tdoc);
            if (!save) {
                this.preview2(pr, spath);
            } else if (spath == null) {
                this.topui.getResourceView().viewFile(previewFile);
            }
        }
    }

    @Override
    public void preview2(Project pr, String spath) {
        String name;
        Document sdoc = this.getDocument();
        String path = (String)sdoc.getProperty("path");
        PlainDocument tdoc = null;
        if (this.isBilingual) {
            return;
        }
        String prev = pr.preview2(sdoc);
        if (prev != null) {
            tdoc = new PlainDocument();
            try {
                tdoc.insertString(0, prev, null);
                if (sdoc.getProperty("skeleton") != null) {
                    LinkedHashMap skeleton = (LinkedHashMap)sdoc.getProperty("skeleton");
                    tdoc.putProperty("skeleton", skeleton);
                }
                if (sdoc.getProperty("zname") != null) {
                    name = (String)sdoc.getProperty("zname");
                    tdoc.putProperty("zname", name);
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            return;
        }
        if (path != null) {
            String prevFilePath;
            File file = new File(path);
            name = file.getName();
            int i = name.lastIndexOf(".");
            String extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
            String parent = file.getParent();
            if (spath == null) {
                prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
            } else {
                prevFilePath = spath.toLowerCase().endsWith(extention) ? spath : spath + extention;
                if (prevFilePath.equalsIgnoreCase(path)) {
                    JOptionPane.showMessageDialog(this.topui, "Never overwrite the original source language document!");
                    return;
                }
            }
            File previewFile = new File(prevFilePath);
            boolean save = this.saveZipXMLFile(previewFile, file, tdoc);
            if (save && spath == null) {
                this.topui.getResourceView().viewFile(previewFile);
            }
        }
    }

    private boolean saveZipXMLFile(File newFile, File oldFile, Document doc) {
        try {
            ZipFile zipFile = oldFile == null ? new ZipFile(newFile) : new ZipFile(oldFile);
            String[] texts = new String[this.sheets.size() + this.zipNames.size() + 1];
            String[] names = new String[this.sheets.size() + this.zipNames.size() + 1];
            int index = 0;
            if (doc != null) {
                String[] ts = this.insertContent(doc);
                if (ts == null) {
                    JOptionPane.showMessageDialog(this.topui, "The original source language document has been modified. Export may fail or be incomplete.");
                    return false;
                }
                for (String zname : this.zipNames) {
                    String out;
                    if (index >= ts.length || (out = ts[index]) == null || out.startsWith("<sheet>")) continue;
                    texts[index] = out;
                    names[index] = zname;
                    ++index;
                }
                this.parseSheetsOutput(ts);
            }
            for (Sheet sheet : this.sheets) {
                String xml;
                texts[index] = xml = sheet.getXMLFormat();
                names[index] = sheet.getName();
                ++index;
            }
            texts[index] = this.parseShareStringsOut();
            names[index] = "xl/sharedStrings.xml";
            File tempFile = File.createTempFile("Exp", newFile.getName(), newFile.getParentFile());
            this.storeZipFile(tempFile, zipFile, names, texts);
            if (newFile.exists()) {
                newFile.delete();
            }
            if (tempFile.renameTo(newFile)) {
                if (doc != null) {
                    Boolean state = false;
                    doc.putProperty("state", state);
                }
            } else {
                JOptionPane.showMessageDialog(this.topui, "CafeTran cannot rename the file to " + newFile.getName());
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, e.getMessage());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, "The original source language document has been modified. Export may fail or be incomplete.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeZipFile(File tempFile, ZipFile zipFile, String[] names, String[] texts) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tempFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            byte[] buffer = new byte[1024];
            InputStream is = null;
            while (entries.hasMoreElements()) {
                int bytesRead;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String oname = entry.getName();
                boolean con = false;
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    if (!oname.equals(name)) continue;
                    con = true;
                }
                if (con) continue;
                is = zipFile.getInputStream(entry);
                zos.putNextEntry(new ZipEntry(oname));
                while ((bytesRead = is.read(buffer)) != -1) {
                    zos.write(buffer, 0, bytesRead);
                }
            }
            if (is != null) {
                is.close();
            }
            zipFile.close();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                ZipEntry entry = new ZipEntry(name);
                zos.putNextEntry(entry);
                String text = texts[i];
                byte[] buf = text.getBytes("UTF-8");
                zos.write(buf, 0, buf.length);
            }
            zos.close();
        }
        catch (IOException ex) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    String getPPContent(String xhtml, LinkedHashMap skeleton, String aformat) {
        this.isXML = true;
        Pattern p = Pattern.compile(aformat, 34);
        Matcher matcher = p.matcher(xhtml);
        StringBuffer content = new StringBuffer();
        String group = "";
        String lastGroup = "";
        int from = 0;
        int to = 0;
        int index = this.tagIndex;
        boolean hasContent = false;
        boolean isPage = false;
        if (index > 0) {
            isPage = true;
        }
        ++index;
        StringBuffer inline = new StringBuffer();
        StringBuffer fgr = new StringBuffer();
        StringBuffer coll = new StringBuffer();
        int format = -1;
        int wstyle = 0;
        boolean change = false;
        boolean docSpace = false;
        String colorGroup = null;
        boolean colorChange = false;
        boolean ap = false;
        while (matcher.find()) {
            from = matcher.start();
            group = matcher.group();
            if (group.startsWith("<a:rPr")) {
                int gi = group.indexOf(" b=");
                if (gi != -1 && group.charAt(gi + 4) != '0') {
                    if (wstyle != 2 && wstyle != 14) {
                        change = true;
                        wstyle = 2;
                    } else {
                        wstyle = 2;
                    }
                }
                if ((gi = group.indexOf(" i=")) != -1 && group.charAt(gi + 4) != '0') {
                    if (wstyle != 4) {
                        change = true;
                        wstyle += 4;
                    } else {
                        wstyle = 4;
                    }
                }
                if ((gi = group.indexOf(" u=")) != -1 && group.charAt(gi + 4) != 'n') {
                    if (wstyle != 8) {
                        change = true;
                        wstyle += 8;
                    } else {
                        wstyle = 8;
                    }
                }
            } else if (group.startsWith("<a:t")) {
                char ch = group.charAt(4);
                if (!(ch != '>' && ch != ' ' || colorGroup == null || colorChange)) {
                    colorGroup = null;
                    change = true;
                }
            } else if (group.equals("</a:r>")) {
                colorChange = false;
            } else if (group.equals("</a:bodyPr>")) {
                wstyle = 0;
            } else if (group.equals("<a:p>")) {
                ap = true;
                colorGroup = null;
                colorChange = false;
            } else if (group.equals("</a:p>") || group.equals("<a:br/>")) {
                format = 0;
                wstyle = 0;
                ap = false;
            } else if (ap && group.startsWith("<a:srgbClr")) {
                if (colorGroup == null || !group.equals(colorGroup)) {
                    change = true;
                }
                colorGroup = group;
                colorChange = true;
            }
            if (to == from) {
                inline.append(group);
                fgr.append(group);
                to = matcher.end();
            } else {
                String match = xhtml.substring(to, from);
                String aftbreak = fgr.toString();
                if (wstyle > 0 && fgr.indexOf(" b=") == -1 && fgr.indexOf(" i=") == -1 && fgr.indexOf(" u=") == -1 && fgr.indexOf("<w:hlink ") == -1 && fgr.indexOf("<w:rStyle w:val=\"Hyperlink\"") == -1) {
                    wstyle = 0;
                    change = true;
                }
                if (!this.isUncleaned && !change && format == -1 && match.length() > 0 && aftbreak.startsWith("</a:t></a:r><a:r")) {
                    match = XMLHelper.resolveEntitiesXML(match);
                    coll.append(match);
                    fgr.setLength(0);
                    inline.append(group);
                    fgr.append(group);
                    to = matcher.end();
                    change = false;
                    lastGroup = group;
                    continue;
                }
                if (match.trim().length() > 0) {
                    String s;
                    if (!hasContent) {
                        hasContent = true;
                    }
                    match = XMLHelper.resolveEntitiesXML(match);
                    StringBuilder typebuilder = new StringBuilder();
                    String equivtext = null;
                    if (isPage) {
                        typebuilder.append("page");
                        isPage = false;
                    } else if (AppPreferences.segmentTags || this.isPPBreak(inline)) {
                        typebuilder.append("break");
                        equivtext = " ";
                    }
                    if (wstyle > 0 && (s = this.createStyleAttribute(wstyle)) != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append(s);
                    }
                    StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                    tagbuilder.append(index);
                    tagbuilder.append("\"");
                    if (typebuilder.length() > 0) {
                        tagbuilder.append(" ctype=\"x-");
                        tagbuilder.append((CharSequence)typebuilder);
                        tagbuilder.append("\"");
                    }
                    if (equivtext != null) {
                        tagbuilder.append(" equiv-text=\"");
                        tagbuilder.append(equivtext);
                        tagbuilder.append("\"");
                    }
                    tagbuilder.append("/>");
                    String tags = tagbuilder.toString();
                    ++index;
                    skeleton.put(tags, inline.toString());
                    this.styles.put(tags, wstyle);
                    inline.setLength(0);
                    fgr.setLength(0);
                    if (coll.length() > 0) {
                        content.append(coll.toString());
                        coll.setLength(0);
                    }
                    content.append(tags);
                    content.append(match);
                    inline.append(group);
                    fgr.append(group);
                    change = false;
                    format = -1;
                    docSpace = false;
                } else {
                    if (match.length() > 0 && content.length() > 0) {
                        inline.append(match);
                    }
                    inline.append(group);
                    fgr.append(group);
                }
                to = matcher.end();
            }
            lastGroup = group;
        }
        if (!hasContent) {
            return "";
        }
        if (coll.length() > 0) {
            content.append(coll.toString());
            coll.setLength(0);
        }
        if (inline.length() > 0) {
            String tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            this.styles.put(tags, wstyle);
            content.append(tags);
        }
        this.tagIndex = index;
        return content.toString();
    }

    boolean isPPBreak(StringBuffer group) {
        boolean br = false;
        if (group.indexOf("</a:p>") != -1 || group.indexOf("<a:br/>") != -1 || group.indexOf("</Data>") != -1 || group.indexOf("</t>") != -1 || group.indexOf("</p:cm>") != -1) {
            br = true;
        }
        return br;
    }

    public Map getCommentsMap() {
        return this.comments;
    }
}

