/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.text.GapContent;
import javax.swing.text.StyleContext;
import translator.AppPreferences;
import translator.FormatChooser;
import translator.NaturalOrderComparator;
import translator.Project;
import translator.Translatable;
import translator.XMLHelper;
import translator.text.ParagraphStyledDocument;
import translator.tmx.TMX;
import translator.translatables.IndesignIDMLDocument;
import translator.translatables.ZipDocument;
import translator.xliff.XLIFF;

public class MSOfficeDocumentReview
extends ZipDocument
implements Translatable {
    int tagIndex = 0;
    private int documentType;
    private String skeleton;
    private String docPath;
    private String tags;

    public MSOfficeDocumentReview() {
        this.isWord = true;
    }

    public int getDocumentType() {
        return this.documentType;
    }

    public boolean importToProject(Project pr) {
        XLIFF xliff = pr.getXLIFF();
        TMX tmx = pr.getTMX();
        if (xliff != null) {
            boolean b = xliff.importBilingualFromWord(this.skeleton);
            return b;
        }
        if (tmx != null) {
            boolean b = tmx.importBilingualFromWord(this.skeleton);
            return b;
        }
        return false;
    }

    public boolean exportForReview(Project pr, String spath, boolean notes) {
        String prev;
        String pname = pr.getName();
        XLIFF xliff = pr.getXLIFF();
        if (xliff != null) {
            prev = xliff.exportBilingualToWord(pname, notes);
        } else {
            TMX tmx = pr.getTMX();
            if (tmx != null) {
                prev = tmx.exportBilingualToWord(pname, notes);
            } else {
                return false;
            }
        }
        StringBuilder sb = new StringBuilder(this.skeleton);
        int k = sb.indexOf("</w:tblPr>");
        if (k != -1) {
            sb = sb.insert(k + 10, prev);
        }
        if (prev != null && this.docPath != null) {
            String prevFilePath;
            File file = new File(this.docPath);
            String name = file.getName();
            int i = name.lastIndexOf(".");
            String extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
            String parent = file.getParent();
            if (spath == null) {
                prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
            } else {
                prevFilePath = spath.endsWith(extention) ? spath : spath + extention;
                if (prevFilePath.equalsIgnoreCase(this.docPath)) {
                    return false;
                }
            }
            File previewFile = new File(prevFilePath);
            boolean save = this.saveZipXMLReviewFile(previewFile, file, sb.toString());
            if (save && spath == null) {
                this.topui.getResourceView().viewFile(previewFile);
            }
            return true;
        }
        return false;
    }

    private boolean saveZipXMLReviewFile(File newFile, File oldFile, String content) {
        try {
            ZipFile zipFile = oldFile == null ? new ZipFile(newFile) : new ZipFile(oldFile);
            String[] texts = new String[]{content};
            File tempFile = File.createTempFile("Exp", newFile.getName(), newFile.getParentFile());
            String[] names = new String[this.zipNames.size()];
            int index = 0;
            Iterator it = this.zipNames.iterator();
            while (it.hasNext()) {
                String zname;
                names[index] = zname = (String)it.next();
                ++index;
            }
            this.storeZipFile(tempFile, zipFile, names, texts);
            if (newFile.exists()) {
                newFile.delete();
            }
            if (!tempFile.renameTo(newFile)) {
                JOptionPane.showMessageDialog(this.topui, "CafeTran cannot rename the file to " + newFile.getName());
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, e.getMessage());
            return false;
        }
    }

    @Override
    public void loadFile(File file, String format, String encoding, String zName) {
        ZipFile zipFile;
        if (format.equals("Ms Word (*.docx/xml)")) {
            this.documentType = 0;
        }
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<? extends ZipEntry> list = Collections.list(entries);
        if (list.size() > 1) {
            Collections.sort(list, new NaturalOrderComparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    ZipEntry entry1 = (ZipEntry)o1;
                    ZipEntry entry2 = (ZipEntry)o2;
                    String s1 = entry1.getName();
                    String s2 = entry2.getName();
                    return super.compare(s1, s2);
                }
            });
        }
        for (ZipEntry zipEntry : list) {
            String zipname;
            String outString;
            String s = zipEntry.getName();
            if (!s.equals("word/document.xml") || (outString = this.loadZipFile(zipFile, zipname = s, encoding)).trim().length() <= 0) continue;
            this.skeleton = outString;
            this.zipNames.add(zipname);
        }
        try {
            zipFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(IndesignIDMLDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.docPath = file.getPath();
    }

    @Override
    public void openFile(File file, String format, String encoding, String zName) {
        ZipFile zipFile;
        this.setCustomFormatMap(format);
        String regExp = FormatChooser.getFormatRegEx(format);
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<? extends ZipEntry> list = Collections.list(entries);
        if (list.size() > 1) {
            Collections.sort(list, new NaturalOrderComparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    ZipEntry entry1 = (ZipEntry)o1;
                    ZipEntry entry2 = (ZipEntry)o2;
                    String s1 = entry1.getName();
                    String s2 = entry2.getName();
                    return super.compare(s1, s2);
                }
            });
        }
        ArrayList<String> stories = new ArrayList<String>();
        int len = 0;
        for (ZipEntry zipEntry : list) {
            String s = zipEntry.getName();
            if (!s.equals("word/document.xml") && !s.equals("word/footnotes.xml") && !s.equals("word/endnotes.xml") && !s.equals("xl/sharedStrings.xml") && !s.startsWith("word/header") && !s.startsWith("word/footer") && !s.startsWith("ppt/slides/slide")) continue;
            String zipname = s;
            String outString = this.loadZipFile(zipFile, zipname, encoding);
            LinkedHashMap skeleton = null;
            if (regExp.length() <= 0 || (outString = this.getContent(outString, skeleton = new LinkedHashMap(), regExp)).trim().length() <= 0) continue;
            len += outString.length();
            this.skeletons.add(skeleton);
            stories.add(outString);
            this.zipNames.add(zipname);
        }
        try {
            zipFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(IndesignIDMLDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        GapContent gap = new GapContent(len);
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String string = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", string);
        this.doc.putProperty("name", name);
        String loadedPath = string;
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(loadedPath)) {
            docs.add(loadedPath);
        }
        this.openEditorTab(this.doc);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
        this.setDocumentProperties(this.doc);
    }

    @Override
    String getContent(String xhtml, LinkedHashMap skeleton, String aformat) {
        this.isXML = true;
        if (aformat.startsWith("#")) {
            aformat = aformat.substring(1);
            this.isUncleaned = true;
        } else {
            this.isUncleaned = false;
        }
        Pattern p = Pattern.compile(aformat, 34);
        Matcher matcher = p.matcher(xhtml);
        StringBuilder content = new StringBuilder();
        String group = "";
        String lastGroup = "";
        int from = 0;
        int to = 0;
        int index = this.tagIndex;
        String standaloneSpace = null;
        boolean hasContent = false;
        boolean isPage = false;
        if (index > 0) {
            isPage = true;
        }
        boolean isPicture = false;
        ++index;
        StringBuffer inline = new StringBuffer();
        StringBuilder fgr = new StringBuilder();
        StringBuilder coll = new StringBuilder();
        int format = -1;
        int wstyle = 0;
        int textStyle = 0;
        boolean wrstyle = false;
        boolean wrProp = false;
        int wrPropStyle = 0;
        boolean wpProp = false;
        int wpPropStyle = 0;
        boolean change = false;
        boolean docSpace = false;
        boolean pexternal = false;
        boolean rexternal = false;
        String colorGroup = null;
        boolean colorChange = false;
        String fontGroup = null;
        boolean fontChange = false;
        String sizeGroup = null;
        boolean sizeChange = false;
        boolean XE = false;
        while (matcher.find()) {
            char ch;
            from = matcher.start();
            group = matcher.group();
            if (group.startsWith("<w:instrText")) {
                if (group.indexOf("XE \"<") != -1) {
                    XE = true;
                } else if (XE) {
                    int j;
                    XE = false;
                    int i = group.indexOf(62) + 1;
                    String m = group.substring(i, j = group.indexOf(60, i));
                    if (m.trim().length() > 0) {
                        String s;
                        if (!hasContent) {
                            hasContent = true;
                        }
                        String sgroup = group.substring(0, i);
                        String ssgroup = group.substring(j);
                        inline.append(sgroup);
                        StringBuilder typebuilder = new StringBuilder();
                        String equivtext = null;
                        if (isPage) {
                            typebuilder.append("page");
                            isPage = false;
                        } else if (AppPreferences.segmentTags || this.isBreak(inline)) {
                            typebuilder.append("break");
                            equivtext = " ";
                        }
                        int style = wpPropStyle > 0 ? wpPropStyle : wstyle;
                        if (style > 0 && (s = this.createStyleAttribute(style)) != null) {
                            if (typebuilder.length() > 0) {
                                typebuilder.append(';');
                            }
                            typebuilder.append(s);
                        }
                        StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                        tagbuilder.append(index);
                        tagbuilder.append("\"");
                        if (typebuilder.length() > 0) {
                            tagbuilder.append(" ctype=\"x-");
                            tagbuilder.append((CharSequence)typebuilder);
                            tagbuilder.append("\"");
                        }
                        if (equivtext != null) {
                            tagbuilder.append(" equiv-text=\"");
                            tagbuilder.append(equivtext);
                            tagbuilder.append("\"");
                        }
                        tagbuilder.append("/>");
                        this.tags = tagbuilder.toString();
                        ++index;
                        skeleton.put(this.tags, inline.toString());
                        this.styles.put(this.tags, style);
                        inline.setLength(0);
                        fgr.setLength(0);
                        m = XMLHelper.resolveEntitiesXML(m);
                        if (coll.length() > 0) {
                            content.append(coll.toString());
                            coll.setLength(0);
                        }
                        content.append(this.tags);
                        if (standaloneSpace != null) {
                            content.append(standaloneSpace);
                        }
                        content.append(m);
                        inline.append(ssgroup);
                        fgr.append(ssgroup);
                        change = false;
                        format = -1;
                        docSpace = false;
                        standaloneSpace = null;
                        to = matcher.end();
                        continue;
                    }
                }
            }
            if (group.endsWith("Style w:val=\"tw4winExternal\"/>") || !this.isUncleaned && group.equals("<w:vanish/>")) {
                if (group.startsWith("<w:rStyle") || wrProp) {
                    rexternal = true;
                    change = true;
                } else {
                    pexternal = true;
                }
            }
            if (group.equals("</w:p>")) {
                if (!isPicture) {
                    pexternal = false;
                    rexternal = false;
                }
                sizeGroup = null;
                colorGroup = null;
                fontGroup = null;
                wpPropStyle = 0;
            }
            if (group.startsWith("<w:t") && ((ch = group.charAt(4)) == '>' || ch == ' ')) {
                if (colorGroup != null && !colorChange) {
                    colorGroup = null;
                    change = true;
                }
                if (fontGroup != null && !fontChange) {
                    fontGroup = null;
                    change = true;
                }
                if (sizeGroup != null && !sizeChange) {
                    sizeGroup = null;
                    change = true;
                }
            }
            if (group.equals("<w:rPr>")) {
                if (!isPicture) {
                    rexternal = false;
                }
                wrProp = true;
            } else if (group.equals("</w:rPr>")) {
                wrProp = false;
                wrPropStyle = 0;
            } else if (group.equals("</w:r>")) {
                if (!isPicture) {
                    rexternal = false;
                }
                colorChange = false;
                fontChange = false;
                sizeChange = false;
            } else if (group.equals("<w:pPr>")) {
                wpProp = true;
            } else if (group.equals("</w:pPr>")) {
                wpProp = false;
                wstyle = 0;
                wrstyle = false;
            } else if (group.equals("<w:t xml:space=\"preserve\">")) {
                docSpace = true;
            } else if (group.indexOf("<w:tab") != -1 || group.equals("</w:p>") || group.equals("<w:br/>") || group.indexOf("<w:footnoteReference") != -1 || group.indexOf("<w:fldChar") != -1 || group.indexOf("<w:noBreakHyphen/>") != -1) {
                format = 0;
                wstyle = 0;
            } else if (group.equals("<w:b/>") || group.startsWith("<w:b ")) {
                if (wrPropStyle > 0 || lastGroup.equals("<w:i/>") || lastGroup.startsWith("<w:u ")) {
                    change = (wstyle += 2) != textStyle;
                } else if (wstyle != 2 && wstyle != 6 && wstyle != 10 && wstyle != 14) {
                    change = true;
                    wstyle = 2;
                } else {
                    wstyle = 2;
                }
                if (wrProp) {
                    wrPropStyle = 2;
                }
                if (wpProp) {
                    wpPropStyle += 2;
                }
            } else if (group.equals("<w:i/>")) {
                if (wrPropStyle > 0 || lastGroup.equals("<w:b/>") || lastGroup.startsWith("<w:b ") || lastGroup.startsWith("<w:u ")) {
                    change = (wstyle += 4) != textStyle;
                } else if (wstyle != 4 && wstyle != 6 && wstyle != 12 && wstyle != 14) {
                    change = true;
                    wstyle = 4;
                } else {
                    wstyle = 4;
                }
                if (wrProp) {
                    wrPropStyle = 4;
                }
                if (wpProp) {
                    wpPropStyle += 4;
                }
            } else if (group.startsWith("<w:u ") || group.startsWith("<w:rStyle w:val=\"Hyperlink\"") || group.startsWith("<w:hlink ")) {
                if (wrPropStyle > 0 || lastGroup.equals("<w:b/>") || lastGroup.startsWith("<w:b ") || lastGroup.equals("<w:i/>")) {
                    wstyle += 8;
                } else if (wstyle != 8 && wstyle != 10 && wstyle != 12 && wstyle != 14) {
                    change = true;
                    wstyle = 8;
                } else {
                    wstyle = 8;
                }
                if (wrProp) {
                    wrPropStyle = 8;
                }
                if (wpProp) {
                    wpPropStyle += 8;
                }
            } else if (group.startsWith("<w:vertAlign w:val=\"subscript\"")) {
                wstyle = 16;
                format = 0;
            } else if (group.startsWith("<w:vertAlign w:val=\"superscript\"")) {
                wstyle = 18;
                format = 0;
            } else if (group.equals("<w:strike/>")) {
                wstyle = 20;
                format = 0;
            } else if (group.equals("<w:caps/>")) {
                wstyle = 22;
                format = 0;
            } else if (group.equals("<w:smallCaps/>")) {
                wstyle = 24;
                format = 0;
            } else if (group.startsWith("<w:color") || group.startsWith("<w:highlight") || group.startsWith("<w:shd")) {
                if (colorGroup == null || !group.equals(colorGroup)) {
                    change = true;
                }
                colorGroup = group;
                colorChange = true;
            } else if (group.startsWith("<w:rFonts")) {
                if (fontGroup == null || !group.equals(fontGroup)) {
                    change = true;
                }
                fontGroup = group;
                fontChange = true;
            } else if (group.startsWith("<w:szCs ") || group.startsWith("<w:sz ")) {
                String val = group.substring(group.indexOf(32) + 1);
                if (sizeGroup == null || !val.equals(sizeGroup)) {
                    change = true;
                }
                sizeGroup = val;
                sizeChange = true;
            } else if (group.startsWith("<w:txbxContent>") || group.startsWith("<w:sym ")) {
                change = true;
            } else if (group.equals("<w:drawing>") || group.equals("<w:pict>")) {
                isPicture = true;
            } else if (group.equals("</w:drawing>") || group.equals("</w:pict>")) {
                isPicture = false;
            }
            if (to == from) {
                inline.append(group);
                fgr.append(group);
                to = matcher.end();
            } else {
                String match = xhtml.substring(to, from);
                if (pexternal || rexternal) {
                    inline.append(match);
                    inline.append(group);
                    fgr.append(match);
                    fgr.append(group);
                    to = matcher.end();
                    continue;
                }
                String aftbreak = fgr.toString();
                if (wstyle > 0 && fgr.indexOf("<w:b/>") == -1 && fgr.indexOf("<w:b ") == -1 && fgr.indexOf("<w:i/>") == -1 && fgr.indexOf("<w:u ") == -1 && fgr.indexOf("<w:hlink ") == -1 && fgr.indexOf("<w:rStyle w:val=\"Hyperlink\"") == -1 && fgr.indexOf("<w:vertAlign") == -1 && fgr.indexOf("<w:strike/>") == -1 && fgr.indexOf("<w:caps/>") == -1 && fgr.indexOf("<w:smallCaps/>") == -1) {
                    wstyle = 0;
                    change = true;
                }
                if (!(wrstyle || this.isUncleaned || change || format != -1 || match.length() <= 0 || !aftbreak.startsWith("</w:t></w:r><w:r") && !aftbreak.startsWith("</w:t></w:r><w:proofErr"))) {
                    match = XMLHelper.resolveEntitiesXML(match);
                    coll.append(match);
                    fgr.setLength(0);
                    inline.append(group);
                    fgr.append(group);
                    to = matcher.end();
                    change = false;
                    lastGroup = group;
                    continue;
                }
                int i = aftbreak.indexOf("<w:rStyle ");
                if (i == -1) {
                    i = aftbreak.indexOf("<w:vertAlign");
                }
                if (i != -1) {
                    if (aftbreak.indexOf("</w:r>", i) == -1) {
                        wrstyle = true;
                    } else {
                        wrstyle = false;
                        wstyle = 0;
                    }
                } else {
                    wrstyle = false;
                }
                if (match.trim().length() > 0) {
                    String s;
                    String inl;
                    if (this.tags != null && (inl = (String)skeleton.get(this.tags)) != null && inl.endsWith("<w:t>")) {
                        StringBuffer sb = new StringBuffer(inl);
                        sb = sb.insert(sb.length() - 1, " xml:space=\"preserve\"");
                        skeleton.put(this.tags, sb.toString());
                    }
                    if (!hasContent) {
                        hasContent = true;
                    }
                    match = XMLHelper.resolveEntitiesXML(match);
                    StringBuilder typebuilder = new StringBuilder();
                    String equivtext = null;
                    if (isPage) {
                        typebuilder.append("page");
                        isPage = false;
                    } else if (AppPreferences.segmentTags || this.isBreak(inline)) {
                        typebuilder.append("break");
                        equivtext = " ";
                    }
                    int style = wpPropStyle > 0 ? wpPropStyle : wstyle;
                    if (style > 0 && (s = this.createStyleAttribute(style)) != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append(s);
                    }
                    StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                    tagbuilder.append(index);
                    tagbuilder.append("\"");
                    if (typebuilder.length() > 0) {
                        tagbuilder.append(" ctype=\"x-");
                        tagbuilder.append((CharSequence)typebuilder);
                        tagbuilder.append("\"");
                    }
                    if (equivtext != null) {
                        tagbuilder.append(" equiv-text=\"");
                        tagbuilder.append(equivtext);
                        tagbuilder.append("\"");
                    }
                    tagbuilder.append("/>");
                    this.tags = tagbuilder.toString();
                    ++index;
                    if (inline.toString().endsWith("<w:t>")) {
                        inline = inline.insert(inline.length() - 1, " xml:space=\"preserve\"");
                    }
                    skeleton.put(this.tags, inline.toString());
                    this.styles.put(this.tags, style);
                    textStyle = wstyle;
                    inline.setLength(0);
                    fgr.setLength(0);
                    if (coll.length() > 0) {
                        content.append(coll.toString());
                        coll.setLength(0);
                    }
                    content.append(this.tags);
                    if (standaloneSpace != null) {
                        content.append(standaloneSpace);
                    }
                    content.append(match);
                    inline.append(group);
                    fgr.append(group);
                    change = false;
                    format = -1;
                    docSpace = false;
                    standaloneSpace = null;
                } else {
                    if (match.length() > 0 && (content.length() > 0 || docSpace)) {
                        standaloneSpace = match;
                    }
                    inline.append(group);
                    fgr.append(group);
                }
                to = matcher.end();
            }
            lastGroup = group;
        }
        if (!hasContent) {
            return "";
        }
        if (coll.length() > 0) {
            content.append(coll.toString());
            coll.setLength(0);
        }
        if (inline.length() > 0) {
            String tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            if (wpPropStyle > 0) {
                this.styles.put(tags, wpPropStyle);
            } else {
                this.styles.put(tags, wstyle);
            }
            content.append(tags);
        }
        this.tagIndex = index;
        return content.toString();
    }

    boolean isBreak(StringBuffer group) {
        boolean br = false;
        if (group.indexOf("<w:tab") != -1 || group.indexOf("</w:p>") != -1 || group.indexOf("<w:br/>") != -1 || group.indexOf("</Data>") != -1 || group.indexOf("</si>") != -1 || group.indexOf("<w:txbxContent>") != -1) {
            br = true;
        }
        return br;
    }
}

