/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.XMLElement;
import translator.XMLHelper;
import translator.translatables.MSExcelDocument;

public class Row
extends DefaultXMLElement {
    private MSExcelDocument document;
    private List sharedStrings;
    private List columns;
    private boolean hidden;
    private String exportColumnID;
    private XMLElement sourceColumn;
    private XMLElement targetColumn;
    private String sourceColumnID;
    private String targetColumnID;
    private String note;
    private Map sourceTagsMap;
    private Map targetTagsMap;
    static Pattern patternIn = Pattern.compile("<rPh.+?</rPh>|<[^>]*>", 34);
    static Pattern patternOut = Pattern.compile("<x id=.+?>");
    int count = 0;

    public Row(MSExcelDocument document) {
        this.document = document;
        this.sharedStrings = document.getSharedStrings();
    }

    public String getNote() {
        return this.note;
    }

    public void setTagMaps() {
        this.sourceTagsMap = new HashMap();
        this.targetTagsMap = new HashMap();
    }

    public void setExportColumn(String id) {
        this.exportColumnID = id;
        boolean exportColumnExists = false;
        if (this.columns == null) {
            this.columns = this.getChildren();
        }
        for (XMLElement elem : this.columns) {
            String cid = elem.getAttribute("r");
            if (!this.exportColumnID.equalsIgnoreCase(cid)) continue;
            exportColumnExists = true;
            break;
        }
        if (!exportColumnExists && this.sourceColumn != null) {
            DefaultXMLElement cElement = new DefaultXMLElement();
            cElement.setName("c");
            LinkedHashMap attrs = this.sourceColumn.getAttributes();
            for (Map.Entry pairs : attrs.entrySet()) {
                String k = pairs.getKey().toString();
                String v = pairs.getValue().toString();
                cElement.setAttribute(k, v);
            }
            cElement.setAttribute("r", this.exportColumnID);
            DefaultXMLElement vElement = new DefaultXMLElement();
            vElement.setName("v");
            vElement.setContent(0, "1");
            cElement.addChild(vElement);
            this.columns.add(cElement);
            this.targetColumn = cElement;
            Collections.sort(this.columns, new Comparator(){

                public int compare(Object o1, Object o2) {
                    XMLElement elem1 = (XMLElement)o1;
                    XMLElement elem2 = (XMLElement)o2;
                    String s1 = elem1.getAttribute("r");
                    String s2 = elem2.getAttribute("r");
                    if (s1 != null && s2 != null) {
                        return s1.compareTo(s2);
                    }
                    return 0;
                }
            });
        }
    }

    public void setHidden(boolean h) {
        this.hidden = h;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getSource(String icol, String ecol, String ncol, Set hiddenCols, Set rangeCols) {
        StringBuilder sb = new StringBuilder();
        String rid = this.getAttribute("r");
        if (icol.length() > 0) {
            icol = icol + rid;
        }
        if (ncol.length() > 0) {
            ncol = ncol + rid;
        }
        if (this.columns == null) {
            this.columns = this.getChildren();
        }
        for (XMLElement elem : this.columns) {
            XMLElement val;
            String vcont;
            char ch;
            int j;
            char[] arr;
            int i;
            String type = elem.getAttribute("t");
            if (type == null || !type.equals("s")) continue;
            String cid = elem.getAttribute("r");
            if (hiddenCols != null) {
                i = -1;
                arr = cid.toCharArray();
                for (j = 0; j < arr.length && (ch = arr[j]) >= 'A' && ch <= 'Z'; ++j) {
                    i = ch - 65;
                    if (j == 0) {
                        ++i;
                        continue;
                    }
                    i += j * 26;
                }
                if (hiddenCols.contains(i)) continue;
            }
            if (rangeCols != null) {
                i = -1;
                arr = cid.toCharArray();
                for (j = 0; j < arr.length && (ch = arr[j]) >= 'A' && ch <= 'Z'; ++j) {
                    i = ch - 65;
                    if (j == 0) {
                        ++i;
                        continue;
                    }
                    i += j * 26;
                }
                if (!rangeCols.contains(i)) continue;
                icol = cid;
            }
            boolean isNote = false;
            if (ncol.length() > 0 && ncol.equalsIgnoreCase(cid)) {
                isNote = true;
            }
            if (icol.length() > 0 && !icol.equalsIgnoreCase(cid) && !isNote) continue;
            List vals = elem.getChildren("v");
            if (vals.size() == 1 && (vcont = (String)(val = (XMLElement)vals.get(0)).getContent(0)) != null && vcont.length() > 0) {
                int i2;
                try {
                    i2 = Integer.parseInt(vcont);
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                if (i2 > -1 && i2 < this.sharedStrings.size()) {
                    String ss = this.sharedStrings.get(i2).toString();
                    if (!isNote) {
                        sb.append("<c ");
                        sb.append("r=\"" + cid + "\">");
                        sb.append(ss);
                        sb.append("</c>");
                    } else {
                        this.note = ss;
                    }
                }
            }
            if (icol.length() <= 0 || isNote) continue;
            this.sourceColumn = elem;
        }
        if (ecol.length() > 0 && !ecol.equals(icol)) {
            this.targetColumnID = ecol = ecol + rid;
        }
        return sb.toString();
    }

    public String getSourceAndTarget(String scol, String tcol, String ncol, String slang, String tlang) {
        StringBuilder sb = new StringBuilder();
        String rid = this.getAttribute("r");
        boolean hasSource = false;
        boolean hasTarget = false;
        if (!this.hidden) {
            this.setTagMaps();
            if (scol.length() > 0) {
                scol = scol + rid;
            }
            if (tcol.length() > 0) {
                tcol = tcol + rid;
            }
            if (ncol.length() > 0) {
                ncol = ncol + rid;
            }
            if (this.columns == null) {
                this.columns = this.getChildren();
            }
            for (XMLElement elem : this.columns) {
                String ss;
                int i;
                XMLElement val;
                String vcont;
                List vals;
                String cid;
                String type = elem.getAttribute("t");
                if (type == null) {
                    elem.setAttribute("t", "s");
                } else if (!type.equals("s")) continue;
                if ((cid = elem.getAttribute("r")) == null) continue;
                if (scol.length() > 0 && scol.equalsIgnoreCase(cid)) {
                    vals = elem.getChildren("v");
                    if (vals.size() == 1 && (vcont = (String)(val = (XMLElement)vals.get(0)).getContent(0)) != null && vcont.length() > 0) {
                        try {
                            i = Integer.parseInt(vcont);
                        }
                        catch (NumberFormatException ex) {
                            hasSource = false;
                            break;
                        }
                        ss = i < this.sharedStrings.size() ? this.sharedStrings.get(i).toString() : "";
                        if (ss.length() > 0) {
                            ss = this.getBilingualContent(ss, true);
                        }
                        sb.append("<source xml:lang=\"");
                        sb.append(slang);
                        sb.append("\">");
                        sb.append(ss);
                        sb.append("</source>");
                        hasSource = true;
                        this.sourceColumnID = cid;
                    }
                    this.sourceColumn = elem;
                    continue;
                }
                if (tcol.length() > 0 && tcol.equalsIgnoreCase(cid)) {
                    vals = elem.getChildren("v");
                    if (vals.size() == 1 && (vcont = (String)(val = (XMLElement)vals.get(0)).getContent(0)) != null && vcont.length() > 0) {
                        try {
                            i = Integer.parseInt(vcont);
                        }
                        catch (NumberFormatException ex) {
                            hasTarget = false;
                            break;
                        }
                        ss = i < this.sharedStrings.size() ? this.sharedStrings.get(i).toString() : "";
                        if (ss.length() > 0) {
                            ss = this.getBilingualContent(ss, false);
                        }
                        sb.append("<target xml:lang=\"");
                        sb.append(tlang);
                        sb.append("\">");
                        sb.append(ss);
                        sb.append("</target>");
                        hasTarget = true;
                        this.targetColumnID = cid;
                    }
                    this.targetColumn = elem;
                    continue;
                }
                if (ncol.length() <= 0 || !ncol.equalsIgnoreCase(cid) || (vals = elem.getChildren("v")).size() != 1 || (vcont = (String)(val = (XMLElement)vals.get(0)).getContent(0)) == null || vcont.length() <= 0) continue;
                try {
                    i = Integer.parseInt(vcont);
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                ss = i < this.sharedStrings.size() ? this.sharedStrings.get(i).toString() : "";
                if (ss.length() > 0) {
                    ss = XMLHelper.parseTagsContent(ss);
                }
                sb.append("<note>");
                sb.append(ss);
                sb.append("</note>");
            }
            if (hasSource && !hasTarget) {
                sb.append("<target xml:lang=\"");
                sb.append(tlang);
                sb.append("\">");
                sb.append("</target>");
                this.targetColumnID = tcol;
            }
        }
        if (!hasSource) {
            return "";
        }
        return sb.toString();
    }

    public void setTarget(String s, String id) {
        if (this.targetColumn == null && this.targetColumnID != null) {
            this.setExportColumn(this.targetColumnID);
        }
        if (this.columns == null) {
            this.columns = this.getChildren();
        }
        if (this.exportColumnID != null) {
            id = this.exportColumnID;
        }
        for (XMLElement elem : this.columns) {
            XMLElement val;
            String cid = elem.getAttribute("r");
            if (!id.equals(cid)) continue;
            List vals = elem.getChildren("v");
            if (vals.isEmpty()) {
                if (elem.getAttribute("t") == null) {
                    elem.setAttribute("t", "s");
                }
                val = new DefaultXMLElement();
                ((DefaultXMLElement)val).setName("v");
                elem.addChild(val);
                vals = elem.getChildren("v");
            }
            if (vals.size() != 1) break;
            val = (XMLElement)vals.get(0);
            int si = this.sharedStrings.indexOf(s);
            if (si == -1) {
                this.sharedStrings.add(s);
                int count = this.sharedStrings.size() - 1;
                val.setContent(0, Integer.toString(count));
                break;
            }
            val.setContent(0, Integer.toString(si));
            break;
        }
    }

    public void setBilinugalTarget(String s) {
        if (this.targetColumn == null && this.targetColumnID != null) {
            this.setExportColumn(this.targetColumnID);
        }
        if (this.targetColumn != null) {
            Matcher m = patternOut.matcher(s);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                int j;
                int i;
                String xgroup = m.group();
                String tagID = xgroup.substring(i = xgroup.indexOf(34) + 1, j = xgroup.indexOf(34, i));
                String replace = (String)this.targetTagsMap.get(tagID);
                if (replace != null) {
                    m.appendReplacement(sb, replace);
                    continue;
                }
                replace = (String)this.sourceTagsMap.get(tagID);
                if (replace != null) {
                    m.appendReplacement(sb, replace);
                    continue;
                }
                m.appendReplacement(sb, "");
            }
            m.appendTail(sb);
            List vals = this.targetColumn.getChildren("v");
            if (vals.isEmpty()) {
                if (this.targetColumn.getAttribute("t") == null) {
                    this.targetColumn.setAttribute("t", "s");
                }
                DefaultXMLElement val = new DefaultXMLElement();
                val.setName("v");
                this.targetColumn.addChild(val);
                vals = this.targetColumn.getChildren("v");
            }
            if (vals.size() == 1) {
                XMLElement val = (XMLElement)vals.get(0);
                this.sharedStrings.add(sb.toString());
                int count = this.sharedStrings.size() - 1;
                val.setContent(0, Integer.toString(count));
            }
        }
    }

    void clearTargetColumn() {
        if (this.targetColumn != null) {
            this.columns.remove(this.targetColumn);
            this.targetColumn = null;
        }
    }

    String getBilingualContent(String xml, boolean source) {
        Matcher matcher = patternIn.matcher(xml);
        StringBuilder content = new StringBuilder();
        String group = "";
        String lastGroup = "";
        int from = 0;
        int to = 0;
        String standaloneSpace = null;
        boolean hasContent = false;
        boolean isPage = false;
        boolean isPicture = false;
        StringBuffer inline = new StringBuffer();
        StringBuilder fgr = new StringBuilder();
        StringBuilder coll = new StringBuilder();
        int format = -1;
        int wstyle = 0;
        String wcolor = null;
        int textStyle = 0;
        boolean wrstyle = false;
        boolean wrProp = false;
        int wrPropStyle = 0;
        boolean wpProp = false;
        int wpPropStyle = 0;
        boolean change = false;
        boolean docSpace = false;
        boolean pexternal = false;
        boolean rexternal = false;
        String colorGroup = null;
        boolean colorChange = false;
        String fontGroup = null;
        boolean fontChange = false;
        String sizeGroup = null;
        boolean sizeChange = false;
        int sourceTagIndex = 1;
        int targetTagIndex = 1;
        while (matcher.find()) {
            char ch;
            from = matcher.start();
            group = matcher.group();
            if (group.equals("</w:p>") || group.equals("</si>")) {
                if (!isPicture) {
                    pexternal = false;
                    rexternal = false;
                }
                sizeGroup = null;
                colorGroup = null;
                fontGroup = null;
                wpPropStyle = 0;
            }
            if (group.startsWith("<t") && ((ch = group.charAt(2)) == '>' || ch == ' ')) {
                if (colorGroup != null && !colorChange) {
                    colorGroup = null;
                    change = true;
                }
                if (fontGroup != null && !fontChange) {
                    fontGroup = null;
                    change = true;
                }
                if (sizeGroup != null && !sizeChange) {
                    sizeGroup = null;
                    change = true;
                }
            }
            if (group.equals("<rPr>")) {
                if (!isPicture) {
                    rexternal = false;
                }
                wrProp = true;
            } else if (group.equals("</rPr>")) {
                wrProp = false;
                wrPropStyle = 0;
            } else if (group.equals("</r>")) {
                if (!isPicture) {
                    rexternal = false;
                }
                colorChange = false;
                fontChange = false;
                sizeChange = false;
            } else if (group.equals("<w:pPr>")) {
                wpProp = true;
            } else if (group.equals("</w:pPr>")) {
                wpProp = false;
                wstyle = 0;
                wrstyle = false;
            } else if (group.equals("<t xml:space=\"preserve\">")) {
                docSpace = true;
            } else if (group.indexOf("<w:tab") != -1 || group.equals("</si>") || group.equals("</w:p>") || group.equals("<w:br/>") || group.indexOf("<w:footnoteReference") != -1 || group.indexOf("<w:endnoteReference") != -1 || group.indexOf("<w:fldChar") != -1 || group.indexOf("<w:noBreakHyphen/>") != -1) {
                format = 0;
                wstyle = 0;
            } else if (group.equals("<b/>")) {
                if (wrPropStyle > 0 || lastGroup.equals("<i/>") || lastGroup.equals("<u/>")) {
                    change = (wstyle += 2) != textStyle;
                } else if (wstyle != 2 && wstyle != 6 && wstyle != 10 && wstyle != 14) {
                    change = true;
                    wstyle = 2;
                } else {
                    wstyle = 2;
                }
                if (wrProp) {
                    wrPropStyle = 2;
                }
                if (wpProp) {
                    wpPropStyle += 2;
                }
            } else if (group.equals("<i/>")) {
                if (wrPropStyle > 0 || lastGroup.equals("<b/>") || lastGroup.equals("<u/>")) {
                    change = (wstyle += 4) != textStyle;
                } else if (wstyle != 4 && wstyle != 6 && wstyle != 12 && wstyle != 14) {
                    change = true;
                    wstyle = 4;
                } else {
                    wstyle = 4;
                }
                if (wrProp) {
                    wrPropStyle = 4;
                }
                if (wpProp) {
                    wpPropStyle += 4;
                }
            } else if (group.equals("<u/>") || group.startsWith("<w:rStyle w:val=\"Hyperlink\"") || group.startsWith("<w:hlink ")) {
                if (wrPropStyle > 0 || lastGroup.equals("<b/>") || lastGroup.equals("<i/>")) {
                    change = (wstyle += 8) != textStyle;
                } else if (wstyle != 8 && wstyle != 10 && wstyle != 12 && wstyle != 14) {
                    change = true;
                    wstyle = 8;
                } else {
                    wstyle = 8;
                }
                if (wrProp) {
                    wrPropStyle = 8;
                }
                if (wpProp) {
                    wpPropStyle += 8;
                }
            } else if (group.startsWith("<w:vertAlign w:val=\"subscript\"")) {
                wstyle = 16;
                format = 0;
            } else if (group.startsWith("<w:vertAlign w:val=\"superscript\"")) {
                wstyle = 18;
                format = 0;
            } else if (group.equals("<w:strike/>")) {
                wstyle = 20;
                format = 0;
            } else if (group.equals("<w:caps/>")) {
                wstyle = 22;
                format = 0;
            } else if (group.equals("<w:smallCaps/>")) {
                wstyle = 24;
                format = 0;
            } else if (group.startsWith("<color") || group.startsWith("<w:highlight") || group.startsWith("<w:shd")) {
                int j;
                int i = group.indexOf("rgb=\"");
                if (i != -1 && (j = group.indexOf(34, i + 5)) != -1) {
                    String c = group.substring(i + 5, j);
                    if (c.length() > 7) {
                        c = c.substring(2);
                    }
                    wcolor = c;
                }
                if (colorGroup == null || !group.equals(colorGroup)) {
                    change = true;
                }
                colorGroup = group;
                colorChange = true;
            } else if (group.startsWith("<rFont")) {
                if (fontGroup == null || !group.equals(fontGroup)) {
                    change = true;
                }
                fontGroup = group;
                fontChange = true;
            } else if (group.startsWith("<szCs ") || group.startsWith("<sz ")) {
                String val = group.substring(group.indexOf(32) + 1);
                if (sizeGroup == null || !val.equals(sizeGroup)) {
                    change = true;
                }
                sizeGroup = val;
                sizeChange = true;
            } else if (group.startsWith("<w:txbxContent>") || group.startsWith("<w:sym ")) {
                change = true;
            } else if (group.equals("<w:drawing>") || group.equals("<w:pict>")) {
                isPicture = true;
            } else if (group.equals("</w:drawing>") || group.equals("</w:pict>")) {
                isPicture = false;
                change = true;
            }
            if (to == from) {
                inline.append(group);
                fgr.append(group);
                to = matcher.end();
            } else {
                String match = xml.substring(to, from);
                if (pexternal || rexternal) {
                    inline.append(match);
                    inline.append(group);
                    fgr.append(match);
                    fgr.append(group);
                    to = matcher.end();
                    continue;
                }
                String aftbreak = fgr.toString();
                if (wstyle > 0 && fgr.indexOf("<b/>") == -1 && fgr.indexOf("<i/>") == -1 && fgr.indexOf("<u/>") == -1 && fgr.indexOf("<w:hlink ") == -1 && fgr.indexOf("<w:rStyle w:val=\"Hyperlink\"") == -1 && fgr.indexOf("<w:vertAlign") == -1 && fgr.indexOf("<w:strike/>") == -1 && fgr.indexOf("<w:caps/>") == -1 && fgr.indexOf("<w:smallCaps/>") == -1) {
                    wstyle = 0;
                    change = true;
                }
                if (!wrstyle && !change && format == -1 && match.length() > 0 && (aftbreak.startsWith("</t></r><r") || aftbreak.startsWith("</t></r><w:proofErr"))) {
                    coll.append(match);
                    fgr.setLength(0);
                    inline.append(group);
                    fgr.append(group);
                    to = matcher.end();
                    change = false;
                    lastGroup = group;
                    continue;
                }
                int i = aftbreak.indexOf("<w:rStyle ");
                if (i == -1) {
                    i = aftbreak.indexOf("<w:vertAlign");
                }
                if (i != -1) {
                    if (aftbreak.indexOf("</r>", i) == -1) {
                        wrstyle = true;
                    } else {
                        wrstyle = false;
                        wstyle = 0;
                    }
                } else {
                    wrstyle = false;
                }
                if (match.trim().length() > 0) {
                    String tagID;
                    String s;
                    if (!hasContent) {
                        hasContent = true;
                    }
                    StringBuilder typebuilder = new StringBuilder();
                    String equivtext = null;
                    if (isPage) {
                        typebuilder.append("page");
                        isPage = false;
                    } else if (AppPreferences.segmentTags) {
                        typebuilder.append("break");
                        equivtext = " ";
                    }
                    int style = wpPropStyle > 0 ? wpPropStyle : wstyle;
                    if (style > 0 && (s = this.createStyleAttribute(style)) != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append(s);
                    }
                    if (wcolor != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append("fcolor:" + wcolor);
                        wcolor = null;
                    }
                    StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                    if (source) {
                        tagID = "s" + Integer.toString(sourceTagIndex);
                        tagbuilder.append(tagID);
                        ++sourceTagIndex;
                    } else {
                        tagID = "t" + Integer.toString(targetTagIndex);
                        tagbuilder.append(tagID);
                        ++targetTagIndex;
                    }
                    tagbuilder.append("\"");
                    if (typebuilder.length() > 0) {
                        tagbuilder.append(" ctype=\"x-");
                        tagbuilder.append((CharSequence)typebuilder);
                        tagbuilder.append("\"");
                    }
                    if (equivtext != null) {
                        tagbuilder.append(" equiv-text=\"");
                        tagbuilder.append(equivtext);
                        tagbuilder.append("\"");
                    }
                    tagbuilder.append("/>");
                    String tags = tagbuilder.toString();
                    if (source) {
                        this.sourceTagsMap.put(tagID, inline.toString());
                    } else {
                        this.targetTagsMap.put(tagID, inline.toString());
                    }
                    textStyle = wstyle;
                    inline.setLength(0);
                    fgr.setLength(0);
                    if (coll.length() > 0) {
                        content.append(coll.toString());
                        coll.setLength(0);
                    }
                    content.append(tags);
                    if (standaloneSpace != null) {
                        content.append(standaloneSpace);
                    }
                    content.append(match);
                    inline.append(group);
                    fgr.append(group);
                    change = false;
                    format = -1;
                    docSpace = false;
                    standaloneSpace = null;
                } else {
                    if (match.length() > 0 && (content.length() > 0 || docSpace)) {
                        standaloneSpace = match;
                    }
                    inline.append(group);
                    fgr.append(group);
                }
                to = matcher.end();
            }
            lastGroup = group;
        }
        if (!hasContent) {
            return "";
        }
        if (coll.length() > 0) {
            content.append(coll.toString());
            coll.setLength(0);
        }
        if (inline.length() > 0) {
            if (source) {
                String tagID = "s" + Integer.toString(sourceTagIndex);
                ++sourceTagIndex;
                String tags = "<x id=\"" + tagID + "\"/>";
                this.sourceTagsMap.put(tagID, inline.toString());
                content.append(tags);
            } else {
                String tagID = "t" + Integer.toString(targetTagIndex);
                ++targetTagIndex;
                String tags = "<x id=\"" + tagID + "\"/>";
                this.targetTagsMap.put(tagID, inline.toString());
                content.append(tags);
            }
        }
        return content.toString();
    }

    boolean isBreak(StringBuffer group) {
        boolean br = false;
        if (group.indexOf("<w:tab") != -1 || group.indexOf("</w:p>") != -1 || group.indexOf("<w:br/>") != -1 || group.indexOf("</Data>") != -1 || group.indexOf("</si>") != -1 || group.indexOf("<w:txbxContent>") != -1) {
            br = true;
        }
        return br;
    }

    protected String createStyleAttribute(int tstyle) {
        String attr;
        if (tstyle == 2) {
            attr = "bold";
        } else if (tstyle == 4) {
            attr = "italic";
        } else if (tstyle == 8) {
            attr = "underline";
        } else if (tstyle == 6) {
            attr = "bold;italic";
        } else if (tstyle == 10) {
            attr = "bold;underline";
        } else if (tstyle == 12) {
            attr = "italic;underline";
        } else if (tstyle == 14) {
            attr = "bold;italic;underline";
        } else if (tstyle == 16) {
            attr = "subscript";
        } else if (tstyle == 18) {
            attr = "superscript";
        } else if (tstyle == 20) {
            attr = "strikethrough";
        } else if (tstyle == 22) {
            attr = "caps";
        } else if (tstyle == 24) {
            attr = "smallcaps";
        } else {
            return null;
        }
        return attr;
    }
}

