/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleContext;
import translator.AppPreferences;
import translator.FormatChooser;
import translator.Project;
import translator.Translatable;
import translator.XMLHelper;
import translator.text.ParagraphStyledDocument;
import translator.translatables.TextDocument;

public class SRTSubtitles
extends TextDocument
implements Translatable {
    private HashMap comments = new HashMap();

    @Override
    public void loadFile(File file, String format, String encoding) {
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadTextFile(file, encoding);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
    }

    @Override
    public void openFile(File file, String format, String encoding) {
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadTextFile(file, encoding);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(path)) {
            docs.add(path);
        }
        this.openEditorTab(this.doc);
        boolean i = false;
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
    }

    @Override
    String getContent(String xhtml, LinkedHashMap skeleton, String format) {
        String tags;
        boolean xml = false;
        Pattern p = Pattern.compile(format, 34);
        Matcher matcher = p.matcher(xhtml);
        StringBuffer content = new StringBuffer();
        String group = "";
        int from = 0;
        int to = 0;
        int index = 1;
        ArrayDeque<String> ad = new ArrayDeque<String>();
        StringBuffer inline = new StringBuffer();
        while (matcher.find()) {
            from = matcher.start();
            group = matcher.group();
            String c = group.trim();
            int i = c.lastIndexOf(10);
            if (i != -1) {
                String comment = c.substring(i + 1);
                comment = comment.replace("-->", "-");
                ad.add(comment);
            }
            if (to == from) {
                inline.append(group);
                to = matcher.end();
                continue;
            }
            String match = xhtml.substring(to, from);
            if (match.trim().length() > 0) {
                String s;
                int endformatIndex;
                if (xml) {
                    match = XMLHelper.resolveEntitiesXML(match);
                }
                int style = 0;
                String inlineLower = inline.toString().toLowerCase();
                int startformatIndex = inlineLower.lastIndexOf("<b>");
                if (startformatIndex != -1) {
                    endformatIndex = inlineLower.indexOf("</b>", startformatIndex);
                    if (endformatIndex == -1) {
                        style = 2;
                    }
                } else {
                    int endformatIndex2;
                    startformatIndex = inlineLower.lastIndexOf("<bold>");
                    if (startformatIndex != -1 && (endformatIndex2 = inlineLower.indexOf("</bold>", startformatIndex)) == -1) {
                        style = 2;
                    }
                }
                startformatIndex = inlineLower.lastIndexOf("<i>");
                if (startformatIndex != -1) {
                    endformatIndex = inlineLower.indexOf("</i>", startformatIndex);
                    if (endformatIndex == -1) {
                        style += 4;
                    }
                } else {
                    startformatIndex = inlineLower.lastIndexOf("<italic");
                    if (startformatIndex != -1 && (endformatIndex = inlineLower.indexOf("</italic", startformatIndex)) == -1) {
                        style += 4;
                    }
                }
                startformatIndex = inlineLower.lastIndexOf("<u>");
                if (startformatIndex != -1) {
                    endformatIndex = inlineLower.indexOf("</u>", startformatIndex);
                    if (endformatIndex == -1) {
                        style += 8;
                    }
                } else {
                    startformatIndex = inlineLower.lastIndexOf("<underline");
                    if (startformatIndex != -1 && (endformatIndex = inlineLower.indexOf("</underline", startformatIndex)) == -1) {
                        style += 8;
                    }
                }
                startformatIndex = inlineLower.lastIndexOf("<sub>");
                if (startformatIndex != -1 && (endformatIndex = inlineLower.indexOf("</sub>", startformatIndex)) == -1) {
                    style = 16;
                }
                if ((startformatIndex = inlineLower.lastIndexOf("<sup>")) != -1 && (endformatIndex = inlineLower.indexOf("</sup>", startformatIndex)) == -1) {
                    style = 18;
                }
                if ((startformatIndex = inlineLower.lastIndexOf("<s>")) != -1 && (endformatIndex = inlineLower.indexOf("</s>", startformatIndex)) == -1) {
                    style = 20;
                }
                StringBuilder typebuilder = new StringBuilder();
                String equivtext = null;
                if (!this.isNoBreak(inline.toString().toLowerCase())) {
                    typebuilder.append("break");
                    equivtext = " ";
                }
                if (style > 0 && (s = this.createStyleAttribute(style)) != null) {
                    if (typebuilder.length() > 0) {
                        typebuilder.append(';');
                    }
                    typebuilder.append(s);
                }
                StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                tagbuilder.append(index);
                tagbuilder.append("\"");
                if (typebuilder.length() > 0) {
                    tagbuilder.append(" ctype=\"x-");
                    tagbuilder.append((CharSequence)typebuilder);
                    tagbuilder.append("\"");
                }
                if (equivtext != null) {
                    tagbuilder.append(" equiv-text=\"");
                    tagbuilder.append(equivtext);
                    tagbuilder.append("\"");
                }
                tagbuilder.append("/>");
                String tags2 = tagbuilder.toString();
                skeleton.put(tags2, inline.toString());
                this.styles.put(tags2, style);
                if (!ad.isEmpty()) {
                    String comment = (String)ad.removeFirst();
                    this.comments.put(tags2, comment);
                }
                inline.setLength(0);
                content.append(tags2);
                content.append(match);
                inline.append(group);
                ++index;
            } else {
                if (match.length() > 0 && content.length() > 0) {
                    inline.append(match);
                }
                inline.append(group);
            }
            to = matcher.end();
        }
        if (inline.length() > 0) {
            tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            content.append(tags);
            if (!ad.isEmpty()) {
                String comment = (String)ad.removeFirst();
                this.comments.put(tags, comment);
            }
        }
        if (to < xhtml.length()) {
            tags = "<x id=\"" + ++index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, "");
            content.append(xhtml.substring(to));
            content.append(tags);
            if (!ad.isEmpty()) {
                String comment = (String)ad.removeFirst();
                this.comments.put(tags, comment);
            }
        }
        return content.toString();
    }

    public Map getCommentsMap() {
        return this.comments;
    }

    @Override
    public String getSegmentationRule() {
        return "<x.+?/>";
    }

    @Override
    public void preview(Project pr, String spath) {
        Document sdoc = this.getDocument();
        String path = (String)sdoc.getProperty("path");
        String prev = null;
        prev = this.isUncleaned ? pr.previewUnclean(sdoc) : pr.preview(sdoc);
        if (prev != null && path != null) {
            String prevFilePath;
            prev = prev.replaceAll("\r*\n", "\r\n");
            PlainDocument tdoc = new PlainDocument();
            try {
                tdoc.insertString(0, prev, null);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            File file = new File(path);
            String name = file.getName();
            String extention = null;
            int i = name.lastIndexOf(".");
            extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
            String parent = file.getParent();
            if (spath == null) {
                prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
            } else {
                prevFilePath = spath.toLowerCase().endsWith(extention) ? spath : spath + extention;
                if (prevFilePath.equalsIgnoreCase(path)) {
                    JOptionPane.showMessageDialog(this.topui, "Never overwrite the original source language document!");
                    return;
                }
            }
            File previewFile = new File(prevFilePath);
            boolean save = this.saveFile(previewFile, tdoc);
            if (!save) {
                this.preview2(pr, spath);
            } else if (spath == null) {
                this.topui.getResourceView().viewFile(previewFile);
            }
        }
    }

    @Override
    public void preview2(Project pr, String spath) {
        Document sdoc = this.getDocument();
        String path = (String)sdoc.getProperty("path");
        String prev = null;
        if (this.isUncleaned) {
            return;
        }
        prev = pr.preview2(sdoc);
        if (prev != null && path != null) {
            String prevFilePath;
            prev = prev.replaceAll("\r*\n", "\r\n");
            PlainDocument tdoc = new PlainDocument();
            try {
                tdoc.insertString(0, prev, null);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            File file = new File(path);
            String name = file.getName();
            String extention = null;
            int i = name.lastIndexOf(".");
            extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
            String parent = file.getParent();
            if (spath == null) {
                prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
            } else {
                prevFilePath = spath.toLowerCase().endsWith(extention) ? spath : spath + extention;
                if (prevFilePath.equalsIgnoreCase(path)) {
                    JOptionPane.showMessageDialog(this.topui, "Never overwrite the original source language document!");
                    return;
                }
            }
            File previewFile = new File(prevFilePath);
            boolean save = this.saveFile(previewFile, tdoc);
            if (save && spath == null) {
                this.topui.getResourceView().viewFile(previewFile);
            }
        }
    }
}

