/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.text.GapContent;
import javax.swing.text.StyleContext;
import translator.FormatChooser;
import translator.Translatable;
import translator.text.ParagraphStyledDocument;
import translator.translatables.TextDocument;

public class TaggedTextDocument
extends TextDocument
implements Translatable {
    @Override
    public void loadFile(File file, String format, String encoding) {
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadTextFile(file, encoding);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
    }

    @Override
    public void openFile(File file, String format, String encoding) {
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadTextFile(file, encoding);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(path)) {
            docs.add(path);
        }
        this.openEditorTab(this.doc);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
    }

    @Override
    String getContent(String xhtml, LinkedHashMap skeleton, String format) {
        String tags;
        this.isTagged = true;
        Pattern p = Pattern.compile(format, 34);
        Matcher matcher = p.matcher(xhtml);
        StringBuffer content = new StringBuffer();
        String group = "";
        int from = 0;
        int to = 0;
        int index = 1;
        StringBuffer inline = new StringBuffer();
        boolean isTag = true;
        while (matcher.find()) {
            from = matcher.start();
            group = matcher.group();
            if (to == from) {
                inline.append(group);
                to = matcher.end();
                continue;
            }
            String match = xhtml.substring(to, from);
            if (match.trim().length() > 0) {
                if (isTag) {
                    tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
                    skeleton.put(tags, inline.toString());
                    content.append(tags);
                }
                inline.setLength(0);
                content.append(match);
                if (group.equals("\\<") || group.equals("\\>")) {
                    content.append(group.charAt(1));
                    isTag = false;
                } else {
                    isTag = true;
                    inline.append(group);
                }
                ++index;
            } else {
                if (match.length() > 0 && content.length() > 0) {
                    inline.append(match);
                }
                isTag = true;
                inline.append(group);
            }
            to = matcher.end();
        }
        if (inline.length() > 0) {
            tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            content.append(tags);
        }
        if (to < xhtml.length()) {
            tags = "<x id=\"" + ++index + "\" ctype=\"x-break\"/>";
            content.append(xhtml.substring(to));
            content.append(tags);
        }
        return content.toString();
    }
}

