/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.GapContent;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.DefaultResource;
import translator.EncodingValidator;
import translator.FileFilters;
import translator.FormatChooser;
import translator.MainView;
import translator.MyHighlightPainter;
import translator.MySwingWorker;
import translator.MyUndoListener;
import translator.Project;
import translator.ScrollPaneWatermark;
import translator.TabView;
import translator.Translatable;
import translator.XMLHelper;
import translator.text.ParagraphEditorKit;
import translator.text.ParagraphStyledDocument;
import translator.ui.Colors;

public class TextDocument
extends DefaultResource
implements Translatable {
    MainView topui;
    TabView tview;
    JLabel statusBar;
    private JTextPane textPane;
    private int startPosition = -1;
    private int endPosition = -1;
    private boolean hasHighlighter = false;
    private Highlighter.HighlightPainter myHighlightPainter;
    private Highlighter.HighlightPainter myHighlightPainter2;
    private Object taghighlight1;
    private Object taghighlight2;
    HashMap styles = new HashMap();
    protected Map customFormatMap;
    boolean edit = false;
    boolean isXML = false;
    boolean isTagged = false;
    boolean isUncleaned = false;
    boolean isMIF = false;
    boolean isResX = false;
    boolean isWord = false;
    boolean isPowerPoint = false;
    boolean isExcel = false;
    String forcedEncoding = null;
    List skeletons = new ArrayList();
    ParagraphStyledDocument doc = null;
    private boolean paragraphView = true;
    public String name;
    private Pattern p = Pattern.compile("<.*?>");
    private static Pattern tags = Pattern.compile(AppPreferences.segFormat);
    private MySwingWorker worker;
    private Pattern customFormatPattern = Pattern.compile("(&lt;([biu]|sup|sub|mark)&gt;)+|(&lt;/([biu]|sup|sub|mark)&gt;)+|\n");
    protected MyUndoListener undoHandler;

    @Override
    public void setMainView(MainView topui) {
        this.topui = topui;
        this.tview = topui.getTabView();
        this.statusBar = topui.getMainStatusBar();
    }

    public void setParagraphView(boolean view) {
        this.paragraphView = view;
    }

    private void createEditorTab(String name) {
        this.name = name;
        this.edit = true;
        this.doc = new ParagraphStyledDocument();
        this.doc.putProperty("name", name);
        this.setDocumentProperties(this.doc);
        JScrollPane scroll = this.createEditorTextComponent(this.doc);
        this.tview = this.topui.getTabView();
        this.tview.addTab(this, name, scroll);
    }

    private JScrollPane createEditorTextComponent(StyledDocument doc) {
        File file;
        this.textPane = new JTextPane();
        if (this.paragraphView) {
            this.textPane.setEditorKit(new ParagraphEditorKit());
        }
        this.textPane.setDocument(doc);
        if (!this.edit) {
            this.textPane.setEditable(false);
        }
        Graphics g = this.textPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        }
        Color background = null;
        if (AppPreferences.background != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            background = new Color(AppPreferences.background);
            Color foreground = new Color(AppPreferences.foreground);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.pBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.textPane.setCaretColor(foreground);
            this.textPane.setBackground(background);
            this.textPane.setForeground(foreground);
            this.textPane.setSelectedTextColor(foreground);
            this.textPane.setSelectionColor(selection);
        }
        this.textPane.setFont(new Font(AppPreferences.fontname, AppPreferences.fontstyle, AppPreferences.fontsize));
        if (!this.paragraphView) {
            this.textPane.setMargin(new Insets(16, 32, 16, 32));
        }
        this.textPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TextDocument.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.textPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                try {
                    int dot = e.getDot();
                    JTextComponent textP = (JTextComponent)e.getSource();
                    Rectangle r = textP.getVisibleRect();
                    Rectangle2D r0 = textP.modelToView2D(dot);
                    int w = (int)r.getWidth();
                    int h = (int)r.getHeight();
                    int x = (int)r.getX();
                    int y = (int)r.getY();
                    int y0 = (int)r0.getY();
                    if (!textP.isFocusOwner()) {
                        r = new Rectangle(x, y0 - h / 2, w, h);
                        textP.scrollRectToVisible(r);
                    } else if (y0 - y + 40 >= h) {
                        r = new Rectangle(x, y0 - h / 5, w, h);
                        textP.scrollRectToVisible(r);
                    } else if (y0 < 40) {
                        r = new Rectangle(0, 0, w, h);
                        textP.scrollRectToVisible(r);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.textPane.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextDocument.this.undoHandler.undoAction();
            }
        });
        this.textPane.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextDocument.this.undoHandler.redoAction();
            }
        });
        this.textPane.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.textPane.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        if (background != null) {
            jScrollPane.setBackground(background);
        }
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            jScrollPane.getViewport().setOpaque(false);
            this.textPane.setOpaque(false);
            this.textPane.setBackground(new Color(0, 0, 0, 0));
        }
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.textPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(this.textPane);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        return jScrollPane;
    }

    public void setDocumentProperties(Document doc) {
        Boolean state = new Boolean(false);
        doc.putProperty("state", state);
        this.undoHandler = new MyUndoListener();
        this.undoHandler.setLimit(100);
        doc.addUndoableEditListener(this.undoHandler);
        doc.putProperty("undohandler", this.undoHandler);
        Boolean save = new Boolean(true);
        doc.putProperty("save", save);
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextDocument.this.doc_insertUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextDocument.this.doc_removeUpdate(e);
            }
        });
    }

    private void doc_changedUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            state = true;
            doc.putProperty("state", state);
        }
    }

    private void doc_insertUpdate(DocumentEvent e) {
        StyledDocument doc = (StyledDocument)e.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            state = true;
            doc.putProperty("state", state);
        }
    }

    private void doc_removeUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            state = true;
            doc.putProperty("state", state);
        }
    }

    public void openEditorTab(StyledDocument doc) {
        String fname;
        this.name = fname = (String)doc.getProperty("name");
        JScrollPane scroll = this.createEditorTextComponent(doc);
        this.tview = this.topui.getTabView();
        this.tview.addTab(this, fname, scroll);
    }

    String[] insertContent(Document doc) throws BadLocationException {
        int le;
        int skelindex = 0;
        String[] contents = new String[this.skeletons.size()];
        LinkedHashMap skeleton = (LinkedHashMap)this.skeletons.get(skelindex);
        StringBuilder all = new StringBuilder();
        String content = doc.getText(0, doc.getLength());
        String tsegFormat = "(<x id=[^>]*>+?)";
        Pattern ttags = Pattern.compile(tsegFormat);
        Matcher ma = ttags.matcher(content);
        int st = 0;
        String inline = null;
        while (ma.find()) {
            int b = ma.start();
            int e = ma.end();
            String group = ma.group();
            String cont = content.substring(st, b);
            if (group.indexOf("x-page") != -1 && all.length() > 0) {
                cont = "";
                contents[skelindex] = all.toString();
                all.setLength(0);
                if (++skelindex < this.skeletons.size()) {
                    skeleton = (LinkedHashMap)this.skeletons.get(skelindex);
                }
            }
            if (cont.length() > 0) {
                if (this.isXML) {
                    if (this.isResX) {
                        if (!cont.startsWith("<data")) {
                            cont = XMLHelper.resolveXMLEntities(cont);
                        }
                    } else if (!AppPreferences.format.equals("HTML")) {
                        cont = XMLHelper.resolveXMLEntities(cont);
                    }
                } else if (this.isMIF) {
                    cont = XMLHelper.resolveMIFEntities(cont);
                } else if (this.isTagged) {
                    cont = cont.replaceAll("<", "\\\\<");
                    cont = cont.replaceAll(">", "\\\\>");
                }
                if (this.customFormatMap != null) {
                    cont = this.applyCustomFormat(cont, inline);
                }
            }
            if ((inline = (String)skeleton.get(group)) != null) {
                all.append(cont);
                all.append(inline);
            }
            st = e;
        }
        if (all.length() > 0) {
            if (skelindex >= contents.length) {
                return null;
            }
            contents[skelindex] = all.toString();
            all.setLength(0);
            if (++skelindex < this.skeletons.size()) {
                skeleton = (LinkedHashMap)this.skeletons.get(skelindex);
            }
        }
        if (st < (le = content.length())) {
            String cont = content.substring(st, le);
            if (this.isXML) {
                cont = XMLHelper.resolveXMLEntities(cont);
            }
            if (this.customFormatMap != null) {
                cont = this.applyCustomFormat(cont, inline);
            }
            all.append(cont);
            if (skelindex >= contents.length) {
                return null;
            }
            contents[skelindex] = all.toString();
            all.setLength(0);
        }
        return contents;
    }

    String getContent(String xhtml, LinkedHashMap skeleton, String format) {
        boolean xml = false;
        if (format.indexOf("<[^>]") != -1) {
            xml = true;
        }
        Pattern p = Pattern.compile(format, 34);
        Matcher matcher = p.matcher(xhtml);
        StringBuffer content = new StringBuffer();
        String group = "";
        String attributes = null;
        boolean editTag = false;
        int from = 0;
        int to = 0;
        int index = 1;
        StringBuffer inline = new StringBuffer();
        while (matcher.find()) {
            from = matcher.start();
            group = matcher.group();
            if (xml && group.indexOf("title=") != -1) {
                attributes = group;
                editTag = true;
            } else if (xml && group.startsWith("<a ")) {
                attributes = group;
                editTag = true;
            } else if (attributes != null) {
                int j;
                editTag = false;
                int i = attributes.indexOf(32) + 1;
                String m = attributes.substring(i, j = attributes.lastIndexOf(62));
                if (m.trim().length() > 0) {
                    String sgroup = attributes.substring(0, i);
                    String ssgroup = attributes.substring(j);
                    inline.append(sgroup);
                    StringBuilder typebuilder = new StringBuilder();
                    String equivtext = null;
                    typebuilder.append("break");
                    equivtext = " ";
                    int style = 8;
                    String s = this.createStyleAttribute(style);
                    if (s != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append(s);
                    }
                    StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                    tagbuilder.append(index);
                    tagbuilder.append("\"");
                    if (typebuilder.length() > 0) {
                        tagbuilder.append(" ctype=\"x-");
                        tagbuilder.append((CharSequence)typebuilder);
                        tagbuilder.append("\"");
                    }
                    if (equivtext != null) {
                        tagbuilder.append(" equiv-text=\"");
                        tagbuilder.append(equivtext);
                        tagbuilder.append("\"");
                    }
                    tagbuilder.append("/>");
                    String tags = tagbuilder.toString();
                    ++index;
                    skeleton.put(tags, inline.toString());
                    this.styles.put(tags, style);
                    inline.setLength(0);
                    m = XMLHelper.resolveEntitiesXML(m);
                    content.append(tags);
                    content.append(m);
                    inline.append(ssgroup);
                }
                attributes = null;
            }
            if (to == from) {
                inline.append(group);
                to = matcher.end();
                continue;
            }
            String match = xhtml.substring(to, from);
            if (match.trim().length() > 0) {
                String s;
                int endformatIndex;
                if (xml) {
                    match = XMLHelper.resolveEntitiesXML(match);
                }
                int style = 0;
                String inlineLower = inline.toString().toLowerCase();
                int startformatIndex = inlineLower.lastIndexOf("<b>");
                if (startformatIndex != -1) {
                    int endformatIndex2 = inlineLower.indexOf("</b>", startformatIndex);
                    if (endformatIndex2 == -1) {
                        style = 2;
                    }
                } else {
                    int endformatIndex3;
                    startformatIndex = inlineLower.lastIndexOf("<bold>");
                    if (startformatIndex != -1 && (endformatIndex3 = inlineLower.indexOf("</bold>", startformatIndex)) == -1) {
                        style = 2;
                    }
                }
                startformatIndex = inlineLower.lastIndexOf("<i>");
                if (startformatIndex != -1) {
                    int endformatIndex4 = inlineLower.indexOf("</i>", startformatIndex);
                    if (endformatIndex4 == -1) {
                        style += 4;
                    }
                } else {
                    int endformatIndex5;
                    startformatIndex = inlineLower.lastIndexOf("<italic");
                    if (startformatIndex != -1 && (endformatIndex5 = inlineLower.indexOf("</italic", startformatIndex)) == -1) {
                        style += 4;
                    }
                }
                startformatIndex = inlineLower.lastIndexOf("<u>");
                if (startformatIndex != -1) {
                    int endformatIndex6 = inlineLower.indexOf("</u>", startformatIndex);
                    if (endformatIndex6 == -1) {
                        style += 8;
                    }
                } else {
                    int endformatIndex7;
                    startformatIndex = inlineLower.lastIndexOf("<underline");
                    if (startformatIndex != -1 && (endformatIndex7 = inlineLower.indexOf("</underline", startformatIndex)) == -1) {
                        style += 8;
                    }
                }
                startformatIndex = inlineLower.lastIndexOf("<sub>");
                if (startformatIndex != -1 && (endformatIndex = inlineLower.indexOf("</sub>", startformatIndex)) == -1) {
                    style = 16;
                }
                if ((startformatIndex = inlineLower.lastIndexOf("<sup>")) != -1 && (endformatIndex = inlineLower.indexOf("</sup>", startformatIndex)) == -1) {
                    style = 18;
                }
                if ((startformatIndex = inlineLower.lastIndexOf("<s>")) != -1 && (endformatIndex = inlineLower.indexOf("</s>", startformatIndex)) == -1) {
                    style = 20;
                }
                StringBuilder typebuilder = new StringBuilder();
                String equivtext = null;
                if (!this.isNoBreak(inline.toString().toLowerCase())) {
                    typebuilder.append("break");
                    equivtext = " ";
                }
                if (style > 0 && (s = this.createStyleAttribute(style)) != null) {
                    if (typebuilder.length() > 0) {
                        typebuilder.append(';');
                    }
                    typebuilder.append(s);
                }
                StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                tagbuilder.append(index);
                tagbuilder.append("\"");
                if (typebuilder.length() > 0) {
                    tagbuilder.append(" ctype=\"x-");
                    tagbuilder.append((CharSequence)typebuilder);
                    tagbuilder.append("\"");
                }
                if (equivtext != null) {
                    tagbuilder.append(" equiv-text=\"");
                    tagbuilder.append(equivtext);
                    tagbuilder.append("\"");
                }
                tagbuilder.append("/>");
                String tags = tagbuilder.toString();
                skeleton.put(tags, inline.toString());
                this.styles.put(tags, style);
                inline.setLength(0);
                content.append(tags);
                content.append(match);
                if (!editTag) {
                    inline.append(group);
                }
                ++index;
            } else {
                if (match.length() > 0 && content.length() > 0) {
                    inline.append(match);
                }
                if (!editTag) {
                    inline.append(group);
                }
            }
            to = matcher.end();
        }
        if (inline.length() > 0) {
            String tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            content.append(tags);
        }
        if (to < xhtml.length()) {
            String tags = "<x id=\"" + ++index + "\" ctype=\"x-break\"/>";
            content.append(xhtml.substring(to));
            content.append(tags);
        }
        return content.toString();
    }

    boolean isNoBreak(String gr) {
        boolean nobr = false;
        boolean br = false;
        Matcher m = this.p.matcher(gr);
        while (m.find()) {
            String group = m.group();
            if (group.equals("<b>") || group.equals("</b>") || group.equals("<u>") || group.equals("</u>") || group.equals("<i>") || group.equals("</i>") || group.equals("<sub>") || group.equals("</sub>") || group.equals("<sup>") || group.equals("</sup>") || group.startsWith("<span") || group.equals("</span>") || group.startsWith("<emphasis") || group.equals("</emphasis>") || group.startsWith("<variable") || group.equals("</variable>") || group.startsWith("<link") || group.equals("</link>") || group.startsWith("<dynamic_link") || group.equals("</dynamic_link>") || group.startsWith("<lexiconlink") || group.equals("</lexiconlink>") || group.startsWith("<variableValue") || group.equals("</variableValue>") || group.startsWith("<variableName") || group.equals("</variableName>") || group.startsWith("<variantName") || group.equals("</variantName>")) {
                nobr = true;
                continue;
            }
            br = true;
        }
        return nobr && !br;
    }

    void colorTags(StyledDocument doc, boolean openEditor) {
        try {
            String s = doc.getText(0, doc.getLength());
            if (s.startsWith("<?xml")) {
                Style style = doc.getStyle("ColorTags");
                if (style == null) {
                    style = doc.addStyle("ColorTags", null);
                    Color tcolor = new Color(AppPreferences.tagColor);
                    StyleConstants.setForeground(style, tcolor);
                }
                Pattern ctags = Pattern.compile("<[^>]*>");
                Matcher ma = ctags.matcher(s);
                int st = -1;
                int en = -1;
                while (ma.find()) {
                    st = ma.start();
                    String group = ma.group();
                    doc.setCharacterAttributes(st, group.length(), style, false);
                    en = ma.end();
                }
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void insertStringTags(ParagraphStyledDocument doc, String s) {
        FontIcon tagIcon = FontIcon.of((Ikon)MaterialDesign.MDI_TAG, (Color)new Color(AppPreferences.foreground));
        try {
            if (s.startsWith("<") || s.startsWith("{")) {
                Style smallCaps;
                Style strike;
                Style sup;
                Style sub;
                Style biu;
                Style iu;
                Style bu;
                Style bi;
                Style underline;
                Style italics;
                Style bold;
                Style style;
                if (this.isUncleaned) {
                    String rtfFormat2 = "(<\\d*\\})";
                    String rtfFormat3 = "(\\{\\d*>)";
                    tags = Pattern.compile(rtfFormat2 + "|" + rtfFormat3 + "|" + AppPreferences.segFormat);
                }
                if ((style = doc.getStyle("Tags")) == null) {
                    style = doc.addStyle("Tags", null);
                    StyleConstants.setIcon(style, (Icon)tagIcon);
                }
                if ((bold = doc.getStyle("Bold")) == null) {
                    bold = doc.addStyle("Bold", null);
                    StyleConstants.setBold(bold, true);
                }
                if ((italics = doc.getStyle("Italics")) == null) {
                    italics = doc.addStyle("Italics", null);
                    StyleConstants.setItalic(italics, true);
                }
                if ((underline = doc.getStyle("Underline")) == null) {
                    underline = doc.addStyle("Underline", null);
                    StyleConstants.setUnderline(underline, true);
                }
                if ((bi = doc.getStyle("BoldItalics")) == null) {
                    bi = doc.addStyle("BoldItalics", null);
                    StyleConstants.setBold(bi, true);
                    StyleConstants.setItalic(bi, true);
                }
                if ((bu = doc.getStyle("BoldUnderline")) == null) {
                    bu = doc.addStyle("BoldUnderLine", null);
                    StyleConstants.setBold(bu, true);
                    StyleConstants.setUnderline(bu, true);
                }
                if ((iu = doc.getStyle("ItalicsUnderline")) == null) {
                    iu = doc.addStyle("ItalicsUnderLine", null);
                    StyleConstants.setItalic(iu, true);
                    StyleConstants.setUnderline(iu, true);
                }
                if ((biu = doc.getStyle("BoldItalicsUnderline")) == null) {
                    biu = doc.addStyle("BoldItalicsUnderLine", null);
                    StyleConstants.setItalic(biu, true);
                    StyleConstants.setUnderline(biu, true);
                    StyleConstants.setBold(biu, true);
                }
                if ((sub = doc.getStyle("Subscript")) == null) {
                    sub = doc.addStyle("Subscript", null);
                    StyleConstants.setSubscript(sub, true);
                }
                if ((sup = doc.getStyle("Superscript")) == null) {
                    sup = doc.addStyle("Superscript", null);
                    StyleConstants.setSuperscript(sup, true);
                }
                if ((strike = doc.getStyle("Strikethrough")) == null) {
                    strike = doc.addStyle("Strikethrough", null);
                    StyleConstants.setStrikeThrough(strike, true);
                }
                if ((smallCaps = doc.getStyle("Smallcaps")) == null) {
                    smallCaps = doc.addStyle("Smallcaps", null);
                    StyleConstants.setFontSize(smallCaps, AppPreferences.fontsize - 2);
                }
                Matcher ma = tags.matcher(s);
                int st = 0;
                int en = 0;
                int tstyle = -1;
                boolean parabreak = false;
                while (ma.find()) {
                    st = ma.start();
                    String group = ma.group();
                    String ss = s.substring(en, st);
                    if (ss.length() > 0) {
                        if (parabreak) {
                            doc.addParagraphView();
                            parabreak = false;
                        }
                        if (tstyle > 0) {
                            if (tstyle == 2) {
                                doc.addTextElement(ss, bold);
                            } else if (tstyle == 4) {
                                doc.addTextElement(ss, italics);
                            } else if (tstyle == 8) {
                                doc.addTextElement(ss, underline);
                            } else if (tstyle == 6) {
                                doc.addTextElement(ss, bi);
                            } else if (tstyle == 10) {
                                doc.addTextElement(ss, bu);
                            } else if (tstyle == 12) {
                                doc.addTextElement(ss, iu);
                            } else if (tstyle == 14) {
                                doc.addTextElement(ss, biu);
                            } else if (tstyle == 16) {
                                doc.addTextElement(ss, sub);
                            } else if (tstyle == 18) {
                                doc.addTextElement(ss, sup);
                            } else if (tstyle == 20) {
                                doc.addTextElement(ss, strike);
                            } else if (tstyle == 22) {
                                doc.addTextElement(ss.toUpperCase(), null);
                            } else if (tstyle == 24) {
                                doc.addTextElement(ss.toUpperCase(), smallCaps);
                            } else {
                                doc.addTextElement(ss, null);
                            }
                        } else {
                            doc.addTextElement(ss, null);
                        }
                    }
                    tstyle = -1;
                    Object o = this.styles.get(group);
                    if (o != null) {
                        tstyle = (Integer)o;
                    }
                    if (group.indexOf("x-page") != -1) {
                        doc.addParagraphView();
                    } else if (group.indexOf("x-break") != -1 && st > 0) {
                        parabreak = true;
                    }
                    doc.addTextElement(group.toString(), style);
                    en = ma.end();
                }
                if (en < s.length()) {
                    String ss = s.substring(en);
                    doc.addTextElement(ss, null);
                }
            } else {
                doc.insertString(0, s, null);
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadTextFile(File file, String encoding) {
        FileInputStream fis = null;
        try {
            Charset charset = Charset.isSupported(encoding) ? Charset.forName(encoding) : Charset.forName("UTF-8");
            CharsetDecoder decoder = charset.newDecoder();
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            fis = new FileInputStream(file);
            FileChannel fc = fis.getChannel();
            int sz = (int)fc.size();
            ByteBuffer bb = ByteBuffer.allocateDirect(sz);
            fc.read(bb);
            ByteBuffer buffer = bb;
            ((Buffer)buffer).flip();
            CharBuffer cb = decoder.decode(bb);
            fc.close();
            String string = cb.toString();
            return string;
        }
        catch (IOException ex) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public void openFile(File file, String format, String enc) {
        String e;
        if (format != null && format.equals("Mac String Resources (*.strings)")) {
            this.forcedEncoding = "UTF-8";
            EncodingValidator v = new EncodingValidator(this.forcedEncoding);
            boolean b = v.validateFile(file);
            if (!b) {
                this.forcedEncoding = "UTF-16";
            }
            e = this.forcedEncoding;
        } else {
            e = enc;
        }
        StringBuffer texts = new StringBuffer();
        String regExp = FormatChooser.getFormatRegEx(format);
        String outString = this.loadTextFile(file, e);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
        }
        texts.append(outString);
        if (this.skeletons.isEmpty()) {
            this.edit = true;
        }
        GapContent gap = new GapContent(texts.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(path)) {
            docs.add(path);
        }
        this.openEditorTab(this.doc);
        this.insertStringTags(this.doc, texts.toString());
        texts.setLength(0);
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
    }

    public void loadFile(File file, String format, String enc) {
        String e;
        if (format != null && format.equals("Mac String Resources (*.strings)")) {
            this.forcedEncoding = "UTF-8";
            EncodingValidator v = new EncodingValidator(this.forcedEncoding);
            boolean b = v.validateFile(file);
            if (!b) {
                this.forcedEncoding = "UTF-16";
            }
            e = this.forcedEncoding;
        } else {
            e = enc;
        }
        String regExp = FormatChooser.getFormatRegEx(format);
        String outString = this.loadTextFile(file, e);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
        }
        if (this.skeletons.isEmpty()) {
            this.edit = true;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        this.insertStringTags(this.doc, outString);
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
    }

    private boolean saveFile() {
        Document doc = null;
        doc = this.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            return false;
        }
        String path = (String)doc.getProperty("path");
        if (path == null) {
            return this.saveAsFile();
        }
        if (path.length() == 0) {
            return false;
        }
        Boolean save = (Boolean)doc.getProperty("save");
        if (save == null || !save.booleanValue()) {
            return false;
        }
        File file = new File(path);
        return this.saveFile(file, doc);
    }

    private boolean saveAsFile() {
        Document doc = this.getDocument();
        Boolean save = (Boolean)doc.getProperty("save");
        if (save == null || !save.booleanValue()) {
            return false;
        }
        JFileChooser jFileChooser = new JFileChooser();
        FileFilters filters = new FileFilters();
        String filterName = this.edit ? "Text (*.txt)" : AppPreferences.format;
        filters.setFileFilters(FormatChooser.formatType, filterName, jFileChooser);
        jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE DOCUMENT"));
        jFileChooser.setCurrentDirectory(new File(AppPreferences.fileDirectory));
        String fs = (String)doc.getProperty("path");
        String tlang = (String)doc.getProperty("target-lang");
        if (fs == null) {
            fs = "";
        }
        if (tlang != null) {
            int ind = fs.lastIndexOf(".");
            if (ind != -1) {
                String ext = fs.substring(ind);
                fs = fs.substring(0, ind) + "_" + tlang + ext;
            } else {
                fs = fs + tlang;
            }
        }
        jFileChooser.setSelectedFile(new File(fs));
        jFileChooser.repaint();
        if (0 == jFileChooser.showSaveDialog(this.topui)) {
            int i;
            File newFile = jFileChooser.getSelectedFile();
            AppPreferences.fileDirectory = newFile.getParent();
            String oldpath = (String)doc.getProperty("path");
            String path = newFile.getPath();
            doc.putProperty("path", path);
            doc.putProperty("file", newFile);
            List docs = this.topui.getResourceLoader().getDocumentLoaderList();
            if (oldpath != null) {
                docs.remove(oldpath);
            }
            docs.add(path);
            String oname = (String)doc.getProperty("name");
            String name = newFile.getName();
            JTabbedPane tabpane = this.tview.getTabbedPane();
            if (oname != null && (i = tabpane.indexOfTab(oname)) != -1) {
                tabpane.setTitleAt(i, name);
            }
            doc.putProperty("name", name);
            return this.saveFile(newFile, doc);
        }
        return false;
    }

    public void storeFileAlt(File tempFile, String text, String enc) {
        try {
            FileOutputStream out = new FileOutputStream(tempFile);
            BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, enc));
            awriter.write(text);
            awriter.close();
        }
        catch (IOException ex) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeFile(File tempFile, String text, String enc) {
        String e = this.forcedEncoding != null ? this.forcedEncoding : enc;
        FileOutputStream fos = null;
        try {
            Charset charset = Charset.isSupported(e) ? Charset.forName(e) : Charset.forName("UTF-8");
            CharsetEncoder encoder = charset.newEncoder();
            encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            encoder.onMalformedInput(CodingErrorAction.REPLACE);
            fos = new FileOutputStream(tempFile);
            FileChannel fc = fos.getChannel();
            CharBuffer cb = CharBuffer.wrap(text.toCharArray());
            ByteBuffer bb = encoder.encode(cb);
            fc.write(bb);
            fos.close();
        }
        catch (IOException ex) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public boolean saveFile(File file, Document doc) {
        try {
            String text = "";
            if (this.skeletons.size() > 0) {
                String[] texts = this.insertContent(doc);
                if (texts == null) {
                    JOptionPane.showMessageDialog(this.topui, "The original source language document has been modified. Export may fail or be incomplete.");
                    return false;
                }
                for (int i = 0; i < texts.length; ++i) {
                    String string = texts[i];
                    text = text + string;
                }
            } else {
                text = doc.getText(0, doc.getLength());
            }
            File tempFile = File.createTempFile("Exp", file.getName(), file.getParentFile());
            this.storeFile(tempFile, text, AppPreferences.en);
            if (file.exists()) {
                file.delete();
            }
            if (tempFile.renameTo(file)) {
                Boolean state = false;
                doc.putProperty("state", state);
            } else {
                JOptionPane.showMessageDialog(this.topui, "CafeTran cannot rename the file to " + file.getName());
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, e.getMessage());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, "The original source language document has been modified. Export may fail or be incomplete.");
        }
        return false;
    }

    private boolean okToAbandon() {
        if (this.textPane != null && !this.textPane.isEditable()) {
            return true;
        }
        Document doc = this.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            return true;
        }
        int value = JOptionPane.showConfirmDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE CHANGES IN THE DOCUMENT?"), "CafeTran", 1);
        switch (value) {
            case 0: {
                return this.saveFile();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public void setEditable(boolean edit) {
        if (this.textPane != null) {
            this.textPane.setEditable(edit);
        }
    }

    public boolean isUncleaned() {
        return this.isUncleaned;
    }

    public Document getDocument() {
        return this.doc;
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public void newDocument(String name) {
        this.createEditorTab(name);
    }

    @Override
    public void newResource() {
        this.createEditorTab(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW"));
    }

    @Override
    public void openResource() {
    }

    @Override
    public void saveAsResource() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextDocument.this.saveAsFile();
            }
        });
    }

    @Override
    public void saveResource() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextDocument.this.saveFile();
            }
        });
    }

    @Override
    public void closeResource() {
        Object o = this.getDocument().getProperty("path");
        if (o != null) {
            String path = o.toString();
            List docs = this.topui.getResourceLoader().getDocumentLoaderList();
            docs.remove(path);
        }
        this.doc = null;
        this.tview = this.topui.getTabView();
        this.tview.removeTab(this.name);
    }

    @Override
    public void printResource() {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.PRINT)) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENT PRINT ACTION IS NOT SUPPORTED ON YOUR SYSTEM."), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SYSTEM INFORMATION"), 1);
            this.topui.printTextComponent();
        } else {
            Document doc = this.getDocument();
            File file = (File)doc.getProperty("file");
            if (file != null && file.toString().indexOf(46) != -1) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.print(file);
                }
                catch (IOException ex) {
                    this.topui.printTextComponent();
                }
            } else {
                this.topui.printTextComponent();
            }
        }
    }

    @Override
    public void nextResource() {
        Document doc = this.getDocument();
        this.undoHandler = (MyUndoListener)doc.getProperty("undohandler");
        this.undoHandler.redoAction();
    }

    @Override
    public void previousResource() {
        Document doc = this.getDocument();
        this.undoHandler = (MyUndoListener)doc.getProperty("undohandler");
        this.undoHandler.undoAction();
    }

    @Override
    public void plusResource() {
        if (this.textPane != null) {
            Font font = this.textPane.getFont();
            float size = font.getSize() + 1;
            font = font.deriveFont(size);
            this.textPane.setFont(font);
            MutableAttributeSet attr = this.textPane.getInputAttributes();
            StyleConstants.setFontFamily(attr, font.getFamily());
            StyleConstants.setFontSize(attr, font.getSize());
            StyledDocument doc = this.textPane.getStyledDocument();
            doc.setCharacterAttributes(0, doc.getLength(), attr, false);
        }
    }

    @Override
    public void minusResource() {
        if (this.textPane != null) {
            Font font = this.textPane.getFont();
            float size = font.getSize() - 1;
            font = font.deriveFont(size);
            this.textPane.setFont(font);
            MutableAttributeSet attr = this.textPane.getInputAttributes();
            StyleConstants.setFontFamily(attr, font.getFamily());
            StyleConstants.setFontSize(attr, font.getSize());
            StyledDocument doc = this.textPane.getStyledDocument();
            doc.setCharacterAttributes(0, doc.getLength(), attr, false);
        }
    }

    @Override
    public void search(String m, String r) {
        m = this.topui.getResourceView().prepareSearchString(m);
        this.lookUpText(m, r, -1);
    }

    @Override
    public void stopSearch() {
        if (this.worker != null) {
            this.worker.interrupt();
        }
    }

    private void lookUpText(final String m, final String r, final int pos) {
        if (this.textPane == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ TextDocument this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                JTextPane jt = this.this$0.textPane;
                if (jt != null) {
                    Document doc = jt.getDocument();
                    String text = null;
                    try {
                        text = doc.getText(0, doc.getLength());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Pattern p = AppPreferences.searchCase ? Pattern.compile(m) : Pattern.compile(m, 2);
                        Matcher ma = p.matcher(text);
                        int i = pos != -1 ? pos : jt.getCaretPosition();
                        if (ma.find(i)) {
                            if (r != null && jt.isEditable()) {
                                int o = JOptionPane.showConfirmDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REPLACE ALL?"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AND REPLACE"), 0);
                                if (o == 0) {
                                    StringBuffer sb = new StringBuffer();
                                    do {
                                        ma.appendReplacement(sb, r);
                                    } while (ma.find());
                                    if (sb.length() > 0) {
                                        ma.appendTail(sb);
                                        ((JTextComponent)jt).setText(sb.toString());
                                        jt.setCaretPosition(i);
                                        jt.requestFocus();
                                    }
                                } else {
                                    jt.setRequestFocusEnabled(false);
                                    jt.setSelectionStart(ma.start());
                                    jt.setSelectionEnd(ma.end());
                                    ((JTextComponent)jt).replaceSelection(r);
                                    jt.setSelectionStart(ma.start());
                                    jt.setSelectionEnd(ma.start() + r.length());
                                    jt.setRequestFocusEnabled(true);
                                    jt.requestFocus();
                                }
                            } else {
                                jt.setRequestFocusEnabled(false);
                                jt.setSelectionStart(ma.start());
                                jt.setSelectionEnd(ma.end());
                                jt.setRequestFocusEnabled(true);
                                jt.requestFocus();
                            }
                        } else {
                            int o = JOptionPane.showConfirmDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NOT FOUND. CONTINUE FROM THE START?"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND AND REPLACE"), 0);
                            if (o == 0) {
                                this.this$0.lookUpText(m, r, 0);
                                jt.repaint();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (m.startsWith(">") && m.startsWith(">fca=") && (AppPreferences.fca = m.substring(m.indexOf("=") + 1)).indexOf("newline") != -1) {
                        AppPreferences.fca = AppPreferences.fca.replaceAll("newline", "\n");
                    }
                }
            }
        });
    }

    void setSegmentStyle() {
        if (this.textPane != null) {
            Color segment = new Color(AppPreferences.segment);
            if (AppPreferences.backGrid || AppPreferences.pBackgroundIm.length() > 0) {
                segment = this.topui.toAlphaColor(segment, 85);
            }
            Color segment2 = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.pBackgroundIm.length() > 0) {
                segment2 = this.topui.toAlphaColor(segment2, 85);
            }
            this.myHighlightPainter = new MyHighlightPainter(segment);
            this.myHighlightPainter2 = new MyHighlightPainter(segment2);
            this.hasHighlighter = true;
            this.taghighlight1 = null;
            this.taghighlight2 = null;
        }
    }

    void cancelSegmentStyle() {
        if (this.textPane != null) {
            Highlighter hilite = this.textPane.getHighlighter();
            Highlighter.Highlight[] hilites = hilite.getHighlights();
            for (int i = 0; i < hilites.length; ++i) {
                if (!(hilites[i].getPainter() instanceof MyHighlightPainter)) continue;
                hilite.removeHighlight(hilites[i]);
            }
            this.taghighlight1 = null;
            this.taghighlight2 = null;
        }
    }

    @Override
    public String getLocation() {
        String href = null;
        Document doc = this.getDocument();
        href = (String)doc.getProperty("path");
        return href;
    }

    @Override
    public String getSourceContent() {
        try {
            Document doc = this.getDocument();
            String source = doc.getText(0, doc.getLength());
            if (source.length() == 0) {
                return null;
            }
            doc.putProperty("source", new Boolean(true));
            this.endPosition = doc.getLength();
            this.startPosition = 0;
            if (this.textPane != null) {
                String sel = this.textPane.getSelectedText();
                if (sel != null) {
                    this.startPosition = this.textPane.getSelectionStart();
                    this.endPosition = this.textPane.getSelectionEnd();
                }
                if (this.textPane.isEditable()) {
                    this.textPane.setEditable(false);
                    this.textPane.putClientProperty("edit", new Boolean(true));
                } else {
                    this.textPane.putClientProperty("edit", new Boolean(false));
                }
                if (this.taghighlight1 != null || this.taghighlight2 != null) {
                    this.cancelSegmentStyle();
                }
                this.setSegmentStyle();
            }
            return source;
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return null;
        }
    }

    @Override
    public int getStartPosition() {
        return this.startPosition;
    }

    @Override
    public int getEndPosition() {
        return this.endPosition;
    }

    @Override
    public void highlightSegment(int from, int to, String segment) {
        if (this.textPane != null) {
            int len = this.doc.getLength();
            if (to < len) {
                this.textPane.setCaretPosition(to);
            }
            if (!this.hasHighlighter) {
                this.setSegmentStyle();
            }
            try {
                Highlighter hilite = this.textPane.getHighlighter();
                if (segment != null) {
                    if (this.taghighlight1 != null) {
                        hilite.changeHighlight(this.taghighlight1, from, to);
                    } else {
                        this.taghighlight1 = hilite.addHighlight(from, to, this.myHighlightPainter);
                    }
                } else if (this.taghighlight2 != null) {
                    hilite.changeHighlight(this.taghighlight2, from, to);
                } else {
                    this.taghighlight2 = hilite.addHighlight(from, to, this.myHighlightPainter2);
                }
            }
            catch (Exception ble) {
                ble.printStackTrace();
            }
        }
    }

    public String translate(Document sdoc, Project pr) {
        String s = null;
        s = this.isUncleaned ? pr.translateUnclean(sdoc) : pr.translate(sdoc);
        return s;
    }

    @Override
    public void preview(Project pr, String spath) {
        Document sdoc = this.getDocument();
        String path = (String)sdoc.getProperty("path");
        String prev = null;
        prev = this.isUncleaned ? pr.previewUnclean(sdoc) : pr.preview(sdoc);
        if (prev != null && path != null) {
            String prevFilePath;
            PlainDocument tdoc = new PlainDocument();
            try {
                tdoc.insertString(0, prev, null);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            File file = new File(path);
            String name = file.getName();
            String extention = null;
            int i = name.lastIndexOf(".");
            extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
            String parent = file.getParent();
            if (spath == null) {
                prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
            } else {
                prevFilePath = spath.toLowerCase().endsWith(extention) ? spath : spath + extention;
                if (prevFilePath.equalsIgnoreCase(path)) {
                    JOptionPane.showMessageDialog(this.topui, "Never overwrite the original source language document!");
                    return;
                }
            }
            File previewFile = new File(prevFilePath);
            boolean save = this.saveFile(previewFile, tdoc);
            if (!save) {
                this.preview2(pr, spath);
            } else if (spath == null) {
                this.topui.getResourceView().viewFile(previewFile);
            }
        }
    }

    public void preview2(Project pr, String spath) {
        Document sdoc = this.getDocument();
        String path = (String)sdoc.getProperty("path");
        String prev = null;
        if (this.isUncleaned) {
            return;
        }
        prev = pr.preview2(sdoc);
        if (prev != null && path != null) {
            String prevFilePath;
            PlainDocument tdoc = new PlainDocument();
            try {
                tdoc.insertString(0, prev, null);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            File file = new File(path);
            String name = file.getName();
            String extention = null;
            int i = name.lastIndexOf(".");
            extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
            String parent = file.getParent();
            if (spath == null) {
                prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
            } else {
                prevFilePath = spath.toLowerCase().endsWith(extention) ? spath : spath + extention;
                if (prevFilePath.equalsIgnoreCase(path)) {
                    JOptionPane.showMessageDialog(this.topui, "Never overwrite the original source language document!");
                    return;
                }
            }
            File previewFile = new File(prevFilePath);
            boolean save = this.saveFile(previewFile, tdoc);
            if (save && spath == null) {
                this.topui.getResourceView().viewFile(previewFile);
            }
        }
    }

    @Override
    public boolean setTargetContent(Project p) {
        ParagraphStyledDocument sdoc = (ParagraphStyledDocument)this.getDocument();
        String s = this.translate(sdoc, p);
        if (s != null && s.length() > 0) {
            try {
                sdoc.remove(0, sdoc.getLength());
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.insertStringTags(sdoc, s);
            sdoc.setContents();
            if (this.textPane != null) {
                this.cancelSegmentStyle();
                Boolean e = (Boolean)this.textPane.getClientProperty("edit");
                if (e != null && e.booleanValue()) {
                    this.textPane.setEditable(true);
                }
                this.textPane.setCaretPosition(0);
            }
            this.saveResource();
            return true;
        }
        return false;
    }

    public void setCustomFormatMap(String format) {
        if (format.equals("Ms Word (*.docx/xml)") || format.equals("Ms Word OCR (*.docx/xml)")) {
            this.customFormatMap = new HashMap();
            this.customFormatMap.put("\n", "</w:t><w:br/><w:t xml:space=\"preserve\">");
            this.customFormatMap.put("&lt;b&gt;", "</w:t></w:r><w:r><w:rPr><w:b/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;/b&gt;", "</w:t></w:r><w:r>");
            this.customFormatMap.put("&lt;i&gt;", "</w:t></w:r><w:r><w:rPr><w:i/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;/i&gt;", "</w:t></w:r><w:r>");
            this.customFormatMap.put("&lt;u&gt;", "</w:t></w:r><w:r><w:rPr><w:u w:val=\"single\"/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;/u&gt;", "</w:t></w:r><w:r>");
            this.customFormatMap.put("&lt;sub&gt;", "</w:t></w:r><w:r><w:rPr><w:vertAlign w:val=\"subscript\"/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;/sub&gt;", "</w:t></w:r><w:r>");
            this.customFormatMap.put("&lt;sup&gt;", "</w:t></w:r><w:r><w:rPr><w:vertAlign w:val=\"superscript\"/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;/sup&gt;", "</w:t></w:r><w:r>");
            this.customFormatMap.put("&lt;mark&gt;", "</w:t></w:r><w:r><w:rPr><w:shd w:fill=\"XXX\"/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;/mark&gt;", "</w:t></w:r><w:r>");
            this.customFormatMap.put("&lt;b&gt;&lt;i&gt;", "</w:t></w:r><w:r><w:rPr><w:b/><w:i/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;i&gt;&lt;b&gt;", "</w:t></w:r><w:r><w:rPr><w:b/><w:i/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;b&gt;&lt;u&gt;", "</w:t></w:r><w:r><w:rPr><w:b/><w:u w:val=\"single\"/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;u&gt;&lt;b&gt;", "</w:t></w:r><w:r><w:rPr><w:b/><w:u w:val=\"single\"/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;u&gt;&lt;i&gt;", "</w:t></w:r><w:r><w:rPr><w:i/><w:u w:val=\"single\"/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;i&gt;&lt;u&gt;", "</w:t></w:r><w:r><w:rPr><w:i/><w:u w:val=\"single\"/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;b&gt;&lt;i&gt;&lt;u&gt;", "</w:t></w:r><w:r><w:rPr><w:b/><w:i/><w:u w:val=\"single\"/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;b&gt;&lt;u&gt;&lt;i&gt;", "</w:t></w:r><w:r><w:rPr><w:b/><w:i/><w:u w:val=\"single\"/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;u&gt;&lt;i&gt;&lt;b&gt;", "</w:t></w:r><w:r><w:rPr><w:b/><w:i/><w:u w:val=\"single\"/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;u&gt;&lt;b&gt;&lt;i&gt;", "</w:t></w:r><w:r><w:rPr><w:b/><w:i/><w:u w:val=\"single\"/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;i&gt;&lt;b&gt;&lt;u&gt;", "</w:t></w:r><w:r><w:rPr><w:b/><w:i/><w:u w:val=\"single\"/></w:rPr><w:t>");
            this.customFormatMap.put("&lt;i&gt;&lt;u&gt;&lt;b&gt;", "</w:t></w:r><w:r><w:rPr><w:b/><w:i/><w:u w:val=\"single\"/></w:rPr><w:t>");
        } else if (format.equals("LibreOffice (*.odt/ods/odp/odg)")) {
            this.customFormatMap = new HashMap();
            this.customFormatMap.put("&lt;b&gt;", "<text:span text:style-name=\"T101\">");
            this.customFormatMap.put("&lt;/b&gt;", "</text:span>");
            this.customFormatMap.put("&lt;i&gt;", "<text:span text:style-name=\"T102\">");
            this.customFormatMap.put("&lt;/i&gt;", "</text:span>");
            this.customFormatMap.put("&lt;u&gt;", "<text:span text:style-name=\"T103\">");
            this.customFormatMap.put("&lt;/u&gt;", "</text:span>");
            this.customFormatMap.put("&lt;sub&gt;", "<text:span text:style-name=\"T104\">");
            this.customFormatMap.put("&lt;/sub&gt;", "</text:span>");
            this.customFormatMap.put("&lt;sup&gt;", "<text:span text:style-name=\"T105\">");
            this.customFormatMap.put("&lt;/sup&gt;", "</text:span>");
            this.customFormatMap.put("&lt;mark&gt;", "<text:span text:style-name=\"T110\">");
            this.customFormatMap.put("&lt;/mark&gt;", "</text:span>");
            this.customFormatMap.put("&lt;b&gt;&lt;i&gt;", "<text:span text:style-name=\"T106\">");
            this.customFormatMap.put("&lt;i&gt;&lt;b&gt;", "<text:span text:style-name=\"T106\">");
            this.customFormatMap.put("&lt;u&gt;&lt;i&gt;", "<text:span text:style-name=\"T107\">");
            this.customFormatMap.put("&lt;i&gt;&lt;u&gt;", "<text:span text:style-name=\"T107\">");
            this.customFormatMap.put("&lt;u&gt;&lt;b&gt;", "<text:span text:style-name=\"T108\">");
            this.customFormatMap.put("&lt;b&gt;&lt;u&gt;", "<text:span text:style-name=\"T108\">");
            this.customFormatMap.put("&lt;b&gt;&lt;i&gt;&lt;u&gt;", "<text:span text:style-name=\"T109\">");
            this.customFormatMap.put("&lt;b&gt;&lt;u&gt;&lt;i&gt;", "<text:span text:style-name=\"T109\">");
            this.customFormatMap.put("&lt;u&gt;&lt;i&gt;&lt;b&gt;", "<text:span text:style-name=\"T109\">");
            this.customFormatMap.put("&lt;u&gt;&lt;b&gt;&lt;i&gt;", "<text:span text:style-name=\"T109\">");
            this.customFormatMap.put("&lt;i&gt;&lt;b&gt;&lt;u&gt;", "<text:span text:style-name=\"T109\">");
            this.customFormatMap.put("&lt;i&gt;&lt;u&gt;&lt;b&gt;", "<text:span text:style-name=\"T109\">");
        } else if (format.equals("Ms PowerPoint (*.pptx)")) {
            this.customFormatMap = new HashMap();
            this.customFormatMap.put("&lt;b&gt;", "</a:t></a:r><a:r><a:rPr b=\"1\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;/b&gt;", "</a:t></a:r><a:r>");
            this.customFormatMap.put("&lt;i&gt;", "</a:t></a:r><a:r><a:rPr i=\"1\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;/i&gt;", "</a:t></a:r><a:r><a:t>");
            this.customFormatMap.put("&lt;u&gt;", "</a:t></a:r><a:r><a:rPr u=\"sng\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;/u&gt;", "</a:t></a:r><a:r>");
            this.customFormatMap.put("&lt;sub&gt;", "</a:t></a:r><a:r><a:rPr baseline=\"-33000\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;/sub&gt;", "</a:t></a:r><a:r>");
            this.customFormatMap.put("&lt;sup&gt;", "</a:t></a:r><a:r><a:rPr baseline=\"40000\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;/sup&gt;", "</a:t></a:r><a:r>");
            this.customFormatMap.put("&lt;mark&gt;", "</a:t></a:r><a:r><a:rPr><a:highlight><a:srgbClr val=\"XXX\"/></a:highlight></a:rPr><a:t>");
            this.customFormatMap.put("&lt;/mark&gt;", "</a:t></a:r><a:r>");
            this.customFormatMap.put("&lt;b&gt;&lt;i&gt;", "</a:t></a:r><a:r><a:rPr b=\"1\" i=\"1\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;i&gt;&lt;b&gt;", "</a:t></a:r><a:r><a:rPr b=\"1\" i=\"1\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;b&gt;&lt;u&gt;", "</a:t></a:r><a:r><a:rPr b=\"1\" u=\"sng\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;u&gt;&lt;b&gt;", "</a:t></a:r><a:r><a:rPr b=\"1\" u=\"sng\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;u&gt;&lt;i&gt;", "</a:t></a:r><a:r><a:rPr i=\"1\" u=\"sng\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;i&gt;&lt;u&gt;", "</a:t></a:r><a:r><a:rPr i=\"1\" u=\"sng\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;b&gt;&lt;i&gt;&lt;u&gt;", "</a:t></a:r><a:r><a:rPr b=\"1\" i=\"1\" u=\"sng\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;b&gt;&lt;u&gt;&lt;i&gt;", "</a:t></a:r><a:r><a:rPr b=\"1\" i=\"1\" u=\"sng\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;u&gt;&lt;i&gt;&lt;b&gt;", "</a:t></a:r><a:r><a:rPr b=\"1\" i=\"1\" u=\"sng\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;u&gt;&lt;b&gt;&lt;i&gt;", "</a:t></a:r><a:r><a:rPr b=\"1\" i=\"1\" u=\"sng\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;i&gt;&lt;b&gt;&lt;u&gt;", "</a:t></a:r><a:r><a:rPr b=\"1\" i=\"1\" u=\"sng\"></a:rPr><a:t>");
            this.customFormatMap.put("&lt;i&gt;&lt;u&gt;&lt;b&gt;", "</a:t></a:r><a:r><a:rPr b=\"1\" i=\"1\" u=\"sng\"></a:rPr><a:t>");
        } else if (format.equals("Ms Excel (*.xlsx)")) {
            this.customFormatMap = new HashMap();
            this.customFormatMap.put("&lt;b&gt;", "<r><rPr><b val=\"true\"/></rPr><t>");
            this.customFormatMap.put("&lt;/b&gt;", "</t></r>");
            this.customFormatMap.put("&lt;i&gt;", "<r><rPr><i val=\"true\"/></rPr><t>");
            this.customFormatMap.put("&lt;/i&gt;", "</t></r>");
            this.customFormatMap.put("&lt;u&gt;", "<r><rPr><u val=\"single\"/></rPr><t>");
            this.customFormatMap.put("&lt;/u&gt;", "</t></r>");
            this.customFormatMap.put("&lt;sub&gt;", "<r><rPr><vertAlign val=\"subscript\"/></rPr><t>");
            this.customFormatMap.put("&lt;/sub&gt;", "</t></r>");
            this.customFormatMap.put("&lt;sup&gt;", "<r><rPr><vertAlign val=\"superscript\"/></rPr><t>");
            this.customFormatMap.put("&lt;/sup&gt;", "</t></r>");
            this.customFormatMap.put("&lt;b&gt;&lt;i&gt;", "<r><rPr><b val=\"true\"/><i val=\"true\"/></rPr><t>");
            this.customFormatMap.put("&lt;i&gt;&lt;b&gt;", "<r><rPr><b val=\"true\"/><i val=\"true\"/></rPr><t>");
            this.customFormatMap.put("&lt;b&gt;&lt;u&gt;", "<r><rPr><b val=\"true\"/><u val=\"single\"/></rPr><t>");
            this.customFormatMap.put("&lt;u&gt;&lt;b&gt;", "<r><rPr><b val=\"true\"/><u val=\"single\"/></rPr><t>");
            this.customFormatMap.put("&lt;u&gt;&lt;i&gt;", "<r><rPr><i val=\"true\"/><u val=\"single\"/></rPr><t>");
            this.customFormatMap.put("&lt;i&gt;&lt;u&gt;", "<r><rPr><i val=\"true\"/><u val=\"single\"/></rPr><t>");
            this.customFormatMap.put("&lt;b&gt;&lt;i&gt;&lt;u&gt;", "<r><rPr><b val=\"true\"/><i val=\"true\"/><u val=\"single\"/></rPr><t>");
            this.customFormatMap.put("&lt;b&gt;&lt;u&gt;&lt;i&gt;", "<r><rPr><b val=\"true\"/><i val=\"true\"/><u val=\"single\"/></rPr><t>");
            this.customFormatMap.put("&lt;u&gt;&lt;i&gt;&lt;b&gt;", "<r><rPr><b val=\"true\"/><i val=\"true\"/><u val=\"single\"/></rPr><t>");
            this.customFormatMap.put("&lt;u&gt;&lt;b&gt;&lt;i&gt;", "<r><rPr><b val=\"true\"/><i val=\"true\"/><u val=\"single\"/></rPr><t>");
            this.customFormatMap.put("&lt;i&gt;&lt;b&gt;&lt;u&gt;", "<r><rPr><b val=\"true\"/><i val=\"true\"/><u val=\"single\"/></rPr><t>");
            this.customFormatMap.put("&lt;i&gt;&lt;u&gt;&lt;b&gt;", "<r><rPr><b val=\"true\"/><i val=\"true\"/><u val=\"single\"/></rPr><t>");
        }
    }

    protected String applyCustomFormat(String s, String inline) {
        if (!AppPreferences.convertCustomTags) {
            return s;
        }
        if (this.isWord) {
            return this.applyCustomFormatWord(s, inline);
        }
        if (this.isPowerPoint) {
            return this.applyCustomFormatPowerPoint(s, inline);
        }
        if (this.isExcel) {
            return this.applyCustomFormatExcel(s, inline);
        }
        return this.applyCustomFormatDefault(s, inline);
    }

    private String applyCustomFormatWord(String s, String inline) {
        Matcher m = this.customFormatPattern.matcher(s);
        StringBuffer sb = new StringBuffer();
        String previousProps = null;
        while (m.find()) {
            StringBuffer buffer;
            String r;
            int et;
            String g = m.group();
            if (g.startsWith("&lt;/") && (et = g.indexOf("&gt;")) != -1) {
                g = g.substring(0, et + 4);
            }
            if ((r = (String)this.customFormatMap.get(g)) == null) continue;
            if (inline != null && r.indexOf("<w:rPr>") != -1) {
                if (g.indexOf("mark") != -1) {
                    r = r.replace("XXX", Colors.highlightColorHTML.substring(1));
                }
                buffer = new StringBuffer(r);
                int i = inline.lastIndexOf("<w:rPr>");
                if (i != -1) {
                    int ii;
                    String ins;
                    int k;
                    int j;
                    int n = inline.indexOf("</w:rPr>", i);
                    if (n != -1) {
                        previousProps = inline.substring(i, n + 8);
                    }
                    if ((j = inline.indexOf("<w:lang ", i)) != -1 && (k = inline.indexOf(">", j)) != -1) {
                        ins = inline.substring(j, k + 1);
                        ii = buffer.indexOf("<w:rPr>");
                        if (ii != -1) {
                            buffer.insert(ii + 7, ins);
                        }
                    }
                    if ((j = inline.indexOf("<w:szCs ", i)) != -1 && (k = inline.indexOf(">", j)) != -1) {
                        ins = inline.substring(j, k + 1);
                        ii = buffer.indexOf("<w:rPr>");
                        if (ii != -1) {
                            buffer.insert(ii + 7, ins);
                        }
                    }
                    if ((j = inline.indexOf("<w:sz ", i)) != -1 && (k = inline.indexOf(">", j)) != -1) {
                        ins = inline.substring(j, k + 1);
                        ii = buffer.indexOf("<w:rPr>");
                        if (ii != -1) {
                            buffer.insert(ii + 7, ins);
                        }
                    }
                    if ((j = inline.indexOf("<w:rFonts", i)) != -1 && (k = inline.indexOf(">", j)) != -1) {
                        String fonts = inline.substring(j, k + 1);
                        ii = buffer.indexOf("<w:rPr>");
                        if (ii != -1) {
                            buffer.insert(ii + 7, fonts);
                        }
                    }
                    if ((j = inline.indexOf("<w:color", i)) != -1 && (k = inline.indexOf(">", j)) != -1) {
                        String color = inline.substring(j, k + 1);
                        ii = buffer.indexOf("<w:rPr>");
                        if (ii != -1) {
                            buffer.insert(ii + 7, color);
                        }
                    }
                    if ((j = inline.indexOf("<w:highlight", i)) != -1 && (k = inline.indexOf(">", j)) != -1) {
                        String hl = inline.substring(j, k + 1);
                        ii = buffer.indexOf("<w:rPr>");
                        if (ii != -1) {
                            buffer.insert(ii + 7, hl);
                        }
                    }
                }
                r = buffer.toString();
            } else if (inline != null && r.endsWith("<w:r>")) {
                buffer = new StringBuffer(r);
                if (previousProps != null) {
                    buffer.append(previousProps);
                    previousProps = null;
                }
                buffer.append("<w:t xml:space=\"preserve\">");
                r = buffer.toString();
            }
            m.appendReplacement(sb, r);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String applyCustomFormatPowerPoint(String s, String inline) {
        Matcher m = this.customFormatPattern.matcher(s);
        StringBuffer sb = new StringBuffer();
        String previousProps = null;
        String previousPropsPart = null;
        while (m.find()) {
            StringBuffer buffer;
            String r;
            int et;
            String g = m.group();
            if (g.startsWith("&lt;/") && (et = g.indexOf("&gt;")) != -1) {
                g = g.substring(0, et + 4);
            }
            if ((r = (String)this.customFormatMap.get(g)) == null) continue;
            if (inline != null && r.indexOf("<a:rPr") != -1) {
                if (g.indexOf("mark") != -1) {
                    r = r.replace("XXX", Colors.highlightColorHTML.substring(1));
                }
                buffer = new StringBuffer(r);
                int i = inline.lastIndexOf("<a:rPr");
                if (i != -1) {
                    int ii;
                    String ins;
                    int k;
                    int j;
                    int p = inline.indexOf(">", i);
                    int n = inline.indexOf("</a:rPr>", i);
                    if (n != -1) {
                        previousProps = inline.substring(i, n + 8);
                        previousPropsPart = inline.substring(p + 1, n);
                    }
                    if ((j = inline.indexOf("lang=\"", i)) != -1 && (k = inline.indexOf("\"", j + 6)) != -1) {
                        ins = inline.substring(j, k + 1);
                        ii = buffer.indexOf("<a:rPr");
                        if (ii != -1) {
                            buffer.insert(ii + 6, " " + ins);
                        }
                    }
                    if ((j = inline.indexOf("sz=\"", i)) != -1 && (k = inline.indexOf("\"", j + 4)) != -1) {
                        ins = inline.substring(j, k + 1);
                        ii = buffer.indexOf("<a:rPr");
                        if (ii != -1) {
                            buffer.insert(ii + 6, " " + ins);
                        }
                    }
                    if (previousPropsPart != null && previousPropsPart.length() > 0) {
                        k = buffer.indexOf("</a:rPr>");
                        if (k != -1) {
                            buffer.insert(k, previousPropsPart);
                        }
                        previousPropsPart = null;
                    }
                }
                r = buffer.toString();
            } else if (inline != null && r.endsWith("<a:r>")) {
                buffer = new StringBuffer(r);
                if (previousProps != null) {
                    buffer.append(previousProps);
                    previousProps = null;
                }
                buffer.append("<a:t>");
                r = buffer.toString();
            }
            m.appendReplacement(sb, r);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String applyCustomFormatExcel(String s, String inline) {
        if (inline == null) {
            return s;
        }
        boolean noRun = false;
        if (inline.endsWith("<si><t>") || inline.endsWith("<si><t xml:space=\"preserve\">")) {
            noRun = true;
        } else if (inline.indexOf("</rPr><t") == -1 && inline.indexOf("<r><t") == -1) {
            return s;
        }
        Matcher m = this.customFormatPattern.matcher(s);
        StringBuffer sb = new StringBuffer();
        String previousProps = null;
        while (m.find()) {
            StringBuffer buffer;
            String r;
            int et;
            String g = m.group();
            if (g.startsWith("&lt;/") && (et = g.indexOf("&gt;")) != -1) {
                g = g.substring(0, et + 4);
            }
            if ((r = (String)this.customFormatMap.get(g)) == null) continue;
            if (!r.equals("</t></r>")) {
                r = !noRun ? "</t></r>" + r : "</t>" + r;
            }
            if (r.indexOf("<rPr>") != -1) {
                buffer = new StringBuffer(r);
                int i = inline.lastIndexOf("<rPr>");
                if (i != -1) {
                    String fonts;
                    int ii;
                    String ins;
                    int k;
                    int j;
                    int n = inline.indexOf("</rPr>", i);
                    if (n != -1) {
                        previousProps = inline.substring(i, n + 6);
                    }
                    if ((j = inline.indexOf("<charset ", i)) != -1 && (k = inline.indexOf(">", j)) != -1) {
                        ins = inline.substring(j, k + 1);
                        ii = buffer.indexOf("<rPr>");
                        if (ii != -1) {
                            buffer.insert(ii + 5, ins);
                        }
                    }
                    if ((j = inline.indexOf("<sz ", i)) != -1 && (k = inline.indexOf(">", j)) != -1) {
                        ins = inline.substring(j, k + 1);
                        ii = buffer.indexOf("<rPr>");
                        if (ii != -1) {
                            buffer.insert(ii + 5, ins);
                        }
                    }
                    if ((j = inline.indexOf("<rFont", i)) != -1 && (k = inline.indexOf(">", j)) != -1) {
                        fonts = inline.substring(j, k + 1);
                        ii = buffer.indexOf("<rPr>");
                        if (ii != -1) {
                            buffer.insert(ii + 5, fonts);
                        }
                    }
                    if ((j = inline.indexOf("<family", i)) != -1 && (k = inline.indexOf(">", j)) != -1) {
                        fonts = inline.substring(j, k + 1);
                        ii = buffer.indexOf("<rPr>");
                        if (ii != -1) {
                            buffer.insert(ii + 5, fonts);
                        }
                    }
                }
                r = buffer.toString();
            } else if (r.endsWith("</r>")) {
                buffer = new StringBuffer(r);
                if (!noRun) {
                    buffer.append("<r>");
                }
                if (previousProps != null) {
                    buffer.append(previousProps);
                    previousProps = null;
                }
                if (!noRun) {
                    buffer.append("<t xml:space=\"preserve\">");
                } else {
                    buffer.append("<t>!!");
                }
                r = buffer.toString();
            }
            m.appendReplacement(sb, r);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String applyCustomFormatDefault(String s, String inline) {
        Matcher m = this.customFormatPattern.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String r;
            int et;
            String g = m.group();
            if (g.startsWith("&lt;/") && (et = g.indexOf("&gt;")) != -1) {
                g = g.substring(0, et + 4);
            }
            if ((r = (String)this.customFormatMap.get(g)) == null) continue;
            m.appendReplacement(sb, r);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public String getSegmentationRule() {
        return null;
    }

    protected String createStyleAttribute(int tstyle) {
        String attr;
        if (tstyle == 2) {
            attr = "bold";
        } else if (tstyle == 4) {
            attr = "italic";
        } else if (tstyle == 8) {
            attr = "underline";
        } else if (tstyle == 6) {
            attr = "bold;italic";
        } else if (tstyle == 10) {
            attr = "bold;underline";
        } else if (tstyle == 12) {
            attr = "italic;underline";
        } else if (tstyle == 14) {
            attr = "bold;italic;underline";
        } else if (tstyle == 16) {
            attr = "subscript";
        } else if (tstyle == 18) {
            attr = "superscript";
        } else if (tstyle == 20) {
            attr = "strikethrough";
        } else if (tstyle == 22) {
            attr = "caps";
        } else if (tstyle == 24) {
            attr = "smallcaps";
        } else {
            return null;
        }
        return attr;
    }
}

