/*
 * Decompiled with CFR 0.152.
 */
package translator.ttx;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Stack;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.NumbersHelper;
import translator.Prompter;
import translator.StopWords;
import translator.XMLElement;
import translator.XMLHelper;
import translator.hunspell.HunSpellChecker;
import translator.ttx.Raw;
import translator.ttx.TTXMenu;
import translator.ttx.TTXUnit;
import translator.ttx.TTXView;
import translator.ttx.TTXWorkflow;

public class TTX
extends DefaultXMLElement {
    private Raw currentFile;
    private Locale locale;
    private Locale srclocale;
    private HashMap projectMemory = new HashMap();
    private TTXView view;
    private static TTXWorkflow xworkflow;
    private String slang = "";
    private String tlang = "";
    private int id = -1;
    private String lastTUID;
    private String path;
    public boolean saved = true;
    int i = -1;

    public void setLastID(String tuid) {
        this.lastTUID = tuid;
    }

    public String getLastID() {
        return this.lastTUID;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    XMLElement getHeader() {
        XMLElement head = null;
        List list = this.getChildren("FrontMatter");
        if (list.size() > 0) {
            head = (XMLElement)list.get(0);
        }
        return head;
    }

    XMLElement getBody() {
        XMLElement body = null;
        List list = this.getChildren("Body");
        if (list.size() > 0) {
            body = (XMLElement)list.get(0);
        }
        return body;
    }

    public List getFiles() {
        XMLElement body = this.getBody();
        if (body != null) {
            return body.getChildren("Raw");
        }
        return null;
    }

    public Raw getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(Raw file) {
        XMLElement frontMatter = this.getHeader();
        XMLElement elem = null;
        List list = frontMatter.getChildren("UserSettings");
        if (list.size() > 0 && (elem = (XMLElement)list.get(0)) != null) {
            this.slang = elem.getAttribute("SourceLanguage");
            this.tlang = elem.getAttribute("TargetLanguage");
            this.setLocale(this.tlang);
            this.setSrcLocale(this.slang);
        }
        this.currentFile = file;
    }

    public String getSourceLang() {
        return this.slang;
    }

    public String getTargetLang() {
        return this.tlang;
    }

    public void setTargetLang(String lang) {
        String s;
        XMLElement frontMatter = this.getHeader();
        XMLElement elem = null;
        List list = frontMatter.getChildren("UserSettings");
        if (list.size() > 0 && (elem = (XMLElement)list.get(0)) != null && ((s = elem.getAttribute("TargetLanguage")) == null || s.length() == 0)) {
            elem.setAttribute("TargetLanguage", lang);
            this.slang = elem.getAttribute("SourceLanguage");
            this.tlang = elem.getAttribute("TargetLanguage");
            this.setLocale(this.tlang);
            this.setSrcLocale(this.slang);
        }
    }

    public void setLocale(String lang) {
        if (lang != null && lang.length() > 0) {
            String ccode;
            String lcode;
            int v;
            if (lang.equals("en")) {
                lang = "en-US";
            }
            if ((v = lang.indexOf(45)) == -1) {
                v = lang.indexOf(95);
            }
            if (v != -1) {
                lcode = lang.substring(0, v).toLowerCase();
                ccode = lang.substring(v + 1).toUpperCase();
            } else {
                lcode = lang.toLowerCase();
                ccode = lang.toUpperCase();
            }
            this.locale = new Locale(lcode, ccode);
            this.setSpellChecker(lcode + "_" + ccode);
            if (lcode.equals("ja") || lcode.equals("zh")) {
                AppPreferences.noWordSeparatorTargetLanguage = true;
                Prompter.imputMethodsOverlapping = lcode.equals("ja");
            } else {
                AppPreferences.noWordSeparatorTargetLanguage = false;
                Prompter.imputMethodsOverlapping = false;
            }
            NumbersHelper.setTargetLocale(this.locale);
            if (this.view != null) {
                this.view.topui.getTargetView().setTextComponentOrientation(this.locale);
                this.view.topui.getResourceView().getTextShortcuts().setDefaultShortcuts(this.locale);
            }
        }
    }

    private void setSpellChecker(String lang) {
        HunSpellChecker spell = this.view.topui.getSpellChecker();
        if (spell != null) {
            spell.setTargetLanguageDictionary(lang);
            spell.setBreakIterator(this.locale);
        }
    }

    public void setSrcLocale(String lang) {
        if (lang != null && lang.length() > 0) {
            if (lang.equals("en")) {
                lang = "en-US";
            }
            int v = lang.indexOf(95);
            int vv = lang.indexOf(45);
            this.srclocale = v != -1 ? new Locale(lang.substring(0, v).toLowerCase(), lang.substring(v + 1).toUpperCase()) : (vv != -1 ? new Locale(lang.substring(0, vv).toLowerCase(), lang.substring(vv + 1).toUpperCase()) : new Locale(lang.toLowerCase(), lang.toUpperCase()));
            AppPreferences.noWordSeparatorSourceLanguage = this.srclocale.getLanguage().equals("ja") || this.srclocale.getLanguage().equals("zh");
            StopWords.setStopWords(lang);
            this.view.topui.getSourceView().setTextComponentOrientation(this.srclocale);
            NumbersHelper.setSourceLocale(this.srclocale);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Locale getSrcLocale() {
        return this.srclocale;
    }

    public void setView(TTXView view) {
        this.view = view;
    }

    public TTXView getView() {
        return this.view;
    }

    public void setWorkflow(TTXWorkflow flow) {
        xworkflow = flow;
    }

    public TTXWorkflow getWorkflow() {
        return xworkflow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addToMemory(String source, TTXUnit tu, boolean propagate) {
        Object ob;
        int[] pos;
        int p;
        if (NumbersHelper.isExtendedNumber(source) && (p = (pos = tu.getSourceTagsPositions())[0]) == 0) {
            tu.number = true;
        }
        if ((ob = this.projectMemory.get(source)) != null) {
            Stack<TTXUnit> deck = null;
            if (ob instanceof TTXUnit) {
                TTXUnit tuu = (TTXUnit)ob;
                if (tu.equals(tuu)) return;
                deck = new Stack<TTXUnit>();
                deck.addElement(tuu);
                this.projectMemory.put(source, deck);
            } else {
                deck = (Stack<TTXUnit>)ob;
            }
            if (propagate) {
                for (Object e : deck) {
                    TTXUnit tuu = (TTXUnit)e;
                    if (tu.equals(tuu)) continue;
                    String target = tuu.getTargetText();
                    String targetNew = tu.getTargetText();
                    if (targetNew.length() <= 0 || target.equals(targetNew)) continue;
                    XMLElement tuss = tuu.getSource();
                    XMLElement tutt = tuu.getTarget();
                    if (tuss == null || tutt == null) continue;
                    tuu.propagate(targetNew, tu.getTargetTagsPositions());
                }
            }
            tu.repetition = true;
            deck.remove(tu);
            deck.add(0, tu);
            return;
        } else {
            this.projectMemory.put(source, tu);
        }
    }

    public String getFromMemory(String source, String[] tags) {
        Object o = this.projectMemory.get(source);
        if (o != null) {
            TTXUnit tu2 = null;
            if (o instanceof TTXUnit) {
                tu2 = (TTXUnit)o;
                String t = tu2.getTargetText();
                if (t.length() > 0) {
                    if (tags != null) {
                        int[] pos = tu2.getTargetTagsPositions();
                        t = this.setTargetTags(t, tags, pos);
                    }
                    return t;
                }
                return null;
            }
            Stack deck = (Stack)o;
            String t = null;
            for (TTXUnit tu2 : deck) {
                t = tu2.getTargetText();
                if (t.length() <= 0) continue;
                if (tags == null) break;
                int[] pos = tu2.getTargetTagsPositions();
                t = this.setTargetTags(t, tags, pos);
                break;
            }
            return t;
        }
        return null;
    }

    private String setTargetTags(String target, String[] tags, int[] pos) {
        int off = 0;
        StringBuffer sb = new StringBuffer(target);
        for (int i = 0; i < pos.length; ++i) {
            int j = pos[i];
            String tag = tags[i];
            if (j <= 0 || tag == null) break;
            if (sb.length() <= j + off) continue;
            sb = sb.insert(j + off, tag);
            off += tag.length();
        }
        return sb.toString();
    }

    public void edit(String s) {
        TTXMenu menu;
        int j;
        TTXView view;
        XMLElement xml;
        Raw file;
        List list;
        String tuid;
        int i;
        if (s.equals("END")) {
            int size;
            List tus = this.view.getViewUnits();
            if (tus != null && (size = tus.size()) > 0) {
                xworkflow.setCheckStart(size - 1);
                xworkflow.checkNextTU();
            }
        } else if (s.startsWith("#")) {
            String tuid2 = s.substring(1);
            int i2 = Integer.parseInt(tuid2);
            if (i2 == -1) {
                xworkflow.checkNextTU();
            } else if (i2 == -2) {
                xworkflow.checkPreviousTU();
            } else {
                if (i2 >= 0) {
                    xworkflow.setCheckStart(i2);
                }
                xworkflow.checkNextTU();
            }
        } else if (s.startsWith("$") && (i = Integer.parseInt(tuid = s.substring(1))) < (list = (file = this.getCurrentFile()).getChildren()).size() && (xml = (XMLElement)list.get(i)) != null && (view = this.getView()) != null && (j = (menu = view.getMenu()).showXMLElement(xml)) == 0) {
            list.remove(xml);
        }
    }

    public StringBuffer toAutoCompletion() {
        StringBuffer sb = new StringBuffer();
        List pfiles = this.getFiles();
        if (pfiles != null) {
            for (Raw file : pfiles) {
                List tus = file.getTransUnits();
                this.takeTUContent(tus, sb);
            }
        }
        return sb;
    }

    private void takeTUContent(Collection tus, StringBuffer sb) {
        for (TTXUnit tunit : tus) {
            String content = tunit.getTargetText();
            if (content.length() <= 0) continue;
            sb.append(content);
            sb.append(" ");
        }
    }

    private void prop(String source, String replacement, XMLElement tuss, XMLElement tutt) {
        if (tuss != null && tutt != null) {
            List tusList = tuss.getChildren();
            List tutList = tutt.getChildren();
            ListIterator sit = tusList.listIterator();
            ListIterator<String> tit = tutList.listIterator();
            while (sit.hasNext() && tit.hasNext()) {
                Object object1 = sit.next();
                Object object2 = tit.next();
                if (object1 == null || object2 == null) continue;
                if (object1 instanceof String && object2 instanceof String) {
                    String tsource = object1.toString();
                    String ttarget = object2.toString();
                    if (tsource.length() <= 0 || !tsource.equalsIgnoreCase(source) || ttarget.equalsIgnoreCase(replacement)) continue;
                    tit.set(replacement);
                    ++this.i;
                    continue;
                }
                if (!(object1 instanceof XMLElement) || !(object2 instanceof XMLElement)) continue;
                XMLElement subsource = (XMLElement)object1;
                XMLElement subtarget = (XMLElement)object2;
                this.prop(source, replacement, subsource, subtarget);
            }
        }
    }

    public int propagate(String source, String replacement) {
        this.i = 0;
        if (replacement != null && source != null) {
            source = XMLHelper.parseTags(source);
            replacement = XMLHelper.parseTags(replacement);
            List list = this.getFiles();
            if (list != null) {
                for (Raw file : list) {
                    List units = file.getTransUnits();
                    for (TTXUnit tuu : units) {
                        XMLElement tuss = tuu.getSource();
                        XMLElement tutt = tuu.getTarget();
                        this.prop(source, replacement, tuss, tutt);
                    }
                }
            }
        }
        return this.i;
    }

    private XMLElement segmentInternal(XMLElement elem) {
        List elements = elem.getChildren();
        boolean extTag = false;
        XMLElement tuv = null;
        boolean extUT = false;
        ListIterator<TTXUnit> itt = elements.listIterator();
        while (itt.hasNext()) {
            Object object = itt.next();
            boolean isString = false;
            if (object instanceof XMLElement) {
                XMLElement xml = (XMLElement)object;
                if (xml.getName().equals("ut")) {
                    String style = xml.getAttribute("Style");
                    if (style != null && style.equals("external") || extTag) {
                        extTag = true;
                        extUT = true;
                        tuv = null;
                    } else {
                        String type = xml.getAttribute("Type");
                        if (type != null && type.equals("end")) {
                            extTag = false;
                        } else {
                            String display = xml.getAttribute("DisplayText");
                            if (display != null && display.length() > 0) {
                                extTag = false;
                                extUT = true;
                            } else {
                                extTag = true;
                                extUT = true;
                                tuv = null;
                            }
                        }
                    }
                } else {
                    if (xml.getName().equals("Tu")) {
                        extTag = true;
                        extUT = false;
                        tuv = null;
                        break;
                    }
                    XMLElement x = this.segmentInternal(elem);
                    if (x != null) {
                        tuv = x;
                    } else if (tuv != null) {
                        itt.remove();
                        tuv.addChild(xml);
                        continue;
                    }
                }
            } else if (object instanceof String) {
                String ss = object.toString();
                String s = ss.trim();
                if (s.length() == 0) {
                    itt.remove();
                    continue;
                }
                object = s;
                extTag = false;
                isString = true;
            }
            if (extTag || !extUT || !isString) continue;
            if (tuv == null) {
                TTXUnit tu = this.createTU();
                tuv = this.creatTUV();
                tuv.addChild(object);
                tu.addChild(tuv);
                itt.set(tu);
                continue;
            }
            itt.remove();
            tuv.addChild(object);
        }
        if (tuv == null && extUT) {
            TTXUnit tu = this.createTU();
            tuv = this.creatTUV();
            tu.addChild(tuv);
            elem.addChild(tu);
        }
        return tuv;
    }

    public void segment() {
        List raws = this.getFiles();
        if (raws != null) {
            for (Raw raw : raws) {
                List elements = raw.getChildren();
                boolean extUT = false;
                boolean extTag = false;
                XMLElement tuv = null;
                ListIterator<TTXUnit> itt = elements.listIterator();
                while (itt.hasNext()) {
                    Object object = itt.next();
                    if (object instanceof XMLElement) {
                        XMLElement xml;
                        if (tuv == null) {
                            extTag = false;
                            extUT = false;
                        }
                        if ((xml = (XMLElement)object).getName().equals("df")) {
                            extTag = false;
                            extUT = true;
                        } else if (xml.getName().equals("ut")) {
                            String style = xml.getAttribute("Style");
                            if (style != null && style.equals("external") || extTag) {
                                extTag = true;
                                extUT = true;
                                tuv = null;
                            } else {
                                String type = xml.getAttribute("Type");
                                if (type != null && type.equals("end")) {
                                    extTag = false;
                                    extUT = true;
                                } else {
                                    String display = xml.getAttribute("DisplayText");
                                    if (display != null && display.length() > 0) {
                                        extTag = false;
                                        extUT = true;
                                    } else {
                                        extTag = true;
                                        extUT = true;
                                        tuv = null;
                                    }
                                }
                            }
                        } else if (xml.getName().equals("Tu")) {
                            extTag = true;
                            extUT = false;
                            tuv = null;
                        } else {
                            XMLElement x = this.segmentInternal(xml);
                            if (x != null) {
                                tuv = x;
                            } else if (tuv != null) {
                                itt.remove();
                                tuv.addChild(xml);
                                continue;
                            }
                        }
                    } else if (object instanceof String) {
                        String ss = object.toString();
                        String s = ss.trim();
                        if (s.length() == 0) {
                            itt.remove();
                            continue;
                        }
                        object = extTag ? s : ss;
                        extTag = false;
                    }
                    if (extTag || !extUT) continue;
                    if (tuv == null) {
                        TTXUnit tu = this.createTU();
                        tuv = this.creatTUV();
                        tuv.addChild(object);
                        tu.addChild(tuv);
                        itt.set(tu);
                        continue;
                    }
                    itt.remove();
                    tuv.addChild(object);
                }
            }
        }
    }

    private void removeLineBreaks(List elems) {
        ListIterator iterator = elems.listIterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof String) {
                String s = object.toString();
                if (!s.equals("\r\n") && !s.equals("\n")) continue;
                iterator.remove();
                continue;
            }
            if (!(object instanceof XMLElement)) continue;
            XMLElement xml = (XMLElement)object;
            this.removeLineBreaks(xml.getChildren());
        }
    }

    private void trimTUs(List elements) {
        ListIterator itt = elements.listIterator();
        while (itt.hasNext()) {
            Object object = itt.next();
            if (!(object instanceof XMLElement)) continue;
            XMLElement xml = (XMLElement)object;
            if (xml.getName().equals("Tu")) {
                TTXUnit tu = (TTXUnit)xml;
                if (tu.getSourceText().trim().length() == 0) {
                    itt.remove();
                    continue;
                }
                List elems = xml.getChildren();
                this.removeLineBreaks(elems);
                continue;
            }
            List elems = xml.getChildren();
            this.trimTUs(elems);
        }
    }

    public void trimLines() {
        List raws = this.getFiles();
        if (raws != null) {
            for (Raw raw : raws) {
                List elements = raw.getChildren();
                this.trimTUs(elements);
            }
        }
    }

    private TTXUnit createTU() {
        TTXUnit tu = new TTXUnit(this.id);
        tu.setAttribute("MatchPercent", "100");
        tu.setName("Tu");
        return tu;
    }

    private TTXUnit createTUOld(Object o) {
        TTXUnit tu = new TTXUnit(this.id);
        tu.setAttribute("MatchPercent", "100");
        tu.setName("Tu");
        DefaultXMLElement tuv = new DefaultXMLElement();
        String lang = this.getSourceLang();
        if (lang != null) {
            tuv.setAttribute("Lang", lang);
        }
        tuv.setName("Tuv");
        tuv.addChild(o);
        tu.addChild(tuv);
        return tu;
    }

    private DefaultXMLElement creatTUV() {
        DefaultXMLElement tuv = new DefaultXMLElement();
        String lang = this.getSourceLang();
        if (lang != null) {
            tuv.setAttribute("Lang", lang);
        }
        tuv.setName("Tuv");
        return tuv;
    }

    public void removeTargetElements() {
        Raw r = this.getCurrentFile();
        if (r != null) {
            List list = r.getTransUnits();
            for (Object object : list) {
                TTXUnit tu;
                XMLElement target;
                if (!(object instanceof TTXUnit) || (target = (tu = (TTXUnit)object).getTarget()) == null) continue;
                String s = tu.getSourceText();
                String t = tu.getTargetText();
                if (!t.equals(s)) continue;
                target.getChildren().clear();
                this.saved = false;
            }
        }
    }

    public void toggleBookmark() {
        TTXUnit tunit = null;
        TTXWorkflow flow = this.getWorkflow();
        if (flow != null) {
            tunit = flow.getCheckTransUnit();
        }
        if (tunit != null) {
            this.getView().getMenu().toggleBookmark(tunit);
        }
    }

    public void searchFile(String s, String r, int mode) {
        this.view.search(s, r, mode);
    }

    public void viewRange(int from, int to) {
        this.view.viewRange(from, to);
    }

    public void sort() {
        this.view.sort();
    }

    public void sortByLength(boolean longToShort) {
        this.view.sortByLength(longToShort);
    }

    private String getStringContent(List list, String parent) {
        StringBuffer sb = new StringBuffer();
        for (Object object : list) {
            TTXUnit tu;
            XMLElement tar;
            String s;
            List listt;
            if (object instanceof String) {
                String s2 = object.toString();
                s2 = parent.equals("ut") ? XMLHelper.resolveEntitiesXML(s2) : XMLHelper.resolveXMLEntities(s2);
                sb.append(s2);
                continue;
            }
            if (!(object instanceof XMLElement)) continue;
            XMLElement xml = (XMLElement)object;
            String name = xml.getName();
            if (name.equals("df")) {
                listt = xml.getChildren();
                s = this.getStringContent(listt, name);
                sb.append(s);
                continue;
            }
            if (name.equals("ut")) {
                listt = xml.getChildren();
                s = this.getStringContent(listt, name);
                sb.append(s);
                continue;
            }
            if (!name.equals("Tu") || (tar = (tu = (TTXUnit)xml).getTarget()) == null) continue;
            name = tar.getName();
            List listt2 = tar.getChildren();
            String s3 = this.getStringContent(listt2, name);
            sb.append(s3);
        }
        return sb.toString();
    }

    public String getTargetFile() {
        Raw raw = this.getCurrentFile();
        List list = raw.getChildren();
        String name = raw.getName();
        String s = this.getStringContent(list, name);
        return s;
    }

    public void writeXMLFormat(BufferedWriter awriter) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getXMLFormat());
        awriter.write(sb.toString());
        sb.setLength(0);
    }

    public void writeXMLFormat() throws IOException {
        File projectFile = new File(this.path);
        File tempFile = File.createTempFile("old", null, projectFile.getParentFile());
        FileOutputStream fout = new FileOutputStream(tempFile);
        String enc = "UTF-16";
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, enc));
        awriter.write("<?xml version=\"1.0\"?>");
        StringBuffer sb = new StringBuffer();
        sb.append(this.getXMLFormat());
        awriter.write(sb.toString());
        sb.setLength(0);
        awriter.close();
        fout.close();
        if (projectFile.exists()) {
            projectFile.delete();
        }
        if (!tempFile.renameTo(projectFile)) {
            throw new IOException();
        }
        this.saved = true;
    }
}

