/*
 * Decompiled with CFR 0.152.
 */
package translator.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.Vector;

public class CTFocusTraversalPolicy
extends FocusTraversalPolicy {
    Vector<Component> order;

    public CTFocusTraversalPolicy(Vector<Component> order) {
        this.order = new Vector(order.size());
        this.order.addAll(order);
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
        return this.order.get(idx);
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        int idx = this.order.indexOf(aComponent) - 1;
        if (idx < 0) {
            idx = this.order.size() - 1;
        }
        return this.order.get(idx);
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        return this.order.get(0);
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        return this.order.lastElement();
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        return this.order.get(0);
    }
}

