/*
 * Decompiled with CFR 0.152.
 */
package translator.ui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.ActionMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public class CaretAction
extends TextAction {
    private boolean caretForward;

    public CaretAction(boolean caretForward) {
        super(caretForward ? "Caret Forward" : "Caret Backward");
        this.caretForward = caretForward;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent textComponent = this.getFocusedComponent();
        int start = textComponent.getSelectionStart();
        int end = textComponent.getSelectionEnd();
        int offset = textComponent.getCaretPosition();
        offset = start != end ? (this.caretForward ? (offset == end ? offset + 1 : end) : (offset == start ? offset - 1 : start)) : (offset += this.caretForward ? 1 : -1);
        offset = Math.max(offset, 0);
        offset = Math.min(offset, textComponent.getDocument().getLength());
        textComponent.setCaretPosition(offset);
    }

    private static void createAndShowUI() {
        JTextField textField1 = new JTextField(10);
        JTextField textField2 = new JTextField(10);
        JPanel panel = new JPanel();
        panel.add(textField1);
        panel.add(textField2);
        JFrame frame = new JFrame("Caret Action");
        frame.setDefaultCloseOperation(3);
        frame.add(panel);
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
        ActionMap map = (ActionMap)UIManager.get("TextField.actionMap");
        map.put("caret-backward", new CaretAction(false));
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CaretAction.createAndShowUI();
            }
        });
    }
}

