/*
 * Decompiled with CFR 0.152.
 */
package translator.ui;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.Optional;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import translator.ui.GhostGlassPane;
import translator.ui.TabDragGestureListener;
import translator.ui.TabDropTargetListener;

public class DnDTabbedPane
extends JTabbedPane {
    private static final int LINEWIDTH = 48;
    private static final int RWH = 20;
    private static final int BUTTON_SIZE = 30;
    private final GhostGlassPane glassPane = new GhostGlassPane(this);
    protected int dragTabIndex = -1;
    protected boolean hasGhost = true;
    protected boolean isPaintScrollArea = false;
    protected Rectangle rBackward = new Rectangle();
    protected Rectangle rForward = new Rectangle();

    public void autoScrollTest(Point glassPt) {
        Rectangle r = this.getTabAreaBounds();
        int tabPlacement = this.getTabPlacement();
        if (tabPlacement == 1 || tabPlacement == 3) {
            this.rBackward.setBounds(r.x, r.y, 20, r.height);
            this.rForward.setBounds(r.x + r.width - 20 - 30, r.y, 50, r.height);
        } else {
            this.rBackward.setBounds(r.x, r.y, r.width, 20);
            this.rForward.setBounds(r.x, r.y + r.height - 20 - 30, r.width, 50);
        }
        this.rBackward = SwingUtilities.convertRectangle(this.getParent(), this.rBackward, this.glassPane);
        this.rForward = SwingUtilities.convertRectangle(this.getParent(), this.rForward, this.glassPane);
        if (this.rBackward.contains(glassPt)) {
            this.clickArrowButton("scrollTabsBackwardAction");
        } else if (this.rForward.contains(glassPt)) {
            this.clickArrowButton("scrollTabsForwardAction");
        }
    }

    private void clickArrowButton(String actionKey) {
        ActionMap am = this.getActionMap();
        Optional.ofNullable(am.get(actionKey)).filter(a -> a.isEnabled()).ifPresent(a -> a.actionPerformed(new ActionEvent(this, 1001, null, 0L, 0)));
    }

    public DnDTabbedPane() {
        this.glassPane.setName("GlassPane");
        new DropTarget(this.glassPane, 3, new TabDropTargetListener(), true);
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 3, new TabDragGestureListener());
    }

    protected int getTargetTabIndex(Point glassPt) {
        Point tabPt = SwingUtilities.convertPoint(this.glassPane, glassPt, this);
        boolean isTB = this.getTabPlacement() == 1 || this.getTabPlacement() == 3;
        Point d = isTB ? new Point(1, 0) : new Point(0, 1);
        for (int i = 0; i < this.getTabCount(); ++i) {
            Rectangle r = this.getBoundsAt(i);
            r.translate(-r.width * d.x / 2, -r.height * d.y / 2);
            if (!r.contains(tabPt)) continue;
            return i;
        }
        Rectangle r = this.getBoundsAt(this.getTabCount() - 1);
        r.translate(r.width * d.x / 2, r.height * d.y / 2);
        return r.contains(tabPt) ? this.getTabCount() : -1;
    }

    protected void convertTab(int prev, int next) {
        if (next < 0 || prev == next) {
            return;
        }
        Component cmp = this.getComponentAt(prev);
        Component tab = this.getTabComponentAt(prev);
        String str = this.getTitleAt(prev);
        Icon icon = this.getIconAt(prev);
        String tip = this.getToolTipTextAt(prev);
        boolean flg = this.isEnabledAt(prev);
        int tgtindex = prev > next ? next : next - 1;
        this.remove(prev);
        this.insertTab(str, icon, cmp, tip, tgtindex);
        this.setEnabledAt(tgtindex, flg);
        if (flg) {
            this.setSelectedIndex(tgtindex);
        }
        this.setTabComponentAt(tgtindex, tab);
    }

    protected void initTargetLeftRightLine(int next) {
        if (next < 0 || this.dragTabIndex == next || next - this.dragTabIndex == 1) {
            this.glassPane.setTargetRect(0, 0, 0, 0);
        } else if (next == 0) {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(0), this.glassPane);
            this.glassPane.setTargetRect(r.x - 24, r.y, 48, r.height);
        } else {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(next - 1), this.glassPane);
            this.glassPane.setTargetRect(r.x + r.width - 24, r.y, 48, r.height);
        }
    }

    protected void initTargetTopBottomLine(int next) {
        if (next < 0 || this.dragTabIndex == next || next - this.dragTabIndex == 1) {
            this.glassPane.setTargetRect(0, 0, 0, 0);
        } else if (next == 0) {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(0), this.glassPane);
            this.glassPane.setTargetRect(r.x, r.y - 24, r.width, 48);
        } else {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(next - 1), this.glassPane);
            this.glassPane.setTargetRect(r.x, r.y + r.height - 24, r.width, 48);
        }
    }

    protected void initGlassPane(Point tabPt) {
        this.getRootPane().setGlassPane(this.glassPane);
        if (this.hasGhost) {
            Rectangle rect = this.getBoundsAt(this.dragTabIndex);
            BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D g2 = image.createGraphics();
            this.paint(g2);
            g2.dispose();
            rect.x = Math.max(0, rect.x);
            rect.y = Math.max(0, rect.y);
            image = image.getSubimage(rect.x, rect.y, rect.width, rect.height);
            this.glassPane.setImage(image);
        }
        Point glassPt = SwingUtilities.convertPoint(this, tabPt, this.glassPane);
        this.glassPane.setPoint(glassPt);
        this.glassPane.setVisible(true);
    }

    protected Rectangle getTabAreaBounds() {
        Rectangle tabbedRect = this.getBounds();
        Component comp = this.getSelectedComponent();
        int idx = 0;
        while (comp == null && idx < this.getTabCount()) {
            comp = this.getComponentAt(idx++);
        }
        Rectangle compRect = comp == null ? new Rectangle() : comp.getBounds();
        int tabPlacement = this.getTabPlacement();
        if (tabPlacement == 1) {
            tabbedRect.height -= compRect.height;
        } else if (tabPlacement == 3) {
            tabbedRect.y = tabbedRect.y + compRect.y + compRect.height;
            tabbedRect.height -= compRect.height;
        } else if (tabPlacement == 2) {
            tabbedRect.width -= compRect.width;
        } else if (tabPlacement == 4) {
            tabbedRect.x = tabbedRect.x + compRect.x + compRect.width;
            tabbedRect.width -= compRect.width;
        }
        tabbedRect.grow(2, 2);
        return tabbedRect;
    }
}

