/*
 * Decompiled with CFR 0.152.
 */
package translator.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Optional;
import javax.swing.JPanel;
import translator.ui.DnDTabbedPane;

public class GhostGlassPane
extends JPanel {
    private static final AlphaComposite ALPHA = AlphaComposite.getInstance(3, 0.5f);
    public final DnDTabbedPane tabbedPane;
    private final Rectangle lineRect = new Rectangle();
    private final Color lineColor = Color.RED;
    private Point location = new Point();
    private transient Optional<BufferedImage> draggingGhostOp;

    protected GhostGlassPane(DnDTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
        this.setOpaque(false);
    }

    public void setTargetRect(int x, int y, int width, int height) {
        this.lineRect.setBounds(x, y, width, height);
    }

    public void setImage(BufferedImage draggingGhost) {
        this.draggingGhostOp = Optional.ofNullable(draggingGhost);
    }

    public void setPoint(Point location) {
        this.location = location;
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        if (!v) {
            this.setTargetRect(0, 0, 0, 0);
            this.setImage(null);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(ALPHA);
        if (this.tabbedPane.isPaintScrollArea && this.tabbedPane.getTabLayoutPolicy() == 1) {
            g2.setPaint(Color.RED);
            g2.fill(this.tabbedPane.rBackward);
            g2.fill(this.tabbedPane.rForward);
        }
        this.draggingGhostOp.ifPresent(img -> {
            double xx = this.location.getX() - (double)img.getWidth(this) / 2.0;
            double yy = this.location.getY() - (double)img.getHeight(this) / 2.0;
            g2.drawImage((Image)img, (int)xx, (int)yy, null);
        });
        g2.setPaint(this.lineColor);
        g2.fill(this.lineRect);
        g2.dispose();
    }
}

