/*
 * Decompiled with CFR 0.152.
 */
package translator.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.AbstractBorder;

public class ShadowBorder
extends AbstractBorder {
    private int shadowWidth = 10;
    private int inset = 5;
    protected Color lineBorderColor = null;
    protected Color shadowColor = null;
    protected int type = 2;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;

    public ShadowBorder(Color shadowColor, Color lineBorderColor, int shadowWidth, int type) {
        this.shadowWidth = shadowWidth;
        this.shadowColor = shadowColor;
        this.lineBorderColor = lineBorderColor;
        this.type = type;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int hPosition = this.shadowWidth;
        int vPosition = this.shadowWidth;
        if (this.type == 0) {
            hPosition = 0;
            vPosition = 0;
        } else if (this.type == 1) {
            hPosition = this.shadowWidth;
            vPosition = 0;
        } else if (this.type == 2) {
            hPosition = 0;
            vPosition = this.shadowWidth;
        } else if (this.type == 3) {
            hPosition = this.shadowWidth;
            vPosition = this.shadowWidth;
        }
        return new Insets(this.shadowWidth - hPosition + this.inset, this.shadowWidth - vPosition + this.inset, hPosition + this.inset, vPosition + this.inset);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this.shadowWidth + 2;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public Color getShadowColor(Component c) {
        Color shadow = this.getShadowColor();
        if (shadow == null) {
            shadow = c.getBackground().darker().darker();
        }
        return shadow;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int hPosition = this.shadowWidth;
        int vPosition = this.shadowWidth;
        if (this.type == 0) {
            hPosition = 0;
            vPosition = 0;
        } else if (this.type == 1) {
            hPosition = this.shadowWidth;
            vPosition = 0;
        } else if (this.type == 2) {
            hPosition = 0;
            vPosition = this.shadowWidth;
        } else if (this.type == 3) {
            hPosition = this.shadowWidth;
            vPosition = this.shadowWidth;
        }
        Graphics2D gg = (Graphics2D)g;
        Color oldColor = gg.getColor();
        gg.translate(x, y);
        ShadowBorder.paintShadow(c, gg, this.getShadowColor(c), hPosition, vPosition, --width - this.shadowWidth, --height - this.shadowWidth, this.shadowWidth);
        gg.setColor(c.getBackground());
        gg.fillRect(this.shadowWidth - hPosition, this.shadowWidth - vPosition, width - this.shadowWidth, height - this.shadowWidth);
        if (this.lineBorderColor != null) {
            gg.setColor(this.lineBorderColor);
            gg.drawRect(this.shadowWidth - hPosition, this.shadowWidth - vPosition, width - this.shadowWidth, height - this.shadowWidth);
        }
        gg.translate(-x, -y);
        gg.setColor(oldColor);
    }

    public static void paintShadow(Component c, Graphics2D gg, Color shadowColor, int x, int y, int width, int height, int shadowWidth) {
        gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AlphaComposite ac = null;
        gg.setColor(shadowColor);
        int sw = width - 2 * shadowWidth;
        int sh = height - 2 * shadowWidth;
        for (int i = 0; i < shadowWidth; ++i) {
            ac = AlphaComposite.getInstance(3, 1.0f / (float)(i + 1));
            gg.setComposite(ac);
            gg.fillRoundRect(x + shadowWidth - i, y + shadowWidth - i, sw + 2 * i, sh + 2 * i, i * 2, i * 2);
        }
        ac = AlphaComposite.getInstance(3, 1.0f);
        gg.setComposite(ac);
    }
}

