/*
 * Decompiled with CFR 0.152.
 */
package translator.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import translator.ui.ArrowIcon;

public class SplitButton
extends JComponent {
    private JButton mainButton;
    private JButton dropDownButton;
    private JPopupMenu dropDownMenu;

    public SplitButton() {
        this(" ");
    }

    public SplitButton(String text) {
        this(new JButton(text), 5);
    }

    public SplitButton(String text, int orientation) {
        this(new JButton(text), orientation);
    }

    public SplitButton(JButton mainButt, int orientation) {
        this.mainButton = mainButt;
        this.dropDownButton = new JButton(new ArrowIcon(5, this.mainButton.getForeground()));
        this.dropDownButton.setPreferredSize(new Dimension(22, this.mainButton.getPreferredSize().height));
        this.dropDownButton.setMaximumSize(new Dimension(22, this.mainButton.getPreferredSize().height));
        this.dropDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SplitButton.this.dropDownMenu == null) {
                    return;
                }
                if (!SplitButton.this.dropDownMenu.isVisible()) {
                    SplitButton.this.dropDownMenu.show(SplitButton.this.mainButton, SplitButton.this.mainButton.getX(), SplitButton.this.mainButton.getY() + SplitButton.this.mainButton.getHeight() + 2);
                } else {
                    SplitButton.this.dropDownMenu.setVisible(false);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainButton, "Center");
        this.add((Component)this.dropDownButton, "East");
    }

    public void setMenu(JPopupMenu menu) {
        this.dropDownMenu = menu;
    }

    public JButton getMainButton() {
        return this.mainButton;
    }

    public JButton getDropDownButton() {
        return this.dropDownButton;
    }

    public JPopupMenu getMenu() {
        return this.dropDownMenu;
    }

    private static JMenuItem addMI(String text) {
        JMenuItem mi = new JMenuItem(text);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(e.getActionCommand());
            }
        });
        return mi;
    }
}

