/*
 * Decompiled with CFR 0.152.
 */
package translator.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class TransparentBackgroundUI
extends JComponent
implements ComponentListener,
WindowFocusListener,
Runnable {
    private JFrame frame;
    protected Image background;
    private long lastupdate = 0L;
    public boolean refreshRequested = true;

    public TransparentBackgroundUI(JFrame frame) {
        this.frame = frame;
        this.updateBackground();
        frame.addComponentListener(this);
        frame.addWindowFocusListener(this);
        new Thread(this).start();
    }

    public void updateBackground() {
        try {
            Robot rbt = new Robot();
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension dim = tk.getScreenSize();
            this.background = rbt.createScreenCapture(new Rectangle(0, 0, (int)dim.getWidth(), (int)dim.getHeight()));
        }
        catch (Exception ex) {
            TransparentBackgroundUI.p(ex.toString());
            ex.printStackTrace();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Point pos = this.getLocationOnScreen();
        Point offset = new Point(-pos.x, -pos.y);
        g.drawImage(this.background, offset.x, offset.y, null);
    }

    @Override
    public void componentShown(ComponentEvent evt) {
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent evt) {
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent evt) {
        this.repaint();
    }

    @Override
    public void componentHidden(ComponentEvent evt) {
    }

    @Override
    public void windowGainedFocus(WindowEvent evt) {
        this.refresh();
    }

    @Override
    public void windowLostFocus(WindowEvent evt) {
        this.refresh();
    }

    public void refresh() {
        if (this.isVisible() && this.frame.isVisible()) {
            this.repaint();
            this.refreshRequested = true;
            this.lastupdate = new Date().getTime();
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                Thread.sleep(250L);
                long now = new Date().getTime();
                if (!this.refreshRequested || now - this.lastupdate <= 1000L) continue;
                if (this.frame.isVisible()) {
                    Point location = this.frame.getLocation();
                    this.frame.hide();
                    this.updateBackground();
                    this.frame.show();
                    this.frame.setLocation(location);
                    this.refresh();
                }
                this.lastupdate = now;
                this.refreshRequested = false;
            }
        }
        catch (Exception ex) {
            TransparentBackgroundUI.p(ex.toString());
            ex.printStackTrace();
            return;
        }
    }

    public static void p(String str) {
        System.out.println(str);
    }
}

