/*
 * Decompiled with CFR 0.152.
 */
package translator.ui.kodo;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.Timer;

public class KodoButton
extends JButton {
    private boolean active = false;
    private boolean hovered = false;
    private boolean pressed = false;
    private int pulseOffset = 0;
    private Timer pulseTimer;
    private Color baseColor = new Color(30, 30, 30);
    private Color hoverColor = new Color(50, 50, 50);
    private Color pressedColor = new Color(10, 10, 10);
    private Color actionColor = new Color(255, 0, 0, 80);

    public KodoButton() {
        this("");
    }

    public KodoButton(String text) {
        super(text);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this.setForeground(new Color(180, 180, 180));
        this.setFont(new Font("SansSerif", 0, 14));
        this.setCursor(new Cursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                KodoButton.this.hovered = true;
                KodoButton.this.startPulse();
                KodoButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                KodoButton.this.hovered = false;
                KodoButton.this.stopPulse();
                KodoButton.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                KodoButton.this.pressed = true;
                KodoButton.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                KodoButton.this.pressed = false;
                KodoButton.this.repaint();
            }
        });
    }

    @Override
    public void setBackground(Color color) {
        int hb;
        int hg;
        this.baseColor = color;
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int hr = r + 20;
        if (hr > 255) {
            hr = 255;
        }
        if ((hg = g + 20) > 255) {
            hg = 255;
        }
        if ((hb = b + 20) > 255) {
            hb = 255;
        }
        this.hoverColor = new Color(hr, hg, hb);
        hr = r - 20;
        if (hr < 0) {
            hr = 0;
        }
        if ((hg = g - 20) < 0) {
            hg = 0;
        }
        if ((hb = b - 20) < 0) {
            hb = 0;
        }
        this.pressedColor = new Color(hr, hg, hb);
    }

    public void setActive(boolean a) {
        this.active = a;
        if (!this.active) {
            this.stopPulse();
        } else {
            this.startPulse();
        }
    }

    private void startPulse() {
        if (this.pulseTimer == null || !this.pulseTimer.isRunning()) {
            this.pulseTimer = new Timer(30, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KodoButton.this.pulseOffset += 4;
                    if (KodoButton.this.pulseOffset > KodoButton.this.getWidth() * 2) {
                        KodoButton.this.pulseOffset = -KodoButton.this.getWidth();
                    }
                    KodoButton.this.repaint();
                }
            });
            this.pulseTimer.start();
        }
    }

    private void stopPulse() {
        if (this.active) {
            return;
        }
        if (this.pulseTimer != null && this.pulseTimer.isRunning()) {
            this.pulseTimer.stop();
        }
        this.pulseOffset = 0;
    }

    @Override
    protected void paintComponent(Graphics g) {
        GradientPaint pulse;
        Graphics2D g2 = (Graphics2D)g.create();
        int width = this.getWidth();
        int height = this.getHeight();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color bgColor = this.baseColor;
        if (this.pressed) {
            bgColor = this.pressedColor;
        } else if (this.hovered) {
            bgColor = this.hoverColor;
        }
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, bgColor.brighter(), 0.0f, height, bgColor.darker());
        g2.setPaint(gradient);
        g2.fillRoundRect(0, 0, width, height, 20, 20);
        if (this.active) {
            pulse = new GradientPaint(this.pulseOffset, 0.0f, this.actionColor, this.pulseOffset + width / 4, 0.0f, new Color(255, 255, 255, 0), true);
            g2.setPaint(pulse);
            g2.fillRoundRect(0, 0, width, height, 20, 20);
        } else if (this.hovered) {
            pulse = new GradientPaint(this.pulseOffset, 0.0f, new Color(255, 255, 255, 80), this.pulseOffset + width / 4, 0.0f, new Color(255, 255, 255, 0), true);
            g2.setPaint(pulse);
            g2.fillRoundRect(0, 0, width, height, 20, 20);
        }
        FontMetrics fm = g2.getFontMetrics();
        Rectangle textRect = new Rectangle(0, 0, width, height);
        int textHeight = fm.getAscent();
        int textY = (textRect.height - fm.getHeight()) / 2 + fm.getAscent();
        g2.setColor(this.getForeground());
        g2.setFont(this.getFont());
        g2.drawString(this.getText(), (width - fm.stringWidth(this.getText())) / 2, textY);
        g2.dispose();
    }
}

