/*
 * Decompiled with CFR 0.152.
 */
package translator.ui.kodo;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class KodoTabbedPaneUI
extends BasicTabbedPaneUI {
    private Color tabBackground = new Color(55, 55, 55);
    private Color tabForeground = new Color(200, 200, 200);
    private Color selectedTabAccent = new Color(160, 0, 0);
    private boolean increasing = true;
    private float breathingAlpha = 0.3f;
    private Timer breathingTimer;

    public void setTabBackground(Color color) {
        this.tabBackground = color;
    }

    public Color getTabBackground() {
        return this.tabBackground;
    }

    public void setTabForeground(Color color) {
        this.tabForeground = color;
    }

    public Color getTabForeground() {
        return this.tabForeground;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.tabAreaInsets = new Insets(10, 10, 0, 10);
        this.contentBorderInsets = new Insets(1, 0, 0, 0);
        this.tabInsets = new Insets(8, 20, 8, 20);
    }

    private void startBreathingAnimation() {
        this.breathingTimer = new Timer(60, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (KodoTabbedPaneUI.this.increasing) {
                    KodoTabbedPaneUI.this.breathingAlpha += 0.01f;
                    if (KodoTabbedPaneUI.this.breathingAlpha >= 0.6f) {
                        KodoTabbedPaneUI.this.increasing = false;
                    }
                } else {
                    KodoTabbedPaneUI.this.breathingAlpha -= 0.01f;
                    if (KodoTabbedPaneUI.this.breathingAlpha <= 0.3f) {
                        KodoTabbedPaneUI.this.increasing = true;
                    }
                }
                KodoTabbedPaneUI.this.tabPane.repaint();
            }
        });
        this.breathingTimer.start();
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RoundRectangle2D.Float tabShape = new RoundRectangle2D.Float(x, y + 2, w, h - 2, 14.0f, 14.0f);
        if (isSelected) {
            g2.setColor(this.tabBackground.brighter());
            g2.fill(tabShape);
        } else {
            g2.setColor(this.tabBackground);
            g2.fill(tabShape);
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        g.setColor(isSelected ? this.tabForeground.brighter() : this.tabForeground);
        g.drawString(title, textRect.x, textRect.y + metrics.getAscent());
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }
}

