/*
 * Decompiled with CFR 0.152.
 */
package translator.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.advanced.AdvancedPlayer;
import javazoom.jl.player.advanced.PlaybackEvent;
import javazoom.jl.player.advanced.PlaybackListener;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.polly.PollyClient;
import software.amazon.awssdk.services.polly.PollyClientBuilder;
import software.amazon.awssdk.services.polly.model.DescribeVoicesRequest;
import software.amazon.awssdk.services.polly.model.DescribeVoicesResponse;
import software.amazon.awssdk.services.polly.model.OutputFormat;
import software.amazon.awssdk.services.polly.model.PollyException;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest;
import software.amazon.awssdk.services.polly.model.Voice;
import translator.AppPreferences;

class AmazonTTSAPI {
    private PollyClient pollyClient;
    private AdvancedPlayer player;

    AmazonTTSAPI() {
    }

    private void validate(String text) throws Exception {
    }

    public void talk(String text, int voiceID) throws Exception {
        if (AppPreferences.amazonAPIAccessKey.length() == 0) {
            throw new RuntimeException("Please set the Amazon API access key");
        }
        if (AppPreferences.amazonAPISecretKey.length() == 0) {
            throw new RuntimeException("Please set the Amazon API secret key");
        }
        if (AppPreferences.amazonAPIRegion.length() == 0) {
            AppPreferences.amazonAPIRegion = "eu-central-1";
        }
        if (this.player != null) {
            this.player.close();
        }
        if (this.pollyClient == null) {
            AwsBasicCredentials awsBasicCreds = AwsBasicCredentials.create((String)AppPreferences.amazonAPIAccessKey, (String)AppPreferences.amazonAPISecretKey);
            StaticCredentialsProvider staticCreds = StaticCredentialsProvider.create((AwsCredentials)awsBasicCreds);
            Region region = Region.of((String)AppPreferences.amazonAPIRegion);
            this.pollyClient = (PollyClient)((PollyClientBuilder)((PollyClientBuilder)PollyClient.builder().credentialsProvider((AwsCredentialsProvider)staticCreds)).region(region)).build();
        }
        String engine = AppPreferences.amazonPollyEngine == 1 ? "neural" : "standard";
        try {
            DescribeVoicesRequest describeVoiceRequest = (DescribeVoicesRequest)DescribeVoicesRequest.builder().engine(engine).build();
            DescribeVoicesResponse describeVoicesResult = this.pollyClient.describeVoices(describeVoiceRequest);
            Voice voice = (Voice)describeVoicesResult.voices().get(voiceID);
            InputStream stream = this.synthesize(text, voice, engine, OutputFormat.MP3);
            this.player = new AdvancedPlayer(stream, FactoryRegistry.systemRegistry().createAudioDevice());
            this.player.setPlayBackListener(new PlaybackListener(){

                public void playbackStarted(PlaybackEvent evt) {
                }

                public void playbackFinished(PlaybackEvent evt) {
                }
            });
            this.player.play();
        }
        catch (IOException | JavaLayerException | PollyException e) {
            System.err.println(e.getMessage());
            if (this.pollyClient != null) {
                this.pollyClient.close();
                this.pollyClient = null;
            }
            throw new Exception(e.getMessage());
        }
    }

    public InputStream synthesize(String text, Voice voice, String engine, OutputFormat format) throws IOException {
        SynthesizeSpeechRequest synthReq = (SynthesizeSpeechRequest)SynthesizeSpeechRequest.builder().text(text).voiceId(voice.id()).outputFormat(format).engine(engine).build();
        ResponseInputStream synthRes = this.pollyClient.synthesizeSpeech(synthReq);
        return synthRes;
    }

    public String[] getVoices() throws Exception {
        if (AppPreferences.amazonAPIAccessKey.length() == 0) {
            throw new RuntimeException("Please set the Amazon API access key");
        }
        if (AppPreferences.amazonAPISecretKey.length() == 0) {
            throw new RuntimeException("Please set the Amazon API secret key");
        }
        if (AppPreferences.amazonAPIRegion.length() == 0) {
            AppPreferences.amazonAPIRegion = "eu-central-1";
        }
        if (this.pollyClient == null) {
            AwsBasicCredentials awsBasicCreds = AwsBasicCredentials.create((String)AppPreferences.amazonAPIAccessKey, (String)AppPreferences.amazonAPISecretKey);
            StaticCredentialsProvider staticCreds = StaticCredentialsProvider.create((AwsCredentials)awsBasicCreds);
            Region region = Region.of((String)AppPreferences.amazonAPIRegion);
            this.pollyClient = (PollyClient)((PollyClientBuilder)((PollyClientBuilder)PollyClient.builder().credentialsProvider((AwsCredentialsProvider)staticCreds)).region(region)).build();
        }
        String[] vs = null;
        String engine = AppPreferences.amazonPollyEngine == 1 ? "neural" : "standard";
        try {
            DescribeVoicesRequest describeVoiceRequest = (DescribeVoicesRequest)DescribeVoicesRequest.builder().engine(engine).build();
            DescribeVoicesResponse enUsVoicesResult = this.pollyClient.describeVoices(describeVoiceRequest);
            List voices = enUsVoicesResult.voices();
            Iterator iterator = voices.iterator();
            vs = new String[voices.size()];
            int i = 0;
            while (iterator.hasNext()) {
                Voice voice = (Voice)iterator.next();
                String lang = voice.languageName();
                String name = voice.name();
                String gender = voice.genderAsString();
                vs[i] = lang + ": " + name + ", " + gender;
                ++i;
            }
        }
        catch (PollyException e) {
            System.err.println(e.getMessage());
            this.pollyClient.close();
            throw new Exception("Problem with the connection to Amazon Polly web service");
        }
        return vs;
    }

    public void close() {
        if (this.pollyClient != null) {
            this.pollyClient.close();
            this.pollyClient = null;
        }
    }
}

