/*
 * Decompiled with CFR 0.152.
 */
package translator.web;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.JTableHeader;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import translator.AppPreferences;
import translator.MainClass;
import translator.web.CafeTranDocument;
import translator.web.FileUploadHTTP;
import translator.web.TMTown;

public class CafeTranDocumentsView
extends JPanel {
    private JScrollPane masterScrollPane;
    private JTable masterTable;
    private BindingGroup bindingGroup;
    private static List<CafeTranDocument> documents;
    private TMTown tmTown;
    private JButton uploadButton;

    public CafeTranDocumentsView(TMTown tmTown) {
        ArrayList list = new ArrayList();
        documents = ObservableCollections.observableList(list);
        this.tmTown = tmTown;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 0));
        this.masterScrollPane = new JScrollPane();
        this.masterScrollPane.setOpaque(false);
        this.masterScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.masterScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        this.masterScrollPane.getViewport().setOpaque(false);
        this.masterTable = new JTable();
        this.masterTable.setRowHeight(34);
        Font font = this.masterTable.getFont();
        int size = font.getSize();
        if (size < 14) {
            font = font.deriveFont(14.0f);
        }
        JTextField textField = new JTextField();
        textField.setFont(font);
        textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        DefaultCellEditor dce = new DefaultCellEditor(textField);
        this.masterTable.setDefaultEditor(String.class, dce);
        this.masterTable.setFont(font);
        JTableHeader header = this.masterTable.getTableHeader();
        header.setFont(font.deriveFont(1));
        header.setForeground(new Color(2, 119, 189));
        this.bindingGroup = new BindingGroup();
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, documents, (JTable)this.masterTable);
        String s = "name";
        String column = "Name";
        JTableBinding.ColumnBinding columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
        columnBinding.setColumnName(column);
        columnBinding.setColumnClass(String.class);
        s = "fieldsOfExpertise";
        column = "Fields of Expertise";
        columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
        columnBinding.setColumnName(column);
        columnBinding.setColumnClass(String.class);
        s = "type";
        column = "Type";
        columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
        columnBinding.setColumnName(column);
        columnBinding.setColumnClass(String.class);
        this.bindingGroup.addBinding((Binding)jTableBinding);
        jTableBinding.bind();
        JLabel label = new JLabel("Upload to TM-Town:");
        label.setOpaque(true);
        label.setForeground(new Color(255, 255, 255));
        label.setBackground(new Color(50, 50, 50));
        this.uploadButton = new JButton("No resources");
        font = this.uploadButton.getFont();
        font = font.deriveFont(1);
        this.uploadButton.setFont(font);
        this.uploadButton.setPreferredSize(new Dimension(300, this.uploadButton.getPreferredSize().height));
        this.uploadButton.setMaximumSize(new Dimension(300, this.uploadButton.getPreferredSize().height));
        this.uploadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name;
                String s = e.getActionCommand();
                CafeTranDocument next = null;
                Iterator iterator = documents.iterator();
                while (iterator.hasNext() && !s.equals(name = (next = (CafeTranDocument)iterator.next()).getName())) {
                }
                if (next != null) {
                    if (next.uploaded) {
                        JOptionPane.showMessageDialog(MainClass.getMainView(), "The document has already been uploaded to TM-Town.");
                        return;
                    }
                    String filepath = next.getPath();
                    if (filepath != null) {
                        String url = ((CafeTranDocumentsView)CafeTranDocumentsView.this).tmTown.documentsURL;
                        String fields = next.getFieldsOfExpertise();
                        if (fields == null || fields.length() == 0) {
                            JOptionPane.showMessageDialog(MainClass.getMainView(), "Enter up to 3 fields of expertise separated by comma.");
                            return;
                        }
                        String type = next.getType();
                        if (type.equals("Translation Memory")) {
                            type = "tm_file";
                        } else if (type.equals("Glossary")) {
                            type = "terminology_file";
                        }
                        String name2 = next.getName();
                        FileUploadHTTP fileUpload = new FileUploadHTTP(url, name2, filepath, type, fields, AppPreferences.tmTownToken);
                        fileUpload.setMainView(MainClass.getMainView());
                        fileUpload.upload();
                        next.uploaded = true;
                    }
                }
            }
        });
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.masterTable, (Property)ELProperty.create((String)"${selectedElement.name}"), (Object)this.uploadButton, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        binding.bind();
        this.masterScrollPane.setViewportView(this.masterTable);
        this.add((Component)this.masterScrollPane, "Center");
        JPanel panel = new JPanel();
        panel.setBackground(new Color(50, 50, 50));
        panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.black));
        panel.add(label);
        panel.add(this.uploadButton);
        this.add((Component)panel, "South");
    }

    public void addDocument(CafeTranDocument doc) {
        documents.add(doc);
    }

    public static List getDocuments() {
        return documents;
    }

    public JTable getTable() {
        return this.masterTable;
    }
}

