/*
 * Decompiled with CFR 0.152.
 */
package translator.web;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import translator.MainView;
import translator.web.FileUploadTask;

public class FileUploadHTTP
implements PropertyChangeListener {
    private String documentsURL;
    private String filePath;
    private String name;
    private String tagList;
    private String fileType;
    private String token;
    private MainView topui;
    private JProgressBar progressBar;

    public FileUploadHTTP(String url, String name, String path, String fileType, String tagList, String token) {
        this.documentsURL = url;
        this.filePath = path;
        this.name = name;
        this.fileType = fileType;
        this.tagList = tagList;
        this.filePath = this.filePath;
        this.token = token;
    }

    public void setMainView(MainView mv) {
        this.topui = mv;
    }

    public void upload() {
        if (this.documentsURL.equals("")) {
            JOptionPane.showMessageDialog(this.topui, "Please enter upload URL!", "Error", 0);
            return;
        }
        if (this.filePath.equals("")) {
            JOptionPane.showMessageDialog(this.topui, "Please choose a file to upload!", "Error", 0);
            return;
        }
        try {
            File uploadFile = new File(this.filePath);
            this.progressBar = this.topui.getPretranslateProgressBar();
            this.progressBar.setStringPainted(true);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(100);
            this.progressBar.setValue(0);
            FileUploadTask task = new FileUploadTask(this.documentsURL, this.name, uploadFile, this.fileType, this.tagList, this.token, false);
            task.addPropertyChangeListener(this);
            task.execute();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.topui, "Error executing upload task: " + ex.getMessage(), "Error", 0);
            this.topui.removePretranslateProgressBar(this.progressBar);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressBar.setValue(progress);
            if (progress >= 100) {
                this.topui.removePretranslateProgressBar(this.progressBar);
            }
        }
    }
}

