/*
 * Decompiled with CFR 0.152.
 */
package translator.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import translator.web.FileUploadUtility;

public class FileUploadTask
extends SwingWorker<Void, Integer> {
    private String uploadURL;
    private String name;
    private File uploadFile;
    private String fileType;
    private String tagList;
    private String token;
    private boolean authorizationProperty;
    private String response;

    public FileUploadTask(String uploadURL, String name, File uploadFile, String fileType, String tagList, String token, boolean authorizationProperty) {
        this.uploadURL = uploadURL;
        this.name = name;
        this.uploadFile = uploadFile;
        this.fileType = fileType;
        this.tagList = tagList;
        this.token = token;
        this.authorizationProperty = authorizationProperty;
    }

    public String getResponse() {
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        try {
            FileUploadUtility util;
            if (this.authorizationProperty) {
                util = new FileUploadUtility(this.uploadURL, this.token);
                util.addFilePart(null, this.name, this.fileType, this.tagList);
            } else {
                util = new FileUploadUtility(this.uploadURL, null);
                util.addFilePart(this.token, this.name, this.fileType, this.tagList);
            }
            if (this.fileType.equals("media")) {
                FileInputStream inputStream = new FileInputStream(this.uploadFile);
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                long totalBytesRead = 0L;
                int percentCompleted = 0;
                long fileSize = this.uploadFile.length();
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    util.writeFileBytes(buffer, 0, bytesRead);
                    percentCompleted = (int)((totalBytesRead += (long)bytesRead) * 100L / fileSize);
                    if (percentCompleted >= 100) continue;
                    this.setProgress(percentCompleted);
                }
                inputStream.close();
            } else {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.uploadFile), "UTF-8"));
                    long totalBytesRead = 0L;
                    int percentCompleted = 0;
                    long fileSize = this.uploadFile.length();
                    while ((line = reader.readLine()) != null) {
                        util.writeLine(line);
                        int bytesRead = line.getBytes().length;
                        percentCompleted = (int)((totalBytesRead += (long)bytesRead) * 100L / fileSize);
                        this.setProgress(percentCompleted);
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            this.response = util.finish();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Error uploading file: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
            this.setProgress(0);
            this.cancel(true);
        }
        return null;
    }

    @Override
    protected void done() {
        this.setProgress(100);
    }
}

