/*
 * Decompiled with CFR 0.152.
 */
package translator.web;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.X509TrustManager;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import javax.swing.text.html.HTMLDocument;
import translator.AppPreferences;
import translator.DefaultResource;
import translator.FragmentMatch;
import translator.LanguageCodes;
import translator.MainView;
import translator.ResourceView;
import translator.ScrollPaneWatermark;
import translator.StatisticsView;
import translator.TabView;
import translator.TargetView;
import translator.TranslateEvent;
import translator.XMLElementEditor;
import translator.XMLHelper;
import translator.html.CTHTMLEditorKit;
import translator.json.JSONArray;
import translator.json.JSONException;
import translator.json.JSONObject;
import translator.ui.Colors;
import translator.ui.GridPanel;
import translator.ui.HTMLFormat;
import translator.ui.UITools;
import translator.web.FileUploadTask;
import translator.web.ProzAnswerQuestionView;
import translator.web.ProzAskQuestion;
import translator.web.ProzAskQuestionView;
import translator.web.ProzQuestionsPreferences;
import translator.web.ProzWIWOMessage;
import translator.web.ProzWIWOPost;
import translator.web.ProzWIWOSView;

public class Proz
extends DefaultResource {
    private MainView topui;
    private TabView tview;
    private JPopupMenu pop;
    private GridPanel mainPanel;
    public static boolean ProzLinking = false;
    private String clientID = "65c7620700e3b038ab7107873102443001f59b88";
    private String clientSecret = "562ae2ae7676301fd29498c71eef5a59d7372d86";
    public static String redirectURL = "https://www.cafetran.com/oauth2";
    public static String authorizationRequest = "https://www.proz.com/oauth/authorize?redirect_uri=https%3A%2F%2Fwww.cafetran.com%2Foauth2&client_id=65c7620700e3b038ab7107873102443001f59b88&response_type=code&scope=kudoz.read+kudoz.write+media.post+wiwo";
    private String tokenURL = "https://www.proz.com/oauth/token";
    public static String accountURL = "http://www.proz.com";
    public static boolean benefitCTE = false;
    private String info = "";
    private String cafetranMaxLimitsFor;
    private String cafetranURL = "https://api.proz.com/v2/cafetran?";
    private String userURL = "https://api.proz.com/v2/user?";
    private String languageURL = "https://api.proz.com/v2/codes/language?";
    private String termSearchURL = "https://api.proz.com/v2/term-search";
    private String questionsURL = "https://api.proz.com/v2/kudoz";
    private String wiwoURL = "https://api.proz.com/v2/wiwo";
    private String mediaURL = "https://api.proz.com/v2/media";
    private String generalDisciplinesURL = "https://api.proz.com/v2/codes/disc-gen?";
    private String specificDisciplinesURL = "https://api.proz.com/v2/codes/disc-spec?";
    private JTextPane mtHTMLPane;
    private boolean running;
    private String resourceName;
    private boolean canLook = true;
    private String searchTerms = "search_terms";
    private String userDetails = "user_details";
    private String askQuestion = "ask_question";
    private String answerQuestion = "answer_question=";
    private String questions = "questions";
    private String wiwo = "wiwo";
    private String sourceLanguage = "";
    private String targetLanguage = "";
    private LinkedHashMap languageCodeMap = new LinkedHashMap();
    private LinkedHashMap codeLanguageMap = new LinkedHashMap();
    private LinkedHashMap generalDisciplinesMap = new LinkedHashMap();
    private LinkedHashMap specificDisciplinesMap = new LinkedHashMap();
    private String kudoz = "KudoZ";
    private String kog = "KudoZ open glossary";
    private String gloss = "Personal glossaries";
    private String glossPost = "GlossPost";
    private String gbk = "Glossary-building KudoZ";
    private String wikiwords = "Wikiwords";
    private String[] arrayResources;
    private String currentTerm;
    private String uuid = "";
    private int questionsPage = 1;
    private Date lastQuestionsCheck;
    private java.util.Timer timerRefreshQuestions;
    private String confidenceColor1 = "#455A64";
    private String confidenceColor2 = "#5D4037";
    private String confidenceColor3 = "#1B5E20";
    private String confidenceColor4 = "#01579B";
    private String confidenceColor5 = "#7B1FA2";
    private static boolean runWiwoTimer = true;
    private ArrayList wiwoArray;
    private ProzWIWOSView wiwosView;
    private String wiwoNextURL;
    private String wiwoPreviousURL;
    private boolean wiwoPosted = false;
    private String checkWiwosTime;
    private int refreshTokenTrials = 0;
    int newTranslations = 0;
    StringBuilder userHTML = null;
    boolean answerNotification = false;

    public Proz() {
        this.setLanguageCodesPair(AppPreferences.fileSLang, AppPreferences.fileTLang);
        this.arrayResources = new String[6];
        if (AppPreferences.prozResources != null && AppPreferences.prozResources.length() > 0) {
            String[] arr = AppPreferences.prozResources.split(",");
            for (int i = 0; i < arr.length; ++i) {
                String res = arr[i];
                if (res == null) continue;
                if (res.equals("kudoz")) {
                    this.arrayResources[0] = res;
                    continue;
                }
                if (res.equals("kog")) {
                    this.arrayResources[1] = res;
                    continue;
                }
                if (res.equals("gloss")) {
                    this.arrayResources[2] = res;
                    continue;
                }
                if (res.equals("glosspost")) {
                    this.arrayResources[3] = res;
                    continue;
                }
                if (res.equals("gbk")) {
                    this.arrayResources[4] = res;
                    continue;
                }
                if (!res.equals("wikiwords")) continue;
                this.arrayResources[5] = res;
            }
        }
        this.resourceName = "ProZ.com";
    }

    Map getLanguageCodesMap() {
        return this.languageCodeMap;
    }

    Map getSpecificDisciplinesMap() {
        return this.specificDisciplinesMap;
    }

    Map getGeneralDisciplinesMap() {
        return this.generalDisciplinesMap;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public JTextComponent getResourcePane() {
        return this.mtHTMLPane;
    }

    public void showLoginFrame() {
        if (AppPreferences.prozToken == null) {
            ProzLinking = true;
            this.topui.getResourceLoader().prepareWebResource(authorizationRequest, "ProZ.com - Authorization", false, true, -1);
        }
    }

    public void connectToService() {
        if (AppPreferences.prozToken != null && AppPreferences.prozAuthorizationScope) {
            this.getUser(false);
        } else {
            this.showLinkInMessage();
        }
    }

    public boolean isConnected() {
        return AppPreferences.prozToken != null && AppPreferences.prozAuthorizationScope;
    }

    public void exchangeAuthorizationForToken(String urlString) {
        int i = urlString.indexOf(61);
        if (i != -1) {
            String code = urlString.substring(i + 1);
            String cSecret = "client_secret=" + this.clientSecret;
            String cID = "client_id=" + this.clientID;
            String grantType = "grant_type=authorization_code";
            String redirURI = "redirect_uri=https%3A%2F%2Fwww.cafetran.com%2Foauth2";
            String authcode = "code=" + code;
            String request = cSecret + "&" + grantType + "&" + redirURI + "&" + authcode + "&" + cID;
            try {
                String eline;
                URL url = new URL(this.tokenURL);
                URLConnection conn = url.openConnection();
                conn.setDoOutput(true);
                OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
                out.write(request);
                out.close();
                InputStream ins = conn.getInputStream();
                BufferedReader in = new BufferedReader(new InputStreamReader(ins, "UTF-8"));
                StringBuilder sb = new StringBuilder();
                while ((eline = in.readLine()) != null) {
                    sb.append(eline);
                }
                JSONObject jobject = new JSONObject(sb.toString());
                AppPreferences.prozToken = jobject.getString("access_token");
                AppPreferences.prozRefreshToken = jobject.getString("refresh_token");
                AppPreferences.prozAuthorizationScope = true;
                this.refreshTokenTrials = 0;
            }
            catch (IOException ex) {
                Logger.getLogger(Proz.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (JSONException ex) {
                Logger.getLogger(Proz.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (AppPreferences.prozToken != null) {
                if (this.topui.getDashboardView() != null) {
                    this.getUser(true);
                } else {
                    this.getUser(false);
                }
            }
        }
    }

    private void refreshToken() {
        ++this.refreshTokenTrials;
        AppPreferences.prozToken = null;
        String cSecret = "client_secret=" + this.clientSecret;
        String cID = "client_id=" + this.clientID;
        String grantType = "grant_type=refresh_token";
        String refreshTok = "refresh_token=" + AppPreferences.prozRefreshToken;
        String request = cSecret + "&" + grantType + "&" + refreshTok + "&" + cID;
        AppPreferences.prozRefreshToken = null;
        try {
            String eline;
            URL url = new URL(this.tokenURL);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            out.write(request);
            out.close();
            InputStream ins = conn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(ins, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null) {
                sb.append(eline);
            }
            JSONObject jobject = new JSONObject(sb.toString());
            AppPreferences.prozToken = jobject.getString("access_token");
            AppPreferences.prozRefreshToken = jobject.getString("refresh_token");
            AppPreferences.prozAuthorizationScope = true;
        }
        catch (IOException ex) {
            Logger.getLogger(Proz.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (JSONException ex) {
            Logger.getLogger(Proz.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (AppPreferences.prozToken != null && AppPreferences.prozRefreshToken != null) {
            this.getUser(false);
        } else {
            this.showLinkInMessage();
        }
    }

    @Override
    public void setMainView(MainView topui) {
        this.topui = topui;
        this.tview = topui.getTabView();
        this.setPopup();
        this.createView();
    }

    private void setPopup() {
        this.pop = new JPopupMenu();
        boolean kudozB = false;
        boolean kogB = false;
        boolean glossB = false;
        boolean glosspostB = false;
        boolean gbkB = false;
        boolean wikiwordsB = false;
        if (this.arrayResources != null) {
            for (int i = 0; i < this.arrayResources.length; ++i) {
                String res = this.arrayResources[i];
                if (res == null) continue;
                if (res.equals("kudoz")) {
                    kudozB = true;
                    continue;
                }
                if (res.equals("kog")) {
                    kogB = true;
                    continue;
                }
                if (res.equals("gloss")) {
                    glossB = true;
                    continue;
                }
                if (res.equals("glosspost")) {
                    glosspostB = true;
                    continue;
                }
                if (res.equals("gbk")) {
                    gbkB = true;
                    continue;
                }
                if (!res.equals("wikiwords")) continue;
                wikiwordsB = true;
            }
        }
        JCheckBoxMenuItem checkItemS = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SOURCE LANGUAGE SPECIFIED"));
        checkItemS.setSelected(AppPreferences.prozSourceLangSpecified);
        checkItemS.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.prozSourceLangSpecified = e.getStateChange() == 1;
            }
        });
        JCheckBoxMenuItem checkItemT = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET LANGUAGE SPECIFIED"));
        checkItemT.setSelected(AppPreferences.prozTargetLangSpecified);
        checkItemT.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.prozTargetLangSpecified = e.getStateChange() == 1;
            }
        });
        JCheckBoxMenuItem exactFragmentMatchItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MATCH EXACT FRAGMENTS AUTOMATICALLY"));
        exactFragmentMatchItem.setSelected(AppPreferences.prozExactFragmentsMatching);
        exactFragmentMatchItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.prozExactFragmentsMatching = e.getStateChange() == 1;
            }
        });
        JCheckBoxMenuItem exactMatchItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MATCH ENTIRE PHRASE"));
        exactMatchItem.setSelected(AppPreferences.prozExactMatching);
        exactMatchItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.prozExactMatching = e.getStateChange() == 1;
            }
        });
        JCheckBoxMenuItem termInfoItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW TERM INFORMATION"));
        termInfoItem.setSelected(AppPreferences.prozTermInfoDisplay);
        termInfoItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.prozTermInfoDisplay = e.getStateChange() == 1;
            }
        });
        JCheckBoxMenuItem kudoZItem = new JCheckBoxMenuItem(this.kudoz);
        kudoZItem.setSelected(kudozB);
        kudoZItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((Proz)Proz.this).arrayResources[0] = e.getStateChange() == 1 ? "kudoz" : null;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < Proz.this.arrayResources.length; ++i) {
                    String arrayResource = Proz.this.arrayResources[i];
                    if (arrayResource == null) continue;
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(arrayResource);
                }
                AppPreferences.prozResources = sb.toString();
            }
        });
        JCheckBoxMenuItem kogItem = new JCheckBoxMenuItem(this.kog);
        kogItem.setSelected(kogB);
        kogItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((Proz)Proz.this).arrayResources[1] = e.getStateChange() == 1 ? "kog" : null;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < Proz.this.arrayResources.length; ++i) {
                    String arrayResource = Proz.this.arrayResources[i];
                    if (arrayResource == null) continue;
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(arrayResource);
                }
                AppPreferences.prozResources = sb.toString();
            }
        });
        JCheckBoxMenuItem glossItem = new JCheckBoxMenuItem(this.gloss);
        glossItem.setSelected(glossB);
        glossItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((Proz)Proz.this).arrayResources[2] = e.getStateChange() == 1 ? "gloss" : null;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < Proz.this.arrayResources.length; ++i) {
                    String arrayResource = Proz.this.arrayResources[i];
                    if (arrayResource == null) continue;
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(arrayResource);
                }
                AppPreferences.prozResources = sb.toString();
            }
        });
        JCheckBoxMenuItem glossPostItem = new JCheckBoxMenuItem(this.glossPost);
        glossPostItem.setSelected(glosspostB);
        glossPostItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((Proz)Proz.this).arrayResources[3] = e.getStateChange() == 1 ? "glosspost" : null;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < Proz.this.arrayResources.length; ++i) {
                    String arrayResource = Proz.this.arrayResources[i];
                    if (arrayResource == null) continue;
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(arrayResource);
                }
                AppPreferences.prozResources = sb.toString();
            }
        });
        JCheckBoxMenuItem gbkItem = new JCheckBoxMenuItem(this.gbk);
        gbkItem.setSelected(gbkB);
        gbkItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((Proz)Proz.this).arrayResources[4] = e.getStateChange() == 1 ? "gbk" : null;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < Proz.this.arrayResources.length; ++i) {
                    String arrayResource = Proz.this.arrayResources[i];
                    if (arrayResource == null) continue;
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(arrayResource);
                }
                AppPreferences.prozResources = sb.toString();
            }
        });
        JCheckBoxMenuItem wikiwordsItem = new JCheckBoxMenuItem(this.wikiwords);
        wikiwordsItem.setSelected(wikiwordsB);
        wikiwordsItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((Proz)Proz.this).arrayResources[5] = e.getStateChange() == 1 ? "wikiwords" : null;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < Proz.this.arrayResources.length; ++i) {
                    String arrayResource = Proz.this.arrayResources[i];
                    if (arrayResource == null) continue;
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(arrayResource);
                }
                AppPreferences.prozResources = sb.toString();
            }
        });
        JMenuItem kudoZPrefsItem = new JMenuItem("KudoZ questions preferences");
        kudoZPrefsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Proz.this.showQuestionPrefsForm();
            }
        });
        JMenuItem showUserItem = new JMenuItem("Show ProZ.com user");
        showUserItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppPreferences.prozToken != null) {
                    Proz.this.getUser(false);
                }
            }
        });
        this.pop.add(checkItemS);
        this.pop.add(checkItemT);
        this.pop.addSeparator();
        this.pop.add(kudoZItem);
        this.pop.add(kogItem);
        this.pop.add(glossItem);
        this.pop.add(glossPostItem);
        this.pop.add(gbkItem);
        this.pop.add(wikiwordsItem);
        this.pop.addSeparator();
        this.pop.add(exactFragmentMatchItem);
        this.pop.add(exactMatchItem);
        this.pop.addSeparator();
        this.pop.add(kudoZPrefsItem);
        this.pop.add(showUserItem);
        this.pop.add(termInfoItem);
    }

    private void showPopUp(Component comp, int x, int y) {
        this.pop.show(comp, x, y);
    }

    public void setLanguageCodesPair(String sourceLangCode, String targetLangCode) {
        if (sourceLangCode != null && targetLangCode != null) {
            int i;
            String source = LanguageCodes.getName(sourceLangCode);
            String target = LanguageCodes.getName(targetLangCode);
            if (source == null) {
                source = sourceLangCode;
            }
            if (target == null) {
                target = targetLangCode;
            }
            if ((i = source.lastIndexOf(40)) != -1) {
                source = source.substring(0, i - 1);
            }
            if ((i = target.lastIndexOf(40)) != -1) {
                target = target.substring(0, i - 1);
            }
            if ((i = source.lastIndexOf(" - ")) != -1) {
                source = source.substring(0, i);
            }
            if ((i = target.lastIndexOf(" - ")) != -1) {
                target = target.substring(0, i);
            }
            int sdash = sourceLangCode.indexOf("-");
            int tdash = targetLangCode.indexOf("-");
            if (sdash != -1) {
                sourceLangCode = sourceLangCode.substring(0, sdash);
            }
            if (tdash != -1) {
                targetLangCode = targetLangCode.substring(0, tdash);
            }
            this.sourceLanguage = source;
            this.targetLanguage = target;
        }
    }

    private void addHTMLNoResultsFoundMessage(StringBuilder html) {
        html.append("<table align=center BORDER=0 BORDERCOLOR=#000000 CELLSPACING=0 CELLPADDING=5><tr>");
        if (AppPreferences.prozSourceLangSpecified) {
            html.append("<th style=\"color:#FFFFFF; font-size:").append(AppPreferences.UIFontSizeHTML).append("; background-color:#0074CC\">");
        } else {
            html.append("<th style=\"color:#FFFFFF; font-size:").append(AppPreferences.UIFontSizeHTML).append("; background-color:#0074CC\">");
        }
        html.append(this.sourceLanguage);
        html.append("</th>");
        if (AppPreferences.prozTargetLangSpecified) {
            html.append("<th style=\"color:#FFFFFF; font-size:").append(AppPreferences.UIFontSizeHTML).append("; background-color:#0074CC\">");
        } else {
            html.append("<th style=\"color:#FFFFFF; font-size:").append(AppPreferences.UIFontSizeHTML).append("; background-color:#0074CC\">");
        }
        html.append(this.targetLanguage);
        html.append("</th>");
        html.append("</tr>");
        html.append("<tr>");
        html.append("<td nowrap colspan=\"2\">");
        html.append("<p \"style=\"font-size:").append(AppPreferences.UIFontSizeHTML).append("\">No results have been found.</p>");
        html.append("</td>");
        html.append("</tr>");
        html.append("</table>");
    }

    private String getHTMLTooBar() {
        String webButtonStyle = "\"style=color:#FFFFFF;font-size:" + Integer.toString(AppPreferences.fontsize) + "\"";
        String button = "<td style=\"color:#FFFFFF; background-color:" + Colors.colorProZ + ";border-style:solid;border-width: 0px;\" align=center>";
        StringBuilder sb = new StringBuilder();
        sb.append("<table width=100% align=center CELLSPACING=2 CELLPADDING=8 style=\"margin:0px 0px 0px 0px;\"><tr>");
        sb.append(button);
        sb.append("<a href=\"" + this.questions + "\" " + webButtonStyle + ">KudoZ questions");
        sb.append("</td>");
        sb.append(button);
        sb.append("<a href=\"" + this.askQuestion + "\" " + webButtonStyle + ">Ask KudoZ question");
        sb.append("</td>");
        sb.append(button);
        sb.append("<a href=\"" + this.searchTerms + "\" " + webButtonStyle + ">Search resources");
        sb.append("</td>");
        sb.append(button);
        sb.append("<a href=\"" + this.wiwo + "\" " + webButtonStyle + ">What I am working on?");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table><br>");
        return sb.toString();
    }

    public void showLinkInMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(HTMLFormat.styles);
        sb.append("<body>");
        sb.append("<br>");
        sb.append("<br>");
        sb.append("<table align=center WIDTH=33% CELLSPACING=8 CELLPADDING=2 style=\"color:white; background-color:#455A64; border-style:ridge; border-width: 1px;\"><tr>");
        sb.append("<th>");
        sb.append("<a href=\"").append(authorizationRequest).append("\" \"style=color:white;font-size:").append(AppPreferences.UIFontSizeHTML).append("\"><u>Connect CafeTran to ProZ.com services</u>");
        sb.append("</th>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</body></html>");
        this.info = sb.toString();
        if (this.mtHTMLPane == null) {
            AppPreferences.prozUIClosed = false;
            this.createView();
        }
        this.showMessage(this.info);
    }

    public void showErrorMessage(String error) {
        if (this.mtHTMLPane == null) {
            AppPreferences.prozUIClosed = false;
            this.createView();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(HTMLFormat.styles);
        sb.append("<body>");
        sb.append(this.getHTMLTooBar());
        sb.append("<table align=center WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=8 CELLPADDING=8><tr>");
        sb.append("<td style=\"color:white; background-color:black\">");
        sb.append(error);
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</body></html>");
        this.info = sb.toString();
        this.showMessage(this.info);
    }

    public void getUser(final boolean showMessageDialog) {
        if (this.timerRefreshQuestions != null) {
            this.timerRefreshQuestions.cancel();
        }
        if (!this.canLook) {
            return;
        }
        this.showMessage("<body></body>");
        final JProgressBar bar = this.topui.getPretranslateProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString("Connecting to ProZ.com...");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ Proz this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                if (this.this$0.cafetranMaxLimitsFor == null) {
                    this.this$0.getCafeTranMaxLimits();
                }
                if (this.this$0.languageCodeMap.isEmpty()) {
                    this.this$0.getLanguageProzCodes();
                }
                if (this.this$0.generalDisciplinesMap.isEmpty()) {
                    this.this$0.getGeneralDisciplines();
                }
                if (this.this$0.specificDisciplinesMap.isEmpty()) {
                    this.this$0.getSpecificDisciplines();
                }
                this.this$0.showUser(showMessageDialog);
                return null;
            }

            @Override
            protected void done() {
                this.this$0.topui.removePretranslateProgressBar(bar);
                if (showMessageDialog && this.this$0.userHTML != null) {
                    JOptionPane.showMessageDialog(this.this$0.topui, this.this$0.userHTML.toString());
                }
            }
        };
        worker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTranslations(String api, boolean isMine) {
        StringBuilder translations = new StringBuilder();
        BufferedReader in = null;
        try {
            String eline;
            StringBuilder sq = new StringBuilder(api);
            sq.append("?access_token=");
            sq.append(AppPreferences.prozToken);
            URL url = new URL(sq.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                String string = null;
                return string;
            }
            String enc = conn.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            InputStream ins = conn.getInputStream();
            in = new BufferedReader(new InputStreamReader(ins, enc));
            this.running = true;
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null && this.running) {
                sb.append(eline);
            }
            JSONObject myjson = new JSONObject(sb.toString());
            JSONArray jarray1 = myjson.getJSONArray("translations");
            translations.append("<ol>");
            for (int i = 0; i < jarray1.length(); ++i) {
                JSONObject jo = jarray1.getJSONObject(i);
                String tterm = jo.getString("translated_term");
                String explanation = jo.getString("explanation");
                int confidence = jo.getInt("confidence");
                String translator = jo.getString("translator");
                boolean myAnswer = false;
                if (this.uuid.length() > 0 && translator.endsWith(this.uuid)) {
                    myAnswer = true;
                }
                String time = !jo.isNull("time_updated") ? jo.getString("time_updated") : jo.getString("time_posted");
                boolean isNew = false;
                DateTimeFormatter timeFormatter = DateTimeFormatter.ISO_DATE_TIME;
                TemporalAccessor accessor = timeFormatter.parse(time);
                Date date = Date.from(Instant.from(accessor));
                if (this.lastQuestionsCheck != null && this.lastQuestionsCheck.before(date)) {
                    isNew = true;
                    if (isMine) {
                        ++this.newTranslations;
                    }
                }
                translations.append("<li>");
                if (!isNew) {
                    translations.append("<p>");
                } else {
                    translations.append("<p style=\"color:white;background-color:#D81B60\">");
                }
                translations.append("<b>");
                translations.append(tterm);
                translations.append("</b>");
                translations.append("</p>");
                if (explanation.length() > 0) {
                    if (myAnswer) {
                        translations.append("<p style=\"border-width:2px 0px 0px 0px; border-style:solid;border-color:#D81B60\">");
                    } else {
                        translations.append("<p style=\"border-width:1px 0px 0px 0px; border-style:solid;border-color:#BDBDBD\">");
                    }
                    explanation = explanation.replace("\n", "<br>");
                    translations.append(explanation);
                    translations.append("</p>");
                }
                JSONArray refs = jo.getJSONArray("reference_urls");
                for (int j = 0; j < refs.length(); ++j) {
                    String refURL = refs.getString(j);
                    translations.append("<p style=\"border-width:1px 0px 0px 0px; border-style:solid;border-color:#BDBDBD\">");
                    translations.append("<a href=\"" + refURL + "\">");
                    translations.append("Reference");
                    translations.append("</a>");
                    translations.append("</p>");
                }
                JSONArray examples = jo.getJSONArray("example_sentences");
                for (int j = 0; j < examples.length(); ++j) {
                    String ex = examples.getString(j);
                    translations.append("<p style=\"border-width:1px 0px 0px 0px; border-style:solid;border-color:#BDBDBD\">");
                    translations.append(ex);
                    translations.append("</p>");
                }
                String confidenceColor = confidence == 1 ? this.confidenceColor1 : (confidence == 2 ? this.confidenceColor2 : (confidence == 3 ? this.confidenceColor3 : (confidence == 4 ? this.confidenceColor4 : (confidence == 5 ? this.confidenceColor5 : this.confidenceColor1))));
                translations.append("<p style=\"color:white; background-color:").append(confidenceColor).append("\">");
                translations.append("Confidence: ");
                translations.append(confidence);
                translations.append("</p>");
                translations.append("</li>");
            }
            translations.append("</ol>");
            this.canLook = true;
            this.closeConnection(in);
        }
        catch (IOException er) {
            er.printStackTrace();
        }
        catch (JSONException er) {
            er.printStackTrace();
        }
        finally {
            this.canLook = true;
            this.closeConnection(in);
        }
        return translations.toString();
    }

    public void replyToWIWOMessage(final String wiwoID, final String request) {
        if (this.timerRefreshQuestions != null) {
            this.timerRefreshQuestions.cancel();
        }
        final JProgressBar bar = this.topui.getPretranslateProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString("Sending the message...");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ Proz this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.this$0.replyToWiwoMessageAPI(wiwoID, request);
                return null;
            }

            @Override
            protected void done() {
                this.this$0.topui.removePretranslateProgressBar(bar);
                this.this$0.showWiwos(null, null);
            }
        };
        worker.execute();
    }

    public void deleteWIWO(final String wiwoID) {
        if (this.timerRefreshQuestions != null) {
            this.timerRefreshQuestions.cancel();
        }
        final JProgressBar bar = this.topui.getPretranslateProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString("Deleting...");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ Proz this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.this$0.deleteWiwoAPI(wiwoID);
                return null;
            }

            @Override
            protected void done() {
                this.this$0.topui.removePretranslateProgressBar(bar);
                this.this$0.showWiwos(null, null);
            }
        };
        worker.execute();
    }

    public void sendWIWOMediaMessage(File file, String request) {
        new ProzMediaUploadHTTP(file, request);
    }

    public void sendWIWOMessage(final String request) {
        if (this.timerRefreshQuestions != null) {
            this.timerRefreshQuestions.cancel();
        }
        final JProgressBar bar = this.topui.getPretranslateProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString("Sending the message...");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ Proz this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.this$0.sendWiwoMessageAPI(request);
                return null;
            }

            @Override
            protected void done() {
                this.this$0.topui.removePretranslateProgressBar(bar);
                this.this$0.showWiwos(null, null);
            }
        };
        worker.execute();
    }

    public void askKudoZQuestion(final String request) {
        if (this.timerRefreshQuestions != null) {
            this.timerRefreshQuestions.cancel();
        }
        final JProgressBar bar = this.topui.getPretranslateProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString("Asking a question...");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ Proz this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.this$0.askKudoZQuestionAPI(request);
                return null;
            }

            @Override
            protected void done() {
                this.this$0.topui.removePretranslateProgressBar(bar);
                this.this$0.getQuestions();
            }
        };
        worker.execute();
    }

    public void askKudoZQuestionAPI(String request) {
        try {
            String eline;
            URL url = new URL(this.questionsURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + AppPreferences.prozToken);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            out.write(request);
            out.close();
            int responseCode = conn.getResponseCode();
            if (responseCode != 201) {
                if (responseCode == 429) {
                    this.showErrorMessage("Too many requests.");
                    return;
                }
                if (responseCode > 499) {
                    this.showErrorMessage("The server error. Please try again later.");
                    return;
                }
                if (AppPreferences.prozRefreshToken != null) {
                    this.refreshToken();
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
            InputStream ins = conn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(ins, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null) {
                sb.append(eline);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Proz.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void deleteWiwoAPI(String wiwoID) {
        try {
            URL url = new URL(this.wiwoURL + "/" + wiwoID);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + AppPreferences.prozToken);
            conn.setDoOutput(true);
            conn.setRequestMethod("DELETE");
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode != 204) {
                if (responseCode == 429) {
                    this.showErrorMessage("Too many requests.");
                    return;
                }
                if (responseCode > 499) {
                    this.showErrorMessage("The server error. Please try again later.");
                    return;
                }
                if (AppPreferences.prozRefreshToken != null) {
                    this.refreshToken();
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Proz.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void updateWiwoMessageAPI(String wiwoID, String request) {
        try {
            URL url = new URL(this.wiwoURL + "/" + wiwoID);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + AppPreferences.prozToken);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("X-HTTP-Method-Override", "PATCH");
            conn.setRequestMethod("POST");
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            out.write(request);
            out.close();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                if (responseCode == 429) {
                    this.showErrorMessage("Too many requests.");
                    return;
                }
                if (responseCode > 499) {
                    this.showErrorMessage("The server error. Please try again later.");
                    return;
                }
                if (AppPreferences.prozRefreshToken != null) {
                    this.refreshToken();
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Proz.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void sendWiwoMessageAPI(String request) {
        try {
            String eline;
            URL url = new URL(this.wiwoURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + AppPreferences.prozToken);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            out.write(request);
            out.close();
            int responseCode = conn.getResponseCode();
            if (responseCode != 201) {
                if (responseCode == 429) {
                    this.showErrorMessage("Too many requests.");
                    return;
                }
                if (responseCode > 499) {
                    this.showErrorMessage("The server error. Please try again later.");
                    return;
                }
                if (AppPreferences.prozRefreshToken != null) {
                    this.refreshToken();
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
            InputStream ins = conn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(ins, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null) {
                sb.append(eline);
            }
            this.wiwoPosted = true;
        }
        catch (IOException ex) {
            Logger.getLogger(Proz.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isWiwoPosted() {
        return this.wiwoPosted;
    }

    public void replyToWiwoMessageAPI(String wiwoID, String request) {
        try {
            String eline;
            URL url = new URL(this.wiwoURL + "/" + wiwoID + "/replies");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + AppPreferences.prozToken);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            out.write(request);
            out.close();
            int responseCode = conn.getResponseCode();
            if (responseCode != 201) {
                if (responseCode == 429) {
                    this.showErrorMessage("Too many requests.");
                    return;
                }
                if (responseCode > 499) {
                    this.showErrorMessage("The server error. Please try again later.");
                    return;
                }
                if (AppPreferences.prozRefreshToken != null) {
                    this.refreshToken();
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
            InputStream ins = conn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(ins, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null) {
                sb.append(eline);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Proz.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void answerKudoZQuestion(final String request, final String id) {
        if (this.timerRefreshQuestions != null) {
            this.timerRefreshQuestions.cancel();
        }
        final JProgressBar bar = this.topui.getPretranslateProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString("Answering a question...");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ Proz this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.this$0.answerKudoZQuestionAPI(request, id);
                return null;
            }

            @Override
            protected void done() {
                this.this$0.topui.removePretranslateProgressBar(bar);
                this.this$0.getQuestions();
            }
        };
        worker.execute();
    }

    public void answerKudoZQuestionAPI(String request, String id) {
        try {
            String eline;
            URL url = new URL(this.questionsURL + "/" + id + "/translations");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + AppPreferences.prozToken);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            out.write(request);
            out.close();
            int responseCode = conn.getResponseCode();
            if (responseCode != 201) {
                if (responseCode == 429) {
                    this.showErrorMessage("Too many requests.");
                    return;
                }
                if (responseCode > 499) {
                    this.showErrorMessage("The server error. Please try again later.");
                    return;
                }
                if (AppPreferences.prozRefreshToken != null) {
                    this.refreshToken();
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
            InputStream ins = conn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(ins, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null) {
                sb.append(eline);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Proz.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void getQuestions() {
        if (this.timerRefreshQuestions != null) {
            this.timerRefreshQuestions.cancel();
        }
        if (this.uuid.length() == 0) {
            this.getUser(false);
            return;
        }
        this.showMessage("<body></body>");
        final JProgressBar bar = this.topui.getPretranslateProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString("Fetching questions...");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ Proz this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.this$0.getQuestionsAPI();
                return null;
            }

            @Override
            protected void done() {
                this.this$0.newTranslations = 0;
                this.this$0.topui.removePretranslateProgressBar(bar);
                if (AppPreferences.prozKudozQuestionsUpdate.equals("auto")) {
                    this.this$0.timerRefreshQuestions = new java.util.Timer();
                    this.this$0.timerRefreshQuestions.schedule((TimerTask)this.this$0.new RefreshQuestionsTask(), 180000L, 180000L);
                }
            }
        };
        worker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getQuestionsAPI() {
        this.canLook = false;
        String color = "#303F9F";
        StringBuilder html = new StringBuilder();
        html.append("<html>");
        html.append(HTMLFormat.glossaryStyles);
        html.append("<body>");
        html.append(this.getHTMLTooBar());
        html.append("<table WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=2 CELLPADDING=4>");
        BufferedReader in = null;
        try {
            String eline;
            StringBuilder sq = new StringBuilder();
            sq.append(this.questionsURL);
            sq.append("?access_token=");
            sq.append(AppPreferences.prozToken);
            if (AppPreferences.prozKudozQuestionsLangs.equals("mine")) {
                sq.append("&language_pairs=mine");
            }
            if (AppPreferences.prozKudozQuestionsFields.length() > 0 && !AppPreferences.prozKudozQuestionsFields.equals("all")) {
                sq.append("&disc_spec_ids=");
                sq.append(AppPreferences.prozKudozQuestionsFields);
            }
            if (AppPreferences.prozKudozQuestionsLevel.length() > 0 && !AppPreferences.prozKudozQuestionsLevel.equals("all")) {
                sq.append("&level=");
                sq.append(AppPreferences.prozKudozQuestionsLevel);
            }
            if (AppPreferences.prozKudozQuestionsStatus.length() > 0 && !AppPreferences.prozKudozQuestionsStatus.equals("all")) {
                sq.append("&status=");
                sq.append(AppPreferences.prozKudozQuestionsStatus);
            }
            if (AppPreferences.prozKudozQuestionsPersonal.length() > 0 && !AppPreferences.prozKudozQuestionsPersonal.equals("all")) {
                sq.append("&personal=");
                sq.append(AppPreferences.prozKudozQuestionsPersonal);
            }
            int pp = 20;
            if (AppPreferences.prozKudozQuestionsPerPage.length() > 0) {
                sq.append("&per_page=");
                sq.append(AppPreferences.prozKudozQuestionsPerPage);
                pp = Integer.valueOf(AppPreferences.prozKudozQuestionsPerPage);
            }
            sq.append("&page=");
            sq.append(this.questionsPage);
            URL url = new URL(sq.toString());
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            int responseCode = con.getResponseCode();
            if (responseCode != 200) {
                if (responseCode == 429) {
                    this.showErrorMessage("Too many requests.");
                    return;
                }
                if (responseCode > 499) {
                    this.showErrorMessage("The server error. Please try again later.");
                    return;
                }
                if (AppPreferences.prozRefreshToken != null) {
                    this.refreshToken();
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
            String enc = con.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            InputStream ins = con.getInputStream();
            in = new BufferedReader(new InputStreamReader(ins, enc));
            this.running = true;
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null && this.running) {
                sb.append(eline);
            }
            JSONObject myjson = new JSONObject(sb.toString());
            JSONArray jarray1 = myjson.getJSONArray("kudoz");
            boolean found = false;
            boolean colorRow = false;
            Date checkTime = new Date();
            for (int i = 0; i < jarray1.length(); ++i) {
                StringBuilder recordURL = new StringBuilder();
                recordURL.append("https://www.proz.com/kudoz/");
                JSONObject jo = jarray1.getJSONObject(i);
                String sourceTerm = jo.getString("source_term");
                String context = jo.getString("context");
                String time = jo.getString("time_published");
                int id = jo.getInt("id");
                String status = jo.getString("status");
                int specDiscID = jo.getInt("disc_spec_id");
                DateTimeFormatter timeFormatter = DateTimeFormatter.ISO_DATE_TIME;
                TemporalAccessor accessor = timeFormatter.parse(time);
                Date date = Date.from(Instant.from(accessor));
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                time = dateFormat.format(date);
                JSONObject joAsker = jo.getJSONObject("created_by");
                String asker = !joAsker.isNull("name") ? joAsker.getString("name") : "";
                boolean isMine = false;
                if (!joAsker.isNull("user")) {
                    String user = joAsker.getString("user");
                    if (this.uuid.length() > 0 && user.endsWith(this.uuid)) {
                        isMine = true;
                    }
                }
                int number = jo.getInt("num_translations");
                String glossaryTerm = null;
                if (number > 0 && !jo.isNull("suggested_translations")) {
                    String api = jo.getString("suggested_translations");
                    glossaryTerm = this.getTranslations(api, isMine);
                }
                String langs = jo.getString("language_pair");
                if (i == 0) {
                    SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
                    String timeString = timeFormat.format(checkTime);
                    html.append("<tr>");
                    StringBuilder nav = new StringBuilder();
                    if (this.questionsPage > 1) {
                        nav.append("<a href=\"questionsPrevious\" \"style=color:#FFFFFF;font-size:").append(AppPreferences.UIFontSizeHTML).append("\"><b><u>Previous</b></u>&nbsp;&nbsp;");
                    }
                    if (jarray1.length() == pp) {
                        nav.append("<a href=\"questionsNext\" \"style=color:#FFFFFF;font-size:").append(AppPreferences.UIFontSizeHTML).append("\"><b><u>Next</b></u>");
                    }
                    html.append("<td style=\"color:#FFFFFF; background-color:#0074CC\" width=15% align=center colspan=1>");
                    html.append("</td>");
                    html.append("<td style=\"color:#FFFFFF; background-color:#0074CC\" align=center>");
                    html.append("Updated at ");
                    html.append(timeString);
                    html.append("</td>");
                    html.append("<td style=\"color:#FFFFFF; background-color:#0074CC\" align=right>");
                    html.append((CharSequence)nav);
                    html.append("</td>");
                    html.append("</tr>");
                }
                html.append("<tr>");
                colorRow = !colorRow;
                html.append("<td style=\"color:#FFFFFF; background-color:#0074CC\" align=left valign=top>");
                html.append(time);
                html.append("<p>");
                int k = langs.indexOf(95);
                String targetLang = null;
                if (k != -1) {
                    String la2;
                    String la1 = langs.substring(0, k);
                    String s = (String)this.codeLanguageMap.get(la1);
                    if (s != null) {
                        la1 = s;
                    }
                    targetLang = la2 = langs.substring(k + 1);
                    s = (String)this.codeLanguageMap.get(la2);
                    if (s != null) {
                        la2 = s;
                    }
                    html.append(la1 + " - " + la2);
                }
                html.append("</p>");
                html.append("<br>");
                html.append("<p>");
                html.append(asker);
                html.append("</p>");
                html.append("<p>");
                String specd = (String)this.specificDisciplinesMap.get(specDiscID);
                html.append(specd);
                html.append("</p>");
                html.append("</td>");
                if (!status.equals("open")) {
                    html.append("<TD WIDTH=50% BGCOLOR=" + Colors.reviewColorHTML + " BORDER=0 VALIGN=CENTER ALIGN=LEFT>");
                } else if (!colorRow) {
                    html.append(HTMLFormat.defaultRowLeftAlign2);
                } else {
                    html.append(HTMLFormat.defaultRowLeftAlign2);
                }
                html.append("<p>");
                recordURL.append(id);
                html.append("<a href=\"" + recordURL + "\">");
                html.append("<b>");
                html.append(sourceTerm);
                html.append("</b>");
                html.append("</p>");
                if (isMine) {
                    html.append("<p style=\"border-width:2px 0px 0px 0px; border-style:solid;border-color:#D81B60\">");
                } else {
                    html.append("<p style=\"border-width:1px 0px 0px 0px; border-style:solid;border-color:#BDBDBD\">");
                }
                context = context.replace("\n", "<br>");
                context = context.replace("\\\"", "\"");
                context = context.replace("\\'", "'");
                html.append(context);
                html.append("</p>");
                html.append("</td>");
                if (!colorRow) {
                    html.append(HTMLFormat.defaultRowLeftAlign2);
                } else {
                    html.append(HTMLFormat.defaultRowLeftAlign2);
                }
                if (status.equals("open") && !isMine && targetLang != null) {
                    StringBuilder termRef = new StringBuilder();
                    termRef.append(this.answerQuestion);
                    termRef.append(id);
                    termRef.append(":");
                    termRef.append(targetLang);
                    termRef.append(":");
                    termRef.append(sourceTerm);
                    html.append("<p align=left style=\"border-width:0px 0px 1px 0px; border-style:solid;border-color:#BDBDBD\">");
                    html.append("<a href=\"" + termRef.toString() + "\">");
                    html.append("<b>");
                    html.append("Answer");
                    html.append("</b>");
                    html.append("</p>");
                }
                if (glossaryTerm != null) {
                    html.append(glossaryTerm);
                }
                html.append("</td>");
                html.append("</tr>");
                if (i == jarray1.length() - 1 && i > 5) {
                    html.append("<tr>");
                    StringBuilder nav = new StringBuilder();
                    if (this.questionsPage > 1) {
                        nav.append("<a href=\"questionsPrevious\" \"style=color:#FFFFFF;font-size:").append(AppPreferences.UIFontSizeHTML).append("\"><b><u>Previous</b></u>&nbsp;&nbsp;");
                    }
                    nav.append("<a href=\"questionsNext\" \"style=color:#FFFFFF;font-size:").append(AppPreferences.UIFontSizeHTML).append("\"><b><u>Next</b></u>");
                    html.append("<td style=\"color:#FFFFFF; background-color:#0074CC\" align=center colspan=1>");
                    html.append("</td>");
                    html.append("<td style=\"color:#FFFFFF; background-color:#0074CC\" align=right colspan=2>");
                    html.append((CharSequence)nav);
                    html.append("</td>");
                    html.append("</tr>");
                }
                found = true;
            }
            html.append("</table>");
            this.lastQuestionsCheck = checkTime;
            if (!found) {
                html.setLength(0);
                html.append("<html>");
                html.append(HTMLFormat.styles);
                html.append("<body>");
                html.append(this.getHTMLTooBar());
                this.addHTMLNoResultsFoundMessage(html);
            }
            html.append("</body></html>");
            String r = html.toString();
            this.showMessage(r);
            this.canLook = true;
            this.closeConnection(in);
        }
        catch (IOException er) {
            StringBuilder sb = new StringBuilder();
            sb.append("ProZ.com web service is not available!");
            sb.append("<br><br>");
            sb.append(er.toString());
            this.showErrorMessage(sb.toString());
        }
        catch (JSONException er) {
            er.printStackTrace();
            this.showErrorMessage(er.toString());
        }
        finally {
            this.canLook = true;
            this.closeConnection(in);
        }
    }

    private String getRequestedTerm() {
        String query = this.topui.getResourceView().getLookUpText();
        query = query != null && query.length() > 0 ? XMLHelper.parseTags(query) : "";
        return query;
    }

    public void tanslate(String segment) {
        if (this.timerRefreshQuestions != null) {
            this.timerRefreshQuestions.cancel();
        }
        this.showMessage("<body></body>");
        if (this.refreshTokenTrials > 3) {
            this.showLinkInMessage();
            return;
        }
        if (AppPreferences.prozToken != null) {
            segment = segment.replaceAll("\\s+", " ");
            this.termSearch(segment, this.arrayResources, 0, true);
        } else {
            this.showLinkInMessage();
        }
    }

    @Override
    public void search(String term, String rep) {
        this.searchTerms(term, this.arrayResources, 0, false);
    }

    private void searchTerms(String term, final String[] resources, final int pageStart, final boolean exactFragments) {
        if (this.timerRefreshQuestions != null) {
            this.timerRefreshQuestions.cancel();
        }
        if (term == null && ((term = this.getRequestedTerm()) == null || term.length() == 0)) {
            return;
        }
        this.currentTerm = term = term.replaceAll("\\s+", " ");
        this.showMessage("<body></body>");
        if (this.refreshTokenTrials > 3) {
            this.showLinkInMessage();
            return;
        }
        final JProgressBar bar = this.topui.getPretranslateProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString("Searching terms at ProZ.com...");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ Proz this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.this$0.termSearch(this.this$0.currentTerm, resources, pageStart, exactFragments);
                return null;
            }

            @Override
            protected void done() {
                this.this$0.topui.removePretranslateProgressBar(bar);
            }
        };
        worker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void termSearch(String request, String[] resources, int pageStart, boolean exactFragments) {
        try {
            request = URLEncoder.encode(request, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        this.canLook = false;
        StringBuilder html = new StringBuilder();
        html.append("<html>");
        html.append(HTMLFormat.styles);
        html.append("<body>");
        html.append(this.getHTMLTooBar());
        html.append("<table WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=2 CELLPADDING=2>");
        BufferedReader in = null;
        try {
            JSONArray jarrayObjects;
            String eline;
            StringBuilder sq = new StringBuilder();
            sq.append("access_token=");
            sq.append(AppPreferences.prozToken);
            sq.append("&query=");
            sq.append(request);
            if (resources != null) {
                for (int i = 0; i < resources.length; ++i) {
                    String resource = resources[i];
                    if (resource == null) continue;
                    sq.append("&resources[]=");
                    sq.append(resource);
                }
            }
            sq.append("&separate_resources=true");
            sq.append("&results_per_page=");
            sq.append("50");
            if (pageStart > 0) {
                sq.append("&results_start=");
                sq.append(Integer.toString(pageStart));
            }
            if (AppPreferences.prozSourceLangSpecified && this.sourceLanguage != null) {
                String code = (String)this.languageCodeMap.get(this.sourceLanguage);
                if (code != null) {
                    sq.append("&language_source=");
                    sq.append(code);
                } else {
                    return;
                }
            }
            if (AppPreferences.prozTargetLangSpecified && this.targetLanguage != null) {
                String code = (String)this.languageCodeMap.get(this.targetLanguage);
                if (code != null) {
                    sq.append("&language_target=");
                    sq.append(code);
                } else {
                    return;
                }
            }
            if (exactFragments) {
                sq.append("&exact_match_fragments=true");
            } else if (AppPreferences.prozExactMatching) {
                sq.append("&match_entire_phrase=true");
            }
            URL url = new URL(this.termSearchURL);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.getOutputStream().write(sq.toString().getBytes("UTF-8"));
            int responseCode = con.getResponseCode();
            if (responseCode != 200) {
                if (responseCode == 429) {
                    this.showErrorMessage("Too many requests.");
                    return;
                }
                if (responseCode > 499) {
                    this.showErrorMessage("The server error. Please try again later.");
                    return;
                }
                if (AppPreferences.prozRefreshToken != null) {
                    this.refreshToken();
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
            String enc = con.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            InputStream ins = con.getInputStream();
            in = new BufferedReader(new InputStreamReader(ins, enc));
            this.running = true;
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null && this.running) {
                sb.append(eline);
            }
            if (exactFragments) {
                jarrayObjects = new JSONArray(sb.toString());
            } else {
                JSONObject myjson = new JSONObject(sb.toString());
                jarrayObjects = new JSONArray();
                jarrayObjects.put(myjson);
            }
            boolean found = false;
            boolean emptyRow = false;
            for (int m = 0; m < jarrayObjects.length(); ++m) {
                JSONObject myjson = jarrayObjects.getJSONObject(m);
                JSONArray jarray1 = myjson.getJSONArray("term_search_result_set");
                boolean hasResults = false;
                for (int i = 0; i < jarray1.length(); ++i) {
                    int ps;
                    String htmlRes;
                    JSONObject jo = jarray1.getJSONObject(i);
                    JSONArray jarray2 = jo.getJSONArray("search_results");
                    if (jarray2.length() == 0) continue;
                    String res = jo.getString("resource");
                    JSONObject meta = jo.getJSONObject("meta");
                    int rt = meta.getInt("results_total");
                    int rs = meta.getInt("result_start");
                    int re = meta.getInt("result_end");
                    boolean isKudoZ = false;
                    if (res.equals("kudoz")) {
                        htmlRes = this.kudoz + ": ";
                        isKudoZ = true;
                    } else {
                        htmlRes = res.equals("kog") ? this.kog + ": " : (res.equals("gloss") ? this.gloss + ": " : (res.equals("glosspost") ? this.glossPost + ": " : (res.equals("gbk") ? this.gbk + ": " : (res.equals("wikiwords") ? this.wikiwords + ": " : res + ": "))));
                    }
                    String color = "#0074CC";
                    htmlRes = rt > 50 ? htmlRes + rs + " - " + re + " out of " + rt : htmlRes + rt;
                    if (i > 0 && found && !emptyRow) {
                        html.append("<tr>");
                        if (AppPreferences.prozTermInfoDisplay) {
                            html.append("<td colspan=3>");
                        } else {
                            html.append("<td colspan=2>");
                        }
                        html.append("</td>");
                        html.append("</tr>");
                        emptyRow = true;
                    }
                    html.append("<tr>");
                    StringBuilder nav = new StringBuilder();
                    if (rs > 50) {
                        ps = rs - 50 - 1;
                        nav.append("<a href=\"previous ").append(Integer.toString(ps)).append(" ").append(res).append("\" \"style=color:white;font-size:").append(AppPreferences.UIFontSizeHTML).append("\"><b><u>Previous</b></u>&nbsp;&nbsp;");
                    }
                    if (re < rt) {
                        ps = re;
                        nav.append("<a href=\"next ").append(Integer.toString(ps)).append(" ").append(res).append("\" \"style=color:white;font-size:").append(AppPreferences.UIFontSizeHTML).append("\"><b><u>Next</b></u>");
                    }
                    if (AppPreferences.prozTermInfoDisplay) {
                        html.append("<td width=25% style=\"color:#FFFFFF; background-color:" + color + "\" align=left>");
                        html.append("</td>");
                    }
                    html.append("<td style=\"color:#FFFFFF; background-color:" + color + "\" align=left colspan=1><b>");
                    html.append(htmlRes);
                    html.append("</b></td>");
                    html.append("<td style=\"color:#FFFFFF; background-color:" + color + "\" align=right colspan=1>");
                    html.append((CharSequence)nav);
                    html.append("</td>");
                    html.append("</tr>");
                    boolean colorRow = false;
                    for (int j = 0; j < jarray2.length(); ++j) {
                        String target2;
                        String target;
                        String source2;
                        String source;
                        JSONObject jo2 = jarray2.getJSONObject(j);
                        String langs = jo2.getString("language_pair");
                        JSONArray ja = jo2.getJSONArray("disc_gens");
                        JSONArray ja2 = jo2.getJSONArray("disc_specs");
                        html.append("<tr>");
                        boolean bl = colorRow = !colorRow;
                        if (!jo2.isNull("term_source_highlight")) {
                            source = jo2.getString("term_source_highlight");
                            source2 = jo2.getString("term_source");
                        } else {
                            source2 = !jo2.isNull("source_source") ? (source = jo2.getString("term_source")) : (source = "");
                        }
                        if (!jo2.isNull("term_target_highlight")) {
                            target = jo2.getString("term_target_highlight");
                            target2 = jo2.getString("term_target");
                        } else {
                            target2 = !jo2.isNull("term_target") ? (target = jo2.getString("term_target")) : (target = "");
                        }
                        if (AppPreferences.prozTermInfoDisplay) {
                            html.append("<td width=25% style=\"color:#FFFFFF; background-color:" + color + "\" align=left>");
                            html.append("<p><u>");
                            int k = langs.indexOf(95);
                            if (k != -1) {
                                String la2;
                                String la1 = langs.substring(0, k);
                                String s = (String)this.codeLanguageMap.get(la1);
                                if (s != null) {
                                    la1 = s;
                                }
                                if ((s = (String)this.codeLanguageMap.get(la2 = langs.substring(k + 1))) != null) {
                                    la2 = s;
                                }
                                html.append(la1 + " - " + la2);
                            }
                            html.append("</u></p>");
                            html.append("<p>");
                            StringBuilder sb2 = new StringBuilder();
                            if (ja.length() > 0) {
                                for (int l = 0; l < ja.length(); ++l) {
                                    int n = ja.getInt(l);
                                    Object o = this.generalDisciplinesMap.get(n);
                                    if (o == null) continue;
                                    if (sb2.length() > 0) {
                                        sb2.append(',');
                                    }
                                    sb2.append(o.toString().toUpperCase());
                                }
                            }
                            StringBuilder sb3 = new StringBuilder();
                            if (ja2.length() > 0) {
                                for (int l = 0; l < ja2.length(); ++l) {
                                    int n = ja2.getInt(l);
                                    Object o = this.specificDisciplinesMap.get(n);
                                    if (o == null) continue;
                                    if (sb3.length() > 0) {
                                        sb3.append(',');
                                    }
                                    sb3.append(o.toString());
                                }
                            }
                            if (sb2.length() > 0) {
                                html.append((CharSequence)sb2);
                                if (sb3.length() > 0) {
                                    html.append("<br>");
                                    html.append((CharSequence)sb3);
                                }
                            } else if (sb3.length() > 0) {
                                html.append((CharSequence)sb3);
                            }
                            html.append("</p>");
                            html.append("</td>");
                        }
                        if (!colorRow) {
                            html.append(HTMLFormat.defaultRowLeftAlign2);
                        } else {
                            html.append(HTMLFormat.defaultRowLeftAlign2);
                        }
                        html.append("<p>");
                        html.append(source);
                        html.append("</p>");
                        html.append("</td>");
                        if (!colorRow) {
                            html.append(HTMLFormat.defaultRowLeftAlign2);
                        } else {
                            html.append(HTMLFormat.defaultRowLeftAlign2);
                        }
                        html.append("<p>");
                        html.append(target);
                        html.append("</p>");
                        html.append("</td>");
                        html.append("</tr>");
                        found = true;
                        hasResults = true;
                        emptyRow = false;
                        if (!exactFragments || target2.length() <= 1) continue;
                        String n = "ProZ.com";
                        FragmentMatch fmatch = new FragmentMatch(source2, source2, target2, n, false, 0, 3, 0, 0, 0);
                        TranslateEvent event = this.topui.getMemoryView().getTranslateEvent();
                        if (event == null) continue;
                        event.addFragmentMatch(fmatch);
                    }
                    if (nav.length() <= 0) continue;
                    html.append("<tr>");
                    if (AppPreferences.prozTermInfoDisplay) {
                        html.append("<td width=25% style=\"color:#FFFFFF; background-color:" + color + "\" align=left>");
                        html.append("</td>");
                    }
                    html.append("<td style=\"color:#FFFFFF; background-color:" + color + "\" align=left colspan=1><b>");
                    html.append("</b></td>");
                    html.append("<td style=\"color:#FFFFFF; background-color:" + color + "\" align=right colspan=1>");
                    if (!exactFragments) {
                        html.append((CharSequence)nav);
                    }
                    html.append("</td>");
                    html.append("</tr>");
                }
                if (!hasResults || emptyRow) continue;
                emptyRow = true;
                html.append("<tr>");
                html.append("<td colspan=3>");
                html.append("</td>");
                html.append("</tr>");
            }
            html.append("</table>");
            if (!found) {
                html.setLength(0);
                html.append("<html>");
                html.append(HTMLFormat.styles);
                html.append("<body>");
                html.append(this.getHTMLTooBar());
                this.addHTMLNoResultsFoundMessage(html);
            }
            html.append("</body></html>");
            String r = html.toString();
            this.showMessage(r);
            this.canLook = true;
            this.closeConnection(in);
        }
        catch (IOException er) {
            StringBuilder sb = new StringBuilder();
            sb.append("ProZ.com web service is not available!");
            sb.append("<br><br>");
            sb.append(er.toString());
            this.showErrorMessage(sb.toString());
        }
        catch (JSONException er) {
            er.printStackTrace();
            this.showErrorMessage(er.toString());
        }
        finally {
            this.canLook = true;
            this.closeConnection(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCafeTranMaxLimits() {
        BufferedReader in = null;
        try {
            String t;
            String eline;
            StringBuilder sq = new StringBuilder();
            sq.append(this.cafetranURL);
            sq.append("access_token=");
            sq.append(AppPreferences.prozToken);
            URL url = new URL(sq.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int responseCode = conn.getResponseCode();
            if (responseCode != 201) {
                if (responseCode == 403) {
                    this.showErrorMessage("Only CafeTran Espresso is authorized to use this resource.");
                }
                return;
            }
            String enc = conn.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            InputStream ins = conn.getInputStream();
            in = new BufferedReader(new InputStreamReader(ins, enc));
            this.running = true;
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null && this.running) {
                sb.append(eline);
            }
            JSONObject myjson = new JSONObject(sb.toString());
            if (myjson != null && myjson.has(t = "cafetran_release_max_limits_for") && !myjson.isNull(t)) {
                this.cafetranMaxLimitsFor = myjson.getString(t);
            }
            this.canLook = true;
            this.closeConnection(in);
        }
        catch (IOException er) {
            StringBuilder sb = new StringBuilder();
            sb.append("ProZ.com web service is not available!");
            sb.append("<br><br>");
            sb.append(er.toString());
            this.showErrorMessage(er.toString());
        }
        catch (JSONException er) {
            er.printStackTrace();
            this.showErrorMessage(er.toString());
        }
        finally {
            this.canLook = true;
            this.closeConnection(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLanguageProzCodes() {
        BufferedReader in = null;
        try {
            String eline;
            StringBuilder sq = new StringBuilder();
            sq.append(this.languageURL);
            sq.append("access_token=");
            sq.append(AppPreferences.prozToken);
            URL url = new URL(sq.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                if (responseCode == 429) {
                    this.showErrorMessage("Too many requests.");
                    return;
                }
                if (responseCode > 499) {
                    this.showErrorMessage("The server error. Please try again later.");
                    return;
                }
                if (AppPreferences.prozRefreshToken != null) {
                    this.refreshToken();
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
            String enc = conn.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            InputStream ins = conn.getInputStream();
            in = new BufferedReader(new InputStreamReader(ins, enc));
            this.running = true;
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null && this.running) {
                sb.append(eline);
            }
            JSONObject myjson = new JSONObject(sb.toString());
            JSONArray jarray1 = myjson.getJSONArray("languages");
            if (jarray1 != null) {
                for (int i = 0; i < jarray1.length(); ++i) {
                    JSONObject jo = jarray1.getJSONObject(i);
                    if (jo == null) continue;
                    String lcode = jo.getString("language_code");
                    String lname = jo.getString("language_name");
                    this.languageCodeMap.put(lname, lcode);
                    this.codeLanguageMap.put(lcode, lname);
                }
            }
            this.canLook = true;
            this.closeConnection(in);
        }
        catch (IOException er) {
            StringBuilder sb = new StringBuilder();
            sb.append("ProZ.com web service is not available!");
            sb.append("<br><br>");
            sb.append(er.toString());
            this.showErrorMessage(er.toString());
        }
        catch (JSONException er) {
            er.printStackTrace();
            this.showErrorMessage(er.toString());
        }
        finally {
            this.canLook = true;
            this.closeConnection(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getGeneralDisciplines() {
        BufferedReader in = null;
        try {
            String eline;
            StringBuilder sq = new StringBuilder();
            sq.append(this.generalDisciplinesURL);
            sq.append("access_token=");
            sq.append(AppPreferences.prozToken);
            URL url = new URL(sq.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                if (responseCode == 429) {
                    this.showErrorMessage("Too many requests.");
                    return;
                }
                if (responseCode > 499) {
                    this.showErrorMessage("The server error. Please try again later.");
                    return;
                }
                if (AppPreferences.prozRefreshToken != null) {
                    this.refreshToken();
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
            String enc = conn.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            InputStream ins = conn.getInputStream();
            in = new BufferedReader(new InputStreamReader(ins, enc));
            this.running = true;
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null && this.running) {
                sb.append(eline);
            }
            JSONObject myjson = new JSONObject(sb.toString());
            JSONArray jarray1 = myjson.getJSONArray("general-disciplines");
            if (jarray1 != null) {
                for (int i = 0; i < jarray1.length(); ++i) {
                    JSONObject jo = jarray1.getJSONObject(i);
                    if (jo == null) continue;
                    int id = jo.getInt("disc_gen_id");
                    String name = jo.getString("disc_gen_name");
                    this.generalDisciplinesMap.put(id, name);
                }
            }
            this.canLook = true;
            this.closeConnection(in);
        }
        catch (IOException er) {
            StringBuilder sb = new StringBuilder();
            sb.append("ProZ.com web service is not available!");
            sb.append("<br><br>");
            sb.append(er.toString());
            this.showErrorMessage(er.toString());
        }
        catch (JSONException er) {
            er.printStackTrace();
            this.showErrorMessage(er.toString());
        }
        finally {
            this.canLook = true;
            this.closeConnection(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSpecificDisciplines() {
        BufferedReader in = null;
        try {
            String eline;
            StringBuilder sq = new StringBuilder();
            sq.append(this.specificDisciplinesURL);
            sq.append("access_token=");
            sq.append(AppPreferences.prozToken);
            URL url = new URL(sq.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                if (responseCode == 429) {
                    this.showErrorMessage("Too many requests.");
                    return;
                }
                if (responseCode > 499) {
                    this.showErrorMessage("The server error. Please try again later.");
                    return;
                }
                if (AppPreferences.prozRefreshToken != null) {
                    this.refreshToken();
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
            String enc = conn.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            InputStream ins = conn.getInputStream();
            in = new BufferedReader(new InputStreamReader(ins, enc));
            this.running = true;
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null && this.running) {
                sb.append(eline);
            }
            JSONObject myjson = new JSONObject(sb.toString());
            JSONArray jarray1 = myjson.getJSONArray("specific-disciplines");
            if (jarray1 != null) {
                for (int i = 0; i < jarray1.length(); ++i) {
                    JSONObject jo = jarray1.getJSONObject(i);
                    if (jo == null) continue;
                    int id = jo.getInt("disc_spec_id");
                    String name = jo.getString("disc_spec_name");
                    this.specificDisciplinesMap.put(id, name);
                }
            }
            this.canLook = true;
            this.closeConnection(in);
        }
        catch (IOException er) {
            StringBuilder sb = new StringBuilder();
            sb.append("ProZ.com web service is not available!");
            sb.append("<br><br>");
            sb.append(er.toString());
            this.showErrorMessage(er.toString());
        }
        catch (JSONException er) {
            er.printStackTrace();
            this.showErrorMessage(er.toString());
        }
        finally {
            this.canLook = true;
            this.closeConnection(in);
        }
    }

    public String getWiwosURL() {
        return this.wiwoURL;
    }

    public String getNextWiwosURL() {
        return this.wiwoNextURL;
    }

    public String getPreviousWiwosURL() {
        return this.wiwoPreviousURL;
    }

    public void cancelWiwosView() {
        this.wiwosView = null;
        this.wiwoPosted = false;
    }

    public void showWiwos(final String url, final String searchTerm) {
        if (this.timerRefreshQuestions != null) {
            this.timerRefreshQuestions.cancel();
        }
        if (!this.canLook) {
            return;
        }
        runWiwoTimer = false;
        final JProgressBar bar = this.topui.getPretranslateProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString("Connecting to ProZ.com...");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ Proz this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.this$0.getWiwos(url, searchTerm, false);
                return null;
            }

            @Override
            protected void done() {
                this.this$0.topui.removePretranslateProgressBar(bar);
                if (this.this$0.wiwoArray != null) {
                    if (this.this$0.wiwosView == null) {
                        this.this$0.wiwosView = new ProzWIWOSView(this.this$0, this.this$0.wiwoArray);
                        this.this$0.wiwosView.setMainView(this.this$0.topui);
                    } else {
                        this.this$0.wiwosView.setWiwos(this.this$0.wiwoArray);
                    }
                }
            }
        };
        worker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean getWiwos(String stringURL, String searchTerm, boolean checkOnly) {
        boolean newWiwos;
        block53: {
            if (this.refreshTokenTrials > 3) {
                this.showLinkInMessage();
                return false;
            }
            newWiwos = false;
            if (this.wiwoArray == null) {
                this.wiwoArray = new ArrayList();
            }
            this.wiwoArray.clear();
            this.wiwoNextURL = null;
            this.wiwoPreviousURL = null;
            BufferedReader in = null;
            try {
                int i;
                JSONObject linkPrev;
                String eline;
                URL url;
                HttpURLConnection conn;
                int responseCode;
                StringBuilder sq = new StringBuilder();
                if (stringURL == null) {
                    sq.append(this.wiwoURL);
                    sq.append("?access_token=");
                    sq.append(AppPreferences.prozToken);
                    if (AppPreferences.prozWiwoFilter.length() > 0) {
                        if (AppPreferences.prozWiwoFilter.equals("CafeTran Espresso")) {
                            sq.append("&from_this_platform=true");
                        } else if (AppPreferences.prozWiwoFilter.equals("Mine") && this.uuid.length() > 0) {
                            sq.append("&user_uuid=");
                            sq.append(this.uuid);
                        }
                    }
                    if (searchTerm != null) {
                        sq.append("&search_term=");
                        sq.append(searchTerm);
                    }
                } else {
                    sq.append(stringURL);
                }
                sq.append("&include_private=true");
                if (checkOnly) {
                    sq.append("&min_time=");
                    sq.append(this.checkWiwosTime);
                }
                if ((responseCode = (conn = (HttpURLConnection)(url = new URL(sq.toString())).openConnection()).getResponseCode()) != 200) {
                    if (responseCode == 429) {
                        this.showErrorMessage("Too many requests.");
                        boolean bl = false;
                        return bl;
                    }
                    if (responseCode > 499) {
                        this.showErrorMessage("The server error. Please try again later.");
                        boolean bl = false;
                        return bl;
                    }
                    if (AppPreferences.prozRefreshToken != null) {
                        this.refreshToken();
                    } else {
                        this.showLinkInMessage();
                    }
                    boolean bl = false;
                    return bl;
                }
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                df.setTimeZone(TimeZone.getTimeZone("UTC"));
                this.checkWiwosTime = df.format(new Date());
                String enc = conn.getContentEncoding();
                if (enc == null) {
                    enc = "UTF-8";
                }
                InputStream ins = conn.getInputStream();
                in = new BufferedReader(new InputStreamReader(ins, enc));
                this.running = true;
                StringBuilder sb = new StringBuilder();
                while ((eline = in.readLine()) != null && this.running) {
                    sb.append(eline);
                }
                JSONObject jsonObject = new JSONObject(sb.toString());
                JSONArray wiwos = jsonObject.getJSONArray("wiwos");
                if (wiwos.length() > 0) {
                    newWiwos = true;
                }
                if (checkOnly) {
                    boolean bl = newWiwos;
                    this.canLook = true;
                    this.closeConnection(in);
                    return bl;
                }
                JSONObject links = jsonObject.getJSONObject("_links");
                JSONObject linkNext = links.getJSONObject("next");
                if (!linkNext.isNull("href")) {
                    this.wiwoNextURL = linkNext.getString("href");
                }
                if (!(linkPrev = links.getJSONObject("prev")).isNull("href")) {
                    this.wiwoPreviousURL = linkPrev.getString("href");
                }
                HashMap<String, String[]> usersMap = new HashMap<String, String[]>();
                JSONArray users = jsonObject.getJSONArray("users");
                for (i = 0; i < users.length(); ++i) {
                    JSONObject jsonObjectUser = users.getJSONObject(i);
                    String self_link = jsonObjectUser.getString("self_link");
                    String[] arr = new String[]{jsonObjectUser.getString("site_name"), !jsonObjectUser.isNull("image_url") ? jsonObjectUser.getString("image_url") : "", jsonObjectUser.getString("profile_url")};
                    usersMap.put(self_link, arr);
                }
                for (i = 0; i < wiwos.length(); ++i) {
                    String user_link;
                    String uuidUser;
                    JSONObject locationObject;
                    int d;
                    String target;
                    String t;
                    String source;
                    String s;
                    ProzWIWOPost wiwoPost = new ProzWIWOPost();
                    JSONObject jsonObjectWiwo = wiwos.getJSONObject(i);
                    int id = jsonObjectWiwo.getInt("id");
                    wiwoPost.setWiwoID(Integer.toString(id));
                    String message = jsonObjectWiwo.getString("message");
                    String time = jsonObjectWiwo.getString("time");
                    boolean isPublic = jsonObjectWiwo.getBoolean("public");
                    wiwoPost.setPublic(isPublic);
                    if (!jsonObjectWiwo.isNull("source_language") && (s = (String)this.codeLanguageMap.get(source = jsonObjectWiwo.getString("source_language"))) != null) {
                        wiwoPost.setSourceLanguage(s);
                    }
                    if (!jsonObjectWiwo.isNull("target_language") && (t = (String)this.codeLanguageMap.get(target = jsonObjectWiwo.getString("target_language"))) != null) {
                        wiwoPost.setTargetLanguage(t);
                    }
                    if (!jsonObjectWiwo.isNull("disc_gen_id") && (t = (String)this.generalDisciplinesMap.get(d = jsonObjectWiwo.getInt("disc_gen_id"))) != null) {
                        wiwoPost.setDisciplineGeneral(t);
                    }
                    if (!jsonObjectWiwo.isNull("disc_spec_id") && (t = (String)this.specificDisciplinesMap.get(d = jsonObjectWiwo.getInt("disc_spec_id"))) != null) {
                        wiwoPost.setDisciplineSpecific(t);
                    }
                    if (!jsonObjectWiwo.isNull("discipline")) {
                        String d2 = jsonObjectWiwo.getString("discipline");
                        wiwoPost.setDisciplineCustom(d2);
                    }
                    if (!jsonObjectWiwo.isNull("cat_tool")) {
                        String c = jsonObjectWiwo.getString("cat_tool");
                        wiwoPost.setCATTool(c);
                    }
                    if (!jsonObjectWiwo.isNull("image_url")) {
                        String im = jsonObjectWiwo.getString("image_url");
                        wiwoPost.setWiwoImageURL(im);
                    }
                    if (!jsonObjectWiwo.isNull("from_platform")) {
                        JSONObject o = jsonObjectWiwo.getJSONObject("from_platform");
                        String label = o.getString("label");
                        wiwoPost.setPlatform(label);
                        String purl = o.getString("url");
                        wiwoPost.setPlatformURL(purl);
                    }
                    if (!jsonObjectWiwo.isNull("representative_terms")) {
                        JSONArray arr = jsonObjectWiwo.getJSONArray("representative_terms");
                        String[] tarr = new String[arr.length()];
                        for (int j = 0; j < arr.length(); ++j) {
                            tarr[j] = arr.getString(j);
                        }
                        if (tarr.length > 0) {
                            wiwoPost.setTopTerms(tarr);
                        }
                    }
                    if (!jsonObjectWiwo.isNull("wordcount")) {
                        int wc = jsonObjectWiwo.getInt("wordcount");
                        s = String.valueOf(wc);
                        wiwoPost.setWordCount(s);
                    }
                    if (!jsonObjectWiwo.isNull("percent_complete")) {
                        int pc = jsonObjectWiwo.getInt("percent_complete");
                        s = String.valueOf(pc);
                        wiwoPost.setPercentComplete(s);
                    }
                    if (!jsonObjectWiwo.isNull("busy_meter")) {
                        int bm = jsonObjectWiwo.getInt("busy_meter");
                        s = String.valueOf(bm);
                        wiwoPost.setBusyLevel(s);
                    }
                    if (!(jsonObjectWiwo.isNull("location") || (locationObject = jsonObjectWiwo.getJSONObject("location")).isNull("latitude") || locationObject.isNull("longitude"))) {
                        double latitude = locationObject.getDouble("latitude");
                        double longitude = locationObject.getDouble("longitude");
                        wiwoPost.setLatitude(Double.toString(latitude));
                        wiwoPost.setLongitude(Double.toString(longitude));
                    }
                    if ((uuidUser = (user_link = jsonObjectWiwo.getString("user_link")).substring(user_link.lastIndexOf(47) + 1)).equals(this.uuid)) {
                        wiwoPost.setMine(true);
                    }
                    String[] arr = (String[])usersMap.get(user_link);
                    String name = arr[0];
                    String imageURL = arr[1];
                    String profileURL = arr[2];
                    wiwoPost.setName(name);
                    wiwoPost.setUserImageURL(imageURL);
                    wiwoPost.setProfileURL(profileURL);
                    wiwoPost.setMessage(message);
                    wiwoPost.setTime(time);
                    int nr = jsonObjectWiwo.getInt("num_replies");
                    if (nr > 0) {
                        ProzWIWOPost[] wiwoReplies = new ProzWIWOPost[nr];
                        JSONArray replies = jsonObjectWiwo.getJSONArray("replies");
                        for (int j = 0; j < replies.length(); ++j) {
                            ProzWIWOPost wiwoReply = new ProzWIWOPost();
                            JSONObject jsonObjectReply = replies.getJSONObject(j);
                            String messageR = jsonObjectReply.getString("message");
                            String timeR = jsonObjectReply.getString("time");
                            String user_linkR = jsonObjectReply.getString("user_link");
                            String[] arrR = (String[])usersMap.get(user_linkR);
                            String nameR = arrR[0];
                            String imageURLR = arrR[1];
                            String profileURLR = arrR[2];
                            wiwoReply.setName(nameR);
                            wiwoReply.setUserImageURL(imageURLR);
                            wiwoReply.setProfileURL(profileURLR);
                            wiwoReply.setMessage(messageR);
                            wiwoReply.setTime(timeR);
                            if (!jsonObjectReply.isNull("from_platform")) {
                                JSONObject o = jsonObjectReply.getJSONObject("from_platform");
                                String label = o.getString("label");
                                wiwoReply.setPlatform(label);
                                String purl = o.getString("url");
                                wiwoReply.setPlatformURL(purl);
                            }
                            wiwoReplies[j] = wiwoReply;
                        }
                        wiwoPost.setReplies(wiwoReplies);
                    }
                    this.wiwoArray.add(wiwoPost);
                }
                this.canLook = true;
            }
            catch (IOException er) {
                StringBuilder sb = new StringBuilder();
                sb.append("ProZ.com web service is not available!");
                sb.append("<br><br>");
                sb.append(er.toString());
                this.showErrorMessage(sb.toString());
                this.wiwoArray = null;
                break block53;
            }
            catch (Exception er) {
                this.showErrorMessage(er.toString());
                break block53;
            }
            finally {
                this.canLook = true;
                this.closeConnection(in);
            }
            this.closeConnection(in);
        }
        return newWiwos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showUser(boolean messageDialog) {
        benefitCTE = false;
        this.canLook = false;
        this.userHTML = new StringBuilder();
        this.userHTML.append("<html>");
        this.userHTML.append(HTMLFormat.styles);
        this.userHTML.append("<body>");
        if (!messageDialog) {
            this.userHTML.append("<table align=center BORDER=0 BORDERCOLOR=#000000 CELLSPACING=0 CELLPADDING=8>");
        } else {
            this.userHTML.append("<table width=100% align=center BORDER=0 BORDERCOLOR=#000000 CELLSPACING=0 CELLPADDING=4 BGCOLOR=" + HTMLFormat.barBackgroundHitsColor + ">");
        }
        this.userHTML.append("<thead>");
        this.userHTML.append("</thead>");
        BufferedReader in = null;
        try {
            String eline;
            StringBuilder sq = new StringBuilder();
            sq.append(this.userURL);
            sq.append("access_token=");
            sq.append(AppPreferences.prozToken);
            URL url = new URL(sq.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int responseCode = conn.getResponseCode();
            System.out.println(responseCode);
            if (responseCode != 200) {
                if (responseCode == 429) {
                    this.showErrorMessage("Too many requests.");
                    return;
                }
                if (responseCode > 499) {
                    this.showErrorMessage("The server error. Please try again later.");
                    return;
                }
                if (AppPreferences.prozRefreshToken != null) {
                    this.refreshToken();
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
            String enc = conn.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            InputStream ins = conn.getInputStream();
            in = new BufferedReader(new InputStreamReader(ins, enc));
            this.running = true;
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null && this.running) {
                sb.append(eline);
            }
            JSONObject myjson = new JSONObject(sb.toString());
            String siteName = null;
            String email = null;
            String profileURL = null;
            JSONObject jobject1 = null;
            this.userHTML.append("<tr>");
            this.userHTML.append("<td style=\"color:white; background-color:black\" align=center colspan=2>");
            this.userHTML.append("<a href=\"").append("https://www.proz.com").append("\" \"style=color:yellow; font-size:").append(AppPreferences.UIFontSizeHTML).append("\"><b><u>").append("ProZ.com User").append("</b></u>");
            this.userHTML.append("</td>");
            this.userHTML.append("</tr>");
            Iterator iterator = myjson.keys();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!(next instanceof String)) continue;
                String s = next.toString();
                if (s.equals("uuid")) {
                    this.uuid = myjson.getString(s);
                    continue;
                }
                if (s.equals("site_name")) {
                    siteName = myjson.getString(s);
                    continue;
                }
                if (s.equals("email") && !myjson.isNull(s)) {
                    email = myjson.getString(s);
                    continue;
                }
                if (s.equals("profile_url")) {
                    profileURL = myjson.getString(s);
                    continue;
                }
                if (!s.equals("proz_membership")) continue;
                jobject1 = myjson.getJSONObject(s);
            }
            if (siteName != null) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>User name:</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append(siteName);
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            if (email != null) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>Name:</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append(email);
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            if (profileURL != null) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>Profile URL:</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<a href=\"").append(profileURL).append("\" \"style=font-size:").append(AppPreferences.UIFontSizeHTML).append("\"><b><u>").append(profileURL).append("</b></u>");
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            if (jobject1 != null) {
                this.userHTML.append("<tr>");
                this.userHTML.append("<td style=\"color:white; background-color:black\" align=center colspan=2>");
                this.userHTML.append("<b>ProZ.com membership</b>");
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
                boolean professional = false;
                String t = "membership_type";
                if (!jobject1.isNull(t)) {
                    String v = (String)jobject1.get(t);
                    if (v != null && v.equals("professional")) {
                        professional = true;
                    } else if (v != null && v.equals("business")) {
                        professional = true;
                    }
                }
                boolean currentStatus = false;
                String stat = "status";
                if (!jobject1.isNull(stat)) {
                    String v = (String)jobject1.get(stat);
                    if (v != null && v.equals("current")) {
                        currentStatus = true;
                    } else if (v != null && v.equals("not_current") && this.cafetranMaxLimitsFor != null && this.cafetranMaxLimitsFor.equals("all_registered")) {
                        AppPreferences.prozRegisteredMember = true;
                        AppPreferences.isTrialVersion = false;
                        benefitCTE = true;
                    }
                }
                Iterator iterator2 = jobject1.keys();
                while (iterator2.hasNext()) {
                    String k;
                    Object next = iterator2.next();
                    if (!(next instanceof String) || jobject1.isNull(k = next.toString())) continue;
                    String v = "";
                    if (k.equals("expiration_date") || k.equals("expired_date") || k.equals("certified_pro_network_status")) {
                        v = jobject1.getString(k);
                    } else if (k.equals("status")) {
                        v = jobject1.getString(k);
                    } else if (k.equals("membership_package")) {
                        String i = jobject1.getString(k);
                        if (i.equals("pro_premium")) {
                            AppPreferences.prozPremiumMember = true;
                            if (currentStatus && professional && this.cafetranMaxLimitsFor != null && this.cafetranMaxLimitsFor.equals("plus_and_premium")) {
                                v = "<span style=\"color:red\"><b>Premium</b></span>";
                                AppPreferences.isTrialVersion = false;
                                benefitCTE = true;
                            } else if (currentStatus && professional && this.cafetranMaxLimitsFor != null && this.cafetranMaxLimitsFor.equals("plus_only")) {
                                v = "<span style=\"color:red\"><b>Premium</b></span>";
                                AppPreferences.isTrialVersion = false;
                                benefitCTE = true;
                            } else if (currentStatus && professional && this.cafetranMaxLimitsFor != null && this.cafetranMaxLimitsFor.equals("plus_and_standard")) {
                                v = "<span style=\"color:red\"><b>Premium</b></span>";
                                AppPreferences.isTrialVersion = false;
                                benefitCTE = true;
                            } else if (currentStatus && professional && this.cafetranMaxLimitsFor != null && this.cafetranMaxLimitsFor.equals("all_registered")) {
                                v = "<span style=\"color:red\"><b>Premium</b></span>";
                                AppPreferences.isTrialVersion = false;
                                benefitCTE = true;
                            } else if (currentStatus && professional && this.cafetranMaxLimitsFor == null) {
                                v = "<span style=\"color:red\"><b>Premium</b></span>";
                                AppPreferences.isTrialVersion = false;
                                benefitCTE = true;
                            } else {
                                v = "<span style=\"color:red\"><b>Premium</b></span>";
                            }
                        } else if (i.equals("plus")) {
                            AppPreferences.prozPlusMember = true;
                            if (currentStatus && professional && this.cafetranMaxLimitsFor != null && this.cafetranMaxLimitsFor.equals("plus_only")) {
                                v = "<span style=\"color:red\"><b>Plus</b></span>";
                                AppPreferences.isTrialVersion = false;
                                benefitCTE = true;
                            } else if (currentStatus && professional && this.cafetranMaxLimitsFor != null && this.cafetranMaxLimitsFor.equals("plus_and_standard")) {
                                v = "<span style=\"color:red\"><b>Plus</b></span>";
                                AppPreferences.isTrialVersion = false;
                                benefitCTE = true;
                            } else if (currentStatus && professional && this.cafetranMaxLimitsFor != null && this.cafetranMaxLimitsFor.equals("all_registered")) {
                                v = "<span style=\"color:red\"><b>Plus</b></span>";
                                AppPreferences.isTrialVersion = false;
                                benefitCTE = true;
                            } else if (currentStatus && professional && this.cafetranMaxLimitsFor == null) {
                                v = "<span style=\"color:red\"><b>Plus</b></span>";
                                AppPreferences.isTrialVersion = false;
                                benefitCTE = true;
                            } else {
                                v = "<span style=\"color:red\"><b>Plus</b></span>";
                            }
                        } else if (i.equals("standard")) {
                            AppPreferences.prozStandardMember = true;
                            if (currentStatus && professional && this.cafetranMaxLimitsFor != null && this.cafetranMaxLimitsFor.equals("plus_and_standard")) {
                                v = "<span style=\"color:red\"><b>Standard</b></span>";
                                AppPreferences.isTrialVersion = false;
                                benefitCTE = true;
                            } else if (currentStatus && professional && this.cafetranMaxLimitsFor != null && this.cafetranMaxLimitsFor.equals("all_registered")) {
                                v = "<span style=\"color:red\"><b>Standard</b></span>";
                                AppPreferences.isTrialVersion = false;
                                benefitCTE = true;
                            } else {
                                v = "<span style=\"color:red\"><b>Standard</b></span>";
                            }
                        } else if (i.equals("enterprise")) {
                            v = "<span style=\"color:red\"><b>Enterprise</b></span>";
                            if (currentStatus && professional) {
                                AppPreferences.isTrialVersion = false;
                                benefitCTE = true;
                            }
                        }
                    } else {
                        if (!k.equals("membership_type")) continue;
                        v = jobject1.getString(k);
                    }
                    this.userHTML.append("<tr>");
                    this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                    if (k.length() > 0) {
                        k = k.replace('_', ' ');
                        String u = k.substring(0, 1).toUpperCase();
                        k = u + k.substring(1) + ":";
                    }
                    this.userHTML.append("<b>");
                    this.userHTML.append(k);
                    this.userHTML.append("</b>");
                    this.userHTML.append("</td>");
                    this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                    if (v.length() > 0) {
                        v = v.replace('_', ' ');
                    }
                    this.userHTML.append(v);
                    this.userHTML.append("</td>");
                    this.userHTML.append("</tr>");
                }
            }
            if (benefitCTE) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>");
                this.userHTML.append("Benefit:");
                this.userHTML.append("</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                String v = "<span style=\"color:red\"><b>CafeTran full version</b></span>";
                this.userHTML.append(v);
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            this.userHTML.append("</table>");
            this.userHTML.append("</body></html>");
            StringBuilder s = new StringBuilder(this.userHTML);
            s.insert(this.userHTML.indexOf("<body>") + 6, this.getHTMLTooBar());
            this.showMessage(s.toString());
            this.canLook = true;
            this.closeConnection(in);
        }
        catch (IOException er) {
            StringBuilder sb = new StringBuilder();
            sb.append("ProZ.com web service is not available!");
            sb.append("<br><br>");
            sb.append(er.toString());
            this.showErrorMessage(sb.toString());
        }
        catch (JSONException er) {
            er.printStackTrace();
            this.showErrorMessage(er.toString());
        }
        finally {
            this.canLook = true;
            this.closeConnection(in);
        }
    }

    private void closeConnection(BufferedReader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Proz.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void stopSearch() {
        this.running = false;
    }

    public void createView() {
        File file;
        this.mtHTMLPane = new JTextPane();
        this.mtHTMLPane.setEditorKitForContentType("text/html", new CTHTMLEditorKit());
        this.mtHTMLPane.putClientProperty("type", "memory");
        this.mtHTMLPane.addHyperlinkListener(new ProzHyperactive());
        this.mtHTMLPane.setContentType("text/html");
        Graphics g = this.mtHTMLPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        }
        Color background = null;
        if (AppPreferences.background != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            Color foreground = new Color(AppPreferences.foreground);
            background = new Color(AppPreferences.background);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.mtHTMLPane.setCaretColor(foreground);
            this.mtHTMLPane.setBackground(background);
            this.mtHTMLPane.setForeground(foreground);
            this.mtHTMLPane.setSelectionColor(selection);
            this.mtHTMLPane.setSelectedTextColor(foreground);
        }
        this.mtHTMLPane.setFont(new Font(AppPreferences.fontname, AppPreferences.fontstyle, AppPreferences.fontsize));
        this.mtHTMLPane.setMargin(new Insets(0, 0, 0, 0));
        this.mtHTMLPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Proz.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.mtHTMLPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    Proz.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                boolean ctrl = UITools.isShortcutDown(evt);
                if (!ctrl && evt.getButton() == 1) {
                    String sel;
                    int cc = evt.getClickCount();
                    if (cc < 2 && (sel = Proz.this.mtHTMLPane.getSelectedText()) != null && AppPreferences.smartSelection && !AppPreferences.noWordSeparatorTargetLanguage) {
                        try {
                            int spos = Utilities.getWordStart(Proz.this.mtHTMLPane, Proz.this.mtHTMLPane.getSelectionStart());
                            int epos = Utilities.getWordEnd(Proz.this.mtHTMLPane, Proz.this.mtHTMLPane.getSelectionEnd() - 1);
                            Proz.this.mtHTMLPane.setSelectionStart(spos);
                            Proz.this.mtHTMLPane.setSelectionEnd(epos);
                        }
                        catch (BadLocationException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if ((sel = Proz.this.mtHTMLPane.getSelectedText()) != null) {
                        TargetView pview = Proz.this.topui.getTargetView();
                        pview.grabSelection(sel);
                    }
                }
                if (evt.isPopupTrigger()) {
                    Proz.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.mtHTMLPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane();
        if (background != null) {
            jScrollPane.setBackground(background);
        }
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            jScrollPane.getViewport().setOpaque(false);
            this.mtHTMLPane.setBackground(new Color(0, 0, 0, 0));
            this.mtHTMLPane.setOpaque(false);
        }
        jScrollPane.getViewport().add((Component)this.mtHTMLPane, null);
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.mtHTMLPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(this.mtHTMLPane);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        this.mainPanel = new GridPanel();
        this.mainPanel.setBorder(new EmptyBorder(4, 0, 0, 0));
        this.mainPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    Proz.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    Proz.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.mainPanel.setOpaque(false);
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        this.mainPanel.add(jScrollPane);
        this.tview.addTab(this, this.resourceName, this.mainPanel);
    }

    public void showMessage(String mes) {
        if (this.mtHTMLPane != null) {
            HTMLDocument doc = (HTMLDocument)this.mtHTMLPane.getDocument();
            try {
                doc.setInnerHTML(doc.getDefaultRootElement(), mes);
                JViewport vp = (JViewport)this.mtHTMLPane.getParent();
                final JScrollPane scroll = (JScrollPane)vp.getParent();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ Proz this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        scroll.getVerticalScrollBar().setValue(0);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void closeResource() {
        this.running = false;
        this.topui.getResourceView().setProzService("");
        this.tview.removeTab(this.resourceName);
    }

    private String highlightMatch(String html, Pattern p) {
        StringBuffer sbHTML = new StringBuffer();
        Matcher ma = p.matcher(html);
        while (ma.find()) {
            String m = ma.group();
            String h = HTMLFormat.matchColorHTML + m + "</span>";
            ma.appendReplacement(sbHTML, h);
        }
        ma.appendTail(sbHTML);
        return sbHTML.toString();
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public ProzWIWOMessage makeNewProzWiwoMessage() {
        StatisticsView sv;
        String[] wc;
        String prozLang;
        String code;
        ProzWIWOMessage m = new ProzWIWOMessage();
        if (this.sourceLanguage != null && (code = (String)this.languageCodeMap.get(this.sourceLanguage)) != null) {
            prozLang = (String)this.codeLanguageMap.get(code);
            m.setSourceLanguage(prozLang);
        }
        if (this.targetLanguage != null && (code = (String)this.languageCodeMap.get(this.targetLanguage)) != null) {
            prozLang = (String)this.codeLanguageMap.get(code);
            m.setTargetLanguage(prozLang);
        }
        if ((wc = (sv = this.topui.getStatisticsView()).getProjectWordCount()) != null) {
            String pc = wc[1];
            int dot = pc.indexOf(46);
            if (dot != -1) {
                pc = pc.substring(0, dot);
            } else {
                int per = pc.indexOf(37);
                if (per != -1) {
                    pc = pc.substring(0, per);
                }
            }
            m.setWordCount(wc[0]);
            m.setProjectComplete(pc);
        }
        return m;
    }

    public void showQuestionPrefsForm() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AppPreferences.isJavaFXReady()) {
                        ProzQuestionsPreferences o = new ProzQuestionsPreferences(Proz.this);
                        o.setMainView(Proz.this.topui);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void showAskQuestionForm() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AppPreferences.isJavaFXReady()) {
                        String prozLang;
                        String code;
                        ProzAskQuestion q = new ProzAskQuestion();
                        if (Proz.this.sourceLanguage != null && (code = (String)Proz.this.languageCodeMap.get(Proz.this.sourceLanguage)) != null) {
                            prozLang = (String)Proz.this.codeLanguageMap.get(code);
                            q.setSourceLanguage(prozLang);
                        }
                        if (Proz.this.targetLanguage != null && (code = (String)Proz.this.languageCodeMap.get(Proz.this.targetLanguage)) != null) {
                            prozLang = (String)Proz.this.codeLanguageMap.get(code);
                            q.setTargetLanguage(prozLang);
                        }
                        String term = Proz.this.topui.getSourcePane().getSelectedText();
                        String context = Proz.this.topui.getSourcePane().getText();
                        if (term == null) {
                            term = Proz.this.topui.getTargetPane().getSelectedText();
                            context = Proz.this.topui.getTargetPane().getText();
                        }
                        if (term != null) {
                            term = XMLHelper.parseTags(term);
                            q.setTerm(term);
                        }
                        if (context != null) {
                            context = XMLHelper.parseTags(context);
                            q.setContext(context);
                        }
                        ProzAskQuestionView p = new ProzAskQuestionView(Proz.this, q);
                        p.setMainView(Proz.this.topui);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void showAnswerQuestionForm(final String[] term) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ Proz this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    if (AppPreferences.isJavaFXReady()) {
                        ProzAnswerQuestionView p = new ProzAnswerQuestionView(this.this$0, term);
                        p.setMainView(this.this$0.topui);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void showAnswerNotification() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!Proz.this.answerNotification) {
                    Proz.this.answerNotification = true;
                    JOptionPane.showMessageDialog(Proz.this.mainPanel, "Your KudoZ question has been answered.");
                    Proz.this.answerNotification = false;
                }
            }
        });
    }

    public void activateWiwo() {
        ActionListener taskPerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (runWiwoTimer) {
                    Proz.this.showWiwos(null, null);
                }
            }
        };
        int hideDelaySeconds = 1800;
        Timer timer = new Timer(1800000, taskPerformer);
        timer.setRepeats(false);
        timer.start();
    }

    class ProzMediaUploadHTTP
    implements PropertyChangeListener {
        JProgressBar progressBar;
        String request;
        FileUploadTask task;

        ProzMediaUploadHTTP(File uploadFile, String request) {
            this.request = request;
            try {
                this.progressBar = Proz.this.topui.getPretranslateProgressBar();
                this.progressBar.setStringPainted(true);
                this.progressBar.setMinimum(0);
                this.progressBar.setMaximum(100);
                this.progressBar.setValue(0);
                this.task = new FileUploadTask(Proz.this.mediaURL, uploadFile.getName(), uploadFile, "media", null, AppPreferences.prozToken, true);
                this.task.addPropertyChangeListener(this);
                this.task.execute();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Proz.this.topui, "Error executing upload task: " + ex.getMessage(), "Error", 0);
            }
        }

        void sendWiwo() {
            String response;
            if (this.task != null && (response = this.task.getResponse()) != null) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    int id = jsonObject.getInt("media_id");
                    StringBuilder sb = new StringBuilder(this.request);
                    sb.append("\"image_media_id\": ");
                    sb.append(id);
                    sb.append("}");
                    Proz.this.sendWIWOMessage(sb.toString());
                }
                catch (JSONException ex) {
                    Logger.getLogger(Proz.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("progress" == evt.getPropertyName()) {
                int progress = (Integer)evt.getNewValue();
                this.progressBar.setValue(progress);
                if (progress >= 100) {
                    Proz.this.topui.removePretranslateProgressBar(this.progressBar);
                    this.sendWiwo();
                }
            }
        }
    }

    class ProzHyperactive
    implements HyperlinkListener {
        ProzHyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String s = e.getDescription();
                if (s.equals(authorizationRequest)) {
                    ProzLinking = true;
                    String name = "ProZ.com - Authorization";
                    Proz.this.topui.getResourceLoader().prepareWebResource(s, name, false, false, -1);
                } else if (s.equals(Proz.this.searchTerms)) {
                    Proz.this.searchTerms(null, Proz.this.arrayResources, 0, false);
                } else if (s.equals(Proz.this.userDetails)) {
                    Proz.this.getUser(false);
                } else if (s.equals(Proz.this.askQuestion)) {
                    Proz.this.showAskQuestionForm();
                } else if (s.equals(Proz.this.wiwo)) {
                    Proz.this.showWiwos(null, null);
                } else if (s.startsWith(Proz.this.answerQuestion)) {
                    int j;
                    int i = s.indexOf("=");
                    if (i != -1 && (j = s.indexOf(":")) != -1) {
                        String id = s.substring(i + 1, j);
                        int k = s.indexOf(":", j + 1);
                        if (k != -1) {
                            String lang = s.substring(j + 1, k);
                            String term = s.substring(k + 1);
                            String[] arr = new String[]{id, lang, term};
                            Proz.this.showAnswerQuestionForm(arr);
                        }
                    }
                } else if (s.equals(Proz.this.questions)) {
                    Proz.this.questionsPage = 1;
                    Proz.this.getQuestions();
                } else if (s.equals("questionsNext")) {
                    Proz.this.questionsPage++;
                    Proz.this.getQuestions();
                } else if (s.equals("questionsPrevious")) {
                    Proz.this.questionsPage--;
                    Proz.this.getQuestions();
                } else if (s.equals("questionsPrefs")) {
                    Proz.this.showQuestionPrefsForm();
                } else if (s.startsWith("next") || s.startsWith("previous")) {
                    String[] arr = s.split(" ");
                    if (Proz.this.currentTerm != null) {
                        String[] rarr = new String[]{arr[2]};
                        String ps = arr[1];
                        int i = Integer.valueOf(ps);
                        Proz.this.searchTerms(Proz.this.currentTerm, rarr, i, false);
                    }
                } else if (s.startsWith("http")) {
                    try {
                        URI uri = new URI(s);
                        Proz.this.topui.getResourceView();
                        ResourceView.browse(uri);
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(XMLElementEditor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    class RefreshQuestionsTask
    extends TimerTask {
        RefreshQuestionsTask() {
        }

        @Override
        public void run() {
            if (Proz.this.refreshTokenTrials > 3) {
                Proz.this.showLinkInMessage();
                this.cancel();
                return;
            }
            Proz.this.getQuestionsAPI();
            if (Proz.this.newTranslations > 0) {
                Proz.this.newTranslations = 0;
                Proz.this.showAnswerNotification();
            }
        }
    }

    static class DefaultTrustManager
    implements X509TrustManager {
        DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

