/*
 * Decompiled with CFR 0.152.
 */
package translator.web;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import translator.AppPreferences;
import translator.MainView;
import translator.browser.Browser;
import translator.browser.WebPane;
import translator.json.JSONObject;
import translator.web.Proz;

public class ProzAnswerQuestionView
extends JFrame {
    private MainView topui;
    private WebPane webPane;
    private String html;
    private Proz proz;
    private String id;
    private String targetLanguage;
    private String sourceTerm;

    public ProzAnswerQuestionView(Proz proz, String[] record) {
        this.proz = proz;
        this.id = record[0];
        this.targetLanguage = record[1];
        this.sourceTerm = record[2];
        String peerComments = AppPreferences.prozKudozAnswerQuestionPeerComments ? " checked=\"\" " : "";
        this.html = "<html><head></head><body bgcolor=\"#EEEEEE\"><table valign=\"middle\" align=\"center\" class=\"standard\" id=\"answer_form\" cellpadding=\"5\" cellspacing=\"1\" style=\"border: 1px solid #00BCD4; font-family: verdana,arial,helvetica,sans-serif; font-size:14px\" rules=\"all\" width=\"90%\"><tbody><form method=\"post\" name=\"kudoz_form\"></form><tr><td align=\"center\"><a href=\"javascript:createInfoWindow('kudoz_edited_source_term', '1');\"><img src=\"http://cdn1.proz.com/images/pftv6/info.gif\" border=\"0\" alt=\"You may enter your own version of the source term\" title=\"You may enter your own version of the source term\"></a> Source term:</td><td> <input type=\"text\" name=\"source_term\" style=\"font-size:12pt;\" size=\"70\" maxlength=\"160\" onkeydown=\"textCounter(this.form.source_term,this.form.inputlength_source,100);\" onkeyup=\"textCounter(this.form.source_term,this.form.inputlength_source,100);\" value=\"" + this.sourceTerm + "\"></td></tr><tr><td width=\"300\" align=\"center\">Target term (required):</td><td><input type=\"text\" style=\"font-size:12pt;\" name=\"answer_term\" id=\"answer_term\" size=\"70\" maxlength=\"160\" value=\"\"></td></tr><tr><td width=\"300\" align=\"center\"><a href=\"javascript:createInfoWindow('kudoz_confidence_own', '1');\"><img src=\"http://cdn1.proz.com/images/pftv6/info.gif\" border=\"0\" alt=\"How sure are you of your answer?\" title=\"How sure are you of your answer?\"></a> Your confidence level (required):</td><td><select name=\"fields[reply_confidence]\" id=\"reply_confidence\"><option value=\"\">Please select</option><option value=\"5\"> Highest - I am sure</option><option value=\"4\"> High</option><option value=\"3\"> Medium</option><option value=\"2\"> Low</option><option value=\"1\"> Lowest - I am guessing</option></select></td></tr><tr><td width=\"300\" align=\"center\">Explanation (required):</td><td><textarea autofocus name=\"fields[answer_explanation]\" id=\"answer_explanation\" style=\"font-size:12pt;\" cols=\"70\" rows=\"6\" wrap=\"virtual\"></textarea></td></tr><tr><td align=\"center\">Example sentence(s):</td><td><input type=\"text\" name=\"fields[example_sent1]\" id=\"answer_example1\" size=\"70\" value=\"\" maxlength=\"255\"><br><input type=\"text\" name=\"fields[example_sent2]\" id=\"answer_example2\" size=\"70\" value=\"\" maxlength=\"255\"><br></td></tr><tr><td align=\"center\"><a href=\"javascript:createInfoWindow('kudoz_references', '1');\"><img src=\"http://cdn1.proz.com/images/pftv6/info.gif\" border=\"0\" alt=\"Valid references\" title=\"Valid references\"></a> Web references:</td><td><input type=\"text\" name=\"fields[reference_link1]\" id=\"reference_link1\" size=\"70\" value=\"\"> <br><input type=\"text\" name=\"fields[reference_link2]\" id=\"reference_link2\" size=\"70\" value=\"\"></td></tr><tr><td align=\"center\">Other options:</td><td><input type=\"checkbox\"" + peerComments + "name=\"notify_peer_grade\" value=\"y\"> Notify me of peer comments</td></tr><tr><td bgcolor=\"#00BCD4\" align=\"center\" colspan=\"2\"><input type=\"submit\" style=\"width:150px\" id=\"submit_answer\" value=\"Submit answer\"><br></td></tr>    </tbody></table>";
    }

    public void setMainView(MainView topui) {
        this.topui = topui;
        this.createView();
        this.showAnswerForm();
    }

    private void showAnswerForm() {
        this.webPane.getBrowser().loadHTML(this.html);
    }

    private void createView() {
        this.webPane = new WebPane(new Browser(true));
        this.webPane.getBrowser().getEngine().documentProperty().addListener((ChangeListener)new ChangeListener<Document>(){

            public void changed(ObservableValue<? extends Document> ov, Document oldValue, Document newValue) {
                if (null != newValue) {
                    ProzAnswerQuestionView.this.setOKAction();
                }
            }
        });
        this.setTitle("Answer a KudoZ question");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.webPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        Dimension frmSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(1100, 520);
        Dimension dlgSize = this.getSize();
        Point loc = this.topui.getLocationOnScreen();
        this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        this.setVisible(true);
    }

    protected BufferedReader getBufferedReader(URL page, String post) throws IOException {
        String enc;
        URLConnection conn = page.openConnection();
        conn.setRequestProperty("User-Agent", "Mozilla 5.0");
        conn.setDoOutput(true);
        if (post != null) {
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            out.write(post);
            out.close();
        }
        if (conn instanceof HttpURLConnection) {
            boolean redirect;
            HttpURLConnection hconn = (HttpURLConnection)conn;
            hconn.setInstanceFollowRedirects(false);
            int response = hconn.getResponseCode();
            boolean bl = redirect = response >= 300 && response <= 399;
            if (redirect) {
                String loc = conn.getHeaderField("Location");
                page = loc.startsWith("http", 0) ? new URL(loc) : new URL(page, loc);
                return this.getBufferedReader(page, post);
            }
        }
        if ((enc = conn.getContentEncoding()) == null) {
            enc = "UTF-8";
        }
        InputStream in = conn.getInputStream();
        BufferedReader r = new BufferedReader(new InputStreamReader(in, enc));
        return r;
    }

    private void setOKAction() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EventListener listener = new EventListener(){

                    @Override
                    public void handleEvent(Event evt) {
                        int i;
                        String answerTerm = "";
                        String confidence = "";
                        String example1 = "";
                        String example2 = "";
                        String reference1 = "";
                        String reference2 = "";
                        Document doc = ProzAnswerQuestionView.this.webPane.getBrowser().getEngine().getDocument();
                        NodeList els = doc.getElementsByTagName("select");
                        for (i = 0; i < els.getLength(); ++i) {
                            String v = (String)ProzAnswerQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('select')[" + i + "].value");
                            String n = (String)ProzAnswerQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('select')[" + i + "].name");
                            if (!n.equals("fields[reply_confidence]")) continue;
                            confidence = v;
                        }
                        els = doc.getElementsByTagName("input");
                        for (i = 0; i < els.getLength(); ++i) {
                            Element elem = (Element)els.item(i);
                            String s = elem.getAttribute("type");
                            if (s.equals("checkbox")) {
                                Boolean c = (Boolean)ProzAnswerQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].checked");
                                String name = (String)ProzAnswerQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].name");
                                if (!name.equals("notify_peer_grade") || !c.booleanValue()) continue;
                                String v = (String)ProzAnswerQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].value");
                                if (v.equals("y")) {
                                    AppPreferences.prozKudozAnswerQuestionPeerComments = true;
                                    continue;
                                }
                                AppPreferences.prozKudozAnswerQuestionPeerComments = false;
                                continue;
                            }
                            if (!s.equals("text")) continue;
                            String v = (String)ProzAnswerQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].value");
                            String n = (String)ProzAnswerQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].name");
                            if (n.equals("source_term")) continue;
                            if (n.equals("answer_term")) {
                                answerTerm = v;
                                continue;
                            }
                            if (n.equals("fields[example_sent1]")) {
                                example1 = v;
                                continue;
                            }
                            if (n.equals("fields[example_sent2]")) {
                                example2 = v;
                                continue;
                            }
                            if (n.equals("fields[reference_link1]")) {
                                reference1 = v;
                                continue;
                            }
                            if (!n.equals("fields[reference_link2]")) continue;
                            reference2 = v;
                        }
                        String explanation = (String)ProzAnswerQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementById('answer_explanation').value");
                        if (ProzAnswerQuestionView.this.sourceTerm == null || ProzAnswerQuestionView.this.sourceTerm.trim().length() == 0 || answerTerm.trim().length() == 0 || explanation.trim().length() == 0 || confidence.trim().length() == 0) {
                            Alert alert = new Alert(Alert.AlertType.INFORMATION, "Please provide the required information.", new ButtonType[0]);
                            Optional result = alert.showAndWait();
                            return;
                        }
                        StringBuilder request = new StringBuilder();
                        request.append("{");
                        request.append("\"confidence\": ");
                        request.append(confidence);
                        request.append(", ");
                        request.append("\"translated_term\": ");
                        answerTerm = JSONObject.quote(answerTerm);
                        request.append(answerTerm);
                        request.append(", ");
                        request.append("\"language\": ");
                        request.append("\"");
                        request.append(ProzAnswerQuestionView.this.targetLanguage);
                        request.append("\", ");
                        request.append("\"explanation\": ");
                        explanation = JSONObject.quote(explanation);
                        request.append(explanation);
                        request.append(", ");
                        if (reference1.length() > 0 || reference2.length() > 0) {
                            request.append("\"reference_urls\": [");
                            if (reference1.length() > 0) {
                                if (reference1.startsWith("www")) {
                                    reference1 = "http://" + reference1;
                                }
                                reference1 = JSONObject.quote(reference1);
                                request.append(reference1);
                                if (reference2.length() > 0) {
                                    request.append(",");
                                }
                            }
                            if (reference2.length() > 0) {
                                if (reference2.startsWith("www")) {
                                    reference2 = "http://" + reference2;
                                }
                                reference2 = JSONObject.quote(reference2);
                                request.append(reference2);
                            }
                            request.append("], ");
                        }
                        if (example1.length() > 0 || example1.length() > 0) {
                            request.append("\"example_sentences\": [");
                            if (example1.length() > 0) {
                                example1 = JSONObject.quote(example1);
                                request.append(example1);
                                if (example2.length() > 0) {
                                    request.append(",");
                                }
                            }
                            if (example2.length() > 0) {
                                example2 = JSONObject.quote(example2);
                                request.append(example2);
                            }
                            request.append("], ");
                        }
                        request.append("\"definition\": null");
                        request.append(", ");
                        request.append("\"notify_of_peer_review\": ");
                        if (AppPreferences.prozKudozAnswerQuestionPeerComments) {
                            request.append("true");
                        } else {
                            request.append("false");
                        }
                        request.append("}");
                        final String s = request.toString();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            public void run() {
                                this.this$2.ProzAnswerQuestionView.this.proz.answerKudoZQuestion(s, this.this$2.ProzAnswerQuestionView.this.id);
                                this.this$2.ProzAnswerQuestionView.this.closeFrame();
                            }
                        });
                    }
                };
                Document doc = ProzAnswerQuestionView.this.webPane.getBrowser().getEngine().getDocument();
                Element el = doc.getElementById("submit_answer");
                ((EventTarget)((Object)el)).addEventListener("click", listener, false);
            }
        });
    }

    private void closeFrame() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }
}

