/*
 * Decompiled with CFR 0.152.
 */
package translator.web;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import translator.AppPreferences;
import translator.EULAView;
import translator.web.TMTown;
import translator.web.TMTownRepositories;

public class TMTownRepositoriesView
extends JPanel {
    private JScrollPane masterScrollPane;
    private JTable masterTable;
    private BindingGroup bindingGroup;
    private static List<TMTownRepositories> documents;
    private TMTown tmTown;
    private JButton downloadButton;

    public TMTownRepositoriesView(TMTown tmTown) {
        ArrayList list = new ArrayList();
        documents = ObservableCollections.observableList(list);
        this.tmTown = tmTown;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 0));
        this.masterScrollPane = new JScrollPane();
        this.masterScrollPane.setOpaque(false);
        this.masterScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.masterScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            this.masterScrollPane.getViewport().setOpaque(false);
        }
        this.masterTable = new JTable();
        this.masterTable.setRowHeight(20);
        Font font = this.masterTable.getFont();
        int size = font.getSize();
        if (size < 12) {
            font = font.deriveFont(12.0f);
        }
        this.masterTable.setFont(font);
        this.bindingGroup = new BindingGroup();
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, documents, (JTable)this.masterTable);
        String s = "name";
        String column = "Name";
        JTableBinding.ColumnBinding columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
        columnBinding.setColumnName(column);
        columnBinding.setColumnClass(String.class);
        s = "author";
        column = "Author";
        columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
        columnBinding.setColumnName(column);
        columnBinding.setColumnClass(String.class);
        s = "sourceLanguage";
        column = "Source Language";
        columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
        columnBinding.setColumnName(column);
        columnBinding.setColumnClass(String.class);
        s = "targetLanguage";
        column = "Target Language";
        columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
        columnBinding.setColumnName(column);
        columnBinding.setColumnClass(String.class);
        s = "downloads";
        column = "Downloads";
        columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
        columnBinding.setColumnName(column);
        columnBinding.setColumnClass(String.class);
        this.bindingGroup.addBinding((Binding)jTableBinding);
        jTableBinding.bind();
        this.masterTable.getColumnModel().getColumn(4).setPreferredWidth(80);
        this.masterTable.getColumnModel().getColumn(4).setMaxWidth(100);
        JLabel label = new JLabel("Download:");
        label.setForeground(new Color(AppPreferences.tforeground2));
        label.setOpaque(false);
        this.downloadButton = new JButton();
        this.downloadButton.setPreferredSize(new Dimension(200, 28));
        this.downloadButton.setMaximumSize(new Dimension(200, 28));
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String link;
                String name;
                String s = e.getActionCommand();
                TMTownRepositories next = null;
                Iterator iterator = documents.iterator();
                while (iterator.hasNext() && !s.equals(name = (next = (TMTownRepositories)iterator.next()).getName())) {
                }
                if (next != null && (link = next.getDownloadLink()) != null) {
                    TMTownRepositoriesView.this.tmTown.downloadGlossary(link, s);
                }
            }
        });
        JButton licenseButton = new JButton("View License");
        licenseButton.setPreferredSize(new Dimension(200, 28));
        licenseButton.setMaximumSize(new Dimension(200, 28));
        licenseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String lic;
                String name;
                String s = TMTownRepositoriesView.this.downloadButton.getActionCommand();
                TMTownRepositories next = null;
                Iterator iterator = documents.iterator();
                while (iterator.hasNext() && !s.equals(name = (next = (TMTownRepositories)iterator.next()).getName())) {
                }
                if (next != null && (lic = next.getLicense()) != null) {
                    new EULAView(lic);
                }
            }
        });
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.masterTable, (Property)ELProperty.create((String)"${selectedElement.name}"), (Object)this.downloadButton, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        binding.bind();
        this.masterScrollPane.setViewportView(this.masterTable);
        this.add((Component)this.masterScrollPane, "Center");
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.add(label);
        panel.add(this.downloadButton);
        panel.add(licenseButton);
        this.add((Component)panel, "South");
    }

    public void addRespository(TMTownRepositories doc) {
        documents.add(doc);
    }

    public static List getRepositories() {
        return documents;
    }

    public JTable getTable() {
        return this.masterTable;
    }
}

