/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import translator.DefaultXMLElement;
import translator.Project;
import translator.XMLElement;
import translator.xliff.BinaryUnit;
import translator.xliff.Group;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;

public class FileBody
extends DefaultXMLElement {
    private Group currentGroup;
    private BinaryUnit currentBU;
    private XLIFFUnit currentTU;
    private XLIFFUnit lastTU;
    private List tunits = new ArrayList(500);
    private List bunits = new ArrayList();
    private int reviewTUIndex = -1;
    private List lockedSDLElements;
    public int unitNumber = 0;
    public int lockedID = 1;
    private Pattern segPattern;
    private int mid = 0;
    private boolean SDLSegmentationError;
    private XLIFFUnit loadedTU;

    public FileBody() {
        String seg = "\\A\\t+|\\.\\s+|\\!\\s+|\\?\\s+|\\:\\s+|\u3002|\uff01|\uff1f";
        this.segPattern = Pattern.compile(seg);
    }

    public void setReviewTUIndex(int i) {
        this.reviewTUIndex = i;
    }

    public int getReviewTUIndex() {
        return this.reviewTUIndex;
    }

    @Override
    public void addChild(Object o) {
        if (o instanceof XMLElement) {
            XMLElement xml = (XMLElement)o;
            String name = xml.getName();
            if (name.equals("trans-unit")) {
                XLIFFUnit elem = (XLIFFUnit)xml;
                super.addChild(xml);
                this.currentTU = elem;
            } else if (name.equals("bin-unit")) {
                BinaryUnit elem = (BinaryUnit)xml;
                this.addXliffBU(elem);
            } else if (name.equals("group")) {
                this.addGroup(xml);
            } else {
                super.addChild(xml);
            }
        }
    }

    public void addSDLLockedElement(XMLElement element) {
        if (this.lockedSDLElements == null) {
            this.lockedSDLElements = new ArrayList();
        }
        element.setAttribute("id", "locked" + Integer.toString(this.lockedID));
        this.lockedSDLElements.add(element);
        ++this.lockedID;
    }

    XMLElement[] createSDLLockedElement(Collection col) {
        int len = col.size();
        XMLElement[] xelems = new XMLElement[len];
        int index = 0;
        for (XMLElement selement : col) {
            String xid = selement.getAttribute("xid");
            XLIFFUnit soureLockedTU = null;
            int sourceLockedTUIndex = -1;
            int i = 0;
            Group group = null;
            block1: for (Object o : this.getChildren()) {
                if (o instanceof XLIFFUnit) {
                    XLIFFUnit tu = (XLIFFUnit)o;
                    String tuID = tu.getAttribute("id");
                    if (tuID != null && tuID.equals(xid)) {
                        soureLockedTU = tu;
                        sourceLockedTUIndex = i;
                        break;
                    }
                } else if (o instanceof Group) {
                    int j = 0;
                    Group gr = (Group)o;
                    for (Object o2 : gr.getChildren()) {
                        XLIFFUnit tu;
                        String tuID;
                        if (o2 instanceof XLIFFUnit && (tuID = (tu = (XLIFFUnit)o2).getAttribute("id")) != null && tuID.equals(xid)) {
                            soureLockedTU = tu;
                            sourceLockedTUIndex = j;
                            group = gr;
                            break block1;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (soureLockedTU == null) continue;
            String uuid = UUID.randomUUID().toString();
            DefaultXMLElement newElement = new DefaultXMLElement();
            newElement.setName("x");
            this.addSDLLockedElement(newElement);
            String xid2 = "lockTU_" + uuid;
            newElement.setAttribute("xid", xid2);
            xelems[index] = newElement;
            ++index;
            int uid = soureLockedTU.getUnitID();
            int uno = soureLockedTU.getUnitNumber();
            XLIFFUnit newTU = new XLIFFUnit(soureLockedTU.getProjectID(), soureLockedTU.getFileID(), uid, 1);
            newTU.setUnitNumber(uno);
            newTU.setName("trans-unit");
            newTU.setSource(soureLockedTU.getSource());
            LinkedHashMap attr = soureLockedTU.getAttributes();
            for (Map.Entry entry : attr.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                newTU.setAttribute(key, val);
            }
            newTU.setAttribute("id", xid2);
            XLIFFUnit.lockedTUs.put(xid2, newTU);
            if (group != null) {
                group.getChildren().add(sourceLockedTUIndex, newTU);
                continue;
            }
            this.getChildren().add(sourceLockedTUIndex, newTU);
        }
        return xelems;
    }

    public void updateLockedIDs() {
        int i = 0;
        for (XMLElement x : this.lockedSDLElements) {
            if (i == 0) {
                String id = x.getAttribute("id");
                if (id != null && id.length() > 5) {
                    String lockNo = id.substring(6);
                    i = Integer.parseInt(lockNo);
                }
            } else {
                x.setAttribute("id", "locked" + Integer.toString(i));
            }
            ++i;
        }
    }

    public void addGroup(XMLElement group) {
        super.addChild(group);
        this.currentGroup = (Group)group;
        this.currentBU = null;
    }

    public Group getCurrentGroup() {
        return this.currentGroup;
    }

    public void setCurrentGroup(Group group) {
        this.currentGroup = group;
        this.currentBU = null;
        this.currentTU = null;
    }

    public void addXliffBU(BinaryUnit bunit) {
        super.addChild(bunit);
        this.bunits.add(bunit);
        this.currentBU = bunit;
    }

    public void addBinaryUnit(BinaryUnit bunit) {
        if (this.currentGroup != null) {
            this.currentGroup.addBinaryUnit(bunit);
        } else {
            super.addChild(bunit);
        }
        this.bunits.add(bunit);
        this.currentBU = bunit;
    }

    public void setCurrentBU(BinaryUnit bu) {
        this.currentBU = bu;
    }

    public BinaryUnit getCurrentBU() {
        return this.currentBU;
    }

    public void setCurrentTU(XLIFFUnit tu) {
        this.currentTU = tu;
    }

    public XLIFFUnit getCurrentTU() {
        int count;
        if (this.currentTU == null && (count = this.getTUCount()) > 0) {
            this.currentTU = (XLIFFUnit)this.getTransUnits().get(count - 1);
        }
        return this.currentTU;
    }

    public XLIFFUnit getlastTU() {
        return this.lastTU;
    }

    public void resetLastTU() {
        if (this.lastTU != null) {
            this.setCurrentTU(this.lastTU);
        }
    }

    public List getBinaryUnits() {
        if (this.currentGroup != null) {
            return this.currentGroup.getBinaryUnits();
        }
        return this.bunits;
    }

    public int getTUCount() {
        return this.tunits.size();
    }

    public int getBUCount() {
        return this.bunits.size();
    }

    private void extractSDLSegments(XMLElement elem, List list) {
        List ch = elem.getChildren();
        for (int i = 0; i < ch.size(); ++i) {
            Object object = ch.get(i);
            if (!(object instanceof XMLElement)) continue;
            XMLElement xelem = (XMLElement)object;
            if (xelem.getName().equals("mrk")) {
                String attr = xelem.getAttribute("mtype");
                if (attr == null || !attr.equals("seg")) continue;
                list.add(xelem);
                continue;
            }
            this.extractSDLSegments(xelem, list);
        }
    }

    private void createSDLEmptySegments(List targetElements, List targetSegMarks) {
        for (int i = 0; i < targetElements.size(); ++i) {
            Object object = targetElements.get(i);
            if (!(object instanceof XMLElement)) continue;
            XMLElement m = (XMLElement)object;
            String attr = m.getAttribute("mtype");
            if (attr != null && attr.equals("seg")) {
                DefaultXMLElement tmark = new DefaultXMLElement();
                tmark.setName(m.getName());
                LinkedHashMap amap = m.getAttributes();
                Set keys = amap.keySet();
                for (String key : keys) {
                    String value = (String)amap.get(key);
                    tmark.setAttribute(key, value);
                }
                targetElements.set(i, tmark);
                targetSegMarks.add(tmark);
                continue;
            }
            List targetElem = m.getChildren();
            if (targetElem.isEmpty()) continue;
            this.createSDLEmptySegments(targetElem, targetSegMarks);
        }
    }

    private void copySDLSourceToTarget(XMLElement source, XMLElement target) {
        List sourceElements = source.getChildren();
        for (int i = 0; i < sourceElements.size(); ++i) {
            Object object = sourceElements.get(i);
            if (object instanceof XMLElement) {
                XMLElement sx = (XMLElement)object;
                DefaultXMLElement tx = new DefaultXMLElement();
                tx.setName(sx.getName());
                LinkedHashMap amap = sx.getAttributes();
                Set keys = amap.keySet();
                for (String key : keys) {
                    String value = (String)amap.get(key);
                    tx.setAttribute(key, value);
                }
                target.addChild(tx);
                this.copySDLSourceToTarget(sx, tx);
                continue;
            }
            target.addChild(object);
        }
    }

    private void createSegmentDefElement(String id, String hashedString, XMLElement segDefsElement) {
        DefaultXMLElement segElement = new DefaultXMLElement();
        segElement.setName("sdl:seg");
        segElement.setAttribute("id", id);
        segElement.setAttribute("conf", "Translated");
        segDefsElement.addChild(segElement);
        DefaultXMLElement segValueElement = new DefaultXMLElement();
        segValueElement.setName("sdl:value");
        String hash = this.hashSDLString(hashedString);
        segValueElement.setAttribute("key", "SegmentIdentityHash");
        segValueElement.setContent(0, hash);
        segElement.addChild(segValueElement);
    }

    private XMLElement createMarkElement() {
        ++this.mid;
        DefaultXMLElement mrkElement = new DefaultXMLElement();
        mrkElement.setName("mrk");
        mrkElement.setAttribute("mtype", "seg");
        String id = Integer.toString(this.mid);
        mrkElement.setAttribute("mid", id);
        return mrkElement;
    }

    private String getStringContent(XMLElement e) {
        StringBuffer sb = new StringBuffer();
        List elems = e.getChildren();
        for (Object o : elems) {
            if (o instanceof String) {
                sb.append(o.toString());
                continue;
            }
            XMLElement elem = (XMLElement)o;
            String s = this.getStringContent(elem);
            sb.append(s);
        }
        return sb.toString();
    }

    private void segmentSDLTagContent(XMLElement source, XMLElement parentMrk, XMLElement segDefsElement, boolean startTag) {
        XMLElement mrkElement;
        DefaultXMLElement mainElement = new DefaultXMLElement();
        if (parentMrk != null) {
            mrkElement = parentMrk;
        } else if (startTag) {
            mrkElement = this.createMarkElement();
            mainElement.addChild(mrkElement);
        } else {
            mrkElement = null;
        }
        List elems = source.getChildren();
        for (Object next : elems) {
            if (next instanceof XMLElement) {
                XMLElement e = (XMLElement)next;
                String n = e.getName();
                if (n.equals("g")) {
                    if (mrkElement != null) {
                        mrkElement.addChild(next);
                    } else {
                        mainElement.addChild(next);
                    }
                    this.segmentSDLTagContent(e, mrkElement, segDefsElement, false);
                    continue;
                }
                if (mrkElement != null) {
                    mrkElement.addChild(next);
                    continue;
                }
                mainElement.addChild(next);
                continue;
            }
            String string = (String)next;
            Matcher m = this.segPattern.matcher(string);
            int from = 0;
            while (m.find()) {
                int start = m.start();
                int end = m.end();
                if (start == 0) {
                    String g = m.group();
                    mainElement.addChild(g);
                    from = end;
                    continue;
                }
                if (start < end) {
                    ++start;
                }
                if (mrkElement == null) {
                    mrkElement = this.createMarkElement();
                    mainElement.addChild(mrkElement);
                }
                String sub = string.substring(from, start);
                mrkElement.addChild(sub);
                if (start < end) {
                    String space = string.substring(start, end);
                    mainElement.addChild(space);
                }
                from = end;
                mrkElement = null;
            }
            if (from >= string.length()) continue;
            if (mrkElement == null) {
                mrkElement = this.createMarkElement();
                mainElement.addChild(mrkElement);
            }
            String sub = string.substring(from);
            mrkElement.addChild(sub);
        }
        source.getChildren().clear();
        this.copySDLSourceToTarget(mainElement, source);
        List selems = source.getChildren("mrk");
        for (Object o : selems) {
            XMLElement e;
            String type;
            if (!(o instanceof XMLElement) || (type = (e = (XMLElement)o).getAttribute("mtype")) == null || !type.equals("seg")) continue;
            String id = e.getAttribute("mid");
            String content = this.getStringContent(e);
            this.createSegmentDefElement(id, content, segDefsElement);
        }
    }

    private void createSLDSegmentStructure2(XLIFFUnit unit) {
        XMLElement e;
        String n;
        Object o;
        DefaultXMLElement segDefsElement = new DefaultXMLElement();
        segDefsElement.setName("sdl:seg-defs");
        unit.addChild(segDefsElement);
        XMLElement source = unit.getSource();
        int s = source.getChildren().size();
        if (s == 1 && (o = source.getContent(0)) != null && o instanceof XMLElement && (n = (e = (XMLElement)o).getName()).equals("g")) {
            source = e;
        }
        this.segmentSDLTagContent(source, null, segDefsElement, true);
    }

    private void createSLDSegmentStructure(XLIFFUnit unit) {
        XMLElement e;
        String n;
        Object o;
        ++this.mid;
        XMLElement source = unit.getSource();
        int s = source.getChildren().size();
        if (s == 1 && (o = source.getContent(0)) != null && o instanceof XMLElement && (n = (e = (XMLElement)o).getName()).equals("g")) {
            source = e;
        }
        DefaultXMLElement mrkElement = new DefaultXMLElement();
        mrkElement.setName("mrk");
        mrkElement.setAttribute("mtype", "seg");
        String id = Integer.toString(this.mid);
        mrkElement.setAttribute("mid", id);
        this.copySDLSourceToTarget(source, mrkElement);
        source.getChildren().clear();
        source.addChild(mrkElement);
        DefaultXMLElement segDefsElement = new DefaultXMLElement();
        segDefsElement.setName("sdl:seg-defs");
        unit.addChild(segDefsElement);
        DefaultXMLElement segElement = new DefaultXMLElement();
        segElement.setName("sdl:seg");
        segElement.setAttribute("id", id);
        segElement.setAttribute("conf", "Translated");
        segDefsElement.addChild(segElement);
        DefaultXMLElement segValueElement = new DefaultXMLElement();
        segValueElement.setName("sdl:value");
        String hash = this.hashSDLString(source.getXMLFormat());
        segValueElement.setAttribute("key", "SegmentIdentityHash");
        segValueElement.setContent(0, hash);
        segElement.addChild(segValueElement);
    }

    private String hashSDLString(String org) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashbytes = digest.digest(org.getBytes(StandardCharsets.UTF_8));
            String encodedString = Base64.getEncoder().encodeToString(hashbytes);
            return encodedString;
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(FileBody.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private void fetchSDLComments(XMLElement e, List comments) {
        List childern = e.getChildren();
        for (Object next : childern) {
            if (!(next instanceof XMLElement)) continue;
            XMLElement elem = (XMLElement)next;
            String name = elem.getName();
            if (name.equals("mrk")) {
                String type = elem.getAttribute("mtype");
                if (type != null && type.equals("x-sdl-comment")) {
                    List comms;
                    String id = elem.getAttribute("sdl:cid");
                    if (id == null || (comms = (List)XLIFF.sdlCommentsMap.get(id)) == null) continue;
                    for (XMLElement next1 : comms) {
                        List comment = next1.getChildren("Comment");
                        for (Object next2 : comment) {
                            comments.add(next2);
                        }
                    }
                    continue;
                }
                this.fetchSDLComments(elem, comments);
                continue;
            }
            this.fetchSDLComments(elem, comments);
        }
    }

    public void addSDLXliffTU(XLIFF xliff, XLIFFUnit tunit) {
        XMLElement source = tunit.getSource();
        XMLElement target = tunit.getTarget();
        if (target != null) {
            ArrayList sourceSegMarks = new ArrayList();
            ArrayList targetSegMarks = new ArrayList();
            this.extractSDLSegments(source, sourceSegMarks);
            this.extractSDLSegments(target, targetSegMarks);
            if (sourceSegMarks.size() > 0) {
                String s;
                Project.hasSDLSourceSegments = true;
                if (sourceSegMarks.size() != targetSegMarks.size() && (s = tunit.getTargetText().trim()).length() == 0) {
                    target.getChildren().clear();
                    targetSegMarks.clear();
                    this.copySDLSourceToTarget(source, target);
                    this.createSDLEmptySegments(target.getChildren(), targetSegMarks);
                }
                if (sourceSegMarks.size() == targetSegMarks.size()) {
                    List sdlsegs = null;
                    List sdlsegsdefs = tunit.getChildren("sdl:seg-defs");
                    if (sdlsegsdefs != null) {
                        for (int k = 0; k < sdlsegsdefs.size(); ++k) {
                            Object object1 = sdlsegsdefs.get(k);
                            if (!(object1 instanceof XMLElement)) continue;
                            XMLElement xmle = (XMLElement)object1;
                            sdlsegs = xmle.getChildren("sdl:seg");
                        }
                    }
                    for (int i = 0; i < sourceSegMarks.size(); ++i) {
                        String con;
                        XMLElement ms = (XMLElement)sourceSegMarks.get(i);
                        XLIFFUnit tu = new XLIFFUnit(tunit.getProjectID(), tunit.getFileID(), -1, 1);
                        tu.setName("trans-unit");
                        tu.setParentTU(tunit);
                        String mid = ms.getAttribute("mid");
                        if (mid != null && sdlsegs != null) {
                            for (int l = 0; l < sdlsegs.size(); ++l) {
                                String origin;
                                String a;
                                String p;
                                XMLElement xmle2;
                                String id;
                                Object object2 = sdlsegs.get(l);
                                if (!(object2 instanceof XMLElement) || (id = (xmle2 = (XMLElement)object2).getAttribute("id")) == null || !mid.equals(id)) continue;
                                String s2 = xmle2.getAttribute("locked");
                                if (s2 != null && s2.equals("true")) {
                                    tu.locked = true;
                                }
                                if ((p = xmle2.getAttribute("percent")) != null) {
                                    tu.percent = p + "%";
                                    if (tu.percent.equals("100%")) {
                                        tu.setMatch(100, 1, false);
                                    }
                                }
                                if ((a = xmle2.getAttribute("conf")) != null) {
                                    if (a.equals("Translated")) {
                                        tu.setState(1);
                                    } else if (a.equals("ApprovedTranslation")) {
                                        tu.setState(2);
                                    } else if (a.equals("RejectedTranslation")) {
                                        tu.setState(3);
                                    }
                                }
                                if ((origin = xmle2.getAttribute("origin")) != null && (origin.equals("mt") || origin.equals("nmt") || origin.equals("amt"))) {
                                    tu.setMatch(-1, 4, false);
                                }
                                tu.setSDLSegment(xmle2);
                                break;
                            }
                        }
                        if (mid != null) {
                            tu.setSDLSegmentID(mid);
                        }
                        DefaultXMLElement tus = new DefaultXMLElement();
                        tus.setName("source");
                        tus.addChild(ms);
                        tu.setSource(tus);
                        DefaultXMLElement tut = new DefaultXMLElement();
                        tut.setName("target");
                        tu.setTarget(tut);
                        XMLElement mt = (XMLElement)targetSegMarks.get(i);
                        tut.addChild(mt);
                        if (!XLIFF.sdlCommentsMap.isEmpty()) {
                            ArrayList comments = new ArrayList(1);
                            this.fetchSDLComments(ms, comments);
                            this.fetchSDLComments(mt, comments);
                            if (!comments.isEmpty()) {
                                tu.setNotes(comments);
                            }
                        }
                        if ((con = tu.getSourceText()).length() <= 0) continue;
                        this.addXfliffTU(tu);
                        xliff.addToMemory(con, tu, false, false);
                    }
                } else if (!this.SDLSegmentationError) {
                    JOptionPane.showMessageDialog(null, "Source and target segments do not match!", "Error", 0);
                    this.SDLSegmentationError = true;
                }
            } else {
                String con;
                List sourceCDATA;
                XMLElement cd;
                String n;
                Object o;
                List tlist = target.getChildren();
                if (tlist.size() == 1 && (o = tlist.get(0)) instanceof XMLElement && (n = (cd = (XMLElement)o).getName()).equals("!CDATA") && (sourceCDATA = source.getChildren("!CDATA")).isEmpty()) {
                    tlist.remove(0);
                }
                if ((con = tunit.getSourceText()).length() > 0) {
                    this.addXfliffTU(tunit);
                    xliff.addToMemory(con, tunit, false, false);
                }
            }
        } else {
            String con = tunit.getSourceText();
            if (con.length() > 0) {
                this.addXfliffTU(tunit);
                xliff.addToMemory(con, tunit, false, false);
            }
        }
    }

    void addXfliffTU(XLIFFUnit tunit) {
        int uid = ++XLIFF.unitCounter;
        tunit.setUnitID(uid);
        ++this.unitNumber;
        tunit.setUnitNumber(this.unitNumber);
        if (this.loadedTU != null) {
            this.loadedTU.nextTU = tunit;
            tunit.previousTU = this.loadedTU;
        }
        this.loadedTU = tunit;
        this.tunits.add(tunit);
    }

    public synchronized void addTransUnit(XLIFFUnit tunit) {
        if (this.currentBU != null) {
            this.currentBU.addTransUnit(tunit);
        } else if (this.currentGroup != null) {
            this.currentGroup.addTransUnit(tunit);
        } else {
            super.addChild(tunit);
        }
        this.addXfliffTU(tunit);
        this.currentTU = tunit;
        this.lastTU = tunit;
    }

    public synchronized void addTransUnit(int i, XLIFFUnit tunit) {
        if (this.currentBU != null) {
            this.currentBU.addTransUnit(i, tunit);
        } else if (this.currentGroup != null) {
            this.currentGroup.addTransUnit(i, tunit);
        } else {
            List elems = super.getChildren();
            elems.add(i, tunit);
        }
        this.tunits.add(i, tunit);
    }

    public synchronized void removeTransUnit(XLIFFUnit tu) {
        if (this.currentBU != null) {
            this.currentBU.removeTransUnit(tu);
        } else if (this.currentGroup != null) {
            this.currentGroup.removeTransUnit(tu);
        } else {
            super.removeChild(tu);
        }
        this.tunits.remove(tu);
    }

    public synchronized void removeBinaryUnit(BinaryUnit bu) {
        if (this.currentGroup != null) {
            this.currentGroup.removeBinaryUnit(bu);
        } else {
            super.removeChild(bu);
        }
        this.bunits.remove(bu);
        if (this.currentBU != null && this.currentBU.equals(bu)) {
            this.currentBU = null;
        }
    }

    public List getTransUnits() {
        return this.tunits;
    }

    public void clearFile() {
        List tus = this.getChildren();
        Iterator iterator = tus.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof XLIFFUnit)) continue;
            iterator.remove();
        }
        this.tunits.clear();
    }
}

