/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.WorkflowManager;
import translator.XMLElement;
import translator.XMLHelper;
import translator.xliff.FileBody;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;

public class ProcessXLIFFUnit {
    private XLIFF xliff;
    private int xliffVersion;
    private LinkedHashMap smap;
    private LinkedHashMap tmap;
    private String firstSourceTag;
    private String firstTargetTag;
    private String lastTargetTag;
    private String lastSourceTag;
    private int stags;
    private int ttags;
    private Pattern startTagsPattern;
    private Pattern endTagsPattern;
    private String sourceString;
    private LinkedHashMap xlocksSource;
    private LinkedHashMap xlocksTarget;

    public ProcessXLIFFUnit(XLIFF xliff) {
        this.xliff = xliff;
        this.xliffVersion = xliff.getVersion();
        this.startTagsPattern = Pattern.compile(AppPreferences.startTagRegEx);
        this.endTagsPattern = Pattern.compile(AppPreferences.endTagRegEx);
        this.smap = new LinkedHashMap();
        this.tmap = new LinkedHashMap();
        if (xliff.isExternalToolXLIFF) {
            this.xlocksSource = new LinkedHashMap(1);
            this.xlocksTarget = new LinkedHashMap(1);
        }
    }

    public void processTU(XLIFFUnit tu) {
        XMLElement stuv = tu.getSource();
        XMLElement ttuv = tu.getTarget();
        if (stuv != null) {
            int indxs;
            int exstag;
            boolean hasString;
            List slist = stuv.getChildren();
            List tlist = null;
            if (ttuv != null) {
                tlist = ttuv.getChildren();
            } else {
                ttuv = new DefaultXMLElement();
                ttuv.setName("target");
                if (!this.xliff.isExternalToolXLIFF) {
                    ttuv.setAttribute("state", "new");
                    ttuv.setAttribute("xml:lang", this.xliff.getCurrentFile().getAttribute("target-language"));
                }
                tu.setTarget(ttuv);
                tlist = ttuv.getChildren();
            }
            this.smap.clear();
            this.stags = -1;
            this.tmap.clear();
            this.ttags = -1;
            this.firstSourceTag = null;
            this.firstTargetTag = null;
            this.lastTargetTag = null;
            this.lastSourceTag = null;
            this.sourceString = null;
            String[] sarr = this.getSourceElements(slist, true);
            String[] tarr = this.getTargetElements(tlist, true);
            String fsource = sarr[0];
            String ftarget = tarr[0];
            boolean isTargetEmpty = false;
            if (this.xliff.isExternalToolXLIFF) {
                this.xlocksSource.clear();
                this.xlocksTarget.clear();
                if (ftarget.length() > 0) {
                    hasString = XMLHelper.hasStringContent(ftarget);
                    if (!hasString) {
                        ftarget = "";
                        isTargetEmpty = true;
                    }
                } else {
                    isTargetEmpty = true;
                }
            } else if (tlist.isEmpty()) {
                isTargetEmpty = true;
            }
            if (isTargetEmpty) {
                while (fsource.startsWith("<x") && (exstag = this.firstTagsIndex(fsource)) != -1) {
                    this.firstTargetTag = this.firstSourceTag == null ? (this.firstSourceTag = fsource.substring(0, exstag)) : (this.firstSourceTag = this.firstSourceTag + fsource.substring(0, exstag));
                    fsource = fsource.substring(exstag);
                }
                while (fsource.trim().endsWith(">") && (indxs = this.lastTagsIndex(fsource)) != -1) {
                    this.lastTargetTag = this.lastSourceTag == null ? (this.lastSourceTag = fsource.substring(indxs)) : (this.lastSourceTag = fsource.substring(indxs) + this.lastSourceTag);
                    fsource = fsource.substring(0, indxs);
                }
            } else {
                while (fsource.startsWith("<x") && ftarget.startsWith("<x")) {
                    exstag = this.firstTagsIndex(fsource);
                    int exttag = this.firstTagsIndex(ftarget);
                    if (exstag == -1 || exttag == -1) break;
                    if (this.firstSourceTag == null && this.firstTargetTag == null) {
                        this.firstSourceTag = fsource.substring(0, exstag);
                        this.firstTargetTag = ftarget.substring(0, exttag);
                    } else {
                        this.firstSourceTag = this.firstSourceTag + fsource.substring(0, exstag);
                        this.firstTargetTag = this.firstTargetTag + ftarget.substring(0, exttag);
                    }
                    fsource = fsource.substring(exstag);
                    ftarget = ftarget.substring(exttag);
                }
                if (this.firstSourceTag != null && this.firstTargetTag != null && !this.firstSourceTag.equals(this.firstTargetTag)) {
                    this.firstSourceTag = null;
                    this.firstTargetTag = null;
                    fsource = sarr[0];
                    ftarget = tarr[0];
                }
                while (fsource.trim().endsWith(">") && ftarget.trim().endsWith(">")) {
                    indxs = this.lastTagsIndex(fsource);
                    int indxt = this.lastTagsIndex(ftarget);
                    if (indxs == -1 || indxt == -1) break;
                    if (this.lastSourceTag == null && this.lastTargetTag == null) {
                        this.lastSourceTag = fsource.substring(indxs);
                        this.lastTargetTag = ftarget.substring(indxt);
                    } else {
                        this.lastSourceTag = fsource.substring(indxs) + this.lastSourceTag;
                        this.lastTargetTag = ftarget.substring(indxt) + this.lastTargetTag;
                    }
                    fsource = fsource.substring(0, indxs);
                    ftarget = ftarget.substring(0, indxt);
                }
                if (this.lastSourceTag != null && this.lastTargetTag != null && !this.lastSourceTag.equals(this.lastTargetTag)) {
                    this.firstSourceTag = null;
                    this.firstTargetTag = null;
                    this.lastSourceTag = null;
                    this.lastTargetTag = null;
                    fsource = sarr[0];
                    ftarget = tarr[0];
                }
            }
            if (ftarget.length() > 0 && !(hasString = XMLHelper.hasStringContent(ftarget))) {
                ftarget = "";
            }
            this.sourceString = fsource;
        }
    }

    public String getSourceString() {
        return this.sourceString;
    }

    private String[] getSourceElements(List list, boolean edit) {
        String fs = "";
        String es = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean ed = true;
                boolean em = false;
                if (this.xliffVersion == 2) {
                    if (name.equals("cp") || name.equals("ph") || name.equals("sc") || name.equals("ec") || name.equals("sm") || name.equals("em")) {
                        ed = false;
                        em = true;
                    }
                } else {
                    if (name.equals("bpt") || name.equals("ept") || name.equals("it") || name.equals("ph") || name.equals("bx") || name.equals("ex") || name.equals("x") || name.equals("ut")) {
                        ed = false;
                    }
                    if (name.equals("x") || name.equals("bx") || name.equals("ex")) {
                        em = true;
                    }
                }
                int tagNo = ++this.stags;
                String tname = "x" + tagNo;
                this.smap.put(tname, object);
                if (name.equals("x")) {
                    String lock;
                    String equiv = xml.getAttribute("equiv-text");
                    if (equiv != null && equiv.length() > 0) {
                        if (!this.xliff.isCafeTranXLIFF && equiv.indexOf(38) != -1) {
                            equiv = equiv.replace("&", "");
                        }
                        tname = tname + " equiv-text=\"" + equiv + "\"";
                    }
                    if (this.xliff.isExternalToolXLIFF && (lock = xml.getAttribute("id")) != null && lock.length() > 0 && lock.startsWith("locked")) {
                        this.xlocksSource.put(tname, xml);
                        tname = tname + " lock=\"true\"";
                    }
                }
                String stag = null;
                String etag = null;
                if (!em) {
                    stag = "<" + tname + ">";
                    etag = "</" + tname + ">";
                } else {
                    stag = "<" + tname + "/>";
                }
                fs = fs + stag;
                String[] arr = this.getSourceElements(li, ed);
                if (arr != null) {
                    fs = fs + arr[0];
                    es = es + arr[1];
                }
                if (etag == null) continue;
                fs = fs + etag;
                continue;
            }
            if (!edit) continue;
            es = es + object.toString();
            fs = fs + object.toString();
        }
        String[] sarr = new String[]{fs, es};
        return sarr;
    }

    private String[] getTargetElements(List list, boolean edit) {
        String fs = "";
        String es = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean ed = true;
                boolean em = false;
                if (this.xliffVersion == 2) {
                    if (name.equals("cp") || name.equals("ph") || name.equals("sc") || name.equals("ec") || name.equals("sm") || name.equals("em")) {
                        ed = false;
                        em = true;
                    }
                } else {
                    if (name.equals("bpt") || name.equals("ept") || name.equals("it") || name.equals("ph") || name.equals("bx") || name.equals("ex") || name.equals("x") || name.equals("ut")) {
                        ed = false;
                    }
                    if (name.equals("x") || name.equals("bx") || name.equals("ex")) {
                        em = true;
                    }
                }
                int tagNo = ++this.ttags;
                String tname = "x" + tagNo;
                this.tmap.put(tname, object);
                if (name.equals("x")) {
                    String lock;
                    String equiv = xml.getAttribute("equiv-text");
                    if (equiv != null && equiv.length() > 0) {
                        if (!this.xliff.isCafeTranXLIFF && equiv.indexOf(38) != -1) {
                            equiv = equiv.replace("&", "");
                        }
                        tname = tname + " equiv-text=\"" + equiv + "\"";
                    }
                    if (this.xliff.isExternalToolXLIFF && (lock = xml.getAttribute("id")) != null && lock.length() > 0 && lock.startsWith("locked")) {
                        this.xlocksTarget.put(tname, xml);
                        tname = tname + " lock=\"true\"";
                    }
                }
                String stag = null;
                String etag = null;
                if (!em) {
                    stag = "<" + tname + ">";
                    etag = "</" + tname + ">";
                } else {
                    stag = "<" + tname + "/>";
                }
                fs = fs + stag;
                String[] arr = this.getTargetElements(li, ed);
                if (arr != null) {
                    fs = fs + arr[0];
                    es = es + arr[1];
                }
                if (etag == null) continue;
                fs = fs + etag;
                continue;
            }
            if (!edit) continue;
            es = es + object.toString();
            fs = fs + object.toString();
        }
        String[] sarr = new String[]{fs, es};
        return sarr;
    }

    private int firstTagsIndex(String s) {
        int i = -1;
        Matcher m = this.startTagsPattern.matcher(s);
        boolean b = m.find();
        if (b) {
            i = m.end();
        }
        return i;
    }

    private int lastTagsIndex(String s) {
        int i = -1;
        Matcher m = this.endTagsPattern.matcher(s);
        boolean b = m.find();
        if (b) {
            i = m.start();
        }
        return i;
    }

    public boolean updateTU(XLIFFUnit tu, String source, String target) {
        if (tu != null) {
            boolean emptyTarget = false;
            if (target.length() == 0) {
                emptyTarget = true;
            }
            if (this.firstSourceTag != null) {
                source = this.firstSourceTag + source;
            }
            if (this.firstTargetTag != null) {
                target = this.firstTargetTag + target;
            }
            if (this.lastSourceTag != null) {
                source = source + this.lastSourceTag;
            }
            if (this.lastTargetTag != null) {
                target = target + this.lastTargetTag;
            }
            XMLElement tarXML = tu.getTarget();
            if (this.stags >= 0 || this.ttags >= 0) {
                boolean correct;
                if (this.xliff.isExternalToolXLIFF && this.xlocksSource.size() > 0) {
                    Collection xelems;
                    Set keys = this.xlocksSource.keySet();
                    this.tmap.clear();
                    if (!this.xlocksTarget.isEmpty()) {
                        Iterator valuesIterator = this.xlocksTarget.values().iterator();
                        Iterator it = keys.iterator();
                        for (int kindex = 0; it.hasNext() && kindex < this.xlocksTarget.size(); ++kindex) {
                            String s = it.next().toString();
                            it.remove();
                            XMLElement targetLock = (XMLElement)valuesIterator.next();
                            this.tmap.put(s, targetLock);
                        }
                    }
                    if (!(xelems = this.xlocksSource.values()).isEmpty()) {
                        FileBody body = this.xliff.getCurrentFile().getBody();
                        XMLElement[] xelements = body.createSDLLockedElement(xelems);
                        int xindex = 0;
                        Iterator it = keys.iterator();
                        while (it.hasNext()) {
                            String s = it.next().toString();
                            this.tmap.put(s, xelements[xindex]);
                            ++xindex;
                        }
                    }
                }
                if (!(correct = XMLHelper.parseSegment(tarXML, this.smap, this.tmap, target, true))) {
                    return false;
                }
                if (!WorkflowManager.suspendQATagsCheck) {
                    String formatName;
                    int j;
                    int i = XMLHelper.countTags(source);
                    if (!(i == (j = XMLHelper.countTags(target)) || emptyTarget || (formatName = this.xliff.getFormat()).indexOf("Uncleaned") != -1 || formatName.startsWith("Text") || this.xliff.isExternalToolXLIFF)) {
                        return false;
                    }
                } else {
                    WorkflowManager.suspendQATagsCheck = true;
                }
            } else {
                tarXML.getChildren().clear();
                tarXML.setContent(0, target);
            }
            if (this.xliff.isExternalToolXLIFF) {
                tu.updateParentTargetSegment();
            }
        }
        return true;
    }
}

