/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.DashboardView;
import translator.DefaultXMLElement;
import translator.FormatChooser;
import translator.KeyPreferences;
import translator.MainView;
import translator.MatchBoard;
import translator.NaturalOrderComparator;
import translator.Placeables;
import translator.Project;
import translator.TargetLanguageSelector;
import translator.Translatable;
import translator.TranslatableHandler;
import translator.XMLElement;
import translator.XMLElementEditor;
import translator.ui.GridPanel;
import translator.web.Proz;
import translator.xliff.AltTrans;
import translator.xliff.BinaryUnit;
import translator.xliff.CountGroup;
import translator.xliff.FileBody;
import translator.xliff.FileHeader;
import translator.xliff.PhaseGroup;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffFile;
import translator.xliff.XliffFileEditor;

public class XliffMenu {
    MainView topui;
    Project project;
    private JPopupMenu pop;
    private JCheckBox unglueCheckBox;
    XLIFF xliff;

    public XliffMenu(MainView topui, Project project) {
        this.topui = topui;
        this.project = project;
        this.xliff = project.getXLIFF();
    }

    public void showProjectsDialog(List files) {
        final JDialog dialog = new JDialog((Frame)this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENTS"));
        dialog.setDefaultCloseOperation(2);
        dialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
        dialog.setResizable(false);
        final GridPanel panel = new GridPanel();
        panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        panel.setLayout(new GridLayout(0, 1, 0, 2));
        JScrollPane scroll = new JScrollPane(panel);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        if (files.size() > 20) {
            scroll.setPreferredSize(new Dimension(800, 800));
        }
        dialog.add(scroll);
        if (files.size() > 1 && !this.project.superglue) {
            JButton menuGlueItem = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLUE ALL DOCUMENTS VIRTUALLY"));
            menuGlueItem.addActionListener(new ActionListener(){
                final /* synthetic */ XliffMenu this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                    dialog.dispose();
                    if (!this.this$0.project.superglue) {
                        this.this$0.topui.getWorkflowView().getWorkflowManager().endTranslation();
                        this.this$0.project.setSuperGluedWorkflow(true);
                        this.this$0.topui.getWorkflowView().next(0);
                    }
                }
            });
            menuGlueItem.setHorizontalAlignment(2);
            menuGlueItem.setFont(menuGlueItem.getFont().deriveFont(1));
            panel.add(menuGlueItem);
        } else if (files.size() > 1 && this.project.superglue) {
            this.unglueCheckBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("UNGLUE A DOCUMENT"));
            this.unglueCheckBox.setHorizontalAlignment(2);
            this.unglueCheckBox.setFont(this.unglueCheckBox.getFont().deriveFont(1));
            panel.add(this.unglueCheckBox);
        }
        int nf = 0;
        Iterator i = files.iterator();
        while (i.hasNext()) {
            ++nf;
            XLIFF pfile = (XLIFF)i.next();
            String p = pfile.getPath();
            String name = p;
            int fs = name.lastIndexOf(AppPreferences.fs);
            if (fs == -1 && (fs = name.lastIndexOf("/")) == -1) {
                fs = name.lastIndexOf("\\");
            }
            if (fs != -1) {
                name = name.substring(fs + 1);
            }
            JButton menuFileItem = new JButton(new AbstractAction(this, nf + ". " + name){
                final /* synthetic */ XliffMenu this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent a) {
                    boolean unglue = false;
                    if (this.this$0.unglueCheckBox != null && this.this$0.unglueCheckBox.isSelected()) {
                        unglue = true;
                    }
                    this.this$0.unglueCheckBox = null;
                    dialog.setVisible(false);
                    dialog.dispose();
                    JButton menu = (JButton)a.getSource();
                    XLIFF file = (XLIFF)menu.getClientProperty("element");
                    this.this$0.project.setXLIFF(file);
                    file.saved = false;
                    String p = file.getPath();
                    if (p != null) {
                        this.this$0.project.setTitleForFile(p);
                    }
                    this.this$0.topui.resetSegmentsFilter();
                    if (this.this$0.project.superglue) {
                        XliffFile xfile;
                        int ftu;
                        List xfiles;
                        if (!unglue && (xfiles = file.getFiles()).size() > 0 && (ftu = (xfile = (XliffFile)xfiles.get(0)).getFirstTUID()) != -1) {
                            this.this$0.project.edit("#" + --ftu);
                            return;
                        }
                        this.this$0.project.setSuperGluedWorkflow(false);
                    } else {
                        file.setWorkflow(null);
                    }
                    this.this$0.topui.getWorkflowView().next(0);
                }
            });
            XLIFF file = this.project.getXLIFF();
            if (file != null && file.equals(pfile)) {
                menuFileItem.setForeground(Color.RED);
                menuFileItem.setBackground(Color.WHITE);
                menuFileItem.setFont(menuFileItem.getFont().deriveFont(1));
            }
            menuFileItem.setHorizontalAlignment(2);
            menuFileItem.putClientProperty("element", pfile);
            menuFileItem.setToolTipText(p);
            panel.add(menuFileItem);
        }
        panel.getActionMap().put("ESC", new AbstractAction(this, "ESC"){
            final /* synthetic */ XliffMenu this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        panel.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        panel.getActionMap().put("ENTER", new AbstractAction(this, "ENTER"){
            final /* synthetic */ XliffMenu this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                Component[] comps = panel.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    JButton b;
                    Component comp = comps[i];
                    if (!(comp instanceof JButton) || !(b = (JButton)comp).hasFocus()) continue;
                    b.doClick();
                    break;
                }
            }
        });
        panel.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        Set<AWTKeyStroke> forwardKeys = dialog.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newForwardKeys = new HashSet<AWTKeyStroke>(forwardKeys);
        newForwardKeys.add(KeyStroke.getKeyStroke(40, 0));
        Set<AWTKeyStroke> backwardKeys = dialog.getFocusTraversalKeys(1);
        HashSet<AWTKeyStroke> newBackwardKeys = new HashSet<AWTKeyStroke>(backwardKeys);
        newBackwardKeys.add(KeyStroke.getKeyStroke(38, 0));
        dialog.setFocusTraversalKeys(0, newForwardKeys);
        dialog.setFocusTraversalKeys(1, newBackwardKeys);
        Dimension dlgSize = dialog.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void showRemoveProjectsDialog(final List files) {
        final JDialog dialog = new JDialog((Frame)this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE DOCUMENT"));
        dialog.setDefaultCloseOperation(2);
        dialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
        dialog.setResizable(false);
        GridPanel panel = new GridPanel();
        panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        panel.setLayout(new GridLayout(0, 1, 0, 2));
        JScrollPane scroll = new JScrollPane(panel);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        if (files.size() > 20) {
            scroll.setPreferredSize(new Dimension(800, 800));
        }
        dialog.add(scroll);
        if (files.size() > 1) {
            JButton menuRemoveAllItem = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE ALL FILES"));
            menuRemoveAllItem.addActionListener(new ActionListener(){
                final /* synthetic */ XliffMenu this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                    dialog.dispose();
                    int k = JOptionPane.showConfirmDialog(this.this$0.topui, "This action will delete project files from the project folder. Continue?", "Remove project files?", 0);
                    if (k == 1) {
                        return;
                    }
                    for (XLIFF pfile : files) {
                        String p = pfile.getPath();
                        File file = new File(p);
                        if (!file.exists()) continue;
                        file.delete();
                    }
                    files.clear();
                    this.this$0.project.resetFileIDs();
                    this.this$0.xliff.setCurrentFile(null);
                    this.this$0.topui.getProjectView().resetProjectTextPane();
                    this.this$0.topui.setTitle(AppPreferences.CTTitle);
                    this.this$0.project.saveProject(false);
                    this.this$0.project.createFile(true);
                    if (AppPreferences.prompter) {
                        this.this$0.topui.getSourceView().updatePrompter();
                    }
                }
            });
            menuRemoveAllItem.setHorizontalAlignment(2);
            menuRemoveAllItem.setFont(menuRemoveAllItem.getFont().deriveFont(1));
            panel.add(menuRemoveAllItem);
        }
        for (XLIFF pfile : files) {
            String p = pfile.getPath();
            String name = p;
            int fs = name.lastIndexOf(AppPreferences.fs);
            if (fs == -1 && (fs = name.lastIndexOf("/")) == -1) {
                fs = name.lastIndexOf("\\");
            }
            if (fs != -1) {
                name = name.substring(fs + 1);
            }
            JButton menuFileItem = new JButton(new AbstractAction(this, name){
                final /* synthetic */ XliffMenu this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent a) {
                    File file;
                    dialog.setVisible(false);
                    dialog.dispose();
                    int k = JOptionPane.showConfirmDialog(this.this$0.topui, "This action will delete a project file from the project folder. Continue?", "Delete a project file?", 0);
                    if (k == 1) {
                        return;
                    }
                    JButton menu = (JButton)a.getSource();
                    XLIFF xfile = (XLIFF)menu.getClientProperty("element");
                    String p = xfile.getPath();
                    if (p != null && (file = new File(p)).exists()) {
                        file.delete();
                    }
                    files.remove(xfile);
                    this.this$0.project.resetFileIDs();
                    if (this.this$0.project.superglue) {
                        this.this$0.project.setSuperGluedWorkflow(false);
                    } else {
                        xfile.setWorkflow(null);
                    }
                    if (files.size() > 1) {
                        this.this$0.project.setSuperGluedWorkflow(true);
                        this.this$0.project.edit("#0");
                        this.this$0.project.saveProject(false);
                    } else if (files.size() == 1) {
                        XLIFF pfile = (XLIFF)files.get(0);
                        List pfiles = pfile.getFiles();
                        if (pfiles.size() > 1) {
                            this.this$0.project.setGluedWorkflow(true);
                            this.this$0.project.edit("#0");
                            this.this$0.project.saveProject(false);
                        } else if (pfiles.size() == 1) {
                            XliffFile pxfile = (XliffFile)pfiles.get(0);
                            this.this$0.xliff.setCurrentFile(pxfile);
                            this.this$0.project.edit("#0");
                            this.this$0.project.saveProject(false);
                        } else {
                            this.this$0.xliff.setCurrentFile(null);
                            this.this$0.topui.getProjectView().resetProjectTextPane();
                            this.this$0.topui.setTitle(AppPreferences.CTTitle);
                            this.this$0.project.saveProject(false);
                            this.this$0.project.createFile(true);
                            if (AppPreferences.prompter) {
                                this.this$0.topui.getSourceView().updatePrompter();
                            }
                        }
                    } else {
                        this.this$0.xliff.setCurrentFile(null);
                        this.this$0.topui.getProjectView().resetProjectTextPane();
                        this.this$0.topui.setTitle(AppPreferences.CTTitle);
                        this.this$0.project.saveProject(false);
                        this.this$0.project.createFile(true);
                        if (AppPreferences.prompter) {
                            this.this$0.topui.getSourceView().updatePrompter();
                        }
                    }
                }
            });
            XLIFF file = this.project.getXLIFF();
            if (file != null && file.equals(pfile)) {
                menuFileItem.setForeground(Color.RED);
                menuFileItem.setBackground(Color.WHITE);
                menuFileItem.setFont(menuFileItem.getFont().deriveFont(1));
            }
            menuFileItem.setHorizontalAlignment(2);
            menuFileItem.putClientProperty("element", pfile);
            menuFileItem.setToolTipText(p);
            FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CLOSE, (int)menuFileItem.getFont().getSize(), (Color)menuFileItem.getForeground());
            menuFileItem.setIcon((Icon)ficon);
            panel.add(menuFileItem);
        }
        panel.getActionMap().put("ESC", new AbstractAction(this, "ESC"){
            final /* synthetic */ XliffMenu this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        panel.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        Set<AWTKeyStroke> forwardKeys = dialog.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newForwardKeys = new HashSet<AWTKeyStroke>(forwardKeys);
        newForwardKeys.add(KeyStroke.getKeyStroke(40, 0));
        Set<AWTKeyStroke> backwardKeys = dialog.getFocusTraversalKeys(1);
        HashSet<AWTKeyStroke> newBackwardKeys = new HashSet<AWTKeyStroke>(backwardKeys);
        newBackwardKeys.add(KeyStroke.getKeyStroke(38, 0));
        dialog.setFocusTraversalKeys(0, newForwardKeys);
        dialog.setFocusTraversalKeys(1, newBackwardKeys);
        Dimension dlgSize = dialog.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void showFilesDialog() {
        List files = this.xliff.getContentsFiles();
        if (files == null || files.isEmpty()) {
            return;
        }
        final JDialog dialog = new JDialog((Frame)this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENTS"));
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        dialog.setResizable(false);
        final GridPanel panel = new GridPanel();
        panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        panel.setLayout(new GridLayout(0, 1, 0, 2));
        JScrollPane scroll = new JScrollPane(panel);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        if (files.size() > 20) {
            scroll.setPreferredSize(new Dimension(800, 800));
        }
        dialog.add(scroll);
        if (files.size() > 1 && this.project.mode != 2 && !this.project.glue) {
            JButton menuGlueItem = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLUE ALL DOCUMENTS VIRTUALLY"));
            menuGlueItem.addActionListener(new ActionListener(){
                final /* synthetic */ XliffMenu this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                    dialog.dispose();
                    if (!this.this$0.project.glue) {
                        this.this$0.topui.getWorkflowView().getWorkflowManager().endTranslation();
                        this.this$0.project.setGluedWorkflow(true);
                        String id = this.this$0.xliff.getLastID();
                        if (this.this$0.xliff.getView().getGluedUnits().isEmpty()) {
                            JOptionPane.showMessageDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FOUND NO SEGMENTS"));
                            this.this$0.showFilesDialog();
                        } else if (id != null) {
                            this.this$0.project.edit("#" + id);
                        } else {
                            this.this$0.project.updateViewMode(AppPreferences.projectView);
                        }
                    }
                }
            });
            menuGlueItem.setHorizontalAlignment(2);
            menuGlueItem.setFont(menuGlueItem.getFont().deriveFont(1));
            panel.add(menuGlueItem);
        } else if (files.size() > 1 && this.project.glue) {
            this.unglueCheckBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("UNGLUE A DOCUMENT"));
            this.unglueCheckBox.setHorizontalAlignment(2);
            this.unglueCheckBox.setFont(this.unglueCheckBox.getFont().deriveFont(1));
            panel.add(this.unglueCheckBox);
        }
        int nf = 0;
        for (XliffFile pfile : files) {
            String name = pfile.getShortName();
            String tooltip = pfile.getAttribute("original");
            JButton menuFileItem = new JButton(new AbstractAction(this, ++nf + ". " + name){
                final /* synthetic */ XliffMenu this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent a) {
                    boolean cancel;
                    int ftu;
                    JButton menu = (JButton)a.getSource();
                    XliffFile file = (XliffFile)menu.getClientProperty("element");
                    boolean unglue = false;
                    if (this.this$0.unglueCheckBox != null && this.this$0.unglueCheckBox.isSelected()) {
                        unglue = true;
                    }
                    this.this$0.unglueCheckBox = null;
                    dialog.setVisible(false);
                    dialog.dispose();
                    if (this.this$0.project.glue && !unglue && (ftu = file.getFirstTUID()) != -1) {
                        this.this$0.topui.resetSegmentsFilter();
                        this.this$0.xliff.edit("#" + --ftu);
                        return;
                    }
                    this.this$0.topui.getWorkflowView().getWorkflowManager().endTranslation();
                    String format = file.getAttribute("datatype");
                    if ((format == null || format.length() == 0 || format.equals("x-auto")) && (cancel = this.this$0.showXLIFFFile(file, 0, true))) {
                        return;
                    }
                    this.this$0.xliff.setCurrentFile(file);
                    if (this.this$0.project.glue) {
                        this.this$0.project.setGluedWorkflow(false);
                    } else {
                        this.this$0.xliff.setWorkflow(null);
                    }
                    AppPreferences.original = file.getAttribute("original");
                    this.this$0.project.setTitleForFile(file.getShortName());
                    this.this$0.project.openSkeleton(file);
                    String id = file.getLastID();
                    if (id != null) {
                        this.this$0.project.edit("#" + id);
                    } else {
                        this.this$0.topui.getWorkflowView().next(0);
                    }
                    if (XLIFF.unitCounter > AppPreferences.pagesize) {
                        this.this$0.topui.getProjectView().setNavigationButtons();
                    }
                }
            });
            menuFileItem.setToolTipText(tooltip);
            menuFileItem.setHorizontalAlignment(2);
            menuFileItem.putClientProperty("element", pfile);
            XliffFile file = this.xliff.getCurrentFile();
            if (file != null && file.equals(pfile)) {
                menuFileItem.setForeground(Color.RED);
                menuFileItem.setBackground(Color.WHITE);
                menuFileItem.setFont(menuFileItem.getFont().deriveFont(1));
            }
            panel.add(menuFileItem);
        }
        panel.getActionMap().put("ESC", new AbstractAction(this, "ESC"){
            final /* synthetic */ XliffMenu this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        panel.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        panel.getActionMap().put("ENTER", new AbstractAction(this, "ENTER"){
            final /* synthetic */ XliffMenu this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                Component[] comps = panel.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    JButton b;
                    Component comp = comps[i];
                    if (!(comp instanceof JButton) || !(b = (JButton)comp).hasFocus()) continue;
                    b.doClick();
                    break;
                }
            }
        });
        panel.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        Set<AWTKeyStroke> forwardKeys = dialog.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newForwardKeys = new HashSet<AWTKeyStroke>(forwardKeys);
        newForwardKeys.add(KeyStroke.getKeyStroke(40, 0));
        Set<AWTKeyStroke> backwardKeys = dialog.getFocusTraversalKeys(1);
        HashSet<AWTKeyStroke> newBackwardKeys = new HashSet<AWTKeyStroke>(backwardKeys);
        newBackwardKeys.add(KeyStroke.getKeyStroke(38, 0));
        dialog.setFocusTraversalKeys(0, newForwardKeys);
        dialog.setFocusTraversalKeys(1, newBackwardKeys);
        Dimension dlgSize = dialog.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void showRemoveFilesDialog() {
        List files = this.xliff.getFiles();
        if (files == null || files.isEmpty()) {
            return;
        }
        final JDialog dialog = new JDialog((Frame)this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE DOCUMENT"));
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        dialog.setResizable(false);
        GridPanel panel = new GridPanel();
        panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        panel.setLayout(new GridLayout(0, 1, 0, 2));
        JScrollPane scroll = new JScrollPane(panel);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        if (files.size() > 20) {
            scroll.setPreferredSize(new Dimension(800, 800));
        }
        dialog.add(scroll);
        if (files.size() > 1 && this.project.mode != 2) {
            JButton menuRemoveAllItem = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE ALL FILES"));
            menuRemoveAllItem.addActionListener(new ActionListener(){
                final /* synthetic */ XliffMenu this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                    dialog.dispose();
                    this.this$0.project.removeAllFiles();
                    this.this$0.xliff.setCurrentFile(null);
                    this.this$0.topui.getProjectView().resetProjectTextPane();
                    this.this$0.topui.setTitle(AppPreferences.CTTitle);
                    this.this$0.project.saveProject(false);
                    this.this$0.project.createFile(true);
                    if (AppPreferences.prompter) {
                        this.this$0.topui.getSourceView().updatePrompter();
                    }
                }
            });
            menuRemoveAllItem.setHorizontalAlignment(2);
            menuRemoveAllItem.setFont(menuRemoveAllItem.getFont().deriveFont(1));
            panel.add(menuRemoveAllItem);
        }
        for (XliffFile pfile : files) {
            String name = pfile.getShortName();
            String tooltip = pfile.getAttribute("original");
            JButton menuFileItem = new JButton(new AbstractAction(this, name){
                final /* synthetic */ XliffMenu this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent a) {
                    List files;
                    JButton menu = (JButton)a.getSource();
                    XliffFile file = (XliffFile)menu.getClientProperty("element");
                    dialog.setVisible(false);
                    dialog.dispose();
                    this.this$0.project.removeFile(file);
                    if (this.this$0.project.glue) {
                        this.this$0.project.setGluedWorkflow(false);
                    }
                    if ((files = this.this$0.xliff.getFiles()).size() > 1) {
                        this.this$0.project.setGluedWorkflow(true);
                        this.this$0.project.edit("#0");
                        this.this$0.project.saveProject(false);
                    } else if (files.size() == 1) {
                        XliffFile xfile = (XliffFile)files.get(0);
                        this.this$0.xliff.setCurrentFile(xfile);
                        this.this$0.project.edit("#0");
                        this.this$0.project.saveProject(false);
                    } else {
                        this.this$0.xliff.setCurrentFile(null);
                        this.this$0.topui.getProjectView().resetProjectTextPane();
                        this.this$0.topui.setTitle(AppPreferences.CTTitle);
                        this.this$0.project.saveProject(false);
                        this.this$0.project.createFile(true);
                        if (AppPreferences.prompter) {
                            this.this$0.topui.getSourceView().updatePrompter();
                        }
                    }
                }
            });
            menuFileItem.setToolTipText(tooltip);
            menuFileItem.setHorizontalAlignment(2);
            menuFileItem.putClientProperty("element", pfile);
            FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CLOSE, (int)menuFileItem.getFont().getSize(), (Color)menuFileItem.getForeground());
            menuFileItem.setIcon((Icon)ficon);
            XliffFile file = this.xliff.getCurrentFile();
            if (file != null && file.equals(pfile)) {
                menuFileItem.setForeground(Color.RED);
                menuFileItem.setBackground(Color.WHITE);
                menuFileItem.setFont(menuFileItem.getFont().deriveFont(1));
            }
            panel.add(menuFileItem);
        }
        panel.getActionMap().put("ESC", new AbstractAction(this, "ESC"){
            final /* synthetic */ XliffMenu this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        panel.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        Set<AWTKeyStroke> forwardKeys = dialog.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newForwardKeys = new HashSet<AWTKeyStroke>(forwardKeys);
        newForwardKeys.add(KeyStroke.getKeyStroke(40, 0));
        Set<AWTKeyStroke> backwardKeys = dialog.getFocusTraversalKeys(1);
        HashSet<AWTKeyStroke> newBackwardKeys = new HashSet<AWTKeyStroke>(backwardKeys);
        newBackwardKeys.add(KeyStroke.getKeyStroke(38, 0));
        dialog.setFocusTraversalKeys(0, newForwardKeys);
        dialog.setFocusTraversalKeys(1, newBackwardKeys);
        Dimension dlgSize = dialog.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void createNote(Object o) {
        XMLElement top = (XMLElement)o;
        if (this.xliff.isTXLIFF) {
            XLIFFUnit tu = (XLIFFUnit)top;
            this.createTXliffComment(tu);
        } else if (this.xliff.isTXML) {
            XLIFFUnit tu = (XLIFFUnit)top;
            this.createWFComment(tu);
        } else if (this.xliff.isMQXLIFF) {
            XLIFFUnit tu = (XLIFFUnit)top;
            this.createMQComment(tu);
        } else if (this.xliff.isExternalToolXLIFF && !this.xliff.isUnknownXLIFF) {
            XLIFFUnit tu = (XLIFFUnit)top;
            if (tu.getNotes().isEmpty()) {
                this.createSDLComment(tu);
            }
        } else {
            int i;
            DefaultXMLElement note = new DefaultXMLElement();
            String text = null;
            text = this.topui.getTargetPane().getSelectedText();
            if (text == null && (text = this.topui.getSourcePane().getSelectedText()) == null) {
                text = "";
            }
            note.setContent(0, text);
            note.setName("note");
            if (AppPreferences.userid.length() > 0) {
                note.setAttribute("from", AppPreferences.userid);
            }
            if ((i = this.showXMLElement(note)) == 1) {
                top.addChild(note);
            }
        }
    }

    private void createMQComment(XLIFFUnit tu) {
        String uuid = UUID.randomUUID().toString();
        String text = null;
        text = this.topui.getTargetPane().getSelectedText();
        if (text == null && (text = this.topui.getSourcePane().getSelectedText()) == null) {
            text = "";
        }
        DefaultXMLElement comment = new DefaultXMLElement();
        comment.setName("mq:comment");
        comment.setAttribute("id", uuid);
        if (AppPreferences.userid.length() > 0) {
            comment.setAttribute("creatoruser", AppPreferences.userid);
        } else {
            comment.setAttribute("creatoruser", "Me");
        }
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String date = sdf.format(cal.getTime()).toString();
        comment.setAttribute("time", date);
        comment.setAttribute("deleted", "false");
        comment.setAttribute("category", "0");
        comment.setAttribute("appliesto", "Target");
        comment.setContent(0, text);
        int i = this.showXMLElement(comment);
        if (i == 1) {
            DefaultXMLElement cmts;
            List list = tu.getChildren("mq:comments");
            if (list.isEmpty()) {
                cmts = new DefaultXMLElement();
                cmts.setName("mq:comments");
                tu.addChild(cmts);
            } else {
                cmts = (DefaultXMLElement)list.get(0);
            }
            cmts.addChild(comment);
            ArrayList<DefaultXMLElement> comms = tu.getNotes();
            if (!comms.isEmpty()) {
                comms.add(comment);
            } else {
                comms = new ArrayList<DefaultXMLElement>(1);
                comms.add(comment);
                tu.setNotes(comms);
            }
        }
    }

    private void createWFComment(XLIFFUnit tu) {
        String text = null;
        text = this.topui.getTargetPane().getSelectedText();
        if (text == null && (text = this.topui.getSourcePane().getSelectedText()) == null) {
            text = "";
        }
        DefaultXMLElement comment = new DefaultXMLElement();
        comment.setName("comment");
        if (AppPreferences.userid.length() > 0) {
            comment.setAttribute("creationid", AppPreferences.userid);
        } else {
            comment.setAttribute("creationid", "Me");
        }
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        String date = sdf.format(cal.getTime()).toString();
        comment.setAttribute("creationdate", date);
        comment.setAttribute("type", "text");
        comment.setContent(0, text);
        int i = this.showXMLElement(comment);
        if (i == 1) {
            DefaultXMLElement cmts;
            List list = tu.getChildren("comments");
            if (list.isEmpty()) {
                cmts = new DefaultXMLElement();
                cmts.setName("comments");
                tu.addChild(cmts);
            } else {
                cmts = (DefaultXMLElement)list.get(0);
            }
            cmts.addChild(comment);
            ArrayList<DefaultXMLElement> comms = tu.getNotes();
            if (!comms.isEmpty()) {
                comms.add(comment);
            } else {
                comms = new ArrayList<DefaultXMLElement>(1);
                comms.add(comment);
                tu.setNotes(comms);
            }
        }
    }

    private void createTXliffComment(XLIFFUnit tu) {
        String text = null;
        text = this.topui.getTargetPane().getSelectedText();
        if (text == null && (text = this.topui.getSourcePane().getSelectedText()) == null) {
            text = "";
        }
        DefaultXMLElement comment = new DefaultXMLElement();
        comment.setName("gs4tr:note");
        comment.setAttribute("snid", "0");
        if (AppPreferences.userid.length() > 0) {
            comment.setAttribute("from", AppPreferences.userid);
        } else {
            comment.setAttribute("from", "Me");
        }
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String date = sdf.format(cal.getTime()).toString();
        comment.setAttribute("timestamp", date);
        comment.setAttribute("segment-note-type", "translation");
        comment.setContent(0, text);
        int i = this.showXMLElement(comment);
        if (i == 1) {
            tu.addChild(comment);
            ArrayList<DefaultXMLElement> comms = tu.getNotes();
            if (!comms.isEmpty()) {
                comms.add(comment);
            } else {
                comms = new ArrayList<DefaultXMLElement>(1);
                comms.add(comment);
                tu.setNotes(comms);
            }
        }
    }

    private void createSDLComment(XLIFFUnit tu) {
        XMLElement docInfo;
        List list = this.xliff.getChildren("doc-info");
        if (list.isEmpty()) {
            docInfo = new DefaultXMLElement();
            docInfo.setName("doc-info");
            String attr = this.xliff.getAttribute("xmlns:sdl");
            if (attr == null) {
                attr = "http://sdl.com/FileTypes/SdlXliff/1.0";
            }
            docInfo.setAttribute("xmlns", attr);
            List elems = this.xliff.getChildren();
            elems.add(0, docInfo);
        } else {
            docInfo = (XMLElement)list.get(0);
        }
        String uuid = UUID.randomUUID().toString();
        String text = null;
        text = this.topui.getTargetPane().getSelectedText();
        if (text == null && (text = this.topui.getSourcePane().getSelectedText()) == null) {
            text = "";
        }
        DefaultXMLElement comment = new DefaultXMLElement();
        comment.setName("Comment");
        comment.setAttribute("severity", "Low");
        if (AppPreferences.userid.length() > 0) {
            comment.setAttribute("user", AppPreferences.userid);
        } else {
            comment.setAttribute("user", "Me");
        }
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        String date = sdf.format(cal.getTime()).toString();
        comment.setAttribute("date", date);
        comment.setAttribute("version", "1.0");
        comment.setContent(0, text);
        int i = this.showXMLElement(comment);
        if (i == 1) {
            DefaultXMLElement cmtDefs;
            List list2 = docInfo.getChildren("cmt-defs");
            if (list2.isEmpty()) {
                cmtDefs = new DefaultXMLElement();
                cmtDefs.setName("cmt-defs");
                docInfo.addChild(cmtDefs);
            } else {
                cmtDefs = (DefaultXMLElement)list2.get(0);
            }
            DefaultXMLElement cmtDef = new DefaultXMLElement();
            cmtDef.setName("cmt-def");
            cmtDef.setAttribute("id", uuid);
            cmtDefs.addChild(cmtDef);
            DefaultXMLElement comments = new DefaultXMLElement();
            comments.setName("Comments");
            cmtDef.addChild(comments);
            comments.addChild(comment);
            DefaultXMLElement noteMrk = new DefaultXMLElement();
            noteMrk.setName("mrk");
            noteMrk.setAttribute("mtype", "x-sdl-comment");
            noteMrk.setAttribute("sdl:cid", uuid);
            ArrayList<DefaultXMLElement> comms = new ArrayList<DefaultXMLElement>(1);
            comms.add(comment);
            tu.setNotes(comms);
            tu.setSDLComment(noteMrk);
        }
    }

    public void createAltTrans(XLIFFUnit tu) {
        DefaultXMLElement target = new DefaultXMLElement();
        String text = null;
        text = this.topui.getTargetPane().getSelectedText();
        if (text == null) {
            text = this.topui.getTargetPane().getText();
        }
        target.setContent(0, text);
        target.setName("target");
        int i = this.showXMLElement(target);
        if (i == 1) {
            AltTrans alt = new AltTrans();
            alt.setName("alt-trans");
            alt.addChild(target);
            tu.addChild(alt);
        }
    }

    public void createFileCount(String name, FileHeader header) {
        CountGroup cgr = new CountGroup();
        cgr.setName("count-group");
        cgr.setAttribute("name", name);
        header.addChild(cgr);
        DefaultXMLElement count = new DefaultXMLElement();
        count.setName("count");
        count.setContent(0, "0");
        count.setAttribute("count-type", "total");
        count.setAttribute("unit", "character");
        cgr.addChild(count);
        count = new DefaultXMLElement();
        count.setName("count");
        count.setContent(0, "0");
        count.setAttribute("count-type", "total");
        count.setAttribute("unit", "x-character");
        cgr.addChild(count);
        count = new DefaultXMLElement();
        count.setName("count");
        count.setContent(0, "0");
        count.setAttribute("count-type", "total");
        count.setAttribute("unit", "word");
        cgr.addChild(count);
    }

    public XliffFile createAutoFile(String path) {
        XliffFile file = new XliffFile();
        file.setName("file");
        file.setAttribute("original", path);
        file.setAttribute("source-language", AppPreferences.fileSLang);
        file.setAttribute("target-language", AppPreferences.fileTLang);
        int dot = path.lastIndexOf(".");
        if (dot != -1) {
            String ext = path.substring(dot).toLowerCase();
            String dtype = FormatChooser.getDataTypeForExtension(ext);
            file.setAttribute("datatype", dtype);
        } else {
            file.setAttribute("datatype", "x-auto");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Calendar cal = Calendar.getInstance();
        String date = sdf.format(cal.getTime()).toString();
        file.setAttribute("date", date);
        file.setAttribute("tool-id", AppPreferences.tool);
        FileHeader header = new FileHeader();
        header.setName("header");
        header.setSkeletonReference(path);
        file.setHeader(header);
        PhaseGroup phasegroup = new PhaseGroup();
        phasegroup.setName("phase-group");
        DefaultXMLElement phase = new DefaultXMLElement();
        phase.setName("phase");
        phase.setAttribute("phase-name", "Default");
        phase.setAttribute("process-name", "Review");
        phasegroup.addChild(phase);
        header.setPhaseGroup(phasegroup);
        DefaultXMLElement tool = new DefaultXMLElement();
        tool.setName("tool");
        tool.setAttribute("tool-id", "CafeTran");
        tool.setAttribute("tool-name", "CafeTran Espresso");
        tool.setAttribute("tool-version", AppPreferences.productID);
        header.addChild(tool);
        FileBody body = new FileBody();
        body.setName("body");
        file.setBody(body);
        return file;
    }

    private int createFilesInDir(File dir, LinkedHashMap<String, String> documentFilter) {
        int n = 0;
        File[] files = dir.listFiles();
        if (files.length > 1) {
            List<File> list = Arrays.asList(files);
            Collections.sort(list, new NaturalOrderComparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    File entry1 = (File)o1;
                    File entry2 = (File)o2;
                    if (entry1.isDirectory() && entry2.isFile()) {
                        return 1;
                    }
                    if (entry2.isDirectory() && entry1.isFile()) {
                        return -1;
                    }
                    String s1 = entry1.getName();
                    String s2 = entry2.getName();
                    return super.compare(s1, s2);
                }
            });
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String name = file.getName();
            if (name.startsWith(".") || name.startsWith("~") || name.endsWith(".ini") || name.trim().length() == 0) continue;
            if (file.isFile()) {
                char last = name.charAt(name.length() - 1);
                if (!Character.isLetter(last)) continue;
                String org = file.getPath();
                XliffFile xfile = this.createAutoFile(org);
                if (documentFilter != null) {
                    for (Map.Entry<String, String> entry : documentFilter.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        xfile.setAttribute(key, value);
                    }
                }
                this.xliff.addChild(xfile);
                ++n;
                continue;
            }
            if (!file.isDirectory()) continue;
            n += this.createFilesInDir(file, documentFilter);
        }
        return n;
    }

    public void replaceProjectFile(XliffFile file) {
        boolean succ;
        String projectDirectory;
        String orig = file.getAttribute("original");
        File dir = new File(orig);
        if (dir.isDirectory()) {
            JOptionPane.showMessageDialog(this.topui, "CafeTran cannot replace a folder: " + orig);
            return;
        }
        if (XliffFile.fileReplacementDir != null && XliffFile.fileReplacementDir.length() > 0) {
            projectDirectory = XliffFile.fileReplacementDir;
            XliffFile.fileReplacementDir = null;
        } else {
            projectDirectory = AppPreferences.projectDirectory;
        }
        File projectDirectoryFile = new File(projectDirectory);
        if (!projectDirectoryFile.exists() && !(succ = projectDirectoryFile.mkdirs())) {
            JOptionPane.showMessageDialog(this.topui, "CafeTran cannot make Project location directory: " + projectDirectory);
            return;
        }
        LinkedHashMap<String, String> docFiltersMap = this.project.getDocumentFilters();
        final boolean bilingual = docFiltersMap != null ? docFiltersMap.get("filter:ImportTargetColumn") != null : false;
        String fs = dir.getName();
        String slang = file.getAttribute("source-language");
        int ind = fs.lastIndexOf(".");
        if (ind != -1) {
            String ext = fs.substring(ind);
            fs = fs.substring(0, ind) + "_" + slang + ext;
        } else {
            fs = fs + slang;
        }
        fs = projectDirectory + AppPreferences.fs + fs;
        String pname = dir.getName();
        int dot = pname.lastIndexOf(46);
        if (dot != -1) {
            pname = pname.substring(0, dot);
        }
        if (this.project.mode != 2) {
            block14: {
                try {
                    FileChannel srcChannel = new FileInputStream(orig).getChannel();
                    FileChannel dstChannel = new FileOutputStream(fs).getChannel();
                    dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                    srcChannel.close();
                    dstChannel.close();
                }
                catch (IOException e) {
                    String m = e.getMessage();
                    if (m == null) break block14;
                    JOptionPane.showMessageDialog(this.topui, m, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILE CREATION FAILED!"), 0);
                }
            }
            orig = fs;
            dir = new File(orig);
            file.setAttribute("original", orig);
        }
        FileHeader header = file.getHeader();
        header.setSkeletonReference(orig);
        if (AppPreferences.format != null) {
            String dtype = FormatChooser.getDataType(AppPreferences.format);
            file.setAttribute("datatype", dtype);
        }
        if (docFiltersMap != null) {
            for (Map.Entry<String, String> entry : docFiltersMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                file.setAttribute(key, value);
            }
        }
        this.project.updateViewMode(AppPreferences.projectView);
        AppPreferences.original = file.getAttribute("original");
        this.project.openSkeleton(file);
        this.project.setTitleForFile(file.getShortName());
        if (this.project.mode == 2) {
            this.project.saveProject(true);
        }
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ XliffMenu this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.project.mode == 1 && !this.this$0.project.align) {
                    TranslatableHandler handler = new TranslatableHandler(this.this$0.topui);
                    if (!bilingual) {
                        handler.autoSegmentationSingleFile(this.this$0.project);
                        this.this$0.project.saveProject(false);
                    } else {
                        handler.autoSegmentationBilingualSingleFile(this.this$0.project);
                        this.this$0.project.saveProject(false);
                    }
                    this.this$0.topui.getWorkflowView().getWorkflowManager().start();
                    this.this$0.project.setExactMachesFromReplacementMemory();
                }
            }
        });
    }

    public void createProjectFile(final XliffFile file, final boolean addingDocument) {
        String slang;
        String name;
        LinkedHashMap<String, String> docFiltersMap;
        boolean succ;
        Placeables.loadPlaceables();
        Object orig = file.getAttribute("original");
        File dir = new File((String)orig);
        String previewDirectory = AppPreferences.projectDirectory + AppPreferences.fs + "preview";
        File projectDirectoryFile = new File(AppPreferences.projectDirectory);
        File previewDirectoryFile = new File(previewDirectory);
        String previewPath = null;
        if (dir.isDirectory()) {
            if (projectDirectoryFile.getParent() != null && projectDirectoryFile.getParent().equalsIgnoreCase((String)orig)) {
                JOptionPane.showMessageDialog(this.topui, "CafeTran cannot create the Project inside the source document folder: " + (String)orig);
                return;
            }
            if (AppPreferences.projectDirectory != null && AppPreferences.projectDirectory.equalsIgnoreCase((String)orig)) {
                JOptionPane.showMessageDialog(this.topui, "CafeTran cannot create the Project inside the source document folder: " + (String)orig);
                return;
            }
        }
        if (!projectDirectoryFile.exists() && !(succ = projectDirectoryFile.mkdirs())) {
            JOptionPane.showMessageDialog(this.topui, "CafeTran cannot make Project location directory: " + AppPreferences.projectDirectory);
            return;
        }
        if (!previewDirectoryFile.exists()) {
            previewDirectoryFile.mkdir();
        }
        final boolean bilingual = (docFiltersMap = this.project.getDocumentFilters()) != null ? docFiltersMap.get("filter:ImportTargetColumn") != null : false;
        if (this.project.align) {
            file.setCurrentPhase("Alignment");
            File one = new File(AppPreferences.alignedFile);
            if (one.exists()) {
                String fileTarget;
                block46: {
                    fileTarget = one.getName();
                    String tlang = file.getAttribute("target-language");
                    int ind = fileTarget.lastIndexOf(".");
                    if (ind != -1) {
                        String ext = fileTarget.substring(ind);
                        fileTarget = fileTarget.substring(0, ind) + "_" + tlang + ext;
                    } else {
                        fileTarget = fileTarget + tlang;
                    }
                    fileTarget = AppPreferences.projectDirectory + AppPreferences.fs + fileTarget;
                    try {
                        this.copyFile(AppPreferences.alignedFile, fileTarget);
                    }
                    catch (IOException e) {
                        String m = e.getMessage();
                        if (m == null) break block46;
                        JOptionPane.showMessageDialog(this.topui, m, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILE CREATION FAILED!"), 0);
                    }
                }
                file.addReference(fileTarget, "Aligned document");
            }
        }
        String xlfpath = null;
        int n = -1;
        if (!dir.exists()) {
            xlfpath = AppPreferences.projectDirectory + AppPreferences.fs + (String)orig + ".xlf";
        } else if (dir.isFile()) {
            List files;
            List files2;
            String sourceName;
            name = dir.getName();
            slang = file.getAttribute("source-language");
            int ind = name.lastIndexOf(".");
            if (ind != -1) {
                String ext = name.substring(ind);
                sourceName = name.substring(0, ind) + "_" + slang + ext;
            } else {
                sourceName = name + slang;
            }
            if (addingDocument && (files2 = this.project.getProjectFiles()) != null) {
                for (XliffFile next : files2) {
                    String sn = next.getShortName();
                    if (sn == null || !sn.equals(sourceName)) continue;
                    sourceName = "Copy_" + sourceName;
                    break;
                }
            }
            String sourcePath = AppPreferences.projectDirectory + AppPreferences.fs + sourceName;
            previewPath = previewDirectory + AppPreferences.fs + name;
            String pname = dir.getName();
            int dot = pname.lastIndexOf(46);
            if (dot != -1) {
                pname = pname.substring(0, dot);
            }
            if ((files = this.project.getProjectFiles()) != null && files.isEmpty()) {
                xlfpath = AppPreferences.projectDirectory + AppPreferences.fs + pname + ".xlf";
            }
            if (this.project.mode != 2) {
                block47: {
                    try {
                        this.copyFile((String)orig, sourcePath);
                        this.copyFile((String)orig, previewPath);
                    }
                    catch (IOException e) {
                        String m = e.getMessage();
                        if (m == null) break block47;
                        JOptionPane.showMessageDialog(this.topui, m, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILE CREATION FAILED!"), 0);
                    }
                }
                orig = sourcePath;
                dir = new File((String)orig);
                file.setAttribute("original", (String)orig);
            }
            FileHeader header = file.getHeader();
            header.setSkeletonReference((String)orig);
            if (AppPreferences.format != null) {
                String dtype = FormatChooser.getDataType(AppPreferences.format);
                file.setAttribute("datatype", dtype);
            }
        }
        if (dir.isDirectory()) {
            String fs = AppPreferences.projectDirectory + AppPreferences.fs + dir.getName();
            String tlang = file.getAttribute("target-language");
            slang = file.getAttribute("source-language");
            orig = !fs.endsWith("_" + slang) ? (String)fs + "_" + slang : fs;
            File sourcedir = new File((String)orig);
            if (!sourcedir.exists()) {
                try {
                    this.copyDirectory(dir, sourcedir, slang, this.project.getFilesFilter());
                }
                catch (IOException ex) {
                    Logger.getLogger(XliffMenu.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            file.setAttribute("original", (String)orig);
            n = this.createFilesInDir(sourcedir, docFiltersMap);
            File targetdir = new File((String)fs + "_" + tlang);
            if (!targetdir.exists()) {
                boolean bl = targetdir.mkdir();
            }
            if (n > 0) {
                xlfpath = AppPreferences.projectDirectory + AppPreferences.fs + sourcedir.getName() + ".xlf";
            }
        } else {
            if (docFiltersMap != null) {
                for (Map.Entry<String, String> entry : docFiltersMap.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    file.setAttribute(key, value);
                }
            }
            this.xliff.addChild(file);
            this.project.updateViewMode(AppPreferences.projectView);
            AppPreferences.original = file.getAttribute("original");
            this.project.openSkeleton(file);
            if (AppPreferences.editorAPI == 1 && previewPath != null && FormatChooser.isSupportedPreviewFormat(previewPath) && this.project.getLibreOfficeMode() == 0) {
                this.project.setPreviewReference(previewPath, "LibreOffice");
                this.topui.getResourceLoader().loadPreviewPath();
            }
        }
        if (xlfpath != null) {
            this.topui.getResourceLoader().addProject(xlfpath);
            this.project.saveProject(xlfpath);
        } else {
            name = file.getAttribute("original");
            this.project.setName(name);
            if (this.project.mode == 2) {
                this.project.saveProject(true);
                String path = this.project.getProjectPath();
                if (path != null && path.endsWith(".xlf")) {
                    this.topui.getResourceLoader().addProject(path);
                }
            }
        }
        if (AppPreferences.trackingChanges && this.topui.getTrackingChanges() == null) {
            this.topui.setTrackingChanges();
        }
        if (n > 0) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ XliffMenu this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (this.this$0.project.mode == 1) {
                        TranslatableHandler handler = new TranslatableHandler(this.this$0.topui);
                        handler.autoSegmentation(this.this$0.project);
                        this.this$0.project.saveProject(false);
                    }
                    this.this$0.showFilesDialog();
                    if (!addingDocument) {
                        this.this$0.topui.getResourceLoader().loadTranslationResources(this.this$0.project, true);
                        if (this.this$0.project.mode == 1) {
                            this.this$0.topui.getWorkflowView().getWorkflowManager().start();
                        }
                    }
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ XliffMenu this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    String t;
                    if (this.this$0.project.mode == 1 && !this.this$0.project.align) {
                        TranslatableHandler handler = new TranslatableHandler(this.this$0.topui);
                        if (!bilingual) {
                            handler.autoSegmentationSingleFile(this.this$0.project);
                            this.this$0.project.saveProject(false);
                            this.this$0.project.updateViewMode(1);
                        } else {
                            handler.autoSegmentationBilingualSingleFile(this.this$0.project);
                            this.this$0.project.saveProject(false);
                            this.this$0.project.updateViewMode(1);
                        }
                    }
                    if (this.this$0.xliff.getChildren().size() > 1) {
                        this.this$0.showFilesDialog();
                    } else if (file != null && (t = file.getShortName()) != null) {
                        this.this$0.project.setTitleForFile(t);
                    }
                    if (!addingDocument) {
                        this.this$0.topui.getResourceLoader().loadTranslationResources(this.this$0.project, true);
                        if (this.this$0.project.mode == 1) {
                            this.this$0.topui.getWorkflowView().getWorkflowManager().start();
                        }
                    }
                }
            });
        }
        if (this.project.mode == 2) {
            this.topui.getWorkflowView().getWorkflowManager().start();
            JOptionPane.showMessageDialog(this.topui, "Translate sentences of the paper or image document. Click the Next button after each sentence.");
            MatchBoard mb = this.topui.getMatchBoard();
            if (mb != null) {
                mb.clearMatchBoard();
            }
        } else if (this.project.mode == 3) {
            this.topui.getWorkflowView().getWorkflowManager().start();
            String s = "";
            s = AppPreferences.operatingSystem == 1 ? "<html><body style=\"color:#0E6655\">CafeTran is listening to for the text copied via the Command+C shortcut.<br>Use the toggle button to pause listening.<br><br>Translated segments are exported one after the other automatically.<br>Paste them into your application via the Command+V shortcut.<br><br>All the translated text can exported via the Export button.</body></html>" : "<html><body style=\"color:#0E6655\">CafeTran is listening to for the text copied via the CTRL+C shortcut.<br>Use the toggle button to pause listening.<br><br>Translated segments are exported one after the other automatically.<br>Paste them into your application via the CTRL+V shortcut.<br><br>All the translated text can exported via the Export button.</body></html>";
            JOptionPane.showMessageDialog(this.topui, s);
            MatchBoard mb = this.topui.getMatchBoard();
            if (mb != null) {
                mb.clearMatchBoard();
            }
        }
    }

    public void replaceFile(XliffFile file) {
        FileBody body = file.getBody();
        if (body != null) {
            file.setLastID("0");
            body.setCurrentTU(null);
            String opath = file.getTranslatablePath();
            if (opath != null) {
                File doc;
                Translatable tr = this.topui.getResourceView().getTranslatable(opath);
                if (tr != null) {
                    this.topui.getResourceView().removeTranslatable(tr);
                }
                if ((doc = new File(opath)).exists()) {
                    XliffFile.fileReplacementDir = doc.getParent();
                    doc.delete();
                }
            }
            body.clearFile();
            DashboardView pmview = new DashboardView(this.topui, this, file, true, true);
            this.topui.setDashboard(pmview);
        }
    }

    public void createFile(boolean add) {
        XliffFile file = new XliffFile();
        file.setName("file");
        file.setAttribute("original", "");
        file.setAttribute("source-language", AppPreferences.fileSLang);
        file.setAttribute("target-language", AppPreferences.fileTLang);
        file.setAttribute("datatype", "x-auto");
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String date = sdf.format(cal.getTime()).toString();
        file.setAttribute("date", date);
        file.setAttribute("tool-id", AppPreferences.tool);
        FileHeader header = new FileHeader();
        header.setName("header");
        file.setHeader(header);
        PhaseGroup phasegroup = new PhaseGroup();
        phasegroup.setName("phase-group");
        DefaultXMLElement phase = new DefaultXMLElement();
        phase.setName("phase");
        phase.setAttribute("phase-name", "Default");
        phase.setAttribute("process-name", "Review");
        phasegroup.addChild(phase);
        header.setPhaseGroup(phasegroup);
        DefaultXMLElement tool = new DefaultXMLElement();
        tool.setName("tool");
        tool.setAttribute("tool-id", "CafeTran");
        tool.setAttribute("tool-name", "CafeTran Espresso");
        tool.setAttribute("tool-version", AppPreferences.productID);
        header.addChild(tool);
        FileBody body = new FileBody();
        body.setName("body");
        file.setBody(body);
        DashboardView pmview = new DashboardView(this.topui, this, file, add, false);
        this.topui.setDashboard(pmview);
    }

    public boolean showXLIFFFile(XliffFile file, int mode, boolean isNew) {
        XliffFileEditor dlg = new XliffFileEditor(this.topui, file, mode, isNew, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT CONFIGURATION"));
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = Toolkit.getDefaultToolkit().getScreenSize();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2, (frmSize.height - dlgSize.height) / 2);
        dlg.setVisible(true);
        return dlg.cancelled;
    }

    public void showXLIFF(XLIFF xliff) {
        TargetLanguageSelector dlg = new TargetLanguageSelector(this.topui, "Select a target language", xliff);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = Toolkit.getDefaultToolkit().getScreenSize();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2, (frmSize.height - dlgSize.height) / 2);
        dlg.setVisible(true);
    }

    public void setNotesMenu(JMenu menu, final DefaultXMLElement parent, List notes) {
        if (notes.size() > 0) {
            menu.addSeparator();
            for (DefaultXMLElement c : notes) {
                StringBuffer elem = new StringBuffer();
                elem.append("<html><body width=500>");
                Object o = c.getContent(0);
                if (o != null) {
                    String con = o.toString();
                    con = con.replaceAll("\n", "<br>");
                    elem.append(con);
                } else {
                    elem.append(c.getName());
                }
                elem.append("</body></html>");
                JMenuItem menuNote = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NOTE")){
                    final /* synthetic */ XliffMenu this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        int i;
                        JMenuItem menu = (JMenuItem)a.getSource();
                        DefaultXMLElement c = (DefaultXMLElement)menu.getClientProperty("element");
                        if (c != null && (i = this.this$0.showXMLElement(c)) == 0) {
                            parent.removeChild(c);
                        }
                    }
                });
                menuNote.setText(elem.toString());
                menuNote.putClientProperty("element", c);
                menu.add(menuNote);
            }
        }
    }

    public void setNotesMenu(final XLIFFUnit tu, List notes) {
        if (notes.size() > 0) {
            for (DefaultXMLElement c : notes) {
                StringBuffer elem = new StringBuffer();
                elem.append("<html><body width=500>");
                Object o = c.getContent(0);
                if (o != null) {
                    String con = o.toString();
                    con = con.replaceAll("\n", "<br>");
                    elem.append(con);
                } else {
                    elem.append(c.getName());
                }
                elem.append("</body></html>");
                JMenuItem menuNote = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NOTE")){
                    final /* synthetic */ XliffMenu this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        int i;
                        JMenuItem menu = (JMenuItem)a.getSource();
                        DefaultXMLElement c = (DefaultXMLElement)menu.getClientProperty("element");
                        if (c != null && (i = this.this$0.showXMLElement(c)) == 0) {
                            if (this.this$0.xliff.isExternalToolXLIFF) {
                                List list = this.this$0.xliff.getChildren("doc-info");
                                if (!list.isEmpty()) {
                                    XMLElement docInfo = (XMLElement)list.get(0);
                                    tu.removeMrkTagComment(docInfo);
                                    tu.removeNote(c);
                                    int current = this.this$0.xliff.getView().getCurrentTUIndex();
                                    if (current >= 0) {
                                        this.this$0.xliff.getWorkflow().setCheckStart(current);
                                    }
                                    this.this$0.xliff.getWorkflow().checkNextTU();
                                } else {
                                    tu.removeNote(c);
                                }
                            } else {
                                tu.removeNote(c);
                            }
                        }
                    }
                });
                menuNote.setText(elem.toString());
                menuNote.putClientProperty("element", c);
                this.pop.add(menuNote);
            }
        }
    }

    public void setAltTransMenu(final XLIFFUnit tu, List atrans) {
        if (atrans.size() > 0) {
            int count = 0;
            boolean multi = false;
            if (atrans.size() > 1) {
                multi = true;
            }
            Iterator i = atrans.iterator();
            while (i.hasNext()) {
                ++count;
                JMenu subMenu = null;
                if (multi) {
                    subMenu = new JMenu("A" + count);
                    this.pop.add(subMenu);
                }
                AltTrans alt = (AltTrans)i.next();
                StringBuffer elem = new StringBuffer();
                elem.append("<html><body width=500>");
                if (alt != null) {
                    XMLElement tut = alt.getTarget();
                    if (tut != null) {
                        String con = alt.getTargetText();
                        elem.append(con);
                    }
                } else {
                    elem.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("USE"));
                }
                elem.append("</body></html>");
                JMenuItem menuAltTransUse = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("USE")){
                    final /* synthetic */ XliffMenu this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        String seg;
                        XMLElement tut;
                        JMenuItem item = (JMenuItem)a.getSource();
                        AltTrans alt = (AltTrans)item.getClientProperty("element");
                        if (alt != null && (tut = alt.getTarget()) != null && (seg = alt.getTargetText()) != null) {
                            this.this$0.topui.getTargetPane().setText(seg);
                            tu.removeChild(alt);
                        }
                    }
                });
                menuAltTransUse.putClientProperty("element", alt);
                menuAltTransUse.setText(elem.toString());
                if (subMenu == null) {
                    this.pop.add(menuAltTransUse);
                } else {
                    subMenu.add(menuAltTransUse);
                }
                if (alt.getSource() != null) {
                    JMenuItem menuSource = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SOURCE")){

                        @Override
                        public void actionPerformed(ActionEvent a) {
                            JMenuItem item = (JMenuItem)a.getSource();
                            AltTrans alt = (AltTrans)item.getClientProperty("element");
                            XMLElement tus = alt.getSource();
                            if (tus != null) {
                                XliffMenu.this.showXMLElement(tus);
                            }
                        }
                    });
                    menuSource.putClientProperty("element", alt);
                    if (subMenu == null) {
                        this.pop.add(menuSource);
                    } else {
                        subMenu.add(menuSource);
                    }
                }
                JMenuItem menuTarget = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT")){

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        JMenuItem item = (JMenuItem)a.getSource();
                        AltTrans alt = (AltTrans)item.getClientProperty("element");
                        XMLElement tut = alt.getTarget();
                        if (tut != null) {
                            XliffMenu.this.showXMLElement(tut);
                        }
                    }
                });
                menuTarget.putClientProperty("element", alt);
                if (subMenu == null) {
                    this.pop.add(menuTarget);
                } else {
                    subMenu.add(menuTarget);
                }
                JMenuItem menuAltTransRemove = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE")){
                    final /* synthetic */ XliffMenu this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        JMenuItem item = (JMenuItem)a.getSource();
                        AltTrans alt = (AltTrans)item.getClientProperty("element");
                        if (alt != null) {
                            tu.removeChild(alt);
                        }
                    }
                });
                menuAltTransRemove.putClientProperty("element", alt);
                if (subMenu == null) {
                    this.pop.add(menuAltTransRemove);
                } else {
                    subMenu.add(menuAltTransRemove);
                }
                if (!i.hasNext()) continue;
                this.pop.addSeparator();
            }
        }
    }

    public void showTUPopupMenu(final XLIFFUnit tu) {
        XMLElement target;
        List notes;
        final Proz proz = this.topui.getResourceView().getProzService();
        if (proz != null && proz.isConnected()) {
            JMenuItem askKudoZMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ASK KUDOZ QUESTION"));
            askKudoZMenu.addActionListener(new ActionListener(){
                final /* synthetic */ XliffMenu this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    proz.showAskQuestionForm();
                }
            });
            this.pop.add(askKudoZMenu);
            this.pop.addSeparator();
        }
        JMenuItem addPlaceableItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD SELECTION TO NON-TRANSLATABLE FRAGMENTS"));
        KeyStroke ks = KeyPreferences.getKeyStroke("k21");
        if (ks != null) {
            addPlaceableItem.setAccelerator(ks);
        }
        addPlaceableItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XliffMenu.this.topui.getWorkflowView().addToPlaceables();
            }
        });
        this.pop.add(addPlaceableItem);
        JMenuItem addAbbreviationItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD SELECTION TO ABBREVIATIONS"));
        ks = KeyPreferences.getKeyStroke("k91");
        if (ks != null) {
            addAbbreviationItem.setAccelerator(ks);
        }
        addAbbreviationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XliffMenu.this.topui.getWorkflowView().addAbbreviation();
            }
        });
        this.pop.add(addAbbreviationItem);
        JMenuItem menuBookmark = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BOOKMARK SEGMENT")){
            final /* synthetic */ XliffMenu this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                this.this$0.toggleBookmark(tu);
            }
        });
        this.pop.addSeparator();
        menuBookmark.setAccelerator(KeyStroke.getKeyStroke(66, AppPreferences.modifier));
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_BOOKMARK, (int)menuBookmark.getFont().getSize(), (Color)menuBookmark.getForeground());
        menuBookmark.setIcon((Icon)ficon);
        this.pop.add(menuBookmark);
        JMenuItem menuNewNote = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW NOTE")){
            final /* synthetic */ XliffMenu this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                if (tu != null) {
                    this.this$0.createNote(tu);
                }
            }
        });
        menuNewNote.setAccelerator(KeyStroke.getKeyStroke(78, AppPreferences.modifier));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COMMENT, (int)menuNewNote.getFont().getSize(), (Color)menuNewNote.getForeground());
        menuNewNote.setIcon((Icon)ficon);
        this.pop.add(menuNewNote);
        if (tu != null && !(notes = tu.getNotes()).isEmpty()) {
            this.pop.addSeparator();
            this.setNotesMenu(tu, notes);
            this.pop.addSeparator();
        }
        JMenuItem menuNewAltTrans = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW ALT-TRANS")){
            final /* synthetic */ XliffMenu this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                this.this$0.createAltTrans(tu);
            }
        });
        menuNewAltTrans.setAccelerator(KeyStroke.getKeyStroke(84, AppPreferences.modifier));
        this.pop.add(menuNewAltTrans);
        List atrans = tu.getAltTrans();
        if (!atrans.isEmpty()) {
            this.pop.addSeparator();
            this.setAltTransMenu(tu, atrans);
        }
        if ((target = tu.getTarget()) != null) {
            int state = tu.getState();
            JCheckBoxMenuItem checked = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHECKED SEGMENT"));
            if (state == 1) {
                checked.setSelected(true);
            } else {
                checked.setSelected(false);
            }
            checked.addItemListener(new ItemListener(){
                final /* synthetic */ XliffMenu this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        if (this.this$0.xliff.isCafeTranXLIFF) {
                            tu.getTarget().setAttribute("state", "signed-off");
                        } else if (this.this$0.xliff.isMXLIFF) {
                            tu.setAttribute("m:confirmed", "1");
                        } else if (this.this$0.xliff.isMQXLIFF) {
                            tu.setAttribute("mq:status", "ManuallyConfirmed");
                        } else if (this.this$0.xliff.isStudioXLIFF) {
                            tu.setSDLStatus("Translated");
                        } else if (this.this$0.xliff.isExternalToolXLIFF) {
                            tu.getTarget().setAttribute("state", "signed-off");
                        }
                        tu.setState(1);
                        this.this$0.topui.getTargetView().setTUState(1);
                    } else {
                        if (this.this$0.xliff.isCafeTranXLIFF) {
                            tu.getTarget().setAttribute("state", "new");
                        } else if (this.this$0.xliff.isMXLIFF) {
                            tu.setAttribute("m:confirmed", "0");
                        } else if (this.this$0.xliff.isMQXLIFF) {
                            tu.setAttribute("mq:status", "NotStarted");
                        } else if (this.this$0.xliff.isStudioXLIFF) {
                            tu.setSDLStatus("Draft");
                        } else if (this.this$0.xliff.isExternalToolXLIFF) {
                            tu.getTarget().setAttribute("state", "new");
                        }
                        tu.setState(0);
                        this.this$0.topui.getTargetView().setTUState(0);
                    }
                }
            });
            this.pop.addSeparator();
            this.pop.add(checked);
            JCheckBoxMenuItem locked = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOCKED SEGMENT"));
            locked.setSelected(tu.locked);
            locked.addItemListener(new ItemListener(){
                final /* synthetic */ XliffMenu this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        tu.setLock(true, this.this$0.xliff.isCafeTranXLIFF);
                        this.this$0.topui.getTargetView().setTUState(2);
                    } else if (this.this$0.xliff.isCafeTranXLIFF) {
                        tu.setLock(false, this.this$0.xliff.isCafeTranXLIFF);
                        this.this$0.topui.getTargetView().setTUState(tu.getState());
                    }
                }
            });
            this.pop.add(locked);
        }
        this.pop.addSeparator();
        JCheckBoxMenuItem propagateItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTO-PROPAGATION OF THIS SEGMENT"));
        propagateItem.setSelected(tu.propagate);
        propagateItem.addItemListener(new ItemListener(){
            final /* synthetic */ XliffMenu this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                int state = e.getStateChange();
                if (state == 1) {
                    tu.setPropagation(true, this.this$0.xliff.isCafeTranXLIFF);
                } else {
                    tu.setPropagation(false, this.this$0.xliff.isCafeTranXLIFF);
                }
            }
        });
        this.pop.add(propagateItem);
        JCheckBoxMenuItem propagateForwardOnlyItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTO-PROPAGATION FORWARD ONLY"));
        propagateForwardOnlyItem.setSelected(AppPreferences.propagateForwardOnly);
        propagateForwardOnlyItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int state = e.getStateChange();
                AppPreferences.propagateForwardOnly = state == 1;
            }
        });
        this.pop.add(propagateForwardOnlyItem);
    }

    public void showBUPop(JPopupMenu menu, final BinaryUnit bu) {
        JPopupMenu menuBU = menu;
        JMenuItem menuBULoad = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOAD")){
            final /* synthetic */ XliffMenu this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                FileBody body;
                XliffFile file;
                if (bu != null && (file = this.this$0.xliff.getCurrentFile()) != null && (body = file.getBody()) != null) {
                    this.this$0.topui.getWorkflowView().getWorkflowManager().endTranslation();
                    body.setCurrentBU(bu);
                    this.this$0.project.updateViewMode(AppPreferences.projectView);
                }
            }
        });
        menuBU.add(menuBULoad);
        JMenuItem menuBUEdit = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT")){
            final /* synthetic */ XliffMenu this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                XliffFile file;
                int i;
                if (bu != null && (i = this.this$0.showXMLElement(bu)) == 0 && (file = this.this$0.xliff.getCurrentFile()) != null) {
                    file.getBody().removeBinaryUnit(bu);
                    this.this$0.project.updateViewMode(AppPreferences.projectView);
                }
            }
        });
        menuBU.add(menuBUEdit);
        menuBU.addSeparator();
        JMenu menuNotes = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NOTES"));
        menuBU.add(menuNotes);
        menuNotes.addItemListener(new ItemListener(){
            final /* synthetic */ XliffMenu this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                JMenu menu = (JMenu)e.getItem();
                if (e.getStateChange() == 1) {
                    JMenuItem menuNewNote = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW NOTE")){

                        @Override
                        public void actionPerformed(ActionEvent a) {
                            if (bu != null) {
                                this$0.createNote(bu);
                            }
                        }
                    });
                    FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COMMENT, (int)menuNewNote.getFont().getSize(), (Color)menuNewNote.getForeground());
                    menuNewNote.setIcon((Icon)ficon);
                    menu.add(menuNewNote);
                    if (bu != null) {
                        List notes = bu.getNotes();
                        this.this$0.setNotesMenu(menu, bu, notes);
                    }
                } else if (e.getStateChange() == 2) {
                    menu.removeAll();
                }
            }
        });
    }

    public int showXMLElement(XMLElement elem) {
        XMLElementEditor dlg = new XMLElementEditor(this.topui, elem);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
        return dlg.getStatus();
    }

    public void showPopUp(Component comp, int x, int y, Object o) {
        if (this.pop == null) {
            this.createPopupMenu();
        }
        this.pop.putClientProperty("type", o);
        this.pop.show(comp, x, y);
    }

    private void createPopupMenu() {
        this.pop = new JPopupMenu();
        this.pop.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Object o = XliffMenu.this.pop.getClientProperty("type");
                if (o instanceof XLIFFUnit) {
                    XLIFFUnit tu = (XLIFFUnit)o;
                    XliffMenu.this.showTUPopupMenu(tu);
                } else if (o instanceof BinaryUnit) {
                    BinaryUnit bu = (BinaryUnit)o;
                    XliffMenu.this.showBUPop(XliffMenu.this.pop, bu);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                XliffMenu.this.pop.removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                XliffMenu.this.pop.removeAll();
            }
        });
    }

    void toggleBookmark(XLIFFUnit tu) {
        if (!tu.bookmark) {
            tu.bookmark = true;
            String s = this.xliff.getAttribute("xmlns:property");
            if (s != null) {
                tu.setAttribute("property:bookmark", "true");
            }
        } else {
            LinkedHashMap map;
            tu.bookmark = false;
            String s = this.xliff.getAttribute("xmlns:property");
            if (s != null && (map = tu.getAttributes()) != null) {
                map.remove("property:bookmark");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyDirectory(File sourceLocation, File targetLocation, String lang, List fileFilter) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            File[] files = sourceLocation.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String tname;
                boolean acceptFile;
                File f = files[i];
                String sname = f.getName();
                if (sname.startsWith(".") || sname.startsWith("~") || sname.endsWith(".ini") || sname.trim().length() == 0) continue;
                if (fileFilter != null && fileFilter.size() > 0) {
                    acceptFile = false;
                    Iterator iterator = fileFilter.iterator();
                    while (iterator.hasNext()) {
                        String s = iterator.next().toString().toLowerCase();
                        String lcn = sname.toLowerCase();
                        if (lcn.indexOf(s) == -1) continue;
                        acceptFile = true;
                        break;
                    }
                } else {
                    acceptFile = true;
                }
                if (!acceptFile) continue;
                if (f.isDirectory()) {
                    this.copyDirectory(f, new File(targetLocation.getPath() + AppPreferences.fs + f.getName()), lang, fileFilter);
                    continue;
                }
                int ind = sname.lastIndexOf(".");
                if (ind != -1) {
                    String ext = sname.substring(ind);
                    tname = sname.substring(0, ind) + "_" + lang + ext;
                } else {
                    tname = sname + lang;
                }
                this.copyDirectory(new File(sourceLocation, sname), new File(targetLocation, tname), lang, fileFilter);
            }
            return;
        }
        try {
            FileChannel srcChannel = new FileInputStream(sourceLocation).getChannel();
            FileChannel dstChannel = new FileOutputStream(targetLocation).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
            return;
        }
        catch (IOException e) {
            String m = e.getMessage();
            if (m == null) return;
            JOptionPane.showMessageDialog(this.topui, m, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILE CREATION FAILED!"), 0);
        }
    }

    public void copyFile(String sourceLocation, String targetLocation) throws IOException {
        FileChannel srcChannel = new FileInputStream(sourceLocation).getChannel();
        FileChannel dstChannel = new FileOutputStream(targetLocation).getChannel();
        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        srcChannel.close();
        dstChannel.close();
    }
}

