/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import translator.Abbreviations;
import translator.AppPreferences;
import translator.AssembleParser;
import translator.DefaultXMLElement;
import translator.MainView;
import translator.NumbersHelper;
import translator.Placeables;
import translator.Project;
import translator.ProjectView;
import translator.ResourceView;
import translator.SegmentParser;
import translator.Tag;
import translator.TargetView;
import translator.TrackedChange;
import translator.TrackingChanges;
import translator.Translatable;
import translator.TranslateEvent;
import translator.Workflow;
import translator.WorkflowManager;
import translator.WorkflowView;
import translator.XMLElement;
import translator.XMLHelper;
import translator.tmx.Memory;
import translator.tmx.MemoryView;
import translator.xliff.AltTrans;
import translator.xliff.ContextGroup;
import translator.xliff.FileBody;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffFile;
import translator.xliff.XliffView;

public class XliffWorkflow {
    private MainView topui;
    private ProjectView prview;
    private MemoryView mview;
    private WorkflowView wview;
    private ResourceView rview;
    private Project project;
    private Workflow workflow;
    private XLIFFUnit tucheck;
    private XLIFFUnit tusplit;
    private int checkno = -1;
    private List tunits;
    private XLIFF xliff;
    private int xliffVersion;
    private JProgressBar pb;
    private LinkedHashMap smap;
    private LinkedHashMap tmap;
    private ArrayList hiddenNontransTags;
    private int direction = 0;
    private String firstSourceTag;
    private String firstTargetTag;
    private String lastTargetTag;
    private String lastSourceTag;
    private boolean pretranslationStarted = false;
    private boolean binaryMode = false;
    private boolean clipboardMode = false;
    private boolean noskip;
    private Pattern xtagsPattern;
    private Pattern startTagsPattern;
    private Pattern endTagsPattern;
    private Pattern noLetterPattern;
    private boolean countTargetWords = false;
    private LinkedHashMap xlocksSource;
    private LinkedHashMap xlocksTarget;
    private boolean autoJoin = false;
    private String targetSegmentVersion;
    private boolean isTargetSegEmpty;
    private boolean suspendTagsMerging = false;
    private boolean transferTags = false;
    private boolean lastSegmentTranslated = false;
    private int rangeID = -1;
    private XLIFFUnit virtualTU = null;
    private List joinedTUs = null;
    private boolean virtualJoinWarning = false;
    int stags;
    private boolean endsWithSpace;
    int ttags;

    public XliffWorkflow(MainView topui, Workflow workflow, XLIFF xliff) {
        int m;
        this.topui = topui;
        this.prview = topui.getProjectView();
        this.mview = topui.getMemoryView();
        this.wview = topui.getWorkflowView();
        this.rview = topui.getResourceView();
        this.pb = this.prview.getProgressBar();
        this.project = this.prview.getProject();
        this.smap = new LinkedHashMap();
        this.tmap = new LinkedHashMap();
        this.hiddenNontransTags = new ArrayList();
        this.workflow = workflow;
        this.xliff = xliff;
        this.xliffVersion = xliff.getVersion();
        if (xliff.isExternalToolXLIFF) {
            this.xlocksSource = new LinkedHashMap(1);
            this.xlocksTarget = new LinkedHashMap(1);
        }
        if ((m = workflow.getMode()) == 1) {
            this.clipboardMode = true;
        } else if (m == 2 || m == 3) {
            this.binaryMode = true;
        }
        this.startTagsPattern = Pattern.compile(AppPreferences.startTagRegEx);
        this.endTagsPattern = Pattern.compile(AppPreferences.endTagRegEx);
        this.noLetterPattern = Pattern.compile(AppPreferences.noLettersRegEx);
        this.xtagsPattern = Pattern.compile("<[/]*x.*?\\d+");
    }

    public void setCheckStart(int start) {
        this.checkno = start;
        this.tucheck = null;
        this.direction = 0;
        this.noskip = true;
    }

    public void cancelCheck() {
        this.tucheck = null;
        this.checkno = -1;
        this.direction = 0;
        this.pretranslationStarted = false;
    }

    public void joinTUSource() {
        XLIFFUnit joinTU;
        if (this.tucheck == null || this.project.filter || !this.xliff.isCafeTranXLIFF || this.xliff.isDocumentBilingual) {
            return;
        }
        int fileID = this.tucheck.getFileID();
        XliffFile file = this.xliff.getFile(fileID);
        if (file == null) {
            return;
        }
        int projectID = this.tucheck.getProjectID();
        if (projectID != this.xliff.getID()) {
            return;
        }
        this.noskip = true;
        int index = this.tunits.indexOf(this.tucheck) + 1;
        if (index < this.tunits.size() && (joinTU = (XLIFFUnit)this.tunits.get(index)) != null) {
            if (fileID != joinTU.getFileID()) {
                return;
            }
            XMLElement orgSource = this.tucheck.getSource();
            XMLElement joinSource = joinTU.getSource();
            if (orgSource != null && joinSource != null) {
                List orgSList = orgSource.getChildren();
                List joinSList = joinSource.getChildren();
                if (joinSList.size() > 0) {
                    for (Object object : joinSList) {
                        orgSList.add(object);
                    }
                }
                XLIFFUnit tu1 = joinTU;
                while (tu1 != null) {
                    XLIFFUnit tu2 = tu1.nextTU;
                    if (tu2 != null) {
                        orgSource = tu1.getSource();
                        orgSList = orgSource.getChildren();
                        orgSList.clear();
                        List joinList = tu2.getSource().getChildren();
                        if (joinList.size() > 0) {
                            for (Object object : joinList) {
                                orgSList.add(object);
                            }
                        } else {
                            if (tu1.getTarget().getChildren().size() == 0) {
                                this.removeTU(tu1);
                            }
                            if (tu2.getTarget().getChildren().size() == 0) {
                                this.removeTU(tu2);
                                tu1 = tu2.nextTU;
                            }
                        }
                        tu1 = tu2;
                        continue;
                    }
                    tu1.getSource().getChildren().clear();
                    if (tu1.getTarget().getChildren().size() != 0) break;
                    this.removeTU(tu1);
                    break;
                }
                this.checkno = this.tunits.indexOf(this.tucheck);
                this.direction = 1;
                this.setNextTU();
                this.highlightSegment(false);
                if (this.autoJoin && !this.project.align) {
                    this.autoJoin = false;
                    this.joinTU();
                }
            }
        }
    }

    public void joinTUTarget() {
        XLIFFUnit joinTU;
        if (this.tucheck == null || this.project.filter || !this.xliff.isCafeTranXLIFF || this.xliff.isDocumentBilingual) {
            return;
        }
        int fileID = this.tucheck.getFileID();
        XliffFile file = this.xliff.getFile(fileID);
        if (file == null) {
            return;
        }
        int projectID = this.tucheck.getProjectID();
        if (projectID != this.xliff.getID()) {
            return;
        }
        this.noskip = true;
        int index = this.tunits.indexOf(this.tucheck) + 1;
        if (index < this.tunits.size() && (joinTU = (XLIFFUnit)this.tunits.get(index)) != null) {
            if (fileID != joinTU.getFileID()) {
                return;
            }
            XMLElement orgTarget = this.tucheck.getTarget();
            XMLElement joinTarget = joinTU.getTarget();
            if (orgTarget != null && joinTarget != null) {
                List orgTList = orgTarget.getChildren();
                List joinTList = joinTarget.getChildren();
                if (joinTList.size() > 0) {
                    for (Object object : joinTList) {
                        orgTList.add(object);
                    }
                }
                XLIFFUnit tu1 = joinTU;
                while (tu1 != null) {
                    XLIFFUnit tu2 = tu1.nextTU;
                    if (tu2 != null) {
                        orgTarget = tu1.getTarget();
                        orgTList = orgTarget.getChildren();
                        orgTList.clear();
                        List joinList = tu2.getTarget().getChildren();
                        if (joinList.size() > 0) {
                            for (Object object : joinList) {
                                orgTList.add(object);
                            }
                        } else {
                            if (tu1.getSource().getChildren().size() == 0) {
                                this.removeTU(tu1);
                            }
                            if (tu2.getSource().getChildren().size() == 0) {
                                this.removeTU(tu2);
                                tu2 = tu2.nextTU;
                            }
                        }
                        tu1 = tu2;
                        continue;
                    }
                    tu1.getTarget().getChildren().clear();
                    if (tu1.getSource().getChildren().size() != 0) break;
                    this.removeTU(tu1);
                    break;
                }
                this.checkno = this.tunits.indexOf(this.tucheck);
                this.direction = 1;
                this.setNextTU();
                this.highlightSegment(false);
                if (this.autoJoin && !this.project.align) {
                    this.autoJoin = false;
                    this.joinTU();
                }
            }
        }
    }

    private void prepareTUSplit() {
        List contexts;
        int pid = this.tucheck.getProjectID();
        int fid = this.tucheck.getFileID();
        int uid = this.tucheck.getUnitID();
        int uno = this.tucheck.getUnitNumber();
        XLIFFUnit tunit = new XLIFFUnit(pid, fid, uid, 0);
        tunit.setUnitNumber(uno);
        tunit.setName("trans-unit");
        DefaultXMLElement tus = new DefaultXMLElement();
        tus.setName("source");
        DefaultXMLElement tut = new DefaultXMLElement();
        tut.setName("target");
        String id = this.tucheck.getAttribute("id");
        if (id != null) {
            tunit.setAttribute("id", id + "*");
        }
        if ((contexts = this.tucheck.getContextGroups()) != null) {
            for (ContextGroup cg : contexts) {
                tunit.addChild(cg);
            }
        }
        XMLElement ttus = this.tucheck.getSource();
        XMLElement ttut = this.tucheck.getTarget();
        if (ttus != null) {
            tus.setAttribute("xml:lang", ttus.getAttribute("xml:lang"));
        }
        if (ttut != null) {
            tut.setAttribute("xml:lang", ttut.getAttribute("xml:lang"));
            String state = ttut.getAttribute("state");
            if (state != null) {
                tut.setAttribute("state", state);
            }
            tut.setContent(0, "");
        }
        tunit.setSource(tus);
        tunit.setTarget(tut);
        this.tusplit = tunit;
    }

    public void joinTUVirtual() {
        int index;
        TrackingChanges trackingChanges = this.topui.getTrackingChanges();
        if (this.tucheck == null || this.xliff.isDocumentBilingual || trackingChanges != null) {
            return;
        }
        if (this.tucheck.locked) {
            JOptionPane.showMessageDialog(this.topui, "Locked segment!");
            return;
        }
        if (!this.virtualJoinWarning) {
            JOptionPane.showMessageDialog(this.topui, "Please keep opening and closing tags between joined segments.");
            this.virtualJoinWarning = true;
        }
        if ((index = this.tunits.indexOf(this.tucheck) + 1) < this.tunits.size()) {
            int uid2;
            int uid1;
            XLIFFUnit joinTU = (XLIFFUnit)this.tunits.get(index);
            if (joinTU.locked) {
                JOptionPane.showMessageDialog(this.topui, "Locked segment!");
                return;
            }
            if (this.project.filter && (uid1 = this.tucheck.getUnitID()) != (uid2 = joinTU.getUnitID()) - 1) {
                JOptionPane.showMessageDialog(null, "The segments are not adjacent.");
                return;
            }
            joinTU.join(true);
            XMLElement jsource = null;
            XMLElement jtarget = null;
            if (this.virtualTU == null) {
                Object o1;
                List tl;
                this.tucheck.join(true);
                jsource = new DefaultXMLElement();
                jsource.setName("source");
                jtarget = new DefaultXMLElement();
                jtarget.setName("target");
                XMLElement s1 = this.tucheck.getSource();
                XMLElement s2 = joinTU.getSource();
                List sl = s1.getChildren();
                if (sl != null && sl.size() == 1) {
                    Object o12 = sl.get(0);
                    if (o12 instanceof XMLElement) {
                        jsource.addChild(o12);
                    } else {
                        jsource.addChild(s1);
                    }
                } else {
                    jsource.addChild(s1);
                }
                sl = s2.getChildren();
                if (sl != null && sl.size() == 1) {
                    Object o2 = sl.get(0);
                    if (o2 instanceof XMLElement) {
                        jsource.addChild(o2);
                    } else {
                        jsource.addChild(s2);
                    }
                } else {
                    jsource.addChild(s2);
                }
                XMLElement t1 = this.tucheck.getTarget();
                XMLElement t2 = joinTU.getTarget();
                if (this.tucheck.getTargetText().length() > 0) {
                    tl = t1.getChildren();
                    if (tl != null && tl.size() == 1) {
                        o1 = tl.get(0);
                        if (o1 instanceof XMLElement) {
                            jtarget.addChild(o1);
                        } else {
                            jtarget.addChild(t1);
                        }
                    } else {
                        jtarget.addChild(t1);
                    }
                }
                if (joinTU.getTargetText().length() > 0) {
                    tl = t2.getChildren();
                    if (tl != null && tl.size() == 1) {
                        o1 = tl.get(0);
                        if (o1 instanceof XMLElement) {
                            jtarget.addChild(o1);
                        } else {
                            jtarget.addChild(t2);
                        }
                    } else {
                        jtarget.addChild(t2);
                    }
                }
                this.virtualTU = new XLIFFUnit(this.tucheck.getProjectID(), this.tucheck.getFileID(), this.tucheck.getUnitID(), 1);
                this.virtualTU.setUnitNumber(this.tucheck.getUnitNumber());
                this.virtualTU.setSource(jsource);
                this.virtualTU.setTarget(jtarget);
                this.joinedTUs = new ArrayList(2);
                this.joinedTUs.add(this.tucheck);
                this.joinedTUs.add(joinTU);
            } else {
                jsource = this.virtualTU.getSource();
                jtarget = this.virtualTU.getTarget();
                XMLElement s2 = joinTU.getSource();
                List sl = s2.getChildren();
                if (sl != null && sl.size() == 1) {
                    Object o2 = sl.get(0);
                    if (o2 instanceof XMLElement) {
                        jsource.addChild(o2);
                    } else {
                        jsource.addChild(s2);
                    }
                } else {
                    jsource.addChild(s2);
                }
                XMLElement t2 = joinTU.getTarget();
                if (joinTU.getTargetText().length() > 0) {
                    List tl = t2.getChildren();
                    if (tl != null && tl.size() == 1) {
                        Object o1 = tl.get(0);
                        if (o1 instanceof XMLElement) {
                            jtarget.addChild(o1);
                        } else {
                            jtarget.addChild(t2);
                        }
                    } else {
                        jtarget.addChild(t2);
                    }
                }
                if (this.joinedTUs == null) {
                    this.joinedTUs = new ArrayList(2);
                }
                this.joinedTUs.add(joinTU);
            }
            if (!this.tucheck.propagate) {
                joinTU.setPropagation(this.tucheck.propagate, false);
            }
            this.tucheck = joinTU;
            this.setVirtualTU();
        }
    }

    public void joinTU() {
        if (!this.xliff.isCafeTranXLIFF) {
            this.joinTUVirtual();
            return;
        }
        if (this.tucheck == null || !this.xliff.isCafeTranXLIFF || this.xliff.isDocumentBilingual || this.xliff.isSubtitles || this.xliff.isPO) {
            return;
        }
        int fileID = this.tucheck.getFileID();
        XliffFile file = this.xliff.getFile(fileID);
        if (file == null) {
            return;
        }
        int projectID = this.tucheck.getProjectID();
        if (projectID != this.xliff.getID()) {
            return;
        }
        this.noskip = true;
        int index = this.tunits.indexOf(this.tucheck) + 1;
        if (index < this.tunits.size()) {
            XLIFFUnit joinTU = (XLIFFUnit)this.tunits.get(index);
            if (joinTU != null) {
                int uid2;
                int uid1;
                if (this.project.filter && (uid1 = this.tucheck.getUnitID()) != (uid2 = joinTU.getUnitID()) - 1) {
                    JOptionPane.showMessageDialog(null, "The segments are not adjacent.");
                    return;
                }
                if (fileID != joinTU.getFileID()) {
                    return;
                }
                XMLElement orgSource = this.tucheck.getSource();
                XMLElement orgTarget = this.tucheck.getTarget();
                XMLElement joinSource = joinTU.getSource();
                XMLElement joinTarget = joinTU.getTarget();
                if (orgSource != null && orgTarget != null && joinSource != null && joinTarget != null) {
                    List orgSList = orgSource.getChildren();
                    List orgTList = orgTarget.getChildren();
                    List joinSList = joinSource.getChildren();
                    List joinTList = joinTarget.getChildren();
                    String orglen = orgSource.getAttribute("text:length");
                    String joinlen = joinSource.getAttribute("text:length");
                    String sbreak = joinSource.getAttribute("text:break");
                    if (orglen != null && joinlen != null) {
                        int len = Integer.parseInt(orglen) + Integer.parseInt(joinlen);
                        if (sbreak != null) {
                            len += sbreak.length();
                        }
                        orgSource.setAttribute("text:length", Integer.toString(len));
                    }
                    if (this.project.align) {
                        String orglen2 = orgTarget.getAttribute("text:length");
                        String joinlen2 = joinTarget.getAttribute("text:length");
                        String sbreak2 = joinTarget.getAttribute("text:break");
                        if (orglen2 != null && joinlen2 != null) {
                            int len2 = Integer.parseInt(orglen2) + Integer.parseInt(joinlen2);
                            if (sbreak2 != null) {
                                len2 += sbreak2.length();
                            }
                            orgTarget.setAttribute("text:length", Integer.toString(len2));
                        }
                    }
                    if (joinSList.size() > 0) {
                        if (sbreak != null) {
                            orgSList.add(sbreak);
                        }
                        for (Object object : joinSList) {
                            orgSList.add(object);
                        }
                    }
                    if (joinTList.size() > 0) {
                        if (sbreak != null) {
                            orgTList.add(sbreak);
                        }
                        for (Object object : joinTList) {
                            orgTList.add(object);
                        }
                    }
                    this.tucheck.nextTU = joinTU.nextTU;
                    file.getBody().removeTransUnit(joinTU);
                    if (this.project.glue || this.project.filter) {
                        this.tunits.remove(joinTU);
                    }
                    this.checkno = this.tunits.indexOf(this.tucheck);
                    this.direction = 1;
                    String text = this.workflow.getTarget();
                    boolean targetEmpty = this.isTargetSegmentEmpty();
                    this.setNextTU();
                    int tlen = text.length();
                    if (tlen > 0) {
                        String text2 = this.workflow.getTarget();
                        int tlen2 = text2.length();
                        if (tlen2 == 0) {
                            this.workflow.setTarget(text);
                            this.topui.getTargetPane().setCaretPosition(tlen);
                        } else if (targetEmpty) {
                            this.workflow.setTarget(text + text2);
                            this.topui.getTargetPane().setCaretPosition(tlen + tlen2);
                        }
                    }
                    this.highlightSegment(false);
                    if (this.autoJoin && !this.project.align) {
                        this.autoJoin = false;
                        this.joinTU();
                    }
                }
            }
        } else {
            this.wview.append2();
        }
    }

    public void splitTU() {
        if (this.tucheck == null || !this.xliff.isCafeTranXLIFF || this.xliff.isDocumentBilingual || this.xliff.isSubtitles || this.xliff.isPO) {
            return;
        }
        int index = this.tunits.indexOf(this.tucheck) + 1;
        int index2 = -1;
        List tunits2 = null;
        int fileID = this.tucheck.getFileID();
        XliffFile file = this.xliff.getFile(fileID);
        if (file == null) {
            return;
        }
        tunits2 = file.getBody().getTransUnits();
        index2 = tunits2.indexOf(this.tucheck) + 1;
        XMLElement orgSource = this.tucheck.getSource();
        XMLElement orgTarget = this.tucheck.getTarget();
        if (orgSource != null && orgTarget != null) {
            this.noskip = true;
            String pos = orgSource.getAttribute("text:position");
            String len = orgSource.getAttribute("text:length");
            this.prepareTUSplit();
            String orgSourceString = this.workflow.getSource();
            String orgTargetString = this.workflow.getTarget();
            int scaret = this.topui.getSourcePane().getCaretPosition();
            int tcaret = this.topui.getTargetPane().getCaretPosition();
            if (scaret > 0 && scaret < orgSourceString.length() || this.project.align) {
                boolean ok;
                XMLElement splitSource = this.tusplit.getSource();
                XMLElement splitTarget = this.tusplit.getTarget();
                String newSourceOrg = scaret == 0 ? " " : (scaret == orgSourceString.length() ? orgSourceString : orgSourceString.substring(0, scaret));
                if (this.firstSourceTag != null) {
                    newSourceOrg = this.firstSourceTag + newSourceOrg;
                }
                String newSplitSourceOrg = scaret == orgSourceString.length() ? " " : orgSourceString.substring(scaret);
                if (this.lastSourceTag != null) {
                    newSplitSourceOrg = newSplitSourceOrg + this.lastSourceTag;
                }
                if (!(ok = this.makeSplitTU(orgSource, newSourceOrg))) {
                    return;
                }
                ok = this.makeSplitTU(splitSource, newSplitSourceOrg);
                if (!ok) {
                    return;
                }
                if (len != null && pos != null) {
                    int opos = Integer.parseInt(pos);
                    int nl = this.tucheck.getSourceString().length();
                    int snl = this.tusplit.getSourceString().length();
                    orgSource.setAttribute("text:length", String.valueOf(nl));
                    splitSource.setAttribute("text:position", String.valueOf(opos + nl));
                    splitSource.setAttribute("text:length", String.valueOf(snl));
                }
                if (orgTargetString.length() > 0) {
                    String newTargetOrg = orgTargetString.substring(0, tcaret);
                    if (this.firstTargetTag != null) {
                        newTargetOrg = this.firstTargetTag + newTargetOrg;
                    }
                    String newSplitTargetOrg = orgTargetString.substring(tcaret);
                    if (this.lastTargetTag != null) {
                        newSplitTargetOrg = newSplitTargetOrg + this.lastTargetTag;
                    }
                    if (!(ok = this.makeSplitTU(orgTarget, newTargetOrg))) {
                        return;
                    }
                    ok = this.makeSplitTU(splitTarget, newSplitTargetOrg);
                    if (!ok) {
                        return;
                    }
                    if (this.project.align) {
                        String pos2 = orgTarget.getAttribute("text:position");
                        String len2 = orgTarget.getAttribute("text:length");
                        if (len2 != null && pos2 != null) {
                            int opos = Integer.parseInt(pos2);
                            int nl = this.tucheck.getTargetString().length();
                            int snl = this.tusplit.getTargetString().length();
                            orgTarget.setAttribute("text:length", String.valueOf(nl));
                            splitTarget.setAttribute("text:position", String.valueOf(opos + nl));
                            splitTarget.setAttribute("text:length", String.valueOf(snl));
                        }
                    }
                }
                this.tusplit.previousTU = this.tucheck;
                this.tusplit.nextTU = this.tucheck.nextTU;
                this.tucheck.nextTU = this.tusplit;
                file.getBody().addTransUnit(index2, this.tusplit);
                if (this.project.glue || this.project.filter) {
                    this.tunits.add(index, this.tusplit);
                }
                this.project.resetUnitsIDs();
                this.checkno = this.tunits.indexOf(this.tucheck);
                this.direction = 1;
                this.setNextTU();
                this.highlightSegment(false);
            }
        }
    }

    public void splitTU(int scaret, int tcaret) {
        if (this.tucheck == null || !this.xliff.isCafeTranXLIFF || this.xliff.isDocumentBilingual || this.xliff.isSubtitles || this.xliff.isPO) {
            return;
        }
        int index = this.tunits.indexOf(this.tucheck) + 1;
        int index2 = -1;
        List tunits2 = null;
        int fileID = this.tucheck.getFileID();
        XliffFile file = this.xliff.getFile(fileID);
        if (file == null) {
            return;
        }
        tunits2 = file.getBody().getTransUnits();
        index2 = tunits2.indexOf(this.tucheck) + 1;
        XMLElement orgSource = this.tucheck.getSource();
        XMLElement orgTarget = this.tucheck.getTarget();
        if (orgSource != null && orgTarget != null) {
            this.noskip = true;
            String pos = orgSource.getAttribute("text:position");
            String len = orgSource.getAttribute("text:length");
            this.prepareTUSplit();
            String orgSourceString = this.workflow.getSource();
            String orgTargetString = this.workflow.getTarget();
            if (scaret > 0 && scaret < orgSourceString.length() || this.project.align) {
                boolean ok;
                XMLElement splitSource = this.tusplit.getSource();
                XMLElement splitTarget = this.tusplit.getTarget();
                String newSourceOrg = scaret == 0 ? " " : (scaret == orgSourceString.length() ? orgSourceString : orgSourceString.substring(0, scaret));
                if (this.firstSourceTag != null) {
                    newSourceOrg = this.firstSourceTag + newSourceOrg;
                }
                String newSplitSourceOrg = scaret == orgSourceString.length() ? " " : orgSourceString.substring(scaret);
                if (this.lastSourceTag != null) {
                    newSplitSourceOrg = newSplitSourceOrg + this.lastSourceTag;
                }
                if (!(ok = this.makeSplitTU(orgSource, newSourceOrg))) {
                    return;
                }
                ok = this.makeSplitTU(splitSource, newSplitSourceOrg);
                if (!ok) {
                    return;
                }
                if (len != null && pos != null) {
                    int opos = Integer.parseInt(pos);
                    int nl = this.tucheck.getSourceString().length();
                    int snl = this.tusplit.getSourceString().length();
                    orgSource.setAttribute("text:length", String.valueOf(nl));
                    splitSource.setAttribute("text:position", String.valueOf(opos + nl));
                    splitSource.setAttribute("text:length", String.valueOf(snl));
                }
                if (orgTargetString.length() > 0) {
                    String newTargetOrg = orgTargetString.substring(0, tcaret);
                    if (this.firstTargetTag != null) {
                        newTargetOrg = this.firstTargetTag + newTargetOrg;
                    }
                    String newSplitTargetOrg = orgTargetString.substring(tcaret);
                    if (this.lastTargetTag != null) {
                        newSplitTargetOrg = newSplitTargetOrg + this.lastTargetTag;
                    }
                    if (!(ok = this.makeSplitTU(orgTarget, newTargetOrg))) {
                        return;
                    }
                    ok = this.makeSplitTU(splitTarget, newSplitTargetOrg);
                    if (!ok) {
                        return;
                    }
                    if (this.project.align) {
                        String pos2 = orgTarget.getAttribute("text:position");
                        String len2 = orgTarget.getAttribute("text:length");
                        if (len2 != null && pos2 != null) {
                            int opos = Integer.parseInt(pos2);
                            int nl = this.tucheck.getTargetString().length();
                            int snl = this.tusplit.getTargetString().length();
                            orgTarget.setAttribute("text:length", String.valueOf(nl));
                            splitTarget.setAttribute("text:position", String.valueOf(opos + nl));
                            splitTarget.setAttribute("text:length", String.valueOf(snl));
                        }
                    }
                }
                this.tusplit.previousTU = this.tucheck;
                this.tusplit.nextTU = this.tucheck.nextTU;
                this.tucheck.nextTU = this.tusplit;
                file.getBody().addTransUnit(index2, this.tusplit);
                if (this.project.glue || this.project.filter) {
                    this.tunits.add(index, this.tusplit);
                }
                this.project.resetUnitsIDs();
                this.checkno = this.tunits.indexOf(this.tucheck);
                this.direction = 1;
                this.setNextTU();
                this.highlightSegment(false);
            }
        }
    }

    private String[] getSourceElements(List list, boolean edit) {
        String segTags = "";
        String segTM = "";
        String segGL = "";
        String segAA = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            String aa;
            String m;
            String t;
            Object object = it.next();
            if (object instanceof XMLElement) {
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean editable = true;
                boolean empty = false;
                if (this.xliffVersion == 2) {
                    if (name.equals("cp") || name.equals("ph") || name.equals("sc") || name.equals("ec") || name.equals("sm") || name.equals("em")) {
                        editable = false;
                        empty = true;
                    }
                } else {
                    if (name.equals("bpt") || name.equals("ept") || name.equals("it") || name.equals("ph") || name.equals("bx") || name.equals("ex") || name.equals("x") || name.equals("ut")) {
                        editable = false;
                    }
                    if (name.equals("x") || name.equals("bx") || name.equals("ex")) {
                        empty = true;
                    }
                }
                int tagNo = ++this.stags;
                String tname = "x" + tagNo;
                this.smap.put(tname, object);
                if (name.equals("x")) {
                    String range;
                    String equiv = xml.getAttribute("equiv-text");
                    if (equiv != null && equiv.length() > 0) {
                        if (!this.xliff.isCafeTranXLIFF && equiv.indexOf(38) != -1) {
                            equiv = equiv.replace("&", "");
                        }
                        tname = tname + " equiv-text=\"" + equiv + "\"";
                    }
                    if (this.xliff.isExternalToolXLIFF) {
                        String lock = xml.getAttribute("id");
                        if (lock != null && lock.startsWith("locked")) {
                            this.xlocksSource.put(tname, xml);
                            tname = tname + " lock=\"true\"";
                        }
                    } else if (this.project.getLibreOfficeMode() == 1 && (range = xml.getAttribute("id")) != null && range.length() > 0) {
                        this.rangeID = Integer.parseInt(range);
                    }
                }
                String stag = null;
                String etag = null;
                if (!empty) {
                    stag = "<" + tname + ">";
                    etag = "</" + tname + ">";
                } else {
                    stag = "<" + tname + "/>";
                }
                segTags = segTags + stag;
                String[] arr = this.getSourceElements(li, editable);
                if (arr != null) {
                    segTags = segTags + arr[0];
                    segTM = segTM + arr[1];
                    segGL = segGL + arr[2];
                    segAA = segAA + arr[3];
                    this.endsWithSpace = segGL.length() > 0 && segGL.charAt(segGL.length() - 1) == ' ';
                }
                if (etag == null) continue;
                segTags = segTags + etag;
                continue;
            }
            if (!edit) continue;
            String e = object.toString();
            String[] a = this.findHiddenNonTranslatables(e, true);
            if (a != null) {
                t = a[0];
                m = a[1];
                aa = a[2];
            } else {
                t = e;
                m = e;
                aa = e;
            }
            segGL = !AppPreferences.noWordSeparatorSourceLanguage && !this.xliff.isCafeTranXLIFF && e.length() > 0 && e.charAt(0) != ' ' && !this.endsWithSpace ? segGL + " " + m : segGL + m;
            segTags = segTags + t;
            segTM = segTM + m;
            segAA = segAA + aa;
            if (segGL.length() > 0 && segGL.charAt(segGL.length() - 1) == ' ') {
                this.endsWithSpace = true;
                continue;
            }
            this.endsWithSpace = false;
        }
        String[] sarr = new String[]{segTags, segTM, segGL, segAA};
        return sarr;
    }

    private String[] getTargetElements(List list, boolean edit) {
        String fs = "";
        String es = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                String attr;
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean editable = true;
                boolean empty = false;
                if (this.xliffVersion == 2) {
                    if (name.equals("cp") || name.equals("ph") || name.equals("sc") || name.equals("ec") || name.equals("sm") || name.equals("em")) {
                        editable = false;
                        empty = true;
                    }
                } else {
                    if (name.equals("bpt") || name.equals("ept") || name.equals("it") || name.equals("ph") || name.equals("bx") || name.equals("ex") || name.equals("x") || name.equals("ut")) {
                        editable = false;
                    }
                    if (name.equals("x") || name.equals("bx") || name.equals("ex")) {
                        empty = true;
                    }
                }
                int tagNo = ++this.ttags;
                String tname = "x" + tagNo;
                String tattr = "";
                if (name.equals("x")) {
                    String lock;
                    String equiv = xml.getAttribute("equiv-text");
                    if (equiv != null && equiv.length() > 0) {
                        if (!this.xliff.isCafeTranXLIFF && equiv.indexOf(38) != -1) {
                            equiv = equiv.replace("&", "");
                        }
                        tattr = tattr + " equiv-text=\"" + equiv + "\"";
                    }
                    if (this.xliff.isExternalToolXLIFF && (lock = xml.getAttribute("id")) != null && lock.startsWith("locked")) {
                        this.xlocksTarget.put(tname, xml);
                        tattr = tattr + " lock=\"true\"";
                    }
                } else if (name.equals("mrk") && (attr = xml.getAttribute("mtype")) != null) {
                    if (attr.equals("x-added") || attr.equals("x-sdl-added")) {
                        tattr = tattr + " track=\"added\"";
                        if (AppPreferences.mergeNeighboringTags) {
                            this.suspendTagsMerging = true;
                            AppPreferences.mergeNeighboringTags = false;
                        }
                        tname = "xt" + tagNo;
                        this.addTrackedChange(tname, xml, true);
                    } else if (attr.equals("x-deleted") || attr.equals("x-sdl-deleted")) {
                        tattr = tattr + " track=\"deleted\"";
                        if (AppPreferences.mergeNeighboringTags) {
                            this.suspendTagsMerging = true;
                            AppPreferences.mergeNeighboringTags = false;
                        }
                        tname = "xt" + tagNo;
                        this.addTrackedChange(tname, xml, false);
                    }
                }
                this.tmap.put(tname, object);
                String stag = null;
                String etag = null;
                if (!empty) {
                    stag = "<" + tname + tattr + ">";
                    etag = "</" + tname + ">";
                } else {
                    stag = "<" + tname + tattr + "/>";
                }
                fs = fs + stag;
                String[] arr = this.getTargetElements(li, editable);
                if (arr != null) {
                    fs = fs + arr[0];
                    es = es + arr[1];
                }
                if (etag == null) continue;
                fs = fs + etag;
                continue;
            }
            if (!edit) continue;
            String e = object.toString();
            String[] a = this.findHiddenNonTranslatables(e, false);
            if (a != null) {
                es = es + a[0];
                fs = fs + a[0];
                continue;
            }
            es = es + e;
            fs = fs + e;
        }
        String[] sarr = new String[]{fs, es};
        return sarr;
    }

    private void setVirtualTU() {
        TrackingChanges trackingChanges = this.topui.getTrackingChanges();
        if (trackingChanges != null) {
            trackingChanges.clear();
        }
        if (this.direction == -1) {
            this.checkno += 2;
        }
        if (this.checkno == -1) {
            this.setCheckStart(0);
        }
        this.direction = 1;
        XMLElement jsource = null;
        XMLElement jtarget = null;
        jsource = this.virtualTU.getSource();
        jtarget = this.virtualTU.getTarget();
        this.workflow.setSource("", false);
        this.workflow.setTarget("");
        if (this.xliff.isExternalToolXLIFF) {
            this.xlocksSource.clear();
            this.xlocksTarget.clear();
        }
        XliffView view = this.xliff.getView();
        if (AppPreferences.replaceAndEdit) {
            view.replaceBeforeEdit(this.virtualTU);
        }
        this.tucheck.current = true;
        view.browseToUnit(this.checkno);
        this.tucheck.current = false;
        ++this.checkno;
        if (jsource != null) {
            boolean hasString;
            List slist = jsource.getChildren();
            List tlist = jtarget.getChildren();
            this.smap.clear();
            this.stags = -1;
            this.tmap.clear();
            this.ttags = -1;
            this.hiddenNontransTags.clear();
            this.firstSourceTag = null;
            this.firstTargetTag = null;
            this.lastTargetTag = null;
            this.lastSourceTag = null;
            String[] sarr = this.getSourceElements(slist, true);
            String[] tarr = this.getTargetElements(tlist, true);
            String fsource = sarr[0];
            String ftarget = tarr[0];
            if (ftarget.length() > 0 && !(hasString = XMLHelper.hasStringContent(ftarget))) {
                ftarget = "";
            }
            if (ftarget.length() > 0 && !(hasString = XMLHelper.hasStringContent(ftarget))) {
                ftarget = "";
            }
            if (ftarget.length() == 0 && Abbreviations.endsWithAbbreviation(fsource)) {
                this.autoJoin = true;
            }
            this.isTargetSegEmpty = false;
            if (AppPreferences.mergeNeighboringTags) {
                this.suspendTagsMerging = true;
                AppPreferences.mergeNeighboringTags = false;
            }
            if (!this.autoJoin) {
                this.workflow.setLookupSegments(sarr[1], sarr[2], sarr[3]);
                if (ftarget.length() > 0) {
                    this.countTargetWords = false;
                    this.workflow.setTarget(ftarget);
                    this.workflow.setSource(fsource, AppPreferences.automaticMatching);
                } else {
                    this.countTargetWords = true;
                    String s = this.tucheck.getSegmentUnconfirmed();
                    if (s != null && s.length() > 0) {
                        this.tucheck.setSegmentUnconfirmed(null);
                        this.workflow.setTarget(s);
                    }
                    this.isTargetSegEmpty = true;
                    this.workflow.setSource(fsource, AppPreferences.automaticMatching);
                }
                this.workflow.showfreqWords(fsource, false);
            }
            this.targetSegmentVersion = ftarget;
        }
        if (trackingChanges != null) {
            trackingChanges.track(AppPreferences.recordChanges);
        }
    }

    private void setNextTU() {
        TrackingChanges trackingChanges = this.topui.getTrackingChanges();
        if (trackingChanges != null) {
            trackingChanges.clear();
        }
        this.xliff.saved = false;
        this.workflow.setSource("", false);
        this.workflow.setTarget("");
        boolean isQA = this.project.isQAFilterWorkflow();
        boolean backCheck = false;
        if (this.suspendTagsMerging) {
            AppPreferences.mergeNeighboringTags = true;
        }
        while (this.checkno < this.tunits.size()) {
            Object o;
            if (this.checkno == this.tunits.size() - 1) {
                this.noskip = true;
            }
            if ((o = this.tunits.get(this.checkno)) != null && o instanceof XLIFFUnit) {
                String ts;
                this.tucheck = (XLIFFUnit)o;
                if (this.tucheck.locked && AppPreferences.skipLocked) {
                    this.tucheck = null;
                    ++this.checkno;
                    continue;
                }
                if (!this.tucheck.translate) {
                    this.tucheck = null;
                    ++this.checkno;
                    continue;
                }
                if ((AppPreferences.skipTranslatedJump || AppPreferences.skipTranslated) && !this.noskip && !isQA) {
                    ts = this.tucheck.getTargetText().trim();
                    if (ts.length() > 0) {
                        this.tucheck = null;
                        ++this.checkno;
                        continue;
                    }
                } else {
                    if (AppPreferences.skipPerfectMatches && this.tucheck.getMatch() > 99 && this.tucheck.getMatchType() == 1 && !this.noskip && !isQA) {
                        this.tucheck = null;
                        ++this.checkno;
                        continue;
                    }
                    if (!(!AppPreferences.skipAutoMatches || this.tucheck.getMatchType() != 2 && this.tucheck.getMatchType() != 3 || this.noskip || isQA)) {
                        this.tucheck = null;
                        ++this.checkno;
                        continue;
                    }
                    if (AppPreferences.skipRepetions && this.tucheck.repetition && !this.noskip && !isQA) {
                        ts = this.tucheck.getTargetText().trim();
                        if (ts.length() > 0) {
                            this.tucheck = null;
                            ++this.checkno;
                            continue;
                        }
                    } else {
                        int state;
                        XMLElement tut;
                        if (AppPreferences.skipNoLetters && !this.noskip && !isQA && this.isNoLetterSegment(this.tucheck)) {
                            this.tucheck = null;
                            ++this.checkno;
                            continue;
                        }
                        if (AppPreferences.skipNumbers && this.tucheck.number && !this.noskip && !isQA) {
                            this.tucheck = null;
                            ++this.checkno;
                            continue;
                        }
                        if (!(!AppPreferences.skipReviewedJump && !AppPreferences.skipReviewed || this.noskip || isQA || (tut = this.tucheck.getTarget()) == null || (state = this.tucheck.getState()) != 1 && state != 2)) {
                            this.tucheck = null;
                            ++this.checkno;
                            if (this.checkno < this.tunits.size()) continue;
                            if (!backCheck) {
                                backCheck = true;
                                this.checkno = 0;
                                continue;
                            }
                            this.noskip = true;
                            this.checkno = this.tunits.size() - 1;
                            continue;
                        }
                    }
                }
                if (this.xliff.isExternalToolXLIFF) {
                    String s = this.tucheck.getSourceText();
                    if (s.trim().length() == 0) {
                        this.copySourceToTarget(this.tucheck);
                        this.tucheck = null;
                        ++this.checkno;
                        continue;
                    }
                    this.xlocksSource.clear();
                    this.xlocksTarget.clear();
                }
                this.noskip = false;
                AppPreferences.skipReviewedJump = false;
                AppPreferences.skipTranslatedJump = false;
                this.pb.setValue(this.checkno);
                XliffView view = this.xliff.getView();
                if (AppPreferences.replaceAndEdit) {
                    view.replaceBeforeEdit(this.tucheck);
                }
                this.tucheck.current = true;
                view.browseToUnit(this.checkno);
                this.tucheck.current = false;
                ++this.checkno;
                break;
            }
            this.tucheck = null;
            ++this.checkno;
        }
        if (this.tucheck != null) {
            XMLElement stuv = this.tucheck.getSource();
            XMLElement ttuv = this.tucheck.getTarget();
            if (stuv != null) {
                boolean hasString;
                List slist = stuv.getChildren();
                List tlist = null;
                if (ttuv != null) {
                    tlist = ttuv.getChildren();
                } else {
                    ttuv = new DefaultXMLElement();
                    ttuv.setName("target");
                    if (!this.xliff.isExternalToolXLIFF && !this.xliff.isTXML && this.xliffVersion == 1) {
                        ttuv.setAttribute("state", "new");
                        ttuv.setAttribute("xml:lang", this.xliff.getCurrentFile().getAttribute("target-language"));
                    }
                    this.tucheck.setTarget(ttuv);
                    tlist = ttuv.getChildren();
                }
                this.smap.clear();
                this.stags = -1;
                this.tmap.clear();
                this.ttags = -1;
                this.hiddenNontransTags.clear();
                this.firstSourceTag = null;
                this.firstTargetTag = null;
                this.lastTargetTag = null;
                this.lastSourceTag = null;
                this.rangeID = -1;
                String[] sarr = this.getSourceElements(slist, true);
                String[] tarr = this.getTargetElements(tlist, true);
                String fsource = sarr[0];
                String ftarget = tarr[0];
                boolean isTargetEmpty = false;
                if (!this.xliff.isCafeTranXLIFF) {
                    if (ftarget.length() > 0) {
                        hasString = XMLHelper.hasStringContent(ftarget);
                        if (!hasString) {
                            ftarget = "";
                            isTargetEmpty = true;
                        }
                    } else {
                        isTargetEmpty = true;
                    }
                } else if (tlist.isEmpty()) {
                    isTargetEmpty = true;
                }
                if (AppPreferences.hideBoundaryTags || this.tucheck.first) {
                    int indxs;
                    int exstag;
                    if (isTargetEmpty) {
                        while (fsource.startsWith("<x") && (exstag = this.firstTagsIndex(fsource)) != -1) {
                            this.firstTargetTag = this.firstSourceTag == null ? (this.firstSourceTag = fsource.substring(0, exstag)) : (this.firstSourceTag = this.firstSourceTag + fsource.substring(0, exstag));
                            fsource = fsource.substring(exstag);
                        }
                        while (fsource.trim().endsWith(">") && (indxs = this.lastTagsIndex(fsource)) != -1) {
                            this.lastTargetTag = this.lastSourceTag == null ? (this.lastSourceTag = fsource.substring(indxs)) : (this.lastSourceTag = fsource.substring(indxs) + this.lastSourceTag);
                            fsource = fsource.substring(0, indxs);
                        }
                    } else {
                        while (fsource.startsWith("<x") && ftarget.startsWith("<x")) {
                            exstag = this.firstTagsIndex(fsource);
                            int exttag = this.firstTagsIndex(ftarget);
                            if (exstag == -1 || exttag == -1) break;
                            if (this.firstSourceTag == null && this.firstTargetTag == null) {
                                this.firstSourceTag = fsource.substring(0, exstag);
                                this.firstTargetTag = ftarget.substring(0, exttag);
                            } else {
                                this.firstSourceTag = this.firstSourceTag + fsource.substring(0, exstag);
                                this.firstTargetTag = this.firstTargetTag + ftarget.substring(0, exttag);
                            }
                            fsource = fsource.substring(exstag);
                            ftarget = ftarget.substring(exttag);
                        }
                        if (this.firstSourceTag != null && this.firstTargetTag != null && !this.firstSourceTag.equals(this.firstTargetTag)) {
                            this.firstSourceTag = null;
                            this.firstTargetTag = null;
                            fsource = sarr[0];
                            ftarget = tarr[0];
                        }
                        while (fsource.trim().endsWith(">") && ftarget.trim().endsWith(">")) {
                            indxs = this.lastTagsIndex(fsource);
                            int indxt = this.lastTagsIndex(ftarget);
                            if (indxs == -1 || indxt == -1) break;
                            if (this.lastSourceTag == null && this.lastTargetTag == null) {
                                this.lastSourceTag = fsource.substring(indxs);
                                this.lastTargetTag = ftarget.substring(indxt);
                            } else {
                                this.lastSourceTag = fsource.substring(indxs) + this.lastSourceTag;
                                this.lastTargetTag = ftarget.substring(indxt) + this.lastTargetTag;
                            }
                            fsource = fsource.substring(0, indxs);
                            ftarget = ftarget.substring(0, indxt);
                        }
                        if (this.lastSourceTag != null && this.lastTargetTag != null && !this.lastSourceTag.equals(this.lastTargetTag)) {
                            this.firstSourceTag = null;
                            this.firstTargetTag = null;
                            this.lastSourceTag = null;
                            this.lastTargetTag = null;
                            fsource = sarr[0];
                            ftarget = tarr[0];
                        }
                        if (this.xliff.isUncleaned && this.checkno == this.tunits.size() && this.lastTargetTag == null) {
                            int indxt;
                            while (ftarget.endsWith(">") && (indxt = this.lastTagsIndex(ftarget)) != -1) {
                                this.lastTargetTag = this.lastTargetTag == null ? ftarget.substring(indxt) : ftarget.substring(indxt) + this.lastTargetTag;
                                ftarget = ftarget.substring(0, indxt);
                            }
                        }
                    }
                }
                if (ftarget.length() > 0 && !(hasString = XMLHelper.hasStringContent(ftarget))) {
                    ftarget = "";
                }
                if (ftarget.length() == 0 && Abbreviations.endsWithAbbreviation(fsource)) {
                    this.autoJoin = true;
                }
                this.isTargetSegEmpty = false;
                if (!this.autoJoin) {
                    this.workflow.setLookupSegments(sarr[1], sarr[2], sarr[3]);
                    if (ftarget.length() > 0) {
                        this.countTargetWords = false;
                        this.workflow.setTarget(ftarget);
                        this.workflow.setSource(fsource, AppPreferences.automaticMatching);
                    } else {
                        this.countTargetWords = true;
                        String s = this.tucheck.getSegmentUnconfirmed();
                        if (s != null && s.length() > 0) {
                            this.tucheck.setSegmentUnconfirmed(null);
                            this.workflow.setTarget(s);
                        } else if (AppPreferences.autonumbers && (this.tucheck.number || this.tucheck.numberTagged)) {
                            String fn;
                            String rep;
                            String targetNumber = null;
                            if (AppPreferences.replaceAtTransfer && !(rep = WorkflowView.replaceCharacters(fsource)).equals(fsource)) {
                                targetNumber = rep;
                            }
                            if (AppPreferences.formatnumbers && (fn = NumbersHelper.formatLocaleNumber(fsource)) != null) {
                                targetNumber = fn;
                            }
                            if (targetNumber != null) {
                                this.workflow.setTarget(targetNumber);
                            } else {
                                this.workflow.setTarget(fsource);
                            }
                        }
                        this.isTargetSegEmpty = true;
                        this.workflow.setSource(fsource, AppPreferences.automaticMatching);
                    }
                    this.workflow.showfreqWords(fsource, false);
                    this.topui.getTargetView().setEdited(false);
                }
                this.targetSegmentVersion = ftarget;
            }
        }
        if ((trackingChanges = this.topui.getTrackingChanges()) != null) {
            trackingChanges.track(AppPreferences.recordChanges);
        }
    }

    private void setPrevTU() {
        TrackingChanges trackingChanges = this.topui.getTrackingChanges();
        if (trackingChanges != null) {
            trackingChanges.clear();
        }
        this.xliff.saved = false;
        this.workflow.setSource("", false);
        this.workflow.setTarget("");
        boolean isQA = this.project.isQAFilterWorkflow();
        boolean forwardCheck = false;
        if (this.suspendTagsMerging) {
            AppPreferences.mergeNeighboringTags = true;
        }
        while (this.checkno >= 0) {
            Object o;
            if (this.checkno == 0) {
                this.noskip = true;
            }
            if ((o = this.tunits.get(this.checkno)) != null && o instanceof XLIFFUnit) {
                String ts;
                this.tucheck = (XLIFFUnit)o;
                if (this.tucheck.locked && AppPreferences.skipLocked) {
                    this.tucheck = null;
                    --this.checkno;
                    continue;
                }
                if (!this.tucheck.translate) {
                    this.tucheck = null;
                    --this.checkno;
                    continue;
                }
                if (AppPreferences.skipTranslated && !this.noskip && !isQA) {
                    ts = this.tucheck.getTargetText().trim();
                    if (ts.length() > 0) {
                        this.tucheck = null;
                        --this.checkno;
                        continue;
                    }
                } else {
                    if (AppPreferences.skipPerfectMatches && this.tucheck.getMatch() > 99 && this.tucheck.getMatchType() == 1 && !this.noskip && !isQA) {
                        this.tucheck = null;
                        --this.checkno;
                        continue;
                    }
                    if (!(!AppPreferences.skipAutoMatches || this.tucheck.getMatchType() != 2 && this.tucheck.getMatchType() != 3 || this.noskip || isQA)) {
                        this.tucheck = null;
                        ++this.checkno;
                        continue;
                    }
                    if (AppPreferences.skipRepetions && this.tucheck.repetition && !this.noskip && !isQA) {
                        ts = this.tucheck.getTargetText().trim();
                        if (ts.length() > 0) {
                            this.tucheck = null;
                            --this.checkno;
                            continue;
                        }
                    } else {
                        int state;
                        XMLElement tut;
                        if (AppPreferences.skipNoLetters && !this.noskip && !isQA && this.isNoLetterSegment(this.tucheck)) {
                            this.tucheck = null;
                            --this.checkno;
                            continue;
                        }
                        if (AppPreferences.skipNumbers && this.tucheck.number && !this.noskip && !isQA) {
                            this.tucheck = null;
                            --this.checkno;
                            continue;
                        }
                        if (!(!AppPreferences.skipReviewed || this.noskip || isQA || (tut = this.tucheck.getTarget()) == null || (state = this.tucheck.getState()) != 1 && state != 2)) {
                            this.tucheck = null;
                            --this.checkno;
                            if (this.checkno >= 0) continue;
                            if (!forwardCheck) {
                                forwardCheck = true;
                                this.checkno = this.tunits.size() - 1;
                                continue;
                            }
                            this.noskip = true;
                            this.checkno = 0;
                            continue;
                        }
                    }
                }
                if (this.xliff.isExternalToolXLIFF) {
                    String s = this.tucheck.getSourceText();
                    if (s.trim().length() == 0) {
                        this.copySourceToTarget(this.tucheck);
                        this.tucheck = null;
                        --this.checkno;
                        continue;
                    }
                    this.xlocksSource.clear();
                    this.xlocksTarget.clear();
                }
                this.noskip = false;
                this.pb.setValue(this.checkno);
                XliffView view = this.xliff.getView();
                if (AppPreferences.replaceAndEdit) {
                    view.replaceBeforeEdit(this.tucheck);
                }
                this.tucheck.current = true;
                view.browseToUnit(this.checkno);
                this.tucheck.current = false;
                --this.checkno;
                break;
            }
            this.tucheck = null;
            --this.checkno;
        }
        if (this.tucheck != null) {
            XMLElement stuv = this.tucheck.getSource();
            XMLElement ttuv = this.tucheck.getTarget();
            if (stuv != null) {
                boolean hasString;
                List slist = stuv.getChildren();
                List tlist = null;
                if (ttuv != null) {
                    tlist = ttuv.getChildren();
                } else {
                    ttuv = new DefaultXMLElement();
                    ttuv.setName("target");
                    if (!this.xliff.isExternalToolXLIFF && !this.xliff.isTXML && this.xliffVersion == 1) {
                        ttuv.setAttribute("state", "new");
                        ttuv.setAttribute("xml:lang", this.xliff.getCurrentFile().getAttribute("target-language"));
                    }
                    this.tucheck.setTarget(ttuv);
                    tlist = ttuv.getChildren();
                }
                this.smap.clear();
                this.stags = -1;
                this.tmap.clear();
                this.ttags = -1;
                this.hiddenNontransTags.clear();
                this.firstSourceTag = null;
                this.firstTargetTag = null;
                this.lastTargetTag = null;
                this.lastSourceTag = null;
                this.rangeID = -1;
                String[] sarr = this.getSourceElements(slist, true);
                String[] tarr = this.getTargetElements(tlist, true);
                String fsource = sarr[0];
                String ftarget = tarr[0];
                boolean isTargetEmpty = false;
                if (!this.xliff.isCafeTranXLIFF) {
                    if (ftarget.length() > 0) {
                        hasString = XMLHelper.hasStringContent(ftarget);
                        if (!hasString) {
                            ftarget = "";
                            isTargetEmpty = true;
                        }
                    } else {
                        isTargetEmpty = true;
                    }
                } else if (tlist.isEmpty()) {
                    isTargetEmpty = true;
                }
                if (AppPreferences.hideBoundaryTags || this.tucheck.first) {
                    int indxs;
                    int exstag;
                    if (isTargetEmpty) {
                        while (fsource.startsWith("<x") && (exstag = this.firstTagsIndex(fsource)) != -1) {
                            this.firstTargetTag = this.firstSourceTag == null ? (this.firstSourceTag = fsource.substring(0, exstag)) : (this.firstSourceTag = this.firstSourceTag + fsource.substring(0, exstag));
                            fsource = fsource.substring(exstag);
                        }
                        while (fsource.trim().endsWith(">") && (indxs = this.lastTagsIndex(fsource)) != -1) {
                            this.lastTargetTag = this.lastSourceTag == null ? (this.lastSourceTag = fsource.substring(indxs)) : (this.lastSourceTag = fsource.substring(indxs) + this.lastSourceTag);
                            fsource = fsource.substring(0, indxs);
                        }
                    } else {
                        while (fsource.startsWith("<x") && ftarget.startsWith("<x")) {
                            exstag = this.firstTagsIndex(fsource);
                            int exttag = this.firstTagsIndex(ftarget);
                            if (exstag == -1 || exttag == -1) break;
                            if (this.firstSourceTag == null && this.firstTargetTag == null) {
                                this.firstSourceTag = fsource.substring(0, exstag);
                                this.firstTargetTag = ftarget.substring(0, exttag);
                            } else {
                                this.firstSourceTag = this.firstSourceTag + fsource.substring(0, exstag);
                                this.firstTargetTag = this.firstTargetTag + ftarget.substring(0, exttag);
                            }
                            fsource = fsource.substring(exstag);
                            ftarget = ftarget.substring(exttag);
                        }
                        if (this.firstSourceTag != null && this.firstTargetTag != null && !this.firstSourceTag.equals(this.firstTargetTag)) {
                            this.firstSourceTag = null;
                            this.firstTargetTag = null;
                            fsource = sarr[0];
                            ftarget = tarr[0];
                        }
                        while (fsource.trim().endsWith(">") && ftarget.trim().endsWith(">")) {
                            indxs = this.lastTagsIndex(fsource);
                            int indxt = this.lastTagsIndex(ftarget);
                            if (indxs == -1 || indxt == -1) break;
                            if (this.lastSourceTag == null && this.lastTargetTag == null) {
                                this.lastSourceTag = fsource.substring(indxs);
                                this.lastTargetTag = ftarget.substring(indxt);
                            } else {
                                this.lastSourceTag = fsource.substring(indxs) + this.lastSourceTag;
                                this.lastTargetTag = ftarget.substring(indxt) + this.lastTargetTag;
                            }
                            fsource = fsource.substring(0, indxs);
                            ftarget = ftarget.substring(0, indxt);
                        }
                        if (this.lastSourceTag != null && this.lastTargetTag != null && !this.lastSourceTag.equals(this.lastTargetTag)) {
                            this.firstSourceTag = null;
                            this.firstTargetTag = null;
                            this.lastSourceTag = null;
                            this.lastTargetTag = null;
                            fsource = sarr[0];
                            ftarget = tarr[0];
                        }
                        if (this.xliff.isUncleaned && this.checkno + 2 == this.tunits.size() && this.lastTargetTag == null) {
                            int indxt;
                            while (ftarget.endsWith(">") && (indxt = this.lastTagsIndex(ftarget)) != -1) {
                                this.lastTargetTag = this.lastTargetTag == null ? ftarget.substring(indxt) : ftarget.substring(indxt) + this.lastTargetTag;
                                ftarget = ftarget.substring(0, indxt);
                            }
                        }
                    }
                }
                if (ftarget.length() > 0 && !(hasString = XMLHelper.hasStringContent(ftarget))) {
                    ftarget = "";
                }
                this.workflow.setLookupSegments(sarr[1], sarr[2], sarr[3]);
                this.isTargetSegEmpty = false;
                if (ftarget.length() > 0) {
                    this.countTargetWords = false;
                    this.workflow.setTarget(ftarget);
                    this.workflow.setSource(fsource, AppPreferences.automaticMatching);
                } else {
                    this.countTargetWords = true;
                    String s = this.tucheck.getSegmentUnconfirmed();
                    if (s != null && s.length() > 0) {
                        this.tucheck.setSegmentUnconfirmed(null);
                        this.workflow.setTarget(s);
                    } else if (AppPreferences.autonumbers && (this.tucheck.number || this.tucheck.numberTagged)) {
                        String fn;
                        String rep;
                        String targetNumber = null;
                        if (AppPreferences.replaceAtTransfer && !(rep = WorkflowView.replaceCharacters(fsource)).equals(fsource)) {
                            targetNumber = rep;
                        }
                        if (AppPreferences.formatnumbers && (fn = NumbersHelper.formatLocaleNumber(fsource)) != null) {
                            targetNumber = fn;
                        }
                        if (targetNumber != null) {
                            this.workflow.setTarget(targetNumber);
                        } else {
                            this.workflow.setTarget(fsource);
                        }
                    }
                    this.isTargetSegEmpty = true;
                    this.workflow.setSource(fsource, AppPreferences.automaticMatching);
                }
                this.workflow.showfreqWords(fsource, false);
                this.topui.getTargetView().setEdited(false);
                this.targetSegmentVersion = ftarget;
            }
        }
        if ((trackingChanges = this.topui.getTrackingChanges()) != null) {
            trackingChanges.track(AppPreferences.recordChanges);
        }
    }

    private boolean makeSplitTU(XMLElement elem, String text) {
        if (this.stags >= 0 || this.ttags >= 0) {
            boolean correct = XMLHelper.parseSegment(elem, this.smap, this.tmap, text, true);
            if (!correct) {
                return false;
            }
        } else {
            List list = elem.getChildren();
            list.clear();
            elem.setContent(0, text);
        }
        return true;
    }

    public boolean updateVirtualTU() {
        String source = this.workflow.getSource();
        String target = this.workflow.getTarget();
        if (source.length() > 0 && source.charAt(0) == '?') {
            source = AssembleParser.clearSegmentPattern(source);
            target = AssembleParser.clearSegmentPattern(target);
        } else if (target.length() > 0 && target.charAt(0) == '?') {
            source = AssembleParser.clearSegmentPattern(source);
            target = AssembleParser.clearSegmentPattern(target);
        }
        boolean emptyTarget = false;
        if (target.length() == 0) {
            if (AppPreferences.copysource) {
                target = source;
            } else {
                emptyTarget = true;
            }
        } else if (this.stags >= 0 && (AppPreferences.autoTransferTags || this.transferTags)) {
            target = XMLHelper.tansferMissingTags(source, target);
        }
        if (this.firstSourceTag != null) {
            source = this.firstSourceTag + source;
        }
        if (this.firstTargetTag != null) {
            target = this.firstTargetTag + target;
        }
        if (this.lastSourceTag != null) {
            source = source + this.lastSourceTag;
        }
        if (this.lastTargetTag != null) {
            target = target + this.lastTargetTag;
        }
        XMLElement tarXML = this.virtualTU.getTarget();
        if (this.stags >= 0 || this.ttags >= 0) {
            boolean correct;
            if (this.xliff.isExternalToolXLIFF && this.xlocksSource.size() > 0) {
                Collection xelems;
                Set keys = this.xlocksSource.keySet();
                this.tmap.clear();
                if (!this.xlocksTarget.isEmpty()) {
                    Iterator valuesIterator = this.xlocksTarget.values().iterator();
                    Iterator it = keys.iterator();
                    for (int kindex = 0; it.hasNext() && kindex < this.xlocksTarget.size(); ++kindex) {
                        String s = it.next().toString();
                        it.remove();
                        XMLElement targetLock = (XMLElement)valuesIterator.next();
                        this.tmap.put(s, targetLock);
                    }
                }
                if (!(xelems = this.xlocksSource.values()).isEmpty()) {
                    FileBody body = this.xliff.getCurrentFile().getBody();
                    XMLElement[] xelements = body.createSDLLockedElement(xelems);
                    int xindex = 0;
                    Iterator it = keys.iterator();
                    while (it.hasNext()) {
                        String s = it.next().toString();
                        this.tmap.put(s, xelements[xindex]);
                        ++xindex;
                    }
                }
            }
            if (!(correct = XMLHelper.parseSegment(tarXML, this.smap, this.tmap, target, true))) {
                WorkflowManager man = this.wview.getWorkflowManager();
                man.stopTimer();
                man.standByTimer(false);
                return false;
            }
            if (AppPreferences.editSource) {
                XMLElement srcXML = this.virtualTU.getSource();
                XMLHelper.parseSegment(srcXML, this.smap, this.tmap, source, false);
            }
            if (!WorkflowManager.suspendQATagsCheck) {
                String formatName;
                int j;
                int i = XMLHelper.countTags(source);
                if (!(i == (j = XMLHelper.countTags(target)) || emptyTarget || (formatName = this.xliff.getFormat()).indexOf("Uncleaned") != -1 || formatName.startsWith("Text") || this.xliff.isExternalToolXLIFF)) {
                    WorkflowManager man = this.wview.getWorkflowManager();
                    man.stopTimer();
                    man.standByTimer(false);
                    Object[] options = new String[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOMATIC TRANSFER OF TAGS"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CONTROLLED TRANSFER OF TAGS")};
                    int k = JOptionPane.showOptionDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER SOURCE TAGS TO TARGET. TYPE A TAG NUMBER AND PRESS ESC KEY."), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TAGS QA"), 0, 1, null, options, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CONTROLLED TRANSFER OF TAGS"));
                    if (k == 0) {
                        this.transferTags = true;
                    }
                    return false;
                }
            } else {
                WorkflowManager.suspendQATagsCheck = true;
            }
        } else {
            tarXML.getChildren().clear();
            tarXML.setContent(0, target);
            if (AppPreferences.editSource) {
                XMLElement srcXML = this.virtualTU.getSource();
                srcXML.getChildren().clear();
                srcXML.setContent(0, source);
            }
        }
        TargetView trview = this.topui.getTargetView();
        int state = trview.getTUState();
        if (this.joinedTUs != null) {
            XMLElement vt = this.virtualTU.getTarget();
            List vts = vt.getChildren();
            int i = 0;
            for (Object next : vts) {
                XLIFFUnit ju;
                if (!(next instanceof XMLElement)) continue;
                XMLElement e = (XMLElement)next;
                String n = e.getName();
                if (n.equals("mrk")) {
                    if (i >= this.joinedTUs.size()) continue;
                    ju = (XLIFFUnit)this.joinedTUs.get(i);
                    XMLElement te = ju.getTarget();
                    List ch = te.getChildren();
                    if (ch != null) {
                        ch.clear();
                    }
                    te.addChild(e);
                    ++i;
                    continue;
                }
                if (!n.equals("source") && !n.equals("target") || i >= this.joinedTUs.size()) continue;
                ju = (XLIFFUnit)this.joinedTUs.get(i);
                XMLElement jut = ju.getTarget();
                if (jut != null) {
                    ju.getChildren().remove(jut);
                }
                e.setName("target");
                ju.setTarget(e);
                ++i;
            }
            for (Object next : this.joinedTUs) {
                ((XLIFFUnit)next).join(false);
                if (state == 1) {
                    this.xliff.setStatus((XLIFFUnit)next, 1);
                } else if (state == 2) {
                    this.xliff.setStatus((XLIFFUnit)next, 4);
                }
                if (!this.xliff.isExternalToolXLIFF) continue;
                ((XLIFFUnit)next).updateParentTargetSegment();
            }
            this.joinedTUs.clear();
            this.joinedTUs = null;
        }
        String allsource = this.virtualTU.getSourceText();
        String alltarget = this.virtualTU.getTargetText();
        if (allsource.length() > 0) {
            TranslateEvent event = this.mview.getTranslateEvent();
            if (AppPreferences.fragmentAdjustment && alltarget.length() > 0 && event != null) {
                event.adjustSegmentFragments(allsource, alltarget);
            }
        }
        if (AppPreferences.clipboardTargetSegment) {
            if (!AppPreferences.clipboardHTMLExport) {
                this.topui.getResourceView().addTargetToClipboard(alltarget);
            } else {
                String htmlTarget = this.virtualTU.getTargetXMLText();
                this.topui.getResourceView().addHTMLTargetToClipboard(htmlTarget);
            }
        } else if (this.clipboardMode && this.checkno >= this.tunits.size()) {
            this.project.sendCurrentBlockToClipboard();
        }
        if (this.countTargetWords) {
            this.workflow.updateCount(alltarget);
        }
        this.virtualTU = null;
        return true;
    }

    public boolean updateTU() {
        if (this.virtualTU != null) {
            return this.updateVirtualTU();
        }
        if (this.tucheck != null) {
            String target;
            String source = this.workflow.getSource();
            TrackingChanges trackingChanges = this.topui.getTrackingChanges();
            if (trackingChanges != null) {
                StyledDocument doc = this.workflow.getTargetDocument();
                target = this.setTrackedElements(doc);
            } else {
                target = this.workflow.getTarget();
            }
            if (source.length() > 0 && source.charAt(0) == '?') {
                source = AssembleParser.clearSegmentPattern(source);
                target = AssembleParser.clearSegmentPattern(target);
            } else if (target.length() > 0 && target.charAt(0) == '?') {
                source = AssembleParser.clearSegmentPattern(source);
                target = AssembleParser.clearSegmentPattern(target);
            }
            boolean emptyTarget = false;
            if (target.length() == 0) {
                if (AppPreferences.copysource) {
                    target = source;
                } else {
                    emptyTarget = true;
                }
            } else if (this.stags >= 0 && (this.transferTags || AppPreferences.autoTransferTags)) {
                target = XMLHelper.tansferMissingTags(source, target);
            }
            if (this.firstSourceTag != null) {
                source = this.firstSourceTag + source;
            }
            if (this.firstTargetTag != null) {
                target = this.firstTargetTag + target;
            }
            if (this.lastSourceTag != null) {
                source = source + this.lastSourceTag;
            }
            if (this.lastTargetTag != null) {
                target = target + this.lastTargetTag;
            }
            XMLElement tarXML = this.tucheck.getTarget();
            if (this.stags >= 0 || this.ttags >= 0) {
                boolean correct;
                if (this.xliff.isExternalToolXLIFF && this.xlocksSource.size() > 0) {
                    Collection xelems;
                    FileBody body = this.xliff.getCurrentFile().getBody();
                    Set keys = this.xlocksSource.keySet();
                    this.tmap.clear();
                    if (!this.xlocksTarget.isEmpty()) {
                        Iterator valuesIterator = this.xlocksTarget.values().iterator();
                        Iterator it = keys.iterator();
                        for (int kindex = 0; it.hasNext() && kindex < this.xlocksTarget.size(); ++kindex) {
                            String s = it.next().toString();
                            it.remove();
                            XMLElement targetLock = (XMLElement)valuesIterator.next();
                            this.tmap.put(s, targetLock);
                        }
                    }
                    if (!(xelems = this.xlocksSource.values()).isEmpty()) {
                        XMLElement[] xelements = body.createSDLLockedElement(xelems);
                        int xindex = 0;
                        Iterator it = keys.iterator();
                        while (it.hasNext()) {
                            String s = it.next().toString();
                            this.tmap.put(s, xelements[xindex]);
                            ++xindex;
                        }
                    }
                }
                if (!(correct = XMLHelper.parseSegment(tarXML, this.smap, this.tmap, target, true))) {
                    WorkflowManager man = this.wview.getWorkflowManager();
                    man.stopTimer();
                    man.standByTimer(false);
                    return false;
                }
                if (AppPreferences.editSource) {
                    XMLElement srcXML = this.tucheck.getSource();
                    XMLHelper.parseSegment(srcXML, this.smap, this.tmap, source, false);
                }
                if (!WorkflowManager.suspendQATagsCheck) {
                    String formatName;
                    int j;
                    int i = XMLHelper.countTags(source);
                    if (!(i == (j = XMLHelper.countTags(target)) || emptyTarget || (formatName = this.xliff.getFormat()).indexOf("Uncleaned") != -1 || formatName.startsWith("Text") || this.xliff.isExternalToolXLIFF)) {
                        WorkflowManager man = this.wview.getWorkflowManager();
                        man.stopTimer();
                        man.standByTimer(false);
                        Object[] options = new String[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOMATIC TRANSFER OF TAGS"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CONTROLLED TRANSFER OF TAGS")};
                        int k = JOptionPane.showOptionDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER SOURCE TAGS TO TARGET. TYPE A TAG NUMBER AND PRESS ESC KEY."), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TAGS QA"), 0, 1, null, options, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CONTROLLED TRANSFER OF TAGS"));
                        if (k == 0) {
                            this.transferTags = true;
                        }
                        return false;
                    }
                } else {
                    WorkflowManager.suspendQATagsCheck = true;
                }
            } else {
                tarXML.getChildren().clear();
                tarXML.setContent(0, target);
                if (this.binaryMode) {
                    XMLElement srcXML = this.tucheck.getSource();
                    srcXML.getChildren().clear();
                    if (source.length() > 0) {
                        srcXML.setContent(0, source);
                    } else {
                        srcXML.setContent(0, target);
                    }
                } else if (AppPreferences.editSource) {
                    XMLElement srcXML = this.tucheck.getSource();
                    srcXML.getChildren().clear();
                    srcXML.setContent(0, source);
                }
            }
            TargetView trview = this.topui.getTargetView();
            int state = trview.getTUState();
            if (state == 1) {
                this.xliff.setStatus(this.tucheck, 1);
            } else if (state == 2) {
                this.xliff.setStatus(this.tucheck, 4);
            } else if (state == 3 && this.xliff.isCafeTranXLIFF) {
                String currentTarget = this.workflow.getTarget();
                if (this.targetSegmentVersion != null && this.targetSegmentVersion.length() > 0 && currentTarget.length() > 0 && !currentTarget.equals(this.targetSegmentVersion)) {
                    this.createAltTransForLastVersion();
                }
            } else if (state == 4) {
                this.xliff.setStatus(this.tucheck, 2);
            } else if (state == 5) {
                this.xliff.setStatus(this.tucheck, 3);
            }
            if (trview.isEdited()) {
                boolean storeMatch = false;
                if (this.xliff.isCafeTranXLIFF) {
                    storeMatch = true;
                }
                if (!emptyTarget) {
                    this.tucheck.edited = true;
                    if (AppPreferences.labelHT || AppPreferences.labelEdited) {
                        this.tucheck.removeMatch(false);
                        this.tucheck.setMatch(0, 5, storeMatch);
                    }
                    if (this.xliff.isStudioXLIFF) {
                        this.tucheck.changeSDLMTOrigin();
                    }
                } else {
                    this.tucheck.edited = false;
                    this.tucheck.removeMatch(storeMatch);
                }
            }
            if (this.xliff.isExternalToolXLIFF) {
                this.tucheck.updateParentTargetSegment();
            }
            if (trackingChanges == null) {
                String allsource = this.tucheck.getSourceText();
                String alltarget = this.tucheck.getTargetText();
                if (allsource.length() > 0) {
                    boolean prop = true;
                    if (this.xliff.isUncleaned || !AppPreferences.propagate) {
                        prop = false;
                    }
                    this.xliff.addToMemory(allsource, this.tucheck, prop, true);
                    TranslateEvent event = this.mview.getTranslateEvent();
                    if (AppPreferences.fragmentAdjustment && alltarget.length() > 0 && event != null) {
                        event.adjustSegmentFragments(allsource, alltarget);
                    }
                }
                if (AppPreferences.clipboardTargetSegment) {
                    if (!AppPreferences.clipboardHTMLExport) {
                        this.topui.getResourceView().addTargetToClipboard(alltarget);
                    } else {
                        String htmlTarget = this.tucheck.getTargetXMLText();
                        this.topui.getResourceView().addHTMLTargetToClipboard(htmlTarget);
                    }
                } else if (this.clipboardMode && this.checkno >= this.tunits.size()) {
                    this.project.sendCurrentBlockToClipboard();
                }
                if (this.countTargetWords) {
                    this.workflow.updateCount(alltarget);
                }
            }
        }
        return true;
    }

    private void createAltTransForLastVersion() {
        DefaultXMLElement target = new DefaultXMLElement();
        target.setContent(0, this.targetSegmentVersion);
        target.setName("target");
        AltTrans alt = new AltTrans();
        alt.setName("alt-trans");
        alt.addChild(target);
        this.tucheck.addChild(alt);
    }

    public void checkNextTU() {
        boolean correct;
        XliffFile currentFile = this.xliff.getCurrentFile();
        if (currentFile == null) {
            return;
        }
        boolean filter = false;
        boolean glue = false;
        boolean end = false;
        this.tunits = this.xliff.getView().getFilteredUnits();
        if (this.tunits == null) {
            this.tunits = this.xliff.getView().getGluedUnits();
            if (this.tunits == null) {
                FileBody body = currentFile.getBody();
                this.tunits = body.getTransUnits();
            } else {
                glue = true;
            }
        } else {
            filter = true;
        }
        if (this.tunits.isEmpty()) {
            this.cancelCheck();
            if (this.project.align || this.project.mode == 2) {
                this.wview.getWorkflowManager().setWorkflow(null);
                this.wview.start();
            }
            return;
        }
        this.pb.setMinimum(0);
        this.pb.setMaximum(this.tunits.size());
        if (this.direction == -1) {
            this.checkno += 2;
        }
        if (this.checkno == -1) {
            this.setCheckStart(0);
        }
        this.direction = 1;
        if (!this.pretranslationStarted && !this.topui.getResourceLoader().isStartupLoading()) {
            this.pretranslateInMemories();
        }
        if (!(correct = this.updateTU())) {
            this.workflow.canAppend2 = false;
            return;
        }
        if (this.checkno >= this.tunits.size()) {
            this.pb.setValue(this.pb.getMaximum());
            if (filter || glue) {
                if (this.project.isQAFilterWorkflow()) {
                    if (this.tunits.size() > 0) {
                        XliffView view = this.xliff.getView();
                        view.setLastTU(true);
                        view.browseToUnit(this.tunits.size() - 1);
                    }
                    if (!this.lastSegmentTranslated) {
                        this.wview.end();
                        this.lastSegmentTranslated = true;
                    }
                    return;
                }
                this.checkno = 0;
            } else {
                if (this.project.align || this.project.mode > 1) {
                    if (this.tunits.size() > 0) {
                        XliffView view = this.xliff.getView();
                        view.setLastTU(true);
                        view.browseToUnit(this.tunits.size() - 1);
                    }
                    this.project.cancelReviewMode();
                    String phase = currentFile.getCurrentPhase();
                    if (phase != null && phase.equals("Review") && !this.lastSegmentTranslated) {
                        if (this.project.mode != 3) {
                            this.wview.end();
                        }
                        this.lastSegmentTranslated = true;
                    }
                    return;
                }
                end = true;
                this.checkno = 0;
                this.noskip = true;
            }
        }
        if (!filter) {
            if (!glue && this.xliff.isCafeTranXLIFF) {
                currentFile.setLastID(Integer.toString(this.checkno));
            } else {
                this.xliff.setLastID(Integer.toString(this.checkno));
            }
        }
        this.setNextTU();
        if (this.tucheck != null) {
            int currentID;
            int projectID = this.tucheck.getProjectID();
            if ((filter || glue) && (currentID = this.xliff.getID()) != projectID) {
                this.project.setXLIFF(projectID);
                this.xliff = this.project.getXLIFF();
                this.xliff.saved = false;
                String p = this.xliff.getPath();
                if (p != null) {
                    this.project.setTitleForFile(p);
                }
            }
        }
        if (this.tucheck != null) {
            boolean change;
            XliffFile xfile;
            int fileID = this.tucheck.getFileID();
            if (filter) {
                boolean current = this.xliff.isCurrentFile(fileID);
                if (!current) {
                    xfile = this.xliff.getFile(fileID);
                    if (xfile != null) {
                        this.project.setTitleForFile(xfile.getShortName());
                    }
                } else {
                    this.project.setTitleForFile(this.xliff.getCurrentFile().getShortName());
                }
            } else if (glue && (change = this.xliff.setCurrentFile(fileID)) && (xfile = this.xliff.getCurrentFile()) != null) {
                this.project.setTitleForFile(xfile.getShortName());
            }
            this.highlightSegment(false);
        }
        if (this.autoJoin) {
            this.autoJoin = false;
            this.joinTU();
        }
        if (end && !this.lastSegmentTranslated) {
            if (this.project.mode != 3) {
                this.wview.end();
            }
            this.lastSegmentTranslated = true;
        }
    }

    public void checkPreviousTU() {
        boolean correct;
        XliffFile currentFile = this.xliff.getCurrentFile();
        if (currentFile == null) {
            return;
        }
        boolean filter = false;
        boolean glue = false;
        this.tunits = this.xliff.getView().getFilteredUnits();
        if (this.tunits == null) {
            this.tunits = this.xliff.getView().getGluedUnits();
            if (this.tunits == null) {
                FileBody body = currentFile.getBody();
                this.tunits = body.getTransUnits();
            } else {
                glue = true;
            }
        } else {
            filter = true;
        }
        int size = this.tunits.size();
        if (size == 0) {
            this.cancelCheck();
            if (this.project.align || this.project.mode == 2) {
                this.wview.getWorkflowManager().setWorkflow(null);
                this.wview.start();
            }
            return;
        }
        this.pb.setMinimum(0);
        this.pb.setMaximum(size);
        if (this.direction == 1) {
            this.checkno -= 2;
        }
        this.direction = -1;
        if (!this.pretranslationStarted && !this.topui.getResourceLoader().isStartupLoading()) {
            this.pretranslateInMemories();
        }
        if (!(correct = this.updateTU())) {
            return;
        }
        if (this.checkno < 0) {
            int no = size - 1;
            this.setCheckStart(no);
            this.direction = -1;
        }
        if (!filter) {
            if (!glue && this.xliff.isCafeTranXLIFF) {
                currentFile.setLastID(Integer.toString(this.checkno));
            } else {
                this.xliff.setLastID(Integer.toString(this.checkno));
            }
        }
        this.setPrevTU();
        if (this.tucheck != null) {
            int currentID;
            int projectID = this.tucheck.getProjectID();
            if ((filter || glue) && (currentID = this.xliff.getID()) != projectID) {
                this.project.setXLIFF(projectID);
                this.xliff = this.project.getXLIFF();
                this.xliff.saved = false;
                String p = this.xliff.getPath();
                if (p != null) {
                    this.project.setTitleForFile(p);
                }
            }
        }
        if (this.tucheck != null) {
            boolean change;
            XliffFile xfile;
            int fileID = this.tucheck.getFileID();
            if (filter) {
                boolean current = this.xliff.isCurrentFile(fileID);
                if (!current) {
                    xfile = this.xliff.getFile(fileID);
                    if (xfile != null) {
                        this.project.setTitleForFile(xfile.getShortName());
                    }
                } else {
                    this.project.setTitleForFile(this.xliff.getCurrentFile().getShortName());
                }
            } else if (glue && (change = this.xliff.setCurrentFile(fileID)) && (xfile = this.xliff.getCurrentFile()) != null) {
                this.project.setTitleForFile(xfile.getShortName());
            }
            this.highlightSegment(true);
        }
    }

    public boolean isTargetSegmentEmpty() {
        return this.isTargetSegEmpty;
    }

    public int getCheckTUIndex() {
        return this.checkno;
    }

    public XLIFFUnit getCheckTransUnit() {
        return this.tucheck;
    }

    private int firstTagsIndex(String s) {
        int i = -1;
        Matcher m = this.startTagsPattern.matcher(s);
        boolean b = m.find();
        if (b) {
            i = m.end();
        }
        return i;
    }

    private int lastTagsIndex(String s) {
        int i = -1;
        Matcher m = this.endTagsPattern.matcher(s);
        boolean b = m.find();
        if (b) {
            i = m.start();
        }
        return i;
    }

    public void setPretransationStarted(boolean pstart) {
        this.pretranslationStarted = pstart;
    }

    public boolean pretransationStarted() {
        return this.pretranslationStarted;
    }

    public void pretranslateInMemories() {
        if (this.tunits == null) {
            return;
        }
        int from = this.checkno;
        int to = this.tunits.size();
        List mems = this.mview.getLocalMemories();
        if (mems.size() > 0) {
            this.pretranslationStarted = true;
            for (Object object : mems) {
                final Memory m = (Memory)object;
                if (m.isPretranslateOnly() || m.getWorkflowMode() != 1 || m.isPretranslated()) continue;
                String procName = m.getName() + " - " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRELIMINARY MEMORY MATCHING") + "...";
                m.initMemoryProgress(from, to, procName);
                SegmentParser cparser = m.getTMX().getParser();
                cparser.clearCache();
                this.mview.clearTMPane(m);
                m.setPretranslated(true);
                m.setActive(true);
                SwingWorker worker = new SwingWorker(this){
                    final /* synthetic */ XliffWorkflow this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public String doInBackground() {
                        this.this$0.pretranslate(m);
                        return null;
                    }

                    @Override
                    protected void done() {
                        m.removeMemoryProgress();
                        m.update();
                        m.setActive(false);
                    }
                };
                worker.execute();
            }
        }
    }

    public void pretranslate(Memory ctm) {
        XliffFile currentFile = this.xliff.getCurrentFile();
        if (currentFile == null) {
            return;
        }
        this.tunits = this.xliff.getView().getFilteredUnits();
        if (this.tunits == null) {
            this.tunits = this.xliff.getView().getGluedUnits();
            if (this.tunits == null) {
                FileBody body = currentFile.getBody();
                this.tunits = body.getTransUnits();
            }
        }
        SegmentParser cparser = ctm.getTMX().getParser();
        int from = this.checkno;
        if (from == -1) {
            from = 0;
        }
        try {
            XLIFFUnit[] units = new XLIFFUnit[this.tunits.size() - from];
            int n = 0;
            ListIterator it = this.tunits.listIterator(from);
            while (it.hasNext()) {
                XLIFFUnit u;
                units[n] = u = (XLIFFUnit)it.next();
                ++n;
            }
            for (XLIFFUnit tu : units) {
                if (!ctm.isClosed()) {
                    String cs;
                    if (tu.locked) {
                        ++from;
                        continue;
                    }
                    if (!tu.translate) {
                        ++from;
                        continue;
                    }
                    int state = tu.getState();
                    if (state == 1) {
                        ++from;
                        continue;
                    }
                    String source = tu.getSourceText();
                    if (source.length() > 0 && (cs = cparser.cleanSegment(source)).trim().length() > 0) {
                        cparser.translate(source, cs, tu, true);
                        ctm.update();
                    }
                    if (++from % 10 != 0) continue;
                    ctm.updateMemoryProgress(from, ctm.getName(), true);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.topui, ex.getMessage(), "Pretranslation Error in " + ctm.getName(), 0);
        }
    }

    public void analyse(Memory ctm) {
        XliffFile currentFile = this.xliff.getCurrentFile();
        if (currentFile == null) {
            return;
        }
        List atunits = this.xliff.getView().getFilteredUnits();
        if (atunits == null && (atunits = this.xliff.getView().getGluedUnits()) == null) {
            FileBody body = currentFile.getBody();
            atunits = body.getTransUnits();
        }
        SegmentParser cparser = ctm.getTMX().getParser();
        cparser.setAnalyseMode(true);
        int from = 0;
        try {
            while (from < atunits.size()) {
                Object o = atunits.get(from);
                if (o != null && o instanceof XLIFFUnit) {
                    XLIFFUnit tu = (XLIFFUnit)o;
                    if (tu.locked) {
                        ++from;
                        continue;
                    }
                    if (!tu.translate) {
                        ++from;
                        continue;
                    }
                    int state = tu.getState();
                    if (state == 1) {
                        ++from;
                        continue;
                    }
                    String source = tu.getSourceText();
                    if (source.length() > 0) {
                        cparser.analyse(source, tu);
                    }
                }
                if (++from % 10 != 0) continue;
                ctm.updateMemoryProgress(from, ctm.getName(), false);
            }
            cparser.setAnalyseMode(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void highlightSegment(boolean back) {
        String s;
        if (this.tucheck == null) {
            return;
        }
        int fileID = this.tucheck.getFileID();
        if (AppPreferences.reviewTargetSegments) {
            s = this.tucheck.getTargetText();
            if (s.length() == 0) {
                return;
            }
        } else {
            s = this.workflow.getSegmentForAutoAssembling();
        }
        if (s != null && s.length() > 0) {
            this.rview.realTimeHTMLSourcePreview(s, back);
        }
        if (this.project.mode == 3) {
            return;
        }
        XliffFile xfile = this.xliff.getFile(fileID);
        int libreOfficeMode = this.project.getLibreOfficeMode();
        if (xfile != null && libreOfficeMode == 1) {
            Translatable t = this.project.getTranslatable(xfile);
            if (t != null) {
                t.highlightSegment(this.rangeID, -1, s);
            } else {
                t = this.workflow.getTranslatable();
                if (t != null) {
                    t.highlightSegment(this.rangeID, -1, s);
                } else {
                    t = this.rview.getExternalTranslatable();
                    if (t != null) {
                        t.highlightSegment(this.rangeID, -1, s);
                    }
                }
            }
        } else if (AppPreferences.editorAPI == 1) {
            this.rview.searchInLibreOffice(s, null);
        }
    }

    private void copySourceToTarget(XLIFFUnit tu) {
        block5: {
            XMLElement stuv;
            XMLElement ttuv;
            block4: {
                ttuv = tu.getTarget();
                if (ttuv != null) break block4;
                ttuv = new DefaultXMLElement();
                ttuv.setName("target");
                if (!this.xliff.isExternalToolXLIFF && !this.xliff.isTXML && this.xliffVersion == 1) {
                    ttuv.setAttribute("state", "new");
                    ttuv.setAttribute("xml:lang", this.xliff.getCurrentFile().getAttribute("target-language"));
                }
                tu.setTarget(ttuv);
                XMLElement stuv2 = tu.getSource();
                if (stuv2 == null) break block5;
                List list = stuv2.getChildren();
                for (int i = 0; i < list.size(); ++i) {
                    Object object = list.get(i);
                    ttuv.addChild(object);
                }
                break block5;
            }
            List tch = ttuv.getChildren();
            if (tch.isEmpty() && (stuv = tu.getSource()) != null) {
                List list = stuv.getChildren();
                for (int i = 0; i < list.size(); ++i) {
                    Object object = list.get(i);
                    ttuv.addChild(object);
                }
            }
        }
    }

    private boolean isNoLetterSegment(XLIFFUnit tu) {
        Matcher m;
        boolean b;
        boolean noLetter = false;
        String s = tu.getSourceText();
        if (s != null && (b = (m = this.noLetterPattern.matcher(s)).find())) {
            noLetter = true;
        }
        return noLetter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTagsFormat(String tid) {
        Matcher m;
        if (tid == null) {
            if (this.firstSourceTag == null) return null;
            m = this.xtagsPattern.matcher(this.firstSourceTag);
        } else {
            m = this.xtagsPattern.matcher(tid);
        }
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            Tag tag;
            String id;
            XMLElement elem;
            String name;
            Object ot;
            String s = m.group();
            if (s.startsWith("</") || (ot = this.smap.get(s = s.substring(1))) == null || !(name = (elem = (XMLElement)ot).getName()).equals("g") || (id = elem.getAttribute("id")) == null || (tag = Project.getTag(id)) == null) continue;
            if (tag.isBold()) {
                sb.append("<b>");
            }
            if (tag.isItalic()) {
                sb.append("<i>");
            }
            if (tag.isUnderline()) {
                sb.append("<u>");
            }
            if (tag.isSubscript()) {
                sb.append("<sub>");
            }
            if (!tag.isSuperscript()) continue;
            sb.append("<sup>");
        }
        if (sb.length() <= 0) return null;
        return sb.toString();
    }

    public String getTagsXML(String tid, boolean source) {
        Matcher m = this.xtagsPattern.matcher(tid);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            Object ot;
            boolean endTag = false;
            String s = m.group();
            if (s.startsWith("</")) {
                s = s.substring(2);
                endTag = true;
            } else {
                s = s.substring(1);
            }
            if (source) {
                ot = this.smap.get(s);
            } else {
                ot = this.tmap.get(s);
                if (ot == null) {
                    ot = this.smap.get(s);
                }
            }
            if (ot == null) continue;
            XMLElement elem = (XMLElement)ot;
            String name = elem.getName();
            if (name.equals("ntr")) {
                sb.append(elem.getContent(0));
                continue;
            }
            if (this.xliff.isCafeTranXLIFF) continue;
            sb.append('<');
            if (endTag) {
                sb.append('/');
                sb.append(name);
                sb.append('>');
                continue;
            }
            sb.append(name);
            LinkedHashMap attrMap = elem.getAttributes();
            if (attrMap != null) {
                Set set = attrMap.keySet();
                Iterator i = set.iterator();
                while (i.hasNext()) {
                    sb.append(" ");
                    String s2 = (String)i.next();
                    sb.append(s2);
                    sb.append('=');
                    sb.append('\"');
                    s2 = (String)attrMap.get(s2);
                    sb.append(s2);
                    sb.append('\"');
                }
            }
            sb.append('>');
        }
        return sb.toString();
    }

    public ArrayList getHiddenNontranslatableTags() {
        return this.hiddenNontransTags;
    }

    public void removeTU() {
        List gunits;
        XliffFile currentFile = this.xliff.getCurrentFile();
        if (currentFile == null) {
            return;
        }
        XLIFFUnit prevTU = this.tucheck.previousTU;
        XLIFFUnit nextTU = this.tucheck.nextTU;
        if (prevTU != null) {
            prevTU.nextTU = nextTU;
        }
        if (nextTU != null) {
            nextTU.previousTU = prevTU;
        }
        currentFile.getBody().removeTransUnit(this.tucheck);
        List ftunits = this.xliff.getView().getFilteredUnits();
        if (ftunits != null) {
            ftunits.remove(this.tucheck);
        }
        if ((gunits = this.xliff.getView().getGluedUnits()) != null) {
            gunits.remove(this.tucheck);
        }
        --this.checkno;
        this.checkNextTU();
    }

    private void removeTU(XLIFFUnit removeTU) {
        List gunits;
        XliffFile currentFile = this.xliff.getCurrentFile();
        if (currentFile == null) {
            return;
        }
        XLIFFUnit prevTU = removeTU.previousTU;
        XLIFFUnit nextTU = removeTU.nextTU;
        if (prevTU != null) {
            prevTU.nextTU = nextTU;
        }
        if (nextTU != null) {
            nextTU.previousTU = prevTU;
        }
        currentFile.getBody().removeTransUnit(removeTU);
        List ftunits = this.xliff.getView().getFilteredUnits();
        if (ftunits != null) {
            ftunits.remove(removeTU);
        }
        if ((gunits = this.xliff.getView().getGluedUnits()) != null) {
            gunits.remove(removeTU);
        }
    }

    private String[] findHiddenNonTranslatables(String seg, boolean source) {
        if (AppPreferences.showHiddenPlaceables) {
            return null;
        }
        Set set = Placeables.getPlaceablesSetHidden();
        if (set.isEmpty()) {
            return null;
        }
        String[] arr = null;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Matcher m;
            Pattern p;
            String place = it.next().toString();
            if (place.charAt(0) != '|') {
                int start = seg.indexOf(place);
                if (start == -1) continue;
                p = Placeables.getPlaceablePattern(place);
                if (p == null) {
                    String sp = AppPreferences.noWordSeparatorSourceLanguage || place.length() < 2 ? "\\Q" + place + "\\E" : "\\b\\Q" + place + "\\E\\b";
                    p = Pattern.compile(sp);
                    Placeables.putPlaceablePattern(place, p);
                }
                m = p.matcher(seg);
                while (m.find()) {
                    if (arr == null) {
                        arr = new String[seg.length()];
                    }
                    start = m.start();
                    String s = m.group();
                    String as = arr[start];
                    if (as != null && s.length() <= as.length()) continue;
                    arr[start] = s;
                }
                continue;
            }
            String place2 = place.substring(1);
            p = Placeables.getPlaceablePattern(place);
            if (p == null) {
                p = Pattern.compile(place2);
                Placeables.putPlaceablePattern(place, p);
            }
            m = p.matcher(seg);
            while (m.find()) {
                if (arr == null) {
                    arr = new String[seg.length()];
                }
                int start = m.start();
                String s = m.group();
                String as = arr[start];
                if (as != null && s.length() <= as.length()) continue;
                arr[start] = s;
            }
        }
        if (arr == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        StringBuffer sb3 = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            String ntag;
            String tname;
            int tagNo;
            void string = arr[i];
            if (string == null) {
                sb.append(seg.charAt(i));
                sb2.append(seg.charAt(i));
                sb3.append(seg.charAt(i));
                continue;
            }
            DefaultXMLElement xml = new DefaultXMLElement();
            xml.setName("ntr");
            xml.setContent(0, string);
            if (source) {
                tagNo = ++this.stags;
                tname = "xntr" + tagNo;
                ntag = "<" + tname + "/>";
                sb.append(ntag);
                this.smap.put(tname, xml);
                String[] a = new String[]{string, ntag};
                this.hiddenNontransTags.add(a);
                if (AppPreferences.matchHiddenPlaceables) {
                    sb2.append((String)string);
                }
                sb3.append((String)string);
            } else {
                tagNo = ++this.ttags;
                tname = "xntr" + tagNo;
                ntag = "<" + tname + "/>";
                sb.append(ntag);
                this.tmap.put(tname, xml);
            }
            i = i + string.length() - 1;
        }
        String[] arr2 = new String[]{sb.toString(), sb2.toString(), sb3.toString()};
        return arr2;
    }

    private void addTrackedChange(String id, XMLElement xml, boolean type) {
        TrackedChange tc = new TrackedChange(this.tucheck);
        tc.setElement(xml);
        tc.setID(id);
        tc.setActionType(type);
        Object o = xml.getContent(0);
        String contents = o instanceof String ? (String)xml.getContent(0) : "tag";
        if (type) {
            tc.setChange("+ " + contents);
        } else {
            tc.setChange("- " + contents);
        }
        String revid = xml.getAttribute("sdl:revid");
        if (revid != null) {
            String[] info = this.xliff.getTrackedElementInfo(xml);
            String author = info[0];
            String date = info[1];
            if (author != null) {
                tc.setAuthor(author);
            }
            if (date != null) {
                tc.setDate(date);
            }
        } else {
            String author = xml.getAttribute("ct:author");
            String date = xml.getAttribute("ct:date");
            if (author != null) {
                tc.setAuthor(author);
            }
            if (date != null) {
                tc.setDate(date);
            }
        }
        TrackingChanges trackingChanges = this.topui.getTrackingChanges();
        if (trackingChanges == null) {
            this.topui.setTrackingChanges();
            trackingChanges = this.topui.getTrackingChanges();
        }
        trackingChanges.addChange(tc);
    }

    private String setTrackedElements(StyledDocument doc) {
        try {
            int len = doc.getLength();
            String text = doc.getText(0, len);
            boolean trackTagContents = false;
            int tracking = -1;
            String addTag = " track=\"add\"";
            String delTag = " track=\"delete\"";
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                String n;
                JLabel label;
                String prop;
                int currentTracking = -1;
                Element e = doc.getCharacterElement(i);
                AttributeSet attr = e.getAttributes();
                Object ob = attr.getAttribute(StyleConstants.ComponentAttribute);
                if (ob != null && (prop = (String)(label = (JLabel)ob).getClientProperty("track")) != null) {
                    if (prop.equals("start")) {
                        trackTagContents = true;
                    } else {
                        if (prop.equals("end")) {
                            trackTagContents = false;
                            sb.append(text.charAt(i));
                            tracking = -1;
                            continue;
                        }
                        if (prop.equals("add")) {
                            currentTracking = 0;
                        } else if (prop.equals("delete")) {
                            currentTracking = 1;
                        }
                    }
                }
                if (trackTagContents) {
                    sb.append(text.charAt(i));
                    tracking = -1;
                    continue;
                }
                if (ob == null && attr != null && (n = (String)attr.getAttribute("track")) != null) {
                    if (n.equals("add")) {
                        currentTracking = 0;
                    } else if (n.equals("delete")) {
                        currentTracking = 1;
                    }
                }
                if (tracking != currentTracking) {
                    if (tracking == -1) {
                        XMLElement xe;
                        String t;
                        String name;
                        if (currentTracking == 0) {
                            ++this.ttags;
                            name = "x" + this.ttags;
                            t = "<" + name + addTag + ">";
                            sb.append(t);
                            xe = this.xliff.createTrackedElement(t);
                            if (xe != null) {
                                this.tmap.put(name, xe);
                            }
                        } else if (currentTracking == 1) {
                            ++this.ttags;
                            name = "x" + this.ttags;
                            t = "<" + name + delTag + ">";
                            sb.append(t);
                            xe = this.xliff.createTrackedElement(t);
                            if (xe != null) {
                                this.tmap.put(name, xe);
                            }
                        }
                        sb.append(text.charAt(i));
                    } else {
                        XMLElement xe;
                        String t;
                        String name;
                        String et = "</x" + this.ttags + ">";
                        sb.append(et);
                        if (currentTracking == 0) {
                            ++this.ttags;
                            name = "x" + this.ttags;
                            t = "<" + name + addTag + ">";
                            sb.append(t);
                            xe = this.xliff.createTrackedElement(t);
                            if (xe != null) {
                                this.tmap.put(name, xe);
                            }
                        } else if (currentTracking == 1) {
                            ++this.ttags;
                            name = "x" + this.ttags;
                            t = "<" + name + delTag + ">";
                            sb.append(t);
                            xe = this.xliff.createTrackedElement(t);
                            if (xe != null) {
                                this.tmap.put(name, xe);
                            }
                        }
                        sb.append(text.charAt(i));
                    }
                } else {
                    sb.append(text.charAt(i));
                }
                tracking = currentTracking;
            }
            if (tracking != -1) {
                String et = "</x" + this.ttags + ">";
                sb.append(et);
            }
            return sb.toString();
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }
}

