/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.util.Arrays;
import translator.XMLHelper;

public final class CaseInsensitiveString {
    private char[] charArray;
    private boolean caseSensitive;
    private volatile int hashCode = 0;

    public CaseInsensitiveString(String s, boolean caseSensitive) {
        if (s == null) {
            throw new NullPointerException();
        }
        this.charArray = s.toCharArray();
        this.caseSensitive = caseSensitive;
        this.hashCode = s.toUpperCase().hashCode();
    }

    public boolean equals(Object o) {
        if (!this.caseSensitive) {
            if (o instanceof CaseInsensitiveString) {
                CaseInsensitiveString cs = (CaseInsensitiveString)o;
                char[] arr = cs.toCharArray();
                return XMLHelper.equalsCaseInsensitive(this.charArray, arr);
            }
            return false;
        }
        if (o instanceof CaseInsensitiveString) {
            CaseInsensitiveString cs = (CaseInsensitiveString)o;
            char[] arr = cs.toCharArray();
            return Arrays.equals(this.charArray, arr);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return new String(this.charArray);
    }

    private char[] toCharArray() {
        return this.charArray;
    }
}

