/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileFilters {
    public void setFileFilters(String[] type, String name, JFileChooser chooser) {
        FileFilter[] filters = new FileFilter[type.length];
        FileFilter filter = null;
        for (int i = 0; i < type.length; ++i) {
            filters[i] = new FileFilterFactory(type[i]);
            chooser.addChoosableFileFilter(filters[i]);
            String fname = filters[i].getDescription();
            if (name == null || !name.equals(fname)) continue;
            filter = filters[i];
        }
        if (filter != null) {
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileFilter(filter);
        } else {
            chooser.setAcceptAllFileFilterUsed(true);
        }
    }

    class FileFilterFactory
    extends FileFilter {
        private String description;

        public FileFilterFactory(String d) {
            this.description = d;
        }

        @Override
        public boolean accept(File f) {
            String fname;
            int i;
            if (f.isDirectory()) {
                return true;
            }
            if (this.description.equals("Memories")) {
                String fname2 = f.getName();
                int i2 = fname2.lastIndexOf(46);
                if (i2 != -1) {
                    String ext = fname2.substring(i2);
                    return ext.equalsIgnoreCase(".tmx") || ext.equalsIgnoreCase(".pretranslation") || ext.equalsIgnoreCase(".txt") || ext.equalsIgnoreCase(".sdlppx") || ext.equalsIgnoreCase(".sdltm") || ext.equalsIgnoreCase(".lg") || ext.equalsIgnoreCase(".xlsx") || ext.equalsIgnoreCase(".xml");
                }
            } else if (this.description.indexOf("Project") != -1) {
                String fname3 = f.getName();
                int i3 = fname3.lastIndexOf(46);
                if (i3 != -1) {
                    String ext = fname3.substring(i3);
                    return ext.equalsIgnoreCase(".xlf") || ext.equalsIgnoreCase(".ttx") || ext.equalsIgnoreCase(".tmx") || ext.equalsIgnoreCase(".xliff") || ext.equalsIgnoreCase(".sdlxliff") || ext.equalsIgnoreCase(".ctp") || ext.equalsIgnoreCase(".sdlppx") || ext.equalsIgnoreCase(".mxliff") || ext.equalsIgnoreCase(".mqxliff") || ext.equalsIgnoreCase(".txlf") || ext.equalsIgnoreCase(".txml");
                }
            } else if (this.description.equals("Images")) {
                String fname4 = f.getName();
                int i4 = fname4.lastIndexOf(46);
                if (i4 != -1) {
                    String ext = fname4.substring(i4);
                    return ext.equalsIgnoreCase(".jpg") || ext.equalsIgnoreCase(".jpeg") || ext.equalsIgnoreCase(".png") || ext.equalsIgnoreCase(".bmp") || ext.equalsIgnoreCase(".gif") || ext.equalsIgnoreCase(".tif") || ext.equalsIgnoreCase(".tiff");
                }
            } else if (this.description.equals("HTML") && (i = (fname = f.getName()).lastIndexOf(46)) != -1) {
                String ext = fname.substring(i);
                return ext.equalsIgnoreCase(".html") || ext.equalsIgnoreCase(".HTML");
            }
            return true;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

