/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import translator.AppPreferences;
import translator.MainView;
import translator.Prompter;
import translator.ui.GridPanel;
import translator.ui.HTMLFormat;

final class FontSelector
extends JDialog
implements ActionListener {
    private String[] size = new String[]{"6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50"};
    private String[] styles = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
    private GraphicsEnvironment grEnv;
    private JComboBox fontbox;
    private JComboBox fontstyle;
    private JComboBox fontsize;
    private JButton jb1;
    private JButton jb2;
    private JTextComponent jtextcomp;
    private MainView parent;
    private int target;

    FontSelector(MainView parent, String title, int target) {
        super(parent, title, true);
        this.parent = parent;
        this.target = target;
        this.enableEvents(64L);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        int style;
        String fsize;
        String fname;
        if (this.target == 0) {
            this.jtextcomp = this.parent.getSourcePane();
        } else if (this.target == 1) {
            this.jtextcomp = this.parent.getTargetPane();
        } else if (this.target == 2) {
            this.jtextcomp = this.parent.getProjectView().getProjectPane();
        }
        if (this.jtextcomp != null) {
            fname = this.jtextcomp.getFont().getFamily();
            int size = this.jtextcomp.getFont().getSize();
            fsize = String.valueOf(size);
            style = this.jtextcomp.getFont().getStyle();
        } else if (this.target == 4) {
            fname = AppPreferences.mfontname;
            fsize = String.valueOf(AppPreferences.mfontsize);
            style = AppPreferences.mfontstyle;
        } else if (this.target == 5) {
            fname = AppPreferences.ntfontname;
            fsize = String.valueOf(AppPreferences.ntfontsize);
            style = AppPreferences.ntfontstyle;
        } else if (this.target == 6) {
            fname = AppPreferences.fontname;
            fsize = String.valueOf(AppPreferences.tagsfontsize);
            style = AppPreferences.fontstyle;
        } else if (this.target == 8) {
            fname = AppPreferences.mbfontname;
            fsize = String.valueOf(AppPreferences.mbfontsize);
            style = AppPreferences.mbfontstyle;
        } else if (this.target == 7) {
            fname = AppPreferences.fontname;
            fsize = AppPreferences.UIFontSize > 9 ? String.valueOf(AppPreferences.UIFontSize) : String.valueOf(AppPreferences.toolBarButtonsFontSize);
            style = AppPreferences.fontstyle;
        } else {
            fname = AppPreferences.fontname;
            fsize = String.valueOf(AppPreferences.fontsize);
            style = AppPreferences.fontstyle;
        }
        this.grEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        boolean i = false;
        String[] fonts = this.grEnv.getAvailableFontFamilyNames();
        boolean fontExists = false;
        for (int j = 0; j < fonts.length; ++j) {
            String font = fonts[j];
            if (!font.equalsIgnoreCase(fname)) continue;
            fontExists = true;
            break;
        }
        if (!fontExists) {
            fname = "Dialog";
        }
        this.fontbox = new JComboBox<String>(fonts);
        this.fontstyle = new JComboBox<String>(this.styles);
        this.fontsize = new JComboBox<String>(this.size);
        this.fontbox.setSelectedItem(fname);
        this.fontsize.setSelectedItem(fsize);
        if (style == 0) {
            this.fontstyle.setSelectedItem("Plain");
        } else if (style == 1) {
            this.fontstyle.setSelectedItem("Bold");
        } else if (style == 2) {
            this.fontstyle.setSelectedItem("Italic");
        } else if (style == 3) {
            this.fontstyle.setSelectedItem("Bold Italic");
        }
        this.jb1 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jb2 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jb1.addActionListener(this);
        this.jb2.addActionListener(this);
        JPanel panel1 = new JPanel();
        panel1.setOpaque(false);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout(2));
        panel2.setOpaque(false);
        panel2.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        GridPanel panel3 = new GridPanel();
        panel3.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.setContentPane(panel3);
        panel3.setLayout(new BorderLayout());
        this.setResizable(false);
        if (this.target != 6 && this.target != 7) {
            panel1.add(this.fontbox);
            panel1.add(this.fontstyle);
            panel1.add(this.fontsize);
            panel2.add(this.jb1);
            panel2.add(this.jb2);
            panel3.add((Component)panel1, "North");
            panel3.add((Component)panel2, "South");
        } else {
            panel2.add(this.jb2);
            panel2.add(this.fontsize);
            panel2.add(this.jb1);
            panel3.add((Component)panel2, "Center");
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jb2) {
            this.cancel();
        } else if (e.getSource() == this.jb1) {
            Integer integr = new Integer((String)this.fontsize.getSelectedItem());
            int size = integr;
            String fname = (String)this.fontbox.getSelectedItem();
            String fstyle = (String)this.fontstyle.getSelectedItem();
            int s = -1;
            if (fstyle.equals("Plain")) {
                s = 0;
            } else if (fstyle.equals("Bold")) {
                s = 1;
            } else if (fstyle.equals("Italic")) {
                s = 2;
            } else if (fstyle.equals("Bold Italic")) {
                s = 3;
            }
            Font font = new Font(fname, s, size);
            if (this.jtextcomp != null) {
                String type;
                Prompter ac;
                this.jtextcomp.setFont(font);
                if (this.target == 1 && (ac = this.parent.getSourceView().getPrompter()) != null) {
                    ac.setTableFont(font);
                }
                if ((type = (String)this.jtextcomp.getClientProperty("type")) != null) {
                    if (type.equals("project")) {
                        AppPreferences.pfontname = fname;
                        AppPreferences.pfontsize = font.getSize();
                        AppPreferences.pfontstyle = font.getStyle();
                        HTMLFormat.setStyles();
                    } else if (type.equals("langview")) {
                        AppPreferences.tfontname = fname;
                        AppPreferences.tfontsize = font.getSize();
                        AppPreferences.tfontstyle = font.getStyle();
                    } else if (type.equals("langview2")) {
                        AppPreferences.sfontname = fname;
                        AppPreferences.sfontsize = font.getSize();
                        AppPreferences.sfontstyle = font.getStyle();
                    }
                }
                this.cancel();
            } else if (this.target == 4) {
                AppPreferences.mfontname = fname;
                AppPreferences.mfontsize = font.getSize();
                AppPreferences.mfontstyle = font.getStyle();
                this.cancel();
            } else if (this.target == 5) {
                AppPreferences.ntfontname = fname;
                AppPreferences.ntfontsize = font.getSize();
                AppPreferences.ntfontstyle = font.getStyle();
                this.cancel();
            } else if (this.target == 6) {
                AppPreferences.tagsfontsize = font.getSize();
                this.cancel();
            } else if (this.target == 7) {
                AppPreferences.UIFontSize = font.getSize();
                this.cancel();
                JOptionPane.showMessageDialog(this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RESTART THE PROGRAM TO CHANGE THE PREFERENCE!"));
            } else if (this.target == 8) {
                AppPreferences.mbfontname = fname;
                AppPreferences.mbfontsize = font.getSize();
                AppPreferences.mbfontstyle = font.getStyle();
                HTMLFormat.setStyles();
                this.parent.getMatchBoard().setMatchboardFont(font);
                this.cancel();
            } else {
                AppPreferences.fontname = fname;
                AppPreferences.fontsize = font.getSize();
                AppPreferences.fontstyle = font.getStyle();
                HTMLFormat.setStyles();
                this.parent.getResourceView().setResourcesFont(font);
                this.cancel();
            }
        }
    }
}

