/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import translator.AppPreferences;
import translator.DictionaryResource;
import translator.GlossaryResource;
import translator.KeyPreferences;
import translator.LanguageCodes;
import translator.MainView;
import translator.Project;
import translator.Workflow;
import translator.ui.GridPanel;
import translator.ui.UITools;

public class GlossaryEntryEditor
extends JDialog
implements ActionListener {
    private JPanel jPanel3;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private ArrayList fields;
    private MainView parent;
    private String[] entries;
    private int index;
    private DictionaryResource dictionary;
    private boolean isNewTerm;
    private String[] termArray;
    private String term;

    public GlossaryEntryEditor(MainView ui, DictionaryResource dictionary, String[] entries, String term, int index, boolean isNewTerm) {
        super(ui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TERM EDITOR"), true);
        JLabel label1;
        Font font;
        int i;
        this.parent = ui;
        this.entries = entries;
        this.dictionary = dictionary;
        this.isNewTerm = isNewTerm;
        this.index = index;
        this.term = term;
        Pattern p = Pattern.compile(dictionary.getKeyEntrySeparator(), 16);
        this.termArray = p.split(term);
        ArrayList header = dictionary.getHeader();
        this.jPanel3 = new JPanel();
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new SpringLayout());
        int rows = 0;
        this.fields = new ArrayList(this.termArray.length);
        int k = 0;
        for (i = 0; i < this.termArray.length; ++i) {
            Font font2;
            String s;
            int j;
            JComboBox<Object> box;
            Object[] o;
            JLabel label12;
            String string = this.termArray[i];
            String h = null;
            if (header != null && i < header.size()) {
                h = (String)header.get(i);
                String labelTitle = LanguageCodes.getName(h);
                if (labelTitle != null) {
                    int b = labelTitle.indexOf(40);
                    if (b != -1) {
                        labelTitle = labelTitle.substring(0, b - 1);
                    }
                    label12 = new JLabel(labelTitle + ":");
                } else {
                    label12 = new JLabel(h + ":");
                }
                ++k;
            } else {
                int j2 = i + 1;
                label12 = new JLabel(j2 + ".");
            }
            label12.setHorizontalAlignment(4);
            label12.setFont(label12.getFont().deriveFont(label12.getFont().getStyle(), label12.getFont().getSize() + 2));
            if (h != null && AppPreferences.dbFieldCol.length() > 0 && h.equalsIgnoreCase(AppPreferences.dbFieldCol)) {
                List subjects = Project.getSubjectList();
                if (subjects != null && subjects.size() > 0) {
                    o = subjects.toArray();
                    box = new JComboBox<Object>(o);
                    box.setName("Subject");
                    box.setEditable(true);
                    box.insertItemAt(string, 0);
                    box.setSelectedIndex(0);
                    box.setPreferredSize(new Dimension(800, 34));
                    for (j = 0; j < o.length; ++j) {
                        s = o[j].toString();
                        if (string == null || string.length() <= 0 || !string.equalsIgnoreCase(s)) continue;
                        box.setSelectedItem(string);
                        break;
                    }
                } else {
                    box = new JComboBox();
                    box.setName("Subject");
                    box.setEditable(true);
                    if (string != null && string.length() > 0) {
                        box.insertItemAt(string, 0);
                        box.setSelectedItem(string);
                    }
                }
                font2 = box.getFont();
                box.setFont(new Font(font2.getFamily(), AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
                this.jPanel3.add(label12);
                this.jPanel3.add(box);
                this.fields.add(box);
                ++rows;
                continue;
            }
            if (h != null && AppPreferences.dbClientCol.length() > 0 && h.equalsIgnoreCase(AppPreferences.dbClientCol)) {
                List clients = Project.getClientList();
                if (clients != null && clients.size() > 0) {
                    o = clients.toArray();
                    box = new JComboBox<Object>(o);
                    box.setName("Client");
                    box.setEditable(true);
                    box.insertItemAt(string, 0);
                    box.setSelectedIndex(0);
                    box.setPreferredSize(new Dimension(800, 34));
                    for (j = 0; j < o.length; ++j) {
                        s = o[j].toString();
                        if (string == null || string.length() <= 0 || !string.equalsIgnoreCase(s)) continue;
                        box.setSelectedItem(string);
                        break;
                    }
                } else {
                    box = new JComboBox();
                    box.setName("Client");
                    box.setEditable(true);
                    if (string != null && string.length() > 0) {
                        box.insertItemAt(string, 0);
                        box.setSelectedItem(string);
                    }
                }
                font2 = box.getFont();
                box.setFont(new Font(font2.getFamily(), AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
                this.jPanel3.add(label12);
                this.jPanel3.add(box);
                this.fields.add(box);
                ++rows;
                continue;
            }
            JTextField field = new JTextField(string);
            field.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    GlossaryEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
                }
            });
            field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    GlossaryEntryEditor.this.jButton4.setEnabled(true);
                }
            });
            field.setCaretPosition(0);
            Font font3 = field.getFont();
            field.setFont(new Font(font3.getFamily(), AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
            field.setMargin(new Insets(0, 2, 0, 0));
            field.setPreferredSize(new Dimension(800, 34));
            this.jPanel3.add(label12);
            this.jPanel3.add(field);
            this.fields.add(field);
            ++rows;
        }
        if (header != null) {
            if (header.size() > 2 && header.size() > k) {
                for (i = k; i < header.size(); ++i) {
                    JLabel label13;
                    Font font4;
                    String s;
                    JComboBox<Object> box;
                    Object[] o;
                    String fname = header.get(i).toString();
                    if (AppPreferences.dbFieldCol.length() > 0 && fname.equalsIgnoreCase(AppPreferences.dbFieldCol)) {
                        List subjects = Project.getSubjectList();
                        if (subjects != null && subjects.size() > 0) {
                            o = subjects.toArray();
                            box = new JComboBox<Object>(o);
                            box.setName("Subject");
                            box.setEditable(true);
                            box.insertItemAt("", 0);
                            box.setSelectedIndex(0);
                            box.setPreferredSize(new Dimension(800, 34));
                            for (int j = 0; j < o.length; ++j) {
                                s = o[j].toString();
                                if (AppPreferences.dbField == null || AppPreferences.dbField.length() <= 0 || !AppPreferences.dbField.equalsIgnoreCase(s)) continue;
                                box.setSelectedItem(AppPreferences.dbField);
                                break;
                            }
                        } else {
                            box = new JComboBox();
                            box.setName("Subject");
                            box.setEditable(true);
                            if (AppPreferences.dbField != null && AppPreferences.dbField.length() > 0) {
                                box.setSelectedItem(AppPreferences.dbField);
                            }
                        }
                        font4 = box.getFont();
                        box.setFont(new Font(font4.getFamily(), AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
                        label13 = new JLabel(fname + ":");
                        label13.setHorizontalAlignment(4);
                        label13.setFont(label13.getFont().deriveFont(label13.getFont().getStyle(), label13.getFont().getSize() + 2));
                        this.jPanel3.add(label13);
                        this.jPanel3.add(box);
                        this.fields.add(box);
                        ++rows;
                        continue;
                    }
                    if (AppPreferences.dbClientCol.length() > 0 && fname.equalsIgnoreCase(AppPreferences.dbClientCol)) {
                        List clients = Project.getClientList();
                        if (clients != null && clients.size() > 0) {
                            o = clients.toArray();
                            box = new JComboBox<Object>(o);
                            box.setName("Client");
                            box.setEditable(true);
                            box.insertItemAt("", 0);
                            box.setSelectedIndex(0);
                            box.setPreferredSize(new Dimension(800, 34));
                            for (int j = 0; j < o.length; ++j) {
                                s = o[j].toString();
                                if (AppPreferences.dbUser == null || AppPreferences.dbUser.length() <= 0 || !AppPreferences.dbUser.equalsIgnoreCase(s)) continue;
                                box.setSelectedItem(AppPreferences.dbUser);
                                break;
                            }
                        } else {
                            box = new JComboBox();
                            box.setName("Client");
                            box.setEditable(true);
                            if (AppPreferences.dbUser != null && AppPreferences.dbUser.length() > 0) {
                                box.setSelectedItem(AppPreferences.dbUser);
                            }
                        }
                        font4 = box.getFont();
                        box.setFont(new Font(font4.getFamily(), AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
                        label13 = new JLabel(fname + ":");
                        label13.setHorizontalAlignment(4);
                        label13.setFont(label13.getFont().deriveFont(label13.getFont().getStyle(), label13.getFont().getSize() + 2));
                        this.jPanel3.add(label13);
                        this.jPanel3.add(box);
                        this.fields.add(box);
                        ++rows;
                        continue;
                    }
                    JTextField field = new JTextField();
                    field.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            GlossaryEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
                        }
                    });
                    field.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyTyped(KeyEvent e) {
                            GlossaryEntryEditor.this.jButton4.setEnabled(true);
                        }
                    });
                    field.setCaretPosition(0);
                    font = field.getFont();
                    field.setMargin(new Insets(0, 2, 0, 0));
                    field.setPreferredSize(new Dimension(800, 34));
                    field.setFont(new Font(font.getFamily(), AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
                    label1 = new JLabel(fname + ":");
                    label1.setHorizontalAlignment(4);
                    label1.setFont(label1.getFont().deriveFont(font.getStyle(), label1.getFont().getSize() + 2));
                    this.jPanel3.add(label1);
                    this.jPanel3.add(field);
                    this.fields.add(field);
                    ++rows;
                }
            }
        } else if (this.termArray.length == 2) {
            JLabel label14;
            Font font5;
            JTextField field;
            String s;
            JComboBox<Object> box;
            Object[] o;
            String fieldName = null;
            if (AppPreferences.dbClientCol.length() > 0) {
                fieldName = AppPreferences.dbClientCol;
            }
            if (fieldName != null) {
                List clients = Project.getClientList();
                if (clients != null && clients.size() > 0) {
                    o = clients.toArray();
                    box = new JComboBox<Object>(o);
                    box.setName("Client");
                    box.setEditable(true);
                    box.insertItemAt("", 0);
                    box.setSelectedIndex(0);
                    box.setPreferredSize(new Dimension(800, 34));
                    for (int i2 = 0; i2 < o.length; ++i2) {
                        s = o[i2].toString();
                        if (AppPreferences.dbUser == null || AppPreferences.dbUser.length() <= 0 || !AppPreferences.dbUser.equalsIgnoreCase(s)) continue;
                        box.setSelectedItem(AppPreferences.dbUser);
                        break;
                    }
                } else {
                    box = new JComboBox();
                    box.setName("Client");
                    box.setEditable(true);
                    if (AppPreferences.dbUser != null && AppPreferences.dbUser.length() > 0) {
                        box.setSelectedItem(AppPreferences.dbUser);
                    }
                }
                font = box.getFont();
                box.setFont(new Font(font.getFamily(), AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
                label1 = new JLabel(fieldName + ":");
                label1.setHorizontalAlignment(4);
                label1.setFont(label1.getFont().deriveFont(label1.getFont().getStyle(), label1.getFont().getSize() + 2));
                this.jPanel3.add(label1);
                this.jPanel3.add(box);
                this.fields.add(box);
                ++rows;
            }
            fieldName = null;
            if (AppPreferences.dbFieldCol.length() > 0) {
                fieldName = AppPreferences.dbFieldCol;
            }
            if (fieldName != null) {
                List subjects = Project.getSubjectList();
                if (subjects != null && subjects.size() > 0) {
                    o = subjects.toArray();
                    box = new JComboBox<Object>(o);
                    box.setName("Subject");
                    box.setEditable(true);
                    box.insertItemAt("", 0);
                    box.setSelectedIndex(0);
                    box.setPreferredSize(new Dimension(800, 34));
                    for (int i3 = 0; i3 < o.length; ++i3) {
                        s = o[i3].toString();
                        if (AppPreferences.dbField == null || AppPreferences.dbField.length() <= 0 || !AppPreferences.dbField.equalsIgnoreCase(s)) continue;
                        box.setSelectedItem(AppPreferences.dbField);
                        break;
                    }
                } else {
                    box = new JComboBox();
                    box.setName("Subject");
                    box.setEditable(true);
                    if (AppPreferences.dbField != null && AppPreferences.dbField.length() > 0) {
                        box.setSelectedItem(AppPreferences.dbField);
                    }
                }
                font = box.getFont();
                box.setFont(new Font(font.getFamily(), AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
                JLabel label15 = new JLabel(fieldName + ":");
                label15.setHorizontalAlignment(4);
                label15.setFont(label15.getFont().deriveFont(label15.getFont().getStyle(), label15.getFont().getSize() + 2));
                this.jPanel3.add(label15);
                this.jPanel3.add(box);
                this.fields.add(box);
                ++rows;
            }
            fieldName = null;
            if (AppPreferences.dbNotesCol.length() > 0) {
                fieldName = AppPreferences.dbNotesCol;
            }
            if (fieldName != null) {
                field = new JTextField();
                field.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        GlossaryEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
                    }
                });
                field.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        GlossaryEntryEditor.this.jButton4.setEnabled(true);
                    }
                });
                field.setCaretPosition(0);
                font5 = field.getFont();
                field.setMargin(new Insets(0, 2, 0, 0));
                field.setPreferredSize(new Dimension(800, 34));
                field.setFont(new Font(font5.getFamily(), AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
                label14 = new JLabel(fieldName + ":");
                label14.setHorizontalAlignment(4);
                label14.setFont(label14.getFont().deriveFont(label14.getFont().getStyle(), label14.getFont().getSize() + 2));
                this.jPanel3.add(label14);
                this.jPanel3.add(field);
                this.fields.add(field);
                ++rows;
            }
            fieldName = null;
            if (AppPreferences.dbURLCol.length() > 0) {
                fieldName = AppPreferences.dbURLCol;
            }
            if (fieldName != null) {
                field = new JTextField();
                field.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        GlossaryEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
                    }
                });
                field.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        GlossaryEntryEditor.this.jButton4.setEnabled(true);
                    }
                });
                field.setCaretPosition(0);
                font5 = field.getFont();
                field.setMargin(new Insets(0, 2, 0, 0));
                field.setPreferredSize(new Dimension(800, 34));
                field.setFont(new Font(font5.getFamily(), AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
                label14 = new JLabel(fieldName + ":");
                label14.setHorizontalAlignment(4);
                label14.setFont(label14.getFont().deriveFont(label14.getFont().getStyle(), label14.getFont().getSize() + 2));
                this.jPanel3.add(label14);
                this.jPanel3.add(field);
                this.fields.add(field);
                ++rows;
            }
            fieldName = null;
            if (AppPreferences.dbContextCol.length() > 0) {
                fieldName = AppPreferences.dbContextCol;
            }
            if (fieldName != null) {
                field = new JTextField();
                field.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        GlossaryEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
                    }
                });
                field.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        GlossaryEntryEditor.this.jButton4.setEnabled(true);
                    }
                });
                field.setCaretPosition(0);
                font5 = field.getFont();
                field.setMargin(new Insets(0, 2, 0, 0));
                field.setPreferredSize(new Dimension(800, 34));
                field.setFont(new Font(font5.getFamily(), AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
                label14 = new JLabel(fieldName + ":");
                label14.setHorizontalAlignment(4);
                label14.setFont(label14.getFont().deriveFont(label14.getFont().getStyle(), label14.getFont().getSize() + 2));
                this.jPanel3.add(label14);
                this.jPanel3.add(field);
                this.fields.add(field);
                ++rows;
            }
            fieldName = null;
            if (AppPreferences.dbUser1Col.length() > 0) {
                fieldName = AppPreferences.dbUser1Col;
            }
            if (fieldName != null) {
                field = new JTextField();
                field.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        GlossaryEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
                    }
                });
                field.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        GlossaryEntryEditor.this.jButton4.setEnabled(true);
                    }
                });
                field.setCaretPosition(0);
                font5 = field.getFont();
                field.setMargin(new Insets(0, 2, 0, 0));
                field.setPreferredSize(new Dimension(800, 34));
                field.setFont(new Font(font5.getFamily(), AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
                label14 = new JLabel(fieldName + ":");
                label14.setHorizontalAlignment(4);
                label14.setFont(label14.getFont().deriveFont(label14.getFont().getStyle(), label14.getFont().getSize() + 2));
                this.jPanel3.add(label14);
                this.jPanel3.add(field);
                this.fields.add(field);
                ++rows;
            }
            fieldName = null;
            if (AppPreferences.dbUser2Col.length() > 0) {
                fieldName = AppPreferences.dbUser2Col;
            }
            if (fieldName != null) {
                field = new JTextField();
                field.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        GlossaryEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
                    }
                });
                field.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        GlossaryEntryEditor.this.jButton4.setEnabled(true);
                    }
                });
                field.setCaretPosition(0);
                font5 = field.getFont();
                field.setMargin(new Insets(0, 2, 0, 0));
                field.setPreferredSize(new Dimension(800, 34));
                field.setFont(new Font(font5.getFamily(), AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
                label14 = new JLabel(fieldName + ":");
                label14.setHorizontalAlignment(4);
                label14.setFont(label14.getFont().deriveFont(label14.getFont().getStyle(), label14.getFont().getSize() + 2));
                this.jPanel3.add(label14);
                this.jPanel3.add(field);
                this.fields.add(field);
                ++rows;
            }
            fieldName = null;
            if (AppPreferences.dbUser3Col.length() > 0) {
                fieldName = AppPreferences.dbUser3Col;
            }
            if (fieldName != null) {
                field = new JTextField();
                field.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        GlossaryEntryEditor.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
                    }
                });
                field.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        GlossaryEntryEditor.this.jButton4.setEnabled(true);
                    }
                });
                field.setCaretPosition(0);
                font5 = field.getFont();
                field.setMargin(new Insets(0, 2, 0, 0));
                field.setPreferredSize(new Dimension(800, 34));
                field.setFont(new Font(font5.getFamily(), AppPreferences.ntfontstyle, AppPreferences.ntfontsize));
                label14 = new JLabel(fieldName + ":");
                label14.setHorizontalAlignment(4);
                label14.setFont(label14.getFont().deriveFont(label14.getFont().getStyle(), label14.getFont().getSize() + 2));
                this.jPanel3.add(label14);
                this.jPanel3.add(field);
                this.fields.add(field);
                ++rows;
            }
        }
        this.jButton1 = new JButton();
        this.jButton1.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jButton1.addActionListener(this);
        this.jButton2 = new JButton();
        this.jButton2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jButton2.addActionListener(this);
        this.jButton3 = new JButton();
        this.jButton3.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DELETE"));
        this.jButton3.addActionListener(this);
        this.jButton4 = new JButton();
        this.jButton4.setEnabled(false);
        this.jButton4.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLONE"));
        this.jButton4.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new EmptyBorder(5, 5, 0, 5));
        jPanel5.setLayout(new GridLayout(0, 4, 10, 0));
        jPanel5.setOpaque(false);
        jPanel5.add(this.jButton1);
        jPanel5.add(this.jButton3);
        jPanel5.add(this.jButton4);
        jPanel5.add(this.jButton2);
        GridPanel con = new GridPanel();
        con.setLayout(new BorderLayout());
        this.setContentPane(con);
        con.setBorder(new EmptyBorder(new Insets(10, 10, 5, 10)));
        con.add((Component)jPanel5, "South");
        if (rows > 0) {
            UITools.makeCompactGrid(this.jPanel3, rows, 2, 6, 6, 12, 6);
            con.add((Component)this.jPanel3, "Center");
        }
        con.getActionMap().put("CYCLEFOCUS", new AbstractAction("CYCLEFOCUS"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (GlossaryEntryEditor.this.fields.size() > 1) {
                    JTextField targetfield = (JTextField)GlossaryEntryEditor.this.fields.get(1);
                    if (!targetfield.isFocusOwner()) {
                        targetfield.requestFocusInWindow();
                    } else {
                        JTextField sourcefield = (JTextField)GlossaryEntryEditor.this.fields.get(0);
                        sourcefield.requestFocusInWindow();
                    }
                }
            }
        });
        con.getActionMap().put("REQUESTFOCUS", new AbstractAction("REQUESTFOCUS"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (GlossaryEntryEditor.this.fields.size() > 1) {
                    JTextField targetfield = (JTextField)GlossaryEntryEditor.this.fields.get(1);
                    targetfield.requestFocusInWindow();
                }
            }
        });
        con.getActionMap().put("TITLECASE", new AbstractAction("TITLECASE"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTextComponent tc = GlossaryEntryEditor.this.parent.getFocusedTextComponent();
                GlossaryEntryEditor.this.parent.getResourceView().cycleCase(tc, 2);
            }
        });
        con.getActionMap().put("CYCLECASE", new AbstractAction("CYCLECASE"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTextComponent tc = GlossaryEntryEditor.this.parent.getFocusedTextComponent();
                GlossaryEntryEditor.this.parent.getResourceView().cycleCase(tc, 1);
            }
        });
        con.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlossaryEntryEditor.this.jButton1.doClick();
            }
        });
        con.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlossaryEntryEditor.this.jButton2.doClick();
            }
        });
        KeyStroke ks = KeyPreferences.getKeyStroke("k38");
        con.getInputMap(1).put(ks, "TITLECASE");
        ks = KeyPreferences.getKeyStroke("k39");
        con.getInputMap(1).put(ks, "CYCLECASE");
        ks = KeyPreferences.getKeyStroke("k80");
        con.getInputMap(1).put(ks, "CYCLEFOCUS");
        ks = KeyPreferences.getKeyStroke("k89");
        con.getInputMap(1).put(ks, "REQUESTFOCUS");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(10, 128), "ENTER");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GlossaryEntryEditor.this.closeDialog();
            }
        });
        this.pack();
        JComponent field = (JComponent)this.fields.get(0);
        field.requestFocusInWindow();
    }

    private String makeEntry() {
        String sep = this.dictionary.getKeyEntrySeparator();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int j = 0;
        boolean placeabe = false;
        for (Object object : this.fields) {
            String s;
            if (object instanceof JComboBox) {
                JComboBox box = (JComboBox)object;
                Object o = box.getSelectedItem();
                s = o != null ? o.toString().trim() : "";
            } else {
                JTextField field = (JTextField)object;
                s = field.getText().trim();
            }
            if (s.length() > 0) {
                ++j;
                char c = s.charAt(0);
                if (c == '!') {
                    placeabe = true;
                }
            }
            sb.append(s);
            if (i < this.fields.size() - 1) {
                sb.append(sep);
            }
            ++i;
        }
        String newTerm = sb.toString();
        if (j == 1 && placeabe) {
            newTerm = newTerm.trim();
        }
        return newTerm;
    }

    void closeDialog() {
        AppPreferences.glossaryDialogWidth = this.getWidth();
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton1) {
            String newEntry = this.makeEntry();
            if (this.dictionary instanceof GlossaryResource) {
                Workflow w;
                GlossaryResource gloss = (GlossaryResource)this.dictionary;
                gloss.updateTerm(newEntry, this.index, this.isNewTerm);
                if (gloss.nontranslatablesOnly && (w = this.parent.getWorkflowView().getWorkflowManager().getWorkflow()) != null) {
                    w.refreshSourcePane();
                }
            }
            this.closeDialog();
        } else if (e.getSource() == this.jButton4) {
            String newEntry = this.makeEntry();
            if (this.dictionary instanceof GlossaryResource) {
                Workflow w;
                GlossaryResource gloss = (GlossaryResource)this.dictionary;
                this.dictionary.cloneTerm(newEntry);
                gloss.addToSourceMap();
                if (gloss.nontranslatablesOnly && (w = this.parent.getWorkflowView().getWorkflowManager().getWorkflow()) != null) {
                    w.refreshSourcePane();
                }
            }
            this.closeDialog();
        } else if (e.getSource() == this.jButton2) {
            this.closeDialog();
        } else if (e.getSource() == this.jButton3) {
            if (this.dictionary instanceof GlossaryResource) {
                Workflow w;
                GlossaryResource gloss = (GlossaryResource)this.dictionary;
                gloss.updateTerm(null, this.index, this.isNewTerm);
                if (gloss.nontranslatablesOnly && (w = this.parent.getWorkflowView().getWorkflowManager().getWorkflow()) != null) {
                    w.refreshSourcePane();
                }
            }
            this.closeDialog();
        }
    }
}

