/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.AssembleParser;
import translator.CaseInsensitiveString;
import translator.DefaultXMLElement;
import translator.DictionaryResource;
import translator.FragmentMatch;
import translator.LanguageCodes;
import translator.MainView;
import translator.NaturalOrderComparator;
import translator.NumbersHelper;
import translator.Placeables;
import translator.Project;
import translator.ResourceInfo;
import translator.ResourceView;
import translator.TranslateEvent;
import translator.Workflow;
import translator.XMLHelper;
import translator.hunspell.HunSpellChecker;
import translator.qa.Fixable;
import translator.qa.Issue;
import translator.translatables.MSExcelDocument;
import translator.ttx.TTXUnit;
import translator.ui.HTMLFormat;
import translator.ui.UITools;
import translator.xliff.XLIFFUnit;

public class GlossaryResource
extends DictionaryResource {
    private ConcurrentHashMap smap;
    private Pattern pattern;
    private int priority = 1;
    private boolean isBlocked;
    private ConcurrentHashMap rootsMap;
    private Set roots;
    private ConcurrentHashMap regularExpressionsMap;
    private Set regularExpressions;
    private Pattern spacePatternQA = Pattern.compile("\\s+");
    public static int totalEntriesLoaded = 0;
    private int entriesLoaded = 0;
    public static boolean trialMessageDisplayed;
    private Set targetSet = new HashSet();

    public GlossaryResource(ResourceInfo ri) {
        super(ri);
        this.priority = ri.getPriority();
        if (this.priority == 3) {
            this.autoAssemblingStopped = true;
        }
        this.fillFields();
        if (this.fields == null && !this.nontranslatablesOnly) {
            this.setHeader();
        }
        this.fillMaps(false);
        this.setMatchPattern();
    }

    public void setMatchPattern() {
        if (AppPreferences.noWordSeparatorSourceLanguage) {
            this.pattern = Pattern.compile("", 16);
        } else if (AppPreferences.wordDividers.length() > 0) {
            StringBuilder sb = new StringBuilder();
            char[] ch = AppPreferences.wordDividers.toCharArray();
            for (int i = 0; i < ch.length; ++i) {
                char c = ch[i];
                if (c == '-' || c == '\\' || c == '[' || c == ']') {
                    sb.append('\\').append(c);
                    continue;
                }
                sb.append(c);
            }
            this.pattern = Pattern.compile("[ " + sb.toString() + "]+");
        } else {
            this.pattern = Pattern.compile("[ ]+");
        }
    }

    public void setSearchColumn(int i) {
        this.searchColumnIndex = i;
        this.info.setEntry("Search column", Integer.toString(i));
        this.info.saveInfo();
    }

    public void setPriority(int p) {
        this.priority = p;
        this.info.setEntry("Priority", Integer.toString(p));
        this.info.saveInfo();
    }

    public int getPriority() {
        return this.priority;
    }

    void setBlocked(boolean b) {
        this.isBlocked = b;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    @Override
    public void setMainView(MainView topui) {
        String slang;
        HunSpellChecker sc;
        super.setMainView(topui);
        this.setPopupListener();
        this.nextResource();
        if (AppPreferences.wordStemGlossaryLookup && (sc = topui.getSpellChecker()) != null && (slang = AppPreferences.fileSLang).indexOf(45) != 1) {
            slang = slang.replace('-', '_');
            sc.setSourceLanguageDictionary(slang);
        }
    }

    private void setPopupListener() {
        this.textPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    GlossaryResource.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                int button = evt.getButton();
                if (evt.isPopupTrigger()) {
                    GlossaryResource.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                } else {
                    boolean ctrl = UITools.isShortcutDown(evt);
                    if (ctrl && button == 1) {
                        GlossaryResource.this.topui.getResourceView().addTermToGlossariesDirect(GlossaryResource.this);
                    }
                }
            }
        });
    }

    public void removeFromMap(String key) {
        if (key.indexOf(this.TargetDelimiter) != -1) {
            String[] keys = this.alterntivesPattern.split(key);
            for (int k = 0; k < keys.length; ++k) {
                String skey = keys[k];
                int pipe = skey.indexOf(124);
                if (this.regExOnly && pipe != 0) {
                    skey = this.prependPipe(skey);
                    pipe = 0;
                }
                if (pipe != -1) {
                    if (pipe == 0 && this.regularExpressionsMap != null) {
                        String regEx = key.substring(1);
                        if (!regEx.startsWith("\\A")) {
                            regEx = "\\A" + regEx;
                        }
                        if (!regEx.endsWith("\\z")) {
                            regEx = regEx + "\\z";
                        }
                        this.regularExpressionsMap.remove(regEx);
                    }
                    skey = skey.replace("|", "");
                }
                String mapKey = skey.replaceAll(AppPreferences.punctuation, "");
                if (AppPreferences.glossaryPrefixMatch) {
                    mapKey = !AppPreferences.noWordSeparatorSourceLanguage ? this.makePrefixes(mapKey) : this.makePrefixCJK(mapKey);
                }
                CaseInsensitiveString cisKey = new CaseInsensitiveString(mapKey, this.caseMatch);
                Object o = this.smap.remove(cisKey);
                if (skey.startsWith("!")) {
                    Placeables.removePlaceable(skey.substring(1));
                } else if (this.nontranslatablesOnly) {
                    Placeables.removePlaceable(skey);
                }
                AssembleParser.removeFromSuperGlossary(skey);
            }
        } else {
            int pipe = key.indexOf(124);
            if (this.regExOnly && pipe != 0) {
                key = this.prependPipe(key);
                pipe = 0;
            }
            if (pipe != -1) {
                if (pipe == 0 && this.regularExpressionsMap != null) {
                    String regEx = key.substring(1);
                    if (!regEx.startsWith("\\A")) {
                        regEx = "\\A" + regEx;
                    }
                    if (!regEx.endsWith("\\z")) {
                        regEx = regEx + "\\z";
                    }
                    this.regularExpressionsMap.remove(regEx);
                }
                key = key.replace("|", "");
            }
            String mapKey = key.replaceAll(AppPreferences.punctuation, "");
            if (AppPreferences.glossaryPrefixMatch) {
                mapKey = !AppPreferences.noWordSeparatorSourceLanguage ? this.makePrefixes(mapKey) : this.makePrefixCJK(mapKey);
            }
            CaseInsensitiveString cisKey = new CaseInsensitiveString(mapKey, this.caseMatch);
            Object o = this.smap.remove(cisKey);
            if (key.startsWith("!")) {
                Placeables.removePlaceable(key.substring(1));
            } else if (this.nontranslatablesOnly) {
                Placeables.removePlaceable(key);
            }
            AssembleParser.removeFromSuperGlossary(key);
        }
    }

    public void updateTerm(String newLine, int index, boolean isNewTerm) {
        if (!isNewTerm) {
            if (index < this.fields.length) {
                String oldLine = this.fields[index];
                String oldKey = null;
                if (newLine == null || oldLine != null && !oldLine.equals(newLine)) {
                    int i = oldLine.indexOf(this.KeyEntrySeparator);
                    if (this.sourceColumnIndex != -1 && this.targetColumnIndex != -1 && i != -1) {
                        int ind = 0;
                        Matcher m = this.splitPattern.matcher(oldLine);
                        while (m.find()) {
                            String s = m.group().trim();
                            if (s.length() > 0 && ind == this.sourceColumnIndex) {
                                oldKey = s;
                                break;
                            }
                            ++ind;
                        }
                    } else {
                        oldKey = i != -1 ? oldLine.substring(0, i) : oldLine;
                    }
                    if (oldKey != null) {
                        if (oldKey.indexOf(this.TargetDelimiter) != -1) {
                            String[] keys = this.alterntivesPattern.split(oldKey);
                            for (int k = 0; k < keys.length; ++k) {
                                String oldKeyA = keys[k];
                                if (oldKeyA.startsWith("?")) {
                                    AssembleParser.removeTermPattern(oldKeyA);
                                } else if (oldKeyA.startsWith("!")) {
                                    Placeables.removePlaceable(oldKeyA.substring(1));
                                } else if (this.nontranslatablesOnly) {
                                    Placeables.removePlaceable(oldKeyA);
                                }
                                AssembleParser.removeFromSuperGlossary(oldKeyA);
                            }
                        } else {
                            if (oldKey.startsWith("?")) {
                                AssembleParser.removeTermPattern(oldKey);
                            } else if (oldKey.startsWith("!")) {
                                Placeables.removePlaceable(oldKey.substring(1));
                            } else if (this.nontranslatablesOnly) {
                                Placeables.removePlaceable(oldKey);
                            }
                            AssembleParser.removeFromSuperGlossary(oldKey);
                        }
                    }
                    this.fields[index] = newLine;
                    this.reloadMaps();
                    this.addToSourceMap();
                    this.showFromIndex(index);
                    this.saveAllContent();
                }
            }
        } else if (index < this.newFields.length) {
            String oldLine = this.newFields[index];
            if (newLine == null || oldLine != null && !oldLine.equals(newLine)) {
                String oldKey = null;
                int i = oldLine.indexOf(this.KeyEntrySeparator);
                if (this.sourceColumnIndex != -1 && this.targetColumnIndex != -1 && i != -1) {
                    int ind = 0;
                    Matcher m = this.splitPattern.matcher(oldLine);
                    while (m.find()) {
                        String s = m.group().trim();
                        if (s.length() > 0 && ind == this.sourceColumnIndex) {
                            oldKey = s;
                            break;
                        }
                        ++ind;
                    }
                } else {
                    oldKey = i != -1 ? oldLine.substring(0, i) : oldLine;
                }
                if (oldKey != null) {
                    if (oldKey.indexOf(this.TargetDelimiter) != -1) {
                        String[] keys = this.alterntivesPattern.split(oldKey);
                        for (int k = 0; k < keys.length; ++k) {
                            String oldKeyA = keys[k];
                            if (oldKeyA.startsWith("?")) {
                                AssembleParser.removeTermPattern(oldKeyA);
                            } else if (oldKeyA.startsWith("!")) {
                                Placeables.removePlaceable(oldKeyA.substring(1));
                            } else if (this.nontranslatablesOnly) {
                                Placeables.removePlaceable(oldKeyA);
                            }
                            AssembleParser.removeFromSuperGlossary(oldKeyA);
                        }
                    } else {
                        if (oldKey.startsWith("?")) {
                            AssembleParser.removeTermPattern(oldKey);
                        } else if (oldKey.startsWith("!")) {
                            Placeables.removePlaceable(oldKey.substring(1));
                        } else if (this.nontranslatablesOnly) {
                            Placeables.removePlaceable(oldKey);
                        }
                        AssembleParser.removeFromSuperGlossary(oldKey);
                    }
                }
                this.reloadGlossary();
                int newIndex = -1;
                if (this.fields != null && this.fields.length > 0) {
                    for (int j = this.fields.length - 1; j > -1; --j) {
                        String field = this.fields[j];
                        if (field == null || this.fields.length <= 0 || !field.equals(oldLine)) continue;
                        this.fields[j] = newLine;
                        newIndex = j;
                        break;
                    }
                }
                if (newIndex != -1) {
                    this.reloadMaps();
                    this.showFromIndex(newIndex);
                    this.saveAllContent();
                }
            }
        }
    }

    private void fillMaps(boolean reload) {
        this.smap = new ConcurrentHashMap();
        this.rootsMap = new ConcurrentHashMap(100);
        this.regularExpressionsMap = new ConcurrentHashMap(100);
        if (this.fields != null) {
            for (int j = 0; j < this.fields.length; ++j) {
                String key;
                CaseInsensitiveString cisKey;
                Object[] ob;
                int pipe;
                String line;
                if (AppPreferences.isTrialVersion) {
                    if (!reload) {
                        if (totalEntriesLoaded > 500) {
                            this.fields[j] = null;
                            continue;
                        }
                        ++totalEntriesLoaded;
                        ++this.entriesLoaded;
                    } else if (j >= this.entriesLoaded) {
                        this.fields[j] = null;
                        continue;
                    }
                }
                if ((line = this.fields[j]) == null) continue;
                int i = line.indexOf(this.KeyEntrySeparator);
                if (i != -1) {
                    Object[] ob2;
                    CaseInsensitiveString cisKey2;
                    Object[] o;
                    Object[] arr;
                    String key2 = "";
                    String value = "";
                    String note = null;
                    if (this.sourceColumnIndex != -1 && this.targetColumnIndex != -1) {
                        StringBuilder columns = new StringBuilder();
                        int ind = 0;
                        Matcher m = this.splitPattern.matcher(line);
                        while (m.find()) {
                            String s = m.group().trim();
                            if (s.length() > 0) {
                                if (ind == this.sourceColumnIndex) {
                                    key2 = s;
                                } else if (ind == this.targetColumnIndex) {
                                    value = s;
                                } else {
                                    if (columns.length() > 0) {
                                        columns.append('\t');
                                    }
                                    columns.append(s);
                                }
                            }
                            ++ind;
                        }
                        if (columns.length() > 0) {
                            note = columns.toString();
                        }
                    } else {
                        key2 = line.substring(0, i);
                        value = line.substring(i + this.KeyEntrySeparator.length());
                        if ((i = value.indexOf(this.KeyEntrySeparator)) != -1) {
                            String s = value;
                            value = value.substring(0, i);
                            note = s.substring(i + this.KeyEntrySeparator.length());
                        }
                    }
                    if (key2.length() <= 0) continue;
                    if (key2.indexOf(this.TargetDelimiter) != -1) {
                        String[] keys = this.alterntivesPattern.split(key2);
                        for (int k = 0; k < keys.length; ++k) {
                            Object[] ob3;
                            CaseInsensitiveString cisKey3;
                            Object[] o2;
                            arr = new Object[4];
                            arr[0] = value;
                            arr[1] = note;
                            arr[2] = j;
                            String skey = keys[k];
                            if (skey.length() > 0) {
                                char q = skey.charAt(0);
                                if (q == '?') {
                                    if (value.length() <= 0) continue;
                                    AssembleParser.addToSegmentPatterns(skey, value, true);
                                    continue;
                                }
                                if (q == '!') {
                                    Placeables.addPlaceable(skey.substring(1));
                                }
                            }
                            arr[3] = skey;
                            int pipe2 = skey.indexOf(124);
                            if (this.regExOnly && pipe2 != 0) {
                                skey = this.prependPipe(skey);
                                pipe2 = 0;
                            }
                            if (pipe2 != -1) {
                                Object[] ob4 = new Object[]{arr};
                                if (pipe2 == 0) {
                                    this.addRegularExpression(skey, ob4);
                                } else {
                                    this.addRoot(skey, ob4, pipe2);
                                }
                                skey = skey.replace("|", "");
                            }
                            String mapKey = skey.replaceAll(AppPreferences.punctuation, "");
                            if (AppPreferences.glossaryPrefixMatch) {
                                mapKey = !AppPreferences.noWordSeparatorSourceLanguage ? this.makePrefixes(mapKey) : this.makePrefixCJK(mapKey);
                            }
                            if (mapKey.length() <= 0 || (o2 = this.smap.put(cisKey3 = new CaseInsensitiveString(mapKey, this.caseMatch), ob3 = new Object[]{arr})) == null) continue;
                            Object[] oo = o2;
                            oo = this.addTargetToArray(oo, arr);
                            this.smap.put(cisKey3, oo);
                        }
                        continue;
                    }
                    char q = key2.charAt(0);
                    if (q == '?') {
                        if (value.length() <= 0) continue;
                        AssembleParser.addToSegmentPatterns(key2, value, true);
                        continue;
                    }
                    if (q == '!') {
                        Placeables.addPlaceable(key2.substring(1));
                    }
                    arr = new Object[]{value, note, j, key2};
                    int pipe3 = key2.indexOf(124);
                    if (this.regExOnly && pipe3 != 0) {
                        key2 = this.prependPipe(key2);
                        pipe3 = 0;
                    }
                    if (pipe3 != -1) {
                        Object[] ob5 = new Object[]{arr};
                        if (pipe3 == 0) {
                            this.addRegularExpression(key2, ob5);
                        } else {
                            this.addRoot(key2, ob5, pipe3);
                        }
                        key2 = key2.replace("|", "");
                    }
                    String mapKey = key2.replaceAll(AppPreferences.punctuation, "");
                    if (AppPreferences.glossaryPrefixMatch) {
                        mapKey = !AppPreferences.noWordSeparatorSourceLanguage ? this.makePrefixes(mapKey) : this.makePrefixCJK(mapKey);
                    }
                    if (mapKey.length() <= 0 || (o = this.smap.put(cisKey2 = new CaseInsensitiveString(mapKey, this.caseMatch), ob2 = new Object[]{arr})) == null) continue;
                    Object[] oo = o;
                    oo = this.addTargetToArray(oo, arr);
                    this.smap.put(cisKey2, oo);
                    continue;
                }
                if (line.length() <= 0) continue;
                char q = line.charAt(0);
                if (q == '!' && line.length() > 1) {
                    String key3 = line.substring(1);
                    Placeables.addPlaceable(key3);
                    Object[] arr = new Object[]{"", null, j, line};
                    int k = line.lastIndexOf(61);
                    if (k != -1) {
                        key3 = line.substring(0, k);
                    }
                    pipe = key3.indexOf(124);
                    if (this.regExOnly && pipe != 0) {
                        key3 = this.prependPipe(key3);
                        pipe = 0;
                    }
                    if (pipe != -1) {
                        ob = new Object[]{arr};
                        if (pipe == 0) {
                            this.addRegularExpression(key3, ob);
                        } else {
                            this.addRoot(key3, ob, pipe);
                        }
                        key3 = key3.replace("|", "");
                    }
                    cisKey = new CaseInsensitiveString(key3, this.caseMatch);
                    Object[] ob6 = new Object[]{arr};
                    this.smap.put(cisKey, ob6);
                    continue;
                }
                if (!this.nontranslatablesOnly) continue;
                if (line.charAt(0) != '#') {
                    Placeables.addPlaceable(line);
                }
                Object[] arr = new Object[]{"", null, j, line};
                int k = line.lastIndexOf(61);
                if (k != -1) {
                    line = line.substring(0, k);
                }
                if ((key = line).endsWith("^")) {
                    key = key.substring(0, key.length() - 1);
                }
                pipe = key.indexOf(124);
                if (this.regExOnly && pipe != 0) {
                    key = this.prependPipe(key);
                    pipe = 0;
                }
                if (pipe != -1) {
                    ob = new Object[]{arr};
                    if (pipe == 0) {
                        this.addRegularExpression(key, ob);
                    } else {
                        this.addRoot(key, ob, pipe);
                    }
                    key = key.replace("|", "");
                }
                cisKey = new CaseInsensitiveString(key, this.caseMatch);
                Object[] ob7 = new Object[]{arr};
                this.smap.put(cisKey, ob7);
            }
            if (!this.regularExpressionsMap.isEmpty()) {
                this.regularExpressions = this.regularExpressionsMap.keySet();
            }
            if (!this.rootsMap.isEmpty()) {
                this.roots = this.rootsMap.keySet();
            }
        }
    }

    public void reloadGlossary() {
        this.saveResourceOneThread();
        this.clearNewContent();
        this.fields = null;
        this.smap.clear();
        if (this.nontranslatablesOnly) {
            Placeables.loadPlaceables();
        }
        this.reload();
        this.fillFields();
        this.fillMaps(true);
        this.nextResource();
    }

    void reloadMaps() {
        if (this.nontranslatablesOnly) {
            Placeables.loadPlaceables();
        }
        this.smap.clear();
        this.fillMaps(true);
    }

    public void joinGlossary() {
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        FileChooser fileChooser = new FileChooser();
                        File f = new File(System.getProperty("user.home"));
                        if (f.isDirectory() && f.canRead()) {
                            fileChooser.setInitialDirectory(f);
                        }
                        fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FILE"));
                        final File file = fileChooser.showOpenDialog(null);
                        if (file != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    try {
                                        String path = file.toURI().toURL().getPath();
                                        if (path.length() > 0) {
                                            this.this$1.GlossaryResource.this.fields = null;
                                            this.this$1.GlossaryResource.this.smap.clear();
                                            this.this$1.GlossaryResource.this.joinResource(path);
                                            this.this$1.GlossaryResource.this.fillFields();
                                            this.this$1.GlossaryResource.this.fillMaps(false);
                                            this.this$1.GlossaryResource.this.nextResource();
                                            JOptionPane.showMessageDialog(this.this$1.GlossaryResource.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION COMPLETED"));
                                        }
                                    }
                                    catch (MalformedURLException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.GlossaryResource.this.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            JFileChooser jch = new JFileChooser(System.getProperty("user.home"));
            jch.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FILE"));
            jch.setFileSelectionMode(2);
            if (0 == jch.showOpenDialog(this.topui)) {
                File file = jch.getSelectedFile();
                try {
                    String path = file.toURI().toURL().getPath();
                    if (path.length() > 0) {
                        this.fields = null;
                        this.smap.clear();
                        this.joinResource(path);
                        this.fillFields();
                        this.fillMaps(false);
                        this.nextResource();
                        JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION COMPLETED"));
                    }
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void importExcel() {
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        FileChooser fileChooser = new FileChooser();
                        File f = new File(System.getProperty("user.home"));
                        if (f.isDirectory() && f.canRead()) {
                            fileChooser.setInitialDirectory(f);
                        }
                        fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FILE"));
                        final File file = fileChooser.showOpenDialog(null);
                        if (file != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 3 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    try {
                                        String path = file.toURI().toURL().getPath().toLowerCase();
                                        if (path.length() > 0 && path.endsWith(".xlsx")) {
                                            MSExcelDocument res = new MSExcelDocument();
                                            res.setConversion();
                                            res.loadFile(file, "Ms Excel (*.xlsx)", "UTF-8", null, null);
                                            res.toGlossary(this.this$1.GlossaryResource.this);
                                            this.this$1.GlossaryResource.this.showNewEntries();
                                            this.this$1.GlossaryResource.this.saveResource();
                                            JOptionPane.showMessageDialog(this.this$1.GlossaryResource.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION COMPLETED"));
                                        } else if (path.length() > 0 && path.endsWith(".xls")) {
                                            JOptionPane.showMessageDialog(this.this$1.GlossaryResource.this.topui, "Please save this MS Excel .xls file in the new MS Excel .xlsx format and start again.");
                                        }
                                    }
                                    catch (MalformedURLException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.GlossaryResource.this.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            JFileChooser jch = new JFileChooser(System.getProperty("user.home"));
            jch.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FILE"));
            jch.setFileSelectionMode(0);
            if (0 == jch.showOpenDialog(this.topui)) {
                File file = jch.getSelectedFile();
                try {
                    String path = file.toURI().toURL().getPath().toLowerCase();
                    if (path.length() > 0 && path.endsWith(".xlsx")) {
                        MSExcelDocument res = new MSExcelDocument();
                        res.setConversion();
                        res.loadFile(file, "Ms Excel (*.xlsx)", "UTF-8", null, null);
                        res.toGlossary(this);
                        this.showNewEntries();
                        this.saveResource();
                        JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION COMPLETED"));
                    } else if (path.length() > 0 && path.endsWith(".xls")) {
                        JOptionPane.showMessageDialog(this.topui, "Please save this MS Excel .xls file in the new MS Excel .xlsx format and start again.");
                    }
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void mergeTargets() {
        this.smap.clear();
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        if (this.fields != null) {
            StringBuilder sb;
            String string;
            String[] targets;
            LinkedHashSet<String> set;
            String t;
            String s;
            int k;
            String[] prevchunks;
            String[] o;
            String[] chunks;
            String line;
            int j;
            int srcIndex = 0;
            int trgIndex = 1;
            if (this.sourceColumnIndex != -1 && this.targetColumnIndex != -1) {
                srcIndex = this.sourceColumnIndex;
                trgIndex = this.targetColumnIndex;
            }
            for (j = 0; j < this.fields.length; ++j) {
                line = this.fields[j];
                if (line == null || line.trim().length() == 0) continue;
                chunks = Pattern.compile(this.KeyEntrySeparator, 16).split(line, 500);
                if (chunks != null && chunks.length > 0 && srcIndex < chunks.length && trgIndex < chunks.length && chunks[srcIndex].length() > 0 && chunks[trgIndex].length() > 0) {
                    o = map.put(chunks[srcIndex], chunks);
                    if (o == null || (prevchunks = o).length <= 1 || chunks.length <= 1) continue;
                    for (k = 0; k < prevchunks.length && k < chunks.length; ++k) {
                        int i;
                        if (k == srcIndex) continue;
                        s = prevchunks[k];
                        t = chunks[k];
                        set = new LinkedHashSet<String>();
                        if (t != null && t.length() > 0) {
                            if (t.indexOf(this.TargetDelimiter) != -1) {
                                targets = Pattern.compile(this.TargetDelimiter, 16).split(t);
                                for (i = 0; i < targets.length; ++i) {
                                    string = targets[i];
                                    set.add(string);
                                }
                            } else {
                                set.add(t);
                            }
                        }
                        if (s != null && s.length() > 0) {
                            if (s.indexOf(this.TargetDelimiter) != -1) {
                                targets = Pattern.compile(this.TargetDelimiter, 16).split(s);
                                for (i = 0; i < targets.length; ++i) {
                                    string = targets[i];
                                    set.add(string);
                                }
                            } else {
                                set.add(s);
                            }
                        }
                        sb = new StringBuilder();
                        for (String next : set) {
                            if (next.trim().length() <= 0) continue;
                            if (sb.length() > 0) {
                                sb.append(this.TargetDelimiter);
                            }
                            sb.append(next);
                        }
                        chunks[k] = sb.toString();
                    }
                    continue;
                }
                map.put(line, chunks);
            }
            if (this.newFields != null) {
                for (j = 0; j < this.newFields.length; ++j) {
                    line = this.newFields[j];
                    if (line == null) continue;
                    chunks = Pattern.compile(this.KeyEntrySeparator, 16).split(line, 500);
                    if (chunks != null && chunks.length > 0 && srcIndex < chunks.length && trgIndex < chunks.length && chunks[srcIndex].length() > 0 && chunks[trgIndex].length() > 0) {
                        o = map.put(chunks[srcIndex], chunks);
                        if (o == null || (prevchunks = o).length <= 1 || chunks.length <= 1) continue;
                        for (k = 0; k < prevchunks.length && k < chunks.length; ++k) {
                            if (k == srcIndex) continue;
                            s = prevchunks[k];
                            t = chunks[k];
                            set = new LinkedHashSet();
                            if (t != null && t.length() > 0) {
                                if (t.indexOf(this.TargetDelimiter) != -1) {
                                    targets = Pattern.compile(this.TargetDelimiter, 16).split(t);
                                    for (int i = 0; i < targets.length; ++i) {
                                        string = targets[i];
                                        set.add(string);
                                    }
                                } else {
                                    set.add(t);
                                }
                            }
                            if (s != null && s.length() > 0) {
                                if (s.indexOf(this.TargetDelimiter) != -1) {
                                    targets = Pattern.compile(this.TargetDelimiter, 16).split(s);
                                    for (int i = 0; i < targets.length; ++i) {
                                        string = targets[i];
                                        set.add(string);
                                    }
                                } else {
                                    set.add(s);
                                }
                            }
                            sb = new StringBuilder();
                            for (String next : set) {
                                if (next.trim().length() <= 0) continue;
                                if (sb.length() > 0) {
                                    sb.append(this.TargetDelimiter);
                                }
                                sb.append(next);
                            }
                            chunks[k] = sb.toString();
                        }
                        continue;
                    }
                    map.put(line, chunks);
                }
                this.clearNewContent();
            }
            StringBuilder sb2 = new StringBuilder();
            Collection col = map.values();
            for (String[] chunks2 : col) {
                String target;
                int sep;
                if (chunks2.length > 1 && (sep = (target = chunks2[trgIndex]).indexOf(this.TargetDelimiter)) != -1) {
                    CaseInsensitiveString cis;
                    String[] targets2 = Pattern.compile(this.TargetDelimiter, 16).split(target);
                    LinkedHashSet<CaseInsensitiveString> noduplicates = new LinkedHashSet<CaseInsensitiveString>(targets2.length);
                    for (int i = 0; i < targets2.length; ++i) {
                        String string2 = targets2[i];
                        cis = new CaseInsensitiveString(string2, false);
                        noduplicates.add(cis);
                    }
                    StringBuilder sb22 = new StringBuilder();
                    Iterator it1 = noduplicates.iterator();
                    while (it1.hasNext()) {
                        cis = (CaseInsensitiveString)it1.next();
                        sb22.append(cis.toString());
                        if (!it1.hasNext()) continue;
                        sb22.append(this.TargetDelimiter);
                    }
                    chunks2[trgIndex] = sb22.toString();
                }
                for (int i = 0; i < chunks2.length; ++i) {
                    String string3 = chunks2[i];
                    sb2.append(string3);
                    if (i + 1 >= chunks2.length) continue;
                    sb2.append(this.KeyEntrySeparator);
                }
                sb2.append(this.EntrySeparator);
            }
            this.saveDictionary(sb2, false, true);
            this.reload();
            this.fillFields();
            this.fillMaps(true);
            this.nextResource();
            String p = this.backupName != null ? ". " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIOUS VERSION SAVED") + "." : "";
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARY UPDATED") + p);
        }
    }

    public void removeDuplicates() {
        this.smap.clear();
        String header = null;
        if (this.fields != null && this.fields.length > 1) {
            String line;
            int j;
            LinkedHashSet<String> list = new LinkedHashSet<String>(this.fields.length);
            String h = this.fields[0];
            if (h != null && h.startsWith("#")) {
                header = h;
                this.fields[0] = null;
            }
            for (j = 0; j < this.fields.length; ++j) {
                line = this.fields[j];
                if (line == null) continue;
                list.add(line);
            }
            if (this.newFields != null) {
                for (j = 0; j < this.newFields.length; ++j) {
                    line = this.newFields[j];
                    if (line == null) continue;
                    list.add(line);
                }
                this.clearNewContent();
            }
            StringBuilder sb = new StringBuilder();
            if (header != null) {
                sb.append(header);
                sb.append(this.EntrySeparator);
            }
            Iterator it = list.iterator();
            while (it.hasNext()) {
                String line2 = it.next().toString();
                sb.append(line2);
                sb.append(this.EntrySeparator);
            }
            this.saveDictionary(sb, false, true);
            this.reload();
            this.fillFields();
            this.fillMaps(true);
            this.nextResource();
            String p = this.backupName != null ? ". " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIOUS VERSION SAVED") + "." : "";
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARY UPDATED") + p);
        }
    }

    public void removeSourceEqualsTarget() {
        this.smap.clear();
        StringBuilder sb = new StringBuilder();
        if (this.fields != null && this.fields.length > 1) {
            String value;
            String key;
            int i;
            boolean add;
            String line;
            int j;
            String h = this.fields[0];
            if (h != null && h.startsWith("#")) {
                this.fields[0] = null;
                sb.append(h);
                sb.append(this.EntrySeparator);
            }
            for (j = 0; j < this.fields.length; ++j) {
                line = this.fields[j];
                if (line == null) continue;
                add = true;
                i = line.indexOf(this.KeyEntrySeparator);
                if (i != -1) {
                    key = line.substring(0, i);
                    value = line.substring(i + this.KeyEntrySeparator.length());
                    if ((i = value.indexOf(this.KeyEntrySeparator)) != -1) {
                        value = value.substring(0, i);
                    }
                    if (this.caseMatch) {
                        if (key.equals(value)) {
                            add = false;
                        }
                    } else if (key.equalsIgnoreCase(value)) {
                        add = false;
                    }
                }
                if (!add) continue;
                sb.append(line);
                sb.append(this.EntrySeparator);
            }
            if (this.newFields != null) {
                for (j = 0; j < this.newFields.length; ++j) {
                    line = this.newFields[j];
                    if (line == null) continue;
                    add = true;
                    i = line.indexOf(this.KeyEntrySeparator);
                    if (i != -1) {
                        key = line.substring(0, i);
                        value = line.substring(i + this.KeyEntrySeparator.length());
                        if ((i = value.indexOf(this.KeyEntrySeparator)) != -1) {
                            value = value.substring(0, i);
                        }
                        if (this.caseMatch) {
                            if (key.equals(value)) {
                                add = false;
                            }
                        } else if (key.equalsIgnoreCase(value)) {
                            add = false;
                        }
                    }
                    if (!add) continue;
                    sb.append(line);
                    sb.append(this.EntrySeparator);
                }
                this.clearNewContent();
            }
            this.saveDictionary(sb, false, true);
            this.reload();
            this.fillFields();
            this.fillMaps(true);
            this.nextResource();
            String p = this.backupName != null ? ". " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIOUS VERSION SAVED") + "." : "";
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARY UPDATED") + p);
        }
    }

    public void sort() {
        this.smap.clear();
        ArrayList<String[]> list = new ArrayList<String[]>();
        String header = null;
        if (this.fields != null && this.fields.length > 1) {
            String[] chunks2;
            String line;
            int j;
            String h = this.fields[0];
            if (h != null && h.startsWith("#")) {
                header = h;
                this.fields[0] = null;
            }
            for (j = 0; j < this.fields.length; ++j) {
                line = this.fields[j];
                if (line == null || (chunks2 = Pattern.compile(this.KeyEntrySeparator, 16).split(line, 500)) == null || chunks2.length <= 0) continue;
                list.add(chunks2);
            }
            if (this.newFields != null) {
                for (j = 0; j < this.newFields.length; ++j) {
                    line = this.newFields[j];
                    if (line == null || (chunks2 = Pattern.compile(this.KeyEntrySeparator, 16).split(line, 500)) == null || chunks2.length <= 0) continue;
                    list.add(chunks2);
                }
                this.clearNewContent();
            }
            Collections.sort(list, new NaturalOrderComparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    String[] entry1 = (String[])o1;
                    String[] entry2 = (String[])o2;
                    int i = 0;
                    if (GlossaryResource.this.sourceColumnIndex != -1) {
                        i = GlossaryResource.this.sourceColumnIndex;
                    }
                    String s1 = i < entry1.length ? entry1[i].trim() : "";
                    String s2 = i < entry2.length ? entry2[i].trim() : "";
                    return s1.compareToIgnoreCase(s2);
                }
            });
            StringBuilder sb = new StringBuilder();
            if (header != null) {
                sb.append(header);
                sb.append(this.EntrySeparator);
            }
            for (String[] chunks2 : list) {
                for (int i = 0; i < chunks2.length; ++i) {
                    String string = chunks2[i];
                    sb.append(string);
                    if (i + 1 >= chunks2.length) continue;
                    sb.append(this.KeyEntrySeparator);
                }
                sb.append(this.EntrySeparator);
            }
            this.saveDictionary(sb, false, true);
            this.reload();
            this.fillFields();
            this.fillMaps(true);
            this.nextResource();
            String p = this.backupName != null ? ". " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIOUS VERSION SAVED") + "." : "";
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARY UPDATED") + p);
        }
    }

    public void sortByCaseLenght() {
        this.smap.clear();
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (this.fields != null) {
            String[] chunks2;
            String line;
            int j;
            for (j = 0; j < this.fields.length; ++j) {
                line = this.fields[j];
                if (line == null || (chunks2 = Pattern.compile(this.KeyEntrySeparator, 16).split(line, 500)) == null || chunks2.length <= 0) continue;
                list.add(chunks2);
            }
            if (this.newFields != null) {
                for (j = 0; j < this.newFields.length; ++j) {
                    line = this.newFields[j];
                    if (line == null || (chunks2 = Pattern.compile(this.KeyEntrySeparator, 16).split(line, 500)) == null || chunks2.length <= 0) continue;
                    list.add(chunks2);
                }
                this.clearNewContent();
            }
            Collections.sort(list, new NaturalOrderComparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    String[] entry1 = (String[])o1;
                    String[] entry2 = (String[])o2;
                    int i = 0;
                    if (GlossaryResource.this.sourceColumnIndex != -1) {
                        i = GlossaryResource.this.sourceColumnIndex;
                    }
                    String s1 = i < entry1.length ? entry1[i].trim() : "";
                    String s2 = i < entry2.length ? entry2[i].trim() : "";
                    char c1 = s1.charAt(0);
                    char c2 = s2.charAt(0);
                    if ((c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) {
                        int len2;
                        int len1 = s1.length();
                        if (len1 == (len2 = s2.length())) {
                            return s1.compareToIgnoreCase(s2);
                        }
                        if (len1 > len2) {
                            return 1;
                        }
                        return -1;
                    }
                    return s1.compareToIgnoreCase(s2);
                }
            });
            StringBuilder sb = new StringBuilder();
            for (String[] chunks2 : list) {
                for (int i = 0; i < chunks2.length; ++i) {
                    String string = chunks2[i];
                    sb.append(string);
                    if (i + 1 >= chunks2.length) continue;
                    sb.append(this.KeyEntrySeparator);
                }
                sb.append(this.EntrySeparator);
            }
            this.saveDictionary(sb, false, true);
            this.reload();
            this.fillFields();
            this.fillMaps(true);
            this.nextResource();
            String p = this.backupName != null ? ". " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIOUS VERSION SAVED") + "." : "";
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARY UPDATED") + p);
        }
    }

    public void sortByLengthAlphabet() {
        this.smap.clear();
        ArrayList<String[]> list = new ArrayList<String[]>();
        String header = null;
        if (this.fields != null && this.fields.length > 1) {
            String s;
            String[] chunks2;
            String line;
            int j;
            String h = this.fields[0];
            if (h != null && h.startsWith("#")) {
                header = h;
                this.fields[0] = null;
            }
            for (j = 0; j < this.fields.length; ++j) {
                line = this.fields[j];
                if (line == null || (chunks2 = Pattern.compile(this.KeyEntrySeparator, 16).split(line, 500)) == null || chunks2.length <= 0 || (s = chunks2[0]).trim().length() <= 0) continue;
                list.add(chunks2);
            }
            if (this.newFields != null) {
                for (j = 0; j < this.newFields.length; ++j) {
                    line = this.newFields[j];
                    if (line == null || (chunks2 = Pattern.compile(this.KeyEntrySeparator, 16).split(line, 500)) == null || chunks2.length <= 0 || (s = chunks2[0]).trim().length() <= 0) continue;
                    list.add(chunks2);
                }
                this.clearNewContent();
            }
            Collections.sort(list, new NaturalOrderComparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    int len2;
                    String[] entry1 = (String[])o1;
                    String[] entry2 = (String[])o2;
                    int i = 0;
                    if (GlossaryResource.this.sourceColumnIndex != -1) {
                        i = GlossaryResource.this.sourceColumnIndex;
                    }
                    String s1 = i < entry1.length ? entry1[i] : "";
                    String s2 = i < entry2.length ? entry2[i] : "";
                    int len1 = s1.length();
                    if (len1 == (len2 = s2.length())) {
                        return s1.compareToIgnoreCase(s2);
                    }
                    if (len1 > len2) {
                        return 1;
                    }
                    return -1;
                }
            });
            StringBuilder sb = new StringBuilder();
            if (header != null) {
                sb.append(header);
                sb.append(this.EntrySeparator);
            }
            for (String[] chunks2 : list) {
                for (int i = 0; i < chunks2.length; ++i) {
                    String string = chunks2[i];
                    sb.append(string);
                    if (i + 1 >= chunks2.length) continue;
                    sb.append(this.KeyEntrySeparator);
                }
                sb.append(this.EntrySeparator);
            }
            this.saveDictionary(sb, false, true);
            this.reload();
            this.fillFields();
            this.fillMaps(true);
            this.nextResource();
            String p = this.backupName != null ? ". " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIOUS VERSION SAVED") + "." : "";
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARY UPDATED") + p);
        }
    }

    public boolean hasMatch(String key) {
        String mapKey = AppPreferences.glossaryPrefixMatch ? (!AppPreferences.noWordSeparatorSourceLanguage ? this.makePrefixes(key) : this.makePrefixCJK(key)) : key;
        Object objs = this.smap.get(new CaseInsensitiveString(mapKey, this.caseMatch));
        if (objs != null) {
            return true;
        }
        if (this.regularExpressions != null) {
            objs = this.findRegularExpression(key);
        }
        if (objs != null) {
            return true;
        }
        return this.roots != null && (objs = this.findRoot(key)) != null;
    }

    public Set getTargetSet() {
        return this.targetSet;
    }

    public List getMatch(String key, boolean unchanged) {
        ArrayList<String> targets = new ArrayList<String>();
        if (!unchanged) {
            key = key.replaceAll(AppPreferences.punctuation, "");
            key = key.trim();
            key = XMLHelper.normalizeSpace(key);
            key = key.replaceAll("\\s+", " ");
        }
        String mapKey = AppPreferences.glossaryPrefixMatch ? (!AppPreferences.noWordSeparatorSourceLanguage ? this.makePrefixes(key) : this.makePrefixCJK(key)) : key;
        Object objs = this.smap.get(new CaseInsensitiveString(mapKey, this.caseMatch));
        boolean fullRegExMatch = false;
        if (this.regularExpressions != null && objs == null && (objs = this.findRegularExpression(key)) != null) {
            fullRegExMatch = true;
        }
        if (this.roots != null && objs == null) {
            objs = this.findRoot(key);
        }
        if (objs == null) {
            int len;
            int a = key.indexOf(39);
            if (a == -1) {
                a = key.indexOf(8217);
            }
            if (a == 1 && a < (len = key.length()) - 3) {
                mapKey = key.substring(a + 1);
                objs = this.smap.get(new CaseInsensitiveString(mapKey, this.caseMatch));
            }
        }
        if (objs != null) {
            Object[] oarr = (Object[])objs;
            for (int m = 0; m < oarr.length; ++m) {
                Object[] arr = (Object[])oarr[m];
                String tar = arr[0].toString();
                int del = tar.indexOf(this.TargetDelimiter);
                if (del != -1) {
                    String[] tars = Pattern.compile(this.TargetDelimiter, 16).split(tar);
                    for (int k = 0; k < tars.length; ++k) {
                        String string = tars[k];
                        if (AppPreferences.autonumbers && fullRegExMatch) {
                            string = NumbersHelper.autoTransfer(key, string);
                        }
                        targets.add(string);
                    }
                    continue;
                }
                if (AppPreferences.autonumbers && fullRegExMatch) {
                    tar = NumbersHelper.autoTransfer(key, tar);
                }
                targets.add(tar);
            }
        }
        return targets;
    }

    public void findGlossaryMatches(TranslateEvent event) {
        HashSet<String> uniqueSet = new HashSet<String>();
        this.targetSet.clear();
        String fullSegment = event.getGlossaryLookupText();
        String segment = event.getGlossaryLookupTextCleaned();
        StringBuilder buffer = new StringBuilder();
        AbstractMap rowMap = AppPreferences.sortMatches ? new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toLowerCase().compareTo(o2.toLowerCase());
            }
        }) : new LinkedHashMap();
        buffer.append(HTMLFormat.startHTML);
        buffer.append(HTMLFormat.glossaryStyles);
        buffer.append(HTMLFormat.startBody);
        buffer.append(HTMLFormat.startTableGlossary);
        boolean hasHeader = false;
        ArrayList header = this.getHeader();
        if (header != null && !header.isEmpty()) {
            hasHeader = true;
        }
        if (hasHeader && !this.verticalDisplay) {
            this.makeHorizontalHeaderRow(buffer);
        }
        String[] str = this.pattern.split(segment);
        int sindex = 0;
        int eindex = 0;
        int slength = segment.length();
        boolean colorRow = false;
        boolean fullRegExMatch = false;
        int isRegEx = -1;
        for (int i = 0; i < str.length; ++i) {
            String key = str[i];
            if (key.length() == 0) continue;
            sindex = segment.indexOf(key, sindex);
            String part = segment.substring(sindex, slength);
            sindex += key.length();
            for (int j = str.length - 1; j >= i; --j) {
                List stems;
                HunSpellChecker sp;
                int matchType = 0;
                boolean apostrophe = false;
                key = str[j];
                eindex = part.lastIndexOf(key) + key.length();
                part = part.substring(0, eindex);
                String mapKey = !this.nontranslatablesOnly && AppPreferences.glossaryPrefixMatch && !AppPreferences.noWordSeparatorSourceLanguage ? this.makePrefixes(part) : part;
                Object objs = this.smap.get(new CaseInsensitiveString(mapKey, this.caseMatch));
                fullRegExMatch = false;
                if (this.regularExpressions != null && objs == null && isRegEx < i && (objs = this.findRegularExpression(part)) != null) {
                    matchType = 1;
                    isRegEx = j;
                    if (j == str.length - 1 && i == 0) {
                        fullRegExMatch = true;
                    }
                }
                if (this.roots != null && objs == null && i == j && (objs = this.findRoot(part)) != null) {
                    matchType = 2;
                }
                if (AppPreferences.wordStemGlossaryLookup && i == j && objs == null && (sp = this.topui.getSpellChecker()) != null && sp.hasSourceDictionary() && (stems = sp.getStems(part)) != null) {
                    for (String next : stems) {
                        String mKey;
                        if (next.equals(part) || (objs = this.smap.get(new CaseInsensitiveString(mKey = AppPreferences.glossaryPrefixMatch && !AppPreferences.noWordSeparatorSourceLanguage ? this.makePrefixes(next) : next, this.caseMatch))) == null) continue;
                        matchType = 3;
                        break;
                    }
                }
                if (objs == null) {
                    int a = part.indexOf(39);
                    if (a == -1) {
                        a = part.indexOf(8217);
                    }
                    if (a == 1 || i == j) {
                        int len = part.length();
                        if (a > 0 && a < len - 3) {
                            mapKey = part.substring(a + 1);
                            if (AppPreferences.glossaryPrefixMatch && !AppPreferences.noWordSeparatorSourceLanguage) {
                                mapKey = this.makePrefixes(mapKey);
                            }
                            if ((objs = this.smap.get(new CaseInsensitiveString(mapKey, this.caseMatch))) != null) {
                                apostrophe = true;
                            }
                        }
                    }
                }
                if (objs != null) {
                    Object[] oarr = (Object[])objs;
                    StringBuilder rowBuilder = new StringBuilder();
                    for (int m = 0; m < oarr.length; ++m) {
                        int del;
                        String line;
                        int ind;
                        Object[] arr = (Object[])oarr[m];
                        String tar = arr[0].toString();
                        String src = arr[3].toString();
                        if (apostrophe || matchType == 1) {
                            src = part;
                        }
                        if ((ind = ((Integer)arr[2]).intValue()) >= 0 && ind < this.fields.length) {
                            line = this.fields[ind];
                        } else {
                            int k = ind + 1;
                            if ((k = -k) >= this.newFields.length) continue;
                            line = this.newFields[k];
                        }
                        boolean changed = uniqueSet.add(line);
                        if (!changed && matchType != 1 || line.length() <= 0) continue;
                        if ((line = XMLHelper.resolveHTMLSwingEntities(line)).indexOf(this.TargetDelimiter) != -1) {
                            line = line.replace(this.TargetDelimiter, "<br>");
                        }
                        String[] extraFields = AppPreferences.matchBoardShowGlossaryFields ? new String[8] : null;
                        StringBuilder row = new StringBuilder();
                        if (this.verticalDisplay) {
                            this.makeVerticalRow(src, ind, line, extraFields, row, colorRow);
                        } else {
                            this.makeHorizontalRow(src, ind, line, extraFields, row, colorRow);
                        }
                        if (row.length() > 0) {
                            rowBuilder.append((CharSequence)row);
                            colorRow = !colorRow;
                        }
                        char ex = line.charAt(0);
                        boolean nt = false;
                        if (this.nontranslatablesOnly || ex == '!') {
                            nt = true;
                        }
                        if ((del = tar.indexOf(this.TargetDelimiter)) != -1) {
                            String[] tars = Pattern.compile(this.TargetDelimiter, 16).split(tar);
                            for (int k = 0; k < tars.length; ++k) {
                                String trg = tars[k];
                                int pipe = trg.indexOf(124);
                                if (pipe != -1) {
                                    char[] arrString = trg.toCharArray();
                                    StringBuilder sb = new StringBuilder();
                                    for (int l = 0; l < arrString.length; ++l) {
                                        char b = arrString[l];
                                        if (b == '|') continue;
                                        sb.append(b);
                                    }
                                    trg = sb.toString();
                                }
                                if (AppPreferences.autonumbers && fullRegExMatch) {
                                    trg = NumbersHelper.autoTransfer(fullSegment, trg);
                                }
                                if (this.autoAssemblingStopped) continue;
                                int mtype = matchType == 1 ? 6 : (matchType == 2 || matchType == 3 ? 5 : (AppPreferences.glossaryPrefixMatch ? 4 : 1));
                                this.targetSet.add(trg);
                                String n = this.getName();
                                FragmentMatch fmatch = new FragmentMatch(part, src, trg, n, false, mtype, 2, 0, this.priority, k);
                                fmatch.setHitsNumer(ind);
                                fmatch.setFields(extraFields);
                                event.addFragmentMatch(fmatch);
                            }
                            if (!AppPreferences.displayLongestGlossaryMatchOnly) continue;
                            i = j;
                            continue;
                        }
                        int pipe = tar.indexOf(124);
                        if (pipe != -1) {
                            char[] arrString = tar.toCharArray();
                            StringBuilder sb = new StringBuilder();
                            for (int l = 0; l < arrString.length; ++l) {
                                char b = arrString[l];
                                if (b == '|') continue;
                                sb.append(b);
                            }
                            tar = sb.toString();
                        }
                        if (AppPreferences.autonumbers && fullRegExMatch) {
                            tar = NumbersHelper.autoTransfer(fullSegment, tar);
                        }
                        if (this.autoAssemblingStopped) continue;
                        int mtype = nt ? 7 : (matchType == 1 ? 6 : (matchType == 2 || matchType == 3 ? 5 : (AppPreferences.glossaryPrefixMatch ? 4 : 1)));
                        if (nt && tar.length() == 0) {
                            String ckey = Placeables.getConvertedPlaceable(part);
                            if (ckey != null) {
                                part = ckey;
                            }
                            tar = part;
                        }
                        this.targetSet.add(tar);
                        String n = this.getName();
                        FragmentMatch fmatch = new FragmentMatch(part, src, tar, n, false, mtype, 2, 0, this.priority, 0);
                        fmatch.setHitsNumer(ind);
                        fmatch.setFields(extraFields);
                        event.addFragmentMatch(fmatch);
                        if (!AppPreferences.displayLongestGlossaryMatchOnly) continue;
                        i = j;
                    }
                    if (rowBuilder.length() > 0) {
                        rowMap.put(part, rowBuilder);
                    }
                }
                part = part.substring(0, part.length() - key.length());
            }
        }
        for (Map.Entry entry : rowMap.entrySet()) {
            buffer.append(((StringBuilder)entry.getValue()).toString());
        }
        if (rowMap.isEmpty()) {
            buffer.append("<tr>");
            buffer.append(HTMLFormat.glossaryRowLeftAlign);
            buffer.append("<b>");
            int size = 0;
            if (this.fields != null) {
                size = this.fields.length;
            }
            if (this.newFields != null) {
                size += this.newFields.length;
            }
            if (size > 0 && hasHeader) {
                --size;
            }
            buffer.append("<a href=").append("next").append(">");
            buffer.append("Size: ");
            buffer.append(size).append("</a>");
            if (this.readOnly) {
                buffer.append("<br>read only");
            }
            buffer.append("</b>");
            buffer.append("</td>");
            buffer.append("</tr>");
        }
        buffer.append(HTMLFormat.endTable);
        buffer.append(HTMLFormat.endHTML);
        try {
            this.showContent(buffer.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized Fixable getGlossaryEntriesQA(Fixable fixable) {
        String target;
        String source;
        DefaultXMLElement tu;
        if (fixable instanceof XLIFFUnit) {
            tu = (XLIFFUnit)fixable;
            source = ((XLIFFUnit)tu).getSourceText();
            target = ((XLIFFUnit)tu).getTargetText();
        } else if (fixable instanceof TTXUnit) {
            tu = (TTXUnit)fixable;
            source = ((TTXUnit)tu).getSourceText();
            target = ((TTXUnit)tu).getTargetText();
        } else {
            return null;
        }
        if (target != null) {
            target = XMLHelper.parseCustomTags(target);
            target = target.toLowerCase();
            target = XMLHelper.normalizeSpace(target);
            target = target.replaceAll(AppPreferences.punctuation, "");
            target = target.trim();
            target = target.replaceAll("\\s+", " ");
        }
        String segment = source.replaceAll(AppPreferences.punctuation, "");
        segment = segment.trim();
        segment = XMLHelper.normalizeSpace(segment);
        segment = segment.replaceAll("\\s+", " ");
        Issue issue = null;
        String[] str = this.pattern.split(segment);
        int sindex = 0;
        int eindex = 0;
        int slength = segment.length();
        block0: for (int i = 0; i < str.length; ++i) {
            String key = str[i];
            if (key.length() == 0) continue;
            sindex = segment.indexOf(key, sindex);
            String part = segment.substring(sindex, slength);
            sindex += key.length();
            for (int j = str.length - 1; j >= i; --j) {
                key = str[j];
                eindex = part.lastIndexOf(key) + key.length();
                part = part.substring(0, eindex);
                String mapKey = AppPreferences.glossaryPrefixMatch && !AppPreferences.noWordSeparatorSourceLanguage ? this.makePrefixes(part) : part;
                Object objs = this.smap.get(new CaseInsensitiveString(mapKey, this.caseMatch));
                if (this.regularExpressions != null && objs == null) {
                    objs = this.findRegularExpression(part);
                }
                if (this.roots != null && objs == null && i == j) {
                    objs = this.findRoot(part);
                }
                if (objs != null) {
                    Object[] oarr = (Object[])objs;
                    boolean hasMatch = false;
                    StringBuilder unusedTarget = new StringBuilder();
                    for (int m = 0; m < oarr.length; ++m) {
                        String[] tars;
                        Object[] arr = (Object[])oarr[m];
                        String tar = arr[0].toString();
                        int ind = (Integer)arr[2];
                        int del = tar.indexOf(this.TargetDelimiter);
                        boolean match = false;
                        if (del != -1) {
                            tars = Pattern.compile(this.TargetDelimiter, 16).split(tar);
                            for (int k = 0; k < tars.length; ++k) {
                                String string = tars[k];
                                string = string.toLowerCase();
                                string = XMLHelper.normalizeSpace(string);
                                string = string.replaceAll(AppPreferences.punctuation, "");
                                string = string.trim();
                                match = this.compareTargetsForQA(target, string = string.replaceAll("\\s+", " "));
                                if (!match) continue;
                                hasMatch = true;
                                break;
                            }
                        } else {
                            tars = new String[]{tar};
                            String tar2 = tar.toLowerCase();
                            tar2 = XMLHelper.normalizeSpace(tar2);
                            tar2 = tar2.replaceAll(AppPreferences.punctuation, "");
                            tar2 = tar2.trim();
                            match = this.compareTargetsForQA(target, tar2 = tar2.replaceAll("\\s+", " "));
                            if (match) {
                                hasMatch = true;
                            }
                        }
                        if (target != null && match) continue;
                        if (unusedTarget.length() > 0) {
                            unusedTarget.append(";");
                        }
                        unusedTarget.append(tar);
                    }
                    boolean flag = false;
                    if (!hasMatch || target == null) {
                        flag = true;
                    } else if (AppPreferences.qaGlossaryDuplicates && unusedTarget.length() > 0) {
                        flag = true;
                    }
                    if (flag) {
                        if (issue == null) {
                            issue = new Issue(1);
                            fixable.addIssue(issue);
                        }
                        String s = this.getName();
                        issue.addMessage("<u>" + s + "</u><br><br>" + part);
                        issue.addMessage("<u>" + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT TERM USE") + "</u><br><br>" + unusedTarget.toString());
                    }
                    i = j;
                    continue block0;
                }
                part = part.substring(0, part.length() - key.length());
            }
        }
        if (issue != null) {
            return fixable;
        }
        return null;
    }

    private boolean compareTargetsForQA(String target, String target2) {
        boolean match = false;
        if (AppPreferences.qaTermMatch == 0 && !AppPreferences.noWordSeparatorTargetLanguage) {
            match = this.fuzzytermMatch(target2, target, AppPreferences.qaTermAccuracy);
        } else {
            int mi = target.indexOf(target2);
            if (mi != -1) {
                match = true;
            }
        }
        return match;
    }

    private boolean fuzzytermMatch(String term, String target, int proc) {
        boolean match = false;
        String[] str = this.spacePatternQA.split(term);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length; ++i) {
            String string = str[i];
            int len = string.length();
            if (len <= 0) continue;
            int newlen = len * proc / 100;
            if (newlen == 0) {
                newlen = 1;
            }
            string = string.substring(0, newlen);
            string = Pattern.quote(string);
            sb.append("\\b");
            sb.append(string);
            sb.append("[^\\s]*");
            if (i >= str.length - 1) continue;
            sb.append("(\\s+)");
        }
        Pattern pattern = Pattern.compile(sb.toString());
        Matcher m = pattern.matcher(target);
        if (m.find()) {
            match = true;
        }
        return match;
    }

    private Object[] findRegularExpression(String s) {
        Iterator it = this.regularExpressions.iterator();
        while (it.hasNext()) {
            Pattern p;
            String regEx = it.next().toString();
            try {
                p = !this.caseMatch ? Pattern.compile(regEx, 258) : Pattern.compile(regEx, 256);
            }
            catch (PatternSyntaxException ex) {
                ex.printStackTrace();
                it.remove();
                continue;
            }
            Matcher m = p.matcher(s);
            if (!m.find()) continue;
            Object[] term = (Object[])this.regularExpressionsMap.get(regEx);
            return term;
        }
        return null;
    }

    private void removeRegularExpression(String key) {
        String regEx = key.substring(1);
        if (!regEx.startsWith("\\A")) {
            regEx = "\\A" + regEx;
        }
        if (!regEx.endsWith("\\z")) {
            regEx = regEx + "\\z";
        }
        this.regularExpressionsMap.remove(regEx);
    }

    private void addRegularExpression(String key, Object[] value) {
        Object[] o;
        String regEx = key.substring(1);
        if (!regEx.startsWith("\\A")) {
            regEx = "\\A" + regEx;
        }
        if (!regEx.endsWith("\\z")) {
            regEx = regEx + "\\z";
        }
        if ((o = this.regularExpressionsMap.put(regEx, value)) != null) {
            Object[] oo = o;
            Object[] arr = (Object[])value[0];
            oo = this.addTargetToArray(oo, arr);
            this.regularExpressionsMap.put(regEx, oo);
        }
    }

    private Object[] findRoot(String s) {
        if (!this.caseMatch) {
            s = s.toLowerCase();
        }
        Iterator it = this.roots.iterator();
        while (it.hasNext()) {
            String root = it.next().toString();
            if (s.indexOf(root) == -1) continue;
            Object[] term = (Object[])this.rootsMap.get(root);
            return term;
        }
        return null;
    }

    private void addRoot(String key, Object[] value, int pipe) {
        Object[] o;
        int pipe2 = key.indexOf(124, pipe + 1);
        String root = pipe2 != -1 ? key.substring(pipe + 1, pipe2) : key.substring(0, pipe);
        if (!this.caseMatch) {
            root = root.toLowerCase();
        }
        if ((o = this.rootsMap.put(root, value)) != null) {
            Object[] oo = o;
            Object[] arr = (Object[])value[0];
            oo = this.addTargetToArray(oo, arr);
            this.rootsMap.put(root, oo);
        }
    }

    private void removeRoot(String key, int pipe) {
        int pipe2 = key.indexOf(124, pipe + 1);
        String root = pipe2 != -1 ? key.substring(pipe + 1, pipe2) : key.substring(0, pipe);
        if (!this.caseMatch) {
            root = root.toLowerCase();
        }
        this.rootsMap.remove(root);
    }

    private Object[] addTargetToArray(Object[] o, Object[] s) {
        int len = o.length;
        int nlen = len + 1;
        Object[] oo = new Object[nlen];
        for (int i = 0; i < o.length; ++i) {
            oo[i] = o[i];
        }
        oo[len] = s;
        return oo;
    }

    private void modifyTargetArray(Object[] old, Object[] n) {
        for (int i = 0; i < old.length; ++i) {
            int t;
            Object[] temp = (Object[])old[i];
            int k = (Integer)temp[2];
            if (k != (t = ((Integer)n[2]).intValue())) continue;
            old[i] = n;
            break;
        }
    }

    public void addDirectEntry(String key, String entry) {
        if (this.isReadOnly()) {
            JOptionPane.showMessageDialog(this.topui, this.getName() + " - " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("READ ONLY GLOSSARY"));
            return;
        }
        if (key != null && key.length() > 0 && entry != null && entry.length() > 0) {
            TranslateEvent event;
            Workflow w;
            key = XMLHelper.parseTags(key);
            entry = XMLHelper.parseTags(entry);
            if (AppPreferences.trimNewterm) {
                key = XMLHelper.trimNewTermStart(key);
                key = XMLHelper.trimNewTermEnd(key);
                entry = XMLHelper.trimNewTermStart(entry);
                entry = XMLHelper.trimNewTermEnd(entry);
            }
            this.updateDictionary(key, entry, null);
            this.addToSourceMap();
            if (this.nontranslatablesOnly && (w = this.topui.getWorkflowView().getWorkflowManager().getWorkflow()) != null) {
                w.refreshSourcePane();
            }
            if ((event = this.topui.getMemoryView().getTranslateEvent()) != null) {
                this.findGlossaryMatches(event);
                event.addNewFragmentsToMatchBoard();
            }
            if (this.newEntryIndex >= AppPreferences.gautosave) {
                this.saveResource();
            }
        }
    }

    private String prependPipe(String key) {
        char ch;
        int klen = key.length();
        if (klen > 0 && (ch = key.charAt(0)) != '|') {
            key = '|' + key;
        }
        return key;
    }

    public void addToSourceMap() {
        int len;
        if (this.newFields != null && (len = this.newFields.length) > 0) {
            for (int j = 0; j < len; ++j) {
                Object[] ob;
                String line = this.newFields[j];
                if (line == null) continue;
                int i = line.indexOf(this.KeyEntrySeparator);
                if (i != -1) {
                    CaseInsensitiveString cisKey;
                    Object[] o;
                    Object[] ob2;
                    char q;
                    String key = "";
                    String value = "";
                    String note = null;
                    if (this.sourceColumnIndex != -1 && this.targetColumnIndex != -1) {
                        StringBuilder columns = new StringBuilder();
                        int ind = 0;
                        Pattern pat = Pattern.compile("[^\t]*(\t|\\z)");
                        Matcher m = pat.matcher(line);
                        while (m.find()) {
                            String s = m.group().trim();
                            if (s.length() > 0) {
                                if (ind == this.sourceColumnIndex) {
                                    key = s;
                                } else if (ind == this.targetColumnIndex) {
                                    value = s;
                                } else {
                                    if (columns.length() > 0) {
                                        columns.append('\t');
                                    }
                                    columns.append(s);
                                }
                            }
                            ++ind;
                        }
                        if (columns.length() > 0) {
                            note = columns.toString();
                        }
                    } else {
                        key = line.substring(0, i);
                        value = line.substring(i + 1);
                        if ((i = value.indexOf(this.KeyEntrySeparator)) != -1) {
                            String s = value;
                            value = value.substring(0, i);
                            note = s.substring(i + this.KeyEntrySeparator.length());
                        }
                    }
                    if (key.length() > 0 && (q = key.charAt(0)) == '?') {
                        if (value.length() > 0) {
                            AssembleParser.addToSegmentPatterns(key, value, true);
                        }
                        return;
                    }
                    if (key.indexOf(this.TargetDelimiter) != -1) {
                        String[] keys = this.alterntivesPattern.split(key);
                        for (int k = 0; k < keys.length; ++k) {
                            Object[] ob3;
                            CaseInsensitiveString cisKey2;
                            Object[] o2;
                            Object[] arr = new Object[4];
                            arr[0] = value;
                            arr[1] = note;
                            arr[2] = -(j + 1);
                            String skey = keys[k];
                            arr[3] = skey;
                            int pipe = skey.indexOf(124);
                            if (this.regExOnly && pipe != 0) {
                                skey = this.prependPipe(skey);
                                pipe = 0;
                            }
                            if (pipe != -1) {
                                ob2 = new Object[]{arr};
                                if (pipe == 0) {
                                    this.addRegularExpression(skey, ob2);
                                    if (this.regularExpressions == null) {
                                        this.regularExpressions = this.regularExpressionsMap.keySet();
                                    }
                                } else {
                                    this.addRoot(skey, ob2, pipe);
                                    if (this.roots == null) {
                                        this.roots = this.rootsMap.keySet();
                                    }
                                }
                                skey = skey.replace("|", "");
                            }
                            String mapKey = skey.replaceAll(AppPreferences.punctuation, "");
                            if (AppPreferences.glossaryPrefixMatch) {
                                mapKey = !AppPreferences.noWordSeparatorSourceLanguage ? this.makePrefixes(mapKey) : this.makePrefixCJK(mapKey);
                            }
                            if ((o2 = this.smap.put(cisKey2 = new CaseInsensitiveString(mapKey, this.caseMatch), ob3 = new Object[]{arr})) == null) continue;
                            Object[] oo = o2;
                            oo = this.addTargetToArray(oo, arr);
                            this.smap.put(cisKey2, oo);
                        }
                        continue;
                    }
                    Object[] arr = new Object[]{value, note, -(j + 1), key};
                    int pipe = key.indexOf(124);
                    if (this.regExOnly && pipe != 0) {
                        key = this.prependPipe(key);
                        pipe = 0;
                    }
                    if (pipe != -1) {
                        Object[] ob4 = new Object[]{arr};
                        if (pipe == 0) {
                            this.addRegularExpression(key, ob4);
                            if (this.regularExpressions == null) {
                                this.regularExpressions = this.regularExpressionsMap.keySet();
                            }
                        } else {
                            this.addRoot(key, ob4, pipe);
                            if (this.roots == null) {
                                this.roots = this.rootsMap.keySet();
                            }
                        }
                        key = key.replace("|", "");
                    }
                    String mapKey = key.replaceAll(AppPreferences.punctuation, "");
                    if (AppPreferences.glossaryPrefixMatch) {
                        mapKey = !AppPreferences.noWordSeparatorSourceLanguage ? this.makePrefixes(mapKey) : this.makePrefixCJK(mapKey);
                    }
                    if ((o = this.smap.put(cisKey = new CaseInsensitiveString(mapKey, this.caseMatch), ob2 = new Object[]{arr})) == null) continue;
                    Object[] oo = o;
                    oo = this.addTargetToArray(oo, arr);
                    this.smap.put(cisKey, oo);
                    continue;
                }
                if (line.length() <= 0) continue;
                char q = line.charAt(0);
                if (q == '!' && line.length() > 1) {
                    String key = line.substring(1);
                    Placeables.addPlaceable(key);
                    Object[] arr = new Object[]{"", null, -(j + 1), line};
                    int pipe = key.indexOf(124);
                    if (this.regExOnly && pipe != 0) {
                        key = this.prependPipe(key);
                        pipe = 0;
                    }
                    if (pipe != -1) {
                        Object[] ob5 = new Object[]{arr};
                        if (pipe == 0) {
                            this.addRegularExpression(key, ob5);
                        } else {
                            this.addRoot(key, ob5, pipe);
                        }
                        key = key.replace("|", "");
                    }
                    CaseInsensitiveString cisKey = new CaseInsensitiveString(key, this.caseMatch);
                    ob = new Object[]{arr};
                    this.smap.put(cisKey, ob);
                    continue;
                }
                if (!this.nontranslatablesOnly) continue;
                if (line.charAt(0) != '#') {
                    Placeables.addPlaceable(line);
                }
                Object[] arr = new Object[]{"", null, -(j + 1), line};
                String key = line;
                int pipe = key.indexOf(124);
                if (this.regExOnly && pipe != 0) {
                    key = this.prependPipe(key);
                    pipe = 0;
                }
                if (pipe != -1) {
                    Object[] ob6 = new Object[]{arr};
                    if (pipe == 0) {
                        this.addRegularExpression(key, ob6);
                    } else {
                        this.addRoot(key, ob6, pipe);
                    }
                    key = key.replace("|", "");
                }
                CaseInsensitiveString cisKey = new CaseInsensitiveString(key, this.caseMatch);
                ob = new Object[]{arr};
                this.smap.put(cisKey, ob);
            }
        }
    }

    private void showPopUp(Component comp, int x, int y) {
        JPopupMenu pop = new JPopupMenu();
        JMenuItem nextTUs = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BROWSE GLOSSARY") + " - " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FORWARD"));
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_RIGHT, (int)nextTUs.getFont().getSize(), (Color)nextTUs.getForeground());
        nextTUs.setIcon((Icon)ficon);
        nextTUs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlossaryResource.this.nextResource();
            }
        });
        JMenuItem previousTUs = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BROWSE GLOSSARY") + " - " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BACK"));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_LEFT, (int)previousTUs.getFont().getSize(), (Color)previousTUs.getForeground());
        previousTUs.setIcon((Icon)ficon);
        previousTUs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlossaryResource.this.previousResource();
            }
        });
        pop.add(nextTUs);
        pop.add(previousTUs);
        pop.addSeparator();
        ArrayList header = this.getHeader();
        if (header != null && !header.isEmpty()) {
            JMenu searchBox = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEARCH"));
            pop.add(searchBox);
            pop.addSeparator();
            int i = 0;
            ButtonGroup searchGroup = new ButtonGroup();
            for (String next : header) {
                String n = LanguageCodes.getName(next);
                if (n != null) {
                    int k = n.indexOf(40);
                    next = k != -1 ? n.substring(0, k) : n;
                }
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(next);
                item.setName(String.valueOf(i));
                if (this.searchColumnIndex >= 0 && this.searchColumnIndex == i) {
                    item.setSelected(true);
                }
                item.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getItem();
                        String name = item.getName();
                        int i = Integer.parseInt(name);
                        GlossaryResource.this.setSearchColumn(i);
                    }
                });
                ++i;
                searchBox.add(item);
                searchGroup.add(item);
            }
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ALL"));
            item.setName("All");
            if (this.searchColumnIndex < 0) {
                item.setSelected(true);
            }
            item.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    GlossaryResource.this.setSearchColumn(-2);
                }
            });
            searchBox.addSeparator();
            searchBox.add(item);
            searchGroup.add(item);
        }
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("READ ONLY"));
        item.setEnabled(true);
        item.setSelected(this.readOnly);
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GlossaryResource.this.setReadOnly(true);
                } else {
                    GlossaryResource.this.setReadOnly(false);
                }
            }
        });
        pop.add(item);
        item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MATCH CASE"));
        item.setEnabled(true);
        item.setSelected(this.caseMatch);
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GlossaryResource.this.setMatchCase(true);
                } else {
                    GlossaryResource.this.setMatchCase(false);
                }
            }
        });
        pop.add(item);
        if (this.fieldsToHide.size() > 0) {
            item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIELDS TO HIDE:") + " " + AppPreferences.fieldsToHideGlossary);
            item.setEnabled(true);
            item.setSelected(this.hideFields);
            item.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    GlossaryResource.this.hideFields = e.getStateChange() == 1;
                }
            });
            pop.add(item);
        }
        JMenuItem mitem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RELOAD GLOSSARY"));
        mitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                GlossaryResource.this.reloadGlossary();
                Project p = GlossaryResource.this.topui.getProjectView().getProject();
                if (p != null && (i = p.getCurrenTUIndex()) != -1) {
                    p.edit("#" + Integer.toString(i));
                }
            }
        });
        pop.add(mitem);
        mitem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT GLOSSARY"));
        mitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = GlossaryResource.this.getLocation();
                if (url != null) {
                    File file = new File(url);
                    ResourceView rv = GlossaryResource.this.topui.getResourceView();
                    rv.viewFile(file);
                }
            }
        });
        pop.add(mitem);
        JCheckBoxMenuItem itemDisplay = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("VERTICAL DISPLAY"));
        itemDisplay.setSelected(this.verticalDisplay);
        itemDisplay.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GlossaryResource.this.verticalDisplay = true;
                    GlossaryResource.this.nextResource();
                } else {
                    GlossaryResource.this.verticalDisplay = false;
                    GlossaryResource.this.nextResource();
                }
            }
        });
        pop.add(itemDisplay);
        JCheckBoxMenuItem itemRows = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHADE ALTERNATE ROWS"));
        itemRows.setSelected(AppPreferences.shadeGlossaryRows);
        itemRows.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.shadeGlossaryRows = true;
                    HTMLFormat.setStyles();
                    GlossaryResource.this.nextResource();
                } else {
                    AppPreferences.shadeGlossaryRows = false;
                    HTMLFormat.setStyles();
                    GlossaryResource.this.nextResource();
                }
            }
        });
        pop.add(itemRows);
        pop.addSeparator();
        item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOW PRIORITY"));
        if (this.priority == 0) {
            item.setSelected(true);
        }
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GlossaryResource.this.autoAssemblingStopped = false;
                    GlossaryResource.this.setPriority(0);
                }
            }
        });
        pop.add(item);
        item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEDIUM PRIORITY"));
        if (this.priority == 1) {
            item.setSelected(true);
        }
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GlossaryResource.this.autoAssemblingStopped = false;
                    GlossaryResource.this.setPriority(1);
                }
            }
        });
        pop.add(item);
        item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("HIGH PRIORITY"));
        if (this.priority == 2) {
            item.setSelected(true);
        }
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GlossaryResource.this.autoAssemblingStopped = false;
                    GlossaryResource.this.setPriority(2);
                }
            }
        });
        pop.add(item);
        item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("KEEP OUT OF AUTO-ASSEMBLING"));
        item.setEnabled(true);
        item.setSelected(this.autoAssemblingStopped);
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GlossaryResource.this.autoAssemblingStopped = true;
                    GlossaryResource.this.setPriority(3);
                }
            }
        });
        pop.add(item);
        item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("STOP AUTOMATIC MATCHING"));
        item.setEnabled(true);
        item.setSelected(this.automaticMatchingStopped);
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GlossaryResource.this.automaticMatchingStopped = e.getStateChange() == 1;
            }
        });
        pop.add(item);
        item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TERMS CONSISTENCY CHECK"));
        item.setSelected(this.QATermsCheck);
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GlossaryResource.this.setQATermsCheck(true);
                } else {
                    GlossaryResource.this.setQATermsCheck(false);
                }
            }
        });
        pop.addSeparator();
        pop.add(item);
        pop.show(comp, x, y);
    }

    private String makePrefixCJK(String key) {
        if (key.length() > AppPreferences.memPrefixLength) {
            key = key.substring(0, AppPreferences.memPrefixLength);
        }
        return key;
    }

    private String makePrefixes(String key) {
        int min = AppPreferences.memPrefixLength;
        int proc = AppPreferences.memPrefixAccuracy;
        StringBuilder sb = new StringBuilder();
        String[] arr = key.split(" ");
        for (int i = 0; i < arr.length; ++i) {
            String string = arr[i];
            int ai = string.indexOf(39);
            if (ai != -1) {
                String s = string.substring(ai + 1);
                int len = s.length();
                if (len >= min) {
                    if (proc == 0) {
                        string = s.substring(0, min);
                    } else {
                        int newlen = len * proc / 100;
                        if (newlen < min) {
                            newlen = min;
                        }
                        string = s.substring(0, newlen);
                    }
                }
            } else {
                int len = string.length();
                if (len >= min) {
                    if (proc == 0) {
                        string = string.substring(0, min);
                    } else {
                        int newlen = len * proc / 100;
                        if (newlen < min) {
                            newlen = min;
                        }
                        string = string.substring(0, newlen);
                    }
                }
            }
            sb.append(string);
            if (i >= arr.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    private static String lcs(String a, String b) {
        int[][] lengths = new int[a.length() + 1][b.length() + 1];
        for (int i = 0; i < a.length(); ++i) {
            for (int j = 0; j < b.length(); ++j) {
                lengths[i + 1][j + 1] = a.charAt(i) == b.charAt(j) ? lengths[i][j] + 1 : Math.max(lengths[i + 1][j], lengths[i][j + 1]);
            }
        }
        StringBuffer sb = new StringBuffer();
        int x = a.length();
        int y = b.length();
        while (x != 0 && y != 0) {
            if (lengths[x][y] == lengths[x - 1][y]) {
                --x;
                continue;
            }
            if (lengths[x][y] == lengths[x][y - 1]) {
                --y;
                continue;
            }
            assert (a.charAt(x - 1) == b.charAt(y - 1));
            sb.append(a.charAt(x - 1));
            --x;
            --y;
        }
        return sb.reverse().toString();
    }

    public void checkTrialVersionLimit(boolean showMessageAlways) {
        if (AppPreferences.isTrialVersion && totalEntriesLoaded >= 500) {
            this.readOnly = true;
            if (!trialMessageDisplayed || showMessageAlways) {
                String cont;
                trialMessageDisplayed = true;
                String message = "The free version of CafeTran Espresso allows you to work with translation memories (TM's) up to 1000 translation units (TU's)\nin size (in total among all TM's), and with glossary files with up to 500 terms (in total). You have reached one of those limits.\nTo unlock the program for use with these larger resources, it is necessary to purchase a license file from the CafeTran.com website.\nOnce you load the license file into the program you will be able to use the program with TM's and glossaries of unlimited size.";
                String s = "Trial Version Limit";
                String buy = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PURCHASE LICENSE");
                Object[] options = new String[]{buy, cont = "Continue to use free version, with limits"};
                int i = JOptionPane.showOptionDialog(this.topui, message, s, 0, 1, null, options, buy);
                if (i == 0) {
                    try {
                        URI uri = new URI(AppPreferences.purchase_url);
                        this.topui.getResourceView();
                        ResourceView.browse(uri);
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(MainView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }
}

