/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import translator.AppPreferences;
import translator.DictionaryResource;
import translator.LanguageCodes;
import translator.ui.Colors;
import translator.ui.GridPopupMenu;
import translator.ui.HTMLFormat;

public class GlossaryTip {
    String startTable = "<TABLE WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLPADDING=4 CELLSPACING=0>";
    String endTable = "</TABLE>";
    String sRow = "<TR>";
    String eRow = "</TR>";
    String sBLeftCol = "<TD WIDTH=50% style='border-width: 1px; border-style: solid; border-color: " + HTMLFormat.barBackgroundColor + "' VALIGN=CENTER ALIGN=LEFT>";
    String sBHeaderCol = "<TD WIDTH=50% COLOR=white BGCOLOR=" + Colors.colorGlossaryHTML + " style='border-width: 1px; border-style: solid; border-color: " + HTMLFormat.barBackgroundColor + "' VALIGN=CENTER ALIGN=CENTER NOWRAP>";
    String eCol = "</TD>";
    private GridPopupMenu pop;

    private void setPopup() {
        this.pop = new GridPopupMenu();
        this.pop.setBorder(BorderFactory.createEmptyBorder());
        this.pop.setGrid(AppPreferences.backGrid);
        if (AppPreferences.background != 0) {
            this.pop.setBackground(new Color(AppPreferences.background));
        }
        this.pop.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                GlossaryTip.this.pop.removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                GlossaryTip.this.pop.removeAll();
            }
        });
    }

    public void hideInfo() {
        if (this.pop != null) {
            this.pop.setVisible(false);
        }
    }

    public void showInfo(DictionaryResource dictionary, String s, Component comp, int x, int y) {
        Pattern p;
        String[] termArray;
        int j;
        String fs;
        String[] entries;
        int index;
        int i;
        String ss = s.substring(1);
        if (ss.startsWith("-")) {
            ss = ss.substring(1);
            i = Integer.parseInt(ss);
            index = i - 1;
            entries = dictionary.getFields(true);
        } else {
            index = i = Integer.parseInt(ss);
            entries = dictionary.getFields(false);
        }
        if (entries != null && entries.length > index && (fs = entries[index]) != null && (j = fs.indexOf(dictionary.getKeyEntrySeparator())) != -1 && (termArray = (p = Pattern.compile(dictionary.getKeyEntrySeparator(), 16)).split(fs)).length > 2) {
            this.showTUToolTip(termArray, dictionary.getHeader(), comp, x, y);
        }
    }

    private void showTUToolTip(String[] props, ArrayList header, Component comp, int x, int y) {
        int ssize = Toolkit.getDefaultToolkit().getScreenSize().width;
        int max = ssize / 2;
        if (header != null && header.size() > 4) {
            max = ssize;
        }
        Font f = new Font(AppPreferences.mfontname, AppPreferences.mfontstyle, AppPreferences.mfontsize);
        String para = "<p style='background: " + HTMLFormat.htmlBackgroundColor + "; color: " + HTMLFormat.htmlForegroundColor + "'>";
        StringBuilder html = new StringBuilder();
        html.append("<HTML>");
        html.append("<BODY width=" + max + ">");
        html.append(this.startTable);
        if (props != null) {
            int i;
            if (header != null) {
                html.append(this.sRow);
                for (i = 0; i < header.size(); ++i) {
                    html.append(this.sBHeaderCol);
                    html.append("<p>");
                    String h = (String)header.get(i);
                    String n = LanguageCodes.getName(h);
                    if (n != null) {
                        int j = n.indexOf(40);
                        if (j != -1) {
                            n = n.substring(0, j - 1);
                        }
                        html.append(n);
                    } else {
                        html.append(h);
                    }
                    html.append("</p>");
                    html.append(this.eCol);
                    if (i == 11) break;
                }
                html.append(this.eRow);
            }
            html.append(this.sRow);
            for (i = 0; i < props.length; ++i) {
                String field = props[i];
                if (field != null) {
                    html.append(this.sBLeftCol);
                    html.append(para);
                    html.append(field);
                    html.append("</p>");
                    html.append(this.eCol);
                }
                if (i == 11) break;
            }
            html.append(this.eRow);
        }
        html.append(this.endTable);
        html.append("</BODY></HTML>");
        JLabel item = new JLabel();
        item.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                GlossaryTip.this.hideInfo();
            }
        });
        item.setOpaque(true);
        item.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (HTMLFormat.htmlBackgroundColor.equals("white")) {
            item.setBackground(Color.white);
        } else {
            item.setBackground(new Color(AppPreferences.tbackground2));
        }
        item.setText(html.toString());
        item.setFont(f);
        item.setText(html.toString());
        item.setFont(f);
        if (this.pop == null) {
            this.setPopup();
        } else {
            this.pop.removeAll();
            this.pop.setVisible(false);
        }
        this.pop.add(item);
        this.pop.show(comp, x, y);
    }
}

