/*
 * Decompiled with CFR 0.152.
 */
package translator;

import com.ctndev.truelicense.maven.keymgr.LicensingSchema;
import java.awt.Dialog;
import java.awt.Frame;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.java.truelicense.core.LicenseConsumerManager;
import net.java.truelicense.core.LicenseManagementException;
import net.java.truelicense.swing.LicenseWizard;
import translator.AppPreferences;
import translator.MainView;
import translator.ResourceView;

public final class License {
    public static final boolean allowLicenseUninstall = false;
    public static final boolean checkSystemId = true;
    private static final long workerDelaySecondsInitial = 3600L;
    private static final long workerDelaySecondsPeriodic = 3600L;
    private static final int gracePeriodDays = 14;
    private static final LicenseConsumerManager licenseManager = LicensingSchema.manager();
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static long daysUntilExpiration = 0L;

    private static void showBuyDialog(String title, String bodyText, String buyButtonText, String buttonUri) {
        Object[] options = new Object[]{buyButtonText, "Close"};
        int click = JOptionPane.showOptionDialog(null, "<html><p style='width:400px;'>" + bodyText + "</p></html>", title, -1, 2, null, options, options[0]);
        if (click == 0) {
            try {
                URI uri = new URI(buttonUri);
                ResourceView.browse(uri);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(MainView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static void showJustActivatedDialog() {
        JOptionPane.showMessageDialog(null, "Your license file has been imported, and the CafeTran Espresso full version has been unlocked. The restrictions on TM and glossary size have been removed.\n\nThe license file may now be moved or deleted, since it is not needed for CafeTran to stay unlocked.\n\nPlease restart the program to launch the full version.", "License import successful", 2);
    }

    private static void showLicenseExpiredDialog() {
        License.showBuyDialog("License file expired", "The license file that you most recently imported into this version of CafeTran Espresso expired more than 14 days ago. Therefore, the restrictions on TM and glossary size found in trial versions of this software (1000 translation units and 500 terms, respectively), have been reinstated.<br><br>To remove these restrictions, you should go to CafeTran.com to obtain a new license file, and then import that license file into this program using the appropriate option under the About menu.<br><br>", "Visit your account page at CafeTran.com", AppPreferences.account_url);
    }

    private static void showLicenseGracePeriodStartDialog(String gracePeriodEndDateStr) {
        License.showBuyDialog("License file expired", "Your current license file has expired. To ensure ongoing, unrestricted use of this copy of CafeTran Espresso, you should visit CafeTran.com to obtain a new license file. After you obtain the license file, you should import it into this software using the option provided under the About menu item.<br><br>If you do not obtain and import a new license file by " + gracePeriodEndDateStr + ", the restrictions on TM and glossary size that are present in trial versions of CafeTran Espresso will be reinstated.<br><br>", "Visit your account page at CafeTran.com", AppPreferences.account_url);
    }

    private static void showUpcomingGracePeriodDialog() {
        License.showBuyDialog("License file expires soon", "Your current CafeTran Espresso license file is valid through " + License.getNotAfter().toString() + ".<br><br>After that time, you will have " + 14 + " days to visit the CafeTran.com website to obtain a new license file, and then to import that license file into this copy of CafeTran Espresso.<br><br>If a new license file is not imported within " + 14 + " days of the expiration, the restrictions on TM and glossary size that are present in trial versions of CafeTran Espresso will be reinstated.<br><br>", "Visit your account page at CafeTran.com", AppPreferences.account_url);
    }

    private static void showWrongSystemDialog() {
        License.showBuyDialog("Wrong system", "The CafeTran Espresso license file you have imported is valid, however, the local SystemID does not match the SystemID associated with the license file.<br><br>CafeTran may be installed on two systems for each license purchase. You may request an additional license file  for use on a second computer by contacting CafeTran support.<br><br>", "Request license file", AppPreferences.contact_url);
    }

    public static void showVerifyViewLicensingOptionsDialog() {
        License.showBuyDialog("Valid license file", "Your current CafeTran Espresso license file is valid through " + License.getNotAfter().toString() + ".<br><br>Would you still like to visit CafeTran.com to view licensing options?<br><br>", "View licensing options at CafeTran.com", AppPreferences.purchase_url);
    }

    public static boolean validateLicense() {
        Date now = new Date();
        try {
            licenseManager.verify();
        }
        catch (LicenseManagementException e) {
            if (!AppPreferences.lastLicenseCheckResult.equals("trial")) {
                Date notAfter = License.getNotAfter();
                Date gracePeriodEnd = License.getGracePeriodEnd();
                if (now.after(notAfter) && now.before(gracePeriodEnd)) {
                    if (AppPreferences.lastLicenseCheckResult.equals("full")) {
                        AppPreferences.lastLicenseCheckResult = "grace";
                        License.showLicenseGracePeriodStartDialog(gracePeriodEnd.toString());
                    }
                    return true;
                }
                if (now.after(gracePeriodEnd)) {
                    AppPreferences.isTrialVersion = true;
                    AppPreferences.lastLicenseCheckResult = "trial";
                    AppPreferences.licensePreGracePeriodWarningShown = false;
                    License.showLicenseExpiredDialog();
                    return false;
                }
            }
            return false;
        }
        if (License.validateSystemId()) {
            Date notAfter;
            if (AppPreferences.lastLicenseCheckResult.equals("full") && !AppPreferences.licensePreGracePeriodWarningShown && (daysUntilExpiration = ((notAfter = License.getNotAfter()).getTime() - now.getTime()) / 86400000L) <= 7L) {
                License.showUpcomingGracePeriodDialog();
                AppPreferences.licensePreGracePeriodWarningShown = true;
            }
            if (AppPreferences.lastLicenseCheckResult.equals("trial")) {
                License.showJustActivatedDialog();
            }
        } else {
            License.showWrongSystemDialog();
            AppPreferences.isTrialVersion = true;
            AppPreferences.lastLicenseCheckResult = "trial";
            AppPreferences.licensePreGracePeriodWarningShown = false;
            License.uninstallCurrentLicense();
            return false;
        }
        AppPreferences.isTrialVersion = false;
        AppPreferences.lastLicenseCheckResult = "full";
        String[] blockedSystemIDs = new String[]{"1529893012:103890397:-1775378484", "-1658377545"};
        int j = AppPreferences.systemID.indexOf(58);
        String s = j != -1 ? AppPreferences.systemID.substring(0, j) : AppPreferences.systemID;
        String s2 = AppPreferences.BID != null ? AppPreferences.BID : "";
        for (int i = 0; i < blockedSystemIDs.length; ++i) {
            String blockedSystemID = blockedSystemIDs[i];
            if (!blockedSystemID.equals(s) && !blockedSystemID.equals(s2)) continue;
            AppPreferences.isTrialVersion = true;
            AppPreferences.lastLicenseCheckResult = "trial";
            AppPreferences.licensePreGracePeriodWarningShown = false;
            AppPreferences.BID = s;
            License.uninstallCurrentLicense();
            return false;
        }
        return true;
    }

    private static boolean validateSystemId() {
        String licenseInfo;
        try {
            licenseInfo = licenseManager.view().getInfo();
        }
        catch (LicenseManagementException e) {
            System.out.println(e.getMessage());
            return false;
        }
        return licenseInfo.equals("SystemId:" + AppPreferences.systemID);
    }

    private static void uninstallCurrentLicense() {
        try {
            licenseManager.uninstall();
        }
        catch (LicenseManagementException e) {
            System.out.println(e.getMessage());
        }
    }

    public static String getHolder() {
        String licenseHolder = "";
        try {
            licenseHolder = licenseManager.view().getHolder().getName().replaceAll("^CN=", "");
        }
        catch (LicenseManagementException e) {
            System.out.println(e.getMessage());
        }
        return licenseHolder;
    }

    public static Date getNotAfter() {
        Date notAfterDate = new Date();
        try {
            notAfterDate = licenseManager.view().getNotAfter();
        }
        catch (LicenseManagementException e) {
            System.out.println(e.getMessage());
        }
        return notAfterDate;
    }

    public static Date getGracePeriodEnd() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(License.getNotAfter());
        cal.add(5, 14);
        return cal.getTime();
    }

    public static long getDaysUntilExpiration() {
        return daysUntilExpiration;
    }

    public static void showLicenseFileImportWizard(JDialog parentDialog) {
        LicenseWizard wizard = new LicenseWizard(licenseManager, (Dialog)parentDialog);
        wizard.showModalDialog();
        License.validateLicense();
    }

    public static void showLicenseFileImportWizard(JFrame parentFrame) {
        LicenseWizard wizard = new LicenseWizard(licenseManager, (Frame)parentFrame);
        wizard.showModalDialog();
        License.validateLicense();
    }

    public static boolean isPerpetual() {
        return License.getDaysUntilExpiration() > 18250L;
    }

    static {
        scheduler.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                License.validateLicense();
            }
        }, 3600L, 3600L, TimeUnit.SECONDS);
    }
}

