/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.Painter;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import translator.AppPreferences;
import translator.EULAView;
import translator.KeyPreferences;
import translator.License;
import translator.MainView;
import translator.MySwingWorker;
import translator.ProjectView;
import translator.server.RendezVousServer;
import translator.ui.MacOSKeyBindings;

public class MainClass {
    private static String packagePath;
    private static RendezVousServer rvs;
    private static MainView mv;
    private static final Class[] parameters;

    public MainClass() {
        block15: {
            String[] resourceDirs;
            String javaVersion = System.getProperty("java.version");
            if (javaVersion != null && javaVersion.startsWith("1.")) {
                JOptionPane.showMessageDialog(null, "Unsupported Java version " + javaVersion + " detected. Please install the latest version of CafeTran Espresso.");
                System.exit(0);
            }
            System.out.println("Java version=" + javaVersion);
            System.out.println("Classpath=" + System.getProperty("java.class.path"));
            if (packagePath == null) {
                String res = "MainClass.class";
                packagePath = this.getClass().getResource(res).getPath();
                int ci = packagePath.indexOf("Cafetran.jar");
                if (ci != -1) {
                    int fi = packagePath.indexOf("file:/") + 5;
                    packagePath = packagePath.substring(fi, ci);
                    packagePath = packagePath.replaceAll("%20", " ");
                } else {
                    int i = packagePath.lastIndexOf("build");
                    if (i != -1) {
                        packagePath = packagePath.substring(0, i) + "resources/";
                        packagePath = packagePath.replaceAll("%20", " ");
                    }
                }
                AppPreferences.setPaths(packagePath);
                AppPreferences.setAppPreferences();
                KeyPreferences.setKeyPreferences();
            }
            System.out.println("Cafetran dir=" + AppPreferences.packagePath);
            this.setLookAndFeel();
            for (String dir : resourceDirs = new String[]{"abbreviations", "databases", "glossaries", "images", "memories", "placeables", "shortcuts", "spellchecker"}) {
                new File(AppPreferences.packagePath + "/resources/" + dir).mkdirs();
            }
            boolean bl = AppPreferences.isTrialVersion = !License.validateLicense();
            if (AppPreferences.isTrialVersion && AppPreferences.mySystemID != null && AppPreferences.mySystemID.equals(AppPreferences.systemID)) {
                Calendar calendar = Calendar.getInstance();
                System.out.println(calendar.getTimeInMillis());
                Calendar calendar2 = Calendar.getInstance();
                calendar2.set(2024, 4, 7);
                System.out.println(calendar2.getTimeInMillis());
                long t = 1687159147243L;
                calendar2.setTimeInMillis(t);
                System.out.println(calendar.compareTo(calendar2));
            }
            if (AppPreferences.EULAShow) {
                String path = AppPreferences.packagePath + "eula.txt";
                File file = new File(path);
                EULAView t = new EULAView(file, "End User License Agreement");
            }
            try {
                mv = new MainView();
            }
            catch (Exception e) {
                if (mv != null) {
                    ProjectView pv = mv.getProjectView();
                    if (pv != null && pv.getProject() != null) {
                        e.printStackTrace();
                    } else {
                        e.printStackTrace();
                    }
                } else {
                    e.printStackTrace();
                }
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                e.printStackTrace(printWriter);
                Object[] options = new String[]{"Check your system and start again", "Reset CafeTran"};
                int i = JOptionPane.showOptionDialog(null, ((Object)result).toString(), "We've had a problem with the launch!", 0, 0, null, options, options[0]);
                if (i == 1) {
                    AppPreferences.clearPrefs();
                }
                if (mv != null) break block15;
                System.exit(0);
            }
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length > 0) {
            // empty if block
        }
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        String os = System.getProperty("os.name");
        if (os.startsWith("Mac OS")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.application.name", "CafeTran");
            System.setProperty("apple.awt.brushMetalLook", "true");
            System.setProperty("apple.awt.antialiasing", "true");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainClass main = new MainClass();
                if (AppPreferences.server) {
                    MainClass.startServer();
                }
            }
        });
    }

    public static void addURL(URL u, Object parent) throws IOException {
        boolean canLoad = true;
        URLClassLoader sysloader = parent == null ? (URLClassLoader)ClassLoader.getSystemClassLoader() : (URLClassLoader)parent.getClass().getClassLoader();
        if (sysloader != null) {
            URL[] urls = sysloader.getURLs();
            String fileName = u.getFile();
            for (int i = 0; i < urls.length; ++i) {
                String s = urls[i].getFile();
                if (!fileName.equals(s)) continue;
                canLoad = false;
                break;
            }
            if (canLoad) {
                Class<URLClassLoader> sysclass = URLClassLoader.class;
                try {
                    Method method = sysclass.getDeclaredMethod("addURL", parameters);
                    method.setAccessible(true);
                    method.invoke((Object)sysloader, u);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new IOException("Error, could not add URL to system classloader");
                }
            }
        }
    }

    static void startServer() {
        MySwingWorker worker = new MySwingWorker(){

            @Override
            public Object construct() {
                rvs = new RendezVousServer(mv);
                rvs.listen(AppPreferences.port);
                return null;
            }

            @Override
            public void finished() {
            }
        };
        worker.start();
    }

    static void stopServer() {
        if (rvs != null) {
            rvs.stop();
            rvs = null;
        }
    }

    public static RendezVousServer getServer() {
        return rvs;
    }

    public static MainView getMainView() {
        return mv;
    }

    private void setLookAndFeel() {
        try {
            FontUIResource fr;
            int fsize;
            Object value;
            String key;
            Color progressColor;
            if (AppPreferences.laf.equals("System")) {
                String name = UIManager.getSystemLookAndFeelClassName();
                if (name.endsWith("GTKLookAndFeel")) {
                    AppPreferences.laf = "Nimbus";
                    UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
                } else if (name.endsWith("WindowsLookAndFeel")) {
                    AppPreferences.laf = "Nimbus";
                    UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
                } else if (name.endsWith("AquaLookAndFeel")) {
                    AppPreferences.laf = "Mac OS";
                    UIManager.setLookAndFeel(name);
                }
            } else if (AppPreferences.laf.equals("Metal")) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            } else if (AppPreferences.laf.equals("GTK")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                AppPreferences.linuxGTK = true;
            } else if (AppPreferences.laf.equals("Windows")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else if (AppPreferences.laf.equals("Mac OS")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else if (AppPreferences.laf.equals("Nimbus")) {
                UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
            }
            Toolkit kit = Toolkit.getDefaultToolkit();
            Dimension screenSize = kit.getScreenSize();
            if (screenSize.width > 3800) {
                AppPreferences.dividerSize = 16;
                AppPreferences.toolBarButtonsFontSize = 28;
                AppPreferences.UIFontSizeHTML = 20;
            } else if (screenSize.width > 3000) {
                AppPreferences.dividerSize = 12;
                AppPreferences.toolBarButtonsFontSize = 24;
                AppPreferences.UIFontSizeHTML = 18;
            } else if (screenSize.width > 2400) {
                AppPreferences.dividerSize = 10;
                AppPreferences.toolBarButtonsFontSize = 20;
                AppPreferences.UIFontSizeHTML = 16;
            } else {
                AppPreferences.toolBarButtonsFontSize = screenSize.width > 1900 ? 18 : (screenSize.width > 1400 ? 14 : 12);
            }
            if (AppPreferences.windowsLayout == 0) {
                if (screenSize.width > 1900) {
                    AppPreferences.windowsLayout = 4;
                    AppPreferences.dockedTabsNames = "Matchboard:2";
                } else {
                    AppPreferences.windowsLayout = 3;
                    AppPreferences.autodockName3 = "Matchboard";
                }
            }
            if (AppPreferences.UIFontSize > 9) {
                AppPreferences.toolBarButtonsFontSize = AppPreferences.UIFontSize;
            }
            UIManager.put("ToolTip.background", new Color(25, 25, 25));
            UIManager.put("ToolTip.foreground", new Color(225, 225, 225));
            UIManager.put("ToolTip.border", BorderFactory.createLineBorder(new Color(150, 0, 0), 1));
            UIManager.put("ToolTip.font", new Font("SansSerif", 1, 12));
            UIManager.put("TabbedPane.contentOpaque", false);
            UIManager.put("Slider.paintValue", false);
            Color bcolor = AppPreferences.toolBarsBackground != -16777216 ? new Color(AppPreferences.toolBarsBackground) : Color.DARK_GRAY;
            int fgrey = (int)((double)bcolor.getRed() * 0.299 + (double)bcolor.getGreen() * 0.587 + (double)bcolor.getBlue() * 0.114);
            Color color = progressColor = fgrey < 186 ? new Color(-14126753) : new Color(AppPreferences.iconsColor);
            if (AppPreferences.operatingSystem == 1 && (AppPreferences.laf.equals("Nimbus") || AppPreferences.laf.equals("Metal"))) {
                MacOSKeyBindings bindings = new MacOSKeyBindings();
                InputMap im = (InputMap)UIManager.get("TextField.focusInputMap");
                bindings.addOSXKeyStrokes(im);
                im = (InputMap)UIManager.get("TextArea.focusInputMap");
                bindings.addOSXKeyStrokes(im);
                im = (InputMap)UIManager.get("TextPane.focusInputMap");
                bindings.addOSXKeyStrokes(im);
            }
            if (AppPreferences.laf.equals("Mac OS") && AppPreferences.toolBarButtonsFontSize > 16 && AppPreferences.UIFontSize < 10) {
                AppPreferences.toolBarButtonsFontSize = 16;
            }
            if (AppPreferences.laf.equals("Nimbus")) {
                if (!AppPreferences.theme.equals("System")) {
                    UIDefaults defaults = UIManager.getLookAndFeelDefaults();
                    if (AppPreferences.tforeground2 == -16777216) {
                        UIManager.put("nimbusBase", new Color(140, 160, 150));
                        UIManager.put("control", new Color(220, 230, 220));
                    } else {
                        UIManager.put("nimbusBase", new Color(1, 4, 3));
                        UIManager.put("control", new Color(48, 48, 48));
                        UIManager.put("text", new Color(200, 200, 200));
                        UIManager.put("Menu[Enabled].textForeground", new Color(200, 200, 200));
                        defaults.put("MenuItem[Enabled].textForeground", new Color(200, 200, 200));
                        defaults.put("CheckBoxMenuItem[Enabled].textForeground", new Color(200, 200, 200));
                        defaults.put("CheckBox.foreground", new Color(200, 200, 200));
                        UIManager.put("RadioButtonMenuItem[Enabled].textForeground", new Color(200, 200, 200));
                        UIManager.put("ComboBox:\"ComboBox.listRenderer\".background", Color.BLACK);
                        UIManager.put("TextField.background", Color.BLACK);
                        defaults.put("ComboBox:\"ComboBox.textField\"[Enabled].backgroundPainter", Color.BLACK);
                        defaults.put("ComboBox[Editable+Focused].backgroundPainter", Color.BLACK);
                        defaults.put("ToolTip[Enabled].backgroundPainter", Color.BLACK);
                        UIManager.put("Table:\"Table.cellRenderer\".background", new Color(24, 24, 24));
                        UIManager.put("Table.alternateRowColor", new Color(32, 32, 32));
                        UIManager.put("Table[Enabled+Selected].textBackground", new Color(48, 48, 48));
                    }
                    defaults.put("TextPane[Enabled].backgroundPainter", new Painter<JComponent>(){

                        @Override
                        public void paint(Graphics2D g, JComponent comp, int width, int height) {
                            g.setColor(comp.getBackground());
                            g.fillRect(0, 0, width, height);
                        }
                    });
                    defaults.put("ToolBar:Button[MouseOver].backgroundPainter", new Painter<JComponent>(){

                        @Override
                        public void paint(Graphics2D g, JComponent comp, int width, int height) {
                            g.setColor(comp.getBackground().darker());
                            g.fill3DRect(0, 0, width, height, true);
                        }
                    });
                }
                int fstyle = 0;
                if (AppPreferences.toolBarButtonsFontSize < 18) {
                    fstyle = 1;
                }
                UIManager.getLookAndFeelDefaults().put("defaultFont", new Font("SansSerif", fstyle, AppPreferences.toolBarButtonsFontSize));
            }
            if (AppPreferences.laf.equals("Metal")) {
                UIManager.put("ProgressBar.selectionForeground", Color.WHITE);
                UIManager.put("ProgressBar.selectionBackground", Color.BLACK);
                UIManager.put("ProgressBar.foreground", progressColor);
                key = "Menu.font";
                value = UIManager.get(key);
                if (value != null && value instanceof FontUIResource && (fsize = (fr = (FontUIResource)value).getSize()) < AppPreferences.toolBarButtonsFontSize) {
                    UIManager.put(key, fr.deriveFont((float)AppPreferences.toolBarButtonsFontSize));
                }
                if ((value = UIManager.get(key = "MenuItem.font")) != null && value instanceof FontUIResource && (fsize = (fr = (FontUIResource)value).getSize()) < AppPreferences.toolBarButtonsFontSize) {
                    UIManager.put(key, fr.deriveFont((float)AppPreferences.toolBarButtonsFontSize));
                }
                if ((value = UIManager.get(key = "CheckBoxMenuItem.font")) != null && value instanceof FontUIResource && (fsize = (fr = (FontUIResource)value).getSize()) < AppPreferences.toolBarButtonsFontSize) {
                    UIManager.put(key, fr.deriveFont((float)AppPreferences.toolBarButtonsFontSize));
                }
                if ((value = UIManager.get(key = "RadioButtonMenuItem.font")) != null && value instanceof FontUIResource && (fsize = (fr = (FontUIResource)value).getSize()) < AppPreferences.toolBarButtonsFontSize) {
                    UIManager.put(key, fr.deriveFont((float)AppPreferences.toolBarButtonsFontSize));
                }
            }
            if ((value = UIManager.get(key = "TitledBorder.font")) != null && value instanceof FontUIResource && (fsize = (fr = (FontUIResource)value).getSize()) < AppPreferences.toolBarButtonsFontSize) {
                UIManager.put(key, fr.deriveFont(1, AppPreferences.toolBarButtonsFontSize));
            }
            if ((value = UIManager.get(key = "TabbedPane.font")) != null && value instanceof FontUIResource && (fsize = (fr = (FontUIResource)value).getSize()) < AppPreferences.toolBarButtonsFontSize) {
                UIManager.put(key, fr.deriveFont(0, AppPreferences.toolBarButtonsFontSize));
            }
            if ((value = UIManager.get(key = "Button.font")) != null && value instanceof FontUIResource && (fsize = (fr = (FontUIResource)value).getSize()) < AppPreferences.toolBarButtonsFontSize) {
                UIManager.put(key, fr.deriveFont((float)AppPreferences.toolBarButtonsFontSize));
            }
            if ((value = UIManager.get(key = "Label.font")) != null && value instanceof FontUIResource && (fsize = (fr = (FontUIResource)value).getSize()) < AppPreferences.toolBarButtonsFontSize) {
                UIManager.put(key, fr.deriveFont((float)AppPreferences.toolBarButtonsFontSize));
            }
            if ((value = UIManager.get(key = "CheckBox.font")) != null && value instanceof FontUIResource && (fsize = (fr = (FontUIResource)value).getSize()) < AppPreferences.toolBarButtonsFontSize) {
                UIManager.put(key, fr.deriveFont((float)AppPreferences.toolBarButtonsFontSize));
            }
            if ((value = UIManager.get(key = "ComboBox.font")) != null && value instanceof FontUIResource && (fsize = (fr = (FontUIResource)value).getSize()) < AppPreferences.toolBarButtonsFontSize) {
                UIManager.put(key, fr.deriveFont((float)AppPreferences.toolBarButtonsFontSize));
            }
            if ((value = UIManager.get(key = "TextField.font")) != null && value instanceof FontUIResource && (fsize = (fr = (FontUIResource)value).getSize()) < AppPreferences.toolBarButtonsFontSize) {
                UIManager.put(key, fr.deriveFont((float)AppPreferences.toolBarButtonsFontSize));
            }
            if ((value = UIManager.get(key = "RadioButton.font")) != null && value instanceof FontUIResource && (fsize = (fr = (FontUIResource)value).getSize()) < AppPreferences.toolBarButtonsFontSize) {
                UIManager.put(key, fr.deriveFont((float)AppPreferences.toolBarButtonsFontSize));
            }
            if ((value = UIManager.get(key = "ToggleButton.font")) != null && value instanceof FontUIResource && (fsize = (fr = (FontUIResource)value).getSize()) < AppPreferences.toolBarButtonsFontSize) {
                UIManager.put(key, fr.deriveFont((float)AppPreferences.toolBarButtonsFontSize));
            }
            if ((value = UIManager.get(key = "PopupMenu.font")) != null && value instanceof FontUIResource && (fsize = (fr = (FontUIResource)value).getSize()) < AppPreferences.toolBarButtonsFontSize) {
                UIManager.put(key, fr.deriveFont((float)AppPreferences.toolBarButtonsFontSize));
            }
            if ((value = UIManager.get(key = "OptionPane.font")) != null && value instanceof FontUIResource && (fsize = (fr = (FontUIResource)value).getSize()) < AppPreferences.toolBarButtonsFontSize) {
                UIManager.put(key, fr.deriveFont((float)AppPreferences.toolBarButtonsFontSize));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AppPreferences.laf = "System";
            String name = UIManager.getSystemLookAndFeelClassName();
            try {
                UIManager.setLookAndFeel(name);
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
    }

    static String getCurrentInternetDate() {
        String[] machines = new String[]{"time-c.nist.gov", "time-d.nist.gov", "time.nist.gov", "nist1-nj2.ustiming.org", "nist1-ny2.ustiming.org", "nist1-pa.ustiming.org"};
        String currentDate = null;
        for (int k = 0; k < machines.length; ++k) {
            String machine = machines[k];
            try {
                String eline;
                int daytimeport = 13;
                Socket so = new Socket(machine, 13);
                BufferedReader br = new BufferedReader(new InputStreamReader(so.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((eline = br.readLine()) != null) {
                    sb.append(eline);
                }
                String result = sb.toString().trim();
                if (result.length() > 0) {
                    String[] arr = result.split(" ");
                    for (int i = 0; i < arr.length; ++i) {
                        String string;
                        if (i != 1 || (string = arr[i]).indexOf(45) == -1) continue;
                        int len = string.length();
                        StringBuilder sb2 = new StringBuilder();
                        for (int j = 0; j < len; ++j) {
                            char c = string.charAt(j);
                            if (c == '-') continue;
                            sb2.append(c);
                        }
                        currentDate = sb2.toString();
                    }
                }
                if (currentDate != null) {
                    break;
                }
            }
            catch (IOException daytimeport) {
                // empty catch block
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(MainClass.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return currentDate;
    }

    static long[] getJavaHeapSize() {
        int mb = 0x100000;
        Runtime runtime = Runtime.getRuntime();
        long max = runtime.maxMemory();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        long used = total - free;
        long[] arr = new long[]{max / (long)mb, used / (long)mb};
        return arr;
    }

    private static boolean is64bitJava() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    static void setUIFontSize(int size) {
        for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
            FontUIResource fr;
            int fsize;
            Object key = entry.getKey();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource) || (fsize = (fr = (FontUIResource)value).getSize()) >= AppPreferences.toolBarButtonsFontSize) continue;
            UIManager.put(key, fr.deriveFont((float)AppPreferences.toolBarButtonsFontSize));
        }
    }

    static {
        parameters = new Class[]{URL.class};
    }
}

