/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterInputStream;
import java.util.zip.InflaterInputStream;
import javax.swing.SwingUtilities;

public class PdfReader {
    byte[] array;

    public PdfReader() {
        String p = System.getProperty("user.home") + "\\Test.pdf";
        File file = new File(p);
        System.out.println(p);
        if (file.exists()) {
            try {
                String pdf = this.loadTextFile(file);
                StringBuffer pdfbuf = new StringBuffer();
                int h = 0;
                int i = 0;
                int j = 0;
                String filter = "/FlateDecode";
                String sfilter = "stream";
                String efilter = "endstream";
                ArrayList<Byte> list = new ArrayList<Byte>();
                while (h != -1) {
                    if ((h = pdf.indexOf(filter, h + 1)) != -1) {
                        int si = pdf.indexOf(sfilter, h + 1);
                        i = si + sfilter.length() + 2;
                        for (int m = j; m < i; ++m) {
                            list.add(this.array[m]);
                        }
                        pdfbuf.append(pdf.substring(j, i));
                        j = pdf.indexOf(efilter, i);
                        int len = j - i;
                        byte[] compData = new byte[len];
                        for (int k = 0; k < len; ++k) {
                            compData[k] = this.array[i];
                            ++i;
                        }
                        if (compData.length <= 0) continue;
                        byte[] decompData = PdfReader.FlateDecode(compData, false);
                        if (decompData.length > 0) {
                            decompData = PdfReader.FlateEncode(decompData, false);
                            for (int m = 0; m < decompData.length; ++m) {
                                list.add(decompData[m]);
                            }
                            String decomp = new String(decompData);
                            pdfbuf.append(decomp);
                            continue;
                        }
                        for (int m = 0; m < compData.length; ++m) {
                            list.add(compData[m]);
                        }
                        continue;
                    }
                    for (int m = j; m < this.array.length; ++m) {
                        list.add(this.array[m]);
                    }
                    pdfbuf.append(pdf.substring(j, pdf.length()));
                }
                byte[] ob = new byte[list.size()];
                int ib = 0;
                for (Byte b : list) {
                    ob[ib] = b;
                    ++ib;
                }
                System.out.println(pdfbuf);
                String s = System.getProperty("user.home") + "\\Test-Uncomp.pdf";
                file = new File(s);
                this.store(file, ob);
            }
            catch (Exception ex) {
                Logger.getLogger(PdfReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String loadTextFile(File file) {
        FileInputStream fis = null;
        try {
            int read;
            fis = new FileInputStream(file);
            byte[] b = new byte[8192];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((read = fis.read(b)) >= 1) {
                out.write(b, 0, read);
            }
            this.array = out.toByteArray();
            String string = new String(this.array);
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public synchronized void store(File file, byte[] outbytes) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        out.write(outbytes);
        out.close();
    }

    public static byte[] FlateDecode(byte[] in, boolean strict) {
        ByteArrayInputStream stream = new ByteArrayInputStream(in);
        InflaterInputStream zip = new InflaterInputStream(stream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] b = new byte[strict ? 4092 : 1];
        try {
            int n;
            while ((n = zip.read(b)) >= 0) {
                out.write(b, 0, n);
            }
            zip.close();
            out.close();
            return out.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (strict) {
                return null;
            }
            return out.toByteArray();
        }
    }

    public static byte[] FlateEncode(byte[] in, boolean strict) {
        ByteArrayInputStream stream = new ByteArrayInputStream(in);
        DeflaterInputStream zip = new DeflaterInputStream(stream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] b = new byte[strict ? 4092 : 1];
        try {
            int n;
            while ((n = zip.read(b)) >= 0) {
                out.write(b, 0, n);
            }
            zip.close();
            out.close();
            return out.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (strict) {
                return null;
            }
            return out.toByteArray();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PdfReader();
            }
        });
    }
}

