/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.util.HashSet;
import java.util.Set;

public class StopWords {
    private static String[] albanian = new String[]{"nj\u00eb"};
    private static String[] greek = new String[]{"?", "?", "??", "??", "??", "??", "????", "???", "???"};
    private static String[] english = new String[]{"the", "a", "an", "of"};
    private static String[] german = new String[]{"der", "die", "das", "des", "dem", "den", "ein", "eine", "einer", "eines", "einem", "einen"};
    private static String[] dutch = new String[]{"de", "het", "een"};
    private static String[] spanish = new String[]{"el", "la", "lo", "los", "las"};
    private static String[] french = new String[]{"le", "la", "l'", "les", "un", "une", "des"};
    private static String[] portuguese = new String[]{"o", "a", "os", "as", "um", "uma", "uns", "umas"};
    private static String[] italian = new String[]{"il", "lo", "la", "l'", "i", "gli", "le", "un'", "uno", "una", "un"};
    private static String[] romanian = new String[]{"un", "o", "una", "un"};
    private static String[] hungarian = new String[]{"a, az", "egy"};
    private static Set<String> stopWordsSet;
    private static int maxLengthLimit;

    public static void setStopWords(String lang) {
        String[] arr;
        if (lang != null) {
            if (lang.startsWith("en")) {
                arr = english;
                maxLengthLimit = 4;
            } else if (lang.startsWith("de")) {
                arr = german;
                maxLengthLimit = 6;
            } else if (lang.startsWith("es")) {
                arr = spanish;
                maxLengthLimit = 4;
            } else if (lang.startsWith("fr")) {
                arr = french;
                maxLengthLimit = 4;
            } else if (lang.startsWith("it")) {
                arr = italian;
                maxLengthLimit = 4;
            } else if (lang.startsWith("pt")) {
                arr = portuguese;
                maxLengthLimit = 5;
            } else if (lang.startsWith("nl")) {
                arr = dutch;
                maxLengthLimit = 4;
            } else if (lang.startsWith("el")) {
                arr = greek;
                maxLengthLimit = 5;
            } else if (lang.startsWith("ro")) {
                arr = romanian;
                maxLengthLimit = 4;
            } else if (lang.startsWith("hu")) {
                arr = hungarian;
                maxLengthLimit = 4;
            } else if (lang.startsWith("sq")) {
                arr = albanian;
                maxLengthLimit = 4;
            } else {
                arr = null;
            }
        } else {
            arr = null;
        }
        if (arr != null) {
            stopWordsSet = new HashSet<String>(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                String arr1 = arr[i];
                stopWordsSet.add(arr1);
            }
        } else {
            stopWordsSet = null;
            maxLengthLimit = 0;
        }
    }

    public static boolean isStopWord(String s) {
        return s.length() < maxLengthLimit && stopWordsSet != null && stopWordsSet.contains(s.toLowerCase());
    }

    static {
        maxLengthLimit = 0;
    }
}

