/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringPool {
    private static ConcurrentMap<String, String> map = new ConcurrentHashMap<String, String>(50000);
    private static Pattern p = Pattern.compile("\\s+");

    public static String getCanonicalVersion(String str) {
        String canon = map.putIfAbsent(str, str);
        return canon == null ? str : canon;
    }

    public static String[] splitInternal(CharSequence input) {
        int index = 0;
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher m = p.matcher(input);
        while (m.find()) {
            String group;
            String match = input.subSequence(index, m.start()).toString();
            if (match.length() > 0) {
                matchList.add(StringPool.getCanonicalVersion(match));
            }
            if ((group = input.subSequence(m.start(), m.end()).toString()).length() > 0) {
                matchList.add(StringPool.getCanonicalVersion(group));
            }
            index = m.end();
        }
        if (index == 0) {
            String s = input.toString();
            return new String[]{StringPool.getCanonicalVersion(s)};
        }
        String r = input.subSequence(index, input.length()).toString();
        matchList.add(StringPool.getCanonicalVersion(r));
        int resultSize = matchList.size();
        String[] result = new String[resultSize];
        return matchList.subList(0, resultSize).toArray(result);
    }

    public static long getUniqueStringID(String str) {
        long hash = -1431655766L;
        for (int i = 0; i < str.length(); ++i) {
            if ((i & 1) == 0) {
                hash ^= hash << 7 ^ (long)str.charAt(i) * (hash >> 3);
                continue;
            }
            hash ^= (hash << 11) + (long)str.charAt(i) ^ hash >> 5 ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return hash;
    }
}

