/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import translator.AppPreferences;
import translator.LanguageCodes;
import translator.MainView;
import translator.ui.GridPanel;
import translator.xliff.XLIFF;

public class TargetLanguageSelector
extends JDialog
implements ActionListener {
    private JComboBox langbox;
    private JButton jb1;
    private JButton jb2;
    private XLIFF xliff;

    public TargetLanguageSelector(MainView parent, String title, XLIFF xliff) {
        super(parent, title, true);
        this.enableEvents(64L);
        this.xliff = xliff;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String trg = this.xliff.getAttribute("trgLang");
        String[] langs = LanguageCodes.getNames();
        this.langbox = new JComboBox<String>(langs);
        this.langbox.setEditable(true);
        if (trg != null && trg.length() > 0) {
            String val = LanguageCodes.getName(trg);
            if (val != null) {
                this.langbox.setSelectedItem(val);
            } else {
                this.langbox.setSelectedItem(trg);
            }
        }
        this.jb1 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jb2 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jb1.addActionListener(this);
        this.jb2.addActionListener(this);
        JPanel panel1 = new JPanel();
        panel1.setOpaque(false);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout(2));
        panel2.setOpaque(false);
        panel2.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        GridPanel panel3 = new GridPanel();
        panel3.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.setContentPane(panel3);
        panel3.setLayout(new BorderLayout());
        this.setResizable(false);
        panel1.add(this.langbox);
        panel2.add(this.jb1);
        panel2.add(this.jb2);
        panel3.add((Component)panel1, "North");
        panel3.add((Component)panel2, "South");
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jb2) {
            this.cancel();
        } else if (e.getSource() == this.jb1) {
            String src = this.xliff.getAttribute("srcLang");
            String value = (String)this.langbox.getSelectedItem();
            String trg = LanguageCodes.getCode(value);
            if (src != null) {
                if (trg == null) {
                    trg = Locale.getDefault().getLanguage();
                }
                this.xliff.setAttribute("trgLang", trg);
                this.xliff.setLangEnvironment(src, trg);
                this.xliff.setFormat();
            }
            this.cancel();
        }
    }
}

