/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.Frequencer;
import translator.MainView;
import translator.Placeables;
import translator.Project;
import translator.ProjectView;
import translator.PropertyChooser;
import translator.SegmentParser;
import translator.TrackingChanges;
import translator.TranslationUnit;
import translator.TranslationUnitMap;
import translator.XMLElement;
import translator.hunspell.HunSpellChecker;
import translator.tmx.Memory;
import translator.tmx.MemoryView;
import translator.tmx.SegmentSplitter;
import translator.tmx.TMX;
import translator.tmx.TMXUnit;
import translator.tmx.TMXUnitVariant;
import translator.tmx.TMXView;
import translator.ttx.ProcessTTXUnit;
import translator.ttx.TTX;
import translator.ttx.TTXUnit;
import translator.xliff.AltTrans;
import translator.xliff.ProcessXLIFFUnit;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;

public class TaskView {
    private MainView topui;
    private JMenu actionMenu;
    private ProjectView prview;

    public TaskView(MainView topui) {
        this.topui = topui;
        this.prview = topui.getProjectView();
        this.setActionMenu();
    }

    public JMenu getMenu() {
        return this.actionMenu;
    }

    private void setActionMenu() {
        this.actionMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TASK"));
        JMenuItem removeTargetsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE TARGET SEGMENTS"));
        removeTargetsMenu.setName("MenuTaskRemoveTargetSegments");
        removeTargetsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.removeTargets();
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem removeTargetsAsSourcesMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE TARGET THE SAME AS SOURCE"));
        removeTargetsAsSourcesMenu.setName("MenuTaskRemoveTargetSegmentsSameAsSource");
        removeTargetsAsSourcesMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.removeTargetSameAsSource();
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem removeNotesMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE NOTES"));
        removeNotesMenu.setName("MenuTaskRemoveNotes");
        removeNotesMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.removeNotes();
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem removeATMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE ALTERNATIVE TRANSLATIONS"));
        removeATMenu.setName("MenuTaskRemoveAlternativeTranslations");
        removeATMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.removeATs();
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem resetMatchStatusMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RESET SEGMENTS MATCH STATUS"));
        resetMatchStatusMenu.setName("MenuTaskResetSegmentsMatchStatus");
        resetMatchStatusMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.resetMatchStatus();
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem resetStateMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RESET SEGMENTS STATUS"));
        resetStateMenu.setName("MenuTaskResetSegmentsStatus");
        resetStateMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.resetState();
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem checkedStatusMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET CHECKED STATUS FOR SEGMENTS"));
        checkedStatusMenu.setName("MenuTaskSetCheckedForTargetSegs");
        checkedStatusMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.setState(1);
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem translatedStatusMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET APPROVED STATUS FOR SEGMENTS"));
        translatedStatusMenu.setName("MenuTaskSetTranslatedForTargetSegs");
        translatedStatusMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.setState(2);
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem lockMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOCK SEGMENTS"));
        lockMenu.setName("MenuTaskLockSegments");
        lockMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.setLock(true);
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem unlockMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("UNLOCK SEGMENTS"));
        unlockMenu.setName("MenuTaskUnlockSegments");
        unlockMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.setLock(false);
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem bookmarkMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BOOKMARK SEGMENTS"));
        bookmarkMenu.setName("MenuTaskBookmarkSegments");
        bookmarkMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.setBookmark();
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem unbookmarkMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE BOOKMARKS"));
        unbookmarkMenu.setName("MenuTaskUnBookmarkSegments");
        unbookmarkMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.unsetBookmark();
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem acceptAllChangesMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACCEPT ALL TRACKED CHANGES"));
        acceptAllChangesMenu.setName("MenuTaskAcceptAllChanges");
        acceptAllChangesMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.manageTrackedChanges(true);
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem rejectAllChangesMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REJECT ALL TRACKED CHANGES"));
        rejectAllChangesMenu.setName("MenuTaskRejectAllChanges");
        rejectAllChangesMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.manageTrackedChanges(false);
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem trimLeadingSpacesTargetMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRIM LEADING TARGET SPACES"));
        trimLeadingSpacesTargetMenu.setName("MenuTaskTrimLeadingSpacesInTargetSegs");
        trimLeadingSpacesTargetMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.trimLeadingTargetSpaces();
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem trimTrailingSpacesTargetMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRIM TRAILING TARGET SPACES"));
        trimTrailingSpacesTargetMenu.setName("MenuTaskTrimTrailingSpacesInTargetSegs");
        trimTrailingSpacesTargetMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.trimTailingTargetSpaces();
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem copySourceToTargetsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER SOURCE SEGMENTS TO TARGET SEGMENTS"));
        copySourceToTargetsMenu.setName("MenuTaskTransferSourceToTarget");
        copySourceToTargetsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.copySourceToTarget();
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem copyNoLettersToTargetsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER SEGMENTS WITH NO LETTERS TO TARGET"));
        copyNoLettersToTargetsMenu.setName("MenuTaskTransferSegsWithNoLettersToTarget");
        copyNoLettersToTargetsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.copyNoLettersToTarget();
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem copyNonTranslatablesToTargetMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER NON-TRANSLATABLE SEGMENTS TO TARGET"));
        copyNonTranslatablesToTargetMenu.setName("MenuTaskTransferNonTranslatableSegsToTarget");
        copyNonTranslatablesToTargetMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskView.this.copyNonTranslatablesToTarget();
                TaskView.this.showActionResults();
                TaskView.this.projectToSave();
            }
        });
        JMenuItem deleteTMXUnitsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE TMX FILTERED TRANSLATION UNITS"));
        deleteTMXUnitsMenu.setName("MenuTaskRemoveTMXUnitsFiltered");
        deleteTMXUnitsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TMX tmx = TaskView.this.prview.getProject().getTMX();
                if (tmx != null) {
                    int d = TaskView.this.deleteUnitsTMX(tmx, null);
                    TaskView.this.topui.resetSegmentsFilter();
                    if (d > 0) {
                        String m = Integer.toString(d) + " Translation Units deleted.";
                        JOptionPane.showMessageDialog(TaskView.this.topui, m);
                    }
                } else {
                    MemoryView mv;
                    List mems;
                    XLIFF xliff = TaskView.this.prview.getProject().getXLIFF();
                    if (xliff != null && (mems = (mv = TaskView.this.topui.getMemoryView()).getLocalMemories()).size() > 0) {
                        mv.startTaskDialog(mems);
                        for (Memory m : mems) {
                            int d;
                            if (!m.isTaskReady() || (tmx = m.getTMX()) == null || (d = TaskView.this.deleteUnitsTMX(tmx, xliff)) <= 0) continue;
                            String mes = Integer.toString(d) + " Translation Units deleted in " + m.getName();
                            JOptionPane.showMessageDialog(TaskView.this.topui, mes);
                        }
                        TaskView.this.topui.resetSegmentsFilter();
                    }
                }
            }
        });
        JMenuItem deleteDuplicateTMXUnitsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE TMX DUPLICATE TRANSLATION UNITS"));
        deleteDuplicateTMXUnitsMenu.setName("MenuTaskRemoveDuplicateTMXUnits");
        deleteDuplicateTMXUnitsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TMX tmx = TaskView.this.prview.getProject().getTMX();
                if (tmx != null) {
                    TaskView.this.deleteDuplicateUnitsTMX(tmx);
                } else {
                    MemoryView mv = TaskView.this.topui.getMemoryView();
                    List mems = mv.getLocalMemories();
                    if (mems.size() > 0) {
                        mv.startTaskDialog(mems);
                        for (Memory m : mems) {
                            if (!m.isTaskReady() || (tmx = m.getTMX()) == null) continue;
                            TaskView.this.deleteDuplicateUnitsTMX(tmx);
                        }
                    }
                }
            }
        });
        JMenuItem deleteDuplicateSourceTMXUnitsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE TMX DUPLICATE SOURCE TRANSLATION UNITS"));
        deleteDuplicateSourceTMXUnitsMenu.setName("MenuTaskRemoveTMXUnitsWithDupeSrcSegs");
        deleteDuplicateSourceTMXUnitsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TMX tmx = TaskView.this.prview.getProject().getTMX();
                if (tmx != null) {
                    TaskView.this.deleteDuplicateSourceSegmentsTMX(tmx);
                } else {
                    MemoryView mv = TaskView.this.topui.getMemoryView();
                    List mems = mv.getLocalMemories();
                    if (mems.size() > 0) {
                        mv.startTaskDialog(mems);
                        for (Memory m : mems) {
                            if (!m.isTaskReady() || (tmx = m.getTMX()) == null) continue;
                            TaskView.this.deleteDuplicateSourceSegmentsTMX(tmx);
                        }
                    }
                }
            }
        });
        JMenuItem deleteTMXUnitsSourceLikeTargetMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE TMX TRANSLATION UNITS WITH SOURCE=TARGET"));
        deleteTMXUnitsSourceLikeTargetMenu.setName("MenuTaskRemoveTMXUnitsWithSrcEqualTrg");
        deleteTMXUnitsSourceLikeTargetMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TMX tmx = TaskView.this.prview.getProject().getTMX();
                if (tmx != null) {
                    TaskView.this.deleteUnitsTMXTargetSameAsSource(tmx);
                } else {
                    MemoryView mv = TaskView.this.topui.getMemoryView();
                    List mems = mv.getLocalMemories();
                    if (mems.size() > 0) {
                        mv.startTaskDialog(mems);
                        for (Memory m : mems) {
                            if (!m.isTaskReady() || (tmx = m.getTMX()) == null) continue;
                            TaskView.this.deleteUnitsTMXTargetSameAsSource(tmx);
                        }
                    }
                }
            }
        });
        JMenuItem deleteTMXUnitsNoLettersMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE TMX TRANSLATION UNITS WITH NO LETTERS"));
        deleteTMXUnitsNoLettersMenu.setName("MenuTaskRemoveTMXUnitsWithNoLetters");
        deleteTMXUnitsNoLettersMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TMX tmx = TaskView.this.prview.getProject().getTMX();
                if (tmx != null) {
                    TaskView.this.deleteNoLettersUnitsTMX(tmx);
                } else {
                    MemoryView mv = TaskView.this.topui.getMemoryView();
                    List mems = mv.getLocalMemories();
                    if (mems.size() > 0) {
                        mv.startTaskDialog(mems);
                        for (Memory m : mems) {
                            if (!m.isTaskReady() || (tmx = m.getTMX()) == null) continue;
                            TaskView.this.deleteNoLettersUnitsTMX(tmx);
                        }
                    }
                }
            }
        });
        JMenuItem replaceInternalTagsWithSpaceTMXUnitsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REPLACE TMX INTERNAL TAGS WITH SPACE"));
        replaceInternalTagsWithSpaceTMXUnitsMenu.setName("MenuTaskReplaceTMXInternalTagsWithSpace");
        replaceInternalTagsWithSpaceTMXUnitsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TMX tmx = TaskView.this.prview.getProject().getTMX();
                if (tmx != null) {
                    TaskView.this.replaceInternalTagsWithSpace(tmx);
                } else {
                    MemoryView mv = TaskView.this.topui.getMemoryView();
                    List mems = mv.getLocalMemories();
                    if (mems.size() > 0) {
                        mv.startTaskDialog(mems);
                        for (Memory m : mems) {
                            if (!m.isTaskReady() || (tmx = m.getTMX()) == null) continue;
                            TaskView.this.replaceInternalTagsWithSpace(tmx);
                        }
                    }
                }
            }
        });
        JMenuItem splitTMXUnitsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPLIT TMX UNITS"));
        splitTMXUnitsMenu.setName("MenuTaskSplitTMXUnits");
        splitTMXUnitsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegmentSplitter dlg = new SegmentSplitter(TaskView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPLIT TMX UNITS"));
                Dimension dlgSize = dlg.getPreferredSize();
                Dimension frmSize = TaskView.this.topui.getSize();
                Point loc = TaskView.this.topui.getLocationOnScreen();
                dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
                dlg.setVisible(true);
            }
        });
        JMenuItem setTMXUnitsPropertyMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET PROPERTY FOR TMX UNITS"));
        setTMXUnitsPropertyMenu.setName("MenuTaskSetPropertyForTMXUnits");
        setTMXUnitsPropertyMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyChooser chooser = new PropertyChooser(TaskView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE PROPERTY"));
                String type = chooser.getPropertyType();
                String value = chooser.getPropertyValue();
                if (type != null && value != null) {
                    if (type.length() == 0) {
                        return;
                    }
                    TMX tmx = TaskView.this.prview.getProject().getTMX();
                    if (tmx != null) {
                        TaskView.this.setPropertyForUnitsTMX(tmx, type, value);
                    } else {
                        MemoryView mv = TaskView.this.topui.getMemoryView();
                        List mems = mv.getLocalMemories();
                        if (mems.size() > 0) {
                            mv.startTaskDialog(mems);
                            for (Memory m : mems) {
                                if (!m.isTaskReady() || (tmx = m.getTMX()) == null) continue;
                                TaskView.this.setPropertyForUnitsTMX(tmx, type, value);
                            }
                        }
                    }
                }
            }
        });
        JMenuItem removeTMXUnitsPropertyMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE PROPERTY FROM TMX UNITS"));
        removeTMXUnitsPropertyMenu.setName("MenuTaskRemovePropertyFromTMXUnits");
        removeTMXUnitsPropertyMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyChooser chooser = new PropertyChooser(TaskView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE PROPERTY"));
                String type = chooser.getPropertyType();
                String value = chooser.getPropertyValue();
                if (type != null && value != null) {
                    TMX tmx = TaskView.this.prview.getProject().getTMX();
                    if (tmx != null) {
                        TaskView.this.removePropertyForUnitsTMX(tmx, type, value);
                    } else {
                        MemoryView mv = TaskView.this.topui.getMemoryView();
                        List mems = mv.getLocalMemories();
                        if (mems.size() > 0) {
                            mv.startTaskDialog(mems);
                            for (Memory m : mems) {
                                if (!m.isTaskReady() || (tmx = m.getTMX()) == null) continue;
                                TaskView.this.removePropertyForUnitsTMX(tmx, type, value);
                            }
                        }
                    }
                }
            }
        });
        JMenuItem mispelledWordsMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LIST WORDS WITH UNKNOWN SPELLING"));
        mispelledWordsMenu.setName("MenuTaskListWordsWithUnknownSpelling");
        mispelledWordsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TaskView.this.extractMisspelledWords();
                    }
                });
            }
        });
        JMenuItem extractFrequentWordsMenu1 = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FREQUENT WORDS SORTED BY FREQUENCY"));
        extractFrequentWordsMenu1.setName("MenuTaskFrequentWordsSortFrequency");
        extractFrequentWordsMenu1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TaskView.this.extractFrequentWords(0);
                    }
                });
            }
        });
        JMenuItem extractFrequentWordsMenu2 = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FREQUENT WORDS SORTED BY LENGTH"));
        extractFrequentWordsMenu2.setName("MenuTaskFrequentWordsSortLength");
        extractFrequentWordsMenu2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TaskView.this.extractFrequentWords(1);
                    }
                });
            }
        });
        JMenuItem extractFrequentWordsMenu3 = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FREQUENT WORDS SORTED ALPHABETICALLY"));
        extractFrequentWordsMenu3.setName("MenuTaskFrequentWordsSortAlphabetical");
        extractFrequentWordsMenu3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TaskView.this.extractFrequentWords(2);
                    }
                });
            }
        });
        JCheckBoxMenuItem uniqueFWOnly = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW ONLY UNKNOWN FREQUENT WORDS"));
        uniqueFWOnly.setName("MenuTaskFrequentWordsShowOnlyUnknown");
        uniqueFWOnly.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.uniqueFrequentTerms = e.getStateChange() == 1;
            }
        });
        uniqueFWOnly.setSelected(AppPreferences.uniqueFrequentTerms);
        JCheckBoxMenuItem freqToGlossaryMenu = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD FREQUENT WORDS TO GLOSSARY"));
        freqToGlossaryMenu.setName("MenuTaskFrequentWordsAddToGlossary");
        freqToGlossaryMenu.setSelected(AppPreferences.frequentTermsToGlossary);
        freqToGlossaryMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.frequentTermsToGlossary = e.getStateChange() == 1;
            }
        });
        JCheckBoxMenuItem extractFWMenu = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXTRACT FREQUENT WORDS FROM CURRENT SEGMENT"));
        extractFWMenu.setName("MenuTaskFrequentWordsExactFromCurrentSeg");
        extractFWMenu.setSelected(AppPreferences.frequencer);
        extractFWMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.frequencer = e.getStateChange() == 1;
            }
        });
        JMenu fwMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FREQUENT WORDS"));
        fwMenu.setName("MenuTaskFrequentWords");
        fwMenu.add(extractFrequentWordsMenu1);
        fwMenu.add(extractFrequentWordsMenu2);
        fwMenu.add(extractFrequentWordsMenu3);
        fwMenu.addSeparator();
        fwMenu.add(extractFWMenu);
        fwMenu.add(uniqueFWOnly);
        fwMenu.add(freqToGlossaryMenu);
        JMenu tmxMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TMX MEMORY"));
        tmxMenu.add(deleteDuplicateTMXUnitsMenu);
        tmxMenu.add(deleteDuplicateSourceTMXUnitsMenu);
        tmxMenu.add(deleteTMXUnitsSourceLikeTargetMenu);
        tmxMenu.add(deleteTMXUnitsNoLettersMenu);
        tmxMenu.add(deleteTMXUnitsMenu);
        tmxMenu.addSeparator();
        tmxMenu.add(replaceInternalTagsWithSpaceTMXUnitsMenu);
        tmxMenu.add(splitTMXUnitsMenu);
        tmxMenu.add(setTMXUnitsPropertyMenu);
        tmxMenu.add(removeTMXUnitsPropertyMenu);
        this.actionMenu.add(fwMenu);
        this.actionMenu.add(tmxMenu);
        this.actionMenu.addSeparator();
        this.actionMenu.add(mispelledWordsMenu);
        this.actionMenu.addSeparator();
        this.actionMenu.add(copyNoLettersToTargetsMenu);
        this.actionMenu.add(copyNonTranslatablesToTargetMenu);
        this.actionMenu.add(copySourceToTargetsMenu);
        this.actionMenu.addSeparator();
        this.actionMenu.add(removeTargetsMenu);
        this.actionMenu.add(removeTargetsAsSourcesMenu);
        this.actionMenu.add(removeNotesMenu);
        this.actionMenu.add(removeATMenu);
        this.actionMenu.addSeparator();
        this.actionMenu.add(resetMatchStatusMenu);
        this.actionMenu.add(resetStateMenu);
        this.actionMenu.addSeparator();
        this.actionMenu.add(checkedStatusMenu);
        this.actionMenu.add(translatedStatusMenu);
        this.actionMenu.add(lockMenu);
        this.actionMenu.add(unlockMenu);
        this.actionMenu.add(bookmarkMenu);
        this.actionMenu.add(unbookmarkMenu);
        this.actionMenu.addSeparator();
        this.actionMenu.add(acceptAllChangesMenu);
        this.actionMenu.add(rejectAllChangesMenu);
        this.actionMenu.add(trimLeadingSpacesTargetMenu);
        this.actionMenu.add(trimTrailingSpacesTargetMenu);
    }

    private void copyNonTranslatablesToTarget() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.copyNonTranslatablesToTargetXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.copyNonTranslatablesToTargetTTX(ttx);
            }
        }
    }

    private void copyNoLettersToTarget() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.copyNoLettersToTargetXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.copyNoLettersToTargetTTX(ttx);
            }
        }
    }

    private void copySourceToTarget() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.copySourceToTargetXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.copySourceToTargetTTX(ttx);
            }
        }
    }

    private void manageTrackedChanges(boolean accept) {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            List tunits = xliff.getView().getViewUnits();
            if (tunits == null) {
                return;
            }
            TrackingChanges trackingChanges = this.topui.getTrackingChanges();
            if (trackingChanges == null) {
                this.topui.setTrackingChanges();
                trackingChanges = this.topui.getTrackingChanges();
            }
            xliff.saved = false;
            for (Object o : tunits) {
                XMLElement target;
                if (o == null || !(o instanceof XLIFFUnit)) continue;
                XLIFFUnit tu = (XLIFFUnit)o;
                if (tu.locked || !tu.translate || (target = tu.getTarget()) == null) continue;
                trackingChanges.manageTUChanges(xliff, target, accept);
            }
        }
    }

    private void resetMatchStatus() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.resetMatchStatusXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.resetMatchStatusTTX(ttx);
            }
        }
    }

    private void resetState() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.resetStateXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.resetStateTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.resetStateTMX(tmx);
                }
            }
        }
    }

    private void setState(int i) {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.setStateXliff(xliff, i);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.setStateTTX(ttx, i);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.setStateTMX(tmx, i);
                }
            }
        }
    }

    private void setLock(boolean lock) {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null && (lock || xliff.isCafeTranXLIFF)) {
            this.lockXliff(xliff, lock);
        }
    }

    private void setBookmark() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            if (xliff.isCafeTranXLIFF) {
                this.bookmarkXliff(xliff);
            } else {
                String m = "Projects created in other tools may not support bookmarks!";
                JOptionPane.showMessageDialog(this.topui, m);
            }
        }
    }

    private void unsetBookmark() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            if (xliff.isCafeTranXLIFF) {
                this.unbookmarkXliff(xliff);
            } else {
                String m = "Projects created in other tools may not support bookmarks!";
                JOptionPane.showMessageDialog(this.topui, m);
            }
        }
    }

    private void removeTargets() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.removeTargetsXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.removeTargetsTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.removeTargetsTMX(tmx);
                }
            }
        }
    }

    private void removeTargetSameAsSource() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.removeTargetSameAsSourceXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.removeTargetSameAsSourceTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.removeTargetSameAsSourceTMX(tmx);
                }
            }
        }
    }

    private void removeNotes() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.removeNotesXliff(xliff);
        }
    }

    private void removeATs() {
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.removeATsXliff(xliff);
        }
    }

    private void extractMisspelledWords() {
        HunSpellChecker sp = this.topui.getSpellChecker();
        if (sp == null || !sp.hasTargetDictionary()) {
            JOptionPane.showMessageDialog(this.topui, "No spell checking dictionary!");
            return;
        }
        XLIFF xliff = this.prview.getProject().getXLIFF();
        if (xliff != null) {
            this.extractMisspelledWordsXliff(xliff);
        } else {
            TTX ttx = this.prview.getProject().getTTX();
            if (ttx != null) {
                this.extractMisspelledWordsTTX(ttx);
            } else {
                TMX tmx = this.prview.getProject().getTMX();
                if (tmx != null) {
                    this.extractMisspelledWordsTMX(tmx);
                }
            }
        }
    }

    private void removeNotesXliff(XLIFF xliff) {
        List tunits = xliff.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        xliff.saved = false;
        for (Object o : tunits) {
            List notes;
            List list;
            XMLElement target;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (target = tu.getTarget()) == null) continue;
            if (xliff.isExternalToolXLIFF && !(list = xliff.getChildren("doc-info")).isEmpty()) {
                XMLElement docInfo = (XMLElement)list.get(0);
                tu.removeMrkTagComment(docInfo);
            }
            if ((notes = tu.getNotes()) == null || notes.size() <= 0) continue;
            if (notes.size() == 1) {
                String con;
                boolean remove = true;
                DefaultXMLElement c = (DefaultXMLElement)notes.get(0);
                Object no = c.getContent(0);
                if (no != null && (con = no.toString()).length() > 0 && con.equals("propagated")) {
                    remove = false;
                }
                if (!remove) continue;
                tu.removeNote(c);
                continue;
            }
            ArrayList<DefaultXMLElement> removeNotes = new ArrayList<DefaultXMLElement>(notes.size());
            Iterator ai = notes.iterator();
            while (ai.hasNext()) {
                String con;
                boolean remove = true;
                DefaultXMLElement c = (DefaultXMLElement)ai.next();
                Object no = c.getContent(0);
                if (no != null && (con = no.toString()).length() > 0 && con.equals("propagated")) {
                    remove = false;
                }
                if (!remove) continue;
                removeNotes.add(c);
            }
            for (DefaultXMLElement c : removeNotes) {
                tu.removeNote(c);
            }
        }
    }

    private void removeATsXliff(XLIFF xliff) {
        List tunits = xliff.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        xliff.saved = false;
        for (Object o : tunits) {
            List ats;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (ats = tu.getAltTrans()) == null || ats.size() <= 0) continue;
            for (AltTrans alt : ats) {
                tu.removeChild(alt);
            }
        }
    }

    private void removeTargetsXliff(XLIFF xliff) {
        List tunits = xliff.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        xliff.saved = false;
        boolean removeAttr = true;
        if (xliff.isExternalToolXLIFF || xliff.isTXML) {
            removeAttr = false;
        }
        for (Object o : tunits) {
            XMLElement target;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (target = tu.getTarget()) == null) continue;
            if (xliff.isExternalToolXLIFF) {
                if (!this.hasInternalLock(target)) {
                    List marks = target.getChildren("mrk");
                    if (marks.size() > 0) {
                        for (XMLElement next : marks) {
                            String nID = next.getAttribute("mid");
                            if (nID == null) continue;
                            next.getChildren().clear();
                        }
                        tu.updateParentTargetSegment();
                        tu.removeMatch(removeAttr);
                    } else {
                        target.getChildren().clear();
                        tu.removeMatch(removeAttr);
                    }
                }
            } else {
                target.getChildren().clear();
                tu.removeMatch(removeAttr);
            }
            if (xliff.isCafeTranXLIFF) {
                target.setAttribute("state", "new");
                List notes = tu.getNotes();
                for (DefaultXMLElement c : notes) {
                    String con;
                    Object no = c.getContent(0);
                    if (no == null || (con = no.toString()).length() <= 0 || !con.equals("propagated")) continue;
                    tu.removeChild(c);
                    break;
                }
            }
            tu.setState(0);
            tu.autopropagated = false;
            tu.edited = false;
        }
    }

    private void removeTargetsTTX(TTX ttx) {
        List tunits = ttx.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        ttx.saved = false;
        for (Object o : tunits) {
            TTXUnit tu;
            XMLElement target;
            if (o == null || !(o instanceof TTXUnit) || (target = (tu = (TTXUnit)o).getTarget()) == null) continue;
            target.getChildren().clear();
            tu.removeMatch(false);
            tu.setState(0);
        }
    }

    private void removeTargetsTMX(TMX tmx) {
        Collection tunits = TMXView.getFilteredUnits();
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        tmx.saved = false;
        if (tunits != null) {
            TranslationUnitMap map = tmx.getTUMap();
            String tlang = map.getTargetLang();
            for (TMXUnit tu : tunits) {
                TMXUnitVariant tuv = tu.getTUV(tlang);
                if (tuv == null) continue;
                tuv.getChildren().clear();
                tu.state = false;
            }
        }
    }

    private void removeTargetSameAsSourceTMX(TMX tmx) {
        Collection tunits = TMXView.getFilteredUnits();
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        tmx.saved = false;
        if (tunits != null) {
            TranslationUnitMap map = tmx.getTUMap();
            String slang = map.getSourceLang();
            String tlang = map.getTargetLang();
            for (TMXUnit tu : tunits) {
                TMXUnitVariant tuvs = tu.getTUV(slang);
                TMXUnitVariant tuvt = tu.getTUV(tlang);
                if (tuvs == null || tuvt == null) continue;
                String s = tuvs.getSegmentText();
                String t = tuvt.getSegmentText();
                if (!t.equals(s)) continue;
                tuvt.getChildren().clear();
                tu.state = false;
            }
        }
    }

    public void splitTMXUnits(String sPos, String tPos) {
        TMX tmx = this.prview.getProject().getTMX();
        if (tmx != null) {
            this.splitSegments(tmx, sPos, tPos);
        } else {
            MemoryView mv = this.topui.getMemoryView();
            List mems = mv.getLocalMemories();
            if (mems.size() > 0) {
                mv.startTaskDialog(mems);
                for (Memory m : mems) {
                    if (!m.isTaskReady() || (tmx = m.getTMX()) == null) continue;
                    this.splitSegments(tmx, sPos, tPos);
                }
            }
        }
    }

    public void splitSegments(TMX tmx, String sPos, String tPos) {
        List tunits = tmx.getBody().getTransUnits();
        tmx.saved = false;
        if (tunits != null) {
            TranslationUnitMap map = tmx.getTUMap();
            String slang = map.getSourceLang();
            String tlang = map.getTargetLang();
            int checkno = 0;
            while (checkno < tunits.size()) {
                Object o = tunits.get(checkno);
                if (o != null && o instanceof TMXUnit) {
                    TMXUnit tucheck = (TMXUnit)o;
                    XMLElement orgSource = tucheck.getTUV(slang).getSegment();
                    XMLElement orgTarget = tucheck.getTUV(tlang).getSegment();
                    if (orgSource != null && orgTarget != null) {
                        String orgSourceString = tucheck.getTUV(slang).getSegmentText();
                        String orgTargetString = tucheck.getTUV(tlang).getSegmentText();
                        int scaret = orgSourceString.indexOf(sPos);
                        int tcaret = orgTargetString.indexOf(tPos);
                        if (scaret == -1 || tcaret == -1) {
                            ++checkno;
                            continue;
                        }
                        if ((scaret += sPos.length()) == orgSourceString.length() || (tcaret += tPos.length()) == orgTargetString.length()) {
                            ++checkno;
                            continue;
                        }
                        TMXUnit tusplit = this.prepareTUSplit(tmx, tucheck);
                        XMLElement splitSource = tusplit.getTUV(slang).getSegment();
                        XMLElement splitTarget = tusplit.getTUV(tlang).getSegment();
                        String newSourceOrg = scaret == 0 ? " " : (scaret == orgSourceString.length() ? orgSourceString : orgSourceString.substring(0, scaret));
                        String newSplitSourceOrg = scaret == orgSourceString.length() ? " " : orgSourceString.substring(scaret);
                        this.makeSplitTU(orgSource, newSourceOrg);
                        this.makeSplitTU(splitSource, newSplitSourceOrg);
                        if (orgTargetString.length() > 0) {
                            String newTargetOrg = orgTargetString.substring(0, tcaret);
                            String newSplitTargetOrg = orgTargetString.substring(tcaret);
                            this.makeSplitTU(orgTarget, newTargetOrg);
                            this.makeSplitTU(splitTarget, newSplitTargetOrg);
                        }
                        tunits.add(checkno + 1, tusplit);
                    }
                }
                ++checkno;
            }
        }
    }

    private TMXUnit prepareTUSplit(TMX tmx, TMXUnit tucheck) {
        String createid;
        String slang = tmx.getTUMap().getSourceLang();
        String tlang = tmx.getTUMap().getTargetLang();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        String date = sdf.format(cal.getTime()).toString();
        TMXUnit tunit = new TMXUnit(tmx.getID());
        tunit.setName("tu");
        String tuid = tucheck.getAttribute("tuid");
        if (tuid != null) {
            tunit.setAttribute("tuid", tuid + "*");
        }
        if ((createid = tucheck.getAttribute("creationid")) != null) {
            tunit.setAttribute("creationid", createid);
        }
        tunit.setAttribute("creationdate", date);
        DefaultXMLElement tus = new DefaultXMLElement();
        tus.setName("source");
        DefaultXMLElement tut = new DefaultXMLElement();
        tut.setName("target");
        String id = tucheck.getAttribute("id");
        if (id != null) {
            tunit.setAttribute("id", id + "*");
        }
        TMXUnitVariant sourceTUV = new TMXUnitVariant();
        sourceTUV.setName("tuv");
        sourceTUV.setAttribute("xml:lang", slang);
        DefaultXMLElement seg = new DefaultXMLElement(0, 1);
        seg.setName("seg");
        sourceTUV.setSegment(seg);
        tunit.addTUV(sourceTUV);
        TMXUnitVariant targetTUV = new TMXUnitVariant();
        targetTUV.setName("tuv");
        targetTUV.setAttribute("xml:lang", tlang);
        seg = new DefaultXMLElement(0, 1);
        seg.setName("seg");
        seg.setContent(0, "");
        targetTUV.setSegment(seg);
        tunit.addTUV(targetTUV);
        return tunit;
    }

    private void makeSplitTU(XMLElement elem, String text) {
        List list = elem.getChildren();
        list.clear();
        elem.setContent(0, text);
    }

    private void deleteUnitsTMXTargetSameAsSource(TMX tmx) {
        Collection tunits = TMXView.getFilteredUnits();
        if (tunits == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits != null) {
            TranslationUnitMap map = tmx.getTUMap();
            boolean caseMatch = map.isCaseMatching();
            String slang = map.getSourceLang();
            String tlang = map.getTargetLang();
            int d = 0;
            Iterator it = tunits.iterator();
            while (it.hasNext()) {
                TMXUnit tu = (TMXUnit)it.next();
                TMXUnitVariant tuvs = tu.getTUV(slang);
                TMXUnitVariant tuvt = tu.getTUV(tlang);
                if (tuvs == null || tuvt == null) continue;
                String s = tuvs.getSegmentText();
                String t = tuvt.getSegmentText();
                if (caseMatch) {
                    if (!t.equals(s)) continue;
                    it.remove();
                    ++d;
                    continue;
                }
                if (!t.equalsIgnoreCase(s)) continue;
                it.remove();
                ++d;
            }
            if (d > 0) {
                tmx.getView().refreshView();
            }
            this.topui.resetSegmentsFilter();
            String m = Integer.toString(d) + " Translation Units deleted.";
            JOptionPane.showMessageDialog(this.topui, m);
        }
    }

    private void removeTargetSameAsSourceXliff(XLIFF xliff) {
        List tunits = xliff.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        xliff.saved = false;
        boolean removeAttr = true;
        if (xliff.isExternalToolXLIFF || xliff.isTXML) {
            removeAttr = false;
        }
        for (Object o : tunits) {
            XMLElement target;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (target = tu.getTarget()) == null) continue;
            String s = tu.getSourceText();
            String t = tu.getTargetText();
            if (!t.equals(s)) continue;
            if (xliff.isExternalToolXLIFF) {
                if (!this.hasInternalLock(target)) {
                    List marks = target.getChildren("mrk");
                    if (marks.size() > 0) {
                        for (XMLElement next : marks) {
                            String nID = next.getAttribute("mid");
                            if (nID == null) continue;
                            next.getChildren().clear();
                        }
                        tu.updateParentTargetSegment();
                        tu.removeMatch(removeAttr);
                    } else {
                        target.getChildren().clear();
                        tu.removeMatch(removeAttr);
                    }
                }
            } else {
                target.getChildren().clear();
                tu.removeMatch(removeAttr);
            }
            if (xliff.isCafeTranXLIFF) {
                target.setAttribute("state", "new");
                List notes = tu.getNotes();
                for (DefaultXMLElement c : notes) {
                    String con;
                    Object no = c.getContent(0);
                    if (no == null || (con = no.toString()).length() <= 0 || !con.equals("propagated")) continue;
                    tu.removeChild(c);
                    break;
                }
            }
            tu.edited = false;
            tu.autopropagated = false;
            tu.setState(0);
        }
    }

    private void removeTargetSameAsSourceTTX(TTX ttx) {
        List tunits = ttx.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        ttx.saved = false;
        for (Object o : tunits) {
            TTXUnit tu;
            XMLElement target;
            if (o == null || !(o instanceof TTXUnit) || (target = (tu = (TTXUnit)o).getTarget()) == null) continue;
            String s = tu.getSourceText();
            String t = tu.getTargetText();
            if (!t.equals(s)) continue;
            target.getChildren().clear();
            tu.removeMatch(false);
            tu.setState(0);
        }
    }

    private void copyNonTranslatablesToTargetXliff(XLIFF xliff) {
        List tunits = xliff.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        xliff.saved = false;
        ProcessXLIFFUnit process = new ProcessXLIFFUnit(xliff);
        for (Object o : tunits) {
            String sourceText;
            boolean b;
            XMLElement target;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (target = tu.getTarget()) != null && xliff.isExternalToolXLIFF && this.hasInternalLock(target) || (b = TaskView.isTranslatable(sourceText = tu.getSourceText()))) continue;
            process.processTU(tu);
            String s = process.getSourceString();
            if (s == null) continue;
            String t = s;
            process.updateTU(tu, s, t);
        }
    }

    private void copyNonTranslatablesToTargetTTX(TTX ttx) {
        List tunits = ttx.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        ttx.saved = false;
        ProcessTTXUnit process = new ProcessTTXUnit(ttx);
        for (Object o : tunits) {
            TTXUnit tu;
            String sourceText;
            boolean b;
            if (o == null || !(o instanceof TTXUnit) || (b = TaskView.isTranslatable(sourceText = (tu = (TTXUnit)o).getSourceText()))) continue;
            process.processTU(tu);
            String s = process.getSourceString();
            if (s == null) continue;
            String t = s;
            process.updateTU(tu, s, t);
        }
    }

    private void copyNoLettersToTargetXliff(XLIFF xliff) {
        List tunits = xliff.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        xliff.saved = false;
        Pattern noLetterPattern = Pattern.compile(AppPreferences.noLettersRegEx);
        ProcessXLIFFUnit process = new ProcessXLIFFUnit(xliff);
        for (Object o : tunits) {
            String sourceText;
            Matcher m;
            boolean b;
            XMLElement target;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (target = tu.getTarget()) != null && xliff.isExternalToolXLIFF && this.hasInternalLock(target) || !(b = (m = noLetterPattern.matcher(sourceText = tu.getSourceText())).find())) continue;
            process.processTU(tu);
            String s = process.getSourceString();
            if (s == null) continue;
            String t = s;
            process.updateTU(tu, s, t);
        }
    }

    private void copyNoLettersToTargetTTX(TTX ttx) {
        List tunits = ttx.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        ttx.saved = false;
        Pattern noLetterPattern = Pattern.compile(AppPreferences.noLettersRegEx);
        ProcessTTXUnit process = new ProcessTTXUnit(ttx);
        for (Object o : tunits) {
            TTXUnit tu;
            String sourceText;
            Matcher m;
            boolean b;
            if (o == null || !(o instanceof TTXUnit) || !(b = (m = noLetterPattern.matcher(sourceText = (tu = (TTXUnit)o).getSourceText())).find())) continue;
            process.processTU(tu);
            String s = process.getSourceString();
            if (s == null) continue;
            String t = s;
            process.updateTU(tu, s, t);
        }
    }

    private void copySourceToTargetXliff(XLIFF xliff) {
        List tunits = xliff.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        xliff.saved = false;
        ProcessXLIFFUnit process = new ProcessXLIFFUnit(xliff);
        for (Object o : tunits) {
            XMLElement target;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (target = tu.getTarget()) != null && xliff.isExternalToolXLIFF && this.hasInternalLock(target)) continue;
            process.processTU(tu);
            String s = process.getSourceString();
            if (s == null) continue;
            String t = s;
            process.updateTU(tu, s, t);
        }
    }

    private void copySourceToTargetTTX(TTX ttx) {
        List tunits = ttx.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        ttx.saved = false;
        ProcessTTXUnit process = new ProcessTTXUnit(ttx);
        for (Object o : tunits) {
            if (o == null || !(o instanceof TTXUnit)) continue;
            TTXUnit tu = (TTXUnit)o;
            process.processTU(tu);
            String s = process.getSourceString();
            if (s == null) continue;
            String t = s;
            process.updateTU(tu, s, t);
        }
    }

    private void showActionResults() {
        this.prview.getProject().edit("#0");
    }

    public boolean setTranslatedStatus() {
        XLIFF xliff;
        boolean statusSet = false;
        Project project = this.prview.getProject();
        if (project != null && (xliff = project.getXLIFF()) != null) {
            List projects = project.getProjects();
            if (projects != null) {
                for (Object object : projects) {
                    if (!(object instanceof XLIFF)) continue;
                    XLIFF xlf = (XLIFF)object;
                    xlf.setTranslatedStatus();
                    xlf.saved = false;
                }
            } else {
                xliff.setTranslatedStatus();
                xliff.saved = false;
            }
            project.translatedStatusSet = true;
            project.saveProject(false);
            statusSet = true;
        }
        return statusSet;
    }

    private boolean hasInternalLock(XMLElement xml) {
        boolean locked = false;
        List xlist = xml.getChildren();
        for (int i = 0; i < xlist.size(); ++i) {
            String lattr;
            Object object = xlist.get(i);
            if (!(object instanceof XMLElement)) continue;
            XMLElement e = (XMLElement)object;
            String name = e.getName();
            if (name.equals("x") && (lattr = e.getAttribute("id")) != null && lattr.startsWith("locked")) {
                locked = true;
                break;
            }
            locked = this.hasInternalLock(e);
            if (locked) break;
        }
        return locked;
    }

    private void trimLeadingTargetSpaces() {
        int type = AppPreferences.searchType;
        AppPreferences.searchType = 0;
        int mode = this.topui.getResourceView().getFindMode();
        this.topui.getResourceView().setFindMode(5);
        String s = "\\A\\s+";
        String r = "";
        this.topui.getResourceView().lookUpResource(s, r, null);
        AppPreferences.searchType = type;
        this.topui.getResourceView().setFindMode(mode);
    }

    private void trimTailingTargetSpaces() {
        int type = AppPreferences.searchType;
        AppPreferences.searchType = 0;
        int mode = this.topui.getResourceView().getFindMode();
        this.topui.getResourceView().setFindMode(5);
        String s = "\\s+\\z";
        String r = "";
        this.topui.getResourceView().lookUpResource(s, r, null);
        AppPreferences.searchType = type;
        this.topui.getResourceView().setFindMode(mode);
    }

    private void resetMatchStatusXliff(XLIFF xliff) {
        List tunits = xliff.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        xliff.saved = false;
        for (Object o : tunits) {
            XMLElement target;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (target = tu.getTarget()) == null) continue;
            if (xliff.isExternalToolXLIFF || xliff.isTXML) {
                tu.removeMatch(false);
                continue;
            }
            tu.removeMatch(true);
        }
    }

    private void resetMatchStatusTTX(TTX ttx) {
        List tunits = ttx.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        ttx.saved = false;
        for (Object o : tunits) {
            TTXUnit tu;
            XMLElement target;
            if (o == null || !(o instanceof TTXUnit) || (target = (tu = (TTXUnit)o).getTarget()) == null) continue;
            tu.removeMatch(false);
        }
    }

    private void resetStateXliff(XLIFF xliff) {
        List tunits = xliff.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        xliff.saved = false;
        for (Object o : tunits) {
            LinkedHashMap map;
            XMLElement tarXML;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate) continue;
            if (xliff.isCafeTranXLIFF) {
                tarXML = tu.getTarget();
                if (tarXML != null) {
                    tarXML.setAttribute("state", "new");
                }
                if ((map = tu.getAttributes()) != null) {
                    map.remove("approved");
                }
            } else if (xliff.isMXLIFF) {
                tu.setAttribute("m:confirmed", "0");
            } else if (xliff.isMQXLIFF) {
                tu.setAttribute("mq:status", "NotStarted");
            } else if (xliff.isStudioXLIFF) {
                tu.setSDLStatus("Draft");
            } else if (xliff.isExternalToolXLIFF) {
                tarXML = tu.getTarget();
                if (tarXML != null) {
                    tarXML.setAttribute("state", "new");
                }
                if ((map = tu.getAttributes()) != null) {
                    map.remove("approved");
                }
            }
            tu.setState(0);
        }
    }

    private void resetStateTTX(TTX ttx) {
        List tunits = ttx.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        ttx.saved = false;
        for (Object o : tunits) {
            if (o == null || !(o instanceof TTXUnit)) continue;
            TTXUnit tu = (TTXUnit)o;
            tu.setState(0);
        }
    }

    private void resetStateTMX(TMX tmx) {
        Collection tunits = TMXView.getFilteredUnits();
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        tmx.saved = false;
        for (Object o : tunits) {
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            tu.state = false;
        }
    }

    private void setStateXliff(XLIFF xliff, int i) {
        List tunits = xliff.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        xliff.saved = false;
        for (Object o : tunits) {
            String stateAttr;
            XLIFFUnit tuParent;
            XMLElement tarXML;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate) continue;
            if (xliff.isCafeTranXLIFF) {
                tarXML = tu.getTarget();
                if (i == 1 && tarXML != null) {
                    tarXML.setAttribute("state", "signed-off");
                } else if (i == 2) {
                    tu.setAttribute("approved", "yes");
                }
            } else if (xliff.isMQXLIFF) {
                tuParent = tu.getParentTU();
                if (tuParent != null) {
                    tu = tuParent;
                }
                if (i == 1) {
                    stateAttr = tu.getAttribute("mq:status");
                    if (stateAttr == null || !stateAttr.equals("ManuallyConfirmed")) {
                        tu.setAttribute("mq:status", "ManuallyConfirmed");
                    }
                } else if (!(i != 2 || (stateAttr = tu.getAttribute("mq:status")) != null && stateAttr.equals("Reviewer1Confirmed"))) {
                    tu.setAttribute("mq:status", "Reviewer1Confirmed");
                }
            } else if (xliff.isMXLIFF) {
                tuParent = tu.getParentTU();
                if (tuParent != null) {
                    tu = tuParent;
                }
                if (!(i != 1 || (stateAttr = tu.getAttribute("m:confirmed")) != null && stateAttr.equals("1"))) {
                    tu.setAttribute("m:confirmed", "1");
                }
            } else if (xliff.isStudioXLIFF) {
                if (i == 1) {
                    tu.setSDLStatus("Translated");
                } else if (i == 2) {
                    tu.setSDLStatus("ApprovedTranslation");
                }
            } else if (xliff.isExternalToolXLIFF) {
                tarXML = tu.getTarget();
                if (i == 1 && tarXML != null) {
                    tarXML.setAttribute("state", "signed-off");
                } else if (i == 2) {
                    tu.setAttribute("approved", "yes");
                }
            }
            tu.setState(i);
        }
    }

    private void setStateTTX(TTX ttx, int i) {
        List tunits = ttx.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        ttx.saved = false;
        for (Object o : tunits) {
            if (o == null || !(o instanceof TTXUnit)) continue;
            TTXUnit tu = (TTXUnit)o;
            tu.setState(i);
        }
    }

    private void setStateTMX(TMX tmx, int i) {
        Collection tunits = TMXView.getFilteredUnits();
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        tmx.saved = false;
        for (Object o : tunits) {
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            if (i != 1) continue;
            tu.state = true;
        }
    }

    private void lockXliff(XLIFF xliff, boolean lock) {
        List tunits = xliff.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        xliff.saved = false;
        for (Object o : tunits) {
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            tu.setLock(lock, xliff.isCafeTranXLIFF);
        }
    }

    private void bookmarkXliff(XLIFF xliff) {
        List tunits = xliff.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        xliff.saved = false;
        for (Object o : tunits) {
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            tu.bookmark = true;
            String s = xliff.getAttribute("xmlns:property");
            if (s == null) continue;
            tu.setAttribute("property:bookmark", "true");
        }
    }

    private void unbookmarkXliff(XLIFF xliff) {
        List tunits = xliff.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        xliff.saved = false;
        for (Object o : tunits) {
            LinkedHashMap map;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            tu.bookmark = false;
            String s = xliff.getAttribute("xmlns:property");
            if (s == null || (map = tu.getAttributes()) == null) continue;
            map.remove("property:bookmark");
        }
    }

    private int deleteUnitsTMX(TMX tmx, XLIFF xliff) {
        int d = 0;
        if (xliff == null) {
            tmx.getView();
            List tunits = TMXView.getFilteredUnits();
            if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
                return -1;
            }
            Collection col = tmx.getTranslationUnits();
            for (Object o : tunits) {
                boolean rem = col.remove(o);
                if (!rem) continue;
                ++d;
            }
        } else {
            Collection col = tmx.getTranslationUnits();
            SegmentParser parser = tmx.getParser();
            TranslationUnitMap map = tmx.getTUMap();
            String tlang = map.getTargetLang();
            List atunits = xliff.getView().getFilteredUnits();
            if (atunits == null) {
                JOptionPane.showMessageDialog(this.topui, "No Filter!");
                return -1;
            }
            for (XLIFFUnit next : atunits) {
                TMXUnit tux;
                String segment;
                String source = next.getSourceText();
                String target = next.getTargetText();
                TranslationUnit tu = parser.getExactMatchTU(source);
                if (tu == null || !(tu instanceof TMXUnit) || !target.equals(segment = (tux = (TMXUnit)tu).getSegment(tlang))) continue;
                col.remove(tux);
                map.removeTU(tux);
                ++d;
            }
        }
        if (d > 0) {
            tmx.getView().refreshView();
        }
        return d;
    }

    private void deleteNoLettersUnitsTMX(TMX tmx) {
        Collection tunits = TMXView.getFilteredUnits();
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits != null) {
            Pattern noLetterPattern = Pattern.compile(AppPreferences.noLettersRegEx);
            TranslationUnitMap map = tmx.getTUMap();
            String slang = map.getSourceLang();
            int d = 0;
            Iterator it = tunits.iterator();
            while (it.hasNext()) {
                String sourceText;
                Matcher m;
                boolean b;
                TMXUnit tu;
                TMXUnitVariant tuvs;
                Object o = it.next();
                if (o == null || !(o instanceof TMXUnit) || (tuvs = (tu = (TMXUnit)o).getTUV(slang)) == null || !(b = (m = noLetterPattern.matcher(sourceText = tuvs.getSegmentText())).find())) continue;
                it.remove();
                ++d;
            }
            if (d > 0) {
                tmx.getView().refreshView();
            }
            this.topui.resetSegmentsFilter();
            String m = Integer.toString(d) + " Translation Units deleted.";
            JOptionPane.showMessageDialog(this.topui, m);
        }
    }

    private void deleteDuplicateSourceSegmentsTMX(TMX tmx) {
        Collection tunits = tmx.getTranslationUnits();
        ArrayList<TranslationUnit> toRemove = new ArrayList<TranslationUnit>();
        for (Object o : tunits) {
            if (o == null || !(o instanceof TranslationUnit)) continue;
            TranslationUnit tu = (TranslationUnit)o;
            while (tu.hasLink()) {
                TranslationUnit tu1 = tu.getLink();
                toRemove.add(tu1);
                tu.setLink(null);
                tu = tu1;
            }
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            Object object = toRemove.get(i);
            tunits.remove(object);
        }
        if (toRemove.size() > 0) {
            tmx.getView().refreshView();
        }
        this.topui.resetSegmentsFilter();
        String m = Integer.toString(toRemove.size()) + " Translation Units deleted.";
        JOptionPane.showMessageDialog(this.topui, m);
    }

    private void deleteDuplicateUnitsTMX(TMX tmx) {
        Collection tunits = tmx.getTranslationUnits();
        TranslationUnitMap map = tmx.getTUMap();
        String tlang = map.getTargetLang();
        ArrayList<TranslationUnit> toRemove = new ArrayList<TranslationUnit>();
        for (Object o : tunits) {
            TranslationUnit tux;
            if (o == null || !(o instanceof TranslationUnit)) continue;
            LinkedHashMap<String, TranslationUnit> uq = new LinkedHashMap<String, TranslationUnit>(4);
            TranslationUnit tunit = (TranslationUnit)o;
            String target = tunit.getSegment(tlang);
            TranslationUnit tu = tunit;
            while (tu.hasLink()) {
                TranslationUnit tu1 = tu.getLink();
                String t = tu1.getSegment(tlang);
                TranslationUnit tux2 = uq.put(t, tu1);
                if (tux2 != null) {
                    toRemove.add(tux2);
                }
                tu.setLink(null);
                tu = tu1;
            }
            if (!uq.isEmpty() && (tux = (TranslationUnit)uq.get(target)) != null) {
                toRemove.add(tux);
                uq.remove(target);
            }
            if (uq.size() <= 0) continue;
            tu = null;
            for (Map.Entry entry : uq.entrySet()) {
                TranslationUnit translationUnit = (TranslationUnit)entry.getValue();
                if (tu != null) {
                    tu.setLink(translationUnit);
                } else {
                    tunit.setLink(translationUnit);
                }
                tu = translationUnit;
            }
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            Object object = toRemove.get(i);
            tunits.remove(object);
        }
        if (toRemove.size() > 0) {
            tmx.getView().refreshView();
        }
        this.topui.resetSegmentsFilter();
        String m = Integer.toString(toRemove.size()) + " Translation Units deleted.";
        JOptionPane.showMessageDialog(this.topui, m);
    }

    private void setPropertyForUnitsTMX(TMX tmx, String type, String value) {
        Collection tunits = TMXView.getFilteredUnits();
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits != null) {
            int d = 0;
            for (Object o : tunits) {
                if (o == null || !(o instanceof TMXUnit)) continue;
                TMXUnit tu = (TMXUnit)o;
                List properties = tu.getChildren("prop");
                boolean set = false;
                for (DefaultXMLElement elem : properties) {
                    String etype = elem.getAttribute("type");
                    if (etype == null || !etype.equalsIgnoreCase(type)) continue;
                    elem.setContent(0, value);
                    set = true;
                    ++d;
                    break;
                }
                if (set) continue;
                DefaultXMLElement prop = new DefaultXMLElement();
                prop.setName("prop");
                prop.setAttribute("type", type);
                prop.setContent(0, value);
                tu.getChildren().add(0, prop);
                ++d;
            }
            if (d > 0) {
                tmx.getView().refreshView();
            }
            this.topui.resetSegmentsFilter();
            String m = Integer.toString(d) + " properties set.";
            JOptionPane.showMessageDialog(this.topui, m);
        }
    }

    private void removePropertyForUnitsTMX(TMX tmx, String type, String value) {
        Collection tunits = TMXView.getFilteredUnits();
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        if (tunits != null) {
            int d = 0;
            boolean removeAll = false;
            if (type.equals("*")) {
                removeAll = true;
            }
            for (Object o : tunits) {
                if (o == null || !(o instanceof TMXUnit)) continue;
                TMXUnit tu = (TMXUnit)o;
                List list = tu.getChildren();
                Iterator it1 = list.iterator();
                while (it1.hasNext()) {
                    DefaultXMLElement elem;
                    String name;
                    Object object = it1.next();
                    if (!(object instanceof DefaultXMLElement) || (name = (elem = (DefaultXMLElement)object).getName()) == null || !name.equals("prop")) continue;
                    if (removeAll) {
                        it1.remove();
                        ++d;
                        continue;
                    }
                    String etype = elem.getAttribute("type");
                    if (etype == null || !etype.equalsIgnoreCase(type)) continue;
                    if (value.length() == 0 || value.equals("*")) {
                        it1.remove();
                        ++d;
                        continue;
                    }
                    String evalue = elem.getContent(0).toString();
                    if (evalue == null || !evalue.equalsIgnoreCase(value)) continue;
                    it1.remove();
                    ++d;
                }
            }
            if (d > 0) {
                tmx.getView().refreshView();
            }
            this.topui.resetSegmentsFilter();
            String m = Integer.toString(d) + " properties removed.";
            JOptionPane.showMessageDialog(this.topui, m);
        }
    }

    private void replaceInternalTagsWithSpace(TMX tmx) {
        Pattern pattern = Pattern.compile("<.+?[0-9]+[/]*>");
        Pattern pattern2 = Pattern.compile("[ ]{2,}");
        Collection tunits = tmx.getTranslationUnits();
        int r = 0;
        for (Object o : tunits) {
            Matcher m;
            String s;
            if (o == null || !(o instanceof TMXUnit)) continue;
            TMXUnit tu = (TMXUnit)o;
            Collection col = tu.getTMXUnitVariants();
            for (TMXUnitVariant tuv : col) {
                XMLElement seg = tuv.getSegment();
                List children = seg.getChildren();
                StringBuffer sb = new StringBuffer();
                boolean hit = false;
                ListIterator it2 = children.listIterator();
                while (it2.hasNext()) {
                    Object object = it2.next();
                    if (object instanceof XMLElement) {
                        sb.append(" ");
                        hit = true;
                        ++r;
                        continue;
                    }
                    s = object.toString();
                    m = pattern.matcher(s);
                    while (m.find()) {
                        m.appendReplacement(sb, " ");
                        hit = true;
                        ++r;
                    }
                    m.appendTail(sb);
                }
                if (!hit) continue;
                children.clear();
                String s2 = sb.toString();
                Matcher m2 = pattern2.matcher(s2);
                s2 = m2.replaceAll(" ");
                seg.setContent(0, s2);
            }
            while (tu.hasLink()) {
                TMXUnit tu1;
                tu = tu1 = (TMXUnit)tu.getLink();
                Collection col2 = tu.getTMXUnitVariants();
                for (TMXUnitVariant tuv : col2) {
                    XMLElement seg = tuv.getSegment();
                    List children = seg.getChildren();
                    StringBuffer sb = new StringBuffer();
                    boolean hit = false;
                    ListIterator it2 = children.listIterator();
                    while (it2.hasNext()) {
                        Object object = it2.next();
                        if (object instanceof XMLElement) {
                            sb.append(" ");
                            hit = true;
                            ++r;
                            continue;
                        }
                        String s3 = object.toString();
                        Matcher m3 = pattern.matcher(s3);
                        while (m3.find()) {
                            m3.appendReplacement(sb, " ");
                            hit = true;
                            ++r;
                        }
                        m3.appendTail(sb);
                    }
                    if (!hit) continue;
                    children.clear();
                    s = sb.toString();
                    m = pattern2.matcher(s);
                    s = m.replaceAll(" ");
                    seg.setContent(0, s);
                }
            }
        }
        tmx.getView().refreshView();
        this.topui.resetSegmentsFilter();
        String m = Integer.toString(r) + " internal tags replaced with space.";
        JOptionPane.showMessageDialog(this.topui, m);
    }

    private void projectToSave() {
        this.topui.getWorkflowView().getWorkflowManager().setAutoSaveStatus(1);
        Project project = this.prview.getProject();
        List projects = project.getProjects();
        if (projects != null) {
            for (Object object : projects) {
                if (object instanceof XLIFF) {
                    XLIFF xlf = (XLIFF)object;
                    xlf.saved = false;
                    continue;
                }
                if (object instanceof TMX) {
                    TMX tmx = (TMX)object;
                    tmx.saved = false;
                    continue;
                }
                if (!(object instanceof TTX)) continue;
                TTX ttx = (TTX)object;
                ttx.saved = false;
            }
        } else {
            XLIFF xliff = project.getXLIFF();
            if (xliff != null) {
                xliff.saved = false;
            } else {
                TMX tmx = project.getTMX();
                if (tmx != null) {
                    tmx.saved = false;
                }
            }
        }
    }

    private void extractFrequentWords(int sort) {
        Frequencer fr = this.topui.getFrequencer();
        if (fr == null) {
            this.topui.setFrequencer();
            fr = this.topui.getFrequencer();
        }
        fr.showAllFreqWords(sort);
    }

    public static boolean isTranslatable(String segment) {
        boolean b = false;
        HashSet<Integer> positions = new HashSet<Integer>(segment.length());
        Set set = Placeables.getPlaceablesSet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String place = it.next().toString();
            if (place.charAt(0) != '|') {
                int start = segment.indexOf(place);
                if (start == -1) continue;
                int len = start + place.length();
                for (int i = start; i < len; ++i) {
                    positions.add(i);
                }
                continue;
            }
            place = place.substring(1);
            Pattern ppattern = Pattern.compile(place);
            Matcher m = ppattern.matcher(segment);
            while (m.find()) {
                place = m.group();
                int start = m.start();
                int len = start + place.length();
                for (int i = start; i < len; ++i) {
                    positions.add(i);
                }
            }
        }
        if (positions.size() > 0) {
            int slen = segment.length();
            for (int i = 0; i < slen; ++i) {
                char c = segment.charAt(i);
                if (positions.contains(i) || Character.isSpaceChar(c)) continue;
                b = true;
                break;
            }
        } else {
            b = true;
        }
        return b;
    }

    private void extractMisspelledWordsXliff(XLIFF xliff) {
        HunSpellChecker sp = this.topui.getSpellChecker();
        List tunits = xliff.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        HashSet<String> words = new HashSet<String>();
        for (Object o : tunits) {
            List mwords;
            String target;
            int state;
            if (o == null || !(o instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)o;
            if (tu.locked || !tu.translate || (state = tu.getState()) == 1 && !AppPreferences.qaCheckedSegments || (target = tu.getTargetText()) == null || target.length() == 0 || (mwords = sp.getMispelledWords(target)).isEmpty()) continue;
            for (int i = 0; i < mwords.size(); ++i) {
                String s = (String)mwords.get(i);
                words.add(s);
            }
        }
        if (!words.isEmpty()) {
            TreeSet twords = new TreeSet(words);
            sp.showMistakes(twords);
        } else {
            String message = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("YOUR SPELLING IS PERFECT!");
            JOptionPane.showMessageDialog(this.topui, message);
        }
    }

    private void extractMisspelledWordsTTX(TTX ttx) {
        HunSpellChecker sp = this.topui.getSpellChecker();
        List tunits = ttx.getView().getViewUnits();
        if (tunits == null) {
            return;
        }
        HashSet<String> words = new HashSet<String>();
        for (Object o : tunits) {
            List mwords;
            String target;
            TTXUnit tu;
            int state;
            if (o == null || !(o instanceof TTXUnit) || (state = (tu = (TTXUnit)o).getState()) == 1 && !AppPreferences.qaCheckedSegments || (target = tu.getTargetText()) == null || target.length() == 0 || (mwords = sp.getMispelledWords(target)).isEmpty()) continue;
            for (int i = 0; i < mwords.size(); ++i) {
                String s = (String)mwords.get(i);
                words.add(s);
            }
        }
        if (!words.isEmpty()) {
            TreeSet twords = new TreeSet(words);
            sp.showMistakes(twords);
        } else {
            String message = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("YOUR SPELLING IS PERFECT!");
            JOptionPane.showMessageDialog(this.topui, message);
        }
    }

    private void extractMisspelledWordsTMX(TMX tmx) {
        HunSpellChecker sp = this.topui.getSpellChecker();
        Collection tunits = TMXView.getFilteredUnits();
        if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
            tunits = tmx.getTranslationUnits();
        }
        HashSet<String> words = new HashSet<String>();
        if (tunits != null) {
            TranslationUnitMap map = tmx.getTUMap();
            String tlang = map.getTargetLang();
            for (TMXUnit tu : tunits) {
                List mwords;
                String target;
                TMXUnitVariant tuv = tu.getTUV(tlang);
                if (tuv == null || (target = tuv.getSegmentText()) == null || target.length() == 0 || (mwords = sp.getMispelledWords(target)).isEmpty()) continue;
                for (int i = 0; i < mwords.size(); ++i) {
                    String s = (String)mwords.get(i);
                    words.add(s);
                }
            }
        }
        if (!words.isEmpty()) {
            TreeSet twords = new TreeSet(words);
            sp.showMistakes(twords);
        } else {
            String message = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("YOUR SPELLING IS PERFECT!");
            JOptionPane.showMessageDialog(this.topui, message);
        }
    }
}

