/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.MainView;
import translator.XMLHelper;
import translator.ui.GridPanel;

public class TextShortcuts {
    private MainView topui;
    private String name;
    static String path = AppPreferences.packagePath + "resources" + AppPreferences.fs + "shortcuts";
    private ConcurrentHashMap shortcutsMap;
    private ConcurrentHashMap shortcutsMap2;

    public TextShortcuts(MainView topui) {
        this.topui = topui;
        this.shortcutsMap = new ConcurrentHashMap();
        this.shortcutsMap2 = new ConcurrentHashMap();
    }

    public Map getShortcutsMap() {
        return this.shortcutsMap;
    }

    public Map getShortcutsMap2() {
        return this.shortcutsMap2;
    }

    public void setDefaultShortcuts(Locale locale) {
        this.shortcutsMap2.clear();
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        if (lang != null && lang.equals("fr")) {
            if (country != null && country.equals("CA")) {
                if (AppPreferences.addNonBreakingSpaceFrench) {
                    String nb = Character.toString('\u00a0');
                    this.shortcutsMap2.put(":", nb + ":");
                }
                if (AppPreferences.changeQuotesToGuillemetsFrench) {
                    String guillemet = Character.toString('\u00ab');
                    this.shortcutsMap2.put("\"", guillemet);
                }
            } else {
                if (AppPreferences.addNonBreakingSpaceFrench) {
                    String nb = Character.toString('\u00a0');
                    this.shortcutsMap2.put(":", nb + ":");
                    this.shortcutsMap2.put(";", nb + ";");
                    this.shortcutsMap2.put("!", nb + "!");
                    this.shortcutsMap2.put("?", nb + "?");
                }
                if (AppPreferences.changeQuotesToGuillemetsFrench) {
                    String guillemet = Character.toString('\u00ab');
                    this.shortcutsMap2.put("\"", guillemet);
                }
            }
        }
    }

    public void addShortcut(String shortcut) {
        String[] ws = shortcut.split("\\s+");
        StringBuilder mem = new StringBuilder();
        StringBuilder full = new StringBuilder();
        for (int i = 0; i < ws.length; ++i) {
            String w = ws[i];
            if (w == null || w.length() <= 0) continue;
            mem.append(w.charAt(0));
            full.append(w);
            if (i >= ws.length - 1) continue;
            full.append(" ");
        }
        shortcut = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("THE SHORTCUT FOR") + " " + shortcut;
        Object o = JOptionPane.showInputDialog(this.topui, shortcut, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TEXT SHORTCUTS"), -1, null, null, mem.toString());
        if (o != null && (shortcut = o.toString()) != null && shortcut.length() > 0) {
            String fullString = XMLHelper.hexToUnicode(full.toString());
            if (shortcut.length() > 0 && fullString.length() > 0) {
                this.shortcutsMap.put(shortcut, fullString);
            }
        }
    }

    public void showShortcuts() {
        if (!this.shortcutsMap.isEmpty()) {
            Object pair;
            int cols = 1;
            if (this.shortcutsMap.size() > 10) {
                cols = 2;
            } else if (this.shortcutsMap.size() > 20) {
                cols = 3;
            }
            final JDialog dialog = new JDialog((Frame)this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TEXT SHORTCUTS"));
            dialog.setDefaultCloseOperation(2);
            dialog.setLayout(new BorderLayout());
            dialog.setModal(true);
            dialog.setResizable(false);
            GridPanel panel = new GridPanel();
            panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
            panel.setLayout(new GridLayout(0, cols, 2, 2));
            JScrollPane scroll = new JScrollPane(panel);
            scroll.setBorder(new EmptyBorder(0, 5, 0, 5));
            scroll.getVerticalScrollBar().setUnitIncrement(10);
            scroll.setOpaque(false);
            scroll.getViewport().setOpaque(false);
            if (this.shortcutsMap.size() > 60) {
                scroll.setPreferredSize(new Dimension(500, 500));
            }
            dialog.add((Component)scroll, "Center");
            Set e = this.shortcutsMap.entrySet();
            Object[] arr = new String[e.size()];
            int i = 0;
            Iterator it = e.iterator();
            while (it.hasNext()) {
                arr[i] = pair = it.next().toString();
                ++i;
            }
            FontIcon ficon = null;
            Arrays.sort(arr);
            for (i = 0; i < arr.length; ++i) {
                pair = arr[i];
                int j = ((String)pair).indexOf(61);
                String acr = ((String)pair).substring(0, j);
                String full = ((String)pair).substring(j + 1);
                JButton menuFileItem = new JButton(new AbstractAction(this, acr){
                    final /* synthetic */ TextShortcuts this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        dialog.setVisible(false);
                        dialog.dispose();
                        JButton menu = (JButton)a.getSource();
                        String ac = menu.getText();
                        this.this$0.shortcutsMap.remove(ac);
                    }
                });
                menuFileItem.setFont(menuFileItem.getFont().deriveFont(1));
                menuFileItem.setToolTipText(full);
                menuFileItem.setHorizontalAlignment(2);
                if (ficon == null) {
                    ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CLOSE, (int)(menuFileItem.getFont().getSize() + 4), (Color)menuFileItem.getForeground());
                }
                menuFileItem.setIcon((Icon)ficon);
                menuFileItem.setIconTextGap(16);
                menuFileItem.setHorizontalTextPosition(4);
                panel.add(menuFileItem);
            }
            GridPanel southPanel = new GridPanel();
            JButton jb = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE"));
            jb.setHorizontalAlignment(2);
            jb.addActionListener(new ActionListener(){
                final /* synthetic */ TextShortcuts this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                    dialog.dispose();
                    this.this$0.shortcutsMap.clear();
                    this.this$0.saveShortcuts();
                }
            });
            southPanel.add(jb);
            JButton jbs = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE"));
            jbs.setHorizontalAlignment(2);
            jbs.addActionListener(new ActionListener(){
                final /* synthetic */ TextShortcuts this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                    dialog.dispose();
                    this.this$0.saveShortcuts();
                }
            });
            southPanel.add(jbs);
            jb = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE"));
            jb.setHorizontalAlignment(2);
            jb.addActionListener(new ActionListener(){
                final /* synthetic */ TextShortcuts this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            southPanel.add(jb);
            dialog.add((Component)southPanel, "South");
            Dimension dlgSize = dialog.getPreferredSize();
            Dimension frmSize = this.topui.getSize();
            Point loc = this.topui.getLocation();
            dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            dialog.pack();
            jbs.requestFocusInWindow();
            dialog.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadShortcuts() {
        this.shortcutsMap.clear();
        FileInputStream fis = null;
        try {
            File file;
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdir();
            }
            if ((file = new File(path + AppPreferences.fs + AppPreferences.textShortcutsFile)).exists()) {
                String line;
                this.name = file.getName();
                fis = new FileInputStream(file);
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                while ((line = in.readLine()) != null && line.length() > 0) {
                    int i = line.indexOf(61);
                    if (i == -1) continue;
                    String key = line.substring(0, i);
                    String value = line.substring(i + 1);
                    if (value == null || key == null || value.length() <= 0 || key.length() <= 0) continue;
                    this.shortcutsMap.put(key, value);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(TextShortcuts.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(TextShortcuts.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void saveShortcuts() {
        if (this.name == null) {
            this.name = JOptionPane.showInputDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NAME") + ":", "");
        }
        if (this.name != null && this.name.length() > 0) {
            if (!this.name.toLowerCase().endsWith(".txt")) {
                this.name = this.name + ".txt";
            }
            AppPreferences.textShortcutsFile = this.name;
            try {
                File file = new File(path + AppPreferences.fs + this.name);
                File tempFile = File.createTempFile("old", null, file.getParentFile());
                FileOutputStream fout = new FileOutputStream(tempFile);
                BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, "UTF-8"));
                Set e = this.shortcutsMap.entrySet();
                Iterator it = e.iterator();
                while (it.hasNext()) {
                    String pair = it.next().toString();
                    awriter.write(pair + AppPreferences.ls);
                }
                awriter.close();
                fout.close();
                if (file.exists()) {
                    file.delete();
                }
                if (!tempFile.renameTo(file)) {
                    throw new IOException();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

