/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import translator.AppPreferences;
import translator.DefaultResource;
import translator.MainView;
import translator.MatchBoard;
import translator.Options;
import translator.Project;
import translator.TabView;
import translator.TrackedChange;
import translator.XMLElement;
import translator.ui.GridPanel;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;

public class TrackingChanges
extends DefaultResource {
    private MainView topui;
    private JToolBar bar;
    private JButton buttonAccept;
    private JButton buttonReject;
    private JButton buttonAcceptAll;
    private JButton buttonRejectAll;
    private JCheckBox nextSegmentBox;
    private JCheckBox recordBox;
    private JCheckBox translateBox;
    private JScrollPane masterScrollPane;
    private JTable masterTable;
    private BindingGroup bindingGroup;
    private static List<TrackedChange> changes;
    private String name;
    private GridPanel panel;

    public TrackingChanges(MainView topui) {
        this.topui = topui;
        this.panel = new GridPanel();
        topui.getTargetView().setTargetProtection(true);
        if (AppPreferences.alpha != -1) {
            this.panel.setOpaque(false);
            this.panel.setGrid(true);
            this.panel.setTransparent(true);
            Color c = new Color(AppPreferences.background);
            Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), 0);
            this.panel.setBackground(color);
        } else {
            this.panel.setOpaque(true);
            this.panel.setGrid(AppPreferences.backGrid);
            if (AppPreferences.background != 0) {
                this.panel.setBackground(new Color(AppPreferences.background));
            }
        }
        this.panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 10));
        this.panel.setLayout(new BorderLayout());
        this.createToolBar();
        this.createTable();
        this.name = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHANGES");
        topui.getTabView().addTab(this, this.name, this.panel);
    }

    public void track(boolean track) {
        this.topui.getTargetView().trackChanges(track);
    }

    private void createToolBar() {
        this.bar = new JToolBar();
        this.bar.setFloatable(false);
        if (AppPreferences.alpha != -1) {
            this.bar.setOpaque(false);
        } else {
            this.bar.setOpaque(true);
        }
        if (AppPreferences.tbackground2 != 0) {
            if (!AppPreferences.backGrid) {
                this.bar.setBackground(this.topui.getMainPanelBackgroundColor());
            } else {
                this.bar.setBackground(GridPanel.darker(this.topui.getMainPanelBackgroundColor(), 0.92));
            }
        }
        this.buttonAccept = new JButton();
        this.buttonAccept.setOpaque(false);
        this.buttonAccept.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.buttonAccept.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.tbackground2 != 0) {
            this.buttonAccept.setBackground(this.topui.getMainPanelBackgroundColor());
        }
        this.buttonAccept.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACCEPT"));
        this.buttonAccept.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACCEPT THE SELECTED CHANGE"));
        this.buttonAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackingChanges.this.acceptChange();
            }
        });
        this.buttonReject = new JButton();
        this.buttonReject.setOpaque(false);
        this.buttonReject.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.buttonReject.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.tbackground2 != 0) {
            this.buttonReject.setBackground(this.topui.getMainPanelBackgroundColor());
        }
        this.buttonReject.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REJECT"));
        this.buttonReject.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REJECT THE SELECTED CHANGE"));
        this.buttonReject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackingChanges.this.rejectChange();
            }
        });
        this.buttonAcceptAll = new JButton();
        this.buttonAcceptAll.setOpaque(false);
        this.buttonAcceptAll.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.buttonAcceptAll.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.tbackground2 != 0) {
            this.buttonAcceptAll.setBackground(this.topui.getMainPanelBackgroundColor());
        }
        this.buttonAcceptAll.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACCEPT ALL"));
        this.buttonAcceptAll.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACCEPT ALL CHANGES IN THE CURRENT SEGMENT") + " (" + Options.getShortcutComboString("k118") + ")");
        this.buttonAcceptAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackingChanges.this.acceptAllChanges();
            }
        });
        this.buttonRejectAll = new JButton();
        this.buttonRejectAll.setOpaque(false);
        this.buttonRejectAll.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.buttonRejectAll.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.tbackground2 != 0) {
            this.buttonRejectAll.setBackground(this.topui.getMainPanelBackgroundColor());
        }
        this.buttonRejectAll.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REJECT ALL"));
        this.buttonRejectAll.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REJECT ALL CHANGES IN THE CURRENT SEGMENT") + " (" + Options.getShortcutComboString("k119") + ")");
        this.buttonRejectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackingChanges.this.rejectAllChanges();
            }
        });
        this.nextSegmentBox = new JCheckBox("Go");
        this.nextSegmentBox.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MOVE TO THE NEXT SEGMENT"));
        this.nextSegmentBox.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.nextSegmentBox.setOpaque(false);
        this.nextSegmentBox.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.tbackground2 != 0) {
            this.nextSegmentBox.setBackground(this.topui.getMainPanelBackgroundColor());
        }
        this.recordBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RECORD"));
        this.recordBox.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RECORD CHANGES IN THE CURRENT SEGMENT"));
        this.recordBox.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.recordBox.setSelected(AppPreferences.recordChanges);
        this.recordBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int state = e.getStateChange();
                AppPreferences.recordChanges = state == 1;
                TrackingChanges.this.track(AppPreferences.recordChanges);
            }
        });
        this.recordBox.setOpaque(false);
        this.recordBox.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.tbackground2 != 0) {
            this.nextSegmentBox.setBackground(this.topui.getMainPanelBackgroundColor());
        }
        this.translateBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE"));
        this.translateBox.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRACK AND TRANSLATE"));
        this.translateBox.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.translateBox.setSelected(AppPreferences.automaticMatching);
        this.translateBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int state = e.getStateChange();
                if (state == 1) {
                    AppPreferences.automaticMatching = true;
                } else {
                    AppPreferences.automaticMatching = false;
                    MatchBoard mb = TrackingChanges.this.topui.getMatchBoard();
                    if (mb != null) {
                        mb.clearMatchBoard();
                    }
                }
            }
        });
        this.translateBox.setOpaque(false);
        this.translateBox.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.tbackground2 != 0) {
            this.translateBox.setBackground(this.topui.getMainPanelBackgroundColor());
        }
        this.bar.add(this.buttonAccept);
        this.bar.add(this.buttonReject);
        this.bar.add(this.buttonAcceptAll);
        this.bar.add(this.buttonRejectAll);
        this.bar.add(Box.createHorizontalGlue());
        this.bar.add(this.nextSegmentBox);
        this.bar.add(this.translateBox);
        this.bar.add(this.recordBox);
        this.panel.add((Component)this.bar, "South");
    }

    private void createTable() {
        ArrayList list = new ArrayList();
        changes = ObservableCollections.observableList(list);
        this.masterScrollPane = new JScrollPane();
        this.masterScrollPane.setOpaque(false);
        this.masterScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.masterScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        this.masterScrollPane.getViewport().setOpaque(false);
        this.masterTable = new JTable();
        this.masterTable.setDefaultEditor(Object.class, null);
        Font font = this.masterTable.getFont();
        int size = font.getSize();
        if (size < 14) {
            font = font.deriveFont(14.0f);
        }
        this.masterTable.setFont(font);
        this.masterTable.setRowHeight(size + 8);
        this.masterTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting() && TrackingChanges.this.masterTable.getSelectedRow() != -1) {
                    int row = TrackingChanges.this.masterTable.getSelectedRow();
                    TrackedChange tc = (TrackedChange)changes.get(row);
                    String sid = "<" + tc.getID() + " ";
                    String eid = "</" + tc.getID() + ">";
                    Document doc = TrackingChanges.this.topui.getTargetPane().getDocument();
                    try {
                        String text = doc.getText(0, doc.getLength());
                        int i = text.indexOf(sid);
                        if (i != -1) {
                            int j = text.indexOf(">", i);
                            int k = text.indexOf(eid, j);
                            TrackingChanges.this.topui.getTargetPane().setSelectionStart(j + 1);
                            TrackingChanges.this.topui.getTargetPane().setSelectionEnd(k);
                            TrackingChanges.this.topui.getTargetPane().getCaret().setSelectionVisible(true);
                        }
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(TrackingChanges.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        JTableHeader header = this.masterTable.getTableHeader();
        header.setFont(font.deriveFont(1));
        header.setForeground(new Color(2, 119, 189));
        this.bindingGroup = new BindingGroup();
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, changes, (JTable)this.masterTable);
        String s = "change";
        String column = "Change";
        JTableBinding.ColumnBinding columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
        columnBinding.setColumnName(column);
        columnBinding.setColumnClass(String.class);
        s = "author";
        column = "Author";
        columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
        columnBinding.setColumnName(column);
        columnBinding.setColumnClass(String.class);
        s = "date";
        column = "Date";
        columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + s + "}")));
        columnBinding.setColumnName(column);
        columnBinding.setColumnClass(String.class);
        this.bindingGroup.addBinding((Binding)jTableBinding);
        jTableBinding.bind();
        this.masterScrollPane.setViewportView(this.masterTable);
        this.panel.add((Component)this.masterScrollPane, "Center");
    }

    public void addChange(TrackedChange change) {
        changes.add(change);
    }

    public void selectRow() {
        int rows = this.masterTable.getRowCount();
        if (rows > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TrackingChanges.this.masterTable.setRowSelectionInterval(0, 0);
                }
            });
        }
    }

    public void clear() {
        changes.clear();
    }

    public void acceptAllChanges() {
        int rc;
        XLIFF xliff;
        Project p = this.topui.getProjectView().getProject();
        if (p != null && (xliff = p.getXLIFF()) != null && (rc = changes.size()) > 0) {
            int i;
            for (i = 0; i < rc; ++i) {
                TrackedChange tc = changes.get(i);
                this.accept(tc, xliff);
            }
            i = p.getCurrenTUIndex();
            if (i != -1) {
                p.edit("#" + Integer.toString(i));
                if (this.nextSegmentBox.isSelected()) {
                    xliff.getWorkflow().checkNextTU();
                }
            }
        }
    }

    public void acceptChange() {
        int row = this.masterTable.getSelectedRow();
        if (row != -1) {
            XLIFF xliff;
            TrackedChange tc = changes.get(row);
            Project p = this.topui.getProjectView().getProject();
            if (p != null && (xliff = p.getXLIFF()) != null) {
                this.accept(tc, xliff);
                int i = p.getCurrenTUIndex();
                if (i != -1) {
                    p.edit("#" + Integer.toString(i));
                    if (changes.size() > 0) {
                        this.selectRow();
                    } else if (this.nextSegmentBox.isSelected()) {
                        xliff.getWorkflow().checkNextTU();
                    }
                }
            }
        }
    }

    private void accept(TrackedChange tc, XLIFF xliff) {
        boolean type = tc.getActionType();
        XMLElement e = tc.getElement();
        XLIFFUnit tu = tc.getTrackedTU();
        XMLElement target = tu.getTarget();
        boolean replaced = this.replaceInElement(e, target, true, type);
        if (xliff.isStudioXLIFF && replaced) {
            xliff.removeTrackedElementInfo(e);
        }
    }

    private void reject(TrackedChange tc, XLIFF xliff) {
        boolean type = tc.getActionType();
        XMLElement e = tc.getElement();
        XLIFFUnit tu = tc.getTrackedTU();
        XMLElement target = tu.getTarget();
        boolean replaced = this.replaceInElement(e, target, false, type);
        if (xliff.isStudioXLIFF && replaced) {
            xliff.removeTrackedElementInfo(e);
        }
    }

    public void rejectAllChanges() {
        int rc;
        XLIFF xliff;
        Project p = this.topui.getProjectView().getProject();
        if (p != null && (xliff = p.getXLIFF()) != null && (rc = changes.size()) > 0) {
            int i;
            for (i = 0; i < rc; ++i) {
                TrackedChange tc = changes.get(i);
                this.reject(tc, xliff);
            }
            i = p.getCurrenTUIndex();
            if (i != -1) {
                p.edit("#" + Integer.toString(i));
                if (this.nextSegmentBox.isSelected()) {
                    xliff.getWorkflow().checkNextTU();
                }
            }
        }
    }

    public void rejectChange() {
        int row = this.masterTable.getSelectedRow();
        if (row != -1) {
            XLIFF xliff;
            TrackedChange tc = changes.get(row);
            Project p = this.topui.getProjectView().getProject();
            if (p != null && (xliff = p.getXLIFF()) != null) {
                this.reject(tc, xliff);
                int i = p.getCurrenTUIndex();
                if (i != -1) {
                    p.edit("#" + Integer.toString(i));
                    if (changes.size() > 0) {
                        this.selectRow();
                    } else if (this.nextSegmentBox.isSelected()) {
                        xliff.getWorkflow().checkNextTU();
                    }
                }
            }
        }
    }

    private boolean replaceInElement(XMLElement trackedElement, XMLElement targetElement, boolean accept, boolean type) {
        List econtents = trackedElement.getChildren();
        List list = targetElement.getChildren();
        int index = -1;
        for (int i = 0; i < list.size(); ++i) {
            Object get = list.get(i);
            if (!(get instanceof XMLElement)) continue;
            XMLElement xml = (XMLElement)get;
            if (trackedElement.equals(xml)) {
                index = i;
                break;
            }
            boolean rep = this.replaceInElement(trackedElement, xml, accept, type);
            if (!rep) continue;
            return true;
        }
        if (index != -1) {
            list.remove(index);
            if (accept && type) {
                list.addAll(index, econtents);
            } else if (!accept && !type) {
                list.addAll(index, econtents);
            }
            return true;
        }
        return false;
    }

    public void manageTUChanges(XLIFF xliff, XMLElement parent, boolean accept) {
        List childern = parent.getChildren();
        ArrayList<TrackedChange> changes = new ArrayList<TrackedChange>();
        for (int k = 0; k < childern.size(); ++k) {
            String a;
            Object get = childern.get(k);
            if (!(get instanceof XMLElement)) continue;
            boolean added = false;
            boolean deleted = false;
            XMLElement e = (XMLElement)get;
            String name = e.getName();
            if (name.equals("mrk") && (a = e.getAttribute("mtype")) != null) {
                TrackedChange tc;
                if (a.endsWith("-added")) {
                    added = true;
                    tc = new TrackedChange();
                    tc.setActionType(true);
                    tc.setElement(e);
                    changes.add(tc);
                } else if (a.endsWith("-deleted")) {
                    deleted = true;
                    tc = new TrackedChange();
                    tc.setActionType(false);
                    tc.setElement(e);
                    changes.add(tc);
                }
            }
            if (added || deleted) continue;
            this.manageTUChanges(xliff, e, accept);
        }
        if (changes.size() > 0) {
            for (TrackedChange tc : changes) {
                XMLElement trackedElement = tc.getElement();
                boolean actionType = tc.getActionType();
                boolean replaced = this.replaceInElement(trackedElement, parent, accept, actionType);
                if (!xliff.isStudioXLIFF || !replaced) continue;
                xliff.removeTrackedElementInfo(trackedElement);
            }
        }
    }

    @Override
    public void closeResource() {
        AppPreferences.automaticMatching = true;
        this.clear();
        this.topui.getTargetView().setTargetProtection(false);
        TabView tview = this.topui.getTabView();
        tview.removeTab(this.name);
        this.topui.closeTrackingChanges();
    }

    private static class MyTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(String.valueOf(value));
            table.setRowHeight(row, this.getPreferredSize().height);
            return this;
        }
    }
}

